/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyCanonicalPathProvider;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifiedNameFinder {
    @Nullable
    public static String findShortestImportableName(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        QualifiedName qName;
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(0);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(1);
        }
        return (qName = QualifiedNameFinder.findShortestImportableQName(foothold, vfile)) == null ? null : qName.toString();
    }

    @Nullable
    public static QualifiedName findShortestImportableQName(@Nullable PsiFileSystemItem fsItem) {
        VirtualFile vFile = fsItem != null ? fsItem.getVirtualFile() : null;
        return vFile != null ? QualifiedNameFinder.findShortestImportableQName((PsiElement)fsItem, vFile) : null;
    }

    @Nullable
    public static QualifiedName findShortestImportableQName(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(2);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(3);
        }
        return QualifiedNameFinder.shortestQName(QualifiedNameFinder.findImportableQNames(foothold, vfile));
    }

    @NotNull
    public static List<QualifiedName> findImportableQNames(@NotNull PsiElement foothold, @NotNull VirtualFile vfile) {
        PythonPathCache cache;
        List<QualifiedName> names;
        if (foothold == null) {
            QualifiedNameFinder.$$$reportNull$$$0(4);
        }
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(5);
        }
        List<QualifiedName> list2 = names = (cache = ResolveImportUtil.getPathCache(foothold)) != null ? cache.getNames(vfile) : null;
        if (names != null) {
            List<QualifiedName> list3 = names;
            if (list3 == null) {
                QualifiedNameFinder.$$$reportNull$$$0(6);
            }
            return list3;
        }
        PathChoosingVisitor visitor2 = new PathChoosingVisitor(vfile);
        RootVisitorHost.visitRoots(foothold, visitor2);
        List<QualifiedName> results = visitor2.getResults();
        if (cache != null) {
            cache.putNames(vfile, results);
        }
        List<QualifiedName> list4 = results;
        if (list4 == null) {
            QualifiedNameFinder.$$$reportNull$$$0(7);
        }
        return list4;
    }

    @Nullable
    private static QualifiedName shortestQName(@NotNull List<QualifiedName> qNames) {
        if (qNames == null) {
            QualifiedNameFinder.$$$reportNull$$$0(8);
        }
        return qNames.stream().min((o1, o2) -> o1.getComponentCount() - o2.getComponentCount()).orElse(null);
    }

    @Nullable
    public static String findShortestImportableName(Module module2, @NotNull VirtualFile vfile) {
        PythonPathCache cache;
        List<QualifiedName> names;
        if (vfile == null) {
            QualifiedNameFinder.$$$reportNull$$$0(9);
        }
        if ((names = (cache = PythonModulePathCache.getInstance(module2)).getNames(vfile)) == null) {
            PathChoosingVisitor visitor2 = new PathChoosingVisitor(vfile);
            RootVisitorHost.visitRoots(module2, false, visitor2);
            names = visitor2.getResults();
            cache.putNames(vfile, names);
        }
        return Objects.toString(QualifiedNameFinder.shortestQName(names), null);
    }

    @Nullable
    public static QualifiedName findCanonicalImportPath(@NotNull PsiElement symbol, @Nullable PsiElement foothold) {
        if (symbol == null) {
            QualifiedNameFinder.$$$reportNull$$$0(10);
        }
        return (QualifiedName)PyUtil.getNullableParameterizedCachedValue(symbol, Couple.of((Object)symbol, (Object)foothold), QualifiedNameFinder::doFindCanonicalImportPath);
    }

    @Nullable
    private static QualifiedName doFindCanonicalImportPath(@NotNull Couple<PsiElement> param) {
        QualifiedName restored;
        QualifiedName qname;
        if (param == null) {
            QualifiedNameFinder.$$$reportNull$$$0(11);
        }
        PsiElement symbol = (PsiElement)param.getFirst();
        PsiElement foothold = (PsiElement)param.getSecond();
        PsiFileSystemItem srcfile = PyPsiUtils.getFileSystemItem(symbol);
        if (srcfile == null) {
            return null;
        }
        VirtualFile virtualFile = srcfile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (srcfile instanceof PsiFile && symbol instanceof PsiNamedElement && !(symbol instanceof PsiFileSystemItem)) {
            PsiFile initPy;
            PyClass containingClass;
            Object toplevel = symbol;
            if (symbol instanceof PyFunction && (containingClass = ((PyFunction)symbol).getContainingClass()) != null) {
                toplevel = containingClass;
            }
            for (PsiDirectory dir = ((PsiFile)srcfile).getContainingDirectory(); dir != null && (initPy = dir.findFile("__init__.py")) != null; dir = dir.getParentDirectory()) {
                if (!(initPy instanceof PyFile)) continue;
                List<RatedResolveResult> resolved = ((PyFile)initPy).multiResolveName(((PsiNamedElement)toplevel).getName());
                Object finalTopLevel = toplevel;
                if (!resolved.stream().anyMatch(arg_0 -> QualifiedNameFinder.lambda$doFindCanonicalImportPath$1((PsiElement)finalTopLevel, arg_0))) continue;
                virtualFile = dir.getVirtualFile();
            }
        }
        if ((qname = QualifiedNameFinder.findShortestImportableQName(foothold != null ? foothold : symbol, virtualFile)) != null && (restored = QualifiedNameFinder.canonizeQualifiedName(qname, foothold)) != null) {
            return restored;
        }
        return qname;
    }

    @Nullable
    public static QualifiedName canonizeQualifiedName(QualifiedName qname, PsiElement foothold) {
        for (PyCanonicalPathProvider provider : (PyCanonicalPathProvider[])Extensions.getExtensions(PyCanonicalPathProvider.EP_NAME)) {
            QualifiedName restored = provider.getCanonicalPath(qname, foothold);
            if (restored == null) continue;
            return restored;
        }
        return null;
    }

    @Nullable
    public static String getQualifiedName(@NotNull PyElement element) {
        if (element == null) {
            QualifiedNameFinder.$$$reportNull$$$0(12);
        }
        return (String)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            if (element == null) {
                QualifiedNameFinder.$$$reportNull$$$0(14);
            }
            return new CachedValueProvider.Result((Object)QualifiedNameFinder.getQualifiedNameInner(element), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static String getQualifiedNameInner(@NotNull PyElement element) {
        String name;
        if (element == null) {
            QualifiedNameFinder.$$$reportNull$$$0(13);
        }
        if ((name = element.getName()) != null) {
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)element);
            if (owner instanceof PyClass) {
                String classQName = ((PyClass)owner).getQualifiedName();
                if (classQName != null) {
                    return classQName + "." + name;
                }
            } else if (owner instanceof PyFile) {
                String fileQName;
                if (builtinCache.isBuiltin((PsiElement)element)) {
                    return name;
                }
                VirtualFile virtualFile = ((PyFile)owner).getVirtualFile();
                if (virtualFile != null && (fileQName = QualifiedNameFinder.findShortestImportableName((PsiElement)element, virtualFile)) != null) {
                    return fileQName + "." + name;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$doFindCanonicalImportPath$1(PsiElement finalTopLevel, RatedResolveResult r) {
        return r.getElement() == finalTopLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportableQNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findShortestImportableName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findShortestImportableQName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findImportableQNames";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shortestQName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findCanonicalImportPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doFindCanonicalImportPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameInner";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQualifiedName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PathChoosingVisitor
    implements RootVisitor {
        @Nullable
        private final VirtualFile myVFile;
        @NotNull
        private final List<QualifiedName> myResults;

        private PathChoosingVisitor(@NotNull VirtualFile file2) {
            if (file2 == null) {
                PathChoosingVisitor.$$$reportNull$$$0(0);
            }
            this.myResults = new ArrayList<QualifiedName>();
            this.myVFile = !file2.isDirectory() && file2.getName().equals("__init__.py") ? file2.getParent() : file2;
        }

        @Override
        public boolean visitRoot(VirtualFile root, Module module2, Sdk sdk, boolean isModuleSource) {
            String relativePath;
            if (this.myVFile != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.myVFile, (VirtualFile)root, (char)'/')) != null && !relativePath.isEmpty()) {
                List result2 = StringUtil.split((String)relativePath, (String)"/");
                if (result2.size() > 0) {
                    result2.set(result2.size() - 1, FileUtil.getNameWithoutExtension((String)((String)result2.get(result2.size() - 1))));
                }
                for (String component : result2) {
                    if (PyNames.isIdentifier(component)) continue;
                    return true;
                }
                this.myResults.add(QualifiedName.fromComponents((Collection)result2));
            }
            return true;
        }

        @NotNull
        public List<QualifiedName> getResults() {
            List<QualifiedName> list2 = this.myResults;
            if (list2 == null) {
                PathChoosingVisitor.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder$PathChoosingVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/resolve/QualifiedNameFinder$PathChoosingVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

