/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyFunctionBuilder {
    private final String myName;
    private final List<String> myParameters;
    private final List<String> myStatements;
    private final List<String> myDecorators;
    private String myAnnotation;
    @NotNull
    private final Map<String, String> myDecoratorValues;
    private boolean myAsync;
    private PyDocstringGenerator myDocStringGenerator;

    @NotNull
    public static PyFunctionBuilder copySignature(@NotNull PyFunction source, String ... decoratorsToCopyIfExist) {
        String name;
        if (source == null) {
            PyFunctionBuilder.$$$reportNull$$$0(0);
        }
        if (decoratorsToCopyIfExist == null) {
            PyFunctionBuilder.$$$reportNull$$$0(1);
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder((name = source.getName()) != null ? name : "", source);
        for (PyParameter parameter : source.getParameterList().getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName == null) continue;
            functionBuilder.parameter(parameterName);
        }
        PyDecoratorList decoratorList = source.getDecoratorList();
        if (decoratorList != null) {
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                String decoratorName = decorator.getName();
                if (decoratorName == null || !ArrayUtil.contains((String)decoratorName, (String[])decoratorsToCopyIfExist)) continue;
                functionBuilder.decorate(decoratorName);
            }
        }
        functionBuilder.myDocStringGenerator = PyDocstringGenerator.forDocStringOwner(source);
        PyFunctionBuilder pyFunctionBuilder = functionBuilder;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(2);
        }
        return pyFunctionBuilder;
    }

    @Deprecated
    public PyFunctionBuilder(@NotNull String name) {
        if (name == null) {
            PyFunctionBuilder.$$$reportNull$$$0(3);
        }
        this.myParameters = new ArrayList<String>();
        this.myStatements = new ArrayList<String>();
        this.myDecorators = new ArrayList<String>();
        this.myAnnotation = null;
        this.myDecoratorValues = new HashMap<String, String>();
        this.myAsync = false;
        this.myName = name;
        this.myDocStringGenerator = null;
    }

    public PyFunctionBuilder(@NotNull String name, @NotNull PsiElement settingsAnchor) {
        if (name == null) {
            PyFunctionBuilder.$$$reportNull$$$0(4);
        }
        if (settingsAnchor == null) {
            PyFunctionBuilder.$$$reportNull$$$0(5);
        }
        this.myParameters = new ArrayList<String>();
        this.myStatements = new ArrayList<String>();
        this.myDecorators = new ArrayList<String>();
        this.myAnnotation = null;
        this.myDecoratorValues = new HashMap<String, String>();
        this.myAsync = false;
        this.myName = name;
        this.myDocStringGenerator = PyDocstringGenerator.create(DocStringUtil.getConfiguredDocStringFormatOrPlain(settingsAnchor), PyIndentUtil.getIndentFromSettings(settingsAnchor.getProject()), settingsAnchor);
    }

    @NotNull
    public PyFunctionBuilder parameterWithType(@NotNull String name, @NotNull String type) {
        if (name == null) {
            PyFunctionBuilder.$$$reportNull$$$0(6);
        }
        if (type == null) {
            PyFunctionBuilder.$$$reportNull$$$0(7);
        }
        this.parameter(name);
        this.myDocStringGenerator.withParamTypedByName(name, type);
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(8);
        }
        return pyFunctionBuilder;
    }

    @Deprecated
    @NotNull
    public PyFunctionBuilder parameterWithType(@NotNull String name, @NotNull String type, @NotNull DocStringFormat format) {
        if (name == null) {
            PyFunctionBuilder.$$$reportNull$$$0(9);
        }
        if (type == null) {
            PyFunctionBuilder.$$$reportNull$$$0(10);
        }
        if (format == null) {
            PyFunctionBuilder.$$$reportNull$$$0(11);
        }
        this.parameter(name);
        this.myDocStringGenerator.withParamTypedByName(name, type);
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(12);
        }
        return pyFunctionBuilder;
    }

    public PyFunctionBuilder parameter(String baseName) {
        String name = baseName;
        int uniqueIndex = 0;
        while (this.myParameters.contains(name)) {
            name = baseName + ++uniqueIndex;
        }
        this.myParameters.add(name);
        return this;
    }

    public PyFunctionBuilder annotation(String text) {
        this.myAnnotation = text;
        return this;
    }

    public PyFunctionBuilder makeAsync() {
        this.myAsync = true;
        return this;
    }

    public PyFunctionBuilder statement(String text) {
        this.myStatements.add(text);
        return this;
    }

    public PyFunction addFunction(PsiElement target2, LanguageLevel languageLevel) {
        return (PyFunction)target2.add((PsiElement)this.buildFunction(target2.getProject(), languageLevel));
    }

    public PyFunction addFunctionAfter(PsiElement target2, PsiElement anchor, LanguageLevel languageLevel) {
        return (PyFunction)target2.addAfter((PsiElement)this.buildFunction(target2.getProject(), languageLevel), anchor);
    }

    public PyFunction buildFunction(Project project, LanguageLevel languageLevel) {
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        String text = this.buildText(project, generator, languageLevel);
        return generator.createFromText(languageLevel, PyFunction.class, text);
    }

    private String buildText(Project project, PyElementGenerator generator, LanguageLevel languageLevel) {
        StringBuilder builder = new StringBuilder();
        for (String decorator : this.myDecorators) {
            StringBuilder decoratorAppender = builder.append('@' + decorator);
            if (this.myDecoratorValues.containsKey(decorator)) {
                PyCallExpression fakeCall = generator.createCallExpression(languageLevel, "fakeFunction");
                fakeCall.getArgumentList().addArgument(generator.createStringLiteralFromString(this.myDecoratorValues.get(decorator)));
                decoratorAppender.append(fakeCall.getArgumentList().getText());
            }
            decoratorAppender.append("\n");
        }
        if (this.myAsync) {
            builder.append("async ");
        }
        builder.append("def ");
        builder.append(this.myName).append("(");
        builder.append(StringUtil.join(this.myParameters, (String)", "));
        builder.append(")");
        if (this.myAnnotation != null) {
            builder.append(this.myAnnotation);
        }
        builder.append(":");
        List<String> statements = this.myStatements.isEmpty() ? Collections.singletonList("pass") : this.myStatements;
        String indent = PyIndentUtil.getIndentFromSettings(project);
        if (!this.myDocStringGenerator.isNewMode() || this.myDocStringGenerator.hasParametersToAdd()) {
            String docstring = PyIndentUtil.changeIndent(this.myDocStringGenerator.buildDocString(), true, indent);
            builder.append('\n').append(indent).append(docstring);
        }
        for (String statement : statements) {
            builder.append('\n').append(indent).append(statement);
        }
        return builder.toString();
    }

    public void decorate(@NotNull String decoratorName, @NotNull String value) {
        if (decoratorName == null) {
            PyFunctionBuilder.$$$reportNull$$$0(13);
        }
        if (value == null) {
            PyFunctionBuilder.$$$reportNull$$$0(14);
        }
        this.decorate(decoratorName);
        this.myDecoratorValues.put(decoratorName, value);
    }

    public void decorate(String decoratorName) {
        this.myDecorators.add(decoratorName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorsToCopyIfExist";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFunctionBuilder";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFunctionBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copySignature";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parameterWithType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copySignature";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parameterWithType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "decorate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

