/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCondaPackageManagerImpl
extends PyPackageManagerImpl {
    @Nullable
    private volatile List<PyPackage> mySideCache;
    public static final String PYTHON = "python";
    public boolean useConda;

    public boolean useConda() {
        return this.useConda;
    }

    public void useConda(boolean conda) {
        this.useConda = conda;
    }

    PyCondaPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(0);
        }
        super(sdk);
        this.mySideCache = null;
        this.useConda = true;
    }

    @Override
    public void install(@NotNull List<PyRequirement> requirements, @NotNull List<String> extraArgs) throws ExecutionException {
        if (requirements == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(1);
        }
        if (extraArgs == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.useConda) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (PyRequirement requirement : requirements) {
                arguments.add(requirement.toString());
            }
            arguments.add("-y");
            if (extraArgs.contains("-U")) {
                this.getCondaOutput("update", arguments);
            } else {
                arguments.addAll(extraArgs);
                this.getCondaOutput("install", arguments);
            }
        } else {
            super.install(requirements, extraArgs);
        }
    }

    private ProcessOutput getCondaOutput(@NotNull String command, List<String> arguments) throws ExecutionException {
        Sdk sdk;
        String condaExecutable;
        if (command == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(3);
        }
        if ((condaExecutable = PyCondaPackageService.getCondaExecutable((sdk = this.getSdk()).getHomeDirectory())) == null) {
            throw new PyExecutionException("Cannot find conda", "Conda", Collections.emptyList(), new ProcessOutput());
        }
        String path = this.getCondaDirectory();
        if (path == null) {
            throw new PyExecutionException("Empty conda name for " + sdk.getHomePath(), command, arguments);
        }
        ArrayList parameters = Lists.newArrayList((Object[])new String[]{condaExecutable, command, "-p", path});
        parameters.addAll(arguments);
        GeneralCommandLine commandLine = new GeneralCommandLine((List)parameters);
        CapturingProcessHandler handler2 = new CapturingProcessHandler(commandLine);
        ProcessOutput result2 = handler2.runProcess();
        int exitCode = result2.getExitCode();
        if (exitCode != 0) {
            String message = StringUtil.isEmptyOrSpaces((String)result2.getStdout()) && StringUtil.isEmptyOrSpaces((String)result2.getStderr()) ? "Permission denied" : "Non-zero exit code";
            throw new PyExecutionException(message, "Conda", parameters, result2);
        }
        return result2;
    }

    @Nullable
    private String getCondaDirectory() {
        VirtualFile homeDirectory = this.getSdk().getHomeDirectory();
        if (homeDirectory == null) {
            return null;
        }
        if (SystemInfo.isWindows) {
            return homeDirectory.getParent().getPath();
        }
        return homeDirectory.getParent().getParent().getPath();
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.useConda) {
            super.install(requirementString);
        } else {
            this.getCondaOutput("install", Lists.newArrayList((Object[])new String[]{requirementString, "-y"}));
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        if (packages == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.useConda) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (PyPackage aPackage : packages) {
                arguments.add(aPackage.getName());
            }
            arguments.add("-y");
            this.getCondaOutput("remove", arguments);
        } else {
            super.uninstall(packages);
        }
    }

    @Override
    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        List<PyPackage> pipPackages = super.collectPackages();
        ProcessOutput output = this.getCondaOutput("list", Lists.newArrayList((Object[])new String[]{"-e"}));
        Set condaPackages = Sets.newConcurrentHashSet(PyCondaPackageManagerImpl.parseCondaToolOutput(output.getStdout()));
        if (this.useConda) {
            this.mySideCache = pipPackages;
            ArrayList arrayList = Lists.newArrayList((Iterable)condaPackages);
            if (arrayList == null) {
                PyCondaPackageManagerImpl.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        this.mySideCache = Lists.newArrayList((Iterable)condaPackages);
        List<PyPackage> list2 = super.collectPackages();
        if (list2 == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    protected static List<PyPackage> parseCondaToolOutput(@NotNull String s) throws ExecutionException {
        if (s == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(8);
        }
        String[] lines2 = StringUtil.splitByLines((String)s);
        ArrayList<PyPackage> packages = new ArrayList<PyPackage>();
        for (String line : lines2) {
            if (line.startsWith("#")) continue;
            List fields = StringUtil.split((String)line, (String)"=");
            if (fields.size() < 3) {
                throw new PyExecutionException("Invalid conda output format", "conda", Collections.emptyList());
            }
            String name = (String)fields.get(0);
            String version = (String)fields.get(1);
            ArrayList<PyRequirement> requirements = new ArrayList<PyRequirement>();
            if (fields.size() >= 4) {
                String requiresLine = (String)fields.get(3);
                String requiresSpec = StringUtil.join((Collection)StringUtil.split((String)requiresLine, (String)":"), (String)"\n");
                requirements.addAll(PyPackageUtil.fix(PyRequirement.fromText(requiresSpec)));
            }
            if ("Python".equals(name)) continue;
            packages.add(new PyPackage(name, version, "", requirements));
        }
        ArrayList<PyPackage> arrayList = packages;
        if (arrayList == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean isCondaVEnv(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(10);
        }
        String condaName = "conda-meta";
        VirtualFile homeDirectory = sdk.getHomeDirectory();
        if (homeDirectory == null) {
            return false;
        }
        VirtualFile condaParent = SystemInfo.isWindows ? homeDirectory.getParent() : homeDirectory.getParent().getParent();
        VirtualFile condaMeta = condaParent.findChild("conda-meta");
        VirtualFile envs = condaParent.findChild("envs");
        return condaMeta != null && envs == null;
    }

    public static boolean isConda(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(11);
        }
        String condaName = "conda-meta";
        VirtualFile homeDirectory = sdk.getHomeDirectory();
        if (homeDirectory == null) {
            return false;
        }
        VirtualFile condaParent = SystemInfo.isWindows ? homeDirectory.getParent() : homeDirectory.getParent().getParent();
        VirtualFile condaMeta = condaParent.findChild("conda-meta");
        return condaMeta != null;
    }

    @NotNull
    public static String createVirtualEnv(@NotNull String destinationDir, String version) throws ExecutionException {
        ProgressIndicator indicator;
        String condaExecutable;
        if (destinationDir == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(12);
        }
        if ((condaExecutable = PyCondaPackageService.getSystemCondaExecutable()) == null) {
            throw new PyExecutionException("Cannot find conda", "Conda", Collections.emptyList(), new ProcessOutput());
        }
        ArrayList parameters = Lists.newArrayList((Object[])new String[]{condaExecutable, "create", "-p", destinationDir, "-y", "python=" + version});
        GeneralCommandLine commandLine = new GeneralCommandLine((List)parameters);
        CapturingProcessHandler handler2 = new CapturingProcessHandler(commandLine);
        ProcessOutput result2 = handler2.runProcessWithProgressIndicator(indicator = ProgressManager.getInstance().getProgressIndicator());
        if (result2.isCancelled()) {
            throw new RunCanceledByUserException();
        }
        int exitCode = result2.getExitCode();
        if (exitCode != 0) {
            String message = StringUtil.isEmptyOrSpaces((String)result2.getStdout()) && StringUtil.isEmptyOrSpaces((String)result2.getStderr()) ? "Permission denied" : "Non-zero exit code";
            throw new PyExecutionException(message, "Conda", parameters, result2);
        }
        String binary = PythonSdkType.getPythonExecutable(destinationDir);
        String binaryFallback = destinationDir + File.separator + "bin" + File.separator + PYTHON;
        String string = binary != null ? binary : binaryFallback;
        if (string == null) {
            PyCondaPackageManagerImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List<PyPackage> packagesCache = this.mySideCache;
        if (packagesCache == null) {
            return null;
        }
        ArrayList packages = Lists.newArrayList(packagesCache);
        List<PyPackage> condaPackages = super.getPackages();
        if (condaPackages == null) {
            return null;
        }
        packages.addAll(condaPackages);
        return Collections.unmodifiableList(packages);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyCondaPackageManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyCondaPackageManagerImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCondaToolOutput";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCondaOutput";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uninstall";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseCondaToolOutput";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCondaVEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConda";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

