/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerExpressionEditor
extends XDebuggerEditorBase {
    private final JComponent myComponent;
    private final EditorTextField myEditorTextField;
    private XExpression myExpression;

    public XDebuggerExpressionEditor(Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, @NotNull XExpression text, final boolean multiline, boolean editorFont, final boolean showEditor) {
        if (debuggerEditorsProvider == null) {
            XDebuggerExpressionEditor.$$$reportNull$$$0(0);
        }
        if (text == null) {
            XDebuggerExpressionEditor.$$$reportNull$$$0(1);
        }
        super(project, debuggerEditorsProvider, multiline ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION, historyId, sourcePosition);
        this.myExpression = XExpressionImpl.changeMode(text, this.getMode());
        this.myEditorTextField = new EditorTextField(this.createDocument(this.myExpression), project, debuggerEditorsProvider.getFileType(), false, !multiline){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setHorizontalScrollbarVisible(multiline);
                editor.setVerticalScrollbarVisible(multiline);
                editor.getSettings().setUseSoftWraps(XDebuggerExpressionEditor.this.isUseSoftWraps());
                editor.getColorsScheme().setEditorFontName(this.getFont().getFontName());
                editor.getColorsScheme().setEditorFontSize(this.getFont().getSize());
                if (multiline) {
                    editor.getContentComponent().setBorder(new CompoundBorder(editor.getContentComponent().getBorder(), (Border)JBUI.Borders.emptyLeft((int)2)));
                    editor.setContextMenuGroupId("XDebugger.Evaluate.Code.Fragment.Editor.Popup");
                } else {
                    XDebuggerEditorBase.foldNewLines(editor);
                    if (showEditor) {
                        XDebuggerExpressionEditor.this.setExpandable(editor);
                    }
                }
                return editor;
            }

            @Override
            public Object getData(String dataId) {
                if (LangDataKeys.CONTEXT_LANGUAGES.is(dataId)) {
                    return new Language[]{XDebuggerExpressionEditor.this.myExpression.getLanguage()};
                }
                if (CommonDataKeys.PSI_FILE.is(dataId)) {
                    return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.getDocument());
                }
                return super.getData(dataId);
            }
        };
        if (editorFont) {
            this.myEditorTextField.setFontInheritedFromLAF(false);
            this.myEditorTextField.setFont(EditorUtil.getEditorFont());
        }
        if (multiline) {
            ShortcutSet shortcut = ActionManager.getInstance().getAction("NextOccurence").getShortcutSet();
            if (shortcut != null) {
                DumbAwareAction.create(e -> this.goForward()).registerCustomShortcutSet(shortcut, (JComponent)((Object)this.myEditorTextField));
            }
            if ((shortcut = ActionManager.getInstance().getAction("PreviousOccurence").getShortcutSet()) != null) {
                DumbAwareAction.create(e -> this.goBackward()).registerCustomShortcutSet(shortcut, (JComponent)((Object)this.myEditorTextField));
            }
        }
        this.myComponent = this.decorate((JComponent)((Object)this.myEditorTextField), multiline, showEditor);
        this.setExpression(this.myExpression);
    }

    @Override
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myEditorTextField;
    }

    @Override
    protected void doSetText(XExpression text) {
        this.myExpression = text;
        this.myEditorTextField.setNewDocumentAndFileType(this.getFileType(text), this.createDocument(text));
    }

    @Override
    public XExpression getExpression() {
        return this.getEditorsProvider().createExpression(this.getProject(), this.myEditorTextField.getDocument(), this.myExpression.getLanguage(), this.myExpression.getMode());
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Editor editor = this.myEditorTextField.getEditor();
        return editor != null ? editor.getContentComponent() : null;
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable == this.myComponent.isEnabled()) {
            return;
        }
        UIUtil.setEnabled((Component)this.myComponent, (boolean)enable, (boolean)true);
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditorTextField.getEditor();
    }

    @Override
    public void selectAll() {
        this.myEditorTextField.selectAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "debuggerEditorsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/ui/XDebuggerExpressionEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

