/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.wizard;

import com.intellij.ui.wizard.WizardCallback;
import com.intellij.ui.wizard.WizardNavigationState;
import com.intellij.ui.wizard.WizardStep;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class WizardModel {
    private final List<WizardStep> mySteps = new ArrayList<WizardStep>();
    private WizardStep myCurrentStep;
    private WizardNavigationState myCurrentState;
    private JComponent myCurrentComponent;
    private WizardCallback myCallback;
    private boolean myDropped = false;
    private boolean myAchieved = false;
    private final String myTitle;

    public WizardModel(String title) {
        this.myTitle = title;
    }

    public final WizardStep add(WizardStep step) {
        this.mySteps.add(step);
        return step;
    }

    public final WizardStep addBefore(WizardStep beforeWhat, WizardStep toAdd) {
        int i = this.mySteps.indexOf(beforeWhat);
        this.mySteps.add(i, toAdd);
        return toAdd;
    }

    public final WizardStep addAfter(WizardStep afterWhat, WizardStep toAdd) {
        int i = this.mySteps.indexOf(afterWhat);
        this.mySteps.add(i + 1, toAdd);
        return toAdd;
    }

    public final void next() {
        this.checkModel();
        WizardStep nextStep = this.getCurrentStep().onNext(this);
        if (nextStep == WizardStep.FORCED_GOAL_DROPPED) {
            this.cancel();
            return;
        }
        if (nextStep == WizardStep.FORCED_GOAL_ACHIEVED) {
            this.finish();
            return;
        }
        if (nextStep == null) {
            nextStep = this.getNextFor(this.getCurrentStep());
        }
        this.changeToStep(nextStep);
    }

    public final void previous() {
        this.checkModel();
        WizardStep previousStep = this.getCurrentStep().onPrevious(this);
        if (previousStep == null) {
            previousStep = this.getPreviousFor(this.getCurrentStep());
        }
        this.changeToStep(previousStep);
    }

    private void changeToStep(WizardStep step) {
        this.prepareCurrentStep(step);
        this.getCallback().onStepChanged();
    }

    public final void finish() {
        this.checkModel();
        this.setFinishedAs(this.getCurrentStep().onFinish());
        if (this.isWizardGoalAchieved()) {
            this.getCallback().onWizardGoalAchieved();
        } else {
            this.getCallback().onWizardGoalDropped();
        }
    }

    public final void cancel() {
        this.checkModel();
        boolean canCancel = this.getCurrentStep().onCancel();
        if (!canCancel) {
            return;
        }
        this.getCallback().onWizardGoalDropped();
        this.setFinishedAs(false);
    }

    public final WizardStep getCurrentStep() {
        this.checkModel();
        if (this.myCurrentStep == null) {
            this.prepareCurrentStep(this.mySteps.get(0));
        }
        return this.myCurrentStep;
    }

    public final JComponent getCurrentComponent() {
        this.checkModel();
        this.getCurrentStep();
        return this.myCurrentComponent;
    }

    public final WizardNavigationState getCurrentNavigationState() {
        this.checkModel();
        this.getCurrentStep();
        return this.myCurrentState;
    }

    public boolean isFirst(WizardStep step) {
        return this.mySteps.indexOf(step) == 0;
    }

    public boolean isLast(WizardStep step) {
        return this.mySteps.indexOf(step) == this.mySteps.size() - 1;
    }

    public final WizardStep getNextFor(WizardStep wizardStep) {
        return this.mySteps.get(this.mySteps.indexOf(wizardStep) + 1);
    }

    public final WizardStep getPreviousFor(WizardStep wizardStep) {
        return this.mySteps.get(this.mySteps.indexOf(wizardStep) - 1);
    }

    private void checkModel() {
        if (this.mySteps.size() == 0) {
            throw new IllegalStateException("Not steps were added");
        }
    }

    private void prepareCurrentStep(WizardStep currentStep) {
        this.myCurrentStep = currentStep;
        if (this.myCurrentState == null) {
            this.myCurrentState = new WizardNavigationState(this);
        }
        this.myCurrentState.NEXT.setEnabled(!this.isLast(this.myCurrentStep));
        this.myCurrentState.PREVIOUS.setEnabled(!this.isFirst(this.myCurrentStep));
        this.myCurrentState.FINISH.setEnabled(this.isLast(this.myCurrentStep));
        this.myCurrentState.CANCEL.setEnabled(true);
        this.myCurrentComponent = this.myCurrentStep.prepare(this.myCurrentState);
    }

    void setCallback(WizardCallback callback) {
        this.myCallback = callback;
    }

    private WizardCallback getCallback() {
        return this.myCallback != null ? this.myCallback : WizardCallback.EMPTY;
    }

    public final boolean isWizardGoalDropped() {
        return this.myDropped;
    }

    public final boolean isWizardGoalAchieved() {
        return this.myAchieved;
    }

    private void setFinishedAs(boolean goalAchieved) {
        this.myAchieved = goalAchieved;
        this.myDropped = !goalAchieved;
    }

    public boolean isDone() {
        return this.myAchieved || this.myDropped;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public int getStepIndex(WizardStep step) {
        return this.mySteps.indexOf(step);
    }
}

