/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.EditorWindowImpl;
import com.intellij.injected.editor.InjectedCaret;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.injected.editor.VirtualFileWindowImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedPsiCachedValueProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectionBackgroundSuppressor;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedLanguageUtil {
    static final Key<List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>>> HIGHLIGHT_TOKENS = Key.create((String)"HIGHLIGHT_TOKENS");
    public static final Key<IElementType> INJECTED_FRAGMENT_TYPE = Key.create((String)"INJECTED_FRAGMENT_TYPE");
    public static final Key<Boolean> FRANKENSTEIN_INJECTION = InjectedLanguageManager.FRANKENSTEIN_INJECTION;
    private static final InjectedPsiCachedValueProvider INJECTED_PSI_PROVIDER = new InjectedPsiCachedValueProvider();
    private static final Key<ParameterizedCachedValue<MultiHostRegistrarImpl, PsiElement>> INJECTED_PSI = Key.create((String)"INJECTED_PSI");
    private static final Key<ConcurrentList<DocumentWindow>> INJECTED_DOCS_KEY = Key.create((String)"INJECTED_DOCS_KEY");

    public static void forceInjectionOnElement(@NotNull PsiElement host) {
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(0);
        }
        InjectedLanguageUtil.enumerate(host, (injectedPsi, places) -> {});
    }

    @NotNull
    static PsiElement loadTree(@NotNull PsiElement host, @NotNull PsiFile containingFile) {
        PsiElement context;
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(1);
        }
        if (containingFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(2);
        }
        if (containingFile instanceof DummyHolder && (context = containingFile.getContext()) != null) {
            PsiFile topFile = context.getContainingFile();
            topFile.getNode();
            TextRange textRange = host.getTextRange().shiftRight(context.getTextRange().getStartOffset());
            PsiElement inLoadedTree = PsiTreeUtil.findElementOfClassAtRange((PsiFile)topFile, (int)textRange.getStartOffset(), (int)textRange.getEndOffset(), host.getClass());
            if (inLoadedTree != null) {
                host = inLoadedTree;
            }
        }
        PsiElement psiElement = host;
        if (psiElement == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public static List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> getHighlightTokens(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(4);
        }
        return (List)file2.getUserData(HIGHLIGHT_TOKENS);
    }

    public static Place getShreds(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(5);
        }
        FileViewProvider viewProvider = injectedFile.getViewProvider();
        return InjectedLanguageUtil.getShreds(viewProvider);
    }

    public static Place getShreds(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(6);
        }
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            return null;
        }
        InjectedFileViewProvider myFileViewProvider = (InjectedFileViewProvider)viewProvider;
        return InjectedLanguageUtil.getShreds(myFileViewProvider.getDocument());
    }

    @NotNull
    public static Place getShreds(@NotNull DocumentWindow document) {
        if (document == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(7);
        }
        Place place = ((DocumentWindowImpl)document).getShreds();
        if (place == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(8);
        }
        return place;
    }

    public static void enumerate(@NotNull DocumentWindow documentWindow, @NotNull PsiFile hostPsiFile, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        PsiElement element;
        Segment[] ranges;
        if (documentWindow == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(9);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(10);
        }
        if (visitor2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(11);
        }
        Segment rangeMarker = (ranges = documentWindow.getHostRanges()).length > 0 ? ranges[0] : null;
        PsiElement psiElement = element = rangeMarker == null ? null : hostPsiFile.findElementAt(rangeMarker.getStartOffset());
        if (element != null) {
            InjectedLanguageUtil.enumerate(element, hostPsiFile, true, visitor2);
        }
    }

    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(12);
        }
        if (visitor2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(13);
        }
        PsiFile containingFile = host.getContainingFile();
        PsiUtilCore.ensureValid((PsiElement)containingFile);
        return InjectedLanguageUtil.enumerate(host, containingFile, true, visitor2);
    }

    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor2) {
        MultiHostRegistrarImpl registrar;
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(14);
        }
        if (containingFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(15);
        }
        if (visitor2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(16);
        }
        if (!containingFile.isPhysical() && containingFile.getOriginalFile() == containingFile) {
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            if (context == null) {
                return false;
            }
            PsiFile file2 = context.getContainingFile();
            if (file2 == null || !file2.isPhysical() && file2.getOriginalFile() == file2) {
                return false;
            }
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return false;
        }
        PsiElement inTree = InjectedLanguageUtil.loadTree(host, containingFile);
        if (inTree != host) {
            host = inTree;
            containingFile = host.getContainingFile();
        }
        if ((registrar = InjectedLanguageUtil.probeElementsUp(host, containingFile, probeUp)) == null) {
            return true;
        }
        List<Pair<Place, PsiFile>> places = registrar.getResult();
        for (Pair<Place, PsiFile> pair : places) {
            if (visitor2 instanceof InjectedReferenceVisitor) {
                if (registrar.getReferenceInjector() == null) continue;
                ((InjectedReferenceVisitor)visitor2).visitInjectedReference(registrar.getReferenceInjector(), (List)pair.first);
                continue;
            }
            if (pair.second == null) continue;
            visitor2.visit((PsiFile)pair.second, (List)pair.first);
        }
        return true;
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file2) {
        if (editor == null || file2 == null || editor instanceof EditorWindow) {
            return editor;
        }
        int offset = editor.getCaretModel().getOffset();
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2, offset);
    }

    public static boolean mightHaveInjectedFragmentAtCaret(@NotNull Project project, @NotNull Document hostDocument, int hostOffset) {
        PsiFile hostPsiFile;
        if (project == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(17);
        }
        if (hostDocument == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(18);
        }
        if ((hostPsiFile = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(hostDocument)) == null || !hostPsiFile.isValid()) {
            return false;
        }
        ConcurrentList<DocumentWindow> documents = InjectedLanguageUtil.getCachedInjectedDocuments(hostPsiFile);
        for (DocumentWindow document : documents) {
            if (!document.isValid() || document.getHostRange(hostOffset) == null) continue;
            return true;
        }
        return false;
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable Caret caret, @Nullable PsiFile file2) {
        if (editor == null || file2 == null || editor instanceof EditorWindow || caret == null) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, caret, injectedFile);
    }

    public static Caret getCaretForInjectedLanguageNoCommit(@Nullable Caret caret, @Nullable PsiFile file2) {
        if (caret == null || file2 == null || caret instanceof InjectedCaret) {
            return caret;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, caret.getOffset());
        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(caret.getEditor(), injectedFile);
        if (!(injectedEditor instanceof EditorWindow)) {
            return caret;
        }
        for (Caret injectedCaret : injectedEditor.getCaretModel().getAllCarets()) {
            if (((InjectedCaret)injectedCaret).getDelegate() != caret) continue;
            return injectedCaret;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiFileBase> T findInjectedFile(@NotNull PsiElement expression, @NotNull Class<T> classToFind) {
        List files;
        if (expression == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(19);
        }
        if (classToFind == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(20);
        }
        if ((files = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles(expression)) == null) {
            return null;
        }
        for (Pair fileInfo : files) {
            PsiElement injectedFile = (PsiElement)fileInfo.first;
            if (!classToFind.isAssignableFrom(injectedFile.getClass())) continue;
            return (T)((PsiFileBase)injectedFile);
        }
        return null;
    }

    public static Editor getEditorForInjectedLanguageNoCommit(@Nullable Editor editor, @Nullable PsiFile file2, int offset) {
        if (editor == null || file2 == null || editor instanceof EditorWindow) {
            return editor;
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
        return InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @Nullable PsiFile injectedFile) {
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(21);
        }
        Editor editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, hostEditor.getCaretModel().getCurrentCaret(), injectedFile);
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(22);
        }
        return editor;
    }

    @NotNull
    public static Editor getInjectedEditorForInjectedFile(@NotNull Editor hostEditor, @NotNull Caret hostCaret, @Nullable PsiFile injectedFile) {
        int selend;
        int selstart;
        Document document;
        if (hostEditor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(23);
        }
        if (hostCaret == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(24);
        }
        if (injectedFile == null || hostEditor instanceof EditorWindow || hostEditor.isDisposed()) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(25);
            }
            return editor;
        }
        Project project = hostEditor.getProject();
        if (project == null) {
            project = injectedFile.getProject();
        }
        if (!((document = PsiDocumentManager.getInstance((Project)project).getDocument(injectedFile)) instanceof DocumentWindowImpl)) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(26);
            }
            return editor;
        }
        DocumentWindowImpl documentWindow = (DocumentWindowImpl)document;
        if (hostCaret.hasSelection() && (selstart = hostCaret.getSelectionStart()) != -1 && !documentWindow.containsRange(selstart, selend = Math.max(selstart, hostCaret.getSelectionEnd()))) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(27);
            }
            return editor;
        }
        if (!documentWindow.isValid()) {
            Editor editor = hostEditor;
            if (editor == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(28);
            }
            return editor;
        }
        Editor editor = EditorWindowImpl.create(documentWindow, (EditorImpl)hostEditor, injectedFile);
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(29);
        }
        return editor;
    }

    @Nullable
    public static PsiFile findInjectedPsiNoCommit(@NotNull PsiFile host, int offset) {
        PsiElement injected;
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(30);
        }
        return (injected = InjectedLanguageUtil.findInjectedElementNoCommit(host, offset)) == null ? null : injected.getContainingFile();
    }

    public static PsiElement findElementAtNoCommit(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(31);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        Trinity<PsiElement, PsiElement, Language> result2 = null;
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            result2 = InjectedLanguageUtil.tryOffset(file2, offset, documentManager);
            PsiElement injected = (PsiElement)result2.first;
            if (injected != null) {
                return injected;
            }
        }
        Language baseLanguage = viewProvider.getBaseLanguage();
        if (result2 != null && baseLanguage == result2.third) {
            return (PsiElement)result2.second;
        }
        return viewProvider.findElementAt(offset, baseLanguage);
    }

    private static MultiHostRegistrarImpl probeElementsUp(@NotNull PsiElement element, @NotNull PsiFile hostPsiFile, boolean probeUp) {
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(32);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(33);
        }
        PsiManager psiManager = hostPsiFile.getManager();
        Project project = psiManager.getProject();
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(project);
        MultiHostRegistrarImpl registrar = null;
        PsiElement current = element;
        block0: while (current != null && current != hostPsiFile && !(current instanceof PsiDirectory)) {
            ProgressManager.checkCanceled();
            if ("EL".equals(current.getLanguage().getID())) break;
            ParameterizedCachedValue data = (ParameterizedCachedValue)current.getUserData(INJECTED_PSI);
            if (data == null || (registrar = (MultiHostRegistrarImpl)data.getValue((Object)current)) == null || !registrar.isValid()) {
                registrar = InjectedPsiCachedValueProvider.doCompute(current, injectedManager, project, hostPsiFile);
            }
            current = current.getParent();
            if (registrar != null) {
                List<Pair<Place, PsiFile>> places = registrar.getResult();
                TextRange elementRange = element.getTextRange();
                for (Pair<Place, PsiFile> pair : places) {
                    Place place = (Place)((Object)pair.first);
                    if (!place.isValid()) continue;
                    Iterator iterator = place.iterator();
                    while (iterator.hasNext()) {
                        PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                        PsiLanguageInjectionHost hostElement = shred.getHost();
                        if (hostElement == null || !hostElement.getTextRange().intersects(elementRange)) continue;
                        break block0;
                    }
                }
            }
            if (probeUp) continue;
            break;
        }
        if (probeUp) {
            for (PsiElement e = element; e != current && e != null && e != hostPsiFile; e = e.getParent()) {
                ProgressManager.checkCanceled();
                if (registrar == null) {
                    e.putUserData(INJECTED_PSI, null);
                    continue;
                }
                ParameterizedCachedValue cachedValue = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue((ParameterizedCachedValueProvider)INJECTED_PSI_PROVIDER, false);
                CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)registrar, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, registrar});
                ((PsiParameterizedCachedValue)cachedValue).setValue(result2);
                e.putUserData(INJECTED_PSI, (Object)cachedValue);
            }
        }
        return registrar;
    }

    public static PsiElement findInjectedElementNoCommit(@NotNull PsiFile hostFile, int offset) {
        if (hostFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(34);
        }
        if (hostFile instanceof PsiCompiledElement) {
            return null;
        }
        Project project = hostFile.getProject();
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(hostFile)) {
            return null;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Trinity<PsiElement, PsiElement, Language> result2 = InjectedLanguageUtil.tryOffset(hostFile, offset, documentManager);
        return (PsiElement)result2.first;
    }

    @NotNull
    private static Trinity<PsiElement, PsiElement, Language> tryOffset(@NotNull PsiFile hostFile, int offset, @NotNull PsiDocumentManager documentManager) {
        if (hostFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(35);
        }
        if (documentManager == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(36);
        }
        FileViewProvider provider = hostFile.getViewProvider();
        Language leafLanguage = null;
        PsiElement leafElement = null;
        for (Language language : provider.getLanguages()) {
            PsiElement injected;
            PsiElement leftElement;
            PsiElement element = provider.findElementAt(offset, language);
            if (element != null) {
                PsiElement injected2;
                if (leafLanguage == null) {
                    leafLanguage = language;
                    leafElement = element;
                }
                if ((injected2 = InjectedLanguageUtil.findInside(element, hostFile, offset, documentManager)) != null) {
                    Trinity trinity = Trinity.create((Object)injected2, (Object)element, (Object)language);
                    if (trinity == null) {
                        InjectedLanguageUtil.$$$reportNull$$$0(37);
                    }
                    return trinity;
                }
            }
            if (offset == 0 || element != null && element.getTextRange().getStartOffset() != offset || (leftElement = provider.findElementAt(offset - 1, language)) == null || leftElement.getTextRange().getEndOffset() != offset || (injected = InjectedLanguageUtil.findInside(leftElement, hostFile, offset, documentManager)) == null) continue;
            Trinity trinity = Trinity.create((Object)injected, (Object)element, (Object)language);
            if (trinity == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(38);
            }
            return trinity;
        }
        Trinity trinity = Trinity.create(null, leafElement, leafLanguage);
        if (trinity == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(39);
        }
        return trinity;
    }

    private static PsiElement findInside(@NotNull PsiElement element, @NotNull PsiFile hostFile, int hostOffset, @NotNull PsiDocumentManager documentManager) {
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(40);
        }
        if (hostFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(41);
        }
        if (documentManager == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(42);
        }
        Ref out = new Ref();
        InjectedLanguageUtil.enumerate(element, hostFile, true, (injectedPsi, places) -> {
            if (documentManager == null) {
                InjectedLanguageUtil.$$$reportNull$$$0(59);
            }
            for (PsiLanguageInjectionHost.Shred place : places) {
                TextRange hostRange = place.getHost().getTextRange();
                if (!hostRange.cutOut(place.getRangeInsideHost()).grown(1).contains(hostOffset)) continue;
                DocumentWindowImpl document = (DocumentWindowImpl)documentManager.getCachedDocument(injectedPsi);
                if (document == null) {
                    return;
                }
                int injectedOffset = document.hostToInjected(hostOffset);
                PsiElement injElement = injectedPsi.findElementAt(injectedOffset);
                out.set(injElement == null ? injectedPsi : injElement);
            }
        });
        return (PsiElement)out.get();
    }

    @NotNull
    public static ConcurrentList<DocumentWindow> getCachedInjectedDocuments(@NotNull PsiFile hostPsiFile) {
        ConcurrentList injected;
        if (hostPsiFile == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(43);
        }
        if ((injected = (ConcurrentList)hostPsiFile.getUserData(INJECTED_DOCS_KEY)) == null) {
            injected = (ConcurrentList)((UserDataHolderEx)hostPsiFile).putUserDataIfAbsent(INJECTED_DOCS_KEY, (Object)ContainerUtil.createConcurrentList());
        }
        ConcurrentList concurrentList = injected;
        if (concurrentList == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(44);
        }
        return concurrentList;
    }

    static void clearCachedInjectedFragmentsForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(45);
        }
        file2.putUserData(INJECTED_DOCS_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches(@NotNull PsiFile injected, @NotNull DocumentWindowImpl documentWindow) {
        if (injected == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(46);
        }
        if (documentWindow == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(47);
        }
        VirtualFileWindowImpl virtualFile = (VirtualFileWindowImpl)injected.getVirtualFile();
        PsiManagerEx psiManagerEx = (PsiManagerEx)injected.getManager();
        if (psiManagerEx.getProject().isDisposed()) {
            return;
        }
        DebugUtil.startPsiModification("injected clearCaches");
        try {
            psiManagerEx.getFileManager().setViewProvider((VirtualFile)virtualFile, null);
        }
        finally {
            DebugUtil.finishPsiModification();
        }
        VirtualFile delegate = virtualFile.getDelegate();
        if (!delegate.isValid()) {
            return;
        }
        FileViewProvider viewProvider = psiManagerEx.getFileManager().findCachedViewProvider(delegate);
        if (viewProvider == null) {
            return;
        }
        for (PsiFile hostFile : ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles()) {
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                ConcurrentList<DocumentWindow> cachedInjectedDocuments = InjectedLanguageUtil.getCachedInjectedDocuments(hostFile);
                for (int i = cachedInjectedDocuments.size() - 1; i >= 0; --i) {
                    DocumentWindow cachedInjectedDocument = (DocumentWindow)cachedInjectedDocuments.get(i);
                    if (cachedInjectedDocument != documentWindow) continue;
                    cachedInjectedDocuments.remove(i);
                }
            }
        }
    }

    public static Editor openEditorFor(@NotNull PsiFile file2, @NotNull Project project) {
        Editor editor;
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(48);
        }
        if (project == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(49);
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
        }
        if ((editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, -1), false)) == null || editor instanceof EditorWindow || editor.isDisposed()) {
            return editor;
        }
        if (document instanceof DocumentWindowImpl) {
            return EditorWindowImpl.create((DocumentWindowImpl)document, (EditorImpl)editor, file2);
        }
        return editor;
    }

    public static PsiFile getTopLevelFile(@NotNull PsiElement element) {
        PsiLanguageInjectionHost host;
        PsiFile containingFile;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(50);
        }
        if ((containingFile = element.getContainingFile()) == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getCachedDocument(containingFile);
        if (document instanceof DocumentWindow && (host = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile)) != null) {
            containingFile = host.getContainingFile();
        }
        return containingFile;
    }

    @NotNull
    public static Editor getTopLevelEditor(@NotNull Editor editor) {
        if (editor == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(51);
        }
        Editor editor2 = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        if (editor2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(52);
        }
        return editor2;
    }

    public static boolean isInInjectedLanguagePrefixSuffix(@NotNull PsiElement element) {
        PsiFile injectedFile;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(53);
        }
        if ((injectedFile = element.getContainingFile()) == null) {
            return false;
        }
        Project project = injectedFile.getProject();
        InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)project);
        if (!languageManager.isInjectedFragment(injectedFile)) {
            return false;
        }
        TextRange elementRange = element.getTextRange();
        List editables = languageManager.intersectWithAllEditableFragments(injectedFile, elementRange);
        int combinedEditablesLength = editables.stream().mapToInt(TextRange::getLength).sum();
        return combinedEditablesLength != elementRange.getLength();
    }

    public static boolean hasInjections(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(54);
        }
        if (!host.isPhysical()) {
            return false;
        }
        Ref result2 = Ref.create((Object)false);
        InjectedLanguageUtil.enumerate((PsiElement)host, (injectedPsi, places) -> result2.set((Object)true));
        return (Boolean)result2.get();
    }

    public static String getUnescapedText(@NotNull PsiFile file2, final @Nullable PsiElement startElement, final @Nullable PsiElement endElement) {
        InjectedLanguageManager manager;
        if (file2 == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(55);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)file2.getProject())).getInjectionHost((PsiElement)file2) == null) {
            return file2.getText().substring(startElement == null ? 0 : startElement.getTextRange().getStartOffset(), endElement == null ? file2.getTextLength() : endElement.getTextRange().getStartOffset());
        }
        final StringBuilder sb = new StringBuilder();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            Boolean myState;
            {
                this.myState = startElement == null ? Boolean.TRUE : null;
            }

            public void visitElement(PsiElement element) {
                if (element == startElement) {
                    this.myState = Boolean.TRUE;
                }
                if (element == endElement) {
                    this.myState = Boolean.FALSE;
                }
                if (Boolean.FALSE == this.myState) {
                    return;
                }
                if (Boolean.TRUE == this.myState && element.getFirstChild() == null) {
                    sb.append(InjectedLanguageUtil.getUnescapedLeafText(element, false));
                } else {
                    super.visitElement(element);
                }
            }
        });
        return sb.toString();
    }

    @Nullable
    public static String getUnescapedLeafText(PsiElement element, boolean strict) {
        String unescaped = (String)element.getCopyableUserData(LeafPatcher.UNESCAPED_TEXT);
        if (unescaped != null) {
            return unescaped;
        }
        if (!strict && element.getFirstChild() == null) {
            return element.getText();
        }
        return null;
    }

    @Nullable
    public static DocumentWindow getDocumentWindow(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(56);
        }
        if ((file2 = element.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            return ((VirtualFileWindow)virtualFile).getDocumentWindow();
        }
        return null;
    }

    public static boolean isInjectableLanguage(Language language) {
        return LanguageUtil.isInjectableLanguage((Language)language);
    }

    public static boolean isHighlightInjectionBackground(@Nullable PsiLanguageInjectionHost host) {
        return !(host instanceof InjectionBackgroundSuppressor);
    }

    public static int getInjectedStart(@NotNull List<PsiLanguageInjectionHost.Shred> places) {
        if (places == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(57);
        }
        PsiLanguageInjectionHost.Shred shred = places.get(0);
        PsiLanguageInjectionHost host = shred.getHost();
        assert (host != null);
        return shred.getRangeInsideHost().getStartOffset() + host.getTextRange().getStartOffset();
    }

    @Nullable
    public static PsiElement findElementInInjected(@NotNull PsiLanguageInjectionHost injectionHost, int offset) {
        if (injectionHost == null) {
            InjectedLanguageUtil.$$$reportNull$$$0(58);
        }
        Ref ref = Ref.create();
        InjectedLanguageUtil.enumerate((PsiElement)injectionHost, (injectedPsi, places) -> ref.set((Object)injectedPsi.findElementAt(offset - InjectedLanguageUtil.getInjectedStart(places))));
        return (PsiElement)ref.get();
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable PsiElement psi) {
        if (psi == null) {
            return null;
        }
        PsiFile containingFile = psi.getContainingFile().getOriginalFile();
        PsiElement fileContext = containingFile.getContext();
        if (fileContext instanceof PsiLanguageInjectionHost) {
            return (PsiLanguageInjectionHost)fileContext;
        }
        Place shreds = InjectedLanguageUtil.getShreds(containingFile.getViewProvider());
        if (shreds == null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
            if (virtualFile instanceof LightVirtualFile) {
                virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
            }
            if (virtualFile instanceof VirtualFileWindow) {
                shreds = InjectedLanguageUtil.getShreds(((VirtualFileWindow)virtualFile).getDocumentWindow());
            }
        }
        return shreds != null ? (PsiLanguageInjectionHost)shreds.getHostPointer().getElement() : null;
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable VirtualFile virtualFile) {
        return virtualFile instanceof VirtualFileWindow ? (PsiLanguageInjectionHost)InjectedLanguageUtil.getShreds(((VirtualFileWindow)virtualFile).getDocumentWindow()).getHostPointer().getElement() : null;
    }

    public static <T> void putInjectedFileUserData(MultiHostRegistrar registrar, Key<T> key, T value) {
        PsiFile psiFile = InjectedLanguageUtil.getInjectedFile(registrar);
        if (psiFile != null) {
            psiFile.putUserData(key, value);
        }
    }

    public static PsiFile getInjectedFile(MultiHostRegistrar registrar) {
        List<Pair<Place, PsiFile>> result2 = ((MultiHostRegistrarImpl)registrar).getResult();
        return result2 == null || result2.isEmpty() ? null : (PsiFile)result2.get((int)(result2.size() - 1)).second;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 4: 
            case 31: 
            case 45: 
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 10: 
            case 33: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 17: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToFind";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostCaret";
                break;
            }
            case 32: 
            case 40: 
            case 50: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 36: 
            case 42: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injected";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShreds";
                break;
            }
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "tryOffset";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInjectedDocuments";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forceInjectionOnElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadTree";
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 52: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTokens";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getShreds";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mightHaveInjectedFragmentAtCaret";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedFile";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedEditorForInjectedFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedPsiNoCommit";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtNoCommit";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "probeElementsUp";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedElementNoCommit";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "tryOffset";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findInside";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedDocuments";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "clearCachedInjectedFragmentsForFile";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "clearCaches";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "openEditorFor";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelEditor";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isInInjectedLanguagePrefixSuffix";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "hasInjections";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getUnescapedText";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentWindow";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedStart";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findElementInInjected";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findInside$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 44: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

