/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostFormatProcessorHelper {
    private final CommonCodeStyleSettings mySettings;
    private int myDelta;
    private TextRange myResultTextRange;

    public PostFormatProcessorHelper(CommonCodeStyleSettings settings) {
        this.mySettings = settings;
    }

    public CommonCodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public void updateResultRange(int oldTextLength, int newTextLength) {
        if (this.myResultTextRange == null) {
            return;
        }
        int thisChange = newTextLength - oldTextLength;
        this.myDelta += thisChange;
        this.myResultTextRange = new TextRange(this.myResultTextRange.getStartOffset(), this.myResultTextRange.getEndOffset() + thisChange);
    }

    public int mapOffset(int sourceOffset) {
        return this.myDelta + sourceOffset;
    }

    @NotNull
    public TextRange mapRange(@NotNull TextRange sourceRange) {
        if (sourceRange == null) {
            PostFormatProcessorHelper.$$$reportNull$$$0(0);
        }
        TextRange textRange = new TextRange(this.myDelta + sourceRange.getStartOffset(), this.myDelta + sourceRange.getEndOffset());
        if (textRange == null) {
            PostFormatProcessorHelper.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public boolean isElementPartlyInRange(@NotNull PsiElement element) {
        if (element == null) {
            PostFormatProcessorHelper.$$$reportNull$$$0(2);
        }
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange.getEndOffset() < this.myResultTextRange.getStartOffset()) {
            return false;
        }
        return elementRange.getStartOffset() <= this.myResultTextRange.getEndOffset();
    }

    public boolean isElementFullyInRange(PsiElement element) {
        if (this.myResultTextRange == null) {
            return true;
        }
        TextRange elementRange = element.getTextRange();
        return elementRange.getStartOffset() >= this.myResultTextRange.getStartOffset() && elementRange.getEndOffset() <= this.myResultTextRange.getEndOffset();
    }

    public static boolean isMultiline(@Nullable PsiElement statement) {
        if (statement == null) {
            return false;
        }
        return statement.textContains('\n');
    }

    public void setResultTextRange(TextRange resultTextRange) {
        this.myResultTextRange = resultTextRange;
        this.myDelta = 0;
    }

    public TextRange getResultTextRange() {
        return this.myResultTextRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "mapRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapRange";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isElementPartlyInRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

