/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsVirtualFile
extends AbstractVcsVirtualFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.vfs.VcsVirtualFile");
    private byte[] myContent;
    private final VcsFileRevision myFileRevision;
    private boolean myContentLoadFailed;
    private Charset myCharset;

    public VcsVirtualFile(@NotNull String path, @Nullable VcsFileRevision revision, @NotNull VirtualFileSystem fileSystem) {
        if (path == null) {
            VcsVirtualFile.$$$reportNull$$$0(0);
        }
        if (fileSystem == null) {
            VcsVirtualFile.$$$reportNull$$$0(1);
        }
        super(path, fileSystem);
        this.myContentLoadFailed = false;
        this.myFileRevision = revision;
    }

    public VcsVirtualFile(@NotNull String path, @NotNull byte[] content, @Nullable String revision, @NotNull VirtualFileSystem fileSystem) {
        if (path == null) {
            VcsVirtualFile.$$$reportNull$$$0(2);
        }
        if (content == null) {
            VcsVirtualFile.$$$reportNull$$$0(3);
        }
        if (fileSystem == null) {
            VcsVirtualFile.$$$reportNull$$$0(4);
        }
        this(path, null, fileSystem);
        this.myContent = content;
        this.setRevision(revision);
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myContentLoadFailed || this.myProcessingBeforeContentsChange) {
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                VcsVirtualFile.$$$reportNull$$$0(5);
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        if (this.myContent == null) {
            VcsVirtualFile.$$$reportNull$$$0(6);
        }
        return this.myContent;
    }

    private void loadContent() throws IOException {
        if (this.myContent != null) {
            return;
        }
        assert (this.myFileRevision != null);
        final VcsFileSystem vcsFileSystem = (VcsFileSystem)this.getFileSystem();
        try {
            this.myFileRevision.loadContent();
            this.fireBeforeContentsChange();
            ++this.myModificationStamp;
            VcsRevisionNumber revisionNumber = this.myFileRevision.getRevisionNumber();
            this.setRevision(VcsUtil.getShortRevisionString((VcsRevisionNumber)revisionNumber));
            this.myContent = this.myFileRevision.getContent();
            this.myCharset = new CharsetToolkit(this.myContent).guessEncoding(this.myContent.length);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireContentsChanged(this, VcsVirtualFile.this, 0L);
                }
            });
        }
        catch (VcsException e) {
            this.myContentLoadFailed = true;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireBeforeFileDeletion(this, VcsVirtualFile.this);
                }
            });
            this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
            this.setRevision("0");
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.could.not.load.virtual.file.content", (Object[])new Object[]{this.getPresentableUrl(), e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.could.not.load.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireFileDeleted(this, VcsVirtualFile.this, VcsVirtualFile.this.getName(), VcsVirtualFile.this.getParent());
                }
            });
        }
        catch (ProcessCanceledException ex) {
            this.myContent = null;
        }
    }

    @Nullable
    public VcsFileRevision getFileRevision() {
        return this.myFileRevision;
    }

    @NotNull
    public Charset getCharset() {
        if (this.myCharset != null) {
            Charset charset = this.myCharset;
            if (charset == null) {
                VcsVirtualFile.$$$reportNull$$$0(7);
            }
            return charset;
        }
        Charset charset = super.getCharset();
        if (charset == null) {
            VcsVirtualFile.$$$reportNull$$$0(8);
        }
        return charset;
    }

    public boolean isDirectory() {
        return false;
    }

    public String getRevision() {
        if (this.myRevision == null) {
            try {
                this.loadContent();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return this.myRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/vfs/VcsVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/vfs/VcsVirtualFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

