/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import org.jetbrains.annotations.Nullable;

public class ReopenClosedTabAction
extends AnAction {
    public ReopenClosedTabAction() {
        super("Reopen Closed Tab");
    }

    public void actionPerformed(AnActionEvent e) {
        EditorWindow window = ReopenClosedTabAction.getEditorWindow(e);
        if (window != null) {
            window.restoreClosedTab();
        }
    }

    @Nullable
    private static EditorWindow getEditorWindow(AnActionEvent e) {
        EditorsSplitters splitters;
        Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (component != null && (splitters = (EditorsSplitters)((Object)UIUtil.getParentOfType(EditorsSplitters.class, (Component)component))) != null) {
            return splitters.getCurrentWindow();
        }
        return null;
    }

    public void update(AnActionEvent e) {
        EditorWindow window = ReopenClosedTabAction.getEditorWindow(e);
        e.getPresentation().setEnabled(window != null && window.hasClosedTabs());
    }
}

