/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.AbnormalCommandTerminationException;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.command.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;

class CommandProcessorImpl
extends CoreCommandProcessor {
    CommandProcessorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishCommand(Project project, Object command, Throwable throwable) {
        boolean failed;
        if (this.myCurrentCommand != command) {
            return;
        }
        try {
            if (throwable instanceof AbnormalCommandTerminationException) {
                AbnormalCommandTerminationException rollback = (AbnormalCommandTerminationException)throwable;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException((Throwable)rollback);
                }
                failed = true;
            } else if (throwable != null) {
                failed = true;
                ExceptionUtil.rethrowUnchecked((Throwable)throwable);
                CommandLog.LOG.error(throwable);
            } else {
                failed = false;
            }
        }
        finally {
            try {
                super.finishCommand(project, command, throwable);
            }
            catch (Throwable e) {
                if (throwable != null) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        if (failed) {
            if (project != null) {
                FileEditor editor = new FocusBasedCurrentEditorProvider().getCurrentEditor();
                UndoManager undoManager = UndoManager.getInstance((Project)project);
                if (undoManager.isUndoAvailable(editor)) {
                    undoManager.undo(editor);
                }
            }
            Messages.showErrorDialog((Project)project, (String)"Cannot perform operation. Too complex, sorry.", (String)"Failed to Perform Operation");
        }
    }

    @Override
    public void markCurrentCommandAsGlobal(Project project) {
        CommandProcessorImpl.getUndoManager(project).markCurrentCommandAsGlobal();
    }

    private static UndoManagerImpl getUndoManager(Project project) {
        return (UndoManagerImpl)(project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance());
    }

    @Override
    public void addAffectedDocuments(Project project, Document ... docs) {
        if (docs == null) {
            CommandProcessorImpl.$$$reportNull$$$0(0);
        }
        CommandProcessorImpl.getUndoManager(project).addAffectedDocuments(docs);
    }

    @Override
    public void addAffectedFiles(Project project, VirtualFile ... files) {
        if (files == null) {
            CommandProcessorImpl.$$$reportNull$$$0(1);
        }
        CommandProcessorImpl.getUndoManager(project).addAffectedFiles(files);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CommandProcessorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedDocuments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

