/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import org.jetbrains.annotations.NotNull;

public class ScratchesSearchScope
extends GlobalSearchScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> SCRATCHES_SCOPE_KEY = NotNullLazyKey.create((String)"SCRATCHES_SCOPE_KEY", project -> new ScratchesSearchScope((Project)project, ScratchFileService.getInstance()));
    private final ScratchFileService myService;

    @NotNull
    public static GlobalSearchScope getScratchesScope(@NotNull Project project) {
        if (project == null) {
            ScratchesSearchScope.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)SCRATCHES_SCOPE_KEY.getValue((UserDataHolder)project);
        if (globalSearchScope == null) {
            ScratchesSearchScope.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    public ScratchesSearchScope(@NotNull Project project, @NotNull ScratchFileService service) {
        if (project == null) {
            ScratchesSearchScope.$$$reportNull$$$0(2);
        }
        if (service == null) {
            ScratchesSearchScope.$$$reportNull$$$0(3);
        }
        super(project);
        this.myService = service;
    }

    @NotNull
    public String getDisplayName() {
        if ("Scratches and Consoles" == null) {
            ScratchesSearchScope.$$$reportNull$$$0(4);
        }
        return "Scratches and Consoles";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        RootType rootType;
        if (file2 == null) {
            ScratchesSearchScope.$$$reportNull$$$0(5);
        }
        return (rootType = this.myService.getRootType(file2)) != null && !rootType.isHidden();
    }

    public boolean isSearchOutsideRootModel() {
        return true;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            ScratchesSearchScope.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            ScratchesSearchScope.$$$reportNull$$$0(7);
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            ScratchesSearchScope.$$$reportNull$$$0(8);
        }
        return false;
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ScratchesSearchScope.$$$reportNull$$$0(9);
        }
        if (scope instanceof ProjectAndLibrariesScope) {
            ScratchesSearchScope scratchesSearchScope = this;
            if (scratchesSearchScope == null) {
                ScratchesSearchScope.$$$reportNull$$$0(10);
            }
            return scratchesSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope == null) {
            ScratchesSearchScope.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchesSearchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchesSearchScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchesScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScratchesScope";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

