/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreFormatterUtil {
    private CoreFormatterUtil() {
    }

    @NotNull
    public static FormattingModel buildModel(@NotNull FormattingModelBuilder builder, @NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (builder == null) {
            CoreFormatterUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CoreFormatterUtil.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            CoreFormatterUtil.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            CoreFormatterUtil.$$$reportNull$$$0(3);
        }
        if (builder instanceof FormattingModelBuilderEx) {
            FormattingModel formattingModel = ((FormattingModelBuilderEx)builder).createModel(element, settings, mode);
            if (formattingModel == null) {
                CoreFormatterUtil.$$$reportNull$$$0(4);
            }
            return formattingModel;
        }
        FormattingModel formattingModel = builder.createModel(element, settings);
        if (formattingModel == null) {
            CoreFormatterUtil.$$$reportNull$$$0(5);
        }
        return formattingModel;
    }

    @Nullable
    public static AlignmentImpl getAlignment(@NotNull AbstractBlockWrapper block) {
        AlignmentImpl alignment;
        if (block == null) {
            CoreFormatterUtil.$$$reportNull$$$0(6);
        }
        AbstractBlockWrapper current = block;
        while ((alignment = current.getAlignment()) == null || alignment.getOffsetRespBlockBefore(block) == null) {
            if ((current = current.getParent()) != null && current.getStartOffset() == block.getStartOffset()) continue;
            return null;
        }
        return alignment;
    }

    public static int getStartColumn(@Nullable LeafBlockWrapper block) {
        if (block == null) {
            return -1;
        }
        int result2 = 0;
        do {
            WhiteSpace whiteSpace;
            if ((whiteSpace = block.getWhiteSpace()) != null) {
                result2 += whiteSpace.getTotalSpaces();
                if (whiteSpace.containsLineFeeds()) {
                    return result2;
                }
            }
            block = block.getPreviousBlock();
            if (result2 > 1000 || block == null) {
                return result2;
            }
            result2 += block.getSymbolsAtTheLastLine();
        } while (!block.containsLineFeeds());
        return result2;
    }

    @Nullable
    public static AbstractBlockWrapper getIndentedParentBlock(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            CoreFormatterUtil.$$$reportNull$$$0(7);
        }
        for (CompositeBlockWrapper current = block.getParent(); current != null; current = current.getParent()) {
            AbstractBlockWrapper prevIndented;
            if (current.getStartOffset() != block.getStartOffset() && current.getWhiteSpace().containsLineFeeds()) {
                return current;
            }
            if (current.getParent() == null || (prevIndented = current.getParent().getPrevIndentedSibling(current)) == null) continue;
            return prevIndented;
        }
        return null;
    }

    public static boolean allowBackwardAlignment(@NotNull LeafBlockWrapper first, @NotNull LeafBlockWrapper second, @NotNull Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> alignmentMappings) {
        if (first == null) {
            CoreFormatterUtil.$$$reportNull$$$0(8);
        }
        if (second == null) {
            CoreFormatterUtil.$$$reportNull$$$0(9);
        }
        if (alignmentMappings == null) {
            CoreFormatterUtil.$$$reportNull$$$0(10);
        }
        HashSet<AbstractBlockWrapper> blocksBeforeCurrent = new HashSet<AbstractBlockWrapper>();
        for (LeafBlockWrapper previousBlock = second.getPreviousBlock(); previousBlock != null; previousBlock = previousBlock.getPreviousBlock()) {
            Set<AbstractBlockWrapper> blocks = alignmentMappings.get(previousBlock);
            if (blocks != null) {
                blocksBeforeCurrent.addAll(blocks);
            }
            if (previousBlock.getWhiteSpace().containsLineFeeds()) break;
        }
        for (LeafBlockWrapper next = first.getNextBlock(); next != null && !next.getWhiteSpace().containsLineFeeds(); next = next.getNextBlock()) {
            if (!blocksBeforeCurrent.contains(next)) continue;
            return false;
        }
        return true;
    }

    public static IndentData getIndent(CommonCodeStyleSettings.IndentOptions options, AbstractBlockWrapper block, int tokenBlockStartOffset) {
        IndentImpl indent = block.getIndent();
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return new IndentData(options.CONTINUATION_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.CONTINUATION_WITHOUT_FIRST) {
            if (block.getStartOffset() != block.getParent().getStartOffset() && block.getStartOffset() == tokenBlockStartOffset) {
                return new IndentData(options.CONTINUATION_INDENT_SIZE);
            }
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.LABEL) {
            return new IndentData(options.LABEL_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.NONE) {
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.SPACES) {
            return new IndentData(indent.getSpaces(), 0);
        }
        return new IndentData(options.INDENT_SIZE);
    }

    @NotNull
    public static LeafBlockWrapper getFirstLeaf(@NotNull AbstractBlockWrapper block) {
        if (block == null) {
            CoreFormatterUtil.$$$reportNull$$$0(11);
        }
        if (block instanceof LeafBlockWrapper) {
            LeafBlockWrapper leafBlockWrapper = (LeafBlockWrapper)block;
            if (leafBlockWrapper == null) {
                CoreFormatterUtil.$$$reportNull$$$0(12);
            }
            return leafBlockWrapper;
        }
        LeafBlockWrapper leafBlockWrapper = CoreFormatterUtil.getFirstLeaf(((CompositeBlockWrapper)block).getChildren().get(0));
        if (leafBlockWrapper == null) {
            CoreFormatterUtil.$$$reportNull$$$0(13);
        }
        return leafBlockWrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/CoreFormatterUtil";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignmentMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/CoreFormatterUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAlignment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndentedParentBlock";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "allowBackwardAlignment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLeaf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

