/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionElementsMergerBase;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.NewInspectionProfile;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.NotNullList;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileImpl
extends NewInspectionProfile {
    @NonNls
    static final String INSPECTION_TOOL_TAG = "inspection_tool";
    @NonNls
    static final String CLASS_TAG = "class";
    protected static final Logger LOG = Logger.getInstance(InspectionProfileImpl.class);
    @NonNls
    private static final String VALID_VERSION = "1.0";
    @NonNls
    private static final String VERSION_TAG = "version";
    @NonNls
    private static final String USED_LEVELS = "used_levels";
    public static boolean INIT_INSPECTIONS = false;
    @NotNull
    protected final Supplier<List<InspectionToolWrapper>> myToolSupplier;
    protected final Map<String, Element> myUninitializedSettings;
    protected Map<String, ToolsImpl> myTools;
    protected volatile Set<String> myChangedToolNames;
    @Attribute(value="is_locked")
    protected boolean myLockedProfile;
    protected final InspectionProfileImpl myBaseProfile;
    private volatile String myToolShortName;
    private String[] myScopesOrder;
    private String myDescription;
    private SchemeDataHolder<? super InspectionProfileImpl> myDataHolder;

    public InspectionProfileImpl(@NotNull String profileName, @NotNull Supplier<List<InspectionToolWrapper>> toolSupplier, @NotNull BaseInspectionProfileManager profileManager) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(0);
        }
        if (toolSupplier == null) {
            InspectionProfileImpl.$$$reportNull$$$0(1);
        }
        if (profileManager == null) {
            InspectionProfileImpl.$$$reportNull$$$0(2);
        }
        this(profileName, toolSupplier, profileManager, InspectionProfileKt.getBASE_PROFILE(), null);
    }

    public InspectionProfileImpl(@NotNull String profileName) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(3);
        }
        this(profileName, InspectionToolRegistrar.getInstance(), (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), null, null);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull Supplier<List<InspectionToolWrapper>> toolSupplier, @Nullable InspectionProfileImpl baseProfile) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(4);
        }
        if (toolSupplier == null) {
            InspectionProfileImpl.$$$reportNull$$$0(5);
        }
        this(profileName, toolSupplier, (BaseInspectionProfileManager)InspectionProfileManager.getInstance(), baseProfile, null);
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull Supplier<List<InspectionToolWrapper>> toolSupplier, @NotNull BaseInspectionProfileManager profileManager, @Nullable InspectionProfileImpl baseProfile, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(6);
        }
        if (toolSupplier == null) {
            InspectionProfileImpl.$$$reportNull$$$0(7);
        }
        if (profileManager == null) {
            InspectionProfileImpl.$$$reportNull$$$0(8);
        }
        super(profileName, profileManager);
        this.myUninitializedSettings = new TreeMap<String, Element>();
        this.myTools = new THashMap();
        this.myToolSupplier = toolSupplier;
        this.myBaseProfile = baseProfile;
        this.myDataHolder = dataHolder;
        if (dataHolder != null) {
            this.schemeState = SchemeState.UNCHANGED;
        }
    }

    public InspectionProfileImpl(@NotNull String profileName, @NotNull Supplier<List<InspectionToolWrapper>> toolSupplier, @NotNull BaseInspectionProfileManager profileManager, @Nullable SchemeDataHolder<? super InspectionProfileImpl> dataHolder) {
        if (profileName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(9);
        }
        if (toolSupplier == null) {
            InspectionProfileImpl.$$$reportNull$$$0(10);
        }
        if (profileManager == null) {
            InspectionProfileImpl.$$$reportNull$$$0(11);
        }
        this(profileName, toolSupplier, profileManager, InspectionProfileKt.getBASE_PROFILE(), dataHolder);
    }

    private static boolean toolSettingsAreEqual(@NotNull String toolName, @NotNull InspectionProfileImpl profile1, @NotNull InspectionProfileImpl profile2) {
        if (toolName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(12);
        }
        if (profile1 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(13);
        }
        if (profile2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(14);
        }
        Tools toolList1 = profile1.myTools.get(toolName);
        Tools toolList2 = profile2.myTools.get(toolName);
        return Comparing.equal((Object)toolList1, (Object)toolList2);
    }

    @NotNull
    protected static InspectionToolWrapper copyToolSettings(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(15);
        }
        InspectionToolWrapper inspectionTool = toolWrapper.createCopy();
        if (toolWrapper.isInitialized()) {
            Element config = new Element("config");
            toolWrapper.getTool().writeSettings(config);
            inspectionTool.getTool().readSettings(config);
        }
        InspectionToolWrapper inspectionToolWrapper = inspectionTool;
        if (inspectionToolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(16);
        }
        return inspectionToolWrapper;
    }

    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        HighlightDisplayLevel level;
        if (inspectionToolKey == null) {
            InspectionProfileImpl.$$$reportNull$$$0(17);
        }
        Project project = element == null ? null : element.getProject();
        ToolsImpl tools = this.getToolsOrNull(inspectionToolKey.toString(), project);
        HighlightDisplayLevel highlightDisplayLevel = level = tools != null ? tools.getLevel(element) : HighlightDisplayLevel.WARNING;
        if (!this.getProfileManager().getOwnSeverityRegistrar().isSeverityValid(level.getSeverity().getName())) {
            level = HighlightDisplayLevel.WARNING;
            this.setErrorLevel(inspectionToolKey, level, project);
        }
        return level;
    }

    @Override
    public void readExternal(@NotNull Element element) {
        String version;
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(18);
        }
        this.mySerializer.readExternal((Object)this, element);
        Element highlightElement = element.getChild(USED_LEVELS);
        if (highlightElement != null) {
            this.getProfileManager().getOwnSeverityRegistrar().readExternal(highlightElement);
        }
        if ((version = element.getAttributeValue(VERSION_TAG)) == null || !version.equals(VALID_VERSION)) {
            InspectionToolWrapper[] tools = this.getInspectionTools(null);
            for (Element toolElement : element.getChildren(INSPECTION_TOOL_TAG)) {
                String toolClassName = toolElement.getAttributeValue(CLASS_TAG);
                String shortName = InspectionProfileImpl.convertToShortName(toolClassName, tools);
                if (shortName == null) continue;
                toolElement.setAttribute(CLASS_TAG, shortName);
                this.myUninitializedSettings.put(shortName, toolElement.clone());
            }
        } else {
            for (Element toolElement : element.getChildren(INSPECTION_TOOL_TAG)) {
                this.myUninitializedSettings.put(toolElement.getAttributeValue(CLASS_TAG), toolElement.clone());
            }
        }
    }

    @Nullable
    private static String convertToShortName(@Nullable String displayName, InspectionToolWrapper[] tools) {
        if (displayName == null) {
            return null;
        }
        for (InspectionToolWrapper tool : tools) {
            if (!displayName.equals(tool.getDisplayName())) continue;
            return tool.getShortName();
        }
        return null;
    }

    @NotNull
    public Set<HighlightSeverity> getUsedSeverities() {
        LOG.assertTrue(this.wasInitialized());
        THashSet result2 = new THashSet();
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state2 : tools.getTools()) {
                result2.add(state2.getLevel().getSeverity());
            }
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            InspectionProfileImpl.$$$reportNull$$$0(19);
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element element = this.writeScheme(true);
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(20);
        }
        return element;
    }

    @NotNull
    public Element writeScheme(boolean setSchemeStateToUnchanged) {
        if (this.myDataHolder != null) {
            Element element = this.myDataHolder.read();
            if (element == null) {
                InspectionProfileImpl.$$$reportNull$$$0(21);
            }
            return element;
        }
        Element element = new Element("profile");
        this.writeExternal(element);
        if (this.isProjectLevel()) {
            element.setAttribute(VERSION_TAG, VALID_VERSION);
        }
        if (this.isProjectLevel() && ProjectKt.isDirectoryBased(((ProjectInspectionProfileManager)this.getProfileManager()).getProject())) {
            Element element2 = new Element("component").setAttribute("name", "InspectionProjectProfileManager").addContent(element);
            if (element2 == null) {
                InspectionProfileImpl.$$$reportNull$$$0(22);
            }
            return element2;
        }
        if (setSchemeStateToUnchanged) {
            this.schemeState = SchemeState.UNCHANGED;
        }
        Element element3 = element;
        if (element3 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(23);
        }
        return element3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(24);
        }
        InspectionProfileImpl.writeVersion(element);
        this.mySerializer.writeExternal((Object)this, element);
        Object object = this.myLock;
        synchronized (object) {
            if (!this.wasInitialized()) {
                for (Element el : this.myUninitializedSettings.values()) {
                    element.addContent(el.clone());
                }
                return;
            }
        }
        Set<String> changedToolNames = this.getChangedToolNames();
        if (changedToolNames == null) {
            return;
        }
        ArrayList<String> allToolNames = new ArrayList<String>(this.myTools.keySet());
        allToolNames.addAll(this.myUninitializedSettings.keySet());
        allToolNames.sort(null);
        for (String toolName : allToolNames) {
            Element toolElement = this.myUninitializedSettings.get(toolName);
            if (toolElement != null) {
                element.addContent(toolElement.clone());
                continue;
            }
            if (!this.myLockedProfile && !changedToolNames.contains(toolName)) {
                this.markSettingsMerged(toolName, element);
                continue;
            }
            ToolsImpl toolList = this.myTools.get(toolName);
            LOG.assertTrue(toolList != null);
            Element inspectionElement = new Element(INSPECTION_TOOL_TAG);
            inspectionElement.setAttribute(CLASS_TAG, toolName);
            try {
                toolList.writeExternal(inspectionElement);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (this.areSettingsMerged(toolName, inspectionElement)) continue;
            element.addContent(inspectionElement);
        }
        this.getPathMacroManager().collapsePaths(element);
    }

    protected static void writeVersion(@NotNull Element element) {
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(25);
        }
        element.setAttribute(VERSION_TAG, VALID_VERSION);
    }

    private void markSettingsMerged(@NotNull String toolName, @NotNull Element element) {
        InspectionElementsMergerBase merger;
        String mergedName;
        if (toolName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(26);
        }
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(27);
        }
        if (!this.myUninitializedSettings.containsKey(mergedName = InspectionElementsMergerBase.getMergedMarkerName(toolName)) && (merger = InspectionProfileImpl.getMerger(toolName)) != null && merger.markSettingsMerged(this.myUninitializedSettings)) {
            element.addContent(new Element(INSPECTION_TOOL_TAG).setAttribute(CLASS_TAG, mergedName));
        }
    }

    private boolean areSettingsMerged(String toolName, Element inspectionElement) {
        InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(toolName);
        return merger != null && merger.areSettingsMerged(this.myUninitializedSettings, inspectionElement);
    }

    public void collectDependentInspections(@NotNull InspectionToolWrapper toolWrapper, @NotNull Set<InspectionToolWrapper<?, ?>> dependentEntries, Project project) {
        String mainToolId;
        if (toolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(28);
        }
        if (dependentEntries == null) {
            InspectionProfileImpl.$$$reportNull$$$0(29);
        }
        if ((mainToolId = toolWrapper.getMainToolId()) != null) {
            InspectionToolWrapper dependentEntryWrapper = this.getInspectionTool(mainToolId, project);
            if (dependentEntryWrapper == null) {
                LOG.error("Can't find main tool: '" + mainToolId + "' which was specified in " + toolWrapper);
                return;
            }
            if (!dependentEntries.add(dependentEntryWrapper)) {
                this.collectDependentInspections(dependentEntryWrapper, dependentEntries, project);
            }
        }
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, @Nullable PsiElement element) {
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(30);
        }
        ToolsImpl toolList = this.getToolsOrNull(shortName, element == null ? null : element.getProject());
        return toolList == null ? null : toolList.getInspectionTool(element);
    }

    @Nullable
    public InspectionProfileEntry getUnwrappedTool(@NotNull String shortName, @NotNull PsiElement element) {
        InspectionToolWrapper tool;
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(31);
        }
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(32);
        }
        return (tool = this.getInspectionTool(shortName, element)) == null ? null : tool.getTool();
    }

    public <T extends InspectionProfileEntry> T getUnwrappedTool(@NotNull Key<T> shortNameKey, @NotNull PsiElement element) {
        if (shortNameKey == null) {
            InspectionProfileImpl.$$$reportNull$$$0(33);
        }
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(34);
        }
        return (T)this.getUnwrappedTool(shortNameKey.toString(), element);
    }

    public void modifyProfile(@NotNull Consumer<InspectionProfileModifiableModel> modelConsumer) {
        if (modelConsumer == null) {
            InspectionProfileImpl.$$$reportNull$$$0(35);
        }
        InspectionProfileModifiableModelKt.edit(this, (Function1<? super InspectionProfileModifiableModel, Unit>)((Function1)it -> {
            if (modelConsumer == null) {
                InspectionProfileImpl.$$$reportNull$$$0(90);
            }
            modelConsumer.consume(it);
            return null;
        }));
    }

    public <T extends InspectionProfileEntry> void modifyToolSettings(@NotNull Key<T> shortNameKey, @NotNull PsiElement psiElement, @NotNull Consumer<T> toolConsumer) {
        if (shortNameKey == null) {
            InspectionProfileImpl.$$$reportNull$$$0(36);
        }
        if (psiElement == null) {
            InspectionProfileImpl.$$$reportNull$$$0(37);
        }
        if (toolConsumer == null) {
            InspectionProfileImpl.$$$reportNull$$$0(38);
        }
        this.modifyProfile((Consumer<InspectionProfileModifiableModel>)((Consumer)model -> {
            if (shortNameKey == null) {
                InspectionProfileImpl.$$$reportNull$$$0(87);
            }
            if (psiElement == null) {
                InspectionProfileImpl.$$$reportNull$$$0(88);
            }
            if (toolConsumer == null) {
                InspectionProfileImpl.$$$reportNull$$$0(89);
            }
            InspectionProfileEntry tool = model.getUnwrappedTool(shortNameKey.toString(), psiElement);
            toolConsumer.consume((Object)tool);
        }));
    }

    @Nullable
    public InspectionToolWrapper getInspectionTool(@NotNull String shortName, Project project) {
        ToolsImpl tools;
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(39);
        }
        return (tools = this.getToolsOrNull(shortName, project)) != null ? tools.getTool() : null;
    }

    public InspectionToolWrapper getToolById(@NotNull String id, @NotNull PsiElement element) {
        if (id == null) {
            InspectionProfileImpl.$$$reportNull$$$0(40);
        }
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(41);
        }
        this.initInspectionTools(element.getProject());
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element);
            if (!id.equals(tool.getID())) continue;
            return tool;
        }
        return null;
    }

    @Nullable
    public List<InspectionToolWrapper> findToolsById(@NotNull String id, @NotNull PsiElement element) {
        if (id == null) {
            InspectionProfileImpl.$$$reportNull$$$0(42);
        }
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(43);
        }
        ArrayList<InspectionToolWrapper> result2 = null;
        this.initInspectionTools(element.getProject());
        for (Tools tools : this.myTools.values()) {
            InspectionToolWrapper tool = tools.getInspectionTool(element);
            if (!id.equals(tool.getID())) continue;
            if (result2 == null) {
                result2 = new ArrayList<InspectionToolWrapper>();
            }
            result2.add(tool);
        }
        return result2;
    }

    @Nullable
    public String getSingleTool() {
        return this.myToolShortName;
    }

    public void setSingleTool(@NotNull String toolShortName) {
        if (toolShortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(44);
        }
        this.myToolShortName = toolShortName;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getName();
        if (string == null) {
            InspectionProfileImpl.$$$reportNull$$$0(45);
        }
        return string;
    }

    public void scopesChanged() {
        if (!this.wasInitialized()) {
            return;
        }
        for (ToolsImpl tools : this.myTools.values()) {
            tools.scopesChanged();
        }
        this.getProfileManager().fireProfileChanged(this);
    }

    @Transient
    public boolean isProfileLocked() {
        return this.myLockedProfile;
    }

    public void lockProfile(boolean isLocked) {
        this.myLockedProfile = isLocked;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    public InspectionToolWrapper[] getInspectionTools(@Nullable PsiElement element) {
        this.initInspectionTools(element == null ? null : element.getProject());
        ArrayList<InspectionToolWrapper> result2 = new ArrayList<InspectionToolWrapper>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getInspectionTool(element));
        }
        InspectionToolWrapper[] inspectionToolWrapperArray = result2.toArray(new InspectionToolWrapper[result2.size()]);
        if (inspectionToolWrapperArray == null) {
            InspectionProfileImpl.$$$reportNull$$$0(46);
        }
        return inspectionToolWrapperArray;
    }

    @NotNull
    public List<Tools> getAllEnabledInspectionTools(Project project) {
        this.initInspectionTools(project);
        ArrayList<Tools> result2 = new ArrayList<Tools>();
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            result2.add(toolList);
        }
        ArrayList<Tools> arrayList = result2;
        if (arrayList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(47);
        }
        return arrayList;
    }

    public void disableToolByDefault(@NotNull Collection<String> toolShortNames, @Nullable Project project) {
        if (toolShortNames == null) {
            InspectionProfileImpl.$$$reportNull$$$0(48);
        }
        for (String toolId : toolShortNames) {
            this.getTools(toolId, project).setDefaultEnabled(false);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    public ScopeToolState getToolDefaultState(@NotNull String toolShortName, @Nullable Project project) {
        if (toolShortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(49);
        }
        ScopeToolState scopeToolState = this.getTools(toolShortName, project).getDefaultState();
        if (scopeToolState == null) {
            InspectionProfileImpl.$$$reportNull$$$0(50);
        }
        return scopeToolState;
    }

    public void enableToolsByDefault(@NotNull List<String> toolShortNames, Project project) {
        if (toolShortNames == null) {
            InspectionProfileImpl.$$$reportNull$$$0(51);
        }
        for (String shortName : toolShortNames) {
            this.getTools(shortName, project).setDefaultEnabled(true);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @NotNull
    protected List<InspectionToolWrapper> createTools(@Nullable Project project) {
        List<InspectionToolWrapper> list2 = this.myToolSupplier.get();
        if (list2 == null) {
            InspectionProfileImpl.$$$reportNull$$$0(52);
        }
        return list2;
    }

    @Override
    protected void initialize(@Nullable Project project) {
        List<InspectionToolWrapper> tools;
        SchemeDataHolder<? super InspectionProfileImpl> dataHolder = this.myDataHolder;
        if (dataHolder != null) {
            this.myDataHolder = null;
            Element element = dataHolder.read();
            if (element.getName().equals("component")) {
                element = element.getChild("profile");
            }
            assert (element != null);
            this.readExternal(element);
        }
        if (this.myBaseProfile != null) {
            this.myBaseProfile.initInspectionTools(project);
        }
        try {
            tools = this.createTools(project);
        }
        catch (ProcessCanceledException ignored) {
            return;
        }
        THashMap dependencies = new THashMap();
        for (InspectionToolWrapper toolWrapper : tools) {
            this.addTool(project, toolWrapper, (Map<String, List<String>>)dependencies);
        }
        DFSTBuilder builder = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)new InboundSemiGraph<String>((Map)dependencies){
            final /* synthetic */ Map val$dependencies;
            {
                this.val$dependencies = map2;
            }

            public Collection<String> getNodes() {
                return this.val$dependencies.keySet();
            }

            public Iterator<String> getIn(String n) {
                return ((List)this.val$dependencies.get(n)).iterator();
            }
        }));
        if (builder.isAcyclic()) {
            this.myScopesOrder = ArrayUtil.toStringArray((Collection)builder.getSortedNodes());
        }
        this.copyToolsConfigurations(project);
        this.initialized = true;
        if (dataHolder != null) {
            dataHolder.updateDigest(this);
        }
    }

    protected void copyToolsConfigurations(@Nullable Project project) {
    }

    public void addTool(@Nullable Project project, @NotNull InspectionToolWrapper toolWrapper, @NotNull Map<String, List<String>> dependencies) {
        String shortName;
        HighlightDisplayKey key;
        if (toolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(53);
        }
        if (dependencies == null) {
            InspectionProfileImpl.$$$reportNull$$$0(54);
        }
        if ((key = HighlightDisplayKey.find((String)(shortName = toolWrapper.getShortName()))) == null) {
            InspectionEP extension = toolWrapper.getExtension();
            Computable.PredefinedValueComputable computable = extension == null ? new Computable.PredefinedValueComputable((Object)toolWrapper.getDisplayName()) : () -> ((InspectionEP)extension).getDisplayName();
            key = toolWrapper instanceof LocalInspectionToolWrapper ? HighlightDisplayKey.register((String)shortName, (Computable)computable, (String)toolWrapper.getID(), (String)((LocalInspectionToolWrapper)toolWrapper).getAlternativeID()) : HighlightDisplayKey.register((String)shortName, (Computable)computable);
        }
        if (key == null) {
            LOG.error(shortName + " ; number of initialized tools: " + this.myTools.size());
            return;
        }
        HighlightDisplayLevel baseLevel = this.myBaseProfile != null && this.myBaseProfile.getToolsOrNull(shortName, project) != null ? this.myBaseProfile.getErrorLevel(key, project) : HighlightDisplayLevel.DO_NOT_SHOW;
        HighlightDisplayLevel defaultLevel = toolWrapper.getDefaultLevel();
        HighlightDisplayLevel level = baseLevel.getSeverity().compareTo(defaultLevel.getSeverity()) > 0 ? baseLevel : defaultLevel;
        boolean enabled = this.myBaseProfile != null ? this.myBaseProfile.isToolEnabled(key) : toolWrapper.isEnabledByDefault();
        ToolsImpl toolsList = new ToolsImpl(toolWrapper, level, !this.myLockedProfile && enabled, enabled);
        Element element = this.myUninitializedSettings.remove(shortName);
        try {
            if (element != null) {
                this.getPathMacroManager().expandPaths(element);
                toolsList.readExternal(element, this.getProfileManager(), dependencies);
            } else if (!this.myUninitializedSettings.containsKey(InspectionElementsMergerBase.getMergedMarkerName(shortName))) {
                Element merged;
                InspectionElementsMergerBase merger = InspectionProfileImpl.getMerger(shortName);
                Element element2 = merged = merger == null ? null : merger.merge(this.myUninitializedSettings);
                if (merged != null) {
                    this.getPathMacroManager().expandPaths(merged);
                    toolsList.readExternal(merged, this.getProfileManager(), dependencies);
                } else if (this.isProfileLocked()) {
                    toolsList.setEnabled(false);
                    if (toolsList.getNonDefaultTools() == null) {
                        toolsList.getDefaultState().setEnabled(false);
                    }
                }
            }
        }
        catch (InvalidDataException e) {
            LOG.error("Can't read settings for " + toolWrapper, (Throwable)e);
        }
        this.myTools.put(shortName, toolsList);
    }

    @Nullable
    private static InspectionElementsMergerBase getMerger(String shortName) {
        final InspectionElementsMerger merger = InspectionElementsMerger.getMerger((String)shortName);
        if (merger instanceof InspectionElementsMergerBase) {
            return (InspectionElementsMergerBase)merger;
        }
        return merger != null ? new InspectionElementsMergerBase(){

            @NotNull
            public String getMergedToolName() {
                String string = merger.getMergedToolName();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String[] getSourceToolNames() {
                String[] stringArray = merger.getSourceToolNames();
                if (stringArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return stringArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/ex/InspectionProfileImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMergedToolName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSourceToolNames";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        } : null;
    }

    @Transient
    @Nullable
    public String[] getScopesOrder() {
        return this.myScopesOrder;
    }

    public void setScopesOrder(String[] scopesOrder) {
        this.myScopesOrder = scopesOrder;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    private HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, @Nullable Project project) {
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(55);
        }
        return this.getTools(key.toString(), project).getLevel();
    }

    @NotNull
    public InspectionProfileModifiableModel getModifiableModel() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = new InspectionProfileModifiableModel(this);
        if (inspectionProfileModifiableModel == null) {
            InspectionProfileImpl.$$$reportNull$$$0(56);
        }
        return inspectionProfileModifiableModel;
    }

    public void cleanup(@NotNull Project project) {
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(57);
        }
        if (!this.wasInitialized()) {
            return;
        }
        for (ToolsImpl toolList : this.myTools.values()) {
            if (!toolList.isEnabled()) continue;
            toolList.cleanupTools(project);
        }
    }

    public void enableTool(@NotNull String toolShortName, @Nullable Project project) {
        if (toolShortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(58);
        }
        this.setToolEnabled(toolShortName, true, project);
    }

    public void enableTool(@NotNull String inspectionTool, @NotNull NamedScope namedScope, Project project) {
        if (inspectionTool == null) {
            InspectionProfileImpl.$$$reportNull$$$0(59);
        }
        if (namedScope == null) {
            InspectionProfileImpl.$$$reportNull$$$0(60);
        }
        this.getTools(inspectionTool, project).enableTool(namedScope, project);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void enableTools(@NotNull List<String> inspectionTools, @NotNull NamedScope namedScope, Project project) {
        if (inspectionTools == null) {
            InspectionProfileImpl.$$$reportNull$$$0(61);
        }
        if (namedScope == null) {
            InspectionProfileImpl.$$$reportNull$$$0(62);
        }
        for (String inspectionTool : inspectionTools) {
            this.enableTool(inspectionTool, namedScope, project);
        }
    }

    public void disableTools(@NotNull List<String> inspectionTools, NamedScope namedScope, @NotNull Project project) {
        if (inspectionTools == null) {
            InspectionProfileImpl.$$$reportNull$$$0(63);
        }
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(64);
        }
        for (String inspectionTool : inspectionTools) {
            this.getTools(inspectionTool, project).disableTool(namedScope, project);
        }
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key, @NotNull HighlightDisplayLevel level, Project project) {
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(65);
        }
        if (level == null) {
            InspectionProfileImpl.$$$reportNull$$$0(66);
        }
        this.getTools(key.toString(), project).setLevel(level);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public boolean isToolEnabled(@Nullable HighlightDisplayKey key, @Nullable PsiElement element) {
        if (key == null) {
            return false;
        }
        ToolsImpl toolState = this.getToolsOrNull(key.toString(), element == null ? null : element.getProject());
        return toolState != null && toolState.isEnabled(element);
    }

    public boolean isExecutable(@Nullable Project project) {
        this.initInspectionTools(project);
        for (Tools tools : this.myTools.values()) {
            if (!tools.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Tag
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = StringUtil.nullize((String)description);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void convert(@NotNull Element element, @NotNull Project project) {
        Element scopes;
        if (element == null) {
            InspectionProfileImpl.$$$reportNull$$$0(67);
        }
        if (project == null) {
            InspectionProfileImpl.$$$reportNull$$$0(68);
        }
        if ((scopes = element.getChild("scopes")) == null) {
            return;
        }
        this.initInspectionTools(project);
        for (Element scopeElement : scopes.getChildren("scope")) {
            NamedScope scope;
            String profile2 = scopeElement.getAttributeValue("profile");
            InspectionProfileImpl inspectionProfile = profile2 == null ? null : this.getProfileManager().getProfile(profile2);
            NamedScope namedScope = scope = inspectionProfile == null ? null : this.getProfileManager().getScopesManager().getScope(scopeElement.getAttributeValue("name"));
            if (scope == null) continue;
            for (InspectionToolWrapper toolWrapper : inspectionProfile.getInspectionTools(null)) {
                HighlightDisplayKey key = HighlightDisplayKey.find((String)toolWrapper.getShortName());
                try {
                    InspectionToolWrapper toolWrapperCopy = InspectionProfileImpl.copyToolSettings(toolWrapper);
                    HighlightDisplayLevel errorLevel = inspectionProfile.getErrorLevel(key, null, project);
                    this.getTools(toolWrapper.getShortName(), project).addTool(scope, toolWrapperCopy, inspectionProfile.isToolEnabled(key), errorLevel);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        this.reduceConvertedScopes();
    }

    private void reduceConvertedScopes() {
        for (ToolsImpl tools : this.myTools.values()) {
            ScopeToolState toolState = tools.getDefaultState();
            List<ScopeToolState> nonDefaultTools = tools.getNonDefaultTools();
            if (nonDefaultTools == null) continue;
            boolean equal = true;
            boolean isEnabled = toolState.isEnabled();
            for (ScopeToolState state2 : nonDefaultTools) {
                isEnabled |= state2.isEnabled();
                if (state2.equalTo(toolState)) continue;
                equal = false;
            }
            tools.setEnabled(isEnabled);
            if (!equal) continue;
            tools.removeAllScopes();
        }
    }

    @NotNull
    public List<ScopeToolState> getAllTools() {
        this.initInspectionTools();
        NotNullList result2 = new NotNullList();
        for (Tools tools : this.myTools.values()) {
            tools.collectTools((List)result2);
        }
        NotNullList notNullList = result2;
        if (notNullList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(69);
        }
        return notNullList;
    }

    @NotNull
    public List<ScopeToolState> getDefaultStates(@Nullable Project project) {
        this.initInspectionTools(project);
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        for (Tools tools : this.myTools.values()) {
            result2.add(tools.getDefaultState());
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(70);
        }
        return arrayList;
    }

    @NotNull
    public List<ScopeToolState> getNonDefaultTools(@NotNull String shortName, Project project) {
        if (shortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(71);
        }
        ArrayList<ScopeToolState> result2 = new ArrayList<ScopeToolState>();
        List<ScopeToolState> nonDefaultTools = this.getTools(shortName, project).getNonDefaultTools();
        if (nonDefaultTools != null) {
            result2.addAll(nonDefaultTools);
        }
        ArrayList<ScopeToolState> arrayList = result2;
        if (arrayList == null) {
            InspectionProfileImpl.$$$reportNull$$$0(72);
        }
        return arrayList;
    }

    public boolean isToolEnabled(@NotNull HighlightDisplayKey key, NamedScope namedScope, Project project) {
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(73);
        }
        return this.getTools(key.toString(), project).isEnabled(namedScope, project);
    }

    public void removeScope(@NotNull String toolShortName, @NotNull String scopeName, Project project) {
        if (toolShortName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(74);
        }
        if (scopeName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(75);
        }
        this.getTools(toolShortName, project).removeScope(scopeName);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void removeScopes(@NotNull List<String> shortNames, @NotNull String scopeName, Project project) {
        if (shortNames == null) {
            InspectionProfileImpl.$$$reportNull$$$0(76);
        }
        if (scopeName == null) {
            InspectionProfileImpl.$$$reportNull$$$0(77);
        }
        for (String shortName : shortNames) {
            this.removeScope(shortName, scopeName, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Set<String> getChangedToolNames() {
        if (this.myBaseProfile == null) {
            return null;
        }
        if (this.myChangedToolNames == null) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myChangedToolNames == null) {
                    this.initInspectionTools(null);
                    Set<String> names = this.myTools.keySet();
                    THashSet map2 = new THashSet(names.size());
                    for (String toolId : names) {
                        if (InspectionProfileImpl.toolSettingsAreEqual(toolId, this.myBaseProfile, this)) continue;
                        map2.add(toolId);
                    }
                    this.myChangedToolNames = map2;
                    return map2;
                }
            }
        }
        return this.myChangedToolNames;
    }

    public void profileChanged() {
        this.myChangedToolNames = null;
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    @Transient
    @NotNull
    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, NamedScope scope, Project project) {
        ToolsImpl tools;
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(78);
        }
        HighlightDisplayLevel highlightDisplayLevel = (tools = this.getToolsOrNull(key.toString(), project)) != null ? tools.getLevel(scope, project) : HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            InspectionProfileImpl.$$$reportNull$$$0(79);
        }
        return highlightDisplayLevel;
    }

    public ScopeToolState addScope(@NotNull InspectionToolWrapper toolWrapper, NamedScope scope, @NotNull HighlightDisplayLevel level, boolean enabled, Project project) {
        if (toolWrapper == null) {
            InspectionProfileImpl.$$$reportNull$$$0(80);
        }
        if (level == null) {
            InspectionProfileImpl.$$$reportNull$$$0(81);
        }
        return this.getTools(toolWrapper.getShortName(), project).prependTool(scope, toolWrapper, enabled, level);
    }

    public void setErrorLevel(@NotNull HighlightDisplayKey key, @NotNull HighlightDisplayLevel level, String scopeName, Project project) {
        if (key == null) {
            InspectionProfileImpl.$$$reportNull$$$0(82);
        }
        if (level == null) {
            InspectionProfileImpl.$$$reportNull$$$0(83);
        }
        this.getTools(key.toString(), project).setLevel(level, scopeName, project);
        this.schemeState = SchemeState.POSSIBLY_CHANGED;
    }

    public void setErrorLevel(@NotNull List<HighlightDisplayKey> keys, @NotNull HighlightDisplayLevel level, String scopeName, Project project) {
        if (keys == null) {
            InspectionProfileImpl.$$$reportNull$$$0(84);
        }
        if (level == null) {
            InspectionProfileImpl.$$$reportNull$$$0(85);
        }
        for (HighlightDisplayKey key : keys) {
            this.setErrorLevel(key, level, scopeName, project);
        }
    }

    @Override
    @Nullable
    public ToolsImpl getToolsOrNull(@NotNull String name, @Nullable Project project) {
        if (name == null) {
            InspectionProfileImpl.$$$reportNull$$$0(86);
        }
        this.initInspectionTools(project);
        return this.myTools.get(name);
    }

    public void enableAllTools(Project project) {
        for (InspectionToolWrapper entry : this.getInspectionTools(null)) {
            this.enableTool(entry.getShortName(), project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 56: 
            case 69: 
            case 70: 
            case 72: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 56: 
            case 69: 
            case 70: 
            case 72: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolSupplier";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileManager";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile2";
                break;
            }
            case 15: 
            case 28: 
            case 53: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 56: 
            case 69: 
            case 70: 
            case 72: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionProfileImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolKey";
                break;
            }
            case 18: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 34: 
            case 41: 
            case 43: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentEntries";
                break;
            }
            case 30: 
            case 31: 
            case 39: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 33: 
            case 36: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortNameKey";
                break;
            }
            case 35: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelConsumer";
                break;
            }
            case 37: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 38: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolConsumer";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 44: 
            case 49: 
            case 58: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolShortName";
                break;
            }
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolShortNames";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 55: 
            case 65: 
            case 73: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 57: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTool";
                break;
            }
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedScope";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTools";
                break;
            }
            case 66: 
            case 81: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortNames";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionProfileImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToolSettings";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedSeverities";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEnabledInspectionTools";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolDefaultState";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createTools";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTools";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStates";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonDefaultTools";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toolSettingsAreEqual";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyToolSettings";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 56: 
            case 69: 
            case 70: 
            case 72: 
            case 79: {
                break;
            }
            case 17: 
            case 55: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getErrorLevel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeVersion";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "markSettingsMerged";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectDependentInspections";
                break;
            }
            case 30: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTool";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getUnwrappedTool";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "modifyProfile";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "modifyToolSettings";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getToolById";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findToolsById";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setSingleTool";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "disableToolByDefault";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getToolDefaultState";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "enableToolsByDefault";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addTool";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "enableTool";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "enableTools";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "disableTools";
                break;
            }
            case 65: 
            case 66: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "setErrorLevel";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getNonDefaultTools";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isToolEnabled";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "removeScope";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "removeScopes";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addScope";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getToolsOrNull";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modifyToolSettings$1";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modifyProfile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 52: 
            case 56: 
            case 69: 
            case 70: 
            case 72: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

