/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IdentifierHighlighterPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass");
    private final PsiFile myFile;
    private final Editor myEditor;
    private final Collection<TextRange> myReadAccessRanges;
    private final Collection<TextRange> myWriteAccessRanges;
    private final int myCaretOffset;
    private final HighlightUsagesHandlerBase<PsiElement> myHighlightUsagesHandler;

    IdentifierHighlighterPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (project == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(2);
        }
        super(project, editor.getDocument(), false);
        this.myReadAccessRanges = Collections.synchronizedList(new ArrayList());
        this.myWriteAccessRanges = Collections.synchronizedList(new ArrayList());
        this.myFile = file2;
        this.myEditor = editor;
        this.myCaretOffset = this.myEditor.getCaretModel().getOffset();
        this.myHighlightUsagesHandler = HighlightUsagesHandler.createCustomHandler(this.myEditor, this.myFile);
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        PsiElement myTarget;
        if (progress == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(3);
        }
        if (this.myHighlightUsagesHandler != null) {
            List<PsiElement> targets = this.myHighlightUsagesHandler.getTargets();
            this.myHighlightUsagesHandler.computeUsages(targets);
            List<TextRange> readUsages = this.myHighlightUsagesHandler.getReadUsages();
            for (TextRange textRange : readUsages) {
                LOG.assertTrue(textRange != null, (Object)("null text range from " + this.myHighlightUsagesHandler));
            }
            this.myReadAccessRanges.addAll(readUsages);
            List<TextRange> writeUsages = this.myHighlightUsagesHandler.getWriteUsages();
            for (TextRange writeUsage : writeUsages) {
                LOG.assertTrue(writeUsage != null, (Object)("null text range from " + this.myHighlightUsagesHandler));
            }
            this.myWriteAccessRanges.addAll(writeUsages);
            if (!this.myHighlightUsagesHandler.highlightReferences()) {
                return;
            }
        }
        int flags = 3;
        try {
            myTarget = TargetElementUtil.getInstance().findTargetElement(this.myEditor, flags, this.myCaretOffset);
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (myTarget == null && !PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument())) {
            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile, this.myCaretOffset);
            myTarget = TargetElementUtil.getInstance().findTargetElement(injectedEditor, flags, injectedEditor.getCaretModel().getOffset());
        }
        if (myTarget != null) {
            this.highlightTargetUsages(myTarget);
        } else {
            PsiReference ref = TargetElementUtil.findReference(this.myEditor);
            if (ref instanceof PsiPolyVariantReference) {
                if (!ref.getElement().isValid()) {
                    throw new PsiInvalidElementAccessException(ref.getElement(), "Invalid element in " + ref + " of " + ref.getClass() + "; editor=" + this.myEditor);
                }
                ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)ref).multiResolve(false);
                if (resolveResultArray.length > 0) {
                    for (ResolveResult result2 : resolveResultArray) {
                        PsiElement target2 = result2.getElement();
                        if (target2 == null) continue;
                        if (!target2.isValid()) {
                            throw new PsiInvalidElementAccessException(target2, "Invalid element returned from " + ref + " of " + ref.getClass() + "; editor=" + this.myEditor);
                        }
                        this.highlightTargetUsages(target2);
                    }
                }
            }
        }
    }

    @NotNull
    public static Couple<Collection<TextRange>> getHighlightUsages(@NotNull PsiElement target2, PsiElement psiElement, boolean withDeclarations) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(4);
        }
        Couple<Collection<TextRange>> couple = IdentifierHighlighterPass.getUsages(target2, psiElement, withDeclarations, true);
        if (couple == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(5);
        }
        return couple;
    }

    @NotNull
    public static Collection<TextRange> getUsages(@NotNull PsiElement target2, PsiElement psiElement, boolean withDeclarations) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(6);
        }
        Collection collection = (Collection)IdentifierHighlighterPass.getUsages((PsiElement)target2, (PsiElement)psiElement, (boolean)withDeclarations, (boolean)false).first;
        if (collection == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    private static Couple<Collection<TextRange>> getUsages(@NotNull PsiElement target2, PsiElement psiElement, boolean withDeclarations, boolean detectAccess) {
        TextRange declRange;
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(8);
        }
        ArrayList<TextRange> readRanges = new ArrayList<TextRange>();
        ArrayList<TextRange> writeRanges = new ArrayList<TextRange>();
        ReadWriteAccessDetector detector = detectAccess ? ReadWriteAccessDetector.findDetector((PsiElement)target2) : null;
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)target2.getProject())).getFindUsagesManager();
        FindUsagesHandler findUsagesHandler = findUsagesManager.getFindUsagesHandler(target2, true);
        LocalSearchScope scope = new LocalSearchScope(psiElement);
        Collection refs = findUsagesHandler != null ? findUsagesHandler.findReferencesToHighlight(target2, (SearchScope)scope) : ReferencesSearch.search((PsiElement)target2, (SearchScope)scope).findAll();
        for (PsiReference psiReference : refs) {
            if (psiReference == null) {
                LOG.error("Null reference returned, findUsagesHandler=" + findUsagesHandler + "; target=" + target2 + " of " + target2.getClass());
                continue;
            }
            ArrayList<TextRange> destination = detector == null || detector.getReferenceAccess(target2, psiReference) == ReadWriteAccessDetector.Access.Read ? readRanges : writeRanges;
            HighlightUsagesHandler.collectRangesToHighlight(psiReference, destination);
        }
        if (withDeclarations && (declRange = HighlightUsagesHandler.getNameIdentifierRange(psiElement.getContainingFile(), target2)) != null) {
            if (detector != null && detector.isDeclarationWriteAccess(target2)) {
                writeRanges.add(declRange);
            } else {
                readRanges.add(declRange);
            }
        }
        Couple couple = Couple.of(readRanges, writeRanges);
        if (couple == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(9);
        }
        return couple;
    }

    private void highlightTargetUsages(@NotNull PsiElement target2) {
        if (target2 == null) {
            IdentifierHighlighterPass.$$$reportNull$$$0(10);
        }
        Couple<Collection<TextRange>> usages = IdentifierHighlighterPass.getHighlightUsages(target2, (PsiElement)this.myFile, true);
        this.myReadAccessRanges.addAll((Collection)usages.first);
        this.myWriteAccessRanges.addAll((Collection)usages.second);
    }

    @Override
    public void doApplyInformationToEditor() {
        boolean virtSpace = TargetElementUtil.inVirtualSpace(this.myEditor, this.myEditor.getCaretModel().getOffset());
        List<HighlightInfo> infos = virtSpace ? Collections.emptyList() : this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getColorsScheme(), this.getId());
    }

    private List<HighlightInfo> getHighlights() {
        if (this.myReadAccessRanges.isEmpty() && this.myWriteAccessRanges.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Pair<Object, TextRange>> existingMarkupTooltips = new HashSet<Pair<Object, TextRange>>();
        for (RangeHighlighter highlighter : this.myEditor.getMarkupModel().getAllHighlighters()) {
            existingMarkupTooltips.add(Pair.create((Object)highlighter.getErrorStripeTooltip(), (Object)new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset())));
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>(this.myReadAccessRanges.size() + this.myWriteAccessRanges.size());
        for (TextRange range : this.myReadAccessRanges) {
            ContainerUtil.addIfNotNull(result2, (Object)this.createHighlightInfo(range, HighlightInfoType.ELEMENT_UNDER_CARET_READ, existingMarkupTooltips));
        }
        for (TextRange range : this.myWriteAccessRanges) {
            ContainerUtil.addIfNotNull(result2, (Object)this.createHighlightInfo(range, HighlightInfoType.ELEMENT_UNDER_CARET_WRITE, existingMarkupTooltips));
        }
        return result2;
    }

    private HighlightInfo createHighlightInfo(TextRange range, HighlightInfoType type, Set<Pair<Object, TextRange>> existingMarkupTooltips) {
        int start = range.getStartOffset();
        String tooltip = start <= this.myDocument.getTextLength() ? HighlightHandlerBase.getLineTextErrorStripeTooltip(this.myDocument, start, false) : null;
        String unescapedTooltip = existingMarkupTooltips.contains(new Pair((Object)tooltip, (Object)range)) ? null : tooltip;
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(type).range(range);
        if (unescapedTooltip != null) {
            builder.unescapedToolTip(unescapedTooltip);
        }
        return builder.createUnconditionally();
    }

    public static void clearMyHighlights(Document document, Project project) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument(document, project, true);
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            Object tooltip = highlighter.getErrorStripeTooltip();
            if (!(tooltip instanceof HighlightInfo)) continue;
            HighlightInfo info = (HighlightInfo)tooltip;
            if (info.type != HighlightInfoType.ELEMENT_UNDER_CARET_READ && info.type != HighlightInfoType.ELEMENT_UNDER_CARET_WRITE) continue;
            highlighter.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/IdentifierHighlighterPass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightUsages";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightUsages";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "highlightTargetUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

