/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleManager;

public class XmlClosingTagInsertHandler
implements InsertHandler<LookupElement> {
    public static final XmlClosingTagInsertHandler INSTANCE = new XmlClosingTagInsertHandler();

    private XmlClosingTagInsertHandler() {
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        Project project = context.getProject();
        if (item instanceof LookupElementDecorator) {
            ((LookupElementDecorator)item).getDelegate().handleInsert(context);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int lineOffset = document.getLineStartOffset(document.getLineNumber(editor.getCaretModel().getOffset()));
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, lineOffset);
    }
}

