/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.Nullable;

public interface ElementFilter<T> {
    public boolean shouldBeShowing(T var1);

    public static interface Listener<T> {
        public ActionCallback update(@Nullable T var1, boolean var2, boolean var3);
    }

    public static interface Active<T>
    extends ElementFilter<T> {
        public ActionCallback fireUpdate(@Nullable T var1, boolean var2, boolean var3);

        public void addListener(Listener<T> var1, Disposable var2);

        public static abstract class Impl<T>
        implements Active<T> {
            Set<Listener<T>> myListeners = new CopyOnWriteArraySet<Listener<T>>();

            @Override
            public ActionCallback fireUpdate(@Nullable T preferredSelection, boolean adjustSelection, boolean now) {
                ActionCallback result = new ActionCallback(this.myListeners.size());
                for (Listener<T> myListener : this.myListeners) {
                    myListener.update(preferredSelection, adjustSelection, now).doWhenProcessed(result.createSetDoneRunnable());
                }
                return result;
            }

            @Override
            public void addListener(final Listener<T> listener, Disposable parent) {
                this.myListeners.add(listener);
                Disposer.register((Disposable)parent, (Disposable)new Disposable(){

                    public void dispose() {
                        myListeners.remove(listener);
                    }
                });
            }
        }
    }
}

