/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.FontMetrics;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class RealLookupElementPresentation
extends LookupElementPresentation {
    private final int myMaximumWidth;
    private final FontMetrics myNormalMetrics;
    private final FontMetrics myBoldMetrics;
    private final Lookup myLookup;

    public RealLookupElementPresentation(int maximumWidth, FontMetrics normalMetrics, FontMetrics boldMetrics, Lookup lookup) {
        this.myMaximumWidth = maximumWidth;
        this.myNormalMetrics = normalMetrics;
        this.myBoldMetrics = boldMetrics;
        this.myLookup = lookup;
    }

    public boolean isLookupSelectionTouched() {
        return this.myLookup.isSelectionTouched();
    }

    @Override
    public boolean isReal() {
        return true;
    }

    public boolean hasEnoughSpaceFor(@Nullable String text, boolean bold) {
        return this.myMaximumWidth >= RealLookupElementPresentation.calculateWidth(this, this.myNormalMetrics, this.myBoldMetrics) + RealLookupElementPresentation.getStringWidth(text, bold ? this.myBoldMetrics : this.myNormalMetrics);
    }

    public static int calculateWidth(LookupElementPresentation presentation, FontMetrics normalMetrics, FontMetrics boldMetrics) {
        int result = 0;
        result += RealLookupElementPresentation.getStringWidth(presentation.getItemText(), presentation.isItemTextBold() ? boldMetrics : normalMetrics);
        result += RealLookupElementPresentation.getStringWidth(presentation.getTailText(), normalMetrics);
        String typeText = presentation.getTypeText();
        if (StringUtil.isNotEmpty((String)typeText)) {
            result += RealLookupElementPresentation.getStringWidth("W", normalMetrics);
            result += RealLookupElementPresentation.getStringWidth(typeText, normalMetrics);
        }
        result += RealLookupElementPresentation.getStringWidth("W", boldMetrics);
        Icon typeIcon = presentation.getTypeIcon();
        if (typeIcon != null) {
            result += typeIcon.getIconWidth();
        }
        return result;
    }

    public static int getStringWidth(@Nullable String text, FontMetrics metrics) {
        if (text != null) {
            return metrics.stringWidth(text);
        }
        return 0;
    }
}

