/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.svnkit.lowLevel;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.io.IOException;
import java.io.OutputStream;

public class SVNStoppableOutputStream
extends OutputStream {
    private final OutputStream myLogStream;

    public SVNStoppableOutputStream(OutputStream logStream) {
        this.myLogStream = logStream;
    }

    @Override
    public void write(int b) throws IOException {
        this.check();
        this.myLogStream.write(b);
    }

    @Override
    public void close() throws IOException {
        this.check();
        this.myLogStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.check();
        this.myLogStream.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.check();
        this.myLogStream.write(b, off, len);
    }

    private void check() throws IOException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null && indicator.isCanceled()) {
            throw new IOException("Write request to canceled by user");
        }
    }
}

