/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.revert;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.FileStatusResultParser;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.revert.RevertClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdRevertClient
extends BaseSvnClient
implements RevertClient {
    private static final String STATUS = "\\s*(.+?)\\s*";
    private static final String PATH = "\\s*'(.*?)'\\s*";
    private static final String OPTIONAL_COMMENT = "(.*)";
    private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(.+?)\\s*\\s*'(.*?)'\\s*(.*)");

    @Override
    public void revert(@NotNull Collection<File> paths, @Nullable Depth depth, @Nullable ProgressTracker handler) throws VcsException {
        if (paths == null) {
            CmdRevertClient.$$$reportNull$$$0(0);
        }
        if (!ContainerUtil.isEmpty(paths)) {
            Command command = this.newCommand(SvnCommandName.revert);
            command.put(depth);
            command.setTargets(paths);
            SvnTarget target = SvnTarget.fromFile((File)((File)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(paths))));
            CommandExecutor executor = this.execute(this.myVcs, target, CommandUtil.getHomeDirectory(), command, null);
            FileStatusResultParser parser = new FileStatusResultParser(CHANGED_PATH, handler, new RevertStatusConvertor());
            parser.parse(executor.getOutput());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/svn/revert/CmdRevertClient", "revert"));
    }

    private static class RevertStatusConvertor
    implements Convertor<Matcher, ProgressEvent> {
        private RevertStatusConvertor() {
        }

        public ProgressEvent convert(@NotNull Matcher matcher) {
            if (matcher == null) {
                RevertStatusConvertor.$$$reportNull$$$0(0);
            }
            String statusMessage = matcher.group(1);
            String path = matcher.group(2);
            return CmdRevertClient.createEvent(new File(path), RevertStatusConvertor.createAction(statusMessage));
        }

        @Nullable
        public static EventAction createAction(@NotNull String code) {
            if (code == null) {
                RevertStatusConvertor.$$$reportNull$$$0(1);
            }
            EventAction result = null;
            if ("Reverted".equals(code)) {
                result = EventAction.REVERT;
            } else if ("Failed to revert".equals(code)) {
                result = EventAction.FAILED_REVERT;
            } else if ("Skipped".equals(code)) {
                result = EventAction.SKIP;
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/revert/CmdRevertClient$RevertStatusConvertor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convert";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

