/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TarUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.TarUtil");

    private TarUtil() {
    }

    @NotNull
    public static TarArchiveOutputStream getTarGzOutputStream(File zipFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile);
        GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)fos);
        TarArchiveOutputStream zip = new TarArchiveOutputStream((OutputStream)gcos);
        zip.setLongFileMode(3);
        TarArchiveOutputStream tarArchiveOutputStream = zip;
        if (tarArchiveOutputStream == null) {
            TarUtil.$$$reportNull$$$0(0);
        }
        return tarArchiveOutputStream;
    }

    public static boolean addFileToTar(@NotNull TarArchiveOutputStream tos, @NotNull File file, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        if (tos == null) {
            TarUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TarUtil.$$$reportNull$$$0(2);
        }
        if (relativeName == null) {
            TarUtil.$$$reportNull$$$0(3);
        }
        return TarUtil.addFileToTar(tos, file, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileToTar(@NotNull TarArchiveOutputStream tos, @NotNull File file, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor) throws IOException {
        if (tos == null) {
            TarUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            TarUtil.$$$reportNull$$$0(5);
        }
        if (relativeName == null) {
            TarUtil.$$$reportNull$$$0(6);
        }
        if (contentProcessor == null) {
            TarUtil.$$$reportNull$$$0(7);
        }
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        boolean isDir = file.isDirectory();
        if (isDir) {
            return true;
        }
        if (fileFilter != null && !FileUtil.isFilePathAcceptable(file, fileFilter)) {
            return false;
        }
        if (writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file + " as " + relativeName);
        }
        long size = file.length();
        TarArchiveEntry e = new TarArchiveEntry(relativeName);
        e.setModTime(file.lastModified());
        e.setSize(size);
        tos.putArchiveEntry((ArchiveEntry)e);
        InputStream is = contentProcessor.getContent(file);
        try {
            FileUtil.copy(is, (OutputStream)tos);
        }
        finally {
            is.close();
        }
        tos.closeArchiveEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull TarArchiveOutputStream tarOutputStream, @Nullable File tarFile, @NotNull File file, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (tarOutputStream == null) {
            TarUtil.$$$reportNull$$$0(8);
        }
        if (file == null) {
            TarUtil.$$$reportNull$$$0(9);
        }
        if (relativePath == null) {
            TarUtil.$$$reportNull$$$0(10);
        }
        if (file.isDirectory()) {
            return TarUtil.addDirToTarRecursively(tarOutputStream, tarFile, file, relativePath, fileFilter, writtenItemRelativePaths);
        }
        TarUtil.addFileToTar(tarOutputStream, file, relativePath, writtenItemRelativePaths, fileFilter);
        return true;
    }

    public static boolean addDirToTarRecursively(@NotNull TarArchiveOutputStream outputStream, @Nullable File tarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children;
        if (outputStream == null) {
            TarUtil.$$$reportNull$$$0(11);
        }
        if (dir == null) {
            TarUtil.$$$reportNull$$$0(12);
        }
        if (relativePath == null) {
            TarUtil.$$$reportNull$$$0(13);
        }
        if (tarFile != null && FileUtil.isAncestor(dir, tarFile, false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            TarUtil.addFileToTar(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter);
        }
        if ((children = dir.listFiles()) != null) {
            for (File child : children) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                TarUtil.addFileOrDirRecursively(outputStream, tarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    public static void extract(@NotNull File file, @NotNull File outputDir, @Nullable FilenameFilter filenameFilter) throws IOException {
        if (file == null) {
            TarUtil.$$$reportNull$$$0(14);
        }
        if (outputDir == null) {
            TarUtil.$$$reportNull$$$0(15);
        }
        TarUtil.extract(file, outputDir, filenameFilter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(@NotNull File file, @NotNull File outputDir, @Nullable FilenameFilter filenameFilter, boolean overwrite) throws IOException {
        if (file == null) {
            TarUtil.$$$reportNull$$$0(16);
        }
        if (outputDir == null) {
            TarUtil.$$$reportNull$$$0(17);
        }
        FileInputStream fis = new FileInputStream(file);
        GzipCompressorInputStream gcis = new GzipCompressorInputStream((InputStream)fis);
        TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)gcis);
        try {
            TarUtil.extract(tis, outputDir, filenameFilter, overwrite);
        }
        finally {
            fis.close();
        }
    }

    public static void extract(@NotNull TarArchiveInputStream tis, @NotNull File outputDir, @Nullable FilenameFilter filenameFilter) throws IOException {
        if (tis == null) {
            TarUtil.$$$reportNull$$$0(18);
        }
        if (outputDir == null) {
            TarUtil.$$$reportNull$$$0(19);
        }
        TarUtil.extract(tis, outputDir, filenameFilter, true);
    }

    public static void extract(@NotNull TarArchiveInputStream tis, @NotNull File outputDir, @Nullable FilenameFilter filenameFilter, boolean overwrite) throws IOException {
        TarArchiveEntry entry;
        if (tis == null) {
            TarUtil.$$$reportNull$$$0(20);
        }
        if (outputDir == null) {
            TarUtil.$$$reportNull$$$0(21);
        }
        while ((entry = tis.getNextTarEntry()) != null) {
            File file = new File(outputDir, entry.getName());
            if (filenameFilter != null && !filenameFilter.accept(file.getParentFile(), file.getName())) continue;
            TarUtil.extractEntry(entry, (InputStream)tis, outputDir, overwrite);
        }
    }

    public static void extractEntry(TarArchiveEntry entry, InputStream inputStream, File outputDir) throws IOException {
        TarUtil.extractEntry(entry, inputStream, outputDir, true);
    }

    public static void extractEntry(TarArchiveEntry entry, InputStream inputStream, File outputDir, boolean overwrite) throws IOException {
        boolean isDirectory = entry.isDirectory();
        String relativeName = entry.getName();
        File file = new File(outputDir, relativeName);
        if (file.exists() && !overwrite) {
            return;
        }
        FileUtil.createParentDirs(file);
        if (isDirectory) {
            file.mkdir();
        } else {
            int count;
            if (entry.getSize() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Tar entries bigger then 2147483647 aren't supported");
            }
            int len = (int)entry.getSize();
            byte[] content = new byte[len];
            for (int n = 0; n < len; n += count) {
                count = inputStream.read(content, n, len - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
            FileUtil.writeToFile(file, content, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(InputStream in, OutputStream out, Map<String, File> relpathToFile) throws IOException {
        TarArchiveInputStream tis = new TarArchiveInputStream(in);
        TarArchiveOutputStream tos = new TarArchiveOutputStream(out);
        try {
            TarArchiveEntry e;
            while ((e = tis.getNextTarEntry()) != null) {
                String name = e.getName();
                if (!relpathToFile.containsKey(name)) {
                    TarArchiveEntry e2 = new TarArchiveEntry(name);
                    e2.setModTime(e.getModTime());
                    e2.setSize(e.getSize());
                    tos.putArchiveEntry((ArchiveEntry)e2);
                    FileUtil.copy((InputStream)tis, (OutputStream)tos);
                    continue;
                }
                File file = relpathToFile.get(name);
                relpathToFile.remove(name);
                TarUtil.addFileToTar(tos, file, name, null, null);
            }
            for (String path : relpathToFile.keySet()) {
                File file = relpathToFile.get(path);
                TarUtil.addFileToTar(tos, file, path, null, null);
            }
        }
        finally {
            tis.close();
            tos.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/TarUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tos";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarOutputStream";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarGzOutputStream";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/TarUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFileToTar";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFileOrDirRecursively";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addDirToTarRecursively";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(File file) throws IOException {
                return new FileInputStream(file);
            }
        };

        public InputStream getContent(File var1) throws IOException;
    }
}

