/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.util.ui.RegionPainter;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public enum RectanglePainter implements RegionPainter<Integer>
{
    DRAW{

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Integer round) {
            int sw = 1;
            int dw = sw + sw;
            if (width > dw && height > dw) {
                int arc;
                int n = arc = round == null ? 0 : round;
                if (arc > 0) {
                    Path2D.Double path = new Path2D.Double(0);
                    path.append(new RoundRectangle2D.Double(x, y, width, height, arc, arc), false);
                    path.append(new RoundRectangle2D.Double(x + sw, y + sw, width - dw, height - dw, arc - dw, arc - dw), false);
                    Object old = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.fill(path);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
                } else {
                    Path2D.Double path = new Path2D.Double(0);
                    path.append(new Rectangle2D.Double(x, y, width, height), false);
                    path.append(new Rectangle2D.Double(x + sw, y + sw, width - dw, height - dw), false);
                    g.fill(path);
                }
            } else {
                FILL.paint(g, x, y, width, height, round);
            }
        }
    }
    ,
    FILL{

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Integer round) {
            if (width > 0 && height > 0) {
                int arc;
                int n = arc = round == null ? 0 : round;
                if (arc > 0) {
                    Object old = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.fillRoundRect(x, y, width, height, arc, arc);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
                } else {
                    g.fillRect(x, y, width, height);
                }
            }
        }
    };


    public static void paint(Graphics2D g, int x, int y, int width, int height, int arc, Paint fill, Paint draw) {
        if (fill != null) {
            g.setPaint(fill);
            if (draw != null) {
                int sw = 1;
                int dw = sw + sw;
                FILL.paint(g, x + sw, y + sw, width - dw, height - dw, arc - dw);
            } else {
                FILL.paint(g, x, y, width, height, arc);
            }
        }
        if (draw != null) {
            g.setPaint(draw);
            DRAW.paint(g, x, y, width, height, arc);
        }
    }
}

