/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * distance(0.0lf, 0.0lf) => 0.0lf
 * distance(0.0lf, -1.3333333333333333lf) => 1.3333333333333333lf
 * distance(0.0lf, 0.84999999999999998lf) => 0.84999999999999998lf
 * distance(-1.3333333333333333lf, 0.0lf) => 1.3333333333333333lf
 * distance(-1.3333333333333333lf, -1.3333333333333333lf) => 0.0lf
 * distance(-1.3333333333333333lf, 0.84999999999999998lf) => 2.1833333333333331lf
 * distance(0.84999999999999998lf, 0.0lf) => 0.84999999999999998lf
 * distance(0.84999999999999998lf, -1.3333333333333333lf) => 2.1833333333333331lf
 * distance(0.84999999999999998lf, 0.84999999999999998lf) => 0.0lf
 */
#version 400

void main()
{
  double[0.0 <= distance(0.0lf, 0.0lf) && distance(0.0lf, 0.0lf) <= 0.0 ? 1 : -1] array0;
  double[1.33332 <= distance(0.0lf, -1.3333333333333333lf) && distance(0.0lf, -1.3333333333333333lf) <= 1.33334666667 ? 1 : -1] array1;
  double[0.8499915 <= distance(0.0lf, 0.84999999999999998lf) && distance(0.0lf, 0.84999999999999998lf) <= 0.8500085 ? 1 : -1] array2;
  double[1.33332 <= distance(-1.3333333333333333lf, 0.0lf) && distance(-1.3333333333333333lf, 0.0lf) <= 1.33334666667 ? 1 : -1] array3;
  double[0.0 <= distance(-1.3333333333333333lf, -1.3333333333333333lf) && distance(-1.3333333333333333lf, -1.3333333333333333lf) <= 0.0 ? 1 : -1] array4;
  double[2.1833115 <= distance(-1.3333333333333333lf, 0.84999999999999998lf) && distance(-1.3333333333333333lf, 0.84999999999999998lf) <= 2.18335516667 ? 1 : -1] array5;
  double[0.8499915 <= distance(0.84999999999999998lf, 0.0lf) && distance(0.84999999999999998lf, 0.0lf) <= 0.8500085 ? 1 : -1] array6;
  double[2.1833115 <= distance(0.84999999999999998lf, -1.3333333333333333lf) && distance(0.84999999999999998lf, -1.3333333333333333lf) <= 2.18335516667 ? 1 : -1] array7;
  double[0.0 <= distance(0.84999999999999998lf, 0.84999999999999998lf) && distance(0.84999999999999998lf, 0.84999999999999998lf) <= 0.0 ? 1 : -1] array8;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
