/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Declare a flat interpolation uvec4 array inside a struct in an interface block.
 *
 * The OpenGL Shading Language 1.50 spec states:
 *
 *    "4.3.4 Inputs
 *    ...
 *        Fragment shader inputs that are signed or unsigned integers
 *        or integer vectors must be qualified with the interpolation
 *        qualifier flat."
 */

#version 150

struct S {
	uvec4 u[4];
};

in IB {
	flat S s;
};
out vec4 color;

void main()
{
	color = vec4(s.u[3]);
}
