/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * roundEven(vec2(-2.0, -1.8333334)) => vec2(-2.0, -2.0)
 * roundEven(vec2(-1.6666666, -1.5)) => vec2(-2.0, -2.0)
 * roundEven(vec2(-1.3333334, -1.1666666)) => vec2(-1.0, -1.0)
 * roundEven(vec2(-1.0, -0.83333331)) => vec2(-1.0, -1.0)
 * roundEven(vec2(-0.66666669, -0.5)) => vec2(-1.0, -0.0)
 * roundEven(vec2(-0.33333334, -0.16666667)) => vec2(-0.0, -0.0)
 * roundEven(vec2(0.0, 0.16666667)) => vec2(0.0, 0.0)
 * roundEven(vec2(0.33333334, 0.5)) => vec2(0.0, 0.0)
 * roundEven(vec2(0.66666669, 0.83333331)) => vec2(1.0, 1.0)
 * roundEven(vec2(1.0, 1.1666666)) => vec2(1.0, 1.0)
 * roundEven(vec2(1.3333334, 1.5)) => vec2(1.0, 2.0)
 * roundEven(vec2(1.6666666, 1.8333334)) => vec2(2.0, 2.0)
 * roundEven(vec2(2.0, -2.0)) => vec2(2.0, -2.0)
 */
#version 150

void main()
{
  float[distance(roundEven(vec2(-2.0, -1.8333334)), vec2(-2.0, -2.0)) <= 2.828427e-05 ? 1 : -1] array0;
  float[distance(roundEven(vec2(-1.6666666, -1.5)), vec2(-2.0, -2.0)) <= 2.828427e-05 ? 1 : -1] array1;
  float[distance(roundEven(vec2(-1.3333334, -1.1666666)), vec2(-1.0, -1.0)) <= 1.4142135e-05 ? 1 : -1] array2;
  float[distance(roundEven(vec2(-1.0, -0.83333331)), vec2(-1.0, -1.0)) <= 1.4142135e-05 ? 1 : -1] array3;
  float[distance(roundEven(vec2(-0.66666669, -0.5)), vec2(-1.0, -0.0)) <= 9.9999997e-06 ? 1 : -1] array4;
  float[distance(roundEven(vec2(-0.33333334, -0.16666667)), vec2(-0.0, -0.0)) <= 0.0 ? 1 : -1] array5;
  float[distance(roundEven(vec2(0.0, 0.16666667)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array6;
  float[distance(roundEven(vec2(0.33333334, 0.5)), vec2(0.0, 0.0)) <= 0.0 ? 1 : -1] array7;
  float[distance(roundEven(vec2(0.66666669, 0.83333331)), vec2(1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array8;
  float[distance(roundEven(vec2(1.0, 1.1666666)), vec2(1.0, 1.0)) <= 1.4142135e-05 ? 1 : -1] array9;
  float[distance(roundEven(vec2(1.3333334, 1.5)), vec2(1.0, 2.0)) <= 2.236068e-05 ? 1 : -1] array10;
  float[distance(roundEven(vec2(1.6666666, 1.8333334)), vec2(2.0, 2.0)) <= 2.828427e-05 ? 1 : -1] array11;
  float[distance(roundEven(vec2(2.0, -2.0)), vec2(2.0, -2.0)) <= 2.828427e-05 ? 1 : -1] array12;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length());
}
