/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sign(vec2(-1.5, -0.75)) => vec2(-1.0, -1.0)
 * sign(vec2(0.0, 0.75)) => vec2(0.0, 1.0)
 * sign(vec2(1.5, -1.5)) => vec2(1.0, -1.0)
 */
#version 120

void main()
{
  float[distance(sign(vec2(-1.5, -0.75)), vec2(-1.0, -1.0)) <= 1.4142135e-05 ? 1 : -1] array0;
  float[distance(sign(vec2(0.0, 0.75)), vec2(0.0, 1.0)) <= 9.9999997e-06 ? 1 : -1] array1;
  float[distance(sign(vec2(1.5, -1.5)), vec2(1.0, -1.0)) <= 1.4142135e-05 ? 1 : -1] array2;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length());
}
