/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0 <= 0.0) => true
 * (0.0 <= -1.33) => false
 * (0.0 <= 0.85000002) => true
 * (-1.33 <= 0.0) => true
 * (-1.33 <= -1.33) => true
 * (-1.33 <= 0.85000002) => true
 * (0.85000002 <= 0.0) => false
 * (0.85000002 <= -1.33) => false
 * (0.85000002 <= 0.85000002) => true
 */
#version 120

void main()
{
  float[(0.0 <= 0.0) == true ? 1 : -1] array0;
  float[(0.0 <= -1.33) == false ? 1 : -1] array1;
  float[(0.0 <= 0.85000002) == true ? 1 : -1] array2;
  float[(-1.33 <= 0.0) == true ? 1 : -1] array3;
  float[(-1.33 <= -1.33) == true ? 1 : -1] array4;
  float[(-1.33 <= 0.85000002) == true ? 1 : -1] array5;
  float[(0.85000002 <= 0.0) == false ? 1 : -1] array6;
  float[(0.85000002 <= -1.33) == false ? 1 : -1] array7;
  float[(0.85000002 <= 0.85000002) == true ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
