/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mod(-1.9, -2.0) => -1.9
 * mod(-1.9, -0.66666669) => -0.5666666
 * mod(-1.9, 0.66666669) => 0.10000008
 * mod(-1.9, 2.0) => 0.10000002
 * mod(-0.63333333, -2.0) => -0.63333333
 * mod(-0.63333333, -0.66666669) => -0.63333333
 * mod(-0.63333333, 0.66666669) => 0.033333361
 * mod(-0.63333333, 2.0) => 1.3666667
 * mod(0.63333333, -2.0) => -1.3666667
 * mod(0.63333333, -0.66666669) => -0.033333361
 * mod(0.63333333, 0.66666669) => 0.63333333
 * mod(0.63333333, 2.0) => 0.63333333
 * mod(1.9, -2.0) => -0.10000002
 * mod(1.9, -0.66666669) => -0.10000008
 * mod(1.9, 0.66666669) => 0.5666666
 * mod(1.9, 2.0) => 1.9
 */
#version 120

void main()
{
  float[distance(mod(-1.9, -2.0), -1.9) <= 1.8999999e-05 ? 1 : -1] array0;
  float[distance(mod(-1.9, -0.66666669), -0.5666666) <= 5.6666659e-06 ? 1 : -1] array1;
  float[distance(mod(-1.9, 0.66666669), 0.10000008) <= 1.0000008e-06 ? 1 : -1] array2;
  float[distance(mod(-1.9, 2.0), 0.10000002) <= 1.0000002e-06 ? 1 : -1] array3;
  float[distance(mod(-0.63333333, -2.0), -0.63333333) <= 6.3333332e-06 ? 1 : -1] array4;
  float[distance(mod(-0.63333333, -0.66666669), -0.63333333) <= 6.3333332e-06 ? 1 : -1] array5;
  float[distance(mod(-0.63333333, 0.66666669), 0.033333361) <= 3.3333362e-07 ? 1 : -1] array6;
  float[distance(mod(-0.63333333, 2.0), 1.3666667) <= 1.3666667e-05 ? 1 : -1] array7;
  float[distance(mod(0.63333333, -2.0), -1.3666667) <= 1.3666667e-05 ? 1 : -1] array8;
  float[distance(mod(0.63333333, -0.66666669), -0.033333361) <= 3.3333362e-07 ? 1 : -1] array9;
  float[distance(mod(0.63333333, 0.66666669), 0.63333333) <= 6.3333332e-06 ? 1 : -1] array10;
  float[distance(mod(0.63333333, 2.0), 0.63333333) <= 6.3333332e-06 ? 1 : -1] array11;
  float[distance(mod(1.9, -2.0), -0.10000002) <= 1.0000002e-06 ? 1 : -1] array12;
  float[distance(mod(1.9, -0.66666669), -0.10000008) <= 1.0000008e-06 ? 1 : -1] array13;
  float[distance(mod(1.9, 0.66666669), 0.5666666) <= 5.6666659e-06 ? 1 : -1] array14;
  float[distance(mod(1.9, 2.0), 1.9) <= 1.8999999e-05 ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
