/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(-1.5) => 1.5
 * abs(-0.75) => 0.75
 * abs(0.0) => 0.0
 * abs(0.75) => 0.75
 * abs(1.5) => 1.5
 */
#version 120

void main()
{
  float[distance(abs(-1.5), 1.5) <= 1.5e-05 ? 1 : -1] array0;
  float[distance(abs(-0.75), 0.75) <= 7.4999998e-06 ? 1 : -1] array1;
  float[distance(abs(0.0), 0.0) <= 0.0 ? 1 : -1] array2;
  float[distance(abs(0.75), 0.75) <= 7.4999998e-06 ? 1 : -1] array3;
  float[distance(abs(1.5), 1.5) <= 1.5e-05 ? 1 : -1] array4;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
