/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(-1.6996000000000002lf, 0.59910000000000008lf, -0.37070000000000003lf, -3.0952999999999999lf, -2.282lf, 1.5271000000000001lf, 2.6993999999999998lf, -0.92300000000000015lf, -0.24249999999999972lf, -0.35070000000000001lf, 3.2243999999999997lf, 1.0672999999999999lf, 1.5481lf, 0.77849999999999975lf, 1.9302999999999999lf, 3.0768000000000004lf)
 * (dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(-2.5764lf, 1.9141999999999999lf, -2.6744999999999997lf, -4.8693lf, -0.81450000000000011lf, 1.7288000000000006lf, -0.82489999999999997lf, -0.92920000000000003lf, -5.4276999999999997lf, 5.1066000000000003lf, -1.8014999999999994lf, -5.661999999999999lf, 4.4477000000000002lf, -5.4821lf, 1.6588999999999998lf, 6.442800000000001lf)
 * (dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) => dmat4(4.1791lf, -0.44610000000000016lf, 0.37269999999999998lf, 0.52239999999999998lf, 3.2672000000000003lf, 1.9083000000000001lf, -0.44709999999999983lf, 0.28199999999999992lf, 1.254lf, 0.04070000000000018lf, -2.7453999999999996lf, 1.0543lf, -4.9115000000000002lf, 1.3541000000000005lf, -1.1874lf, 0.45169999999999993lf)
 * (dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) => dmat4(4.3132000000000001lf, 0.51589999999999991lf, 3.2852000000000001lf, -0.45200000000000007lf, -0.53859999999999997lf, 1.5998999999999997lf, 2.0245000000000002lf, -0.57410000000000005lf, 5.3720999999999997lf, 4.8570000000000002lf, 6.3730999999999991lf, -2.0289000000000001lf, -4.3868lf, -3.6320000000000001lf, -4.926800000000001lf, 0.27129999999999987lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[(distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-1.6996000000000002lf, 0.59910000000000008lf, -0.37070000000000003lf, -3.0952999999999999lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(-1.6996000000000002lf, 0.59910000000000008lf, -0.37070000000000003lf, -3.0952999999999999lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-2.282lf, 1.5271000000000001lf, 2.6993999999999998lf, -0.92300000000000015lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(-2.282lf, 1.5271000000000001lf, 2.6993999999999998lf, -0.92300000000000015lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.24249999999999972lf, -0.35070000000000001lf, 3.2243999999999997lf, 1.0672999999999999lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(-0.24249999999999972lf, -0.35070000000000001lf, 3.2243999999999997lf, 1.0672999999999999lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(1.5481lf, 0.77849999999999975lf, 1.9302999999999999lf, 3.0768000000000004lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(1.5481lf, 0.77849999999999975lf, 1.9302999999999999lf, 3.0768000000000004lf))) <= 5.6557222900000013e-09lf ? 1 : -1] array0;
  double[(distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-2.5764lf, 1.9141999999999999lf, -2.6744999999999997lf, -4.8693lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(-2.5764lf, 1.9141999999999999lf, -2.6744999999999997lf, -4.8693lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-0.81450000000000011lf, 1.7288000000000006lf, -0.82489999999999997lf, -0.92920000000000003lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-0.81450000000000011lf, 1.7288000000000006lf, -0.82489999999999997lf, -0.92920000000000003lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(-5.4276999999999997lf, 5.1066000000000003lf, -1.8014999999999994lf, -5.661999999999999lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(-5.4276999999999997lf, 5.1066000000000003lf, -1.8014999999999994lf, -5.661999999999999lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(4.4477000000000002lf, -5.4821lf, 1.6588999999999998lf, 6.442800000000001lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(4.4477000000000002lf, -5.4821lf, 1.6588999999999998lf, 6.442800000000001lf))) <= 2.3129907753000001e-08lf ? 1 : -1] array1;
  double[(distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(4.1791lf, -0.44610000000000016lf, 0.37269999999999998lf, 0.52239999999999998lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[0], dvec4(4.1791lf, -0.44610000000000016lf, 0.37269999999999998lf, 0.52239999999999998lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(3.2672000000000003lf, 1.9083000000000001lf, -0.44709999999999983lf, 0.28199999999999992lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[1], dvec4(3.2672000000000003lf, 1.9083000000000001lf, -0.44709999999999983lf, 0.28199999999999992lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(1.254lf, 0.04070000000000018lf, -2.7453999999999996lf, 1.0543lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[2], dvec4(1.254lf, 0.04070000000000018lf, -2.7453999999999996lf, 1.0543lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(-4.9115000000000002lf, 1.3541000000000005lf, -1.1874lf, 0.45169999999999993lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))[3], dvec4(-4.9115000000000002lf, 1.3541000000000005lf, -1.1874lf, 0.45169999999999993lf))) <= 7.0464629060000011e-09lf ? 1 : -1] array2;
  double[(distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(4.3132000000000001lf, 0.51589999999999991lf, 3.2852000000000001lf, -0.45200000000000007lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[0], dvec4(4.3132000000000001lf, 0.51589999999999991lf, 3.2852000000000001lf, -0.45200000000000007lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-0.53859999999999997lf, 1.5998999999999997lf, 2.0245000000000002lf, -0.57410000000000005lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[1], dvec4(-0.53859999999999997lf, 1.5998999999999997lf, 2.0245000000000002lf, -0.57410000000000005lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(5.3720999999999997lf, 4.8570000000000002lf, 6.3730999999999991lf, -2.0289000000000001lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[2], dvec4(5.3720999999999997lf, 4.8570000000000002lf, 6.3730999999999991lf, -2.0289000000000001lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-4.3868lf, -3.6320000000000001lf, -4.926800000000001lf, 0.27129999999999987lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) * dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))[3], dvec4(-4.3868lf, -3.6320000000000001lf, -4.926800000000001lf, 0.27129999999999987lf))) <= 1.9110979752000004e-08lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
