/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, -3.0lf), dvec2(0.0lf, 0.33333333333333331lf)) => dvec2(-2.0lf, -2.3333333333333335lf)
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, -3.0lf), dvec2(0.66666666666666663lf, 1.0lf)) => dvec2(-2.666666666666667lf, -3.0lf)
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(3.0lf, 3.0lf), dvec2(0.0lf, 0.33333333333333331lf)) => dvec2(-2.0lf, -0.33333333333333348lf)
 * mix(dvec2(-2.0lf, -2.0lf), dvec2(3.0lf, 3.0lf), dvec2(0.66666666666666663lf, 1.0lf)) => dvec2(1.3333333333333333lf, 3.0lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, -3.0lf), dvec2(0.0lf, 0.33333333333333331lf)) => dvec2(2.0lf, 0.33333333333333348lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, -3.0lf), dvec2(0.66666666666666663lf, 1.0lf)) => dvec2(-1.3333333333333333lf, -3.0lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(3.0lf, 3.0lf), dvec2(0.0lf, 0.33333333333333331lf)) => dvec2(2.0lf, 2.3333333333333335lf)
 * mix(dvec2(2.0lf, 2.0lf), dvec2(3.0lf, 3.0lf), dvec2(0.66666666666666663lf, 1.0lf)) => dvec2(2.666666666666667lf, 3.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, -3.0lf), dvec2(0.0lf, 0.33333333333333331lf)), dvec2(-2.0lf, -2.3333333333333335lf)) <= 3.0731814857642964e-05lf ? 1 : -1] array0;
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(-3.0lf, -3.0lf), dvec2(0.66666666666666663lf, 1.0lf)), dvec2(-2.666666666666667lf, -3.0lf)) <= 4.0138648595974327e-05lf ? 1 : -1] array1;
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(3.0lf, 3.0lf), dvec2(0.0lf, 0.33333333333333331lf)), dvec2(-2.0lf, -0.33333333333333348lf)) <= 2.0275875100994068e-05lf ? 1 : -1] array2;
  double[distance(mix(dvec2(-2.0lf, -2.0lf), dvec2(3.0lf, 3.0lf), dvec2(0.66666666666666663lf, 1.0lf)), dvec2(1.3333333333333333lf, 3.0lf)) <= 3.2829526005987018e-05lf ? 1 : -1] array3;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, -3.0lf), dvec2(0.0lf, 0.33333333333333331lf)), dvec2(2.0lf, 0.33333333333333348lf)) <= 2.0275875100994068e-05lf ? 1 : -1] array4;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(-3.0lf, -3.0lf), dvec2(0.66666666666666663lf, 1.0lf)), dvec2(-1.3333333333333333lf, -3.0lf)) <= 3.2829526005987018e-05lf ? 1 : -1] array5;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(3.0lf, 3.0lf), dvec2(0.0lf, 0.33333333333333331lf)), dvec2(2.0lf, 2.3333333333333335lf)) <= 3.0731814857642964e-05lf ? 1 : -1] array6;
  double[distance(mix(dvec2(2.0lf, 2.0lf), dvec2(3.0lf, 3.0lf), dvec2(0.66666666666666663lf, 1.0lf)), dvec2(2.666666666666667lf, 3.0lf)) <= 4.0138648595974327e-05lf ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
