/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.XmlDocument;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@JRubyClass(name={"Nokogiri::XML::Text"}, parent="Nokogiri::XML::CharacterData")
public class XmlText
extends XmlNode {
    public XmlText(Ruby ruby, RubyClass rubyClass, Node node) {
        super(ruby, rubyClass, node);
    }

    public XmlText(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @Override
    protected void init(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 2) {
            throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
        }
        this.content = iRubyObjectArray[0];
        IRubyObject iRubyObject = iRubyObjectArray[1];
        XmlNode xmlNode = XmlText.asXmlNode(threadContext, iRubyObject);
        XmlDocument xmlDocument = (XmlDocument)xmlNode.document(threadContext);
        this.doc = xmlDocument;
        Document document = xmlDocument.getDocument();
        Text text = document.createTextNode(NokogiriHelpers.rubyStringToString(this.content));
        this.setNode(threadContext, text);
    }

    @Override
    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name == null) {
            this.name = threadContext.getRuntime().newString("text");
        }
        return this.name;
    }

    @Override
    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        saveContextVisitor.enter((Text)this.node);
        for (Node node = this.node.getFirstChild(); node != null; node = node.getNextSibling()) {
            RubyObject rubyObject;
            IRubyObject iRubyObject = NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
            if (iRubyObject instanceof XmlNode) {
                rubyObject = (XmlNode)iRubyObject;
                rubyObject.accept(threadContext, saveContextVisitor);
                continue;
            }
            if (!(iRubyObject instanceof XmlNamespace)) continue;
            rubyObject = (XmlNamespace)iRubyObject;
            rubyObject.accept(threadContext, saveContextVisitor);
        }
        saveContextVisitor.leave(this.node);
    }
}

