<?php

// Defines the base path on the server relative to the spreedwebrtc plugin 
// and traverse symbolic links if present, terminated by a slash

$path_segments = explode(DIRECTORY_SEPARATOR, dirname($_SERVER['SCRIPT_FILENAME']));
$base_path = implode(DIRECTORY_SEPARATOR, array_splice($path_segments, 0, count($path_segments) - 2));
define('WEBAPP_BASE_PATH', dirname($base_path) . "/");

// Bootstrap the script
require_once(WEBAPP_BASE_PATH.'server/includes/bootstrap.php');

include("webapp_auth_common.php");

// Try to authenticate the user
WebAppAuthentication::authenticate();
if (WebAppAuthentication::isAuthenticated()) {
	$GLOBALS['mapisession'] = WebAppAuthentication::getMapiSession();
	// Instantiate Plugin Manager and init the plugins (btw: globals suck)
	$GLOBALS['PluginManager'] = new PluginManager(ENABLE_PLUGINS);
	$GLOBALS['PluginManager']->detectPlugins(DISABLED_PLUGINS_LIST);
	$GLOBALS['PluginManager']->initPlugins(DEBUG_LOADER);
}

?>