/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DownloadSelectedIncompleteMembersAction
extends AbstractRelationEditorAction {
    public DownloadSelectedIncompleteMembersAction(MemberTable memberTable, MemberTableModel memberTableModel, String actionMapKey, OsmDataLayer layer, IRelationEditor editor) {
        super(memberTable, memberTableModel, actionMapKey, layer, editor);
        this.putValue("ShortDescription", I18n.tr("Download selected incomplete members", new Object[0]));
        new ImageProvider("dialogs/relation", "downloadincompleteselected").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Download Members", new Object[0]));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        MainApplication.worker.submit(new DownloadRelationMemberTask(this.editor.getRelation(), this.memberTableModel.getSelectedIncompleteMemberPrimitives(), this.layer, (Dialog)((Object)this.editor)));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.memberTableModel.hasIncompleteSelectedMembers() && this.canDownload());
    }
}

