/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class ChangesetListModel
extends DefaultListModel<Changeset>
implements ChangesetCacheListener {
    private final transient List<Changeset> data = new ArrayList<Changeset>();
    private final transient Storage<Changeset> shownChangesets = new Storage(true);
    private final DefaultListSelectionModel selectionModel;

    public ChangesetListModel(DefaultListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public Set<Changeset> getSelectedChangesets() {
        HashSet<Changeset> ret = new HashSet<Changeset>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(this.data.get(i));
        }
        return ret;
    }

    public Set<Integer> getSelectedChangesetIds() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(this.data.get(i).getId());
        }
        return ret;
    }

    public void setSelectedChangesets(Collection<Changeset> changesets) {
        this.selectionModel.setValueIsAdjusting(true);
        this.selectionModel.clearSelection();
        if (changesets != null) {
            for (Changeset cs : changesets) {
                int idx = this.data.indexOf(cs);
                if (idx < 0) continue;
                this.selectionModel.addSelectionInterval(idx, idx);
            }
        }
        this.selectionModel.setValueIsAdjusting(false);
    }

    protected void setChangesets(Collection<Changeset> changesets) {
        this.shownChangesets.clear();
        if (changesets != null) {
            this.shownChangesets.addAll(changesets);
        }
        this.updateModel();
    }

    private void updateModel() {
        Set<Changeset> sel = this.getSelectedChangesets();
        this.data.clear();
        this.data.addAll(this.shownChangesets);
        ChangesetCache cache = ChangesetCache.getInstance();
        for (Changeset cs : this.data) {
            if (!cache.contains(cs) || cache.get(cs.getId()) == cs) continue;
            cs.mergeFrom(cache.get(cs.getId()));
        }
        this.sort();
        this.fireIntervalAdded(this, 0, this.getSize());
        this.setSelectedChangesets(sel);
    }

    public void initFromChangesetIds(Collection<Integer> ids) {
        if (ids == null || ids.isEmpty()) {
            this.setChangesets(null);
            return;
        }
        HashSet<Changeset> changesets = new HashSet<Changeset>(ids.size());
        for (int id : ids) {
            if (id <= 0) continue;
            changesets.add(new Changeset(id));
        }
        this.setChangesets(changesets);
    }

    public void initFromPrimitives(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            this.setChangesets(null);
            return;
        }
        HashSet<Changeset> changesets = new HashSet<Changeset>();
        for (OsmPrimitive osmPrimitive : primitives) {
            if (osmPrimitive.getChangesetId() <= 0) continue;
            changesets.add(new Changeset(osmPrimitive.getChangesetId()));
        }
        this.setChangesets(changesets);
    }

    public void initFromDataSet(DataSet ds) {
        if (ds == null) {
            this.setChangesets(null);
            return;
        }
        HashSet<Changeset> changesets = new HashSet<Changeset>();
        for (OsmPrimitive p : ds.allPrimitives()) {
            if (p.getChangesetId() <= 0) continue;
            changesets.add(new Changeset(p.getChangesetId()));
        }
        this.setChangesets(changesets);
    }

    @Override
    public Changeset getElementAt(int idx) {
        return this.data.get(idx);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    protected void sort() {
        this.data.sort(Comparator.comparingInt(Changeset::getId).reversed());
    }

    public boolean hasSelectedOpenChangesets() {
        return !this.getSelectedOpenChangesets().isEmpty();
    }

    public List<Changeset> getSelectedOpenChangesets() {
        ArrayList<Changeset> ret = new ArrayList<Changeset>();
        for (int i = 0; i < this.getSize(); ++i) {
            Changeset cs;
            if (!this.selectionModel.isSelectedIndex(i) || !(cs = this.data.get(i)).isOpen()) continue;
            ret.add(cs);
        }
        return ret;
    }

    @Override
    public void changesetCacheUpdated(ChangesetCacheEvent event) {
        int idx;
        Set<Changeset> sel = this.getSelectedChangesets();
        for (Changeset cs : event.getAddedChangesets()) {
            idx = this.data.indexOf(cs);
            if (idx < 0 || this.data.get(idx) == cs) continue;
            this.data.get(idx).mergeFrom(cs);
        }
        for (Changeset cs : event.getUpdatedChangesets()) {
            idx = this.data.indexOf(cs);
            if (idx < 0 || this.data.get(idx) == cs) continue;
            this.data.get(idx).mergeFrom(cs);
        }
        for (Changeset cs : event.getRemovedChangesets()) {
            idx = this.data.indexOf(cs);
            if (idx < 0) continue;
            this.data.set(idx, new Changeset(cs.getId()));
        }
        GuiHelper.runInEDT(() -> {
            this.fireContentsChanged(this, 0, this.getSize());
            this.setSelectedChangesets(sel);
        });
    }
}

