/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;

public class DiscardTagsHook
implements UploadHook {
    @Override
    public boolean checkUpload(APIDataSet apiDataSet) {
        List<OsmPrimitive> objectsToUpload = apiDataSet.getPrimitives();
        HashSet<String> discardableKeys = new HashSet<String>(OsmPrimitive.getDiscardableKeys());
        boolean needsChange = false;
        block0: for (OsmPrimitive osmPrimitive : objectsToUpload) {
            for (String key : osmPrimitive.keySet()) {
                if (!discardableKeys.contains(key)) continue;
                needsChange = true;
                break block0;
            }
        }
        if (needsChange) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : discardableKeys) {
                map.put(key, null);
            }
            SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Removed obsolete tags", new Object[0]), new ChangePropertyCommand(objectsToUpload, map));
            MainApplication.undoRedo.add(sequenceCommand);
        }
        return true;
    }
}

