/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.spi.CalendarNameProvider;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;

public class CalendarNameProviderImpl
extends CalendarNameProvider
implements AvailableLanguageTags {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;
    private static int[] REST_OF_STYLES = new int[]{32769, 2, 32770, 4, 32772};

    public CalendarNameProviderImpl(LocaleProviderAdapter.Type type, Set<String> set) {
        this.type = type;
        this.langtags = set;
    }

    @Override
    public String getDisplayName(String string, int n, int n2, int n3, Locale locale) {
        return this.getDisplayNameImpl(string, n, n2, n3, locale, false);
    }

    public String getJavaTimeDisplayName(String string, int n, int n2, int n3, Locale locale) {
        return this.getDisplayNameImpl(string, n, n2, n3, locale, true);
    }

    public String getDisplayNameImpl(String string, int n, int n2, int n3, Locale locale, boolean bl) {
        String string2 = null;
        String string3 = this.getResourceKey(string, n, n3, bl);
        if (string3 != null) {
            String[] stringArray;
            LocaleResources localeResources = LocaleProviderAdapter.forType(this.type).getLocaleResources(locale);
            String[] stringArray2 = stringArray = bl ? localeResources.getJavaTimeNames(string3) : localeResources.getCalendarNames(string3);
            if (stringArray != null && stringArray.length > 0) {
                if (n == 7 || n == 1) {
                    --n2;
                }
                if (n2 < 0 || n2 >= stringArray.length) {
                    return null;
                }
                string2 = stringArray[n2];
                if (string2.length() == 0 && (n3 == 32769 || n3 == 32770 || n3 == 32772)) {
                    string2 = this.getDisplayName(string, n, n2, this.getBaseStyle(n3), locale);
                }
            }
        }
        return string2;
    }

    @Override
    public Map<String, Integer> getDisplayNames(String string, int n, int n2, Locale locale) {
        Map<String, Integer> map;
        if (n2 == 0) {
            map = this.getDisplayNamesImpl(string, n, 1, locale, false);
            for (int n3 : REST_OF_STYLES) {
                map.putAll(this.getDisplayNamesImpl(string, n, n3, locale, false));
            }
        } else {
            map = this.getDisplayNamesImpl(string, n, n2, locale, false);
        }
        return map.isEmpty() ? null : map;
    }

    public Map<String, Integer> getJavaTimeDisplayNames(String string, int n, int n2, Locale locale) {
        Map<String, Integer> map = this.getDisplayNamesImpl(string, n, n2, locale, true);
        return map.isEmpty() ? null : map;
    }

    private Map<String, Integer> getDisplayNamesImpl(String string, int n, int n2, Locale locale, boolean bl) {
        String string2 = this.getResourceKey(string, n, n2, bl);
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(LengthBasedComparator.INSTANCE);
        if (string2 != null) {
            String[] stringArray;
            LocaleResources localeResources = LocaleProviderAdapter.forType(this.type).getLocaleResources(locale);
            String[] stringArray2 = stringArray = bl ? localeResources.getJavaTimeNames(string2) : localeResources.getCalendarNames(string2);
            if (stringArray != null && !this.hasDuplicates(stringArray)) {
                if (n == 1) {
                    if (stringArray.length > 0) {
                        treeMap.put(stringArray[0], 1);
                    }
                } else {
                    int n3 = n == 7 ? 1 : 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string3 = stringArray[i];
                        if (string3.length() == 0) continue;
                        treeMap.put(string3, n3 + i);
                    }
                }
            }
        }
        return treeMap;
    }

    private int getBaseStyle(int n) {
        return n & 0xFFFF7FFF;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        if (Locale.ROOT.equals(locale)) {
            return true;
        }
        String string = null;
        if (locale.hasExtensions()) {
            string = locale.getUnicodeLocaleType("ca");
            locale = locale.stripExtensions();
        }
        if (string != null) {
            switch (string) {
                case "buddhist": 
                case "japanese": 
                case "gregory": 
                case "islamic": 
                case "roc": {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.langtags.contains(locale.toLanguageTag())) {
            return true;
        }
        if (this.type == LocaleProviderAdapter.Type.JRE) {
            String string2 = locale.toString().replace('_', '-');
            return this.langtags.contains(string2);
        }
        return false;
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }

    private boolean hasDuplicates(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n - 1; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            for (int j = i + 1; j < n; ++j) {
                if (!string.equals(stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    private String getResourceKey(String string, int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = this.getBaseStyle(n2);
        boolean bl3 = bl2 = n2 != n3;
        if ("gregory".equals(string)) {
            string = null;
        }
        boolean bl4 = n3 == 4;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("java.time.");
        }
        switch (n) {
            case 0: {
                if (string != null) {
                    stringBuilder.append(string).append('.');
                }
                if (bl4) {
                    stringBuilder.append("narrow.");
                } else if (this.type == LocaleProviderAdapter.Type.JRE) {
                    if (bl && n3 == 2) {
                        stringBuilder.append("long.");
                    }
                    if (n3 == 1) {
                        stringBuilder.append("short.");
                    }
                } else if (n3 == 2) {
                    stringBuilder.append("long.");
                }
                stringBuilder.append("Eras");
                break;
            }
            case 1: {
                if (bl4) break;
                stringBuilder.append(string).append(".FirstYear");
                break;
            }
            case 2: {
                if ("islamic".equals(string)) {
                    stringBuilder.append(string).append('.');
                }
                if (bl2) {
                    stringBuilder.append("standalone.");
                }
                stringBuilder.append("Month").append(this.toStyleName(n3));
                break;
            }
            case 7: {
                if (bl2 && bl4) {
                    stringBuilder.append("standalone.");
                }
                stringBuilder.append("Day").append(this.toStyleName(n3));
                break;
            }
            case 9: {
                if (bl4) {
                    stringBuilder.append("narrow.");
                }
                stringBuilder.append("AmPmMarkers");
            }
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    private String toStyleName(int n) {
        switch (n) {
            case 1: {
                return "Abbreviations";
            }
            case 4: {
                return "Narrows";
            }
        }
        return "Names";
    }

    private static class LengthBasedComparator
    implements Comparator<String> {
        private static final LengthBasedComparator INSTANCE = new LengthBasedComparator();

        private LengthBasedComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n = string2.length() - string.length();
            return n == 0 ? string.compareTo(string2) : n;
        }
    }
}

