require=function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f;}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e);},l,l.exports,e,t,n,r);}return n[o].exports;}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s;}({"../audits/accessibility/accesskeys":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Accesskeys extends AxeAudit{static get meta(){return{category:'Accessibility',name:'accesskeys',description:'`[accesskey]` values are unique.',failureDescription:'`[accesskey]` values are not unique.',helpText:'Access keys let users quickly focus a part of the page. For proper '+'navigation, each access key must be unique. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/accesskeys).',requiredArtifacts:['Accessibility']};}}
module.exports=Accesskeys;},{"./axe-audit":1}],"../audits/accessibility/aria-allowed-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAAllowedAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-allowed-attr',description:'`[aria-*]` attributes match their roles.',failureDescription:'`[aria-*]` attributes do not match their roles.',helpText:'Each ARIA `role` supports a specific subset of `aria-*` attributes. '+'Mismatching these invalidates the `aria-*` attributes. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-allowed-attr).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAAllowedAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-required-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIARequiredAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-required-attr',description:'`[role]`s have all required `[aria-*]` attributes.',failureDescription:'`[role]`s do not have all required `[aria-*]` attributes.',helpText:'Some ARIA roles have required attributes that describe the state '+'of the element to screen readers. [Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-attr).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIARequiredAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-required-children":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRequiredChildren extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-required-children',description:'Elements with `[role]` that require specific children `[role]`s, are present.',failureDescription:'Elements with `[role]` that require specific children `[role]`s, '+'are missing.',helpText:'Some ARIA parent roles must contain specific child roles to perform '+'their intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-children).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRequiredChildren;},{"./axe-audit":1}],"../audits/accessibility/aria-required-parent":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRequiredParent extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-required-parent',description:'`[role]`s are contained by their required parent element.',failureDescription:'`[role]`s are not contained by their required parent element.',helpText:'Some ARIA child roles must be contained by specific parent roles to '+'properly perform their intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-parent).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRequiredParent;},{"./axe-audit":1}],"../audits/accessibility/aria-roles":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRoles extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-roles',description:'`[role]` values are valid.',failureDescription:'`[role]` values are not valid.',helpText:'ARIA roles must have valid values in order to perform their '+'intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-roles).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRoles;},{"./axe-audit":1}],"../audits/accessibility/aria-valid-attr-value":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-valid-attr-value',description:'`[aria-*]` attributes have valid values.',failureDescription:'`[aria-*]` attributes do not have valid values.',helpText:'Assistive technologies, like screen readers, can\'t interpret ARIA '+'attributes with invalid values. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-valid-attr-value).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-valid-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-valid-attr',description:'`[aria-*]` attributes are valid and not misspelled.',failureDescription:'`[aria-*]` attributes are not valid or misspelled.',helpText:'Assistive technologies, like screen readers, can\'t interpret ARIA '+'attributes with invalid names. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-valid-attr).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":1}],"../audits/accessibility/audio-caption":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AudioCaption extends AxeAudit{static get meta(){return{category:'Accessibility',name:'audio-caption',description:'`<audio>` elements contain a `<track>` element with `[kind="captions"]`.',failureDescription:'`<audio>` elements are missing a `<track>` element with '+'`[kind="captions"]`.',helpText:'Captions make audio elements usable for deaf or hearing-impaired users, '+'providing critical information such as who is talking, what they\'re saying, '+'and other non-speech information. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/audio-caption).',requiredArtifacts:['Accessibility']};}}
module.exports=AudioCaption;},{"./axe-audit":1}],"../audits/accessibility/button-name":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ButtonName extends AxeAudit{static get meta(){return{category:'Accessibility',name:'button-name',description:'Buttons have an accessible name.',failureDescription:'Buttons do not have an accessible name.',helpText:'When a button doesn\'t have an accessible name, screen readers announce it as '+'"button", making it unusable for users who rely on screen readers. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/button-name).',requiredArtifacts:['Accessibility']};}}
module.exports=ButtonName;},{"./axe-audit":1}],"../audits/accessibility/bypass":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Bypass extends AxeAudit{static get meta(){return{category:'Accessibility',name:'bypass',description:'The page contains a heading, skip link, or landmark region.',failureDescription:'The page does not contain a heading, skip link, or landmark region.',helpText:'Adding ways to bypass repetitive content lets keyboard users navigate the page '+'more efficiently. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/bypass).',requiredArtifacts:['Accessibility']};}}
module.exports=Bypass;},{"./axe-audit":1}],"../audits/accessibility/color-contrast":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ColorContrast extends AxeAudit{static get meta(){return{category:'Accessibility',name:'color-contrast',description:'Background and foreground colors have a sufficient contrast ratio.',failureDescription:'Background and foreground colors do not have a '+'sufficient contrast ratio.',helpText:'Low-contrast text is difficult or impossible for many users to read. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/color-contrast).',requiredArtifacts:['Accessibility']};}}
module.exports=ColorContrast;},{"./axe-audit":1}],"../audits/accessibility/definition-list":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DefinitionList extends AxeAudit{static get meta(){return{category:'Accessibility',name:'definition-list',description:'`<dl>`\'s contain only properly-ordered `<dt>` and `<dd>` groups, `<script>` '+'or `<template>` elements.',failureDescription:'`<dl>`\'s do not contain only properly-ordered `<dt>` and `<dd>` '+'groups, `<script>` or `<template>` elements.',helpText:'When definition lists are not properly marked up, screen readers may produce '+'confusing or inaccurate output. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/definition-list).',requiredArtifacts:['Accessibility']};}}
module.exports=DefinitionList;},{"./axe-audit":1}],"../audits/accessibility/dlitem":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DLItem extends AxeAudit{static get meta(){return{category:'Accessibility',name:'dlitem',description:'Definition list items are wrapped in `<dl>` elements.',failureDescription:'Definition list items are not wrapped in `<dl>` elements.',helpText:'Definition list items (`<dt>` and `<dd>`) must be wrapped in a '+'parent `<dl>` element to ensure that screen readers can properly announce them. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/dlitem).',requiredArtifacts:['Accessibility']};}}
module.exports=DLItem;},{"./axe-audit":1}],"../audits/accessibility/document-title":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DocumentTitle extends AxeAudit{static get meta(){return{category:'Accessibility',name:'document-title',description:'Document has a `<title>` element.',failureDescription:'Document does not have a `<title>` element.',helpText:'Screen reader users use page titles to get an overview of the contents of '+'the page. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/document-title).',requiredArtifacts:['Accessibility']};}}
module.exports=DocumentTitle;},{"./axe-audit":1}],"../audits/accessibility/duplicate-id":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DuplicateId extends AxeAudit{static get meta(){return{category:'Accessibility',name:'duplicate-id',description:'`[id]` attributes on the page are unique.',failureDescription:'`[id]` attributes on the page are not unique.',helpText:'The value of an id attribute must be unique to prevent '+'other instances from being overlooked by assistive technologies. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/duplicate-id).',requiredArtifacts:['Accessibility']};}}
module.exports=DuplicateId;},{"./axe-audit":1}],"../audits/accessibility/frame-title":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class FrameTitle extends AxeAudit{static get meta(){return{category:'Accessibility',name:'frame-title',description:'`<frame>` or `<iframe>` elements have a title.',failureDescription:'`<frame>` or `<iframe>` elements do not have a title.',helpText:'Screen reader users rely on frame titles to describe the contents of frames. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/frame-title).',requiredArtifacts:['Accessibility']};}}
module.exports=FrameTitle;},{"./axe-audit":1}],"../audits/accessibility/html-has-lang":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class HTMLHasLang extends AxeAudit{static get meta(){return{category:'Accessibility',name:'html-has-lang',description:'`<html>` element has a `[lang]` attribute.',failureDescription:'`<html>` element does not have a `[lang]` attribute.',helpText:'If a page doesn\'t specify a lang attribute, a screen reader assumes '+'that the page is in the default language that the user chose when setting up the '+'screen reader. If the page isn\'t actually in the default language, then the screen '+'reader might not announce the page\'s text correctly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/html-lang).',requiredArtifacts:['Accessibility']};}}
module.exports=HTMLHasLang;},{"./axe-audit":1}],"../audits/accessibility/html-lang-valid":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class HTMLLangValid extends AxeAudit{static get meta(){return{category:'Accessibility',name:'html-lang-valid',description:'`<html>` element has a valid value for its `[lang]` attribute.',failureDescription:'`<html>` element does not have a valid value for '+'its `[lang]` attribute.',helpText:'Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) '+'helps screen readers announce text properly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/valid-lang).',requiredArtifacts:['Accessibility']};}}
module.exports=HTMLLangValid;},{"./axe-audit":1}],"../audits/accessibility/image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ImageAlt extends AxeAudit{static get meta(){return{category:'Accessibility',name:'image-alt',description:'Image elements have `[alt]` attributes.',failureDescription:'Image elements do not have `[alt]` attributes.',helpText:'Informative elements should aim for short, descriptive alternate text. '+'Decorative elements can be ignored with an empty alt attribute.'+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/image-alt).',requiredArtifacts:['Accessibility']};}}
module.exports=ImageAlt;},{"./axe-audit":1}],"../audits/accessibility/input-image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class InputImageAlt extends AxeAudit{static get meta(){return{category:'Accessibility',name:'input-image-alt',description:'`<input type="image">` elements have `[alt]` text.',failureDescription:'`<input type="image">` elements do not have `[alt]` text.',helpText:'When an image is being used as an `<input>` button, providing alternative text '+'can help screen reader users understand the purpose of the button. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/input-image-alt).',requiredArtifacts:['Accessibility']};}}
module.exports=InputImageAlt;},{"./axe-audit":1}],"../audits/accessibility/label":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Label extends AxeAudit{static get meta(){return{category:'Accessibility',name:'label',description:'Form elements have associated labels.',failureDescription:'Form elements do not have associated labels.',helpText:'Labels ensure that form controls are announced properly by assistive '+'technologies, like screen readers. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/label).',requiredArtifacts:['Accessibility']};}}
module.exports=Label;},{"./axe-audit":1}],"../audits/accessibility/layout-table":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class LayoutTable extends AxeAudit{static get meta(){return{category:'Accessibility',name:'layout-table',description:'Presentational `<table>` elements avoid using `<th>`, `<caption>` or the '+'`[summary]` attribute.',failureDescription:'Presentational `<table>` elements do not avoid using `<th>`, '+'`<caption>` or the `[summary]` attribute.',helpText:'A table being used for layout purposes should not include data elements, '+'such as the th or caption elements or the summary attribute, because this can '+'create a confusing experience for screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/layout-table).',requiredArtifacts:['Accessibility']};}}
module.exports=LayoutTable;},{"./axe-audit":1}],"../audits/accessibility/link-name":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class LinkName extends AxeAudit{static get meta(){return{category:'Accessibility',name:'link-name',description:'Links have a discernible name.',failureDescription:'Links do not have a discernable name.',helpText:'Link text (and alternate text for images, when used as links) that is '+'discernible, unique, and focusable improves the navigation experience for '+'screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/link-name).',requiredArtifacts:['Accessibility']};}}
module.exports=LinkName;},{"./axe-audit":1}],"../audits/accessibility/listitem":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ListItem extends AxeAudit{static get meta(){return{category:'Accessibility',name:'listitem',description:'List items (`<li>`) are contained within `<ul>` or `<ol>` parent elements.',failureDescription:'List items (`<li>`) are not contained within `<ul>` '+'or `<ol>` parent elements.',helpText:'Screen readers require list items (`<li>`) to be contained within a '+'parent `<ul>` or `<ol>` to be announced properly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/listitem).',requiredArtifacts:['Accessibility']};}}
module.exports=ListItem;},{"./axe-audit":1}],"../audits/accessibility/list":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class List extends AxeAudit{static get meta(){return{category:'Accessibility',name:'list',description:'Lists contain only `<li>` elements and script supporting elements '+'(`<script>` and `<template>`).',failureDescription:'Lists do not contain only `<li>` elements and script '+'supporting elements (`<script>` and `<template>`).',helpText:'Screen readers have a specific way of announcing lists. Ensuring proper list '+'structure aids screen reader output. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/list).',requiredArtifacts:['Accessibility']};}}
module.exports=List;},{"./axe-audit":1}],"../audits/accessibility/meta-refresh":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class MetaRefresh extends AxeAudit{static get meta(){return{category:'Accessibility',name:'meta-refresh',description:'The document does not use `<meta http-equiv="refresh">`.',failureDescription:'The document uses `<meta http-equiv="refresh">`.',helpText:'Users do not expect a page to refresh automatically, and doing so will move '+'focus back to the top of the page. This may create a frustrating or '+'confusing experience. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/meta-refresh).',requiredArtifacts:['Accessibility']};}}
module.exports=MetaRefresh;},{"./axe-audit":1}],"../audits/accessibility/meta-viewport":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class MetaViewport extends AxeAudit{static get meta(){return{category:'Accessibility',name:'meta-viewport',description:'`[user-scalable="no"]` is not used in the `<meta name="viewport">` '+'element and the `[maximum-scale]` attribute is not less than 5.',failureDescription:'`[user-scalable="no"]` is used in the `<meta name="viewport">` '+'element or the `[maximum-scale]` attribute is less than 5.',helpText:'Disabling zooming is problematic for users with low vision who rely on screen '+'magnification to properly see the contents of a web page. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/meta-viewport).',requiredArtifacts:['Accessibility']};}}
module.exports=MetaViewport;},{"./axe-audit":1}],"../audits/accessibility/object-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ObjectAlt extends AxeAudit{static get meta(){return{category:'Accessibility',name:'object-alt',description:'`<object>` elements have `[alt]` text.',failureDescription:'`<object>` elements do not have `[alt]` text.',helpText:'Screen readers cannot translate non-text content. Adding alt text to `<object>` '+'elements helps screen readers convey meaning to users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/object-alt).',requiredArtifacts:['Accessibility']};}}
module.exports=ObjectAlt;},{"./axe-audit":1}],"../audits/accessibility/tabindex":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TabIndex extends AxeAudit{static get meta(){return{category:'Accessibility',name:'tabindex',description:'No element has a `[tabindex]` value greater than 0.',failureDescription:'Some elements have a `[tabindex]` value greater than 0.',helpText:'A value greater than 0 implies an explicit navigation ordering. '+'Although technically valid, this often creates frustrating experiences '+'for users who rely on assistive technologies. [Learn more](https://dequeuniversity.com/rules/axe/2.2/tabindex).',requiredArtifacts:['Accessibility']};}}
module.exports=TabIndex;},{"./axe-audit":1}],"../audits/accessibility/td-headers-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TDHeadersAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'td-headers-attr',description:'Cells in a `<table>` element that use the `[headers]` attribute only refer '+'to other cells of that same table.',failureDescription:'Cells in a `<table>` element that use the `[headers]` '+'attribute refers to other cells of that same table.',helpText:'Screen readers have features to make navigating tables easier. Ensuring `<td>` '+'cells using the `[headers]` attribute only refer to other cells in the same table may '+'improve the experience for screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/td-headers-attr).',requiredArtifacts:['Accessibility']};}}
module.exports=TDHeadersAttr;},{"./axe-audit":1}],"../audits/accessibility/th-has-data-cells":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class THHasDataCells extends AxeAudit{static get meta(){return{category:'Accessibility',name:'th-has-data-cells',description:'`<th>` elements and elements with `[role="columnheader"/"rowheader"]` have '+'data cells they describe.',failureDescription:'`<th>` elements and elements with '+'`[role="columnheader"/"rowheader"]` do not have data cells they describe.',helpText:'Screen readers have features to make navigating tables easier. Ensuring table '+'headers always refer to some set of cells may improve the experience for screen '+'reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/th-has-data-cells).',requiredArtifacts:['Accessibility']};}}
module.exports=THHasDataCells;},{"./axe-audit":1}],"../audits/accessibility/valid-lang":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ValidLang extends AxeAudit{static get meta(){return{category:'Accessibility',name:'valid-lang',description:'`[lang]` attributes have a valid value.',failureDescription:'`[lang]` attributes do not have a valid value.',helpText:'Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) '+'on elements helps ensure that text is pronounced correctly by a screen reader. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/valid-lang).',requiredArtifacts:['Accessibility']};}}
module.exports=ValidLang;},{"./axe-audit":1}],"../audits/accessibility/video-caption":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class VideoCaption extends AxeAudit{static get meta(){return{category:'Accessibility',name:'video-caption',description:'`<video>` elements contain a `<track>` element with `[kind="captions"]`.',failureDescription:'`<video>` elements do not contain a `<track>` element '+'with `[kind="captions"]`.',helpText:'When a video provides a caption it is easier for deaf and hearing impaired '+'users to access its information. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/video-caption).',requiredArtifacts:['Accessibility']};}}
module.exports=VideoCaption;},{"./axe-audit":1}],"../audits/accessibility/video-description":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class VideoDescription extends AxeAudit{static get meta(){return{category:'Accessibility',name:'video-description',description:'`<video>` elements contain a `<track>` element with `[kind="description"]`.',failureDescription:'`<video>` elements do not contain a `<track>` element with '+'`[kind="description"]`.',helpText:'Audio descriptions provide relevant information for videos that dialogue '+'cannot, such as facial expressions and scenes. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/video-description).',requiredArtifacts:['Accessibility']};}}
module.exports=VideoDescription;},{"./axe-audit":1}],"../audits/byte-efficiency/offscreen-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const ALLOWABLE_OFFSCREEN_X=100;const ALLOWABLE_OFFSCREEN_Y=200;const IGNORE_THRESHOLD_IN_BYTES=2048;const IGNORE_THRESHOLD_IN_PERCENT=75;class OffscreenImages extends ByteEfficiencyAudit{static get meta(){return{category:'Images',name:'offscreen-images',description:'Offscreen images',informative:true,helpText:'Consider lazy-loading offscreen images to improve page load speed '+'and time to interactive. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images).',requiredArtifacts:['ImageUsage','ViewportDimensions','traces','devtoolsLogs']};}
static computeVisiblePixels(imageRect,viewportDimensions){const innerWidth=viewportDimensions.innerWidth;const innerHeight=viewportDimensions.innerHeight;const top=Math.max(imageRect.top,-1*ALLOWABLE_OFFSCREEN_Y);const right=Math.min(imageRect.right,innerWidth+ALLOWABLE_OFFSCREEN_X);const bottom=Math.min(imageRect.bottom,innerHeight+ALLOWABLE_OFFSCREEN_Y);const left=Math.max(imageRect.left,-1*ALLOWABLE_OFFSCREEN_X);return Math.max(right-left,0)*Math.max(bottom-top,0);}
static computeWaste(image,viewportDimensions){const url=URL.elideDataURI(image.src);const totalPixels=image.clientWidth*image.clientHeight;const visiblePixels=this.computeVisiblePixels(image.clientRect,viewportDimensions);const wastedRatio=totalPixels===0?1:1-visiblePixels/totalPixels;const totalBytes=image.networkRecord.resourceSize;const wastedBytes=Math.round(totalBytes*wastedRatio);if(!Number.isFinite(wastedRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,preview:{type:'thumbnail',url:image.networkRecord.url,mimeType:image.networkRecord.mimeType},requestStartTime:image.networkRecord.startTime,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts){const images=artifacts.ImageUsage;const viewportDimensions=artifacts.ViewportDimensions;const trace=artifacts.traces[ByteEfficiencyAudit.DEFAULT_PASS];let debugString;const resultsMap=images.reduce((results,image)=>{if(!image.networkRecord){return results;}
const processed=OffscreenImages.computeWaste(image,viewportDimensions);if(processed instanceof Error){debugString=processed.message;return results;}
const existing=results.get(processed.preview.url);if(!existing||existing.wastedBytes>processed.wastedBytes){results.set(processed.preview.url,processed);}
return results;},new Map());return artifacts.requestFirstInteractive(trace).then(firstInteractive=>{const ttiTimestamp=firstInteractive.timestamp/1000000;const results=Array.from(resultsMap.values()).filter(item=>{const isWasteful=item.wastedBytes>IGNORE_THRESHOLD_IN_BYTES&&item.wastedPercent>IGNORE_THRESHOLD_IN_PERCENT;const loadedEarly=item.requestStartTime<ttiTimestamp;return isWasteful&&loadedEarly;});const headings=[{key:'preview',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{debugString,results,headings};});}}
module.exports=OffscreenImages;},{"../../lib/url-shim":30,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/total-byte-weight":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const OPTIMAL_VALUE=1600*1024;const SCORING_POINT_OF_DIMINISHING_RETURNS=2500*1024;const SCORING_MEDIAN=4000*1024;class TotalByteWeight extends ByteEfficiencyAudit{static get meta(){return{category:'Network',name:'total-byte-weight',optimalValue:`< ${this.bytesToKbString(OPTIMAL_VALUE)}`,description:'Avoids enormous network payloads',failureDescription:'Has enormous network payloads',helpText:'Network transfer size [costs users real money](https://whatdoesmysitecost.com/) '+'and is [highly correlated](http://httparchive.org/interesting.php#onLoad) with long load times. '+'Try to find ways to reduce the size of required files.',scoringMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['devtoolsLogs']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];return Promise.all([artifacts.requestNetworkRecords(devtoolsLogs),artifacts.requestNetworkThroughput(devtoolsLogs)]).then(([networkRecords,networkThroughput])=>{let totalBytes=0;let results=[];networkRecords.forEach(record=>{if(record.scheme==='data'||!record.finished)return;const result={url:record.url,totalBytes:record.transferSize,totalKb:this.bytesToKbString(record.transferSize),totalMs:this.bytesToMsString(record.transferSize,networkThroughput)};totalBytes+=result.totalBytes;results.push(result);});const totalCompletedRequests=results.length;results=results.sort((itemA,itemB)=>itemB.totalBytes-itemA.totalBytes).slice(0,10);const score=ByteEfficiencyAudit.computeLogNormalScore(totalBytes,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Total Size'},{key:'totalMs',itemType:'text',text:'Transfer Time'}];const tableDetails=ByteEfficiencyAudit.makeTableDetails(headings,results);return{score,rawValue:totalBytes,optimalValue:this.meta.optimalValue,displayValue:`Total size was ${ByteEfficiencyAudit.bytesToKbString(totalBytes)}`,extendedInfo:{value:{results,totalCompletedRequests}},details:tableDetails};});}}
module.exports=TotalByteWeight;},{"./byte-efficiency-audit":3}],"../audits/byte-efficiency/unused-css-rules":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const PREVIEW_LENGTH=100;class UnusedCSSRules extends ByteEfficiencyAudit{static get meta(){return{category:'CSS',name:'unused-css-rules',description:'Unused CSS rules',informative:true,helpText:'Remove unused rules from stylesheets to reduce unnecessary '+'bytes consumed by network activity. '+'[Learn more](https://developers.google.com/speed/docs/insights/OptimizeCSSDelivery)',requiredArtifacts:['CSSUsage','Styles','URL','devtoolsLogs']};}
static indexStylesheetsById(styles,networkRecords){const indexedNetworkRecords=networkRecords.filter(record=>record._resourceType&&record._resourceType._name==='stylesheet').reduce((indexed,record)=>{indexed[record.url]=record;return indexed;},{});return styles.reduce((indexed,stylesheet)=>{indexed[stylesheet.header.styleSheetId]=Object.assign({used:[],unused:[],networkRecord:indexedNetworkRecords[stylesheet.header.sourceURL]},stylesheet);return indexed;},{});}
static countUnusedRules(rules,indexedStylesheets){let unused=0;rules.forEach(rule=>{const stylesheetInfo=indexedStylesheets[rule.styleSheetId];if(!stylesheetInfo||stylesheetInfo.isDuplicate){return;}
if(rule.used){stylesheetInfo.used.push(rule);}else{unused++;stylesheetInfo.unused.push(rule);}});return unused;}
static determineContentPreview(content){let preview=content.slice(0,PREVIEW_LENGTH*5).replace(/( {2,}|\t)+/g,'  ').replace(/\n\s+}/g,'\n}').trim();if(preview.length>PREVIEW_LENGTH){const firstRuleStart=preview.indexOf('{');const firstRuleEnd=preview.indexOf('}');if(firstRuleStart===-1||firstRuleEnd===-1||firstRuleStart>firstRuleEnd||firstRuleStart>PREVIEW_LENGTH){preview=preview.slice(0,PREVIEW_LENGTH)+'...';}else if(firstRuleEnd<PREVIEW_LENGTH){preview=preview.slice(0,firstRuleEnd+1)+' ...';}else{const lastSemicolonIndex=preview.slice(0,PREVIEW_LENGTH).lastIndexOf(';');preview=lastSemicolonIndex<firstRuleStart?preview.slice(0,PREVIEW_LENGTH)+'... } ...':preview.slice(0,lastSemicolonIndex+1)+' ... } ...';}}
return preview;}
static mapSheetToResult(stylesheetInfo,pageUrl){const numUsed=stylesheetInfo.used.length;const numUnused=stylesheetInfo.unused.length;if(numUsed===0&&numUnused===0||stylesheetInfo.isDuplicate){return null;}
let url=stylesheetInfo.header.sourceURL;if(!url||url===pageUrl){const contentPreview=UnusedCSSRules.determineContentPreview(stylesheetInfo.content);url='*inline*```'+contentPreview+'```';}else{url=URL.getURLDisplayName(url);}
const totalBytes=stylesheetInfo.networkRecord?stylesheetInfo.networkRecord.transferSize:Math.round(stylesheetInfo.content.length/3);const percentUnused=numUnused/(numUsed+numUnused);const wastedBytes=Math.round(percentUnused*totalBytes);return{url,numUnused,wastedBytes,wastedPercent:percentUnused*100,totalBytes};}
static audit_(artifacts){const styles=artifacts.Styles;const usage=artifacts.CSSUsage;const pageUrl=artifacts.URL.finalUrl;const devtoolsLogs=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const indexedSheets=UnusedCSSRules.indexStylesheetsById(styles,networkRecords);UnusedCSSRules.countUnusedRules(usage,indexedSheets);const results=Object.keys(indexedSheets).map(sheetId=>{return UnusedCSSRules.mapSheetToResult(indexedSheets[sheetId],pageUrl);}).filter(sheet=>sheet&&sheet.wastedBytes>1024);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'numUnused',itemType:'url',text:'Unused Rules'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{results,headings};});}}
module.exports=UnusedCSSRules;},{"../../lib/url-shim":30,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-optimized-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=4096;class UsesOptimizedImages extends ByteEfficiencyAudit{static get meta(){return{category:'Images',name:'uses-optimized-images',description:'Optimize images',informative:true,helpText:'Optimized images load faster and consume less cellular data. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/optimize-images).',requiredArtifacts:['OptimizedImages','devtoolsLogs']};}
static computeSavings(image,type){const bytes=image.originalSize-image[type+'Size'];const percent=100*bytes/image.originalSize;return{bytes,percent};}
static audit_(artifacts){const images=artifacts.OptimizedImages;const failedImages=[];const results=[];images.forEach(image=>{if(image.failed){failedImages.push(image);return;}else if(/(jpeg|bmp)/.test(image.mimeType)===false||image.originalSize<image.jpegSize+IGNORE_THRESHOLD_IN_BYTES){return;}
const url=URL.elideDataURI(image.url);const jpegSavings=UsesOptimizedImages.computeSavings(image,'jpeg');results.push({url,isCrossOrigin:!image.isSameOrigin,preview:{url:image.url,mimeType:image.mimeType,type:'thumbnail'},totalBytes:image.originalSize,wastedBytes:jpegSavings.bytes});});let debugString;if(failedImages.length){const urls=failedImages.map(image=>URL.getURLDisplayName(image.url));debugString=`Lighthouse was unable to decode some of your images: ${urls.join(', ')}`;}
const headings=[{key:'preview',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{debugString,results,headings};}}
module.exports=UsesOptimizedImages;},{"../../lib/url-shim":30,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-request-compression":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=1400;const IGNORE_THRESHOLD_IN_PERCENT=0.1;class ResponsesAreCompressed extends ByteEfficiencyAudit{static get meta(){return{category:'Performance',name:'uses-request-compression',informative:true,description:'Enable text compression',helpText:'Text-based responses should be served with compression (gzip, deflate or brotli)'+' to minimize total network bytes.'+' [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/optimize-encoding-and-transfer).',requiredArtifacts:['ResponseCompression','devtoolsLogs']};}
static audit_(artifacts){const uncompressedResponses=artifacts.ResponseCompression;const results=[];uncompressedResponses.forEach(record=>{const originalSize=record.resourceSize;const gzipSize=record.gzipSize;const gzipSavings=originalSize-gzipSize;if(1-gzipSize/originalSize<IGNORE_THRESHOLD_IN_PERCENT||gzipSavings<IGNORE_THRESHOLD_IN_BYTES)
{return;}
const url=URL.elideDataURI(record.url);const isDuplicate=results.find(res=>res.url===url&&res.totalBytes===record.resourceSize);if(isDuplicate){return;}
results.push({url,totalBytes:originalSize,wastedBytes:gzipSavings});});const headings=[{key:'url',itemType:'url',text:'Uncompressed resource URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'GZIP Savings'}];return{results,headings};}}
module.exports=ResponsesAreCompressed;},{"../../lib/url-shim":30,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-responsive-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=2048;const WASTEFUL_THRESHOLD_IN_BYTES=25*1024;class UsesResponsiveImages extends ByteEfficiencyAudit{static get meta(){return{category:'Images',name:'uses-responsive-images',description:'Properly size images',informative:true,helpText:'Serve images that are appropriately-sized to save cellular data '+'and improve load time. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/oversized-images).',requiredArtifacts:['ImageUsage','ViewportDimensions','devtoolsLogs']};}
static computeWaste(image,DPR){const url=URL.elideDataURI(image.src);const actualPixels=image.naturalWidth*image.naturalHeight;const usedPixels=image.clientWidth*image.clientHeight*Math.pow(DPR,2);const wastedRatio=1-usedPixels/actualPixels;const totalBytes=image.networkRecord.resourceSize;const wastedBytes=Math.round(totalBytes*wastedRatio);if(!Number.isFinite(wastedRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,preview:{type:'thumbnail',url:image.networkRecord.url,mimeType:image.networkRecord.mimeType},totalBytes,wastedBytes,wastedPercent:100*wastedRatio,isWasteful:wastedBytes>WASTEFUL_THRESHOLD_IN_BYTES};}
static audit_(artifacts){const images=artifacts.ImageUsage;const DPR=artifacts.ViewportDimensions.devicePixelRatio;let debugString;const resultsMap=new Map();images.forEach(image=>{if(!image.networkRecord||image.networkRecord.mimeType==='image/svg+xml'){return;}
const processed=UsesResponsiveImages.computeWaste(image,DPR);if(processed instanceof Error){debugString=processed.message;return;}
const existing=resultsMap.get(processed.preview.url);if(!existing||existing.wastedBytes>processed.wastedBytes){resultsMap.set(processed.preview.url,processed);}});const results=Array.from(resultsMap.values()).filter(item=>item.wastedBytes>IGNORE_THRESHOLD_IN_BYTES);const headings=[{key:'preview',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{debugString,results,headings};}}
module.exports=UsesResponsiveImages;},{"../../lib/url-shim":30,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-webp-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const OptimizedImages=require('./uses-optimized-images');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=8192;class UsesWebPImages extends ByteEfficiencyAudit{static get meta(){return{category:'Images',name:'uses-webp-images',description:'Serve images as WebP',informative:true,helpText:'WebP provides better lossy and lossless compression than PNG or JPEG, '+'which means faster downloads and less data consumption. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/webp).',requiredArtifacts:['OptimizedImages','devtoolsLogs']};}
static audit_(artifacts){const images=artifacts.OptimizedImages;const failedImages=[];const results=[];images.forEach(image=>{if(image.failed){failedImages.push(image);return;}else if(image.originalSize<image.webpSize+IGNORE_THRESHOLD_IN_BYTES){return;}
const url=URL.elideDataURI(image.url);const webpSavings=OptimizedImages.computeSavings(image,'webp');results.push({url,isCrossOrigin:!image.isSameOrigin,preview:{url:image.url,mimeType:image.mimeType,type:'thumbnail'},totalBytes:image.originalSize,wastedBytes:webpSavings.bytes});});let debugString;if(failedImages.length){const urls=failedImages.map(image=>URL.getURLDisplayName(image.url));debugString=`Lighthouse was unable to decode some of your images: ${urls.join(', ')}`;}
const headings=[{key:'preview',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{debugString,results,headings};}}
module.exports=UsesWebPImages;},{"../../lib/url-shim":30,"./byte-efficiency-audit":3,"./uses-optimized-images":"../audits/byte-efficiency/uses-optimized-images"}],"../audits/cache-start-url":[function(require,module,exports){'use strict';const Audit=require('./audit');class CacheStartUrl extends Audit{static get meta(){return{category:'Manifest',name:'cache-start-url',description:'Cache contains start_url from manifest (alpha)',failureDescription:'Cache does not contain start_url from manifest (alpha)',requiredArtifacts:['CacheContents','Manifest','URL']};}
static audit(artifacts){if(!artifacts.Manifest||!artifacts.Manifest.value){return{rawValue:false};}
const manifest=artifacts.Manifest.value;if(!(manifest.start_url&&manifest.start_url.value)){return{rawValue:false,debugString:'start_url not present in Manifest'};}
const startURL=manifest.start_url.value;const altStartURL=startURL.replace(/\?utm_([^=]*)=([^&]|$)*/,'').replace(/\?$/,'');const cacheContents=artifacts.CacheContents;const cacheHasStartUrl=cacheContents.find(req=>{return startURL===req||altStartURL===req;});return{rawValue:cacheHasStartUrl!==undefined};}}
module.exports=CacheStartUrl;},{"./audit":2}],"../audits/consistently-interactive":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util.js');const TracingProcessor=require('../lib/traces/tracing-processor');const SCORING_POINT_OF_DIMINISHING_RETURNS=1700;const SCORING_MEDIAN=10000;const REQUIRED_QUIET_WINDOW=5000;const ALLOWED_CONCURRENT_REQUESTS=2;const IGNORED_NETWORK_SCHEMES=['data','ws'];class ConsistentlyInteractiveMetric extends Audit{static get meta(){return{category:'Performance',name:'consistently-interactive',description:'Consistently Interactive (beta)',helpText:'The point at which most network resources have finished loading and the '+'CPU is idle for a prolonged period.',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static _findNetworkQuietPeriods(networkRecords,traceOfTab){const traceEndTsInMs=traceOfTab.timestamps.traceEnd/1000;const timeBoundaries=[];networkRecords.forEach(record=>{const scheme=record.parsedURL&&record.parsedURL.scheme;if(IGNORED_NETWORK_SCHEMES.includes(scheme)){return;}
timeBoundaries.push({time:record.startTime*1000,isStart:true});if(record.finished){timeBoundaries.push({time:record.endTime*1000,isStart:false});}});timeBoundaries.sort((a,b)=>a.time-b.time);let numInflightRequests=0;let quietPeriodStart=0;const quietPeriods=[];timeBoundaries.forEach(boundary=>{if(boundary.isStart){if(numInflightRequests===ALLOWED_CONCURRENT_REQUESTS){quietPeriods.push({start:quietPeriodStart,end:boundary.time});}
numInflightRequests++;}else{numInflightRequests--;if(numInflightRequests===ALLOWED_CONCURRENT_REQUESTS){quietPeriodStart=boundary.time;}}});if(numInflightRequests<=ALLOWED_CONCURRENT_REQUESTS){quietPeriods.push({start:quietPeriodStart,end:traceEndTsInMs});}
return quietPeriods;}
static _findCPUQuietPeriods(longTasks,traceOfTab){const navStartTsInMs=traceOfTab.timestamps.navigationStart/1000;const traceEndTsInMs=traceOfTab.timestamps.traceEnd/1000;if(longTasks.length===0){return[{start:0,end:traceEndTsInMs}];}
const quietPeriods=[];longTasks.forEach((task,index)=>{if(index===0){quietPeriods.push({start:0,end:task.start+navStartTsInMs});}
if(index===longTasks.length-1){quietPeriods.push({start:task.end+navStartTsInMs,end:traceEndTsInMs});}else{quietPeriods.push({start:task.end+navStartTsInMs,end:longTasks[index+1].start+navStartTsInMs});}});return quietPeriods;}
static findOverlappingQuietPeriods(longTasks,networkRecords,traceOfTab){const FMPTsInMs=traceOfTab.timestamps.firstMeaningfulPaint/1000;const isLongEnoughQuietPeriod=period=>period.end>FMPTsInMs+REQUIRED_QUIET_WINDOW&&period.end-period.start>=REQUIRED_QUIET_WINDOW;const networkQuietPeriods=this._findNetworkQuietPeriods(networkRecords,traceOfTab).filter(isLongEnoughQuietPeriod);const cpuQuietPeriods=this._findCPUQuietPeriods(longTasks,traceOfTab).filter(isLongEnoughQuietPeriod);const cpuQueue=cpuQuietPeriods.slice();const networkQueue=networkQuietPeriods.slice();let cpuCandidate=cpuQueue.shift();let networkCandidate=networkQueue.shift();while(cpuCandidate&&networkCandidate){if(cpuCandidate.start>=networkCandidate.start){if(networkCandidate.end>=cpuCandidate.start+REQUIRED_QUIET_WINDOW){return{cpuQuietPeriod:cpuCandidate,networkQuietPeriod:networkCandidate,cpuQuietPeriods,networkQuietPeriods};}else{networkCandidate=networkQueue.shift();}}else{if(cpuCandidate.end>=networkCandidate.start+REQUIRED_QUIET_WINDOW){return{cpuQuietPeriod:cpuCandidate,networkQuietPeriod:networkCandidate,cpuQuietPeriods,networkQuietPeriods};}else{cpuCandidate=cpuQueue.shift();}}}
const culprit=cpuCandidate?'Network':'Main thread';throw new Error(`${culprit} activity continued through the end of the trace recording. `+'Consistently Interactive requires a minimum of 5 seconds of both main thread idle and '+'network idle.');}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const computedArtifacts=[artifacts.requestNetworkRecords(devtoolsLog),artifacts.requestTraceOfTab(trace)];return Promise.all(computedArtifacts).then(([networkRecords,traceOfTab])=>{if(!traceOfTab.timestamps.firstMeaningfulPaint){throw new Error('No firstMeaningfulPaint found in trace.');}
if(!traceOfTab.timestamps.domContentLoaded){throw new Error('No domContentLoaded found in trace.');}
const longTasks=TracingProcessor.getMainThreadTopLevelEvents(traceOfTab).filter(event=>event.duration>=50);const quietPeriodInfo=this.findOverlappingQuietPeriods(longTasks,networkRecords,traceOfTab);const cpuQuietPeriod=quietPeriodInfo.cpuQuietPeriod;const timestamp=Math.max(cpuQuietPeriod.start,traceOfTab.timestamps.firstMeaningfulPaint/1000,traceOfTab.timestamps.domContentLoaded/1000)*1000;const timeInMs=(timestamp-traceOfTab.timestamps.navigationStart)/1000;const extendedInfo=Object.assign(quietPeriodInfo,{timestamp,timeInMs});return{score:Audit.computeLogNormalScore(timeInMs,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN),rawValue:timeInMs,displayValue:Util.formatMilliseconds(timeInMs),optimalValue:this.meta.optimalValue,extendedInfo:{value:extendedInfo}};});}}
module.exports=ConsistentlyInteractiveMetric;let TimePeriod;},{"../lib/traces/tracing-processor":29,"../report/v2/renderer/util.js":32,"./audit":2}],"../audits/content-width":[function(require,module,exports){'use strict';const Audit=require('./audit');class ContentWidth extends Audit{static get meta(){return{category:'Mobile Friendly',name:'content-width',description:'Content is sized correctly for the viewport',failureDescription:'Content is not sized correctly for the viewport',helpText:'If the width of your app\'s content doesn\'t match the width '+'of the viewport, your app might not be optimized for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/content-sized-correctly-for-viewport).',requiredArtifacts:['ViewportDimensions']};}
static audit(artifacts){const viewportWidth=artifacts.ViewportDimensions.innerWidth;const windowWidth=artifacts.ViewportDimensions.outerWidth;const widthsMatch=viewportWidth===windowWidth;return{rawValue:widthsMatch,debugString:this.createDebugString(widthsMatch,artifacts.ViewportDimensions)};}
static createDebugString(match,artifact){if(match){return'';}
return'The viewport size is '+artifact.innerWidth+'px, '+'whereas the window size is '+artifact.outerWidth+'px.';}}
module.exports=ContentWidth;},{"./audit":2}],"../audits/critical-request-chains":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util');class CriticalRequestChains extends Audit{static get meta(){return{category:'Performance',name:'critical-request-chains',description:'Critical Request Chains',informative:true,optimalValue:0,helpText:'The Critical Request Chains below show you what resources are '+'required for first render of this page. Improve page load by reducing '+'the length of chains, reducing the download size of resources, or '+'deferring the download of unnecessary resources. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains).',requiredArtifacts:['devtoolsLogs']};}
static _traverse(tree,cb){function walk(node,depth,startTime,transferSize=0){const children=Object.keys(node);if(children.length===0){return;}
children.forEach(id=>{const child=node[id];if(!startTime){startTime=child.request.startTime;}
cb({depth,id,node:child,chainDuration:(child.request.endTime-startTime)*1000,chainTransferSize:transferSize+child.request.transferSize});walk(child.children,depth+1,startTime);},'');}
walk(tree,0);}
static _getLongestChain(tree){const longest={duration:0,length:0,transferSize:0};CriticalRequestChains._traverse(tree,opts=>{const duration=opts.chainDuration;if(duration>longest.duration){longest.duration=duration;longest.transferSize=opts.chainTransferSize;longest.length=opts.depth;}});longest.length++;return longest;}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestCriticalRequestChains(devtoolsLogs).then(chains=>{let chainCount=0;function walk(node,depth){const children=Object.keys(node);if(children.length===0){chainCount++;}
children.forEach(id=>{const child=node[id];walk(child.children,depth+1);},'');}
const initialNavKey=Object.keys(chains)[0];const initialNavChildren=initialNavKey&&chains[initialNavKey].children;if(initialNavChildren&&Object.keys(initialNavChildren).length>0){walk(initialNavChildren,0);}
const longestChain=CriticalRequestChains._getLongestChain(chains);return{rawValue:chainCount<=this.meta.optimalValue,displayValue:Util.formatNumber(chainCount),optimalValue:this.meta.optimalValue,extendedInfo:{value:{chains,longestChain}},details:{type:'criticalrequestchain',header:{type:'text',text:'View critical network waterfall:'},chains,longestChain}};});}}
module.exports=CriticalRequestChains;},{"../report/v2/renderer/util":32,"./audit":2}],"../audits/deprecations":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util');class Deprecations extends Audit{static get meta(){return{category:'Deprecations',name:'deprecations',description:'Avoids deprecated APIs',failureDescription:'Uses deprecated API\'s',helpText:'Deprecated APIs will eventually be removed from the browser. '+'[Learn more](https://www.chromestatus.com/features#deprecated).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const entries=artifacts.ChromeConsoleMessages;const deprecations=entries.filter(log=>log.entry.source==='deprecation').map(log=>{return{type:'code',text:log.entry.text,url:log.entry.url,source:log.entry.source,lineNumber:log.entry.lineNumber};});const headings=[{key:'text',itemType:'code',text:'Deprecation / Warning'},{key:'url',itemType:'url',text:'URL'},{key:'lineNumber',itemType:'text',text:'Line'}];const details=Audit.makeTableDetails(headings,deprecations);let displayValue='';if(deprecations.length>1){displayValue=`${Util.formatNumber(deprecations.length)} warnings found`;}else if(deprecations.length===1){displayValue=`${deprecations.length} warning found`;}
return{rawValue:deprecations.length===0,displayValue,extendedInfo:{value:deprecations},details};}}
module.exports=Deprecations;},{"../report/v2/renderer/util":32,"./audit":2}],"../audits/dobetterweb/appcache-manifest":[function(require,module,exports){'use strict';const Audit=require('../audit');class AppCacheManifestAttr extends Audit{static get meta(){return{category:'Offline',name:'appcache-manifest',description:'Avoids Application Cache',failureDescription:'Uses Application Cache',helpText:'Application Cache is deprecated. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/appcache).',requiredArtifacts:['AppCacheManifest']};}
static audit(artifacts){const usingAppcache=artifacts.AppCacheManifest!==null;const debugString=usingAppcache?`Found <html manifest="${artifacts.AppCacheManifest}">.`:'';return{rawValue:!usingAppcache,debugString};}}
module.exports=AppCacheManifestAttr;},{"../audit":2}],"../audits/dobetterweb/dom-size":[function(require,module,exports){'use strict';const Audit=require('../audit');const Util=require('../../report/v2/renderer/util.js');const MAX_DOM_NODES=1500;const MAX_DOM_TREE_WIDTH=60;const MAX_DOM_TREE_DEPTH=32;const SCORING_POINT_OF_DIMINISHING_RETURNS=2400;const SCORING_MEDIAN=3000;class DOMSize extends Audit{static get MAX_DOM_NODES(){return MAX_DOM_NODES;}
static get meta(){return{category:'Performance',name:'dom-size',description:'Avoids an excessive DOM size',failureDescription:'Uses an excessive DOM size',optimalValue:`< ${DOMSize.MAX_DOM_NODES.toLocaleString()} nodes`,helpText:'Browser engineers recommend pages contain fewer than '+`~${Util.formatNumber(DOMSize.MAX_DOM_NODES)} DOM nodes. The sweet spot is a tree `+`depth < ${MAX_DOM_TREE_DEPTH} elements and fewer than ${MAX_DOM_TREE_WIDTH} `+'children/parent element. A large DOM can increase memory usage, cause longer '+'[style calculations](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations), '+'and produce costly [layout reflows](https://developers.google.com/speed/articles/reflow). [Learn more](https://developers.google.com/web/fundamentals/performance/rendering/).',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['DOMStats']};}
static audit(artifacts){const stats=artifacts.DOMStats;const depthSnippet=stats.depth.pathToElement.reduce((str,curr,i)=>{return`${str}\n`+'  '.repeat(i)+`${curr} >`;},'').replace(/>$/g,'').trim();const widthSnippet='Element with most children:\n'+
stats.width.pathToElement[stats.width.pathToElement.length-1];const score=Audit.computeLogNormalScore(stats.totalDOMNodes,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN);const cards=[{title:'Total DOM Nodes',value:Util.formatNumber(stats.totalDOMNodes),target:`< ${Util.formatNumber(MAX_DOM_NODES)} nodes`},{title:'DOM Depth',value:Util.formatNumber(stats.depth.max),snippet:depthSnippet,target:`< ${Util.formatNumber(MAX_DOM_TREE_DEPTH)}`},{title:'Maximum Children',value:Util.formatNumber(stats.width.max),snippet:widthSnippet,target:`< ${Util.formatNumber(MAX_DOM_TREE_WIDTH)} nodes`}];return{score,rawValue:stats.totalDOMNodes,optimalValue:this.meta.optimalValue,displayValue:`${Util.formatNumber(stats.totalDOMNodes)} nodes`,extendedInfo:{value:cards},details:{type:'cards',header:{type:'text',text:'View details'},items:cards}};}}
module.exports=DOMSize;},{"../../report/v2/renderer/util.js":32,"../audit":2}],"../audits/dobetterweb/external-anchors-use-rel-noopener":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');class ExternalAnchorsUseRelNoopenerAudit extends Audit{static get meta(){return{category:'Performance',name:'external-anchors-use-rel-noopener',description:'Opens external anchors using `rel="noopener"`',failureDescription:'Does not open external anchors using `rel="noopener"`',helpText:'Open new tabs using `rel="noopener"` to improve performance and '+'prevent security vulnerabilities. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/noopener).',requiredArtifacts:['URL','AnchorsWithNoRelNoopener']};}
static audit(artifacts){let debugString;const pageHost=new URL(artifacts.URL.finalUrl).host;const failingAnchors=artifacts.AnchorsWithNoRelNoopener.filter(anchor=>{try{return anchor.href===''||new URL(anchor.href).host!==pageHost;}catch(err){debugString='Lighthouse was unable to determine the destination '+'of some anchor tags. If they are not used as hyperlinks, '+'consider removing the _blank target.';return true;}}).map(anchor=>{return{href:anchor.href||'Unknown',target:anchor.target||'',rel:anchor.rel||'',url:'<a'+(anchor.href?` href="${anchor.href}"`:'')+(anchor.target?` target="${anchor.target}"`:'')+(anchor.rel?` rel="${anchor.rel}"`:'')+'>'};});const headings=[{key:'href',itemType:'url',text:'URL'},{key:'target',itemType:'text',text:'Target'},{key:'rel',itemType:'text',text:'Rel'}];const details=Audit.makeTableDetails(headings,failingAnchors);return{rawValue:failingAnchors.length===0,extendedInfo:{value:failingAnchors},details,debugString};}}
module.exports=ExternalAnchorsUseRelNoopenerAudit;},{"../../lib/url-shim":30,"../audit":2}],"../audits/dobetterweb/geolocation-on-start":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class GeolocationOnStart extends ViolationAudit{static get meta(){return{category:'UX',name:'geolocation-on-start',description:'Avoids requesting the geolocation permission on page load',failureDescription:'Requests the geolocation permission on page load',helpText:'Users are mistrustful of or confused by sites that request their '+'location without context. Consider tying the request to user gestures instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/geolocation-on-load).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/geolocation/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=GeolocationOnStart;},{"../violation-audit":6}],"../audits/dobetterweb/link-blocking-first-paint":[function(require,module,exports){'use strict';const Audit=require('../audit');const Util=require('../../report/v2/renderer/util.js');const scoreForWastedMs=require('../byte-efficiency/byte-efficiency-audit').scoreForWastedMs;const LOAD_THRESHOLD_IN_MS=50;class LinkBlockingFirstPaintAudit extends Audit{static get meta(){return{category:'Performance',name:'link-blocking-first-paint',description:'Reduce render-blocking stylesheets',informative:true,helpText:'Link elements are blocking the first paint of your page. Consider '+'inlining critical links and deferring non-critical ones. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).',requiredArtifacts:['TagsBlockingFirstPaint','traces']};}
static computeAuditResultForTags(artifacts,tagFilter,endTimeMax=Infinity,loadDurationThreshold=0){const artifact=artifacts.TagsBlockingFirstPaint;const filtered=artifact.filter(item=>{return item.tag.tagName===tagFilter&&(item.endTime-item.startTime)*1000>=loadDurationThreshold&&item.endTime*1000<endTimeMax;});const startTime=filtered.length===0?0:filtered.reduce((t,item)=>Math.min(t,item.startTime),Number.MAX_VALUE);let endTime=0;const results=filtered.map(item=>{endTime=Math.max(item.endTime,endTime);return{url:item.tag.url,totalKb:Util.formatBytesToKB(item.transferSize),totalMs:Util.formatMilliseconds(Math.round((item.endTime-startTime)*1000),1)};});const rawDelayTime=Math.round((endTime-startTime)*1000);const delayTime=Util.formatMilliseconds(rawDelayTime,1);let displayValue='';if(results.length>1){displayValue=`${results.length} resources delayed first paint by ${delayTime}`;}else if(results.length===1){displayValue=`${results.length} resource delayed first paint by ${delayTime}`;}
const headings=[{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Size (KB)'},{key:'totalMs',itemType:'text',text:'Delayed Paint By (ms)'}];const tableDetails=Audit.makeTableDetails(headings,results);return{displayValue,score:scoreForWastedMs(rawDelayTime),rawValue:rawDelayTime,extendedInfo:{value:{wastedMs:delayTime,results}},details:tableDetails};}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(traceOfTab=>{const fcpTsInMs=traceOfTab.timestamps.firstContentfulPaint/1000;return this.computeAuditResultForTags(artifacts,'LINK',fcpTsInMs,LOAD_THRESHOLD_IN_MS);});}}
module.exports=LinkBlockingFirstPaintAudit;},{"../../report/v2/renderer/util.js":32,"../audit":2,"../byte-efficiency/byte-efficiency-audit":3}],"../audits/dobetterweb/no-document-write":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class NoDocWriteAudit extends ViolationAudit{static get meta(){return{category:'Performance',name:'no-document-write',description:'Avoids `document.write()`',failureDescription:'Uses `document.write()`',helpText:'For users on slow connections, external scripts dynamically injected via '+'`document.write()` can delay page load by tens of seconds. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/document-write).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/document\.write/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=NoDocWriteAudit;},{"../violation-audit":6}],"../audits/dobetterweb/no-mutation-events":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const EventHelpers=require('../../lib/event-helpers');class NoMutationEventsAudit extends Audit{static get MUTATION_EVENTS(){return['DOMAttrModified','DOMAttributeNameChanged','DOMCharacterDataModified','DOMElementNameChanged','DOMNodeInserted','DOMNodeInsertedIntoDocument','DOMNodeRemoved','DOMNodeRemovedFromDocument','DOMSubtreeModified'];}
static get meta(){return{category:'JavaScript',name:'no-mutation-events',description:'Avoids Mutation Events in its own scripts',failureDescription:'Uses Mutation Events in its own scripts',helpText:'Mutation Events are deprecated and harm performance. Consider using Mutation '+'Observers instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/mutation-events).',requiredArtifacts:['URL','EventListeners']};}
static audit(artifacts){let debugString;const listeners=artifacts.EventListeners;const results=listeners.filter(loc=>{const isMutationEvent=this.MUTATION_EVENTS.includes(loc.type);let sameHost=URL.hostsMatch(artifacts.URL.finalUrl,loc.url);if(!URL.isValid(loc.url)&&isMutationEvent){sameHost=true;debugString=URL.INVALID_URL_DEBUG_STRING;}
return sameHost&&isMutationEvent;}).map(EventHelpers.addFormattedCodeSnippet);const groupedResults=EventHelpers.groupCodeSnippetsByLocation(results);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'type',itemType:'code',text:'Event'},{key:'line',itemType:'text',text:'Line'},{key:'col',itemType:'text',text:'Col'},{key:'pre',itemType:'code',text:'Snippet'}];const details=NoMutationEventsAudit.makeTableDetails(headings,groupedResults);return{rawValue:groupedResults.length===0,extendedInfo:{value:{results:groupedResults}},details,debugString};}}
module.exports=NoMutationEventsAudit;},{"../../lib/event-helpers":21,"../../lib/url-shim":30,"../audit":2}],"../audits/dobetterweb/no-old-flexbox":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const StyleHelpers=require('../../lib/styles-helpers');class NoOldFlexboxAudit extends Audit{static get meta(){return{category:'CSS',name:'no-old-flexbox',description:'Avoids old CSS flexbox',failureDescription:'Uses old CSS flexbox',helpText:'The 2009 spec of Flexbox is deprecated and is 2.3x slower than the latest '+'spec. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/old-flexbox).',requiredArtifacts:['Styles','URL']};}
static audit(artifacts){const displayPropResults=StyleHelpers.filterStylesheetsByUsage(artifacts.Styles,'display',StyleHelpers.addVendorPrefixes(['box','flexbox']));const otherPropResults=StyleHelpers.filterStylesheetsByUsage(artifacts.Styles,StyleHelpers.addVendorPrefixes(['box-flex','box-orient','box-flex-group']));const sheetsUsingOldFlexbox=displayPropResults.concat(otherPropResults);const pageUrl=artifacts.URL.finalUrl;const urlList=[];sheetsUsingOldFlexbox.forEach(sheet=>{sheet.parsedContent.forEach(props=>{const formattedStyleRule=StyleHelpers.getFormattedStyleRule(sheet.content,props);let url=sheet.header.sourceURL;if(!URL.isValid(url)||url===pageUrl){url='inline';}else{url=URL.getURLDisplayName(url);}
urlList.push({url,location:formattedStyleRule.location,startLine:formattedStyleRule.startLine,pre:formattedStyleRule.styleRule});});});return{rawValue:sheetsUsingOldFlexbox.length===0,extendedInfo:{value:{results:urlList,tableHeadings:{url:'URL',startLine:'Line in the stylesheet / <style>',location:'Column start/end',pre:'Snippet'}}}};}}
module.exports=NoOldFlexboxAudit;},{"../../lib/styles-helpers":26,"../../lib/url-shim":30,"../audit":2}],"../audits/dobetterweb/no-websql":[function(require,module,exports){'use strict';const Audit=require('../audit');class NoWebSQLAudit extends Audit{static get meta(){return{category:'Offline',name:'no-websql',description:'Avoids WebSQL DB',failureDescription:'Uses WebSQL DB',helpText:'Web SQL is deprecated. Consider using IndexedDB instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/web-sql).',requiredArtifacts:['WebSQL']};}
static audit(artifacts){const db=artifacts.WebSQL;const debugString=db?`Found database "${db.name}", version: ${db.version}.`:'';return{rawValue:!db,debugString};}}
module.exports=NoWebSQLAudit;},{"../audit":2}],"../audits/dobetterweb/notification-on-start":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class NotificationOnStart extends ViolationAudit{static get meta(){return{category:'UX',name:'notification-on-start',description:'Avoids requesting the notification permission on page load',failureDescription:'Requests the notification permission on page load',helpText:'Users are mistrustful of or confused by sites that request to send '+'notifications without context. Consider tying the request to user gestures '+'instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/notifications-on-load).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/notification permission/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=NotificationOnStart;},{"../violation-audit":6}],"../audits/dobetterweb/password-inputs-can-be-pasted-into":[function(require,module,exports){'use strict';const Audit=require('../audit');class PasswordInputsCanBePastedIntoAudit extends Audit{static get meta(){return{category:'UX',name:'password-inputs-can-be-pasted-into',description:'Allows users to paste into password fields',failureDescription:'Prevents users to paste into password fields',helpText:'Preventing password pasting undermines good security policy. '+'[Learn more](https://www.ncsc.gov.uk/blog-post/let-them-paste-passwords)',requiredArtifacts:['PasswordInputsWithPreventedPaste']};}
static audit(artifacts){const passwordInputsWithPreventedPaste=artifacts.PasswordInputsWithPreventedPaste;return{rawValue:passwordInputsWithPreventedPaste.length===0,extendedInfo:{value:passwordInputsWithPreventedPaste},details:{type:'list',header:{type:'text',text:'Password inputs that prevent pasting into'},items:passwordInputsWithPreventedPaste.map(input=>({type:'text',text:input.snippet}))}};}}
module.exports=PasswordInputsCanBePastedIntoAudit;},{"../audit":2}],"../audits/dobetterweb/script-blocking-first-paint":[function(require,module,exports){'use strict';const Audit=require('../audit');const LinkBlockingFirstPaintAudit=require('./link-blocking-first-paint');class ScriptBlockingFirstPaint extends Audit{static get meta(){return{category:'Performance',name:'script-blocking-first-paint',description:'Reduce render-blocking scripts',informative:true,helpText:'Script elements are blocking the first paint of your page. Consider inlining '+'critical scripts and deferring non-critical ones. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).',requiredArtifacts:['TagsBlockingFirstPaint','traces']};}
static audit(artifacts){return LinkBlockingFirstPaintAudit.computeAuditResultForTags(artifacts,'SCRIPT');}}
module.exports=ScriptBlockingFirstPaint;},{"../audit":2,"./link-blocking-first-paint":"../audits/dobetterweb/link-blocking-first-paint"}],"../audits/dobetterweb/uses-http2":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Util=require('../../report/v2/renderer/util.js');class UsesHTTP2Audit extends Audit{static get meta(){return{category:'Performance',name:'uses-http2',description:'Uses HTTP/2 for its own resources',failureDescription:'Does not use HTTP/2 for all of its resources',helpText:'HTTP/2 offers many benefits over HTTP/1.1, including binary headers, '+'multiplexing, and server push. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http2).',requiredArtifacts:['URL','devtoolsLogs']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const finalHost=new URL(artifacts.URL.finalUrl).host;const resources=networkRecords.filter(record=>{const isOldHttp=/HTTP\/[01][\.\d]?/i.test(record.protocol);if(!isOldHttp)return false;const requestHost=new URL(record._url).host;return requestHost===finalHost;}).map(record=>{return{protocol:record.protocol,url:record.url};});let displayValue='';if(resources.length>1){displayValue=`${Util.formatNumber(resources.length)} requests were not handled over HTTP/2`;}else if(resources.length===1){displayValue=`${resources.length} request was not handled over HTTP/2`;}
const headings=[{key:'url',itemType:'url',text:'URL'},{key:'protocol',itemType:'text',text:'Protocol'}];const details=Audit.makeTableDetails(headings,resources);return{rawValue:resources.length===0,displayValue:displayValue,extendedInfo:{value:{results:resources}},details};});}}
module.exports=UsesHTTP2Audit;},{"../../lib/url-shim":30,"../../report/v2/renderer/util.js":32,"../audit":2}],"../audits/dobetterweb/uses-passive-event-listeners":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class PassiveEventsAudit extends ViolationAudit{static get meta(){return{category:'JavaScript',name:'uses-passive-event-listeners',description:'Uses passive listeners to improve scrolling performance',failureDescription:'Does not use passive listeners to improve scrolling performance',helpText:'Consider marking your touch and wheel event listeners as `passive` '+'to improve your page\'s scroll performance. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/passive-event-listeners).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/passive event listener/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=PassiveEventsAudit;},{"../violation-audit":6}],"../audits/estimated-input-latency":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util.js');const TracingProcessor=require('../lib/traces/tracing-processor');const SCORING_POINT_OF_DIMINISHING_RETURNS=50;const SCORING_MEDIAN=100;class EstimatedInputLatency extends Audit{static get meta(){return{category:'Performance',name:'estimated-input-latency',description:'Estimated Input Latency',optimalValue:`< ${Util.formatMilliseconds(SCORING_POINT_OF_DIMINISHING_RETURNS,1)}`,helpText:'The score above is an estimate of how long your app takes to respond to user '+'input, in milliseconds. There is a 90% probability that a user encounters this amount '+'of latency, or less. 10% of the time a user can expect additional latency. If your '+'score is higher than Lighthouse\'s target score, users may perceive your app as '+'laggy. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency).',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static calculate(tabTrace){const startTime=tabTrace.timings.firstMeaningfulPaint;if(!startTime){throw new Error('No firstMeaningfulPaint event found in trace');}
const latencyPercentiles=TracingProcessor.getRiskToResponsiveness(tabTrace,startTime);const ninetieth=latencyPercentiles.find(result=>result.percentile===0.9);const rawValue=parseFloat(ninetieth.time.toFixed(1));const score=Audit.computeLogNormalScore(ninetieth.time,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN);return{score,optimalValue:EstimatedInputLatency.meta.optimalValue,rawValue,displayValue:Util.formatMilliseconds(rawValue,1),extendedInfo:{value:latencyPercentiles}};}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(EstimatedInputLatency.calculate);}}
module.exports=EstimatedInputLatency;},{"../lib/traces/tracing-processor":29,"../report/v2/renderer/util.js":32,"./audit":2}],"../audits/first-interactive":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util.js');const SCORING_POINT_OF_DIMINISHING_RETURNS=1700;const SCORING_MEDIAN=10000;class FirstInteractiveMetric extends Audit{static get meta(){return{category:'Performance',name:'first-interactive',description:'First Interactive (beta)',helpText:'The first point at which necessary scripts of the page have loaded '+'and the CPU is idle enough to handle most user input.',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestFirstInteractive(trace).then(firstInteractive=>{return{score:Audit.computeLogNormalScore(firstInteractive.timeInMs,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN),rawValue:firstInteractive.timeInMs,displayValue:Util.formatMilliseconds(firstInteractive.timeInMs),extendedInfo:{value:firstInteractive}};});}}
module.exports=FirstInteractiveMetric;},{"../report/v2/renderer/util.js":32,"./audit":2}],"../audits/first-meaningful-paint":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util.js');const SCORING_POINT_OF_DIMINISHING_RETURNS=1600;const SCORING_MEDIAN=4000;class FirstMeaningfulPaint extends Audit{static get meta(){return{category:'Performance',name:'first-meaningful-paint',description:'First meaningful paint',optimalValue:`< ${Util.formatMilliseconds(SCORING_POINT_OF_DIMINISHING_RETURNS,1)}`,helpText:'First meaningful paint measures when the primary content of a page is visible. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint).',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(tabTrace=>{if(!tabTrace.firstMeaningfulPaintEvt){throw new Error('No usable `firstMeaningfulPaint(Candidate)` events found in trace');}
if(!tabTrace.navigationStartEvt){throw new Error('No `navigationStart` event found in trace');}
const result=this.calculateScore(tabTrace);return{score:result.score,rawValue:parseFloat(result.duration),displayValue:Util.formatMilliseconds(result.duration),debugString:result.debugString,optimalValue:this.meta.optimalValue,extendedInfo:{value:result.extendedInfo}};});}
static calculateScore(traceOfTab){const extendedInfo={timestamps:{navStart:traceOfTab.timestamps.navigationStart,fCP:traceOfTab.timestamps.firstContentfulPaint,fMP:traceOfTab.timestamps.firstMeaningfulPaint,onLoad:traceOfTab.timestamps.onLoad,endOfTrace:traceOfTab.timestamps.traceEnd},timings:{navStart:0,fCP:traceOfTab.timings.firstContentfulPaint,fMP:traceOfTab.timings.firstMeaningfulPaint,onLoad:traceOfTab.timings.onLoad,endOfTrace:traceOfTab.timings.traceEnd}};Object.keys(extendedInfo.timings).forEach(key=>{const val=extendedInfo.timings[key];if(typeof val!=='number'||Number.isNaN(val)){extendedInfo.timings[key]=undefined;extendedInfo.timestamps[key]=undefined;}else{extendedInfo.timings[key]=parseFloat(extendedInfo.timings[key].toFixed(3));}});const firstMeaningfulPaint=traceOfTab.timings.firstMeaningfulPaint;const score=Audit.computeLogNormalScore(firstMeaningfulPaint,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN);return{score,duration:firstMeaningfulPaint.toFixed(1),rawValue:firstMeaningfulPaint,extendedInfo};}}
module.exports=FirstMeaningfulPaint;},{"../report/v2/renderer/util.js":32,"./audit":2}],"../audits/is-on-https":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const Util=require('../report/v2/renderer/util');const SECURE_SCHEMES=['data','https','wss','blob','chrome','chrome-extension'];const SECURE_DOMAINS=['localhost','127.0.0.1'];class HTTPS extends Audit{static get meta(){return{category:'Security',name:'is-on-https',description:'Uses HTTPS',failureDescription:'Does not use HTTPS',helpText:'All sites should be protected with HTTPS, even ones that don\'t handle '+'sensitive data. HTTPS prevents intruders from tampering with or passively listening '+'in on the communications between your app and your users, and is a prerequisite for '+'HTTP/2 and many new web platform APIs. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/https).',requiredArtifacts:['devtoolsLogs']};}
static isSecureRecord(record){return SECURE_SCHEMES.includes(record.scheme)||SECURE_SCHEMES.includes(record.protocol)||SECURE_DOMAINS.includes(record.domain);}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const insecureRecords=networkRecords.filter(record=>!HTTPS.isSecureRecord(record)).map(record=>({url:URL.elideDataURI(record.url)}));let displayValue='';if(insecureRecords.length>1){displayValue=`${Util.formatNumber(insecureRecords.length)} insecure requests found`;}else if(insecureRecords.length===1){displayValue=`${insecureRecords.length} insecure request found`;}
return{rawValue:insecureRecords.length===0,displayValue,extendedInfo:{value:insecureRecords},details:{type:'list',header:{type:'text',text:'Insecure URLs:'},items:insecureRecords.map(record=>({type:'url',text:record.url}))}};});}}
module.exports=HTTPS;},{"../lib/url-shim":30,"../report/v2/renderer/util":32,"./audit":2}],"../audits/load-fast-enough-for-pwa":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const Emulation=require('../lib/emulation');const Util=require('../report/v2/renderer/util.js');const MAXIMUM_TTFI=10*1000;const WHITELISTED_STATUS_CODES=[307];class LoadFastEnough4Pwa extends Audit{static get meta(){return{category:'PWA',name:'load-fast-enough-for-pwa',description:'Page load is fast enough on 3G',failureDescription:'Page load is not fast enough on 3G',helpText:'A fast page load over a 3G network ensures a good mobile user experience. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/fast-3g).',requiredArtifacts:['traces','devtoolsLogs']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const firstRequestLatenciesByOrigin=new Map();networkRecords.forEach(record=>{const fromCache=record._fromDiskCache||record._fromMemoryCache;const origin=URL.getOrigin(record._url);if(!origin||!record._timing||fromCache||WHITELISTED_STATUS_CODES.includes(record.statusCode)||!record.finished){return;}
if(record._startTime<record._issueTime){return;}
const latency=record._timing.receiveHeadersEnd-record._timing.sendEnd;const latencyInfo={url:record._url,startTime:record._startTime,origin,latency};const existing=firstRequestLatenciesByOrigin.get(origin);if(!existing||latencyInfo.startTime<existing.startTime){firstRequestLatenciesByOrigin.set(origin,latencyInfo);}});let firstRequestLatencies=Array.from(firstRequestLatenciesByOrigin.values());const latency3gMin=Emulation.settings.TYPICAL_MOBILE_THROTTLING_METRICS.targetLatency-10;const areLatenciesAll3G=firstRequestLatencies.every(val=>val.latency>latency3gMin);firstRequestLatencies=firstRequestLatencies.map(item=>({url:item.url,latency:Util.formatNumber(item.latency,2)}));const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestFirstInteractive(trace).then(firstInteractive=>{const timeToFirstInteractive=firstInteractive.timeInMs;const isFast=timeToFirstInteractive<MAXIMUM_TTFI;const extendedInfo={value:{areLatenciesAll3G,firstRequestLatencies,isFast,timeToFirstInteractive}};const details=Audit.makeTableDetails([{key:'url',itemType:'url',text:'URL'},{key:'latency',itemType:'text',text:'Latency (ms)'}],firstRequestLatencies);if(!isFast){return{rawValue:false,debugString:`First Interactive was at ${Util.formatMilliseconds(timeToFirstInteractive)}. More details in the "Performance" section.`,extendedInfo};}
if(!areLatenciesAll3G){return{rawValue:true,debugString:`First Interactive was found at ${Util.formatMilliseconds(timeToFirstInteractive)}, however, the network request latencies were not sufficiently realistic, so the performance measurements cannot be trusted.`,extendedInfo,details};}
return{rawValue:true,extendedInfo};});});}}
module.exports=LoadFastEnough4Pwa;},{"../lib/emulation":20,"../lib/url-shim":30,"../report/v2/renderer/util.js":32,"./audit":2}],"../audits/manifest-short-name-length":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestShortNameLength extends Audit{static get meta(){return{category:'Manifest',name:'manifest-short-name-length',description:'Manifest\'s `short_name` won\'t be truncated when displayed on homescreen',failureDescription:'Manifest\'s `short_name` will be truncated when displayed '+'on homescreen',helpText:'Make your app\'s `short_name` fewer than 12 characters to '+'ensure that it\'s not truncated on homescreens. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/manifest-short_name-is-not-truncated).',requiredArtifacts:['Manifest']};}
static audit(artifacts){return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{if(manifestValues.isParseFailure){return{rawValue:false};}
const hasShortName=manifestValues.allChecks.find(i=>i.id==='hasShortName').passing;if(!hasShortName){return{rawValue:false,debugString:'No short_name found in manifest.'};}
const isShortEnough=manifestValues.allChecks.find(i=>i.id==='shortNameLength').passing;return{rawValue:isShortEnough};});}}
module.exports=ManifestShortNameLength;},{"./audit":2}],"../audits/manual/pwa-cross-browser":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWACrossBrowser extends ManualAudit{static get meta(){return Object.assign({category:'PWA',name:'pwa-cross-browser',helpText:'To reach the most number of users, sites should work across '+'every major browser. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#site-works-cross-browser).',description:'Site works cross-browser'},super.meta);}}
module.exports=PWACrossBrowser;},{"./manual-audit":4}],"../audits/manual/pwa-each-page-has-url":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWAEachPageHasURL extends ManualAudit{static get meta(){return Object.assign({category:'PWA',name:'pwa-each-page-has-url',helpText:'Ensure individual pages are deep linkable via the URLs and that URLs are '+'unique for the purpose of shareability on social media. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#each-page-has-a-url).',description:'Each page has a URL'},super.meta);}}
module.exports=PWAEachPageHasURL;},{"./manual-audit":4}],"../audits/manual/pwa-page-transitions":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWAPageTransitions extends ManualAudit{static get meta(){return Object.assign({category:'PWA',name:'pwa-page-transitions',helpText:'Transitions should feel snappy as you tap around, even on a slow network, a key '+'to perceived performance. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#page-transitions-dont-feel-like-they-block-on-the-network).',description:'Page transitions don\'t feel like they block on the network'},super.meta);}}
module.exports=PWAPageTransitions;},{"./manual-audit":4}],"../audits/redirects-http":[function(require,module,exports){'use strict';const Audit=require('./audit');class RedirectsHTTP extends Audit{static get meta(){return{category:'Security',name:'redirects-http',description:'Redirects HTTP traffic to HTTPS',failureDescription:'Does not redirect HTTP traffic to HTTPS',helpText:'If you\'ve already set up HTTPS, make sure that you redirect all HTTP traffic '+'to HTTPS. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-redirects-to-https).',requiredArtifacts:['HTTPRedirect']};}
static audit(artifacts){return{rawValue:artifacts.HTTPRedirect.value,debugString:artifacts.HTTPRedirect.debugString};}}
module.exports=RedirectsHTTP;},{"./audit":2}],"../audits/screenshot-thumbnails":[function(require,module,exports){'use strict';const Audit=require('./audit');const TTFI=require('./first-interactive');const TTCI=require('./consistently-interactive');const jpeg=require('jpeg-js');const NUMBER_OF_THUMBNAILS=10;const THUMBNAIL_WIDTH=60;class ScreenshotThumbnails extends Audit{static get meta(){return{category:'Images',name:'screenshot-thumbnails',informative:true,description:'Screenshot Thumbnails',helpText:'This is what the load of your site looked like.',requiredArtifacts:['traces']};}
static scaleImageToThumbnail(imageData){const scaledWidth=THUMBNAIL_WIDTH;const scaleFactor=imageData.width/scaledWidth;const scaledHeight=Math.floor(imageData.height/scaleFactor);const outPixels=new Uint8Array(scaledWidth*scaledHeight*4);for(let i=0;i<scaledWidth;i++){for(let j=0;j<scaledHeight;j++){const origX=Math.floor(i*scaleFactor);const origY=Math.floor(j*scaleFactor);const origPos=(origY*imageData.width+origX)*4;const outPos=(j*scaledWidth+i)*4;outPixels[outPos]=imageData.data[origPos];outPixels[outPos+1]=imageData.data[origPos+1];outPixels[outPos+2]=imageData.data[origPos+2];outPixels[outPos+3]=imageData.data[origPos+3];}}
return{width:scaledWidth,height:scaledHeight,data:outPixels};}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];const cachedThumbnails=new Map();return Promise.all([artifacts.requestSpeedline(trace),TTFI.audit(artifacts).catch(()=>({rawValue:0})),TTCI.audit(artifacts).catch(()=>({rawValue:0}))]).then(([speedline,ttfi,ttci])=>{const thumbnails=[];const analyzedFrames=speedline.frames.filter(frame=>!frame.isProgressInterpolated());const timelineEnd=Math.max(speedline.complete,ttfi.rawValue,ttci.rawValue);for(let i=1;i<=NUMBER_OF_THUMBNAILS;i++){const targetTimestamp=speedline.beginning+timelineEnd*i/NUMBER_OF_THUMBNAILS;let frameForTimestamp=null;if(i===NUMBER_OF_THUMBNAILS){frameForTimestamp=analyzedFrames[analyzedFrames.length-1];}else{analyzedFrames.forEach(frame=>{if(frame.getTimeStamp()<=targetTimestamp){frameForTimestamp=frame;}});}
const imageData=frameForTimestamp.getParsedImage();const thumbnailImageData=ScreenshotThumbnails.scaleImageToThumbnail(imageData);const base64Data=cachedThumbnails.get(frameForTimestamp)||jpeg.encode(thumbnailImageData,90).data.toString('base64');cachedThumbnails.set(frameForTimestamp,base64Data);thumbnails.push({timing:Math.round(targetTimestamp-speedline.beginning),timestamp:targetTimestamp*1000,data:base64Data});}
return{score:100,rawValue:thumbnails.length>0,details:{type:'filmstrip',scale:timelineEnd,items:thumbnails}};});}}
module.exports=ScreenshotThumbnails;},{"./audit":2,"./consistently-interactive":"../audits/consistently-interactive","./first-interactive":"../audits/first-interactive","jpeg-js":106}],"../audits/service-worker":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');class ServiceWorker extends Audit{static get meta(){return{category:'Offline',name:'service-worker',description:'Registers a Service Worker',failureDescription:'Does not register a Service Worker',helpText:'The service worker is the technology that enables your app to use many '+'Progressive Web App features, such as offline, add to homescreen, and push '+'notifications. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/registered-service-worker).',requiredArtifacts:['URL','ServiceWorker']};}
static audit(artifacts){const versions=artifacts.ServiceWorker.versions;const url=artifacts.URL.finalUrl;const origin=new URL(url).origin;const matchingSW=versions.filter(v=>v.status==='activated').find(v=>new URL(v.scriptURL).origin===origin);return{rawValue:!!matchingSW};}}
module.exports=ServiceWorker;},{"../lib/url-shim":30,"./audit":2}],"../audits/speed-index-metric":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util');const SCORING_POINT_OF_DIMINISHING_RETURNS=1250;const SCORING_MEDIAN=5500;class SpeedIndexMetric extends Audit{static get meta(){return{category:'Performance',name:'speed-index-metric',description:'Perceptual Speed Index',helpText:'Speed Index shows how quickly the contents of a page are visibly populated. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/speed-index).',optimalValue:`< ${Util.formatNumber(SCORING_POINT_OF_DIMINISHING_RETURNS)}`,scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];return artifacts.requestSpeedline(trace).then(speedline=>{if(speedline.frames.length===0){throw new Error('Trace unable to find visual progress frames.');}
if(speedline.speedIndex===0){throw new Error('Error in Speedline calculating Speed Index (speedIndex of 0).');}
let visuallyReadyInMs=undefined;speedline.frames.forEach(frame=>{if(frame.getPerceptualProgress()>=85&&typeof visuallyReadyInMs==='undefined'){visuallyReadyInMs=frame.getTimeStamp()-speedline.beginning;}});const score=Audit.computeLogNormalScore(speedline.perceptualSpeedIndex,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN);const extendedInfo={timings:{firstVisualChange:speedline.first,visuallyReady:visuallyReadyInMs,visuallyComplete:speedline.complete,speedIndex:speedline.speedIndex,perceptualSpeedIndex:speedline.perceptualSpeedIndex},timestamps:{firstVisualChange:(speedline.first+speedline.beginning)*1000,visuallyReady:(visuallyReadyInMs+speedline.beginning)*1000,visuallyComplete:(speedline.complete+speedline.beginning)*1000,speedIndex:(speedline.speedIndex+speedline.beginning)*1000,perceptualSpeedIndex:(speedline.perceptualSpeedIndex+speedline.beginning)*1000},frames:speedline.frames.map(frame=>{return{timestamp:frame.getTimeStamp(),progress:frame.getPerceptualProgress()};})};const rawValue=Math.round(speedline.perceptualSpeedIndex);return{score,rawValue,displayValue:Util.formatNumber(rawValue),optimalValue:this.meta.optimalValue,extendedInfo:{value:extendedInfo}};});}}
module.exports=SpeedIndexMetric;},{"../report/v2/renderer/util":32,"./audit":2}],"../audits/splash-screen":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');class SplashScreen extends MultiCheckAudit{static get meta(){return{category:'PWA',name:'splash-screen',description:'Configured for a custom splash screen',failureDescription:'Is not configured for a custom splash screen',helpText:'A default splash screen will be constructed for your app, but satisfying these requirements guarantee a high-quality [splash screen](https://developers.google.com/web/updates/2015/10/splashscreen) that transitions the user from tapping the home screen icon to your app\'s first paint',requiredArtifacts:['Manifest']};}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure){failures.push(manifestValues.parseFailureReason);return;}
const splashScreenCheckIds=['hasName','hasBackgroundColor','hasThemeColor','hasIconsAtLeast512px'];manifestValues.allChecks.filter(item=>splashScreenCheckIds.includes(item.id)).forEach(item=>{if(!item.passing){failures.push(item.failureText);}});}
static audit_(artifacts){const failures=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{SplashScreen.assessManifest(manifestValues,failures);return{failures,manifestValues};});}}
module.exports=SplashScreen;},{"./multi-check-audit":5}],"../audits/themed-omnibox":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const validColor=require('../lib/web-inspector').Color.parse;class ThemedOmnibox extends MultiCheckAudit{static get meta(){return{category:'PWA',name:'themed-omnibox',description:'Address bar matches brand colors',failureDescription:'Address bar does not match brand colors',helpText:'The browser address bar can be themed to match your site. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/address-bar).',requiredArtifacts:['Manifest','ThemeColor']};}
static assessMetaThemecolor(themeColorMeta,failures){if(themeColorMeta===null){failures.push('No `<meta name="theme-color">` tag found');}else if(!validColor(themeColorMeta)){failures.push('The theme-color meta tag did not contain a valid CSS color');}}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure){failures.push(manifestValues.parseFailureReason);return;}
const themeColorCheck=manifestValues.allChecks.find(i=>i.id==='hasThemeColor');if(!themeColorCheck.passing){failures.push(themeColorCheck.failureText);}}
static audit_(artifacts){const failures=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{ThemedOmnibox.assessManifest(manifestValues,failures);ThemedOmnibox.assessMetaThemecolor(artifacts.ThemeColor,failures);return{failures,manifestValues,themeColor:artifacts.ThemeColor};});}}
module.exports=ThemedOmnibox;},{"../lib/web-inspector":31,"./multi-check-audit":5}],"../audits/time-to-firstbyte":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util');const URL=require('../lib/url-shim');const TTFB_THRESHOLD=200;const TTFB_THRESHOLD_BUFFER=15;class TTFBMetric extends Audit{static get meta(){return{category:'Performance',name:'time-to-firstbyte',description:'Time To First Byte (TTFB)',informative:true,helpText:'Time To First Byte identifies the time at which your server sends a response.'+'[Learn more](https://developers.google.com/web/tools/chrome-devtools/network-performance/issues).',requiredArtifacts:['networkRecords']};}
static caclulateTTFB(record){const timing=record._timing;return timing.receiveHeadersEnd-timing.sendEnd;}
static audit(artifacts){const networkRecords=artifacts.networkRecords[Audit.DEFAULT_PASS];const results=[];const walk=node=>{const children=Object.keys(node);children.forEach(id=>{const child=node[id];const networkRecord=networkRecords.find(record=>record._requestId===id);if(networkRecord){const ttfb=TTFBMetric.caclulateTTFB(networkRecord);results.push({url:URL.getURLDisplayName(networkRecord._url),ttfb:Util.formatMilliseconds(Math.round(ttfb),1),rawTTFB:ttfb});}
if(child.children){walk(child.children);}});};return artifacts.requestCriticalRequestChains(networkRecords).then(tree=>{walk(tree);const recordsOverBudget=results.filter(row=>row.rawTTFB>TTFB_THRESHOLD+TTFB_THRESHOLD_BUFFER);let displayValue;if(recordsOverBudget.length){const thresholdDisplay=Util.formatMiliseconds(TTFB_THRESHOLD,1);const recordsOverBudgetDisplay=Util.formatNumber(recordsOverBudget.length);displayValue=`${recordsOverBudgetDisplay} critical request(s) went over`+` the ${thresholdDisplay} threshold`;}
return{rawValue:recordsOverBudget.length===0,displayValue,extendedInfo:{value:{results,tableHeadings:{url:'Request URL',ttfb:'Time To First Byte'}}}};});}}
module.exports=TTFBMetric;},{"../lib/url-shim":30,"../report/v2/renderer/util":32,"./audit":2}],"../audits/user-timings":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util');class UserTimings extends Audit{static get meta(){return{category:'Performance',name:'user-timings',description:'User Timing marks and measures',helpText:'Consider instrumenting your app with the User Timing API to create custom, '+'real-world measurements of key user experiences. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/user-timing).',requiredArtifacts:['traces'],informative:true};}
static filterTrace(tabTrace){const userTimings=[];const measuresStartTimes={};tabTrace.processEvents.filter(evt=>{if(!evt.cat.includes('blink.user_timing')){return false;}
return evt.name!=='requestStart'&&evt.name!=='navigationStart'&&evt.name!=='paintNonDefaultBackgroundColor'&&evt.args.frame===undefined;}).forEach(ut=>{if(ut.ph==='R'||ut.ph.toUpperCase()==='I'){userTimings.push({name:ut.name,isMark:true,args:ut.args,startTime:ut.ts});}else if(ut.ph.toLowerCase()==='b'){measuresStartTimes[ut.name]=ut.ts;}else if(ut.ph.toLowerCase()==='e'){userTimings.push({name:ut.name,isMark:false,args:ut.args,startTime:measuresStartTimes[ut.name],endTime:ut.ts});}});userTimings.forEach(ut=>{ut.startTime=(ut.startTime-tabTrace.navigationStartEvt.ts)/1000;if(!ut.isMark){ut.endTime=(ut.endTime-tabTrace.navigationStartEvt.ts)/1000;ut.duration=ut.endTime-ut.startTime;}});return userTimings;}
static get blacklistedPrefixes(){return['goog_'];}
static excludeBlacklisted(timing){return UserTimings.blacklistedPrefixes.every(prefix=>!timing.name.startsWith(prefix));}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(tabTrace=>{const userTimings=this.filterTrace(tabTrace).filter(UserTimings.excludeBlacklisted);const tableRows=userTimings.map(item=>{const time=item.isMark?item.startTime:item.duration;return{name:item.name,timingType:item.isMark?'Mark':'Measure',time:Util.formatMilliseconds(time,0.001),timeAsNumber:time};}).sort((itemA,itemB)=>{if(itemA.timingType===itemB.timingType){return itemA.timeAsNumber-itemB.timeAsNumber;}else if(itemA.timingType==='Measure'){return-1;}else{return 1;}});const headings=[{key:'name',itemType:'text',text:'Name'},{key:'timingType',itemType:'text',text:'Type'},{key:'time',itemType:'text',text:'Time'}];const details=Audit.makeTableDetails(headings,tableRows);return{rawValue:userTimings.length===0,displayValue:userTimings.length,extendedInfo:{value:userTimings},details};});}}
module.exports=UserTimings;},{"../report/v2/renderer/util":32,"./audit":2}],"../audits/viewport":[function(require,module,exports){'use strict';const Audit=require('./audit');const Parser=require('metaviewport-parser');class Viewport extends Audit{static get meta(){return{category:'Mobile Friendly',name:'viewport',description:'Has a `<meta name="viewport">` tag with `width` or `initial-scale`',failureDescription:'Does not have a `<meta name="viewport">` tag with `width` '+'or `initial-scale`',helpText:'Add a viewport meta tag to optimize your app for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/has-viewport-meta-tag).',requiredArtifacts:['Viewport']};}
static audit(artifacts){if(artifacts.Viewport===null){return{debugString:'No viewport meta tag found',rawValue:false};}
let debugString='';const parsedProps=Parser.parseMetaViewPortContent(artifacts.Viewport);if(Object.keys(parsedProps.unknownProperties).length){debugString+=`Invalid properties found: ${JSON.stringify(parsedProps.unknownProperties)}. `;}
if(Object.keys(parsedProps.invalidValues).length){debugString+=`Invalid values found: ${JSON.stringify(parsedProps.invalidValues)}. `;}
debugString=debugString.trim();const viewportProps=parsedProps.validProperties;const hasMobileViewport=viewportProps.width||viewportProps['initial-scale'];return{rawValue:!!hasMobileViewport,debugString};}}
module.exports=Viewport;},{"./audit":2,"metaviewport-parser":110}],"../audits/webapp-install-banner":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const SWAudit=require('./service-worker');class WebappInstallBanner extends MultiCheckAudit{static get meta(){return{category:'PWA',name:'webapp-install-banner',description:'User can be prompted to Install the Web App',failureDescription:'User will not be prompted to Install the Web App',helpText:'Browsers can proactively prompt users to add your app to their homescreen, '+'which can lead to higher engagement. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/install-prompt).',requiredArtifacts:['URL','ServiceWorker','Manifest','StartUrl']};}
static assessManifest(artifacts,result){const{manifestValues,failures}=result;if(manifestValues.isParseFailure){failures.push(manifestValues.parseFailureReason);return;}
const bannerCheckIds=['hasName','hasShortName','hasStartUrl','hasPWADisplayValue','hasIconsAtLeast192px'];manifestValues.allChecks.filter(item=>bannerCheckIds.includes(item.id)).forEach(item=>{if(!item.passing){failures.push(item.failureText);}});}
static assessServiceWorker(artifacts,result){const hasServiceWorker=SWAudit.audit(artifacts).rawValue;if(!hasServiceWorker){result.failures.push('Site does not register a Service Worker');}}
static assessOfflineStartUrl(artifacts,result){const hasOfflineStartUrl=artifacts.StartUrl.statusCode===200;if(!hasOfflineStartUrl){result.failures.push('Manifest start_url is not cached by a Service Worker');}
if(artifacts.StartUrl.debugString){result.warnings.push(artifacts.StartUrl.debugString);}}
static audit_(artifacts){const failures=[];const warnings=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{const result={warnings,failures,manifestValues};WebappInstallBanner.assessManifest(artifacts,result);WebappInstallBanner.assessServiceWorker(artifacts,result);WebappInstallBanner.assessOfflineStartUrl(artifacts,result);return result;});}}
module.exports=WebappInstallBanner;},{"./multi-check-audit":5,"./service-worker":"../audits/service-worker"}],"../audits/without-javascript":[function(require,module,exports){'use strict';const Audit=require('./audit');class WithoutJavaScript extends Audit{static get meta(){return{category:'JavaScript',name:'without-javascript',description:'Contains some content when JavaScript is not available',failureDescription:'Does not provide fallback content when JavaScript is not available',helpText:'Your app should display some content when JavaScript is disabled, even if it\'s '+'just a warning to the user that JavaScript is required to use the app. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/no-js).',requiredArtifacts:['HTMLWithoutJavaScript']};}
static audit(artifacts){const artifact=artifacts.HTMLWithoutJavaScript;if(artifact.value.trim()===''){return{rawValue:false,debugString:'The page body should render some content if its scripts are not available.'};}
return{rawValue:true};}}
module.exports=WithoutJavaScript;},{"./audit":2}],"../audits/works-offline":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');class WorksOffline extends Audit{static get meta(){return{category:'Offline',name:'works-offline',description:'Responds with a 200 when offline',failureDescription:'Does not respond with a 200 when offline',helpText:'If you\'re building a Progressive Web App, consider using a service worker so '+'that your app can work offline. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-200-when-offline).',requiredArtifacts:['Offline','URL']};}
static audit(artifacts){let debugString;const passed=artifacts.Offline===200;if(!passed&&!URL.equalWithExcludedFragments(artifacts.URL.initialUrl,artifacts.URL.finalUrl)){debugString='WARNING: You may be failing this check because your test URL '+`(${artifacts.URL.initialUrl}) was redirected to "${artifacts.URL.finalUrl}". `+'Try testing the second URL directly.';}
return{rawValue:passed,debugString};}}
module.exports=WorksOffline;},{"../lib/url-shim":30,"./audit":2}],"./gather/computed/computed-artifact":[function(require,module,exports){'use strict';class ComputedArtifact{constructor(allComputedArtifacts){this._cache=new Map();this._allComputedArtifacts=allComputedArtifacts;}
get requiredNumberOfArtifacts(){return 1;}
compute_(artifact,allComputedArtifacts){throw new Error('compute_() not implemented for computed artifact '+this.name);}
_performCacheOperation(artifacts,cacheOperation){artifacts=artifacts.slice();let cache=this._cache;while(artifacts.length>1){const nextKey=artifacts.shift();if(cache.has(nextKey)){cache=cache.get(nextKey);}else{const nextCache=new Map();cache.set(nextKey,nextCache);cache=nextCache;}}
return cacheOperation(cache,artifacts.shift());}
_cacheHas(artifacts){return this._performCacheOperation(artifacts,(cache,key)=>cache.has(key));}
_cacheGet(artifacts){return this._performCacheOperation(artifacts,(cache,key)=>cache.get(key));}
_cacheSet(artifacts,result){return this._performCacheOperation(artifacts,(cache,key)=>cache.set(key,result));}
_assertCorrectNumberOfArtifacts(artifacts){const actual=artifacts.length;const expected=this.requiredNumberOfArtifacts;if(actual!==expected){const className=this.constructor.name;throw new Error(`${className} requires ${expected} artifacts but ${actual} were given`);}}
request(...artifacts){this._assertCorrectNumberOfArtifacts(artifacts);if(this._cacheHas(artifacts)){return Promise.resolve(this._cacheGet(artifacts));}
const artifactPromise=Promise.resolve().then(_=>this.compute_(...artifacts,this._allComputedArtifacts));this._cacheSet(artifacts,artifactPromise);return artifactPromise;}}
module.exports=ComputedArtifact;},{}],"./gather/computed/critical-request-chains":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const WebInspector=require('../../lib/web-inspector');class CriticalRequestChains extends ComputedArtifact{get name(){return'CriticalRequestChains';}
static isCritical(request){const resourceTypeCategory=request._resourceType&&request._resourceType._category;const nonCriticalResourceTypes=[WebInspector.resourceTypes.Image._category,WebInspector.resourceTypes.XHR._category];if(nonCriticalResourceTypes.includes(resourceTypeCategory)||request.mimeType&&request.mimeType.startsWith('image/')){return false;}
return['VeryHigh','High','Medium'].includes(request.priority());}
static extractChain(networkRecords){networkRecords=networkRecords.filter(req=>req.finished);const requestIdToRequests=new Map();for(const request of networkRecords){requestIdToRequests.set(request.requestId,request);}
const criticalRequests=networkRecords.filter(CriticalRequestChains.isCritical);const flattenRequest=request=>{return{url:request._url,startTime:request.startTime,endTime:request.endTime,responseReceivedTime:request.responseReceivedTime,transferSize:request.transferSize};};const criticalRequestChains={};for(const request of criticalRequests){const ancestors=[];let ancestorRequest=request.initiatorRequest();let node=criticalRequestChains;while(ancestorRequest){const ancestorIsCritical=CriticalRequestChains.isCritical(ancestorRequest);if(!ancestorIsCritical||ancestors.includes(ancestorRequest.requestId)){ancestors.length=0;node=undefined;break;}
ancestors.push(ancestorRequest.requestId);ancestorRequest=ancestorRequest.initiatorRequest();}
let ancestor=ancestors.pop();while(ancestor){const parentRequest=requestIdToRequests.get(ancestor);const parentRequestId=parentRequest.requestId;if(!node[parentRequestId]){node[parentRequestId]={request:flattenRequest(parentRequest),children:{}};}
ancestor=ancestors.pop();node=node[parentRequestId].children;}
if(!node){continue;}
if(node[request.requestId]){continue;}
node[request.requestId]={request:flattenRequest(request),children:{}};}
return criticalRequestChains;}
compute_(devtoolsLog,artifacts){return artifacts.requestNetworkRecords(devtoolsLog).then(CriticalRequestChains.extractChain);}}
module.exports=CriticalRequestChains;},{"../../lib/web-inspector":31,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/first-interactive":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const TracingProcessor=require('../../lib/traces/tracing-processor');const LONG_TASK_THRESHOLD=50;const MAX_TASK_CLUSTER_DURATION=250;const MIN_TASK_CLUSTER_PADDING=1000;const MIN_TASK_CLUSTER_FMP_DISTANCE=5000;const MAX_QUIET_WINDOW_SIZE=5000;const TRACE_BUSY_MSG='The main thread was busy for the entire trace recording. '+'First Interactive requires the main thread to be idle for several seconds.';const EXPONENTIATION_COEFFICIENT=-Math.log(3-1)/15;class FirstInteractive extends ComputedArtifact{get name(){return'FirstInteractive';}
static getRequiredWindowSizeInMs(t){const tInSeconds=t/1000;const exponentiationComponent=Math.exp(EXPONENTIATION_COEFFICIENT*tInSeconds);return(4*exponentiationComponent+1)*1000;}
static getTaskClustersInWindow(tasks,startIndex,windowEnd){const clusters=[];let previousTaskEndTime=-Infinity;let currentCluster=null;const clusteringWindowEnd=windowEnd+MIN_TASK_CLUSTER_PADDING;const isInClusteringWindow=task=>task.start<clusteringWindowEnd;for(let i=startIndex;i<tasks.length;i++){if(!isInClusteringWindow(tasks[i])){break;}
const task=tasks[i];if(task.start-previousTaskEndTime>MIN_TASK_CLUSTER_PADDING){currentCluster=[];clusters.push(currentCluster);}
currentCluster.push(task);previousTaskEndTime=task.end;}
return clusters.map(tasks=>{const start=tasks[0].start;const end=tasks[tasks.length-1].end;const duration=end-start;return{start,end,duration};}).filter(cluster=>cluster.start<windowEnd);}
static findQuietWindow(FMP,traceEnd,longTasks){if(longTasks.length===0||longTasks[0].start>FMP+FirstInteractive.getRequiredWindowSizeInMs(0)){return FMP;}
const isTooCloseToFMP=cluster=>cluster.start<FMP+MIN_TASK_CLUSTER_FMP_DISTANCE;const isTooLong=cluster=>cluster.duration>MAX_TASK_CLUSTER_DURATION;const isBadCluster=cluster=>isTooCloseToFMP(cluster)||isTooLong(cluster);for(let i=0;i<longTasks.length;i++){const windowStart=longTasks[i].end;const windowSize=FirstInteractive.getRequiredWindowSizeInMs(windowStart-FMP);const windowEnd=windowStart+windowSize;if(windowEnd>traceEnd){throw new Error(TRACE_BUSY_MSG);}
if(i+1<longTasks.length&&longTasks[i+1].start-windowStart<=MIN_TASK_CLUSTER_PADDING){continue;}
const taskClusters=FirstInteractive.getTaskClustersInWindow(longTasks,i+1,windowEnd);const hasBadTaskClusters=taskClusters.some(isBadCluster);if(!hasBadTaskClusters){return windowStart;}}
throw new Error(TRACE_BUSY_MSG);}
computeWithArtifacts(traceOfTab){const navStart=traceOfTab.timestamps.navigationStart;const FMP=traceOfTab.timings.firstMeaningfulPaint;const DCL=traceOfTab.timings.domContentLoaded;const traceEnd=traceOfTab.timings.traceEnd;if(traceEnd-FMP<MAX_QUIET_WINDOW_SIZE){throw new Error('trace not at least 5 seconds longer than FMP');}
if(!FMP||!DCL){throw new Error(`No ${FMP?'domContentLoaded':'firstMeaningfulPaint'} event in trace`);}
const longTasksAfterFMP=TracingProcessor.getMainThreadTopLevelEvents(traceOfTab,FMP).filter(evt=>evt.duration>=LONG_TASK_THRESHOLD);const firstInteractive=FirstInteractive.findQuietWindow(FMP,traceEnd,longTasksAfterFMP);const valueInMs=Math.max(firstInteractive,DCL);return{timeInMs:valueInMs,timestamp:valueInMs*1000+navStart};}
compute_(trace,artifacts){return artifacts.requestTraceOfTab(trace).then(traceOfTab=>{return this.computeWithArtifacts(traceOfTab);});}}
module.exports=FirstInteractive;},{"../../lib/traces/tracing-processor":29,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/manifest-values":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const icons=require('../../lib/icons');const PWA_DISPLAY_VALUES=['minimal-ui','fullscreen','standalone'];const SUGGESTED_SHORTNAME_LENGTH=12;class ManifestValues extends ComputedArtifact{get name(){return'ManifestValues';}
static get validityIds(){return['hasManifest','hasParseableManifest'];}
static get manifestChecks(){return[{id:'hasStartUrl',failureText:'Manifest does not contain a `start_url`',validate:manifest=>!!manifest.value.start_url.value},{id:'hasIconsAtLeast192px',failureText:'Manifest does not have icons at least 192px',validate:manifest=>icons.doExist(manifest.value)&&icons.sizeAtLeast(192,manifest.value).length>0},{id:'hasIconsAtLeast512px',failureText:'Manifest does not have icons at least 512px',validate:manifest=>icons.doExist(manifest.value)&&icons.sizeAtLeast(512,manifest.value).length>0},{id:'hasPWADisplayValue',failureText:'Manifest\'s `display` value is not one of: '+PWA_DISPLAY_VALUES.join(' | '),validate:manifest=>PWA_DISPLAY_VALUES.includes(manifest.value.display.value)},{id:'hasBackgroundColor',failureText:'Manifest does not have `background_color`',validate:manifest=>!!manifest.value.background_color.value},{id:'hasThemeColor',failureText:'Manifest does not have `theme_color`',validate:manifest=>!!manifest.value.theme_color.value},{id:'hasShortName',failureText:'Manifest does not have `short_name`',validate:manifest=>!!manifest.value.short_name.value},{id:'shortNameLength',failureText:'Manifest `short_name` will be truncated when displayed on the homescreen',validate:manifest=>!!manifest.value.short_name.value&&manifest.value.short_name.value.length<=SUGGESTED_SHORTNAME_LENGTH},{id:'hasName',failureText:'Manifest does not have `name`',validate:manifest=>!!manifest.value.name.value}];}
compute_(manifest){let parseFailureReason;if(manifest===null){parseFailureReason='No manifest was fetched';}
if(manifest&&manifest.value===undefined){parseFailureReason='Manifest failed to parse as valid JSON';}
if(parseFailureReason){return{isParseFailure:true,parseFailureReason,allChecks:[]};}
const remainingChecks=ManifestValues.manifestChecks.map(item=>{item.passing=item.validate(manifest);return item;});return{isParseFailure:false,parseFailureReason,allChecks:remainingChecks};}}
module.exports=ManifestValues;},{"../../lib/icons":22,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/network-records":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkRecorder=require('../../lib/network-recorder');class NetworkRecords extends ComputedArtifact{get name(){return'NetworkRecords';}
compute_(devtoolsLog){return NetworkRecorder.recordsFromLogs(devtoolsLog);}}
module.exports=NetworkRecords;},{"../../lib/network-recorder":24,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/network-throughput":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class NetworkThroughput extends ComputedArtifact{get name(){return'NetworkThroughput';}
static getThroughput(networkRecords){let totalBytes=0;const timeBoundaries=networkRecords.reduce((boundaries,record)=>{const scheme=record.parsedURL&&record.parsedURL.scheme;if(scheme==='data'||record.failed||!record.finished||record.statusCode>300||!record.transferSize){return boundaries;}
totalBytes+=record.transferSize;boundaries.push({time:record.responseReceivedTime,isStart:true});boundaries.push({time:record.endTime,isStart:false});return boundaries;},[]).sort((a,b)=>a.time-b.time);if(!timeBoundaries.length){return Infinity;}
let inflight=0;let currentStart=0;let totalDuration=0;timeBoundaries.forEach(boundary=>{if(boundary.isStart){if(inflight===0){currentStart=boundary.time;}
inflight++;}else{inflight--;if(inflight===0){totalDuration+=boundary.time-currentStart;}}});return totalBytes/totalDuration;}
compute_(devtoolsLog,artifacts){return artifacts.requestNetworkRecords(devtoolsLog).then(NetworkThroughput.getThroughput);}}
module.exports=NetworkThroughput;},{"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/pushed-requests":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class PushedRequests extends ComputedArtifact{get name(){return'PushedRequests';}
compute_(devtoolsLog,artifacts){return artifacts.requestNetworkRecords(devtoolsLog).then(records=>{const pushedRecords=records.filter(r=>r._timing&&!!r._timing.pushStart);return pushedRecords;});}}
module.exports=PushedRequests;},{"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/screenshots":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const DevtoolsTimelineModel=require('../../lib/traces/devtools-timeline-model');class ScreenshotFilmstrip extends ComputedArtifact{get name(){return'Screenshots';}
fetchScreenshot(frame){return frame.imageDataPromise().then(data=>'data:image/jpg;base64,'+data);}
compute_(trace){const model=new DevtoolsTimelineModel(trace.traceEvents);const filmStripFrames=model.filmStripModel().frames();const frameFetches=filmStripFrames.map(frame=>this.fetchScreenshot(frame));return Promise.all(frameFetches).then(images=>{const result=filmStripFrames.map((frame,i)=>({timestamp:frame.timestamp,datauri:images[i]}));return result;});}}
module.exports=ScreenshotFilmstrip;},{"../../lib/traces/devtools-timeline-model":27,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/speedline":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const speedline=require('speedline');class Speedline extends ComputedArtifact{get name(){return'Speedline';}
compute_(trace,computedArtifacts){return computedArtifacts.requestTraceOfTab(trace).then(traceOfTab=>{const traceEvents=trace.traceEvents.slice();const navStart=traceOfTab.timestamps.navigationStart;return speedline(traceEvents,{timeOrigin:navStart,fastMode:true});});}}
module.exports=Speedline;},{"./computed-artifact":"./gather/computed/computed-artifact","speedline":113}],"./gather/computed/trace-of-tab":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const log=require('lighthouse-logger');const WebInspector=require('../../lib/web-inspector');class TraceOfTab extends ComputedArtifact{get name(){return'TraceOfTab';}
compute_(trace){const keyEvents=trace.traceEvents.filter(e=>{return e.cat.includes('blink.user_timing')||e.cat.includes('loading')||e.cat.includes('devtools.timeline')||e.name==='TracingStartedInPage';}).stableSort((event0,event1)=>event0.ts-event1.ts);const startedInPageEvt=keyEvents.find(e=>e.name==='TracingStartedInPage');const frameEvents=keyEvents.filter(e=>e.args.frame===startedInPageEvt.args.data.page);const navigationStart=frameEvents.filter(e=>e.name==='navigationStart').pop();if(!navigationStart)throw new Error('navigationStart was not found in the trace');const firstPaint=frameEvents.find(e=>e.name==='firstPaint'&&e.ts>navigationStart.ts);const firstContentfulPaint=frameEvents.find(e=>e.name==='firstContentfulPaint'&&e.ts>navigationStart.ts);let firstMeaningfulPaint=frameEvents.find(e=>e.name==='firstMeaningfulPaint'&&e.ts>navigationStart.ts);if(!firstMeaningfulPaint){const fmpCand='firstMeaningfulPaintCandidate';log.verbose('trace-of-tab',`No firstMeaningfulPaint found, falling back to last ${fmpCand}`);const lastCandidate=frameEvents.filter(e=>e.name===fmpCand).pop();if(!lastCandidate){log.verbose('trace-of-tab','No `firstMeaningfulPaintCandidate` events found in trace');}
firstMeaningfulPaint=lastCandidate;}
const onLoad=frameEvents.find(e=>e.name==='loadEventEnd'&&e.ts>navigationStart.ts);const domContentLoaded=frameEvents.find(e=>e.name==='domContentLoadedEventEnd'&&e.ts>navigationStart.ts);const processEvents=trace.traceEvents.filter(e=>e.pid===startedInPageEvt.pid).stableSort((event0,event1)=>event0.ts-event1.ts);const mainThreadEvents=processEvents.filter(e=>e.tid===startedInPageEvt.tid);const traceEnd=trace.traceEvents.reduce((max,evt)=>{return max.ts>evt.ts?max:evt;});const metrics={navigationStart,firstPaint,firstContentfulPaint,firstMeaningfulPaint,traceEnd:{ts:traceEnd.ts+(traceEnd.dur||0)},onLoad,domContentLoaded};const timings={};const timestamps={};Object.keys(metrics).forEach(metric=>{timestamps[metric]=metrics[metric]&&metrics[metric].ts;timings[metric]=(timestamps[metric]-navigationStart.ts)/1000;});return{timings,timestamps,processEvents,mainThreadEvents,startedInPageEvt,navigationStartEvt:navigationStart,firstPaintEvt:firstPaint,firstContentfulPaintEvt:firstContentfulPaint,firstMeaningfulPaintEvt:firstMeaningfulPaint,onLoadEvt:onLoad};}}
module.exports=TraceOfTab;},{"../../lib/web-inspector":31,"./computed-artifact":"./gather/computed/computed-artifact","lighthouse-logger":109}],"./gatherers/accessibility":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const axeLibSource="/*! aXe v2.2.1\n * Copyright (c) 2017 Deque Systems, Inc.\n *\n * Your use of this Source Code Form is subject to the terms of the Mozilla Public\n * License, v. 2.0. If a copy of the MPL was not distributed with this\n * file, You can obtain one at http://mozilla.org/MPL/2.0/.\n *\n * This entire copyright notice must appear in every copy of this file you\n * distribute or in any file that contains substantial portions of this source\n * code.\n */\n!function a(window){function b(a){this.name=\"SupportError\",this.cause=a.cause,this.message=\"`\"+a.cause+\"` - feature unsupported in your environment.\",a.ruleId&&(this.ruleId=a.ruleId,this.message+=\" Skipping \"+this.ruleId+\" rule.\"),this.stack=(new Error).stack}function c(a){\"use strict\";var b;return a?(b=axe.utils.clone(a),b.commons=a.commons):b={},b.reporter=b.reporter||null,b.rules=b.rules||[],b.checks=b.checks||[],b.data=Object.assign({checks:{},rules:{}},b.data),b}function d(a,b,c){\"use strict\";var d,e;for(d=0,e=a.length;d<e;d++)b[c](a[d])}function e(a){this.brand=\"axe\",this.application=\"axeAPI\",this.tagExclude=[\"experimental\"],this.defaultConfig=a,this._init()}function f(a,b,c){var d=a.brand,e=a.application;return axe.constants.helpUrlBase+d+\"/\"+(c||axe.version.substring(0,axe.version.lastIndexOf(\".\")))+\"/\"+b+\"?application=\"+e}function g(a){\"use strict\";this.id=a.id,this.data=null,this.relatedNodes=[],this.result=null}function h(a){\"use strict\";return\"string\"==typeof a?new Function(\"return \"+a+\";\")():a}function i(a){a&&(this.id=a.id,this.configure(a))}function j(a,b){\"use strict\";if(!axe.utils.isHidden(b)){axe.utils.findBy(a,\"node\",b)||a.push({node:b,include:[],exclude:[]})}}function k(a,b,c){\"use strict\";a.frames=a.frames||[];var d,e,f=document.querySelectorAll(c.shift());a:for(var g=0,h=f.length;g<h;g++){e=f[g];for(var i=0,j=a.frames.length;i<j;i++)if(a.frames[i].node===e){a.frames[i][b].push(c);break a}d={node:e,include:[],exclude:[]},c&&d[b].push(c),a.frames.push(d)}}function l(a){\"use strict\";if(a&&\"object\"===(void 0===a?\"undefined\":Z(a))||a instanceof NodeList){if(a instanceof Node)return{include:[a],exclude:[]};if(a.hasOwnProperty(\"include\")||a.hasOwnProperty(\"exclude\"))return{include:a.include&&+a.include.length?a.include:[document],exclude:a.exclude||[]};if(a.length===+a.length)return{include:a,exclude:[]}}return\"string\"==typeof a?{include:[a],exclude:[]}:{include:[document],exclude:[]}}function m(a,b){\"use strict\";for(var c,d=[],e=0,f=a[b].length;e<f;e++){if(\"string\"==typeof(c=a[b][e])){d=d.concat(axe.utils.toArray(document.querySelectorAll(c)));break}!c||!c.length||c instanceof Node?d.push(c):c.length>1?k(a,b,c):d=d.concat(axe.utils.toArray(document.querySelectorAll(c[0])))}return d.filter(function(a){return a})}function n(a){\"use strict\";if(0===a.include.length){if(0===a.frames.length){var b=axe.utils.respondable.isInFrame()?\"frame\":\"page\";return new Error(\"No elements found for include in \"+b+\" Context\")}a.frames.forEach(function(a,b){if(0===a.include.length)return new Error(\"No elements found for include in Context of frame \"+b)})}}function o(a){\"use strict\";var b=this;this.frames=[],this.initiator=!a||\"boolean\"!=typeof a.initiator||a.initiator,this.page=!1,a=l(a),this.exclude=a.exclude,this.include=a.include,this.include=m(this,\"include\"),this.exclude=m(this,\"exclude\"),axe.utils.select(\"frame, iframe\",this).forEach(function(a){X(a,b)&&j(b.frames,a)}),1===this.include.length&&this.include[0]===document&&(this.page=!0);var c=n(this);if(c instanceof Error)throw c}function p(a){\"use strict\";this.id=a.id,this.result=axe.constants.NA,this.pageLevel=a.pageLevel,this.impact=null,this.nodes=[]}function q(a,b){\"use strict\";this._audit=b,this.id=a.id,this.selector=a.selector||\"*\",this.excludeHidden=\"boolean\"!=typeof a.excludeHidden||a.excludeHidden,this.enabled=\"boolean\"!=typeof a.enabled||a.enabled,this.pageLevel=\"boolean\"==typeof a.pageLevel&&a.pageLevel,this.any=a.any||[],this.all=a.all||[],this.none=a.none||[],this.tags=a.tags||[],a.matches&&(this.matches=h(a.matches))}function r(a){\"use strict\";return axe.utils.getAllChecks(a).map(function(b){var c=a._audit.checks[b.id||b];return c&&\"function\"==typeof c.after?c:null}).filter(Boolean)}function s(a,b){\"use strict\";var c=[];return a.forEach(function(a){axe.utils.getAllChecks(a).forEach(function(a){a.id===b&&c.push(a)})}),c}function t(a){\"use strict\";return a.filter(function(a){return!0!==a.filtered})}function u(a){\"use strict\";var b=[\"any\",\"all\",\"none\"],c=a.nodes.filter(function(a){var c=0;return b.forEach(function(b){a[b]=t(a[b]),c+=a[b].length}),c>0});return a.pageLevel&&c.length&&(c=[c.reduce(function(a,c){if(a)return b.forEach(function(b){a[b].push.apply(a[b],c[b])}),a})]),c}function v(a,b){\"use strict\";if(!axe._audit)throw new Error(\"No audit configured\");var c=axe.utils.queue(),d=[];Object.keys(axe.plugins).forEach(function(a){c.defer(function(b){var c=function(a){d.push(a),b()};try{axe.plugins[a].cleanup(b,c)}catch(a){c(a)}})}),axe.utils.toArray(document.querySelectorAll(\"frame, iframe\")).forEach(function(a){c.defer(function(b,c){return axe.utils.sendCommandToFrame(a,{command:\"cleanup-plugin\"},b,c)})}),c.then(function(c){0===d.length?a(c):b(d)}).catch(b)}function w(a){\"use strict\";var b;if(!(b=axe._audit))throw new Error(\"No audit configured\");a.reporter&&(\"function\"==typeof a.reporter||aa[a.reporter])&&(b.reporter=a.reporter),a.checks&&a.checks.forEach(function(a){b.addCheck(a)}),a.rules&&a.rules.forEach(function(a){b.addRule(a)}),void 0!==a.branding?b.setBranding(a.branding):b._constructHelpUrls(),a.tagExclude&&(b.tagExclude=a.tagExclude)}function x(a,b,c){\"use strict\";var d=c,e=function(a){a instanceof Error==!1&&(a=new Error(a)),c(a)},f=a&&a.context||{};f.include&&!f.include.length&&(f.include=[document]);var g=a&&a.options||{};switch(a.command){case\"rules\":return A(f,g,d,e);case\"cleanup-plugin\":return v(d,e);default:if(axe._audit&&axe._audit.commands&&axe._audit.commands[a.command])return axe._audit.commands[a.command](a,c)}}function y(a){\"use strict\";this._run=a.run,this._collect=a.collect,this._registry={},a.commands.forEach(function(a){axe._audit.registerCommand(a)})}function z(){\"use strict\";var a=axe._audit;if(!a)throw new Error(\"No audit configured\");a.resetRulesAndChecks()}function A(a,b,c,d){\"use strict\";try{a=new o(a)}catch(a){return d(a)}var e=axe.utils.queue(),f=axe._audit;b.performanceTimer&&axe.utils.performanceTimer.auditStart(),a.frames.length&&!1!==b.iframes&&e.defer(function(c,d){axe.utils.collectResultsFromFrames(a,b,\"rules\",null,c,d)}),e.defer(function(c,d){f.run(a,b,c,d)}),e.then(function(e){try{b.performanceTimer&&axe.utils.performanceTimer.auditEnd();var g=axe.utils.mergeResults(e.map(function(a){return{results:a}}));a.initiator&&(g=f.after(g,b),g.forEach(axe.utils.publishMetaData),g=g.map(axe.utils.finalizeRuleResult));try{c(g)}catch(a){axe.log(a)}}catch(a){d(a)}}).catch(d)}function B(a){\"use strict\";switch(!0){case\"string\"==typeof a:case Array.isArray(a):case Node&&a instanceof Node:case NodeList&&a instanceof NodeList:return!0;case\"object\"!==(void 0===a?\"undefined\":Z(a)):return!1;case void 0!==a.include:case void 0!==a.exclude:case\"number\"==typeof a.length:return!0;default:return!1}}function C(a,b,c){\"use strict\";var d=new TypeError(\"axe.run arguments are invalid\");if(!B(a)){if(void 0!==c)throw d;c=b,b=a,a=document}if(\"object\"!==(void 0===b?\"undefined\":Z(b))){if(void 0!==c)throw d;c=b,b={}}if(\"function\"!=typeof c&&void 0!==c)throw d;return{context:a,options:b,callback:c||ba}}function D(a,b){\"use strict\";[\"any\",\"all\",\"none\"].forEach(function(c){Array.isArray(a[c])&&a[c].filter(function(a){return Array.isArray(a.relatedNodes)}).forEach(function(a){a.relatedNodes=a.relatedNodes.map(function(a){var c={html:a.source};return b.elementRef&&!a.fromFrame&&(c.element=a.element),(!1!==b.selectors||a.fromFrame)&&(c.target=a.selector),b.xpath&&(c.xpath=a.xpath),c})})})}function E(a,b){return ea.reduce(function(c,d){return c[d]=(a[d]||[]).map(function(a){return b(a,d)}),c},{})}function F(a,b,c){var d=Object.assign({},b);d.nodes=(d[c]||[]).concat(),axe.constants.resultGroups.forEach(function(a){delete d[a]}),a[c].push(d)}function G(a,b,c){\"use strict\";var d=window.getComputedStyle(a,null),e=!1;return!!d&&(b.forEach(function(a){d.getPropertyValue(a.property)===a.value&&(e=!0)}),!!e||!(a.nodeName.toUpperCase()===c.toUpperCase()||!a.parentNode)&&G(a.parentNode,b,c))}function H(a,b){\"use strict\";return new Error(a+\": \"+axe.utils.getSelector(b))}function I(a,b,c,d,e,f){\"use strict\";var g=axe.utils.queue();a.frames.forEach(function(e){var f={options:b,command:c,parameter:d,context:{initiator:!1,page:a.page,include:e.include||[],exclude:e.exclude||[]}};g.defer(function(a,b){var c=e.node;axe.utils.sendCommandToFrame(c,f,function(b){if(b)return a({results:b,frameElement:c,frame:axe.utils.getSelector(c)});a(null)},b)})}),g.then(function(a){e(axe.utils.mergeResults(a))}).catch(f)}function J(a,b){\"use strict\";if(b=b||300,a.length>b){var c=a.indexOf(\">\");a=a.substring(0,c+1)}return a}function K(a){\"use strict\";var b=a.outerHTML;return b||\"function\"!=typeof XMLSerializer||(b=(new XMLSerializer).serializeToString(a)),J(b||\"\")}function L(a,b){\"use strict\";this._fromFrame=!!b,this.spec=b||{},this.source=void 0!==this.spec.source?this.spec.source:K(a),this._element=a}function M(a){\"use strict\";var b=1,c=a.nodeName.toUpperCase();for(a=a.previousElementSibling;a;)a.nodeName.toUpperCase()===c&&b++,a=a.previousElementSibling;return b}function N(a,b){\"use strict\";var c,d,e=a.parentNode.children;if(!e)return!1;var f=e.length;for(c=0;c<f;c++)if((d=e[c])!==a&&axe.utils.matchesSelector(d,b))return!0;return!1}function O(a,b){var c,d;if(!a)return[];if(!b&&9===a.nodeType)return b=[{str:\"html\"}];if(b=b||[],a.parentNode&&a.parentNode!==a&&(b=O(a.parentNode,b)),a.previousSibling){d=1,c=a.previousSibling;do{1===c.nodeType&&c.nodeName===a.nodeName&&d++,c=c.previousSibling}while(c);1===d&&(d=null)}else if(a.nextSibling){c=a.nextSibling;do{1===c.nodeType&&c.nodeName===a.nodeName?(d=1,c=null):(d=null,c=c.previousSibling)}while(c)}if(1===a.nodeType){var e={};e.str=a.nodeName.toLowerCase(),a.getAttribute&&a.getAttribute(\"id\")&&1===a.ownerDocument.querySelectorAll(\"#\"+axe.utils.escapeSelector(a.id)).length&&(e.id=a.getAttribute(\"id\")),d>1&&(e.count=d),b.push(e)}return b}function P(a){return a.reduce(function(a,b){return b.id?\"/\"+b.str+\"[@id='\"+b.id+\"']\":a+\"/\"+b.str+(b.count>0?\"[\"+b.count+\"]\":\"\")},\"\")}function Q(a){\"use strict\";if(fa&&fa.parentNode)return void 0===fa.styleSheet?fa.appendChild(document.createTextNode(a)):fa.styleSheet.cssText+=a,fa;if(a){var b=document.head||document.getElementsByTagName(\"head\")[0];return fa=document.createElement(\"style\"),fa.type=\"text/css\",void 0===fa.styleSheet?fa.appendChild(document.createTextNode(a)):fa.styleSheet.cssText=a,b.appendChild(fa),fa}}function R(a,b,c){\"use strict\";var d=axe.utils.getXpath(b),e={element:b,selector:c,xpath:d};a.forEach(function(a){a.node=axe.utils.DqElement.fromFrame(a.node,e);var b=axe.utils.getAllChecks(a);b.length&&b.forEach(function(a){a.relatedNodes=a.relatedNodes.map(function(a){return axe.utils.DqElement.fromFrame(a,e)})})})}function S(a,b){\"use strict\";for(var c,d,e=b[0].node,f=0,g=a.length;f<g;f++)if(d=a[f].node,(c=axe.utils.nodeSorter(d.element,e.element))>0||0===c&&e.selector.length<d.selector.length)return void a.splice.apply(a,[f,0].concat(b));a.push.apply(a,b)}function T(a){\"use strict\";return a&&a.results?Array.isArray(a.results)?a.results.length?a.results:null:[a.results]:null}function U(a,b){\"use strict\";return function(c){var d=a[c.id]||{},e=d.messages||{},f=Object.assign({},d);if(delete f.messages,void 0===c.result)if(\"object\"===Z(e.incomplete)){var g=c.data.missingData;g.forEach(function(a){var b;try{b=a.reason}catch(a){b=\"default\"}f.message=function(){return e.incomplete[b]}})}else f.message=e.incomplete;else f.message=c.result===b?e.pass:e.fail;axe.utils.extendMetaData(c,f)}}function V(a,b){\"use strict\";var c,d,e=axe._audit&&axe._audit.tagExclude?axe._audit.tagExclude:[];return b.include||b.exclude?(c=b.include||[],c=Array.isArray(c)?c:[c],d=b.exclude||[],d=Array.isArray(d)?d:[d],d=d.concat(e.filter(function(a){return-1===c.indexOf(a)}))):(c=Array.isArray(b)?b:[b],d=e.filter(function(a){return-1===c.indexOf(a)})),!!(c.some(function(b){return-1!==a.tags.indexOf(b)})||0===c.length&&!1!==a.enabled)&&d.every(function(b){return-1===a.tags.indexOf(b)})}function W(a){\"use strict\";return a.sort(function(a,b){return axe.utils.contains(a,b)?1:-1})[0]}function X(a,b){\"use strict\";var c=b.include&&W(b.include.filter(function(b){return axe.utils.contains(b,a)})),d=b.exclude&&W(b.exclude.filter(function(b){return axe.utils.contains(b,a)}));return!!(!d&&c||d&&axe.utils.contains(d,c))}function Y(a,b,c){\"use strict\";for(var d=0,e=b.length;d<e;d++)-1===a.indexOf(b[d])&&X(b[d],c)&&a.push(b[d])}var document=window.document,Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},axe=axe||{};axe.version=\"2.2.1\",\"function\"==typeof define&&define.amd&&define([],function(){\"use strict\";return axe}),\"object\"===(\"undefined\"==typeof module?\"undefined\":Z(module))&&module.exports&&\"function\"==typeof a.toString&&(axe.source=\"(\"+a.toString()+\")(this, this.document);\",module.exports=axe),\"function\"==typeof window.getComputedStyle&&(window.axe=axe);var commons;b.prototype=Object.create(Error.prototype),b.prototype.constructor=b;var utils=axe.utils={},$={},Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};e.prototype._init=function(){var a=c(this.defaultConfig);axe.commons=commons=a.commons,this.reporter=a.reporter,this.commands={},this.rules=[],this.checks={},d(a.rules,this,\"addRule\"),d(a.checks,this,\"addCheck\"),this.data={},this.data.checks=a.data&&a.data.checks||{},this.data.rules=a.data&&a.data.rules||{},this.data.failureSummaries=a.data&&a.data.failureSummaries||{},this._constructHelpUrls()},e.prototype.registerCommand=function(a){\"use strict\";this.commands[a.id]=a.callback},e.prototype.addRule=function(a){\"use strict\";a.metadata&&(this.data.rules[a.id]=a.metadata);var b=this.getRule(a.id);b?b.configure(a):this.rules.push(new q(a,this))},e.prototype.addCheck=function(a){\"use strict\";var b=a.metadata;\"object\"===(void 0===b?\"undefined\":Z(b))&&(this.data.checks[a.id]=b,\"object\"===Z(b.messages)&&Object.keys(b.messages).filter(function(a){return b.messages.hasOwnProperty(a)&&\"string\"==typeof b.messages[a]}).forEach(function(a){0===b.messages[a].indexOf(\"function\")&&(b.messages[a]=new Function(\"return \"+b.messages[a]+\";\")())})),this.checks[a.id]?this.checks[a.id].configure(a):this.checks[a.id]=new i(a)},e.prototype.run=function(a,b,c,d){\"use strict\";this.validateOptions(b);var e=axe.utils.queue();this.rules.forEach(function(c){if(axe.utils.ruleShouldRun(c,a,b)){if(b.performanceTimer){var d=\"mark_rule_end_\"+c.id,f=\"mark_rule_start_\"+c.id;axe.utils.performanceTimer.mark(f)}e.defer(function(e,g){c.run(a,b,function(a){b.performanceTimer&&(axe.utils.performanceTimer.mark(d),axe.utils.performanceTimer.measure(\"rule_\"+c.id,f,d)),e(a)},function(a){if(b.debug)g(a);else{var d=Object.assign(new p(c),{result:axe.constants.CANTTELL,description:\"An error occured while running this rule\",message:a.message,help:a.stack||a.message,error:a});e(d)}})})}}),e.then(function(a){c(a.filter(function(a){return!!a}))}).catch(d)},e.prototype.after=function(a,b){\"use strict\";var c=this.rules;return a.map(function(a){return axe.utils.findBy(c,\"id\",a.id).after(a,b)})},e.prototype.getRule=function(a){return this.rules.find(function(b){return b.id===a})},e.prototype.validateOptions=function(a){\"use strict\";var b=this;if(\"object\"===Z(a.runOnly)){var c=a.runOnly;if(\"rule\"===c.type&&Array.isArray(c.value))c.value.forEach(function(a){if(!b.getRule(a))throw new Error(\"unknown rule `\"+a+\"` in options.runOnly\")});else if(Array.isArray(c.value)&&c.value.length>0){var d=[].concat(c.value);if(b.rules.forEach(function(a){var b,c,e;if(d)for(c=0,e=a.tags.length;c<e;c++)-1!==(b=d.indexOf(a.tags[c]))&&d.splice(b,1)}),0!==d.length)throw new Error(\"could not find tags `\"+d.join(\"`, `\")+\"`\")}}return\"object\"===Z(a.rules)&&Object.keys(a.rules).forEach(function(a){if(!b.getRule(a))throw new Error(\"unknown rule `\"+a+\"` in options.rules\")}),a},e.prototype.setBranding=function(a){\"use strict\";var b={brand:this.brand,application:this.application};a&&a.hasOwnProperty(\"brand\")&&a.brand&&\"string\"==typeof a.brand&&(this.brand=a.brand),a&&a.hasOwnProperty(\"application\")&&a.application&&\"string\"==typeof a.application&&(this.application=a.application),this._constructHelpUrls(b)},e.prototype._constructHelpUrls=function(){var a=this,b=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,c=axe.version.substring(0,axe.version.lastIndexOf(\".\"));this.rules.forEach(function(d){a.data.rules[d.id]||(a.data.rules[d.id]={});var e=a.data.rules[d.id];(\"string\"!=typeof e.helpUrl||b&&e.helpUrl===f(b,d.id,c))&&(e.helpUrl=f(a,d.id,c))})},e.prototype.resetRulesAndChecks=function(){\"use strict\";this._init()},i.prototype.enabled=!0,i.prototype.run=function(a,b,c,d){\"use strict\";b=b||{};var e=b.hasOwnProperty(\"enabled\")?b.enabled:this.enabled,f=b.options||this.options;if(e){var h,i=new g(this),j=axe.utils.checkHelper(i,c,d);try{h=this.evaluate.call(j,a,f)}catch(a){return void d(a)}j.isAsync||(i.result=h,setTimeout(function(){c(i)},0))}else c(null)},i.prototype.configure=function(a){var b=this;[\"options\",\"enabled\"].filter(function(b){return a.hasOwnProperty(b)}).forEach(function(c){return b[c]=a[c]}),[\"evaluate\",\"after\"].filter(function(b){return a.hasOwnProperty(b)}).forEach(function(c){return b[c]=h(a[c])})};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};q.prototype.matches=function(){\"use strict\";return!0},q.prototype.gather=function(a){\"use strict\";var b=axe.utils.select(this.selector,a);return this.excludeHidden?b.filter(function(a){return!axe.utils.isHidden(a)}):b},q.prototype.runChecks=function(a,b,c,d,e){\"use strict\";var f=this,g=axe.utils.queue();this[a].forEach(function(a){var d=f._audit.checks[a.id||a],e=axe.utils.getCheckOption(d,f.id,c);g.defer(function(a,c){d.run(b,e,a,c)})}),g.then(function(b){b=b.filter(function(a){return a}),d({type:a,results:b})}).catch(e)},q.prototype.run=function(a,c,d,e){var f=this,g=axe.utils.queue(),h=new p(this),i=void 0;try{i=this.gather(a).filter(function(a){return f.matches(a)})}catch(a){return void e(new b({cause:a,ruleId:this.id}))}c.performanceTimer&&axe.log(\"gather (\",i.length,\"):\",axe.utils.performanceTimer.timeElapsed()+\"ms\"),i.forEach(function(a){g.defer(function(b,d){var e=axe.utils.queue();e.defer(function(b,d){f.runChecks(\"any\",a,c,b,d)}),e.defer(function(b,d){f.runChecks(\"all\",a,c,b,d)}),e.defer(function(b,d){f.runChecks(\"none\",a,c,b,d)}),e.then(function(c){if(c.length){var d=!1,e={};c.forEach(function(a){var b=a.results.filter(function(a){return a});e[a.type]=b,b.length&&(d=!0)}),d&&(e.node=new axe.utils.DqElement(a),h.nodes.push(e))}b()}).catch(function(a){return d(a)})})}),g.then(function(){return d(h)}).catch(function(a){return e(a)})},q.prototype.after=function(a,b){\"use strict\";var c=r(this),d=this.id;return c.forEach(function(c){var e=s(a.nodes,c.id),f=axe.utils.getCheckOption(c,d,b),g=c.after(e,f);e.forEach(function(a){-1===g.indexOf(a)&&(a.filtered=!0)})}),a.nodes=u(a),a},q.prototype.configure=function(a){\"use strict\";a.hasOwnProperty(\"selector\")&&(this.selector=a.selector),a.hasOwnProperty(\"excludeHidden\")&&(this.excludeHidden=\"boolean\"!=typeof a.excludeHidden||a.excludeHidden),a.hasOwnProperty(\"enabled\")&&(this.enabled=\"boolean\"!=typeof a.enabled||a.enabled),a.hasOwnProperty(\"pageLevel\")&&(this.pageLevel=\"boolean\"==typeof a.pageLevel&&a.pageLevel),a.hasOwnProperty(\"any\")&&(this.any=a.any),a.hasOwnProperty(\"all\")&&(this.all=a.all),a.hasOwnProperty(\"none\")&&(this.none=a.none),a.hasOwnProperty(\"tags\")&&(this.tags=a.tags),a.hasOwnProperty(\"matches\")&&(\"string\"==typeof a.matches?this.matches=new Function(\"return \"+a.matches+\";\")():this.matches=a.matches)},function(axe){var a=[{name:\"NA\",value:\"inapplicable\",priority:0,group:\"inapplicable\"},{name:\"PASS\",value:\"passed\",priority:1,group:\"passes\"},{name:\"CANTTELL\",value:\"cantTell\",priority:2,group:\"incomplete\"},{name:\"FAIL\",value:\"failed\",priority:3,group:\"violations\"}],b={helpUrlBase:\"https://dequeuniversity.com/rules/\",results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze([\"minor\",\"moderate\",\"serious\",\"critical\"])};a.forEach(function(a){var c=a.name,d=a.value,e=a.priority,f=a.group;b[c]=d,b[c+\"_PRIO\"]=e,b[c+\"_GROUP\"]=f,b.results[e]=d,b.resultGroups[e]=f,b.resultGroupMap[d]=f}),Object.freeze(b.results),Object.freeze(b.resultGroups),Object.freeze(b.resultGroupMap),Object.freeze(b),Object.defineProperty(axe,\"constants\",{value:b,enumerable:!0,configurable:!1,writable:!1})}(axe);var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.log=function(){\"use strict\";\"object\"===(\"undefined\"==typeof console?\"undefined\":Z(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.a11yCheck=function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={}),b&&\"object\"===(void 0===b?\"undefined\":Z(b))||(b={});var d=axe._audit;if(!d)throw new Error(\"No audit configured\");b.reporter=b.reporter||d.reporter||\"v2\",b.performanceTimer&&axe.utils.performanceTimer.start();var e=axe.getReporter(b.reporter);axe._runRules(a,b,function(a){var d=e(a,b,c);void 0!==d&&(b.performanceTimer&&axe.utils.performanceTimer.end(),c(d))},axe.log)},axe.cleanup=v,axe.configure=w,axe.getRules=function(a){\"use strict\";a=a||[];var b=a.length?axe._audit.rules.filter(function(b){return!!a.filter(function(a){return-1!==b.tags.indexOf(a)}).length}):axe._audit.rules,c=axe._audit.data.rules||{};return b.map(function(a){var b=c[a.id]||{};return{ruleId:a.id,description:b.description,help:b.help,helpUrl:b.helpUrl,tags:a.tags}})},axe._load=function(a){\"use strict\";axe.utils.respondable.subscribe(\"axe.ping\",function(a,b,c){c({axe:!0})}),axe.utils.respondable.subscribe(\"axe.start\",x),axe._audit=new e(a)};var axe=axe||{};axe.plugins={},y.prototype.run=function(){\"use strict\";return this._run.apply(this,arguments)},y.prototype.collect=function(){\"use strict\";return this._collect.apply(this,arguments)},y.prototype.cleanup=function(a){\"use strict\";var b=axe.utils.queue(),c=this;Object.keys(this._registry).forEach(function(a){b.defer(function(b){c._registry[a].cleanup(b)})}),b.then(function(){a()})},y.prototype.add=function(a){\"use strict\";this._registry[a.id]=a},axe.registerPlugin=function(a){\"use strict\";axe.plugins[a.id]=new y(a)};var _,aa={};axe.getReporter=function(a){\"use strict\";return\"string\"==typeof a&&aa[a]?aa[a]:\"function\"==typeof a?a:_},axe.addReporter=function(a,b,c){\"use strict\";aa[a]=b,c&&(_=b)},axe.reset=z,axe._runRules=A;var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},ba=function(){};axe.run=function(a,b,c){\"use strict\";if(!axe._audit)throw new Error(\"No audit configured\");var d=C(a,b,c);a=d.context,b=d.options,c=d.callback,b.reporter=b.reporter||axe._audit.reporter||\"v1\",b.performanceTimer&&axe.utils.performanceTimer.start();var e=void 0,f=ba,g=ba;return window.Promise&&c===ba&&(e=new Promise(function(a,b){f=b,g=a})),axe._runRules(a,b,function(a){var d=function(a){try{c(null,a)}catch(a){axe.log(a)}g(a)};b.performanceTimer&&axe.utils.performanceTimer.end();try{var e=axe.getReporter(b.reporter),h=e(a,b,d);void 0!==h&&d(h)}catch(a){c(a),f(a)}},function(a){c(a),f(a)}),e},$.failureSummary=function(a){\"use strict\";var b={};return b.none=a.none.concat(a.all),b.any=a.any,Object.keys(b).map(function(a){if(b[a].length){var c=axe._audit.data.failureSummaries[a];return c&&\"function\"==typeof c.failureMessage?c.failureMessage(b[a].map(function(a){return a.message||\"\"})):void 0}}).filter(function(a){return void 0!==a}).join(\"\\n\\n\")};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},ca=axe.constants.resultGroups;$.processAggregate=function(a,b){var c=axe.utils.aggregateResult(a);return c.timestamp=(new Date).toISOString(),c.url=window.location.href,ca.forEach(function(a){c[a]=(c[a]||[]).map(function(a){return a=Object.assign({},a),Array.isArray(a.nodes)&&a.nodes.length>0&&(a.nodes=a.nodes.map(function(a){return\"object\"===Z(a.node)&&(a.html=a.node.source,b.elementRef&&!a.node.fromFrame&&(a.element=a.node.element),(!1!==b.selectors||a.node.fromFrame)&&(a.target=a.node.selector),b.xpath&&(a.xpath=a.node.xpath)),delete a.result,delete a.node,D(a,b),a})),ca.forEach(function(b){return delete a[b]}),delete a.pageLevel,delete a.result,a})}),c},axe.addReporter(\"na\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=$.processAggregate(a,b);c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"no-passes\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=$.processAggregate(a,b);c({violations:d.violations,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"raw\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={}),c(a)}),axe.addReporter(\"v1\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=$.processAggregate(a,b);d.violations.forEach(function(a){return a.nodes.forEach(function(a){a.failureSummary=$.failureSummary(a)})}),c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"v2\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=$.processAggregate(a,b);c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})},!0),axe.utils.aggregate=function(a,b,c){b=b.slice(),c&&b.push(c);var d=b.map(function(b){return a.indexOf(b)}).sort();return a[d.pop()]};var da=[];da[axe.constants.PASS_PRIO]=!0,da[axe.constants.CANTTELL_PRIO]=null,da[axe.constants.FAIL_PRIO]=!1;var ea=[\"any\",\"all\",\"none\"];axe.utils.aggregateChecks=function(a){var b=Object.assign({},a);E(b,function(a,b){var c=da.indexOf(a.result);a.priority=-1!==c?c:axe.constants.CANTTELL_PRIO,\"none\"===b&&(a.priority=4-a.priority)});var c=E(b,function(a){return a.priority});b.priority=Math.max(c.all.reduce(function(a,b){return Math.max(a,b)},0),c.none.reduce(function(a,b){return Math.max(a,b)},0),c.any.reduce(function(a,b){return Math.min(a,b)},4)%4);var d=[];return ea.forEach(function(a){b[a]=b[a].filter(function(a){return a.priority===b.priority}),b[a].forEach(function(a){return d.push(a.impact)})}),b.priority===axe.constants.FAIL_PRIO?b.impact=axe.utils.aggregate(axe.constants.impact,d):b.impact=null,E(b,function(a){delete a.result,delete a.priority}),b.result=axe.constants.results[b.priority],delete b.priority,b},axe.utils.aggregateResult=function(a){var b={};return axe.constants.resultGroups.forEach(function(a){return b[a]=[]}),a.forEach(function(a){a.error?F(b,a,axe.constants.CANTTELL_GROUP):a.result===axe.constants.NA?F(b,a,axe.constants.NA_GROUP):axe.constants.resultGroups.forEach(function(c){Array.isArray(a[c])&&a[c].length>0&&F(b,a,c)})}),b},function(){axe.utils.aggregateRule=function(a){var b={};a=a.map(function(a){if(a.any&&a.all&&a.none)return axe.utils.aggregateChecks(a);if(Array.isArray(a.node))return axe.utils.finalizeRuleResult(a);throw new TypeError(\"Invalid Result type\")});var c=a.map(function(a){return a.result});b.result=axe.utils.aggregate(axe.constants.results,c,b.result),axe.constants.resultGroups.forEach(function(a){return b[a]=[]}),a.forEach(function(a){var c=axe.constants.resultGroupMap[a.result];b[c].push(a)});var d=axe.constants.FAIL_GROUP;if(b[d].length>0){var e=b[d].map(function(a){return a.impact});b.impact=axe.utils.aggregate(axe.constants.impact,e)||null}else b.impact=null;return b}}(),axe.utils.areStylesSet=G,axe.utils.checkHelper=function(a,b,c){\"use strict\";return{isAsync:!1,async:function(){return this.isAsync=!0,function(d){d instanceof Error==!1?(a.value=d,b(a)):c(d)}},data:function(b){a.data=b},relatedNodes:function(b){b=b instanceof Node?[b]:axe.utils.toArray(b),a.relatedNodes=b.map(function(a){return new axe.utils.DqElement(a)})}}};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.clone=function(a){\"use strict\";var b,c,d=a;if(null!==a&&\"object\"===(void 0===a?\"undefined\":Z(a)))if(Array.isArray(a))for(d=[],b=0,c=a.length;b<c;b++)d[b]=axe.utils.clone(a[b]);else{d={};for(b in a)d[b]=axe.utils.clone(a[b])}return d},axe.utils.sendCommandToFrame=function(a,b,c,d){\"use strict\";var e=a.contentWindow;if(!e)return axe.log(\"Frame does not have a content window\",a),void c(null);var f=setTimeout(function(){f=setTimeout(function(){var e=H(\"No response from frame\",a);b.debug?d(e):(axe.log(e),c(null))},0)},500);axe.utils.respondable(e,\"axe.ping\",null,void 0,function(){clearTimeout(f),f=setTimeout(function(){d(H(\"Axe in frame timed out\",a))},3e4),axe.utils.respondable(e,\"axe.start\",b,void 0,function(a){clearTimeout(f),a instanceof Error==!1?c(a):d(a)})})},axe.utils.collectResultsFromFrames=I,axe.utils.contains=function(a,b){\"use strict\";return\"function\"==typeof a.contains?a.contains(b):!!(16&a.compareDocumentPosition(b))},L.prototype={get selector(){return this.spec.selector||[axe.utils.getSelector(this.element)]},get xpath(){return this.spec.xpath||[axe.utils.getXpath(this.element)]},get element(){return this._element},get fromFrame(){return this._fromFrame},toJSON:function(){\"use strict\";return{selector:this.selector,source:this.source,xpath:this.xpath}}},L.fromFrame=function(a,b){return a.selector.unshift(b.selector),a.xpath.unshift(b.xpath),new axe.utils.DqElement(b.element,a)},axe.utils.DqElement=L,axe.utils.matchesSelector=function(){\"use strict\";function a(a){var b,c,d=a.Element.prototype,e=[\"matches\",\"matchesSelector\",\"mozMatchesSelector\",\"webkitMatchesSelector\",\"msMatchesSelector\"],f=e.length;for(b=0;b<f;b++)if(c=e[b],d[c])return c}var b;return function(c,d){return b&&c[b]||(b=a(c.ownerDocument.defaultView)),c[b](d)}}(),axe.utils.escapeSelector=function(a){\"use strict\";for(var b,c=String(a),d=c.length,e=-1,f=\"\",g=c.charCodeAt(0);++e<d;){if(0==(b=c.charCodeAt(e)))throw new Error(\"INVALID_CHARACTER_ERR\");b>=1&&b<=31||b>=127&&b<=159||0==e&&b>=48&&b<=57||1==e&&b>=48&&b<=57&&45==g?f+=\"\\\\\"+b.toString(16)+\" \":f+=(1!=e||45!=b||45!=g)&&(b>=128||45==b||95==b||b>=48&&b<=57||b>=65&&b<=90||b>=97&&b<=122)?c.charAt(e):\"\\\\\"+c.charAt(e)}return f},axe.utils.extendMetaData=function(a,b){Object.assign(a,b),Object.keys(b).filter(function(a){return\"function\"==typeof b[a]}).forEach(function(c){a[c]=null;try{a[c]=b[c](a)}catch(a){}})},axe.utils.finalizeRuleResult=function(a){return Object.assign(a,axe.utils.aggregateRule(a.nodes)),delete a.nodes,a};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.findBy=function(a,b,c){if(Array.isArray(a))return a.find(function(a){return\"object\"===(void 0===a?\"undefined\":Z(a))&&a[b]===c})},axe.utils.getAllChecks=function(a){\"use strict\";return[].concat(a.any||[]).concat(a.all||[]).concat(a.none||[])},axe.utils.getCheckOption=function(a,b,c){\"use strict\";var d=((c.rules&&c.rules[b]||{}).checks||{})[a.id],e=(c.checks||{})[a.id],f=a.enabled,g=a.options;return e&&(e.hasOwnProperty(\"enabled\")&&(f=e.enabled),\ne.hasOwnProperty(\"options\")&&(g=e.options)),d&&(d.hasOwnProperty(\"enabled\")&&(f=d.enabled),d.hasOwnProperty(\"options\")&&(g=d.options)),{enabled:f,options:g}},axe.utils.getSelector=function(a){\"use strict\";function b(a){return axe.utils.escapeSelector(a)}for(var c,d=[];a.parentNode;){if(c=\"\",a.id&&1===document.querySelectorAll(\"#\"+axe.utils.escapeSelector(a.id)).length){d.unshift(\"#\"+axe.utils.escapeSelector(a.id));break}if(a.className&&\"string\"==typeof a.className&&(\".\"===(c=\".\"+a.className.trim().split(/\\s+/).map(b).join(\".\"))||N(a,c))&&(c=\"\"),!c){if(\"html\"===(c=axe.utils.escapeSelector(a.nodeName).toLowerCase())||\"body\"===c){d.unshift(c);break}N(a,c)&&(c+=\":nth-of-type(\"+M(a)+\")\")}d.unshift(c),a=a.parentNode}return d.join(\" > \")},axe.utils.getXpath=function(a){return P(O(a))};var fa;axe.utils.injectStyle=Q,axe.utils.isHidden=function(a,b){\"use strict\";if(9===a.nodeType)return!1;var c=window.getComputedStyle(a,null);return!c||!a.parentNode||\"none\"===c.getPropertyValue(\"display\")||!b&&\"hidden\"===c.getPropertyValue(\"visibility\")||\"true\"===a.getAttribute(\"aria-hidden\")||axe.utils.isHidden(a.parentNode,!0)},axe.utils.mergeResults=function(a){\"use strict\";var b=[];return a.forEach(function(a){var c=T(a);c&&c.length&&c.forEach(function(c){c.nodes&&a.frame&&R(c.nodes,a.frameElement,a.frame);var d=axe.utils.findBy(b,\"id\",c.id);d?c.nodes.length&&S(d.nodes,c.nodes):b.push(c)})}),b},axe.utils.nodeSorter=function(a,b){\"use strict\";return a===b?0:4&a.compareDocumentPosition(b)?-1:1},utils.performanceTimer=function(){\"use strict\";function a(){if(window.performance&&window.performance)return window.performance.now()}var b=null,c=a();return{start:function(){this.mark(\"mark_axe_start\")},end:function(){this.mark(\"mark_axe_end\"),this.measure(\"axe\",\"mark_axe_start\",\"mark_axe_end\"),this.logMeasures(\"axe\")},auditStart:function(){this.mark(\"mark_audit_start\")},auditEnd:function(){this.mark(\"mark_audit_end\"),this.measure(\"audit_start_to_end\",\"mark_audit_start\",\"mark_audit_end\"),this.logMeasures()},mark:function(a){window.performance&&void 0!==window.performance.mark&&window.performance.mark(a)},measure:function(a,b,c){window.performance&&void 0!==window.performance.measure&&window.performance.measure(a,b,c)},logMeasures:function(a){function b(a){axe.log(\"Measure \"+a.name+\" took \"+a.duration+\"ms\")}if(window.performance&&void 0!==window.performance.getEntriesByType)for(var c=window.performance.getEntriesByType(\"measure\"),d=0;d<c.length;++d){var e=c[d];if(e.name===a)return void b(e);b(e)}},timeElapsed:function(){return a()-c},reset:function(){b||(b=a()),c=a()}}}(),\"function\"!=typeof Object.assign&&function(){Object.assign=function(a){\"use strict\";if(void 0===a||null===a)throw new TypeError(\"Cannot convert undefined or null to object\");for(var b=Object(a),c=1;c<arguments.length;c++){var d=arguments[c];if(void 0!==d&&null!==d)for(var e in d)d.hasOwnProperty(e)&&(b[e]=d[e])}return b}}(),Array.prototype.find||(Array.prototype.find=function(a){if(null===this)throw new TypeError(\"Array.prototype.find called on null or undefined\");if(\"function\"!=typeof a)throw new TypeError(\"predicate must be a function\");for(var b,c=Object(this),d=c.length>>>0,e=arguments[1],f=0;f<d;f++)if(b=c[f],a.call(e,b,f,c))return b}),axe.utils.pollyfillElementsFromPoint=function(){if(document.elementsFromPoint)return document.elementsFromPoint;if(document.msElementsFromPoint)return document.msElementsFromPoint;var a=function(){var a=document.createElement(\"x\");return a.style.cssText=\"pointer-events:auto\",\"auto\"===a.style.pointerEvents}(),b=a?\"pointer-events\":\"visibility\",c=a?\"none\":\"hidden\",d=document.createElement(\"style\");return d.innerHTML=a?\"* { pointer-events: all }\":\"* { visibility: visible }\",function(a,e){var f,g,h,i=[],j=[];for(document.head.appendChild(d);(f=document.elementFromPoint(a,e))&&-1===i.indexOf(f);)i.push(f),j.push({value:f.style.getPropertyValue(b),priority:f.style.getPropertyPriority(b)}),f.style.setProperty(b,c,\"important\");for(g=j.length;h=j[--g];)i[g].style.setProperty(b,h.value?h.value:\"\",h.priority);return document.head.removeChild(d),i}},\"function\"==typeof window.addEventListener&&(document.elementsFromPoint=axe.utils.pollyfillElementsFromPoint()),Array.prototype.includes||(Array.prototype.includes=function(a){\"use strict\";var b=Object(this),c=parseInt(b.length,10)||0;if(0===c)return!1;var d,e=parseInt(arguments[1],10)||0;e>=0?d=e:(d=c+e)<0&&(d=0);for(var f;d<c;){if(f=b[d],a===f||a!==a&&f!==f)return!0;d++}return!1}),Array.prototype.some||(Array.prototype.some=function(a){\"use strict\";if(null==this)throw new TypeError(\"Array.prototype.some called on null or undefined\");if(\"function\"!=typeof a)throw new TypeError;for(var b=Object(this),c=b.length>>>0,d=arguments.length>=2?arguments[1]:void 0,e=0;e<c;e++)if(e in b&&a.call(d,b[e],e,b))return!0;return!1}),Array.from||(Array.from=function(){var a=Object.prototype.toString,b=function(b){return\"function\"==typeof b||\"[object Function]\"===a.call(b)},c=function(a){var b=Number(a);return isNaN(b)?0:0!==b&&isFinite(b)?(b>0?1:-1)*Math.floor(Math.abs(b)):b},d=Math.pow(2,53)-1,e=function(a){var b=c(a);return Math.min(Math.max(b,0),d)};return function(a){var c=this,d=Object(a);if(null==a)throw new TypeError(\"Array.from requires an array-like object - not null or undefined\");var f,g=arguments.length>1?arguments[1]:void 0;if(void 0!==g){if(!b(g))throw new TypeError(\"Array.from: when provided, the second argument must be a function\");arguments.length>2&&(f=arguments[2])}for(var h,i=e(d.length),j=b(c)?Object(new c(i)):new Array(i),k=0;k<i;)h=d[k],j[k]=g?void 0===f?g(h,k):g.call(f,h,k):h,k+=1;return j.length=i,j}}());var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.publishMetaData=function(a){\"use strict\";var b=axe._audit.data.checks||{},c=axe._audit.data.rules||{},d=axe.utils.findBy(axe._audit.rules,\"id\",a.id)||{};a.tags=axe.utils.clone(d.tags||[]);var e=U(b,!0),f=U(b,!1);a.nodes.forEach(function(a){a.any.forEach(e),a.all.forEach(e),a.none.forEach(f)}),axe.utils.extendMetaData(a,axe.utils.clone(c[a.id]||{}))};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};!function(){\"use strict\";function a(){}function b(a){if(\"function\"!=typeof a)throw new TypeError(\"Queue methods require functions as arguments\")}function c(){function c(b){return function(c){g[b]=c,(i-=1)||j===a||(k=!0,j(g))}}function d(b){return j=a,m(b),g}function e(){for(var a=g.length;h<a;h++){var b=g[h];try{b.call(null,c(h),d)}catch(a){d(a)}}}var f,g=[],h=0,i=0,j=a,k=!1,l=function(a){f=a,setTimeout(function(){void 0!==f&&null!==f&&axe.log(\"Uncaught error (of queue)\",f)},1)},m=l,n={defer:function(a){if(\"object\"===(void 0===a?\"undefined\":Z(a))&&a.then&&a.catch){var c=a;a=function(a,b){c.then(a).catch(b)}}if(b(a),void 0===f){if(k)throw new Error(\"Queue already completed\");return g.push(a),++i,e(),n}},then:function(c){if(b(c),j!==a)throw new Error(\"queue `then` already set\");return f||(j=c,i||(k=!0,j(g))),n},catch:function(a){if(b(a),m!==l)throw new Error(\"queue `catch` already set\");return f?(a(f),f=null):m=a,n},abort:d};return n}axe.utils.queue=c}();var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};!function(a){\"use strict\";function b(){var a=\"axe\",b=\"\";return void 0!==axe&&axe._audit&&!axe._audit.application&&(a=axe._audit.application),void 0!==axe&&(b=axe.version),a+\".\"+b}function c(a){if(\"object\"===(void 0===a?\"undefined\":Z(a))&&\"string\"==typeof a.uuid&&!0===a._respondable){var c=b();return a._source===c||\"axe.x.y.z\"===a._source||\"axe.x.y.z\"===c}return!1}function d(a,c,d,e,f,g){var h;d instanceof Error&&(h={name:d.name,message:d.message,stack:d.stack},d=void 0);var i={uuid:e,topic:c,message:d,error:h,_respondable:!0,_source:b(),_keepalive:f};\"function\"==typeof g&&(j[e]=g),a.postMessage(JSON.stringify(i),\"*\")}function e(a,b,c,e,f){d(a,b,c,ga.v1(),e,f)}function f(a,b,c){return function(e,f,g){d(a,b,e,c,f,g)}}function g(a,b,c){var d=b.topic,e=k[d];if(e){var g=f(a,null,b.uuid);e(b.message,c,g)}}function h(a){var b=a.message||\"Unknown error occurred\",c=window[a.name]||Error;return a.stack&&(b+=\"\\n\"+a.stack.replace(a.message,\"\")),new c(b)}function i(a){var b;if(\"string\"==typeof a){try{b=JSON.parse(a)}catch(a){}if(c(b))return\"object\"===Z(b.error)?b.error=h(b.error):b.error=void 0,b}}var j={},k={};e.subscribe=function(a,b){k[a]=b},e.isInFrame=function(a){return a=a||window,!!a.frameElement},\"function\"==typeof window.addEventListener&&window.addEventListener(\"message\",function(a){var b=i(a.data);if(b){var c=b.uuid,e=b._keepalive,h=j[c];if(h){h(b.error||b.message,e,f(a.source,b.topic,c)),e||delete j[c]}if(!b.error)try{g(a.source,b,e)}catch(e){d(a.source,b.topic,e,c,!1)}}},!1),a.respondable=e}(utils),axe.utils.ruleShouldRun=function(a,b,c){\"use strict\";var d=c.runOnly||{},e=(c.rules||{})[a.id];return!(a.pageLevel&&!b.page)&&(\"rule\"===d.type?-1!==d.values.indexOf(a.id):e&&\"boolean\"==typeof e.enabled?e.enabled:\"tag\"===d.type&&d.values?V(a,d.values):V(a,[]))},axe.utils.select=function(a,b){\"use strict\";for(var c,d=[],e=0,f=b.include.length;e<f;e++)c=b.include[e],c.nodeType===c.ELEMENT_NODE&&axe.utils.matchesSelector(c,a)&&Y(d,[c],b),Y(d,c.querySelectorAll(a),b);return d.sort(axe.utils.nodeSorter)},axe.utils.toArray=function(a){\"use strict\";return Array.prototype.slice.call(a)};var ga;!function(a){function b(a,b,c){var d=b&&c||0,e=0;for(b=b||[],a.toLowerCase().replace(/[0-9a-f]{2}/g,function(a){e<16&&(b[d+e++]=l[a])});e<16;)b[d+e++]=0;return b}function c(a,b){var c=b||0,d=k;return d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]}function d(a,b,d){var e=b&&d||0,f=b||[];a=a||{};var g=null!=a.clockseq?a.clockseq:p,h=null!=a.msecs?a.msecs:(new Date).getTime(),i=null!=a.nsecs?a.nsecs:r+1,j=h-q+(i-r)/1e4;if(j<0&&null==a.clockseq&&(g=g+1&16383),(j<0||h>q)&&null==a.nsecs&&(i=0),i>=1e4)throw new Error(\"uuid.v1(): Can't create more than 10M uuids/sec\");q=h,r=i,p=g,h+=122192928e5;var k=(1e4*(268435455&h)+i)%4294967296;f[e++]=k>>>24&255,f[e++]=k>>>16&255,f[e++]=k>>>8&255,f[e++]=255&k;var l=h/4294967296*1e4&268435455;f[e++]=l>>>8&255,f[e++]=255&l,f[e++]=l>>>24&15|16,f[e++]=l>>>16&255,f[e++]=g>>>8|128,f[e++]=255&g;for(var m=a.node||o,n=0;n<6;n++)f[e+n]=m[n];return b||c(f)}function e(a,b,d){var e=b&&d||0;\"string\"==typeof a&&(b=\"binary\"==a?new j(16):null,a=null),a=a||{};var g=a.random||(a.rng||f)();if(g[6]=15&g[6]|64,g[8]=63&g[8]|128,b)for(var h=0;h<16;h++)b[e+h]=g[h];return b||c(g)}var f,g=a.crypto||a.msCrypto;if(!f&&g&&g.getRandomValues){var h=new Uint8Array(16);f=function(){return g.getRandomValues(h),h}}if(!f){var i=new Array(16);f=function(){for(var a,b=0;b<16;b++)0==(3&b)&&(a=4294967296*Math.random()),i[b]=a>>>((3&b)<<3)&255;return i}}for(var j=\"function\"==typeof a.Buffer?a.Buffer:Array,k=[],l={},m=0;m<256;m++)k[m]=(m+256).toString(16).substr(1),l[k[m]]=m;var n=f(),o=[1|n[0],n[1],n[2],n[3],n[4],n[5]],p=16383&(n[6]<<8|n[7]),q=0,r=0;ga=e,ga.v1=d,ga.v4=e,ga.parse=b,ga.unparse=c,ga.BufferClass=j}(window),axe._load({data:{rules:{accesskeys:{description:\"Ensures every accesskey attribute value is unique\",help:\"accesskey attribute value must be unique\"},\"area-alt\":{description:\"Ensures <area> elements of image maps have alternate text\",help:\"Active <area> elements must have alternate text\"},\"aria-allowed-attr\":{description:\"Ensures ARIA attributes are allowed for an element's role\",help:\"Elements must only use allowed ARIA attributes\"},\"aria-required-attr\":{description:\"Ensures elements with ARIA roles have all required ARIA attributes\",help:\"Required ARIA attributes must be provided\"},\"aria-required-children\":{description:\"Ensures elements with an ARIA role that require child roles contain them\",help:\"Certain ARIA roles must contain particular children\"},\"aria-required-parent\":{description:\"Ensures elements with an ARIA role that require parent roles are contained by them\",help:\"Certain ARIA roles must be contained by particular parents\"},\"aria-roles\":{description:\"Ensures all elements with a role attribute use a valid value\",help:\"ARIA roles used must conform to valid values\"},\"aria-valid-attr-value\":{description:\"Ensures all ARIA attributes have valid values\",help:\"ARIA attributes must conform to valid values\"},\"aria-valid-attr\":{description:\"Ensures attributes that begin with aria- are valid ARIA attributes\",help:\"ARIA attributes must conform to valid names\"},\"audio-caption\":{description:\"Ensures <audio> elements have captions\",help:\"<audio> elements must have a captions track\"},blink:{description:\"Ensures <blink> elements are not used\",help:\"<blink> elements are deprecated and must not be used\"},\"button-name\":{description:\"Ensures buttons have discernible text\",help:\"Buttons must have discernible text\"},bypass:{description:\"Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content\",help:\"Page must have means to bypass repeated blocks\"},checkboxgroup:{description:'Ensures related <input type=\"checkbox\"> elements have a group and that that group designation is consistent',help:\"Checkbox inputs with the same name attribute value must be part of a group\"},\"color-contrast\":{description:\"Ensures the contrast between foreground and background colors meets WCAG 2 AA contrast ratio thresholds\",help:\"Elements must have sufficient color contrast\"},\"definition-list\":{description:\"Ensures <dl> elements are structured correctly\",help:\"<dl> elements must only directly contain properly-ordered <dt> and <dd> groups, <script> or <template> elements\"},dlitem:{description:\"Ensures <dt> and <dd> elements are contained by a <dl>\",help:\"<dt> and <dd> elements must be contained by a <dl>\"},\"document-title\":{description:\"Ensures each HTML document contains a non-empty <title> element\",help:\"Documents must have <title> element to aid in navigation\"},\"duplicate-id\":{description:\"Ensures every id attribute value is unique\",help:\"id attribute value must be unique\"},\"empty-heading\":{description:\"Ensures headings have discernible text\",help:\"Headings must not be empty\"},\"frame-title-unique\":{description:\"Ensures <iframe> and <frame> elements contain a unique title attribute\",help:\"Frames must have a unique title attribute\"},\"frame-title\":{description:\"Ensures <iframe> and <frame> elements contain a non-empty title attribute\",help:\"Frames must have title attribute\"},\"heading-order\":{description:\"Ensures the order of headings is semantically correct\",help:\"Heading levels should only increase by one\"},\"href-no-hash\":{description:\"Ensures that href values are valid link references to promote only using anchors as links\",help:\"Anchors must only be used as links and must therefore have an href value that is a valid reference. Otherwise you should probably usa a button\"},\"html-has-lang\":{description:\"Ensures every HTML document has a lang attribute\",help:\"<html> element must have a lang attribute\"},\"html-lang-valid\":{description:\"Ensures the lang attribute of the <html> element has a valid value\",help:\"<html> element must have a valid value for the lang attribute\"},\"image-alt\":{description:\"Ensures <img> elements have alternate text or a role of none or presentation\",help:\"Images must have alternate text\"},\"image-redundant-alt\":{description:\"Ensure button and link text is not repeated as image alternative\",help:\"Text of buttons and links should not be repeated in the image alternative\"},\"input-image-alt\":{description:'Ensures <input type=\"image\"> elements have alternate text',help:\"Image buttons must have alternate text\"},\"label-title-only\":{description:\"Ensures that every form element is not solely labeled using the title or aria-describedby attributes\",help:\"Form elements should have a visible label\"},label:{description:\"Ensures every form element has a label\",help:\"Form elements must have labels\"},\"layout-table\":{description:\"Ensures presentational <table> elements do not use <th>, <caption> elements or the summary attribute\",help:\"Layout tables must not use data table elements\"},\"link-in-text-block\":{description:\"Links can be distinguished without relying on color\",help:\"Links must be distinguished from surrounding text in a way that does not rely on color\"},\"link-name\":{description:\"Ensures links have discernible text\",help:\"Links must have discernible text\"},list:{description:\"Ensures that lists are structured correctly\",help:\"<ul> and <ol> must only directly contain <li>, <script> or <template> elements\"},listitem:{description:\"Ensures <li> elements are used semantically\",help:\"<li> elements must be contained in a <ul> or <ol>\"},marquee:{description:\"Ensures <marquee> elements are not used\",help:\"<marquee> elements are deprecated and must not be used\"},\"meta-refresh\":{description:'Ensures <meta http-equiv=\"refresh\"> is not used',help:\"Timed refresh must not exist\"},\"meta-viewport-large\":{description:'Ensures <meta name=\"viewport\"> can scale a significant amount',help:\"Users should be able to zoom and scale the text up to 500%\"},\"meta-viewport\":{description:'Ensures <meta name=\"viewport\"> does not disable text scaling and zooming',help:\"Zooming and scaling must not be disabled\"},\"object-alt\":{description:\"Ensures <object> elements have alternate text\",help:\"<object> elements must have alternate text\"},\"p-as-heading\":{description:\"Ensure p elements are not used to style headings\",help:\"Bold, italic text and font-size are not used to style p elements as a heading\"},radiogroup:{description:'Ensures related <input type=\"radio\"> elements have a group and that the group designation is consistent',help:\"Radio inputs with the same name attribute value must be part of a group\"},region:{description:\"Ensures all content is contained within a landmark region\",help:\"Content should be contained in a landmark region\"},\"scope-attr-valid\":{description:\"Ensures the scope attribute is used correctly on tables\",help:\"scope attribute should be used correctly\"},\"server-side-image-map\":{description:\"Ensures that server-side image maps are not used\",help:\"Server-side image maps must not be used\"},\"skip-link\":{description:\"Ensures the first link on the page is a skip link\",help:\"The page should have a skip link as its first link\"},tabindex:{description:\"Ensures tabindex attribute values are not greater than 0\",help:\"Elements should not have tabindex greater than zero\"},\"table-duplicate-name\":{description:\"Ensure that tables do not have the same summary and caption\",help:\"The <caption> element should not contain the same text as the summary attribute\"},\"table-fake-caption\":{description:\"Ensure that tables with a caption use the <caption> element.\",help:\"Data or header cells should not be used to give caption to a data table.\"},\"td-has-header\":{description:\"Ensure that each non-empty data cell in a large table has one or more table headers\",help:\"All non-empty td element in table larger than 3 by 3 must have an associated table header\"},\"td-headers-attr\":{description:\"Ensure that each cell in a table using the headers refers to another cell in that table\",help:\"All cells in a table element that use the headers attribute must only refer to other cells of that same table\"},\"th-has-data-cells\":{description:\"Ensure that each table header in a data table refers to data cells\",help:\"All th element and elements with role=columnheader/rowheader must data cells which it describes\"},\"valid-lang\":{description:\"Ensures lang attributes have valid values\",help:\"lang attribute must have a valid value\"},\"video-caption\":{description:\"Ensures <video> elements have captions\",help:\"<video> elements must have captions\"},\"video-description\":{description:\"Ensures <video> elements have audio descriptions\",help:\"<video> elements must have an audio description track\"}},checks:{accesskeys:{impact:\"critical\",messages:{pass:function(a){return\"Accesskey attribute value is unique\"},fail:function(a){return\"Document has multiple elements with the same accesskey\"}}},\"non-empty-alt\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a non-empty alt attribute\"},fail:function(a){return\"Element has no alt attribute or the alt attribute is empty\"}}},\"non-empty-title\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a title attribute\"},fail:function(a){return\"Element has no title attribute or the title attribute is empty\"}}},\"aria-label\":{impact:\"critical\",messages:{pass:function(a){return\"aria-label attribute exists and is not empty\"},fail:function(a){return\"aria-label attribute does not exist or is empty\"}}},\"aria-labelledby\":{impact:\"critical\",messages:{pass:function(a){return\"aria-labelledby attribute exists and references elements that are visible to screen readers\"},fail:function(a){return\"aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty or not visible\"}}},\"aria-allowed-attr\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attributes are used correctly for the defined role\"},fail:function(a){var b=\"ARIA attribute\"+(a.data&&a.data.length>1?\"s are\":\" is\")+\" not allowed:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-attr\":{impact:\"critical\",messages:{pass:function(a){return\"All required ARIA attributes are present\"},fail:function(a){var b=\"Required ARIA attribute\"+(a.data&&a.data.length>1?\"s\":\"\")+\" not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-children\":{impact:\"critical\",messages:{pass:function(a){return\"Required ARIA children are present\"},fail:function(a){var b=\"Required ARIA \"+(a.data&&a.data.length>1?\"children\":\"child\")+\" role not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-parent\":{impact:\"critical\",messages:{pass:function(a){return\"Required ARIA parent role present\"},fail:function(a){var b=\"Required ARIA parent\"+(a.data&&a.data.length>1?\"s\":\"\")+\" role not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},invalidrole:{impact:\"critical\",messages:{pass:function(a){return\"ARIA role is valid\"},fail:function(a){return\"Role must be one of the valid ARIA roles\"}}},abstractrole:{impact:\"serious\",messages:{pass:function(a){return\"Abstract roles are not used\"},fail:function(a){return\"Abstract roles cannot be directly used\"}}},\"aria-valid-attr-value\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attribute values are valid\"},fail:function(a){var b=\"Invalid ARIA attribute value\"+(a.data&&a.data.length>1?\"s\":\"\")+\":\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-valid-attr\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attribute name\"+(a.data&&a.data.length>1?\"s\":\"\")+\" are valid\"},fail:function(a){var b=\"Invalid ARIA attribute name\"+(a.data&&a.data.length>1?\"s\":\"\")+\":\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},caption:{impact:\"critical\",messages:{pass:function(a){return\"The multimedia element has a captions track\"},fail:function(a){return\"The multimedia element does not have a captions track\"},incomplete:function(a){return\"A captions track for this element could not be found\"}}},\"is-on-screen\":{impact:\"minor\",messages:{pass:function(a){return\"Element is not visible\"},fail:function(a){return\"Element is visible\"}}},\"non-empty-if-present\":{impact:\"critical\",messages:{pass:function(a){var b=\"Element \";return a.data?b+=\"has a non-empty value attribute\":b+=\"does not have a value attribute\",b},fail:function(a){return\"Element has a value attribute and the value attribute is empty\"}}},\"non-empty-value\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a non-empty value attribute\"},fail:function(a){return\"Element has no value attribute or the value attribute is empty\"}}},\"button-has-visible-text\":{impact:\"critical\",messages:{pass:function(a){return\"Element has inner text that is visible to screen readers\"},fail:function(a){return\"Element does not have inner text that is visible to screen readers\"}}},\"role-presentation\":{impact:\"moderate\",messages:{pass:function(a){return'Element\\'s default semantics were overriden with role=\"presentation\"'},fail:function(a){return'Element\\'s default semantics were not overridden with role=\"presentation\"'}}},\"role-none\":{impact:\"moderate\",messages:{pass:function(a){return'Element\\'s default semantics were overriden with role=\"none\"'},fail:function(a){return'Element\\'s default semantics were not overridden with role=\"none\"'}}},\"focusable-no-name\":{impact:\"serious\",messages:{pass:function(a){return\"Element is not in tab order or has accessible text\"},fail:function(a){return\"Element is in tab order and does not have accessible text\"}}},\"internal-link-present\":{impact:\"critical\",messages:{pass:function(a){return\"Valid skip link found\"},fail:function(a){return\"No valid skip link found\"}}},\"header-present\":{impact:\"moderate\",messages:{pass:function(a){return\"Page has a header\"},fail:function(a){return\"Page does not have a header\"}}},landmark:{impact:\"serious\",messages:{pass:function(a){return\"Page has a landmark region\"},fail:function(a){return\"Page does not have a landmark region\"}}},\"group-labelledby\":{impact:\"critical\",messages:{pass:function(a){return'All elements with the name \"'+a.data.name+'\" reference the same element with aria-labelledby'},fail:function(a){return'All elements with the name \"'+a.data.name+'\" do not reference the same element with aria-labelledby'}}},fieldset:{impact:\"critical\",messages:{pass:function(a){return\"Element is contained in a fieldset\"},fail:function(a){var b=\"\",c=a.data&&a.data.failureCode;return b+=\"no-legend\"===c?\"Fieldset does not have a legend as its first child\":\"empty-legend\"===c?\"Legend does not have text that is visible to screen readers\":\"mixed-inputs\"===c?\"Fieldset contains unrelated inputs\":\"no-group-label\"===c?\"ARIA group does not have aria-label or aria-labelledby\":\"group-mixed-inputs\"===c?\"ARIA group contains unrelated inputs\":\"Element does not have a containing fieldset or ARIA group\"}}},\"color-contrast\":{impact:\"critical\",messages:{pass:function(a){return\"Element has sufficient color contrast of \"+a.data.contrastRatio},fail:function(a){return\"Element has insufficient color contrast of \"+a.data.contrastRatio+\" (foreground color: \"+a.data.fgColor+\", background color: \"+a.data.bgColor+\", font size: \"+a.data.fontSize+\", font weight: \"+a.data.fontWeight+\")\"},incomplete:{bgImage:\"Element's background color could not be determined due to a background image\",bgGradient:\"Element's background color could not be determined due to a background gradient\",imgNode:\"Element's background color could not be determined because element contains an image node\",bgOverlap:\"Element's background color could not be determined because it is overlapped by another element\",fgAlpha:\"Element's foreground color could not be determined because of alpha transparency\",default:\"Unable to determine contrast ratio\"}}},\"structured-dlitems\":{impact:\"serious\",messages:{pass:function(a){return\"When not empty, element has both <dt> and <dd> elements\"},fail:function(a){return\"When not empty, element does not have at least one <dt> element followed by at least one <dd> element\"}}},\"only-dlitems\":{impact:\"serious\",messages:{pass:function(a){return\"List element only has direct children that are allowed inside <dt> or <dd> elements\"},fail:function(a){return\"List element has direct children that are not allowed inside <dt> or <dd> elements\"}}},dlitem:{impact:\"serious\",messages:{pass:function(a){return\"Description list item has a <dl> parent element\"},fail:function(a){return\"Description list item does not have a <dl> parent element\"}}},\"doc-has-title\":{impact:\"moderate\",messages:{pass:function(a){return\"Document has a non-empty <title> element\"},fail:function(a){return\"Document does not have a non-empty <title> element\"}}},\"duplicate-id\":{impact:\"critical\",messages:{pass:function(a){return\"Document has no elements that share the same id attribute\"},fail:function(a){return\"Document has multiple elements with the same id attribute: \"+a.data}}},\"has-visible-text\":{impact:\"moderate\",messages:{pass:function(a){return\"Element has text that is visible to screen readers\"},fail:function(a){return\"Element does not have text that is visible to screen readers\"}}},\"unique-frame-title\":{impact:\"serious\",messages:{pass:function(a){return\"Element's title attribute is unique\"},fail:function(a){return\"Element's title attribute is not unique\"}}},\"heading-order\":{impact:\"minor\",messages:{pass:function(a){return\"Heading order valid\"},fail:function(a){return\"Heading order invalid\"}}},\"href-no-hash\":{impact:\"moderate\",messages:{pass:function(a){return\"Anchor does not have a href quals #\"},fail:function(a){return\"Anchor has a href quals #\"}}},\"has-lang\":{impact:\"serious\",messages:{pass:function(a){return\"The <html> element has a lang attribute\"},fail:function(a){return\"The <html> element does not have a lang attribute\"}}},\"valid-lang\":{impact:\"serious\",messages:{pass:function(a){return\"Value of lang attribute is included in the list of valid languages\"},fail:function(a){return\"Value of lang attribute not included in the list of valid languages\"}}},\"has-alt\":{impact:\"critical\",messages:{pass:function(a){return\"Element has an alt attribute\"},fail:function(a){return\"Element does not have an alt attribute\"}}},\"duplicate-img-label\":{impact:\"minor\",messages:{pass:function(a){return\"Element does not duplicate existing text in <img> alt text\"},fail:function(a){return\"Element contains <img> element with alt text that duplicates existing text\"}}},\"title-only\":{impact:\"serious\",messages:{pass:function(a){return\"Form element does not solely use title attribute for its label\"},fail:function(a){return\"Only title used to generate label for form element\"}}},\"implicit-label\":{impact:\"critical\",messages:{pass:function(a){return\"Form element has an implicit (wrapped) <label>\"},fail:function(a){return\"Form element does not have an implicit (wrapped) <label>\"}}},\"explicit-label\":{impact:\"critical\",messages:{pass:function(a){return\"Form element has an explicit <label>\"},fail:function(a){return\"Form element does not have an explicit <label>\"}}},\"help-same-as-label\":{impact:\"minor\",messages:{pass:function(a){return\"Help text (title or aria-describedby) does not duplicate label text\"},fail:function(a){return\"Help text (title or aria-describedby) text is the same as the label text\"}}},\"multiple-label\":{impact:\"serious\",messages:{pass:function(a){return\"Form element does not have multiple <label> elements\"},fail:function(a){return\"Form element has multiple <label> elements\"}}},\"has-th\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use <th> elements\"},fail:function(a){return\"Layout table uses <th> elements\"}}},\"has-caption\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use <caption> element\"},fail:function(a){return\"Layout table uses <caption> element\"}}},\"has-summary\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use summary attribute\"},fail:function(a){return\"Layout table uses summary attribute\"}}},\"link-in-text-block\":{impact:\"critical\",messages:{pass:function(a){return\"Links can be distinguished from surrounding text in a way that does not rely on color\"},fail:function(a){return\"Links can not be distinguished from surrounding text in a way that does not rely on color\"},incomplete:{bgContrast:\"Element's contrast ratio could not be determined. Check for a distinct hover/focus style\",\nbgImage:\"Element's contrast ratio could not be determined due to a background image\",bgGradient:\"Element's contrast ratio could not be determined due to a background gradient\",imgNode:\"Element's contrast ratio could not be determined because element contains an image node\",bgOverlap:\"Element's contrast ratio could not be determined because of element overlap\",default:\"Unable to determine contrast ratio\"}}},\"only-listitems\":{impact:\"serious\",messages:{pass:function(a){return\"List element only has direct children that are allowed inside <li> elements\"},fail:function(a){return\"List element has direct children that are not allowed inside <li> elements\"}}},listitem:{impact:\"critical\",messages:{pass:function(a){return'List item has a <ul>, <ol> or role=\"list\" parent element'},fail:function(a){return'List item does not have a <ul>, <ol> or role=\"list\" parent element'}}},\"meta-refresh\":{impact:\"critical\",messages:{pass:function(a){return\"<meta> tag does not immediately refresh the page\"},fail:function(a){return\"<meta> tag forces timed refresh of page\"}}},\"meta-viewport-large\":{impact:\"minor\",messages:{pass:function(a){return\"<meta> tag does not prevent significant zooming\"},fail:function(a){return\"<meta> tag limits zooming\"}}},\"meta-viewport\":{impact:\"critical\",messages:{pass:function(a){return\"<meta> tag does not disable zooming\"},fail:function(a){return\"<meta> tag disables zooming\"}}},\"p-as-heading\":{impact:\"critical\",messages:{pass:function(a){return\"<p> elements are not styled as headings\"},fail:function(a){return\"Heading elements should be used instead of styled p elements\"}}},region:{impact:\"moderate\",messages:{pass:function(a){return\"Content contained by ARIA landmark\"},fail:function(a){return\"Content not contained by an ARIA landmark\"}}},\"html5-scope\":{impact:\"serious\",messages:{pass:function(a){return\"Scope attribute is only used on table header elements (<th>)\"},fail:function(a){return\"In HTML 5, scope attributes may only be used on table header elements (<th>)\"}}},\"scope-value\":{impact:\"critical\",messages:{pass:function(a){return\"Scope attribute is used correctly\"},fail:function(a){return\"The value of the scope attribute may only be 'row' or 'col'\"}}},exists:{impact:\"minor\",messages:{pass:function(a){return\"Element does not exist\"},fail:function(a){return\"Element exists\"}}},\"skip-link\":{impact:\"critical\",messages:{pass:function(a){return\"Valid skip link found\"},fail:function(a){return\"No valid skip link found\"}}},tabindex:{impact:\"serious\",messages:{pass:function(a){return\"Element does not have a tabindex greater than 0\"},fail:function(a){return\"Element has a tabindex greater than 0\"}}},\"same-caption-summary\":{impact:\"moderate\",messages:{pass:function(a){return\"Content of summary attribute and <caption> are not duplicated\"},fail:function(a){return\"Content of summary attribute and <caption> element are identical\"}}},\"caption-faked\":{impact:\"critical\",messages:{pass:function(a){return\"The first row of a table is not used as a caption\"},fail:function(a){return\"The first row of the table should be a caption instead of a table cell\"}}},\"td-has-header\":{impact:\"critical\",messages:{pass:function(a){return\"All non-empty data cells have table headers\"},fail:function(a){return\"Some non-empty data cells do not have table headers\"}}},\"td-headers-attr\":{impact:\"serious\",messages:{pass:function(a){return\"The headers attribute is exclusively used to refer to other cells in the table\"},fail:function(a){return\"The headers attribute is not exclusively used to refer to other cells in the table\"}}},\"th-has-data-cells\":{impact:\"critical\",messages:{pass:function(a){return\"All table header cells refer to data cells\"},fail:function(a){return\"Not all table header cells refer to data cells\"},incomplete:function(a){return\"Table data cells are missing or empty\"}}},description:{impact:\"serious\",messages:{pass:function(a){return\"The multimedia element has an audio description track\"},fail:function(a){return\"The multimedia element does not have an audio description track\"},incomplete:function(a){return\"An audio description track for this element could not be found\"}}}},failureSummaries:{any:{failureMessage:function(a){var b=\"Fix any of the following:\",c=a;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\"\\n  \"+d.split(\"\\n\").join(\"\\n  \");return b}},none:{failureMessage:function(a){var b=\"Fix all of the following:\",c=a;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\"\\n  \"+d.split(\"\\n\").join(\"\\n  \");return b}}}},rules:[{id:\"accesskeys\",selector:\"[accesskey]\",excludeHidden:!1,tags:[\"wcag2a\",\"wcag211\",\"cat.keyboard\"],all:[],any:[],none:[\"accesskeys\"]},{id:\"area-alt\",selector:\"map area[href]\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-alt\",\"non-empty-title\",\"aria-label\",\"aria-labelledby\"],none:[]},{id:\"aria-allowed-attr\",matches:function(a){var b=a.getAttribute(\"role\");b||(b=axe.commons.aria.implicitRole(a));var c=axe.commons.aria.allowedAttr(b);if(b&&c){var d=/^aria-/;if(a.hasAttributes())for(var e=a.attributes,f=0,g=e.length;f<g;f++)if(d.test(e[f].name))return!0}return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag411\",\"wcag412\"],all:[],any:[\"aria-allowed-attr\"],none:[]},{id:\"aria-required-attr\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag411\",\"wcag412\"],all:[],any:[\"aria-required-attr\"],none:[]},{id:\"aria-required-children\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\"],all:[],any:[\"aria-required-children\"],none:[]},{id:\"aria-required-parent\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\"],all:[],any:[\"aria-required-parent\"],none:[]},{id:\"aria-roles\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\",\"wcag411\",\"wcag412\"],all:[],any:[],none:[\"invalidrole\",\"abstractrole\"]},{id:\"aria-valid-attr-value\",matches:function(a){var b=/^aria-/;if(a.hasAttributes())for(var c=a.attributes,d=0,e=c.length;d<e;d++)if(b.test(c[d].name))return!0;return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag131\",\"wcag411\",\"wcag412\"],all:[],any:[{options:[],id:\"aria-valid-attr-value\"}],none:[]},{id:\"aria-valid-attr\",matches:function(a){var b=/^aria-/;if(a.hasAttributes())for(var c=a.attributes,d=0,e=c.length;d<e;d++)if(b.test(c[d].name))return!0;return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag411\"],all:[],any:[{options:[],id:\"aria-valid-attr\"}],none:[]},{id:\"audio-caption\",selector:\"audio\",excludeHidden:!1,tags:[\"cat.time-and-media\",\"wcag2a\",\"wcag122\",\"section508\",\"section508.22.a\"],all:[],any:[],none:[\"caption\"]},{id:\"blink\",selector:\"blink\",excludeHidden:!1,tags:[\"cat.time-and-media\",\"wcag2a\",\"wcag222\",\"section508\",\"section508.22.j\"],all:[],any:[],none:[\"is-on-screen\"]},{id:\"button-name\",selector:'button, [role=\"button\"], input[type=\"button\"], input[type=\"submit\"], input[type=\"reset\"]',tags:[\"cat.name-role-value\",\"wcag2a\",\"wcag412\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-if-present\",\"non-empty-value\",\"button-has-visible-text\",\"aria-label\",\"aria-labelledby\",\"role-presentation\",\"role-none\"],none:[\"focusable-no-name\"]},{id:\"bypass\",selector:\"html\",pageLevel:!0,matches:function(a){return!!a.querySelector(\"a[href]\")},tags:[\"cat.keyboard\",\"wcag2a\",\"wcag241\",\"section508\",\"section508.22.o\"],all:[],any:[\"internal-link-present\",\"header-present\",\"landmark\"],none:[]},{id:\"checkboxgroup\",selector:\"input[type=checkbox][name]\",tags:[\"cat.forms\",\"best-practice\"],all:[],any:[\"group-labelledby\",\"fieldset\"],none:[]},{id:\"color-contrast\",matches:function(a){var b=a.nodeName.toUpperCase(),c=a.type,d=document;if(\"true\"===a.getAttribute(\"aria-disabled\")||axe.commons.dom.findUp(a,'[aria-disabled=\"true\"]'))return!1;if(\"INPUT\"===b)return-1===[\"hidden\",\"range\",\"color\",\"checkbox\",\"radio\",\"image\"].indexOf(c)&&!a.disabled;if(\"SELECT\"===b)return!!a.options.length&&!a.disabled;if(\"TEXTAREA\"===b)return!a.disabled;if(\"OPTION\"===b)return!1;if(\"BUTTON\"===b&&a.disabled||axe.commons.dom.findUp(a,\"button[disabled]\"))return!1;if(\"FIELDSET\"===b&&a.disabled||axe.commons.dom.findUp(a,\"fieldset[disabled]\"))return!1;var e=axe.commons.dom.findUp(a,\"label\");if(\"LABEL\"===b||e){var f=a;e&&(f=e);var g=f.htmlFor&&d.getElementById(f.htmlFor);if(g&&g.disabled)return!1;var g=a.querySelector('input:not([type=\"hidden\"]):not([type=\"image\"]):not([type=\"button\"]):not([type=\"submit\"]):not([type=\"reset\"]), select, textarea');if(g&&g.disabled)return!1}if(a.id){var g=d.querySelector(\"[aria-labelledby~=\"+axe.commons.utils.escapeSelector(a.id)+\"]\");if(g&&g.disabled)return!1}if(\"\"===axe.commons.text.visible(a,!1,!0))return!1;var h,i,j=document.createRange(),k=a.childNodes,l=k.length;for(i=0;i<l;i++)h=k[i],3===h.nodeType&&\"\"!==axe.commons.text.sanitize(h.nodeValue)&&j.selectNodeContents(h);var m=j.getClientRects();for(l=m.length,i=0;i<l;i++)if(axe.commons.dom.visuallyOverlaps(m[i],a))return!0;return!1},excludeHidden:!1,options:{noScroll:!1},tags:[\"cat.color\",\"wcag2aa\",\"wcag143\"],all:[],any:[\"color-contrast\"],none:[]},{id:\"definition-list\",selector:\"dl:not([role])\",tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"structured-dlitems\",\"only-dlitems\"]},{id:\"dlitem\",selector:\"dd:not([role]), dt:not([role])\",tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[\"dlitem\"],none:[]},{id:\"document-title\",selector:\"html\",matches:function(a){return a.ownerDocument.defaultView.self===a.ownerDocument.defaultView.top},tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag242\"],all:[],any:[\"doc-has-title\"],none:[]},{id:\"duplicate-id\",selector:\"[id]\",excludeHidden:!1,tags:[\"cat.parsing\",\"wcag2a\",\"wcag411\"],all:[],any:[\"duplicate-id\"],none:[]},{id:\"empty-heading\",selector:'h1, h2, h3, h4, h5, h6, [role=\"heading\"]',enabled:!0,tags:[\"cat.name-role-value\",\"best-practice\"],all:[],any:[\"has-visible-text\",\"role-presentation\",\"role-none\"],none:[]},{id:\"frame-title-unique\",selector:\"frame[title]:not([title='']), iframe[title]:not([title=''])\",matches:function(a){var b=a.getAttribute(\"title\");return!!(b?axe.commons.text.sanitize(b).trim():\"\")},tags:[\"cat.text-alternatives\",\"best-practice\"],all:[],any:[],none:[\"unique-frame-title\"]},{id:\"frame-title\",selector:\"frame, iframe\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag241\",\"section508\",\"section508.22.i\"],all:[],any:[\"aria-label\",\"aria-labelledby\",\"non-empty-title\",\"role-presentation\",\"role-none\"],none:[]},{id:\"heading-order\",selector:\"h1,h2,h3,h4,h5,h6,[role=heading]\",enabled:!1,tags:[\"cat.semantics\",\"best-practice\"],all:[],any:[\"heading-order\"],none:[]},{id:\"href-no-hash\",selector:\"a[href]\",enabled:!1,tags:[\"cat.semantics\",\"best-practice\"],all:[],any:[\"href-no-hash\"],none:[]},{id:\"html-has-lang\",selector:\"html\",tags:[\"cat.language\",\"wcag2a\",\"wcag311\"],all:[],any:[\"has-lang\"],none:[]},{id:\"html-lang-valid\",selector:\"html[lang]\",tags:[\"cat.language\",\"wcag2a\",\"wcag311\"],all:[],any:[],none:[{\noptions:[\"aa\",\"ab\",\"ae\",\"af\",\"ak\",\"am\",\"an\",\"ar\",\"as\",\"av\",\"ay\",\"az\",\"ba\",\"be\",\"bg\",\"bh\",\"bi\",\"bm\",\"bn\",\"bo\",\"br\",\"bs\",\"ca\",\"ce\",\"ch\",\"co\",\"cr\",\"cs\",\"cu\",\"cv\",\"cy\",\"da\",\"de\",\"dv\",\"dz\",\"ee\",\"el\",\"en\",\"eo\",\"es\",\"et\",\"eu\",\"fa\",\"ff\",\"fi\",\"fj\",\"fo\",\"fr\",\"fy\",\"ga\",\"gd\",\"gl\",\"gn\",\"gu\",\"gv\",\"ha\",\"he\",\"hi\",\"ho\",\"hr\",\"ht\",\"hu\",\"hy\",\"hz\",\"ia\",\"id\",\"ie\",\"ig\",\"ii\",\"ik\",\"in\",\"io\",\"is\",\"it\",\"iu\",\"iw\",\"ja\",\"ji\",\"jv\",\"jw\",\"ka\",\"kg\",\"ki\",\"kj\",\"kk\",\"kl\",\"km\",\"kn\",\"ko\",\"kr\",\"ks\",\"ku\",\"kv\",\"kw\",\"ky\",\"la\",\"lb\",\"lg\",\"li\",\"ln\",\"lo\",\"lt\",\"lu\",\"lv\",\"mg\",\"mh\",\"mi\",\"mk\",\"ml\",\"mn\",\"mo\",\"mr\",\"ms\",\"mt\",\"my\",\"na\",\"nb\",\"nd\",\"ne\",\"ng\",\"nl\",\"nn\",\"no\",\"nr\",\"nv\",\"ny\",\"oc\",\"oj\",\"om\",\"or\",\"os\",\"pa\",\"pi\",\"pl\",\"ps\",\"pt\",\"qu\",\"rm\",\"rn\",\"ro\",\"ru\",\"rw\",\"sa\",\"sc\",\"sd\",\"se\",\"sg\",\"sh\",\"si\",\"sk\",\"sl\",\"sm\",\"sn\",\"so\",\"sq\",\"sr\",\"ss\",\"st\",\"su\",\"sv\",\"sw\",\"ta\",\"te\",\"tg\",\"th\",\"ti\",\"tk\",\"tl\",\"tn\",\"to\",\"tr\",\"ts\",\"tt\",\"tw\",\"ty\",\"ug\",\"uk\",\"ur\",\"uz\",\"ve\",\"vi\",\"vo\",\"wa\",\"wo\",\"xh\",\"yi\",\"yo\",\"za\",\"zh\",\"zu\",\"aaa\",\"aab\",\"aac\",\"aad\",\"aae\",\"aaf\",\"aag\",\"aah\",\"aai\",\"aak\",\"aal\",\"aam\",\"aan\",\"aao\",\"aap\",\"aaq\",\"aas\",\"aat\",\"aau\",\"aav\",\"aaw\",\"aax\",\"aaz\",\"aba\",\"abb\",\"abc\",\"abd\",\"abe\",\"abf\",\"abg\",\"abh\",\"abi\",\"abj\",\"abl\",\"abm\",\"abn\",\"abo\",\"abp\",\"abq\",\"abr\",\"abs\",\"abt\",\"abu\",\"abv\",\"abw\",\"abx\",\"aby\",\"abz\",\"aca\",\"acb\",\"acd\",\"ace\",\"acf\",\"ach\",\"aci\",\"ack\",\"acl\",\"acm\",\"acn\",\"acp\",\"acq\",\"acr\",\"acs\",\"act\",\"acu\",\"acv\",\"acw\",\"acx\",\"acy\",\"acz\",\"ada\",\"adb\",\"add\",\"ade\",\"adf\",\"adg\",\"adh\",\"adi\",\"adj\",\"adl\",\"adn\",\"ado\",\"adp\",\"adq\",\"adr\",\"ads\",\"adt\",\"adu\",\"adw\",\"adx\",\"ady\",\"adz\",\"aea\",\"aeb\",\"aec\",\"aed\",\"aee\",\"aek\",\"ael\",\"aem\",\"aen\",\"aeq\",\"aer\",\"aes\",\"aeu\",\"aew\",\"aey\",\"aez\",\"afa\",\"afb\",\"afd\",\"afe\",\"afg\",\"afh\",\"afi\",\"afk\",\"afn\",\"afo\",\"afp\",\"afs\",\"aft\",\"afu\",\"afz\",\"aga\",\"agb\",\"agc\",\"agd\",\"age\",\"agf\",\"agg\",\"agh\",\"agi\",\"agj\",\"agk\",\"agl\",\"agm\",\"agn\",\"ago\",\"agp\",\"agq\",\"agr\",\"ags\",\"agt\",\"agu\",\"agv\",\"agw\",\"agx\",\"agy\",\"agz\",\"aha\",\"ahb\",\"ahg\",\"ahh\",\"ahi\",\"ahk\",\"ahl\",\"ahm\",\"ahn\",\"aho\",\"ahp\",\"ahr\",\"ahs\",\"aht\",\"aia\",\"aib\",\"aic\",\"aid\",\"aie\",\"aif\",\"aig\",\"aih\",\"aii\",\"aij\",\"aik\",\"ail\",\"aim\",\"ain\",\"aio\",\"aip\",\"aiq\",\"air\",\"ais\",\"ait\",\"aiw\",\"aix\",\"aiy\",\"aja\",\"ajg\",\"aji\",\"ajn\",\"ajp\",\"ajt\",\"aju\",\"ajw\",\"ajz\",\"akb\",\"akc\",\"akd\",\"ake\",\"akf\",\"akg\",\"akh\",\"aki\",\"akj\",\"akk\",\"akl\",\"akm\",\"ako\",\"akp\",\"akq\",\"akr\",\"aks\",\"akt\",\"aku\",\"akv\",\"akw\",\"akx\",\"aky\",\"akz\",\"ala\",\"alc\",\"ald\",\"ale\",\"alf\",\"alg\",\"alh\",\"ali\",\"alj\",\"alk\",\"all\",\"alm\",\"aln\",\"alo\",\"alp\",\"alq\",\"alr\",\"als\",\"alt\",\"alu\",\"alv\",\"alw\",\"alx\",\"aly\",\"alz\",\"ama\",\"amb\",\"amc\",\"ame\",\"amf\",\"amg\",\"ami\",\"amj\",\"amk\",\"aml\",\"amm\",\"amn\",\"amo\",\"amp\",\"amq\",\"amr\",\"ams\",\"amt\",\"amu\",\"amv\",\"amw\",\"amx\",\"amy\",\"amz\",\"ana\",\"anb\",\"anc\",\"and\",\"ane\",\"anf\",\"ang\",\"anh\",\"ani\",\"anj\",\"ank\",\"anl\",\"anm\",\"ann\",\"ano\",\"anp\",\"anq\",\"anr\",\"ans\",\"ant\",\"anu\",\"anv\",\"anw\",\"anx\",\"any\",\"anz\",\"aoa\",\"aob\",\"aoc\",\"aod\",\"aoe\",\"aof\",\"aog\",\"aoh\",\"aoi\",\"aoj\",\"aok\",\"aol\",\"aom\",\"aon\",\"aor\",\"aos\",\"aot\",\"aou\",\"aox\",\"aoz\",\"apa\",\"apb\",\"apc\",\"apd\",\"ape\",\"apf\",\"apg\",\"aph\",\"api\",\"apj\",\"apk\",\"apl\",\"apm\",\"apn\",\"apo\",\"app\",\"apq\",\"apr\",\"aps\",\"apt\",\"apu\",\"apv\",\"apw\",\"apx\",\"apy\",\"apz\",\"aqa\",\"aqc\",\"aqd\",\"aqg\",\"aql\",\"aqm\",\"aqn\",\"aqp\",\"aqr\",\"aqt\",\"aqz\",\"arb\",\"arc\",\"ard\",\"are\",\"arh\",\"ari\",\"arj\",\"ark\",\"arl\",\"arn\",\"aro\",\"arp\",\"arq\",\"arr\",\"ars\",\"art\",\"aru\",\"arv\",\"arw\",\"arx\",\"ary\",\"arz\",\"asa\",\"asb\",\"asc\",\"asd\",\"ase\",\"asf\",\"asg\",\"ash\",\"asi\",\"asj\",\"ask\",\"asl\",\"asn\",\"aso\",\"asp\",\"asq\",\"asr\",\"ass\",\"ast\",\"asu\",\"asv\",\"asw\",\"asx\",\"asy\",\"asz\",\"ata\",\"atb\",\"atc\",\"atd\",\"ate\",\"atg\",\"ath\",\"ati\",\"atj\",\"atk\",\"atl\",\"atm\",\"atn\",\"ato\",\"atp\",\"atq\",\"atr\",\"ats\",\"att\",\"atu\",\"atv\",\"atw\",\"atx\",\"aty\",\"atz\",\"aua\",\"aub\",\"auc\",\"aud\",\"aue\",\"auf\",\"aug\",\"auh\",\"aui\",\"auj\",\"auk\",\"aul\",\"aum\",\"aun\",\"auo\",\"aup\",\"auq\",\"aur\",\"aus\",\"aut\",\"auu\",\"auw\",\"aux\",\"auy\",\"auz\",\"avb\",\"avd\",\"avi\",\"avk\",\"avl\",\"avm\",\"avn\",\"avo\",\"avs\",\"avt\",\"avu\",\"avv\",\"awa\",\"awb\",\"awc\",\"awd\",\"awe\",\"awg\",\"awh\",\"awi\",\"awk\",\"awm\",\"awn\",\"awo\",\"awr\",\"aws\",\"awt\",\"awu\",\"awv\",\"aww\",\"awx\",\"awy\",\"axb\",\"axe\",\"axg\",\"axk\",\"axl\",\"axm\",\"axx\",\"aya\",\"ayb\",\"ayc\",\"ayd\",\"aye\",\"ayg\",\"ayh\",\"ayi\",\"ayk\",\"ayl\",\"ayn\",\"ayo\",\"ayp\",\"ayq\",\"ayr\",\"ays\",\"ayt\",\"ayu\",\"ayx\",\"ayy\",\"ayz\",\"aza\",\"azb\",\"azc\",\"azd\",\"azg\",\"azj\",\"azm\",\"azn\",\"azo\",\"azt\",\"azz\",\"baa\",\"bab\",\"bac\",\"bad\",\"bae\",\"baf\",\"bag\",\"bah\",\"bai\",\"baj\",\"bal\",\"ban\",\"bao\",\"bap\",\"bar\",\"bas\",\"bat\",\"bau\",\"bav\",\"baw\",\"bax\",\"bay\",\"baz\",\"bba\",\"bbb\",\"bbc\",\"bbd\",\"bbe\",\"bbf\",\"bbg\",\"bbh\",\"bbi\",\"bbj\",\"bbk\",\"bbl\",\"bbm\",\"bbn\",\"bbo\",\"bbp\",\"bbq\",\"bbr\",\"bbs\",\"bbt\",\"bbu\",\"bbv\",\"bbw\",\"bbx\",\"bby\",\"bbz\",\"bca\",\"bcb\",\"bcc\",\"bcd\",\"bce\",\"bcf\",\"bcg\",\"bch\",\"bci\",\"bcj\",\"bck\",\"bcl\",\"bcm\",\"bcn\",\"bco\",\"bcp\",\"bcq\",\"bcr\",\"bcs\",\"bct\",\"bcu\",\"bcv\",\"bcw\",\"bcy\",\"bcz\",\"bda\",\"bdb\",\"bdc\",\"bdd\",\"bde\",\"bdf\",\"bdg\",\"bdh\",\"bdi\",\"bdj\",\"bdk\",\"bdl\",\"bdm\",\"bdn\",\"bdo\",\"bdp\",\"bdq\",\"bdr\",\"bds\",\"bdt\",\"bdu\",\"bdv\",\"bdw\",\"bdx\",\"bdy\",\"bdz\",\"bea\",\"beb\",\"bec\",\"bed\",\"bee\",\"bef\",\"beg\",\"beh\",\"bei\",\"bej\",\"bek\",\"bem\",\"beo\",\"bep\",\"beq\",\"ber\",\"bes\",\"bet\",\"beu\",\"bev\",\"bew\",\"bex\",\"bey\",\"bez\",\"bfa\",\"bfb\",\"bfc\",\"bfd\",\"bfe\",\"bff\",\"bfg\",\"bfh\",\"bfi\",\"bfj\",\"bfk\",\"bfl\",\"bfm\",\"bfn\",\"bfo\",\"bfp\",\"bfq\",\"bfr\",\"bfs\",\"bft\",\"bfu\",\"bfw\",\"bfx\",\"bfy\",\"bfz\",\"bga\",\"bgb\",\"bgc\",\"bgd\",\"bge\",\"bgf\",\"bgg\",\"bgi\",\"bgj\",\"bgk\",\"bgl\",\"bgm\",\"bgn\",\"bgo\",\"bgp\",\"bgq\",\"bgr\",\"bgs\",\"bgt\",\"bgu\",\"bgv\",\"bgw\",\"bgx\",\"bgy\",\"bgz\",\"bha\",\"bhb\",\"bhc\",\"bhd\",\"bhe\",\"bhf\",\"bhg\",\"bhh\",\"bhi\",\"bhj\",\"bhk\",\"bhl\",\"bhm\",\"bhn\",\"bho\",\"bhp\",\"bhq\",\"bhr\",\"bhs\",\"bht\",\"bhu\",\"bhv\",\"bhw\",\"bhx\",\"bhy\",\"bhz\",\"bia\",\"bib\",\"bic\",\"bid\",\"bie\",\"bif\",\"big\",\"bij\",\"bik\",\"bil\",\"bim\",\"bin\",\"bio\",\"bip\",\"biq\",\"bir\",\"bit\",\"biu\",\"biv\",\"biw\",\"bix\",\"biy\",\"biz\",\"bja\",\"bjb\",\"bjc\",\"bjd\",\"bje\",\"bjf\",\"bjg\",\"bjh\",\"bji\",\"bjj\",\"bjk\",\"bjl\",\"bjm\",\"bjn\",\"bjo\",\"bjp\",\"bjq\",\"bjr\",\"bjs\",\"bjt\",\"bju\",\"bjv\",\"bjw\",\"bjx\",\"bjy\",\"bjz\",\"bka\",\"bkb\",\"bkc\",\"bkd\",\"bkf\",\"bkg\",\"bkh\",\"bki\",\"bkj\",\"bkk\",\"bkl\",\"bkm\",\"bkn\",\"bko\",\"bkp\",\"bkq\",\"bkr\",\"bks\",\"bkt\",\"bku\",\"bkv\",\"bkw\",\"bkx\",\"bky\",\"bkz\",\"bla\",\"blb\",\"blc\",\"bld\",\"ble\",\"blf\",\"blg\",\"blh\",\"bli\",\"blj\",\"blk\",\"bll\",\"blm\",\"bln\",\"blo\",\"blp\",\"blq\",\"blr\",\"bls\",\"blt\",\"blv\",\"blw\",\"blx\",\"bly\",\"blz\",\"bma\",\"bmb\",\"bmc\",\"bmd\",\"bme\",\"bmf\",\"bmg\",\"bmh\",\"bmi\",\"bmj\",\"bmk\",\"bml\",\"bmm\",\"bmn\",\"bmo\",\"bmp\",\"bmq\",\"bmr\",\"bms\",\"bmt\",\"bmu\",\"bmv\",\"bmw\",\"bmx\",\"bmy\",\"bmz\",\"bna\",\"bnb\",\"bnc\",\"bnd\",\"bne\",\"bnf\",\"bng\",\"bni\",\"bnj\",\"bnk\",\"bnl\",\"bnm\",\"bnn\",\"bno\",\"bnp\",\"bnq\",\"bnr\",\"bns\",\"bnt\",\"bnu\",\"bnv\",\"bnw\",\"bnx\",\"bny\",\"bnz\",\"boa\",\"bob\",\"boe\",\"bof\",\"bog\",\"boh\",\"boi\",\"boj\",\"bok\",\"bol\",\"bom\",\"bon\",\"boo\",\"bop\",\"boq\",\"bor\",\"bot\",\"bou\",\"bov\",\"bow\",\"box\",\"boy\",\"boz\",\"bpa\",\"bpb\",\"bpd\",\"bpg\",\"bph\",\"bpi\",\"bpj\",\"bpk\",\"bpl\",\"bpm\",\"bpn\",\"bpo\",\"bpp\",\"bpq\",\"bpr\",\"bps\",\"bpt\",\"bpu\",\"bpv\",\"bpw\",\"bpx\",\"bpy\",\"bpz\",\"bqa\",\"bqb\",\"bqc\",\"bqd\",\"bqf\",\"bqg\",\"bqh\",\"bqi\",\"bqj\",\"bqk\",\"bql\",\"bqm\",\"bqn\",\"bqo\",\"bqp\",\"bqq\",\"bqr\",\"bqs\",\"bqt\",\"bqu\",\"bqv\",\"bqw\",\"bqx\",\"bqy\",\"bqz\",\"bra\",\"brb\",\"brc\",\"brd\",\"brf\",\"brg\",\"brh\",\"bri\",\"brj\",\"brk\",\"brl\",\"brm\",\"brn\",\"bro\",\"brp\",\"brq\",\"brr\",\"brs\",\"brt\",\"bru\",\"brv\",\"brw\",\"brx\",\"bry\",\"brz\",\"bsa\",\"bsb\",\"bsc\",\"bse\",\"bsf\",\"bsg\",\"bsh\",\"bsi\",\"bsj\",\"bsk\",\"bsl\",\"bsm\",\"bsn\",\"bso\",\"bsp\",\"bsq\",\"bsr\",\"bss\",\"bst\",\"bsu\",\"bsv\",\"bsw\",\"bsx\",\"bsy\",\"bta\",\"btb\",\"btc\",\"btd\",\"bte\",\"btf\",\"btg\",\"bth\",\"bti\",\"btj\",\"btk\",\"btl\",\"btm\",\"btn\",\"bto\",\"btp\",\"btq\",\"btr\",\"bts\",\"btt\",\"btu\",\"btv\",\"btw\",\"btx\",\"bty\",\"btz\",\"bua\",\"bub\",\"buc\",\"bud\",\"bue\",\"buf\",\"bug\",\"buh\",\"bui\",\"buj\",\"buk\",\"bum\",\"bun\",\"buo\",\"bup\",\"buq\",\"bus\",\"but\",\"buu\",\"buv\",\"buw\",\"bux\",\"buy\",\"buz\",\"bva\",\"bvb\",\"bvc\",\"bvd\",\"bve\",\"bvf\",\"bvg\",\"bvh\",\"bvi\",\"bvj\",\"bvk\",\"bvl\",\"bvm\",\"bvn\",\"bvo\",\"bvp\",\"bvq\",\"bvr\",\"bvt\",\"bvu\",\"bvv\",\"bvw\",\"bvx\",\"bvy\",\"bvz\",\"bwa\",\"bwb\",\"bwc\",\"bwd\",\"bwe\",\"bwf\",\"bwg\",\"bwh\",\"bwi\",\"bwj\",\"bwk\",\"bwl\",\"bwm\",\"bwn\",\"bwo\",\"bwp\",\"bwq\",\"bwr\",\"bws\",\"bwt\",\"bwu\",\"bww\",\"bwx\",\"bwy\",\"bwz\",\"bxa\",\"bxb\",\"bxc\",\"bxd\",\"bxe\",\"bxf\",\"bxg\",\"bxh\",\"bxi\",\"bxj\",\"bxk\",\"bxl\",\"bxm\",\"bxn\",\"bxo\",\"bxp\",\"bxq\",\"bxr\",\"bxs\",\"bxu\",\"bxv\",\"bxw\",\"bxx\",\"bxz\",\"bya\",\"byb\",\"byc\",\"byd\",\"bye\",\"byf\",\"byg\",\"byh\",\"byi\",\"byj\",\"byk\",\"byl\",\"bym\",\"byn\",\"byo\",\"byp\",\"byq\",\"byr\",\"bys\",\"byt\",\"byv\",\"byw\",\"byx\",\"byy\",\"byz\",\"bza\",\"bzb\",\"bzc\",\"bzd\",\"bze\",\"bzf\",\"bzg\",\"bzh\",\"bzi\",\"bzj\",\"bzk\",\"bzl\",\"bzm\",\"bzn\",\"bzo\",\"bzp\",\"bzq\",\"bzr\",\"bzs\",\"bzt\",\"bzu\",\"bzv\",\"bzw\",\"bzx\",\"bzy\",\"bzz\",\"caa\",\"cab\",\"cac\",\"cad\",\"cae\",\"caf\",\"cag\",\"cah\",\"cai\",\"caj\",\"cak\",\"cal\",\"cam\",\"can\",\"cao\",\"cap\",\"caq\",\"car\",\"cas\",\"cau\",\"cav\",\"caw\",\"cax\",\"cay\",\"caz\",\"cba\",\"cbb\",\"cbc\",\"cbd\",\"cbe\",\"cbg\",\"cbh\",\"cbi\",\"cbj\",\"cbk\",\"cbl\",\"cbn\",\"cbo\",\"cbq\",\"cbr\",\"cbs\",\"cbt\",\"cbu\",\"cbv\",\"cbw\",\"cby\",\"cca\",\"ccc\",\"ccd\",\"cce\",\"ccg\",\"cch\",\"ccj\",\"ccl\",\"ccm\",\"ccn\",\"cco\",\"ccp\",\"ccq\",\"ccr\",\"ccs\",\"cda\",\"cdc\",\"cdd\",\"cde\",\"cdf\",\"cdg\",\"cdh\",\"cdi\",\"cdj\",\"cdm\",\"cdn\",\"cdo\",\"cdr\",\"cds\",\"cdy\",\"cdz\",\"cea\",\"ceb\",\"ceg\",\"cek\",\"cel\",\"cen\",\"cet\",\"cfa\",\"cfd\",\"cfg\",\"cfm\",\"cga\",\"cgc\",\"cgg\",\"cgk\",\"chb\",\"chc\",\"chd\",\"chf\",\"chg\",\"chh\",\"chj\",\"chk\",\"chl\",\"chm\",\"chn\",\"cho\",\"chp\",\"chq\",\"chr\",\"cht\",\"chw\",\"chx\",\"chy\",\"chz\",\"cia\",\"cib\",\"cic\",\"cid\",\"cie\",\"cih\",\"cik\",\"cim\",\"cin\",\"cip\",\"cir\",\"ciw\",\"ciy\",\"cja\",\"cje\",\"cjh\",\"cji\",\"cjk\",\"cjm\",\"cjn\",\"cjo\",\"cjp\",\"cjr\",\"cjs\",\"cjv\",\"cjy\",\"cka\",\"ckb\",\"ckh\",\"ckl\",\"ckn\",\"cko\",\"ckq\",\"ckr\",\"cks\",\"ckt\",\"cku\",\"ckv\",\"ckx\",\"cky\",\"ckz\",\"cla\",\"clc\",\"cld\",\"cle\",\"clh\",\"cli\",\"clj\",\"clk\",\"cll\",\"clm\",\"clo\",\"clt\",\"clu\",\"clw\",\"cly\",\"cma\",\"cmc\",\"cme\",\"cmg\",\"cmi\",\"cmk\",\"cml\",\"cmm\",\"cmn\",\"cmo\",\"cmr\",\"cms\",\"cmt\",\"cna\",\"cnb\",\"cnc\",\"cng\",\"cnh\",\"cni\",\"cnk\",\"cnl\",\"cno\",\"cns\",\"cnt\",\"cnu\",\"cnw\",\"cnx\",\"coa\",\"cob\",\"coc\",\"cod\",\"coe\",\"cof\",\"cog\",\"coh\",\"coj\",\"cok\",\"col\",\"com\",\"con\",\"coo\",\"cop\",\"coq\",\"cot\",\"cou\",\"cov\",\"cow\",\"cox\",\"coy\",\"coz\",\"cpa\",\"cpb\",\"cpc\",\"cpe\",\"cpf\",\"cpg\",\"cpi\",\"cpn\",\"cpo\",\"cpp\",\"cps\",\"cpu\",\"cpx\",\"cpy\",\"cqd\",\"cqu\",\"cra\",\"crb\",\"crc\",\"crd\",\"crf\",\"crg\",\"crh\",\"cri\",\"crj\",\"crk\",\"crl\",\"crm\",\"crn\",\"cro\",\"crp\",\"crq\",\"crr\",\"crs\",\"crt\",\"crv\",\"crw\",\"crx\",\"cry\",\"crz\",\"csa\",\"csb\",\"csc\",\"csd\",\"cse\",\"csf\",\"csg\",\"csh\",\"csi\",\"csj\",\"csk\",\"csl\",\"csm\",\"csn\",\"cso\",\"csq\",\"csr\",\"css\",\"cst\",\"csu\",\"csv\",\"csw\",\"csy\",\"csz\",\"cta\",\"ctc\",\"ctd\",\"cte\",\"ctg\",\"cth\",\"ctl\",\"ctm\",\"ctn\",\"cto\",\"ctp\",\"cts\",\"ctt\",\"ctu\",\"ctz\",\"cua\",\"cub\",\"cuc\",\"cug\",\"cuh\",\"cui\",\"cuj\",\"cuk\",\"cul\",\"cum\",\"cuo\",\"cup\",\"cuq\",\"cur\",\"cus\",\"cut\",\"cuu\",\"cuv\",\"cuw\",\"cux\",\"cvg\",\"cvn\",\"cwa\",\"cwb\",\"cwd\",\"cwe\",\"cwg\",\"cwt\",\"cya\",\"cyb\",\"cyo\",\"czh\",\"czk\",\"czn\",\"czo\",\"czt\",\"daa\",\"dac\",\"dad\",\"dae\",\"daf\",\"dag\",\"dah\",\"dai\",\"daj\",\"dak\",\"dal\",\"dam\",\"dao\",\"dap\",\"daq\",\"dar\",\"das\",\"dau\",\"dav\",\"daw\",\"dax\",\"day\",\"daz\",\"dba\",\"dbb\",\"dbd\",\"dbe\",\"dbf\",\"dbg\",\"dbi\",\"dbj\",\"dbl\",\"dbm\",\"dbn\",\"dbo\",\"dbp\",\"dbq\",\"dbr\",\"dbt\",\"dbu\",\"dbv\",\"dbw\",\"dby\",\"dcc\",\"dcr\",\"dda\",\"ddd\",\"dde\",\"ddg\",\"ddi\",\"ddj\",\"ddn\",\"ddo\",\"ddr\",\"dds\",\"ddw\",\"dec\",\"ded\",\"dee\",\"def\",\"deg\",\"deh\",\"dei\",\"dek\",\"del\",\"dem\",\"den\",\"dep\",\"deq\",\"der\",\"des\",\"dev\",\"dez\",\"dga\",\"dgb\",\"dgc\",\"dgd\",\"dge\",\"dgg\",\"dgh\",\"dgi\",\"dgk\",\"dgl\",\"dgn\",\"dgo\",\"dgr\",\"dgs\",\"dgt\",\"dgu\",\"dgw\",\"dgx\",\"dgz\",\"dha\",\"dhd\",\"dhg\",\"dhi\",\"dhl\",\"dhm\",\"dhn\",\"dho\",\"dhr\",\"dhs\",\"dhu\",\"dhv\",\"dhw\",\"dhx\",\"dia\",\"dib\",\"dic\",\"did\",\"dif\",\"dig\",\"dih\",\"dii\",\"dij\",\"dik\",\"dil\",\"dim\",\"din\",\"dio\",\"dip\",\"diq\",\"dir\",\"dis\",\"dit\",\"diu\",\"diw\",\"dix\",\"diy\",\"diz\",\"dja\",\"djb\",\"djc\",\"djd\",\"dje\",\"djf\",\"dji\",\"djj\",\"djk\",\"djl\",\"djm\",\"djn\",\"djo\",\"djr\",\"dju\",\"djw\",\"dka\",\"dkk\",\"dkl\",\"dkr\",\"dks\",\"dkx\",\"dlg\",\"dlk\",\"dlm\",\"dln\",\"dma\",\"dmb\",\"dmc\",\"dmd\",\"dme\",\"dmg\",\"dmk\",\"dml\",\"dmm\",\"dmn\",\"dmo\",\"dmr\",\"dms\",\"dmu\",\"dmv\",\"dmw\",\"dmx\",\"dmy\",\"dna\",\"dnd\",\"dne\",\"dng\",\"dni\",\"dnj\",\"dnk\",\"dnn\",\"dnr\",\"dnt\",\"dnu\",\"dnv\",\"dnw\",\"dny\",\"doa\",\"dob\",\"doc\",\"doe\",\"dof\",\"doh\",\"doi\",\"dok\",\"dol\",\"don\",\"doo\",\"dop\",\"doq\",\"dor\",\"dos\",\"dot\",\"dov\",\"dow\",\"dox\",\"doy\",\"doz\",\"dpp\",\"dra\",\"drb\",\"drc\",\"drd\",\"dre\",\"drg\",\"drh\",\"dri\",\"drl\",\"drn\",\"dro\",\"drq\",\"drr\",\"drs\",\"drt\",\"dru\",\"drw\",\"dry\",\"dsb\",\"dse\",\"dsh\",\"dsi\",\"dsl\",\"dsn\",\"dso\",\"dsq\",\"dta\",\"dtb\",\"dtd\",\"dth\",\"dti\",\"dtk\",\"dtm\",\"dtn\",\"dto\",\"dtp\",\"dtr\",\"dts\",\"dtt\",\"dtu\",\"dty\",\"dua\",\"dub\",\"duc\",\"dud\",\"due\",\"duf\",\"dug\",\"duh\",\"dui\",\"duj\",\"duk\",\"dul\",\"dum\",\"dun\",\"duo\",\"dup\",\"duq\",\"dur\",\"dus\",\"duu\",\"duv\",\"duw\",\"dux\",\"duy\",\"duz\",\"dva\",\"dwa\",\"dwl\",\"dwr\",\"dws\",\"dwu\",\"dww\",\"dwy\",\"dya\",\"dyb\",\"dyd\",\"dyg\",\"dyi\",\"dym\",\"dyn\",\"dyo\",\"dyu\",\"dyy\",\"dza\",\"dzd\",\"dze\",\"dzg\",\"dzl\",\"dzn\",\"eaa\",\"ebg\",\"ebk\",\"ebo\",\"ebr\",\"ebu\",\"ecr\",\"ecs\",\"ecy\",\"eee\",\"efa\",\"efe\",\"efi\",\"ega\",\"egl\",\"ego\",\"egx\",\"egy\",\"ehu\",\"eip\",\"eit\",\"eiv\",\"eja\",\"eka\",\"ekc\",\"eke\",\"ekg\",\"eki\",\"ekk\",\"ekl\",\"ekm\",\"eko\",\"ekp\",\"ekr\",\"eky\",\"ele\",\"elh\",\"eli\",\"elk\",\"elm\",\"elo\",\"elp\",\"elu\",\"elx\",\"ema\",\"emb\",\"eme\",\"emg\",\"emi\",\"emk\",\"emm\",\"emn\",\"emo\",\"emp\",\"ems\",\"emu\",\"emw\",\"emx\",\"emy\",\"ena\",\"enb\",\"enc\",\"end\",\"enf\",\"enh\",\"enl\",\"enm\",\"enn\",\"eno\",\"enq\",\"enr\",\"enu\",\"env\",\"enw\",\"enx\",\"eot\",\"epi\",\"era\",\"erg\",\"erh\",\"eri\",\"erk\",\"ero\",\"err\",\"ers\",\"ert\",\"erw\",\"ese\",\"esg\",\"esh\",\"esi\",\"esk\",\"esl\",\"esm\",\"esn\",\"eso\",\"esq\",\"ess\",\"esu\",\"esx\",\"esy\",\"etb\",\"etc\",\"eth\",\"etn\",\"eto\",\"etr\",\"ets\",\"ett\",\"etu\",\"etx\",\"etz\",\"euq\",\"eve\",\"evh\",\"evn\",\"ewo\",\"ext\",\"eya\",\"eyo\",\"eza\",\"eze\",\"faa\",\"fab\",\"fad\",\"faf\",\"fag\",\"fah\",\"fai\",\"faj\",\"fak\",\"fal\",\"fam\",\"fan\",\"fap\",\"far\",\"fat\",\"fau\",\"fax\",\"fay\",\"faz\",\"fbl\",\"fcs\",\"fer\",\"ffi\",\"ffm\",\"fgr\",\"fia\",\"fie\",\"fil\",\"fip\",\"fir\",\"fit\",\"fiu\",\"fiw\",\"fkk\",\"fkv\",\"fla\",\"flh\",\"fli\",\"fll\",\"fln\",\"flr\",\"fly\",\"fmp\",\"fmu\",\"fnb\",\"fng\",\"fni\",\"fod\",\"foi\",\"fom\",\"fon\",\"for\",\"fos\",\"fox\",\"fpe\",\"fqs\",\"frc\",\"frd\",\"frk\",\"frm\",\"fro\",\"frp\",\"frq\",\"frr\",\"frs\",\"frt\",\"fse\",\"fsl\",\"fss\",\"fub\",\"fuc\",\"fud\",\"fue\",\"fuf\",\"fuh\",\"fui\",\"fuj\",\"fum\",\"fun\",\"fuq\",\"fur\",\"fut\",\"fuu\",\"fuv\",\"fuy\",\"fvr\",\"fwa\",\"fwe\",\"gaa\",\"gab\",\"gac\",\"gad\",\"gae\",\"gaf\",\"gag\",\"gah\",\"gai\",\"gaj\",\"gak\",\"gal\",\"gam\",\"gan\",\"gao\",\"gap\",\"gaq\",\"gar\",\"gas\",\"gat\",\"gau\",\"gav\",\"gaw\",\"gax\",\"gay\",\"gaz\",\"gba\",\"gbb\",\"gbc\",\"gbd\",\"gbe\",\"gbf\",\"gbg\",\"gbh\",\"gbi\",\"gbj\",\"gbk\",\"gbl\",\"gbm\",\"gbn\",\"gbo\",\"gbp\",\"gbq\",\"gbr\",\"gbs\",\"gbu\",\"gbv\",\"gbw\",\"gbx\",\"gby\",\"gbz\",\"gcc\",\"gcd\",\"gce\",\"gcf\",\"gcl\",\"gcn\",\"gcr\",\"gct\",\"gda\",\"gdb\",\"gdc\",\"gdd\",\"gde\",\"gdf\",\"gdg\",\"gdh\",\"gdi\",\"gdj\",\"gdk\",\"gdl\",\"gdm\",\"gdn\",\"gdo\",\"gdq\",\"gdr\",\"gds\",\"gdt\",\"gdu\",\"gdx\",\"gea\",\"geb\",\"gec\",\"ged\",\"geg\",\"geh\",\"gei\",\"gej\",\"gek\",\"gel\",\"gem\",\"geq\",\"ges\",\"gev\",\"gew\",\"gex\",\"gey\",\"gez\",\"gfk\",\"gft\",\"gfx\",\"gga\",\"ggb\",\"ggd\",\"gge\",\"ggg\",\"ggk\",\"ggl\",\"ggn\",\"ggo\",\"ggr\",\"ggt\",\"ggu\",\"ggw\",\"gha\",\"ghc\",\"ghe\",\"ghh\",\"ghk\",\"ghl\",\"ghn\",\"gho\",\"ghr\",\"ghs\",\"ght\",\"gia\",\"gib\",\"gic\",\"gid\",\"gig\",\"gih\",\"gil\",\"gim\",\"gin\",\"gio\",\"gip\",\"giq\",\"gir\",\"gis\",\"git\",\"giu\",\"giw\",\"gix\",\"giy\",\"giz\",\"gji\",\"gjk\",\"gjm\",\"gjn\",\"gjr\",\"gju\",\"gka\",\"gke\",\"gkn\",\"gko\",\"gkp\",\"gku\",\"glc\",\"gld\",\"glh\",\"gli\",\"glj\",\"glk\",\"gll\",\"glo\",\"glr\",\"glu\",\"glw\",\"gly\",\"gma\",\"gmb\",\"gmd\",\"gme\",\"gmg\",\"gmh\",\"gml\",\"gmm\",\"gmn\",\"gmq\",\"gmu\",\"gmv\",\"gmw\",\"gmx\",\"gmy\",\"gmz\",\"gna\",\"gnb\",\"gnc\",\"gnd\",\"gne\",\"gng\",\"gnh\",\"gni\",\"gnk\",\"gnl\",\"gnm\",\"gnn\",\"gno\",\"gnq\",\"gnr\",\"gnt\",\"gnu\",\"gnw\",\"gnz\",\"goa\",\"gob\",\"goc\",\"god\",\"goe\",\"gof\",\"gog\",\"goh\",\"goi\",\"goj\",\"gok\",\"gol\",\"gom\",\"gon\",\"goo\",\"gop\",\"goq\",\"gor\",\"gos\",\"got\",\"gou\",\"gow\",\"gox\",\"goy\",\"goz\",\"gpa\",\"gpe\",\"gpn\",\"gqa\",\"gqi\",\"gqn\",\"gqr\",\"gqu\",\"gra\",\"grb\",\"grc\",\"grd\",\"grg\",\"grh\",\"gri\",\"grj\",\"grk\",\"grm\",\"gro\",\"grq\",\"grr\",\"grs\",\"grt\",\"gru\",\"grv\",\"grw\",\"grx\",\"gry\",\"grz\",\"gse\",\"gsg\",\"gsl\",\"gsm\",\"gsn\",\"gso\",\"gsp\",\"gss\",\"gsw\",\"gta\",\"gti\",\"gtu\",\"gua\",\"gub\",\"guc\",\"gud\",\"gue\",\"guf\",\"gug\",\"guh\",\"gui\",\"guk\",\"gul\",\"gum\",\"gun\",\"guo\",\"gup\",\"guq\",\"gur\",\"gus\",\"gut\",\"guu\",\"guv\",\"guw\",\"gux\",\"guz\",\"gva\",\"gvc\",\"gve\",\"gvf\",\"gvj\",\"gvl\",\"gvm\",\"gvn\",\"gvo\",\"gvp\",\"gvr\",\"gvs\",\"gvy\",\"gwa\",\"gwb\",\"gwc\",\"gwd\",\"gwe\",\"gwf\",\"gwg\",\"gwi\",\"gwj\",\"gwm\",\"gwn\",\"gwr\",\"gwt\",\"gwu\",\"gww\",\"gwx\",\"gxx\",\"gya\",\"gyb\",\"gyd\",\"gye\",\"gyf\",\"gyg\",\"gyi\",\"gyl\",\"gym\",\"gyn\",\"gyr\",\"gyy\",\"gza\",\"gzi\",\"gzn\",\"haa\",\"hab\",\"hac\",\"had\",\"hae\",\"haf\",\"hag\",\"hah\",\"hai\",\"haj\",\"hak\",\"hal\",\"ham\",\"han\",\"hao\",\"hap\",\"haq\",\"har\",\"has\",\"hav\",\"haw\",\"hax\",\"hay\",\"haz\",\"hba\",\"hbb\",\"hbn\",\"hbo\",\"hbu\",\"hca\",\"hch\",\"hdn\",\"hds\",\"hdy\",\"hea\",\"hed\",\"heg\",\"heh\",\"hei\",\"hem\",\"hgm\",\"hgw\",\"hhi\",\"hhr\",\"hhy\",\"hia\",\"hib\",\"hid\",\"hif\",\"hig\",\"hih\",\"hii\",\"hij\",\"hik\",\"hil\",\"him\",\"hio\",\"hir\",\"hit\",\"hiw\",\"hix\",\"hji\",\"hka\",\"hke\",\"hkk\",\"hks\",\"hla\",\"hlb\",\"hld\",\"hle\",\"hlt\",\"hlu\",\"hma\",\"hmb\",\"hmc\",\"hmd\",\"hme\",\"hmf\",\"hmg\",\"hmh\",\"hmi\",\"hmj\",\"hmk\",\"hml\",\"hmm\",\"hmn\",\"hmp\",\"hmq\",\"hmr\",\"hms\",\"hmt\",\"hmu\",\"hmv\",\"hmw\",\"hmx\",\"hmy\",\"hmz\",\"hna\",\"hnd\",\"hne\",\"hnh\",\"hni\",\"hnj\",\"hnn\",\"hno\",\"hns\",\"hnu\",\"hoa\",\"hob\",\"hoc\",\"hod\",\"hoe\",\"hoh\",\"hoi\",\"hoj\",\"hok\",\"hol\",\"hom\",\"hoo\",\"hop\",\"hor\",\"hos\",\"hot\",\"hov\",\"how\",\"hoy\",\"hoz\",\"hpo\",\"hps\",\"hra\",\"hrc\",\"hre\",\"hrk\",\"hrm\",\"hro\",\"hrp\",\"hrr\",\"hrt\",\"hru\",\"hrw\",\"hrx\",\"hrz\",\"hsb\",\"hsh\",\"hsl\",\"hsn\",\"hss\",\"hti\",\"hto\",\"hts\",\"htu\",\"htx\",\"hub\",\"huc\",\"hud\",\"hue\",\"huf\",\"hug\",\"huh\",\"hui\",\"huj\",\"huk\",\"hul\",\"hum\",\"huo\",\"hup\",\"huq\",\"hur\",\"hus\",\"hut\",\"huu\",\"huv\",\"huw\",\"hux\",\"huy\",\"huz\",\"hvc\",\"hve\",\"hvk\",\"hvn\",\"hvv\",\"hwa\",\"hwc\",\"hwo\",\"hya\",\"hyx\",\"iai\",\"ian\",\"iap\",\"iar\",\"iba\",\"ibb\",\"ibd\",\"ibe\",\"ibg\",\"ibi\",\"ibl\",\"ibm\",\"ibn\",\"ibr\",\"ibu\",\"iby\",\"ica\",\"ich\",\"icl\",\"icr\",\"ida\",\"idb\",\"idc\",\"idd\",\"ide\",\"idi\",\"idr\",\"ids\",\"idt\",\"idu\",\"ifa\",\"ifb\",\"ife\",\"iff\",\"ifk\",\"ifm\",\"ifu\",\"ify\",\"igb\",\"ige\",\"igg\",\"igl\",\"igm\",\"ign\",\"igo\",\"igs\",\"igw\",\"ihb\",\"ihi\",\"ihp\",\"ihw\",\"iin\",\"iir\",\"ijc\",\"ije\",\"ijj\",\"ijn\",\"ijo\",\"ijs\",\"ike\",\"iki\",\"ikk\",\"ikl\",\"iko\",\"ikp\",\"ikr\",\"iks\",\"ikt\",\"ikv\",\"ikw\",\"ikx\",\"ikz\",\"ila\",\"ilb\",\"ilg\",\"ili\",\"ilk\",\"ill\",\"ilm\",\"ilo\",\"ilp\",\"ils\",\"ilu\",\"ilv\",\"ilw\",\"ima\",\"ime\",\"imi\",\"iml\",\"imn\",\"imo\",\"imr\",\"ims\",\"imy\",\"inb\",\"inc\",\"ine\",\"ing\",\"inh\",\"inj\",\"inl\",\"inm\",\"inn\",\"ino\",\"inp\",\"ins\",\"int\",\"inz\",\"ior\",\"iou\",\"iow\",\"ipi\",\"ipo\",\"iqu\",\"iqw\",\"ira\",\"ire\",\"irh\",\"iri\",\"irk\",\"irn\",\"iro\",\"irr\",\"iru\",\"irx\",\"iry\",\"isa\",\"isc\",\"isd\",\"ise\",\"isg\",\"ish\",\"isi\",\"isk\",\"ism\",\"isn\",\"iso\",\"isr\",\"ist\",\"isu\",\"itb\",\"itc\",\"itd\",\"ite\",\"iti\",\"itk\",\"itl\",\"itm\",\"ito\",\"itr\",\"its\",\"itt\",\"itv\",\"itw\",\"itx\",\"ity\",\"itz\",\"ium\",\"ivb\",\"ivv\",\"iwk\",\"iwm\",\"iwo\",\"iws\",\"ixc\",\"ixl\",\"iya\",\"iyo\",\"iyx\",\"izh\",\"izi\",\"izr\",\"izz\",\"jaa\",\"jab\",\"jac\",\"jad\",\"jae\",\"jaf\",\"jah\",\"jaj\",\"jak\",\"jal\",\"jam\",\"jan\",\"jao\",\"jaq\",\"jar\",\"jas\",\"jat\",\"jau\",\"jax\",\"jay\",\"jaz\",\"jbe\",\"jbi\",\"jbj\",\"jbk\",\"jbn\",\"jbo\",\"jbr\",\"jbt\",\"jbu\",\"jbw\",\"jcs\",\"jct\",\"jda\",\"jdg\",\"jdt\",\"jeb\",\"jee\",\"jeg\",\"jeh\",\"jei\",\"jek\",\"jel\",\"jen\",\"jer\",\"jet\",\"jeu\",\"jgb\",\"jge\",\"jgk\",\"jgo\",\"jhi\",\"jhs\",\"jia\",\"jib\",\"jic\",\"jid\",\"jie\",\"jig\",\"jih\",\"jii\",\"jil\",\"jim\",\"jio\",\"jiq\",\"jit\",\"jiu\",\"jiv\",\"jiy\",\"jje\",\"jjr\",\"jka\",\"jkm\",\"jko\",\"jkp\",\"jkr\",\"jku\",\"jle\",\"jls\",\"jma\",\"jmb\",\"jmc\",\"jmd\",\"jmi\",\"jml\",\"jmn\",\"jmr\",\"jms\",\"jmw\",\"jmx\",\"jna\",\"jnd\",\"jng\",\"jni\",\"jnj\",\"jnl\",\"jns\",\"job\",\"jod\",\"jog\",\"jor\",\"jos\",\"jow\",\"jpa\",\"jpr\",\"jpx\",\"jqr\",\"jra\",\"jrb\",\"jrr\",\"jrt\",\"jru\",\"jsl\",\"jua\",\"jub\",\"juc\",\"jud\",\"juh\",\"jui\",\"juk\",\"jul\",\"jum\",\"jun\",\"juo\",\"jup\",\"jur\",\"jus\",\"jut\",\"juu\",\"juw\",\"juy\",\"jvd\",\"jvn\",\"jwi\",\"jya\",\"jye\",\"jyy\",\"kaa\",\"kab\",\"kac\",\"kad\",\"kae\",\"kaf\",\"kag\",\"kah\",\"kai\",\"kaj\",\"kak\",\"kam\",\"kao\",\"kap\",\"kaq\",\"kar\",\"kav\",\"kaw\",\"kax\",\"kay\",\"kba\",\"kbb\",\"kbc\",\"kbd\",\"kbe\",\"kbf\",\"kbg\",\"kbh\",\"kbi\",\"kbj\",\"kbk\",\"kbl\",\"kbm\",\"kbn\",\"kbo\",\"kbp\",\"kbq\",\"kbr\",\"kbs\",\"kbt\",\"kbu\",\"kbv\",\"kbw\",\"kbx\",\"kby\",\"kbz\",\"kca\",\"kcb\",\"kcc\",\"kcd\",\"kce\",\"kcf\",\"kcg\",\"kch\",\"kci\",\"kcj\",\"kck\",\"kcl\",\"kcm\",\"kcn\",\"kco\",\"kcp\",\"kcq\",\"kcr\",\"kcs\",\"kct\",\"kcu\",\"kcv\",\"kcw\",\"kcx\",\"kcy\",\"kcz\",\"kda\",\"kdc\",\"kdd\",\"kde\",\"kdf\",\"kdg\",\"kdh\",\"kdi\",\"kdj\",\"kdk\",\"kdl\",\"kdm\",\"kdn\",\"kdo\",\"kdp\",\"kdq\",\"kdr\",\"kdt\",\"kdu\",\"kdv\",\"kdw\",\"kdx\",\"kdy\",\"kdz\",\"kea\",\"keb\",\"kec\",\"ked\",\"kee\",\"kef\",\"keg\",\"keh\",\"kei\",\"kej\",\"kek\",\"kel\",\"kem\",\"ken\",\"keo\",\"kep\",\"keq\",\"ker\",\"kes\",\"ket\",\"keu\",\"kev\",\"kew\",\"kex\",\"key\",\"kez\",\"kfa\",\"kfb\",\"kfc\",\"kfd\",\"kfe\",\"kff\",\"kfg\",\"kfh\",\"kfi\",\"kfj\",\"kfk\",\"kfl\",\"kfm\",\"kfn\",\"kfo\",\"kfp\",\"kfq\",\"kfr\",\"kfs\",\"kft\",\"kfu\",\"kfv\",\"kfw\",\"kfx\",\"kfy\",\"kfz\",\"kga\",\"kgb\",\"kgc\",\"kgd\",\"kge\",\"kgf\",\"kgg\",\"kgh\",\"kgi\",\"kgj\",\"kgk\",\"kgl\",\"kgm\",\"kgn\",\"kgo\",\"kgp\",\"kgq\",\"kgr\",\"kgs\",\"kgt\",\"kgu\",\"kgv\",\"kgw\",\"kgx\",\"kgy\",\"kha\",\"khb\",\"khc\",\"khd\",\"khe\",\"khf\",\"khg\",\"khh\",\"khi\",\"khj\",\"khk\",\"khl\",\"khn\",\"kho\",\"khp\",\"khq\",\"khr\",\"khs\",\"kht\",\"khu\",\"khv\",\"khw\",\"khx\",\"khy\",\"khz\",\"kia\",\"kib\",\"kic\",\"kid\",\"kie\",\"kif\",\"kig\",\"kih\",\"kii\",\"kij\",\"kil\",\"kim\",\"kio\",\"kip\",\"kiq\",\"kis\",\"kit\",\"kiu\",\"kiv\",\"kiw\",\"kix\",\"kiy\",\"kiz\",\"kja\",\"kjb\",\"kjc\",\"kjd\",\"kje\",\"kjf\",\"kjg\",\"kjh\",\"kji\",\"kjj\",\"kjk\",\"kjl\",\"kjm\",\"kjn\",\"kjo\",\"kjp\",\"kjq\",\"kjr\",\"kjs\",\"kjt\",\"kju\",\"kjv\",\"kjx\",\"kjy\",\"kjz\",\"kka\",\"kkb\",\"kkc\",\"kkd\",\"kke\",\"kkf\",\"kkg\",\"kkh\",\"kki\",\"kkj\",\"kkk\",\"kkl\",\"kkm\",\"kkn\",\"kko\",\"kkp\",\"kkq\",\"kkr\",\"kks\",\"kkt\",\"kku\",\"kkv\",\"kkw\",\"kkx\",\"kky\",\"kkz\",\"kla\",\"klb\",\"klc\",\"kld\",\"kle\",\"klf\",\"klg\",\"klh\",\"kli\",\"klj\",\"klk\",\"kll\",\"klm\",\"kln\",\"klo\",\"klp\",\"klq\",\"klr\",\"kls\",\"klt\",\"klu\",\"klv\",\"klw\",\"klx\",\"kly\",\"klz\",\"kma\",\"kmb\",\"kmc\",\"kmd\",\"kme\",\"kmf\",\"kmg\",\"kmh\",\"kmi\",\"kmj\",\"kmk\",\"kml\",\"kmm\",\"kmn\",\"kmo\",\"kmp\",\"kmq\",\"kmr\",\"kms\",\"kmt\",\"kmu\",\"kmv\",\"kmw\",\"kmx\",\"kmy\",\"kmz\",\"kna\",\"knb\",\"knc\",\"knd\",\"kne\",\"knf\",\"kng\",\"kni\",\"knj\",\"knk\",\"knl\",\"knm\",\"knn\",\"kno\",\"knp\",\"knq\",\"knr\",\"kns\",\"knt\",\"knu\",\"knv\",\"knw\",\"knx\",\"kny\",\"knz\",\"koa\",\"koc\",\"kod\",\"koe\",\"kof\",\"kog\",\"koh\",\"koi\",\"koj\",\"kok\",\"kol\",\"koo\",\"kop\",\"koq\",\"kos\",\"kot\",\"kou\",\"kov\",\"kow\",\"kox\",\"koy\",\"koz\",\"kpa\",\"kpb\",\"kpc\",\"kpd\",\"kpe\",\"kpf\",\"kpg\",\"kph\",\"kpi\",\"kpj\",\"kpk\",\"kpl\",\"kpm\",\"kpn\",\"kpo\",\"kpp\",\"kpq\",\"kpr\",\"kps\",\"kpt\",\"kpu\",\"kpv\",\"kpw\",\"kpx\",\"kpy\",\"kpz\",\"kqa\",\"kqb\",\"kqc\",\"kqd\",\"kqe\",\"kqf\",\"kqg\",\"kqh\",\"kqi\",\"kqj\",\"kqk\",\"kql\",\"kqm\",\"kqn\",\"kqo\",\"kqp\",\"kqq\",\"kqr\",\"kqs\",\"kqt\",\"kqu\",\"kqv\",\"kqw\",\"kqx\",\"kqy\",\"kqz\",\"kra\",\"krb\",\"krc\",\"krd\",\"kre\",\"krf\",\"krh\",\"kri\",\"krj\",\"krk\",\"krl\",\"krm\",\"krn\",\"kro\",\"krp\",\"krr\",\"krs\",\"krt\",\"kru\",\"krv\",\"krw\",\"krx\",\"kry\",\"krz\",\"ksa\",\"ksb\",\"ksc\",\"ksd\",\"kse\",\"ksf\",\"ksg\",\"ksh\",\"ksi\",\"ksj\",\"ksk\",\"ksl\",\"ksm\",\"ksn\",\"kso\",\"ksp\",\"ksq\",\"ksr\",\"kss\",\"kst\",\"ksu\",\"ksv\",\"ksw\",\"ksx\",\"ksy\",\"ksz\",\"kta\",\"ktb\",\"ktc\",\"ktd\",\"kte\",\"ktf\",\"ktg\",\"kth\",\"kti\",\"ktj\",\"ktk\",\"ktl\",\"ktm\",\"ktn\",\"kto\",\"ktp\",\"ktq\",\"ktr\",\"kts\",\"ktt\",\"ktu\",\"ktv\",\"ktw\",\"ktx\",\"kty\",\"ktz\",\"kub\",\"kuc\",\"kud\",\"kue\",\"kuf\",\"kug\",\"kuh\",\"kui\",\"kuj\",\"kuk\",\"kul\",\"kum\",\"kun\",\"kuo\",\"kup\",\"kuq\",\"kus\",\"kut\",\"kuu\",\"kuv\",\"kuw\",\"kux\",\"kuy\",\"kuz\",\"kva\",\"kvb\",\"kvc\",\"kvd\",\"kve\",\"kvf\",\"kvg\",\"kvh\",\"kvi\",\"kvj\",\"kvk\",\"kvl\",\"kvm\",\"kvn\",\"kvo\",\"kvp\",\"kvq\",\"kvr\",\"kvs\",\"kvt\",\"kvu\",\"kvv\",\"kvw\",\"kvx\",\"kvy\",\"kvz\",\"kwa\",\"kwb\",\"kwc\",\"kwd\",\"kwe\",\"kwf\",\"kwg\",\"kwh\",\"kwi\",\"kwj\",\"kwk\",\"kwl\",\"kwm\",\"kwn\",\"kwo\",\"kwp\",\"kwq\",\"kwr\",\"kws\",\"kwt\",\"kwu\",\"kwv\",\"kww\",\"kwx\",\"kwy\",\"kwz\",\"kxa\",\"kxb\",\"kxc\",\"kxd\",\"kxe\",\"kxf\",\"kxh\",\"kxi\",\"kxj\",\"kxk\",\"kxl\",\"kxm\",\"kxn\",\"kxo\",\"kxp\",\"kxq\",\"kxr\",\"kxs\",\"kxt\",\"kxu\",\"kxv\",\"kxw\",\"kxx\",\"kxy\",\"kxz\",\"kya\",\"kyb\",\"kyc\",\"kyd\",\"kye\",\"kyf\",\"kyg\",\"kyh\",\"kyi\",\"kyj\",\"kyk\",\"kyl\",\"kym\",\"kyn\",\"kyo\",\"kyp\",\"kyq\",\"kyr\",\"kys\",\"kyt\",\"kyu\",\"kyv\",\"kyw\",\"kyx\",\"kyy\",\"kyz\",\"kza\",\"kzb\",\"kzc\",\"kzd\",\"kze\",\"kzf\",\"kzg\",\"kzh\",\"kzi\",\"kzj\",\"kzk\",\"kzl\",\"kzm\",\"kzn\",\"kzo\",\"kzp\",\"kzq\",\"kzr\",\"kzs\",\"kzt\",\"kzu\",\"kzv\",\"kzw\",\"kzx\",\"kzy\",\"kzz\",\"laa\",\"lab\",\"lac\",\"lad\",\"lae\",\"laf\",\"lag\",\"lah\",\"lai\",\"laj\",\"lak\",\"lal\",\"lam\",\"lan\",\"lap\",\"laq\",\"lar\",\"las\",\"lau\",\"law\",\"lax\",\"lay\",\"laz\",\"lba\",\"lbb\",\"lbc\",\"lbe\",\"lbf\",\"lbg\",\"lbi\",\"lbj\",\"lbk\",\"lbl\",\"lbm\",\"lbn\",\"lbo\",\"lbq\",\"lbr\",\"lbs\",\"lbt\",\"lbu\",\"lbv\",\"lbw\",\"lbx\",\"lby\",\"lbz\",\"lcc\",\"lcd\",\"lce\",\"lcf\",\"lch\",\"lcl\",\"lcm\",\"lcp\",\"lcq\",\"lcs\",\"lda\",\"ldb\",\"ldd\",\"ldg\",\"ldh\",\"ldi\",\"ldj\",\"ldk\",\"ldl\",\"ldm\",\"ldn\",\"ldo\",\"ldp\",\"ldq\",\"lea\",\"leb\",\"lec\",\"led\",\"lee\",\"lef\",\"leg\",\"leh\",\"lei\",\"lej\",\"lek\",\"lel\",\"lem\",\"len\",\"leo\",\"lep\",\"leq\",\"ler\",\"les\",\"let\",\"leu\",\"lev\",\"lew\",\"lex\",\"ley\",\"lez\",\"lfa\",\"lfn\",\"lga\",\"lgb\",\"lgg\",\"lgh\",\"lgi\",\"lgk\",\"lgl\",\"lgm\",\"lgn\",\"lgq\",\"lgr\",\"lgt\",\"lgu\",\"lgz\",\"lha\",\"lhh\",\"lhi\",\"lhl\",\"lhm\",\"lhn\",\"lhp\",\"lhs\",\"lht\",\"lhu\",\"lia\",\"lib\",\"lic\",\"lid\",\"lie\",\"lif\",\"lig\",\"lih\",\"lii\",\"lij\",\"lik\",\"lil\",\"lio\",\"lip\",\"liq\",\"lir\",\"lis\",\"liu\",\"liv\",\"liw\",\"lix\",\"liy\",\"liz\",\"lja\",\"lje\",\"lji\",\"ljl\",\"ljp\",\"ljw\",\"ljx\",\"lka\",\"lkb\",\"lkc\",\"lkd\",\"lke\",\"lkh\",\"lki\",\"lkj\",\"lkl\",\"lkm\",\"lkn\",\"lko\",\"lkr\",\"lks\",\"lkt\",\"lku\",\"lky\",\"lla\",\"llb\",\"llc\",\"lld\",\"lle\",\"llf\",\"llg\",\"llh\",\"lli\",\"llj\",\"llk\",\"lll\",\"llm\",\"lln\",\"llo\",\"llp\",\"llq\",\"lls\",\"llu\",\"llx\",\"lma\",\"lmb\",\"lmc\",\"lmd\",\"lme\",\"lmf\",\"lmg\",\"lmh\",\"lmi\",\"lmj\",\"lmk\",\"lml\",\"lmm\",\"lmn\",\"lmo\",\"lmp\",\"lmq\",\"lmr\",\"lmu\",\"lmv\",\"lmw\",\"lmx\",\"lmy\",\"lmz\",\"lna\",\"lnb\",\"lnd\",\"lng\",\"lnh\",\"lni\",\"lnj\",\"lnl\",\"lnm\",\"lnn\",\"lno\",\"lns\",\"lnu\",\"lnw\",\"lnz\",\"loa\",\"lob\",\"loc\",\"loe\",\"lof\",\"log\",\"loh\",\"loi\",\"loj\",\"lok\",\"lol\",\"lom\",\"lon\",\"loo\",\"lop\",\"loq\",\"lor\",\"los\",\"lot\",\"lou\",\"lov\",\"low\",\"lox\",\"loy\",\"loz\",\"lpa\",\"lpe\",\"lpn\",\"lpo\",\"lpx\",\"lra\",\"lrc\",\"lre\",\"lrg\",\"lri\",\"lrk\",\"lrl\",\"lrm\",\"lrn\",\"lro\",\"lrr\",\"lrt\",\"lrv\",\"lrz\",\"lsa\",\"lsd\",\"lse\",\"lsg\",\"lsh\",\"lsi\",\"lsl\",\"lsm\",\"lso\",\"lsp\",\"lsr\",\"lss\",\"lst\",\"lsy\",\"ltc\",\"ltg\",\"lti\",\"ltn\",\"lto\",\"lts\",\"ltu\",\"lua\",\"luc\",\"lud\",\"lue\",\"luf\",\"lui\",\"luj\",\"luk\",\"lul\",\"lum\",\"lun\",\"luo\",\"lup\",\"luq\",\"lur\",\"lus\",\"lut\",\"luu\",\"luv\",\"luw\",\"luy\",\"luz\",\"lva\",\"lvk\",\"lvs\",\"lvu\",\"lwa\",\"lwe\",\"lwg\",\"lwh\",\"lwl\",\"lwm\",\"lwo\",\"lwt\",\"lwu\",\"lww\",\"lya\",\"lyg\",\"lyn\",\"lzh\",\"lzl\",\"lzn\",\"lzz\",\"maa\",\"mab\",\"mad\",\"mae\",\"maf\",\"mag\",\"mai\",\"maj\",\"mak\",\"mam\",\"man\",\"map\",\"maq\",\"mas\",\"mat\",\"mau\",\"mav\",\"maw\",\"max\",\"maz\",\"mba\",\"mbb\",\"mbc\",\"mbd\",\"mbe\",\"mbf\",\"mbh\",\"mbi\",\"mbj\",\"mbk\",\"mbl\",\"mbm\",\"mbn\",\"mbo\",\"mbp\",\"mbq\",\"mbr\",\"mbs\",\"mbt\",\"mbu\",\"mbv\",\"mbw\",\"mbx\",\"mby\",\"mbz\",\"mca\",\"mcb\",\"mcc\",\"mcd\",\"mce\",\"mcf\",\"mcg\",\"mch\",\"mci\",\"mcj\",\"mck\",\"mcl\",\"mcm\",\"mcn\",\"mco\",\"mcp\",\"mcq\",\"mcr\",\"mcs\",\"mct\",\"mcu\",\"mcv\",\"mcw\",\"mcx\",\"mcy\",\"mcz\",\"mda\",\"mdb\",\"mdc\",\"mdd\",\"mde\",\"mdf\",\"mdg\",\"mdh\",\"mdi\",\"mdj\",\"mdk\",\"mdl\",\"mdm\",\"mdn\",\"mdp\",\"mdq\",\"mdr\",\"mds\",\"mdt\",\"mdu\",\"mdv\",\"mdw\",\"mdx\",\"mdy\",\"mdz\",\"mea\",\"meb\",\"mec\",\"med\",\"mee\",\"mef\",\"meg\",\"meh\",\"mei\",\"mej\",\"mek\",\"mel\",\"mem\",\"men\",\"meo\",\"mep\",\"meq\",\"mer\",\"mes\",\"met\",\"meu\",\"mev\",\"mew\",\"mey\",\"mez\",\"mfa\",\"mfb\",\"mfc\",\"mfd\",\"mfe\",\"mff\",\"mfg\",\"mfh\",\"mfi\",\"mfj\",\"mfk\",\"mfl\",\"mfm\",\"mfn\",\"mfo\",\"mfp\",\"mfq\",\"mfr\",\"mfs\",\"mft\",\"mfu\",\"mfv\",\"mfw\",\"mfx\",\"mfy\",\"mfz\",\"mga\",\"mgb\",\"mgc\",\"mgd\",\"mge\",\"mgf\",\"mgg\",\"mgh\",\"mgi\",\"mgj\",\"mgk\",\"mgl\",\"mgm\",\"mgn\",\"mgo\",\"mgp\",\"mgq\",\"mgr\",\"mgs\",\"mgt\",\"mgu\",\"mgv\",\"mgw\",\"mgx\",\"mgy\",\"mgz\",\"mha\",\"mhb\",\"mhc\",\"mhd\",\"mhe\",\"mhf\",\"mhg\",\"mhh\",\"mhi\",\"mhj\",\"mhk\",\"mhl\",\"mhm\",\"mhn\",\"mho\",\"mhp\",\"mhq\",\"mhr\",\"mhs\",\"mht\",\"mhu\",\"mhw\",\"mhx\",\"mhy\",\"mhz\",\"mia\",\"mib\",\"mic\",\"mid\",\"mie\",\"mif\",\"mig\",\"mih\",\"mii\",\"mij\",\"mik\",\"mil\",\"mim\",\"min\",\"mio\",\"mip\",\"miq\",\"mir\",\"mis\",\"mit\",\"miu\",\"miw\",\"mix\",\"miy\",\"miz\",\"mja\",\"mjb\",\"mjc\",\"mjd\",\"mje\",\"mjg\",\"mjh\",\"mji\",\"mjj\",\"mjk\",\"mjl\",\"mjm\",\"mjn\",\"mjo\",\"mjp\",\"mjq\",\"mjr\",\"mjs\",\"mjt\",\"mju\",\"mjv\",\"mjw\",\"mjx\",\"mjy\",\"mjz\",\"mka\",\"mkb\",\"mkc\",\"mke\",\"mkf\",\"mkg\",\"mkh\",\"mki\",\"mkj\",\"mkk\",\"mkl\",\"mkm\",\"mkn\",\"mko\",\"mkp\",\"mkq\",\"mkr\",\"mks\",\"mkt\",\"mku\",\"mkv\",\"mkw\",\"mkx\",\"mky\",\"mkz\",\"mla\",\"mlb\",\"mlc\",\"mld\",\"mle\",\"mlf\",\"mlh\",\"mli\",\"mlj\",\"mlk\",\"mll\",\"mlm\",\"mln\",\"mlo\",\"mlp\",\"mlq\",\"mlr\",\"mls\",\"mlu\",\"mlv\",\"mlw\",\"mlx\",\"mlz\",\"mma\",\"mmb\",\"mmc\",\"mmd\",\"mme\",\"mmf\",\"mmg\",\"mmh\",\"mmi\",\"mmj\",\"mmk\",\"mml\",\"mmm\",\"mmn\",\"mmo\",\"mmp\",\"mmq\",\"mmr\",\"mmt\",\"mmu\",\"mmv\",\"mmw\",\"mmx\",\"mmy\",\"mmz\",\"mna\",\"mnb\",\"mnc\",\"mnd\",\"mne\",\"mnf\",\"mng\",\"mnh\",\"mni\",\"mnj\",\"mnk\",\"mnl\",\"mnm\",\"mnn\",\"mno\",\"mnp\",\"mnq\",\"mnr\",\"mns\",\"mnt\",\"mnu\",\"mnv\",\"mnw\",\"mnx\",\"mny\",\"mnz\",\"moa\",\"moc\",\"mod\",\"moe\",\"mof\",\"mog\",\"moh\",\"moi\",\"moj\",\"mok\",\"mom\",\"moo\",\"mop\",\"moq\",\"mor\",\"mos\",\"mot\",\"mou\",\"mov\",\"mow\",\"mox\",\"moy\",\"moz\",\"mpa\",\"mpb\",\"mpc\",\"mpd\",\"mpe\",\"mpg\",\"mph\",\"mpi\",\"mpj\",\"mpk\",\"mpl\",\"mpm\",\"mpn\",\"mpo\",\"mpp\",\"mpq\",\"mpr\",\"mps\",\"mpt\",\"mpu\",\"mpv\",\"mpw\",\"mpx\",\"mpy\",\"mpz\",\"mqa\",\"mqb\",\"mqc\",\"mqe\",\"mqf\",\"mqg\",\"mqh\",\"mqi\",\"mqj\",\"mqk\",\"mql\",\"mqm\",\"mqn\",\"mqo\",\"mqp\",\"mqq\",\"mqr\",\"mqs\",\"mqt\",\"mqu\",\"mqv\",\"mqw\",\"mqx\",\"mqy\",\"mqz\",\"mra\",\"mrb\",\"mrc\",\"mrd\",\"mre\",\"mrf\",\"mrg\",\"mrh\",\"mrj\",\"mrk\",\"mrl\",\"mrm\",\"mrn\",\"mro\",\"mrp\",\"mrq\",\"mrr\",\"mrs\",\"mrt\",\"mru\",\"mrv\",\"mrw\",\"mrx\",\"mry\",\"mrz\",\"msb\",\"msc\",\"msd\",\"mse\",\"msf\",\"msg\",\"msh\",\"msi\",\"msj\",\"msk\",\"msl\",\"msm\",\"msn\",\"mso\",\"msp\",\"msq\",\"msr\",\"mss\",\"mst\",\"msu\",\"msv\",\"msw\",\"msx\",\"msy\",\"msz\",\"mta\",\"mtb\",\"mtc\",\"mtd\",\"mte\",\"mtf\",\"mtg\",\"mth\",\"mti\",\"mtj\",\"mtk\",\"mtl\",\"mtm\",\"mtn\",\"mto\",\"mtp\",\"mtq\",\"mtr\",\"mts\",\"mtt\",\"mtu\",\"mtv\",\"mtw\",\"mtx\",\"mty\",\"mua\",\"mub\",\"muc\",\"mud\",\"mue\",\"mug\",\"muh\",\"mui\",\"muj\",\"muk\",\"mul\",\"mum\",\"mun\",\"muo\",\"mup\",\"muq\",\"mur\",\"mus\",\"mut\",\"muu\",\"muv\",\"mux\",\"muy\",\"muz\",\"mva\",\"mvb\",\"mvd\",\"mve\",\"mvf\",\"mvg\",\"mvh\",\"mvi\",\"mvk\",\"mvl\",\"mvm\",\"mvn\",\"mvo\",\"mvp\",\"mvq\",\"mvr\",\"mvs\",\"mvt\",\"mvu\",\"mvv\",\"mvw\",\"mvx\",\"mvy\",\"mvz\",\"mwa\",\"mwb\",\"mwc\",\"mwd\",\"mwe\",\"mwf\",\"mwg\",\"mwh\",\"mwi\",\"mwj\",\"mwk\",\"mwl\",\"mwm\",\"mwn\",\"mwo\",\"mwp\",\"mwq\",\"mwr\",\"mws\",\"mwt\",\"mwu\",\"mwv\",\"mww\",\"mwx\",\"mwy\",\"mwz\",\"mxa\",\"mxb\",\"mxc\",\"mxd\",\"mxe\",\"mxf\",\"mxg\",\"mxh\",\"mxi\",\"mxj\",\"mxk\",\"mxl\",\"mxm\",\"mxn\",\"mxo\",\"mxp\",\"mxq\",\"mxr\",\"mxs\",\"mxt\",\"mxu\",\"mxv\",\"mxw\",\"mxx\",\"mxy\",\"mxz\",\"myb\",\"myc\",\"myd\",\"mye\",\"myf\",\"myg\",\"myh\",\"myi\",\"myj\",\"myk\",\"myl\",\"mym\",\"myn\",\"myo\",\"myp\",\"myq\",\"myr\",\"mys\",\"myt\",\"myu\",\"myv\",\"myw\",\"myx\",\"myy\",\"myz\",\"mza\",\"mzb\",\"mzc\",\"mzd\",\"mze\",\"mzg\",\"mzh\",\"mzi\",\"mzj\",\"mzk\",\"mzl\",\"mzm\",\"mzn\",\"mzo\",\"mzp\",\"mzq\",\"mzr\",\"mzs\",\"mzt\",\"mzu\",\"mzv\",\"mzw\",\"mzx\",\"mzy\",\"mzz\",\"naa\",\"nab\",\"nac\",\"nad\",\"nae\",\"naf\",\"nag\",\"nah\",\"nai\",\"naj\",\"nak\",\"nal\",\"nam\",\"nan\",\"nao\",\"nap\",\"naq\",\"nar\",\"nas\",\"nat\",\"naw\",\"nax\",\"nay\",\"naz\",\"nba\",\"nbb\",\"nbc\",\"nbd\",\"nbe\",\"nbf\",\"nbg\",\"nbh\",\"nbi\",\"nbj\",\"nbk\",\"nbm\",\"nbn\",\"nbo\",\"nbp\",\"nbq\",\"nbr\",\"nbs\",\"nbt\",\"nbu\",\"nbv\",\"nbw\",\"nbx\",\"nby\",\"nca\",\"ncb\",\"ncc\",\"ncd\",\"nce\",\"ncf\",\"ncg\",\"nch\",\"nci\",\"ncj\",\"nck\",\"ncl\",\"ncm\",\"ncn\",\"nco\",\"ncp\",\"ncr\",\"ncs\",\"nct\",\"ncu\",\"ncx\",\"ncz\",\"nda\",\"ndb\",\"ndc\",\"ndd\",\"ndf\",\"ndg\",\"ndh\",\"ndi\",\"ndj\",\"ndk\",\"ndl\",\"ndm\",\"ndn\",\"ndp\",\"ndq\",\"ndr\",\"nds\",\"ndt\",\"ndu\",\"ndv\",\"ndw\",\"ndx\",\"ndy\",\"ndz\",\"nea\",\"neb\",\"nec\",\"ned\",\"nee\",\"nef\",\"neg\",\"neh\",\"nei\",\"nej\",\"nek\",\"nem\",\"nen\",\"neo\",\"neq\",\"ner\",\"nes\",\"net\",\"neu\",\"nev\",\"new\",\"nex\",\"ney\",\"nez\",\"nfa\",\"nfd\",\"nfl\",\"nfr\",\"nfu\",\"nga\",\"ngb\",\"ngc\",\"ngd\",\"nge\",\"ngf\",\"ngg\",\"ngh\",\"ngi\",\"ngj\",\"ngk\",\"ngl\",\"ngm\",\"ngn\",\"ngo\",\"ngp\",\"ngq\",\"ngr\",\"ngs\",\"ngt\",\"ngu\",\"ngv\",\"ngw\",\"ngx\",\"ngy\",\"ngz\",\"nha\",\"nhb\",\"nhc\",\"nhd\",\"nhe\",\"nhf\",\"nhg\",\"nhh\",\"nhi\",\"nhk\",\"nhm\",\"nhn\",\"nho\",\"nhp\",\"nhq\",\"nhr\",\"nht\",\"nhu\",\"nhv\",\"nhw\",\"nhx\",\"nhy\",\"nhz\",\"nia\",\"nib\",\"nic\",\"nid\",\"nie\",\"nif\",\"nig\",\"nih\",\"nii\",\"nij\",\"nik\",\"nil\",\"nim\",\"nin\",\"nio\",\"niq\",\"nir\",\"nis\",\"nit\",\"niu\",\"niv\",\"niw\",\"nix\",\"niy\",\"niz\",\"nja\",\"njb\",\"njd\",\"njh\",\"nji\",\"njj\",\"njl\",\"njm\",\"njn\",\"njo\",\"njr\",\"njs\",\"njt\",\"nju\",\"njx\",\"njy\",\"njz\",\"nka\",\"nkb\",\"nkc\",\"nkd\",\"nke\",\"nkf\",\"nkg\",\"nkh\",\"nki\",\"nkj\",\"nkk\",\"nkm\",\"nkn\",\"nko\",\"nkp\",\"nkq\",\"nkr\",\"nks\",\"nkt\",\"nku\",\"nkv\",\"nkw\",\"nkx\",\"nkz\",\"nla\",\"nlc\",\"nle\",\"nlg\",\"nli\",\"nlj\",\"nlk\",\"nll\",\"nln\",\"nlo\",\"nlq\",\"nlr\",\"nlu\",\"nlv\",\"nlw\",\"nlx\",\"nly\",\"nlz\",\"nma\",\"nmb\",\"nmc\",\"nmd\",\"nme\",\"nmf\",\"nmg\",\"nmh\",\"nmi\",\"nmj\",\"nmk\",\"nml\",\"nmm\",\"nmn\",\"nmo\",\"nmp\",\"nmq\",\"nmr\",\"nms\",\"nmt\",\"nmu\",\"nmv\",\"nmw\",\"nmx\",\"nmy\",\"nmz\",\"nna\",\"nnb\",\"nnc\",\"nnd\",\"nne\",\"nnf\",\"nng\",\"nnh\",\"nni\",\"nnj\",\"nnk\",\"nnl\",\"nnm\",\"nnn\",\"nnp\",\"nnq\",\"nnr\",\"nns\",\"nnt\",\"nnu\",\"nnv\",\"nnw\",\"nnx\",\"nny\",\"nnz\",\"noa\",\"noc\",\"nod\",\"noe\",\"nof\",\"nog\",\"noh\",\"noi\",\"noj\",\"nok\",\"nol\",\"nom\",\"non\",\"noo\",\"nop\",\"noq\",\"nos\",\"not\",\"nou\",\"nov\",\"now\",\"noy\",\"noz\",\"npa\",\"npb\",\"npg\",\"nph\",\"npi\",\"npl\",\"npn\",\"npo\",\"nps\",\"npu\",\"npy\",\"nqg\",\"nqk\",\"nqm\",\"nqn\",\"nqo\",\"nqq\",\"nqy\",\"nra\",\"nrb\",\"nrc\",\"nre\",\"nrf\",\"nrg\",\"nri\",\"nrk\",\"nrl\",\"nrm\",\"nrn\",\"nrp\",\"nrr\",\"nrt\",\"nru\",\"nrx\",\"nrz\",\"nsa\",\"nsc\",\"nsd\",\"nse\",\"nsf\",\"nsg\",\"nsh\",\"nsi\",\"nsk\",\"nsl\",\"nsm\",\"nsn\",\"nso\",\"nsp\",\"nsq\",\"nsr\",\"nss\",\"nst\",\"nsu\",\"nsv\",\"nsw\",\"nsx\",\"nsy\",\"nsz\",\"ntd\",\"nte\",\"ntg\",\"nti\",\"ntj\",\"ntk\",\"ntm\",\"nto\",\"ntp\",\"ntr\",\"nts\",\"ntu\",\"ntw\",\"ntx\",\"nty\",\"ntz\",\"nua\",\"nub\",\"nuc\",\"nud\",\"nue\",\"nuf\",\"nug\",\"nuh\",\"nui\",\"nuj\",\"nuk\",\"nul\",\"num\",\"nun\",\"nuo\",\"nup\",\"nuq\",\"nur\",\"nus\",\"nut\",\"nuu\",\"nuv\",\"nuw\",\"nux\",\"nuy\",\"nuz\",\"nvh\",\"nvm\",\"nvo\",\"nwa\",\"nwb\",\"nwc\",\"nwe\",\"nwg\",\"nwi\",\"nwm\",\"nwo\",\"nwr\",\"nwx\",\"nwy\",\"nxa\",\"nxd\",\"nxe\",\"nxg\",\"nxi\",\"nxk\",\"nxl\",\"nxm\",\"nxn\",\"nxo\",\"nxq\",\"nxr\",\"nxu\",\"nxx\",\"nyb\",\"nyc\",\"nyd\",\"nye\",\"nyf\",\"nyg\",\"nyh\",\"nyi\",\"nyj\",\"nyk\",\"nyl\",\"nym\",\"nyn\",\"nyo\",\"nyp\",\"nyq\",\"nyr\",\"nys\",\"nyt\",\"nyu\",\"nyv\",\"nyw\",\"nyx\",\"nyy\",\"nza\",\"nzb\",\"nzi\",\"nzk\",\"nzm\",\"nzs\",\"nzu\",\"nzy\",\"nzz\",\"oaa\",\"oac\",\"oar\",\"oav\",\"obi\",\"obk\",\"obl\",\"obm\",\"obo\",\"obr\",\"obt\",\"obu\",\"oca\",\"och\",\"oco\",\"ocu\",\"oda\",\"odk\",\"odt\",\"odu\",\"ofo\",\"ofs\",\"ofu\",\"ogb\",\"ogc\",\"oge\",\"ogg\",\"ogo\",\"ogu\",\"oht\",\"ohu\",\"oia\",\"oin\",\"ojb\",\"ojc\",\"ojg\",\"ojp\",\"ojs\",\"ojv\",\"ojw\",\"oka\",\"okb\",\"okd\",\"oke\",\"okg\",\"okh\",\"oki\",\"okj\",\"okk\",\"okl\",\"okm\",\"okn\",\"oko\",\"okr\",\"oks\",\"oku\",\"okv\",\"okx\",\"ola\",\"old\",\"ole\",\"olk\",\"olm\",\"olo\",\"olr\",\"olt\",\"olu\",\"oma\",\"omb\",\"omc\",\"ome\",\"omg\",\"omi\",\"omk\",\"oml\",\"omn\",\"omo\",\"omp\",\"omq\",\"omr\",\"omt\",\"omu\",\"omv\",\"omw\",\"omx\",\"ona\",\"onb\",\"one\",\"ong\",\"oni\",\"onj\",\"onk\",\"onn\",\"ono\",\"onp\",\"onr\",\"ons\",\"ont\",\"onu\",\"onw\",\"onx\",\"ood\",\"oog\",\"oon\",\"oor\",\"oos\",\"opa\",\"opk\",\"opm\",\"opo\",\"opt\",\"opy\",\"ora\",\"orc\",\"ore\",\"org\",\"orh\",\"orn\",\"oro\",\"orr\",\"ors\",\"ort\",\"oru\",\"orv\",\"orw\",\"orx\",\"ory\",\"orz\",\"osa\",\"osc\",\"osi\",\"oso\",\"osp\",\"ost\",\"osu\",\"osx\",\"ota\",\"otb\",\"otd\",\"ote\",\"oti\",\"otk\",\"otl\",\"otm\",\"otn\",\"oto\",\"otq\",\"otr\",\"ots\",\"ott\",\"otu\",\"otw\",\"otx\",\"oty\",\"otz\",\"oua\",\"oub\",\"oue\",\"oui\",\"oum\",\"oun\",\"ovd\",\"owi\",\"owl\",\"oyb\",\"oyd\",\"oym\",\"oyy\",\"ozm\",\"paa\",\"pab\",\"pac\",\"pad\",\"pae\",\"paf\",\"pag\",\"pah\",\"pai\",\"pak\",\"pal\",\"pam\",\"pao\",\"pap\",\"paq\",\"par\",\"pas\",\"pat\",\"pau\",\"pav\",\"paw\",\"pax\",\"pay\",\"paz\",\"pbb\",\"pbc\",\"pbe\",\"pbf\",\"pbg\",\"pbh\",\"pbi\",\"pbl\",\"pbn\",\"pbo\",\"pbp\",\"pbr\",\"pbs\",\"pbt\",\"pbu\",\"pbv\",\"pby\",\"pbz\",\"pca\",\"pcb\",\"pcc\",\"pcd\",\"pce\",\"pcf\",\"pcg\",\"pch\",\"pci\",\"pcj\",\"pck\",\"pcl\",\"pcm\",\"pcn\",\"pcp\",\"pcr\",\"pcw\",\"pda\",\"pdc\",\"pdi\",\"pdn\",\"pdo\",\"pdt\",\"pdu\",\"pea\",\"peb\",\"ped\",\"pee\",\"pef\",\"peg\",\"peh\",\"pei\",\"pej\",\"pek\",\"pel\",\"pem\",\"peo\",\"pep\",\"peq\",\"pes\",\"pev\",\"pex\",\"pey\",\"pez\",\"pfa\",\"pfe\",\"pfl\",\"pga\",\"pgd\",\"pgg\",\"pgi\",\"pgk\",\"pgl\",\"pgn\",\"pgs\",\"pgu\",\"pgy\",\"pgz\",\"pha\",\"phd\",\"phg\",\"phh\",\"phi\",\"phk\",\"phl\",\"phm\",\"phn\",\"pho\",\"phq\",\"phr\",\"pht\",\"phu\",\"phv\",\"phw\",\"pia\",\"pib\",\"pic\",\"pid\",\"pie\",\"pif\",\"pig\",\"pih\",\"pii\",\"pij\",\"pil\",\"pim\",\"pin\",\"pio\",\"pip\",\"pir\",\"pis\",\"pit\",\"piu\",\"piv\",\"piw\",\"pix\",\"piy\",\"piz\",\"pjt\",\"pka\",\"pkb\",\"pkc\",\"pkg\",\"pkh\",\"pkn\",\"pko\",\"pkp\",\"pkr\",\"pks\",\"pkt\",\"pku\",\"pla\",\"plb\",\"plc\",\"pld\",\"ple\",\"plf\",\"plg\",\"plh\",\"plj\",\"plk\",\"pll\",\"pln\",\"plo\",\"plp\",\"plq\",\"plr\",\"pls\",\"plt\",\"plu\",\"plv\",\"plw\",\"ply\",\"plz\",\"pma\",\"pmb\",\"pmc\",\"pmd\",\"pme\",\"pmf\",\"pmh\",\"pmi\",\"pmj\",\"pmk\",\"pml\",\"pmm\",\"pmn\",\"pmo\",\"pmq\",\"pmr\",\"pms\",\"pmt\",\"pmu\",\"pmw\",\"pmx\",\"pmy\",\"pmz\",\"pna\",\"pnb\",\"pnc\",\"pne\",\"png\",\"pnh\",\"pni\",\"pnj\",\"pnk\",\"pnl\",\"pnm\",\"pnn\",\"pno\",\"pnp\",\"pnq\",\"pnr\",\"pns\",\"pnt\",\"pnu\",\"pnv\",\"pnw\",\"pnx\",\"pny\",\"pnz\",\"poc\",\"pod\",\"poe\",\"pof\",\"pog\",\"poh\",\"poi\",\"pok\",\"pom\",\"pon\",\"poo\",\"pop\",\"poq\",\"pos\",\"pot\",\"pov\",\"pow\",\"pox\",\"poy\",\"poz\",\"ppa\",\"ppe\",\"ppi\",\"ppk\",\"ppl\",\"ppm\",\"ppn\",\"ppo\",\"ppp\",\"ppq\",\"ppr\",\"pps\",\"ppt\",\"ppu\",\"pqa\",\"pqe\",\"pqm\",\"pqw\",\"pra\",\"prb\",\"prc\",\"prd\",\"pre\",\"prf\",\"prg\",\"prh\",\"pri\",\"prk\",\"prl\",\"prm\",\"prn\",\"pro\",\"prp\",\"prq\",\"prr\",\"prs\",\"prt\",\"pru\",\"prw\",\"prx\",\"pry\",\"prz\",\"psa\",\"psc\",\"psd\",\"pse\",\"psg\",\"psh\",\"psi\",\"psl\",\"psm\",\"psn\",\"pso\",\"psp\",\"psq\",\"psr\",\"pss\",\"pst\",\"psu\",\"psw\",\"psy\",\"pta\",\"pth\",\"pti\",\"ptn\",\"pto\",\"ptp\",\"ptq\",\"ptr\",\"ptt\",\"ptu\",\"ptv\",\"ptw\",\"pty\",\"pua\",\"pub\",\"puc\",\"pud\",\"pue\",\"puf\",\"pug\",\"pui\",\"puj\",\"puk\",\"pum\",\"puo\",\"pup\",\"puq\",\"pur\",\"put\",\"puu\",\"puw\",\"pux\",\"puy\",\"puz\",\"pwa\",\"pwb\",\"pwg\",\"pwi\",\"pwm\",\"pwn\",\"pwo\",\"pwr\",\"pww\",\"pxm\",\"pye\",\"pym\",\"pyn\",\"pys\",\"pyu\",\"pyx\",\"pyy\",\"pzn\",\"qaa..qtz\",\"qua\",\"qub\",\"quc\",\"qud\",\"quf\",\"qug\",\"quh\",\"qui\",\"quk\",\"qul\",\"qum\",\"qun\",\"qup\",\"quq\",\"qur\",\"qus\",\"quv\",\"quw\",\"qux\",\"quy\",\"quz\",\"qva\",\"qvc\",\"qve\",\"qvh\",\"qvi\",\"qvj\",\"qvl\",\"qvm\",\"qvn\",\"qvo\",\"qvp\",\"qvs\",\"qvw\",\"qvy\",\"qvz\",\"qwa\",\"qwc\",\"qwe\",\"qwh\",\"qwm\",\"qws\",\"qwt\",\"qxa\",\"qxc\",\"qxh\",\"qxl\",\"qxn\",\"qxo\",\"qxp\",\"qxq\",\"qxr\",\"qxs\",\"qxt\",\"qxu\",\"qxw\",\"qya\",\"qyp\",\"raa\",\"rab\",\"rac\",\"rad\",\"raf\",\"rag\",\"rah\",\"rai\",\"raj\",\"rak\",\"ral\",\"ram\",\"ran\",\"rao\",\"rap\",\"raq\",\"rar\",\"ras\",\"rat\",\"rau\",\"rav\",\"raw\",\"rax\",\"ray\",\"raz\",\"rbb\",\"rbk\",\"rbl\",\"rbp\",\"rcf\",\"rdb\",\"rea\",\"reb\",\"ree\",\"reg\",\"rei\",\"rej\",\"rel\",\"rem\",\"ren\",\"rer\",\"res\",\"ret\",\"rey\",\"rga\",\"rge\",\"rgk\",\"rgn\",\"rgr\",\"rgs\",\"rgu\",\"rhg\",\"rhp\",\"ria\",\"rie\",\"rif\",\"ril\",\"rim\",\"rin\",\"rir\",\"rit\",\"riu\",\"rjg\",\"rji\",\"rjs\",\"rka\",\"rkb\",\"rkh\",\"rki\",\"rkm\",\"rkt\",\"rkw\",\"rma\",\"rmb\",\"rmc\",\"rmd\",\"rme\",\"rmf\",\"rmg\",\"rmh\",\"rmi\",\"rmk\",\"rml\",\"rmm\",\"rmn\",\"rmo\",\"rmp\",\"rmq\",\"rmr\",\"rms\",\"rmt\",\"rmu\",\"rmv\",\"rmw\",\"rmx\",\"rmy\",\"rmz\",\"rna\",\"rnd\",\"rng\",\"rnl\",\"rnn\",\"rnp\",\"rnr\",\"rnw\",\"roa\",\"rob\",\"roc\",\"rod\",\"roe\",\"rof\",\"rog\",\"rol\",\"rom\",\"roo\",\"rop\",\"ror\",\"rou\",\"row\",\"rpn\",\"rpt\",\"rri\",\"rro\",\"rrt\",\"rsb\",\"rsi\",\"rsl\",\"rsm\",\"rtc\",\"rth\",\"rtm\",\"rts\",\"rtw\",\"rub\",\"ruc\",\"rue\",\"ruf\",\"rug\",\"ruh\",\"rui\",\"ruk\",\"ruo\",\"rup\",\"ruq\",\"rut\",\"ruu\",\"ruy\",\"ruz\",\"rwa\",\"rwk\",\"rwm\",\"rwo\",\"rwr\",\"rxd\",\"rxw\",\"ryn\",\"rys\",\"ryu\",\"rzh\",\"saa\",\"sab\",\"sac\",\"sad\",\"sae\",\"saf\",\"sah\",\"sai\",\"saj\",\"sak\",\"sal\",\"sam\",\"sao\",\"sap\",\"saq\",\"sar\",\"sas\",\"sat\",\"sau\",\"sav\",\"saw\",\"sax\",\"say\",\"saz\",\"sba\",\"sbb\",\"sbc\",\"sbd\",\"sbe\",\"sbf\",\"sbg\",\"sbh\",\"sbi\",\"sbj\",\"sbk\",\"sbl\",\"sbm\",\"sbn\",\"sbo\",\"sbp\",\"sbq\",\"sbr\",\"sbs\",\"sbt\",\"sbu\",\"sbv\",\"sbw\",\"sbx\",\"sby\",\"sbz\",\"sca\",\"scb\",\"sce\",\"scf\",\"scg\",\"sch\",\"sci\",\"sck\",\"scl\",\"scn\",\"sco\",\"scp\",\"scq\",\"scs\",\"scu\",\"scv\",\"scw\",\"scx\",\"sda\",\"sdb\",\"sdc\",\"sde\",\"sdf\",\"sdg\",\"sdh\",\"sdj\",\"sdk\",\"sdl\",\"sdm\",\"sdn\",\"sdo\",\"sdp\",\"sdr\",\"sds\",\"sdt\",\"sdu\",\"sdv\",\"sdx\",\"sdz\",\"sea\",\"seb\",\"sec\",\"sed\",\"see\",\"sef\",\"seg\",\"seh\",\"sei\",\"sej\",\"sek\",\"sel\",\"sem\",\"sen\",\"seo\",\"sep\",\"seq\",\"ser\",\"ses\",\"set\",\"seu\",\"sev\",\"sew\",\"sey\",\"sez\",\"sfb\",\"sfe\",\"sfm\",\"sfs\",\"sfw\",\"sga\",\"sgb\",\"sgc\",\"sgd\",\"sge\",\"sgg\",\"sgh\",\"sgi\",\"sgj\",\"sgk\",\"sgl\",\"sgm\",\"sgn\",\"sgo\",\"sgp\",\"sgr\",\"sgs\",\"sgt\",\"sgu\",\"sgw\",\"sgx\",\"sgy\",\"sgz\",\"sha\",\"shb\",\"shc\",\"shd\",\"she\",\"shg\",\"shh\",\"shi\",\"shj\",\"shk\",\"shl\",\"shm\",\"shn\",\"sho\",\"shp\",\"shq\",\"shr\",\"shs\",\"sht\",\"shu\",\"shv\",\"shw\",\"shx\",\"shy\",\"shz\",\"sia\",\"sib\",\"sid\",\"sie\",\"sif\",\"sig\",\"sih\",\"sii\",\"sij\",\"sik\",\"sil\",\"sim\",\"sio\",\"sip\",\"siq\",\"sir\",\"sis\",\"sit\",\"siu\",\"siv\",\"siw\",\"six\",\"siy\",\"siz\",\"sja\",\"sjb\",\"sjd\",\"sje\",\"sjg\",\"sjk\",\"sjl\",\"sjm\",\"sjn\",\"sjo\",\"sjp\",\"sjr\",\"sjs\",\"sjt\",\"sju\",\"sjw\",\"ska\",\"skb\",\"skc\",\"skd\",\"ske\",\"skf\",\"skg\",\"skh\",\"ski\",\"skj\",\"skk\",\"skm\",\"skn\",\"sko\",\"skp\",\"skq\",\"skr\",\"sks\",\"skt\",\"sku\",\"skv\",\"skw\",\"skx\",\"sky\",\"skz\",\"sla\",\"slc\",\"sld\",\"sle\",\"slf\",\"slg\",\"slh\",\"sli\",\"slj\",\"sll\",\"slm\",\"sln\",\"slp\",\"slq\",\"slr\",\"sls\",\"slt\",\"slu\",\"slw\",\"slx\",\"sly\",\"slz\",\"sma\",\"smb\",\"smc\",\"smd\",\"smf\",\"smg\",\"smh\",\"smi\",\"smj\",\"smk\",\"sml\",\"smm\",\"smn\",\"smp\",\"smq\",\"smr\",\"sms\",\"smt\",\"smu\",\"smv\",\"smw\",\"smx\",\"smy\",\"smz\",\"snb\",\"snc\",\"sne\",\"snf\",\"sng\",\"snh\",\"sni\",\"snj\",\"snk\",\"snl\",\"snm\",\"snn\",\"sno\",\"snp\",\"snq\",\"snr\",\"sns\",\"snu\",\"snv\",\"snw\",\"snx\",\"sny\",\"snz\",\"soa\",\"sob\",\"soc\",\"sod\",\"soe\",\"sog\",\"soh\",\"soi\",\"soj\",\"sok\",\"sol\",\"son\",\"soo\",\"sop\",\"soq\",\"sor\",\"sos\",\"sou\",\"sov\",\"sow\",\"sox\",\"soy\",\"soz\",\"spb\",\"spc\",\"spd\",\"spe\",\"spg\",\"spi\",\"spk\",\"spl\",\"spm\",\"spn\",\"spo\",\"spp\",\"spq\",\"spr\",\"sps\",\"spt\",\"spu\",\"spv\",\"spx\",\"spy\",\"sqa\",\"sqh\",\"sqj\",\"sqk\",\"sqm\",\"sqn\",\"sqo\",\"sqq\",\"sqr\",\"sqs\",\"sqt\",\"squ\",\"sra\",\"srb\",\"src\",\"sre\",\"srf\",\"srg\",\"srh\",\"sri\",\"srk\",\"srl\",\"srm\",\"srn\",\"sro\",\"srq\",\"srr\",\"srs\",\"srt\",\"sru\",\"srv\",\"srw\",\"srx\",\"sry\",\"srz\",\"ssa\",\"ssb\",\"ssc\",\"ssd\",\"sse\",\"ssf\",\"ssg\",\"ssh\",\"ssi\",\"ssj\",\"ssk\",\"ssl\",\"ssm\",\"ssn\",\"sso\",\"ssp\",\"ssq\",\"ssr\",\"sss\",\"sst\",\"ssu\",\"ssv\",\"ssx\",\"ssy\",\"ssz\",\"sta\",\"stb\",\"std\",\"ste\",\"stf\",\"stg\",\"sth\",\"sti\",\"stj\",\"stk\",\"stl\",\"stm\",\"stn\",\"sto\",\"stp\",\"stq\",\"str\",\"sts\",\"stt\",\"stu\",\"stv\",\"stw\",\"sty\",\"sua\",\"sub\",\"suc\",\"sue\",\"sug\",\"sui\",\"suj\",\"suk\",\"sul\",\"sum\",\"suq\",\"sur\",\"sus\",\"sut\",\"suv\",\"suw\",\"sux\",\"suy\",\"suz\",\"sva\",\"svb\",\"svc\",\"sve\",\"svk\",\"svm\",\"svr\",\"svs\",\"svx\",\"swb\",\"swc\",\"swf\",\"swg\",\"swh\",\"swi\",\"swj\",\"swk\",\"swl\",\"swm\",\"swn\",\"swo\",\"swp\",\"swq\",\"swr\",\"sws\",\"swt\",\"swu\",\"swv\",\"sww\",\"swx\",\"swy\",\"sxb\",\"sxc\",\"sxe\",\"sxg\",\"sxk\",\"sxl\",\"sxm\",\"sxn\",\"sxo\",\"sxr\",\"sxs\",\"sxu\",\"sxw\",\"sya\",\"syb\",\"syc\",\"syd\",\"syi\",\"syk\",\"syl\",\"sym\",\"syn\",\"syo\",\"syr\",\"sys\",\"syw\",\"syx\",\"syy\",\"sza\",\"szb\",\"szc\",\"szd\",\"sze\",\"szg\",\"szl\",\"szn\",\"szp\",\"szv\",\"szw\",\"taa\",\"tab\",\"tac\",\"tad\",\"tae\",\"taf\",\"tag\",\"tai\",\"taj\",\"tak\",\"tal\",\"tan\",\"tao\",\"tap\",\"taq\",\"tar\",\"tas\",\"tau\",\"tav\",\"taw\",\"tax\",\"tay\",\"taz\",\"tba\",\"tbb\",\"tbc\",\"tbd\",\"tbe\",\"tbf\",\"tbg\",\"tbh\",\"tbi\",\"tbj\",\"tbk\",\"tbl\",\"tbm\",\"tbn\",\"tbo\",\"tbp\",\"tbq\",\"tbr\",\"tbs\",\"tbt\",\"tbu\",\"tbv\",\"tbw\",\"tbx\",\"tby\",\"tbz\",\"tca\",\"tcb\",\"tcc\",\"tcd\",\"tce\",\"tcf\",\"tcg\",\"tch\",\"tci\",\"tck\",\"tcl\",\"tcm\",\"tcn\",\"tco\",\"tcp\",\"tcq\",\"tcs\",\"tct\",\"tcu\",\"tcw\",\"tcx\",\"tcy\",\"tcz\",\"tda\",\"tdb\",\"tdc\",\"tdd\",\"tde\",\"tdf\",\"tdg\",\"tdh\",\"tdi\",\"tdj\",\"tdk\",\"tdl\",\"tdm\",\"tdn\",\"tdo\",\"tdq\",\"tdr\",\"tds\",\"tdt\",\"tdu\",\"tdv\",\"tdx\",\"tdy\",\"tea\",\"teb\",\"tec\",\"ted\",\"tee\",\"tef\",\"teg\",\"teh\",\"tei\",\"tek\",\"tem\",\"ten\",\"teo\",\"tep\",\"teq\",\"ter\",\"tes\",\"tet\",\"teu\",\"tev\",\"tew\",\"tex\",\"tey\",\"tfi\",\"tfn\",\"tfo\",\"tfr\",\"tft\",\"tga\",\"tgb\",\"tgc\",\"tgd\",\"tge\",\"tgf\",\"tgg\",\"tgh\",\"tgi\",\"tgj\",\"tgn\",\"tgo\",\"tgp\",\"tgq\",\"tgr\",\"tgs\",\"tgt\",\"tgu\",\"tgv\",\"tgw\",\"tgx\",\"tgy\",\"tgz\",\"thc\",\"thd\",\"the\",\"thf\",\"thh\",\"thi\",\"thk\",\"thl\",\"thm\",\"thn\",\"thp\",\"thq\",\"thr\",\"ths\",\"tht\",\"thu\",\"thv\",\"thw\",\"thx\",\"thy\",\"thz\",\"tia\",\"tic\",\"tid\",\"tie\",\"tif\",\"tig\",\"tih\",\"tii\",\"tij\",\"tik\",\"til\",\"tim\",\"tin\",\"tio\",\"tip\",\"tiq\",\"tis\",\"tit\",\"tiu\",\"tiv\",\"tiw\",\"tix\",\"tiy\",\"tiz\",\"tja\",\"tjg\",\"tji\",\"tjl\",\"tjm\",\"tjn\",\"tjo\",\"tjs\",\"tju\",\"tjw\",\"tka\",\"tkb\",\"tkd\",\"tke\",\"tkf\",\"tkg\",\"tkk\",\"tkl\",\"tkm\",\"tkn\",\"tkp\",\"tkq\",\"tkr\",\"tks\",\"tkt\",\"tku\",\"tkv\",\"tkw\",\"tkx\",\"tkz\",\"tla\",\"tlb\",\"tlc\",\"tld\",\"tlf\",\"tlg\",\"tlh\",\"tli\",\"tlj\",\"tlk\",\"tll\",\"tlm\",\"tln\",\"tlo\",\"tlp\",\"tlq\",\"tlr\",\"tls\",\"tlt\",\"tlu\",\"tlv\",\"tlw\",\"tlx\",\"tly\",\"tma\",\"tmb\",\"tmc\",\"tmd\",\"tme\",\"tmf\",\"tmg\",\"tmh\",\"tmi\",\"tmj\",\"tmk\",\"tml\",\"tmm\",\"tmn\",\"tmo\",\"tmp\",\"tmq\",\"tmr\",\"tms\",\"tmt\",\"tmu\",\"tmv\",\"tmw\",\"tmy\",\"tmz\",\"tna\",\"tnb\",\"tnc\",\"tnd\",\"tne\",\"tnf\",\"tng\",\"tnh\",\"tni\",\"tnk\",\"tnl\",\"tnm\",\"tnn\",\"tno\",\"tnp\",\"tnq\",\"tnr\",\"tns\",\"tnt\",\"tnu\",\"tnv\",\"tnw\",\"tnx\",\"tny\",\"tnz\",\"tob\",\"toc\",\"tod\",\"toe\",\"tof\",\"tog\",\"toh\",\"toi\",\"toj\",\"tol\",\"tom\",\"too\",\"top\",\"toq\",\"tor\",\"tos\",\"tou\",\"tov\",\"tow\",\"tox\",\"toy\",\"toz\",\"tpa\",\"tpc\",\"tpe\",\"tpf\",\"tpg\",\"tpi\",\"tpj\",\"tpk\",\"tpl\",\"tpm\",\"tpn\",\"tpo\",\"tpp\",\"tpq\",\"tpr\",\"tpt\",\"tpu\",\"tpv\",\"tpw\",\"tpx\",\"tpy\",\"tpz\",\"tqb\",\"tql\",\"tqm\",\"tqn\",\"tqo\",\"tqp\",\"tqq\",\"tqr\",\"tqt\",\"tqu\",\"tqw\",\"tra\",\"trb\",\"trc\",\"trd\",\"tre\",\"trf\",\"trg\",\"trh\",\"tri\",\"trj\",\"trk\",\"trl\",\"trm\",\"trn\",\"tro\",\"trp\",\"trq\",\"trr\",\"trs\",\"trt\",\"tru\",\"trv\",\"trw\",\"trx\",\"try\",\"trz\",\"tsa\",\"tsb\",\"tsc\",\"tsd\",\"tse\",\"tsf\",\"tsg\",\"tsh\",\"tsi\",\"tsj\",\"tsk\",\"tsl\",\"tsm\",\"tsp\",\"tsq\",\"tsr\",\"tss\",\"tst\",\"tsu\",\"tsv\",\"tsw\",\"tsx\",\"tsy\",\"tsz\",\"tta\",\"ttb\",\"ttc\",\"ttd\",\"tte\",\"ttf\",\"ttg\",\"tth\",\"tti\",\"ttj\",\"ttk\",\"ttl\",\"ttm\",\"ttn\",\"tto\",\"ttp\",\"ttq\",\"ttr\",\"tts\",\"ttt\",\"ttu\",\"ttv\",\"ttw\",\"tty\",\"ttz\",\"tua\",\"tub\",\"tuc\",\"tud\",\"tue\",\"tuf\",\"tug\",\"tuh\",\"tui\",\"tuj\",\"tul\",\"tum\",\"tun\",\"tuo\",\"tup\",\"tuq\",\"tus\",\"tut\",\"tuu\",\"tuv\",\"tuw\",\"tux\",\"tuy\",\"tuz\",\"tva\",\"tvd\",\"tve\",\"tvk\",\"tvl\",\"tvm\",\"tvn\",\"tvo\",\"tvs\",\"tvt\",\"tvu\",\"tvw\",\"tvy\",\"twa\",\"twb\",\"twc\",\"twd\",\"twe\",\"twf\",\"twg\",\"twh\",\"twl\",\"twm\",\"twn\",\"two\",\"twp\",\"twq\",\"twr\",\"twt\",\"twu\",\"tww\",\"twx\",\"twy\",\"txa\",\"txb\",\"txc\",\"txe\",\"txg\",\"txh\",\"txi\",\"txj\",\"txm\",\"txn\",\"txo\",\"txq\",\"txr\",\"txs\",\"txt\",\"txu\",\"txx\",\"txy\",\"tya\",\"tye\",\"tyh\",\"tyi\",\"tyj\",\"tyl\",\"tyn\",\"typ\",\"tyr\",\"tys\",\"tyt\",\"tyu\",\"tyv\",\"tyx\",\"tyz\",\"tza\",\"tzh\",\"tzj\",\"tzl\",\"tzm\",\"tzn\",\"tzo\",\"tzx\",\"uam\",\"uan\",\"uar\",\"uba\",\"ubi\",\"ubl\",\"ubr\",\"ubu\",\"uby\",\"uda\",\"ude\",\"udg\",\"udi\",\"udj\",\"udl\",\"udm\",\"udu\",\"ues\",\"ufi\",\"uga\",\"ugb\",\"uge\",\"ugn\",\"ugo\",\"ugy\",\"uha\",\"uhn\",\"uis\",\"uiv\",\"uji\",\"uka\",\"ukg\",\"ukh\",\"ukl\",\"ukp\",\"ukq\",\"uks\",\"uku\",\"ukw\",\"uky\",\"ula\",\"ulb\",\"ulc\",\"ule\",\"ulf\",\"uli\",\"ulk\",\"ull\",\"ulm\",\"uln\",\"ulu\",\"ulw\",\"uma\",\"umb\",\"umc\",\"umd\",\"umg\",\"umi\",\"umm\",\"umn\",\"umo\",\"ump\",\"umr\",\"ums\",\"umu\",\"una\",\"und\",\"une\",\"ung\",\"unk\",\"unm\",\"unn\",\"unp\",\"unr\",\"unu\",\"unx\",\"unz\",\"uok\",\"upi\",\"upv\",\"ura\",\"urb\",\"urc\",\"ure\",\"urf\",\"urg\",\"urh\",\"uri\",\"urj\",\"urk\",\"url\",\"urm\",\"urn\",\"uro\",\"urp\",\"urr\",\"urt\",\"uru\",\"urv\",\"urw\",\"urx\",\"ury\",\"urz\",\"usa\",\"ush\",\"usi\",\"usk\",\"usp\",\"usu\",\"uta\",\"ute\",\"utp\",\"utr\",\"utu\",\"uum\",\"uun\",\"uur\",\"uuu\",\"uve\",\"uvh\",\"uvl\",\"uwa\",\"uya\",\"uzn\",\"uzs\",\"vaa\",\"vae\",\"vaf\",\"vag\",\"vah\",\"vai\",\"vaj\",\"val\",\"vam\",\"van\",\"vao\",\"vap\",\"var\",\"vas\",\"vau\",\"vav\",\"vay\",\"vbb\",\"vbk\",\"vec\",\"ved\",\"vel\",\"vem\",\"veo\",\"vep\",\"ver\",\"vgr\",\"vgt\",\"vic\",\"vid\",\"vif\",\"vig\",\"vil\",\"vin\",\"vis\",\"vit\",\"viv\",\"vka\",\"vki\",\"vkj\",\"vkk\",\"vkl\",\"vkm\",\"vko\",\"vkp\",\"vkt\",\"vku\",\"vlp\",\"vls\",\"vma\",\"vmb\",\"vmc\",\"vmd\",\"vme\",\"vmf\",\"vmg\",\"vmh\",\"vmi\",\"vmj\",\"vmk\",\"vml\",\"vmm\",\"vmp\",\"vmq\",\"vmr\",\"vms\",\"vmu\",\"vmv\",\"vmw\",\"vmx\",\"vmy\",\"vmz\",\"vnk\",\"vnm\",\"vnp\",\"vor\",\"vot\",\"vra\",\"vro\",\"vrs\",\"vrt\",\"vsi\",\"vsl\",\"vsv\",\"vto\",\"vum\",\"vun\",\"vut\",\"vwa\",\"waa\",\"wab\",\"wac\",\"wad\",\"wae\",\"waf\",\"wag\",\"wah\",\"wai\",\"waj\",\"wak\",\"wal\",\"wam\",\"wan\",\"wao\",\"wap\",\"waq\",\"war\",\"was\",\"wat\",\"wau\",\"wav\",\"waw\",\"wax\",\"way\",\"waz\",\"wba\",\"wbb\",\"wbe\",\"wbf\",\"wbh\",\"wbi\",\"wbj\",\"wbk\",\"wbl\",\"wbm\",\"wbp\",\"wbq\",\"wbr\",\"wbt\",\"wbv\",\"wbw\",\"wca\",\"wci\",\"wdd\",\"wdg\",\"wdj\",\"wdk\",\"wdu\",\"wdy\",\"wea\",\"wec\",\"wed\",\"weg\",\"weh\",\"wei\",\"wem\",\"wen\",\"weo\",\"wep\",\"wer\",\"wes\",\"wet\",\"weu\",\"wew\",\"wfg\",\"wga\",\"wgb\",\"wgg\",\"wgi\",\"wgo\",\"wgu\",\"wgw\",\"wgy\",\"wha\",\"whg\",\"whk\",\"whu\",\"wib\",\"wic\",\"wie\",\"wif\",\"wig\",\"wih\",\"wii\",\"wij\",\"wik\",\"wil\",\"wim\",\"win\",\"wir\",\"wit\",\"wiu\",\"wiv\",\"wiw\",\"wiy\",\"wja\",\"wji\",\"wka\",\"wkb\",\"wkd\",\"wkl\",\"wku\",\"wkw\",\"wky\",\"wla\",\"wlc\",\"wle\",\"wlg\",\"wli\",\"wlk\",\"wll\",\"wlm\",\"wlo\",\"wlr\",\"wls\",\"wlu\",\"wlv\",\"wlw\",\"wlx\",\"wly\",\"wma\",\"wmb\",\"wmc\",\"wmd\",\"wme\",\"wmh\",\"wmi\",\"wmm\",\"wmn\",\"wmo\",\"wms\",\"wmt\",\"wmw\",\"wmx\",\"wnb\",\"wnc\",\"wnd\",\"wne\",\"wng\",\"wni\",\"wnk\",\"wnm\",\"wnn\",\"wno\",\"wnp\",\"wnu\",\"wnw\",\"wny\",\"woa\",\"wob\",\"woc\",\"wod\",\"woe\",\"wof\",\"wog\",\"woi\",\"wok\",\"wom\",\"won\",\"woo\",\"wor\",\"wos\",\"wow\",\"woy\",\"wpc\",\"wra\",\"wrb\",\"wrd\",\"wrg\",\"wrh\",\"wri\",\"wrk\",\"wrl\",\"wrm\",\"wrn\",\"wro\",\"wrp\",\"wrr\",\"wrs\",\"wru\",\"wrv\",\"wrw\",\"wrx\",\"wry\",\"wrz\",\"wsa\",\"wsg\",\"wsi\",\"wsk\",\"wsr\",\"wss\",\"wsu\",\"wsv\",\"wtf\",\"wth\",\"wti\",\"wtk\",\"wtm\",\"wtw\",\"wua\",\"wub\",\"wud\",\"wuh\",\"wul\",\"wum\",\"wun\",\"wur\",\"wut\",\"wuu\",\"wuv\",\"wux\",\"wuy\",\"wwa\",\"wwb\",\"wwo\",\"wwr\",\"www\",\"wxa\",\"wxw\",\"wya\",\"wyb\",\"wyi\",\"wym\",\"wyr\",\"wyy\",\"xaa\",\"xab\",\"xac\",\"xad\",\"xae\",\"xag\",\"xai\",\"xaj\",\"xak\",\"xal\",\"xam\",\"xan\",\"xao\",\"xap\",\"xaq\",\"xar\",\"xas\",\"xat\",\"xau\",\"xav\",\"xaw\",\"xay\",\"xba\",\"xbb\",\"xbc\",\"xbd\",\"xbe\",\"xbg\",\"xbi\",\"xbj\",\"xbm\",\"xbn\",\"xbo\",\"xbp\",\"xbr\",\"xbw\",\"xbx\",\"xby\",\"xcb\",\"xcc\",\"xce\",\"xcg\",\"xch\",\"xcl\",\"xcm\",\"xcn\",\"xco\",\"xcr\",\"xct\",\"xcu\",\"xcv\",\"xcw\",\"xcy\",\"xda\",\"xdc\",\"xdk\",\"xdm\",\"xdy\",\"xeb\",\"xed\",\"xeg\",\"xel\",\"xem\",\"xep\",\"xer\",\"xes\",\"xet\",\"xeu\",\"xfa\",\"xga\",\"xgb\",\"xgd\",\"xgf\",\"xgg\",\"xgi\",\"xgl\",\"xgm\",\"xgn\",\"xgr\",\"xgu\",\"xgw\",\"xha\",\"xhc\",\"xhd\",\"xhe\",\"xhr\",\"xht\",\"xhu\",\"xhv\",\"xia\",\"xib\",\"xii\",\"xil\",\"xin\",\"xip\",\"xir\",\"xis\",\"xiv\",\"xiy\",\"xjb\",\"xjt\",\"xka\",\"xkb\",\"xkc\",\"xkd\",\"xke\",\"xkf\",\"xkg\",\"xkh\",\"xki\",\"xkj\",\"xkk\",\"xkl\",\"xkn\",\"xko\",\"xkp\",\"xkq\",\"xkr\",\"xks\",\"xkt\",\"xku\",\"xkv\",\"xkw\",\"xkx\",\"xky\",\"xkz\",\"xla\",\"xlb\",\"xlc\",\"xld\",\"xle\",\"xlg\",\"xli\",\"xln\",\"xlo\",\"xlp\",\"xls\",\"xlu\",\"xly\",\"xma\",\"xmb\",\"xmc\",\"xmd\",\"xme\",\"xmf\",\"xmg\",\"xmh\",\"xmj\",\"xmk\",\"xml\",\"xmm\",\"xmn\",\"xmo\",\"xmp\",\"xmq\",\"xmr\",\"xms\",\"xmt\",\"xmu\",\"xmv\",\"xmw\",\"xmx\",\"xmy\",\"xmz\",\"xna\",\"xnb\",\"xnd\",\"xng\",\"xnh\",\"xni\",\"xnk\",\"xnn\",\"xno\",\"xnr\",\"xns\",\"xnt\",\"xnu\",\"xny\",\"xnz\",\"xoc\",\"xod\",\"xog\",\"xoi\",\"xok\",\"xom\",\"xon\",\"xoo\",\"xop\",\"xor\",\"xow\",\"xpa\",\"xpc\",\"xpe\",\"xpg\",\"xpi\",\"xpj\",\"xpk\",\"xpm\",\"xpn\",\"xpo\",\"xpp\",\"xpq\",\"xpr\",\"xps\",\"xpt\",\"xpu\",\"xpy\",\"xqa\",\"xqt\",\"xra\",\"xrb\",\"xrd\",\"xre\",\"xrg\",\"xri\",\"xrm\",\"xrn\",\"xrq\",\"xrr\",\"xrt\",\"xru\",\"xrw\",\"xsa\",\"xsb\",\"xsc\",\"xsd\",\"xse\",\"xsh\",\"xsi\",\"xsj\",\"xsl\",\"xsm\",\"xsn\",\"xso\",\"xsp\",\"xsq\",\"xsr\",\"xss\",\"xsu\",\"xsv\",\"xsy\",\"xta\",\"xtb\",\"xtc\",\"xtd\",\"xte\",\"xtg\",\"xth\",\"xti\",\"xtj\",\"xtl\",\"xtm\",\"xtn\",\"xto\",\"xtp\",\"xtq\",\"xtr\",\"xts\",\"xtt\",\"xtu\",\"xtv\",\"xtw\",\"xty\",\"xtz\",\"xua\",\"xub\",\"xud\",\"xug\",\"xuj\",\"xul\",\"xum\",\"xun\",\"xuo\",\"xup\",\"xur\",\"xut\",\"xuu\",\"xve\",\"xvi\",\"xvn\",\"xvo\",\"xvs\",\"xwa\",\"xwc\",\"xwd\",\"xwe\",\"xwg\",\"xwj\",\"xwk\",\"xwl\",\"xwo\",\"xwr\",\"xwt\",\"xww\",\"xxb\",\"xxk\",\"xxm\",\"xxr\",\"xxt\",\"xya\",\"xyb\",\"xyj\",\"xyk\",\"xyl\",\"xyt\",\"xyy\",\"xzh\",\"xzm\",\"xzp\",\"yaa\",\"yab\",\"yac\",\"yad\",\"yae\",\"yaf\",\"yag\",\"yah\",\"yai\",\"yaj\",\"yak\",\"yal\",\"yam\",\"yan\",\"yao\",\"yap\",\"yaq\",\"yar\",\"yas\",\"yat\",\"yau\",\"yav\",\"yaw\",\"yax\",\"yay\",\"yaz\",\"yba\",\"ybb\",\"ybd\",\"ybe\",\"ybh\",\"ybi\",\"ybj\",\"ybk\",\"ybl\",\"ybm\",\"ybn\",\"ybo\",\"ybx\",\"yby\",\"ych\",\"ycl\",\"ycn\",\"ycp\",\"yda\",\"ydd\",\"yde\",\"ydg\",\"ydk\",\"yds\",\"yea\",\"yec\",\"yee\",\"yei\",\"yej\",\"yel\",\"yen\",\"yer\",\"yes\",\"yet\",\"yeu\",\"yev\",\"yey\",\"yga\",\"ygi\",\"ygl\",\"ygm\",\"ygp\",\"ygr\",\"ygs\",\"ygu\",\"ygw\",\"yha\",\"yhd\",\"yhl\",\"yhs\",\"yia\",\"yif\",\"yig\",\"yih\",\"yii\",\"yij\",\"yik\",\"yil\",\"yim\",\"yin\",\"yip\",\"yiq\",\"yir\",\"yis\",\"yit\",\"yiu\",\"yiv\",\"yix\",\"yiy\",\"yiz\",\"yka\",\"ykg\",\"yki\",\"ykk\",\"ykl\",\"ykm\",\"ykn\",\"yko\",\"ykr\",\"ykt\",\"yku\",\"yky\",\"yla\",\"ylb\",\"yle\",\"ylg\",\"yli\",\"yll\",\"ylm\",\"yln\",\"ylo\",\"ylr\",\"ylu\",\"yly\",\"yma\",\"ymb\",\"ymc\",\"ymd\",\"yme\",\"ymg\",\"ymh\",\"ymi\",\"ymk\",\"yml\",\"ymm\",\"ymn\",\"ymo\",\"ymp\",\"ymq\",\"ymr\",\"yms\",\"ymt\",\"ymx\",\"ymz\",\"yna\",\"ynd\",\"yne\",\"yng\",\"ynh\",\"ynk\",\"ynl\",\"ynn\",\"yno\",\"ynq\",\"yns\",\"ynu\",\"yob\",\"yog\",\"yoi\",\"yok\",\"yol\",\"yom\",\"yon\",\"yos\",\"yot\",\"yox\",\"yoy\",\"ypa\",\"ypb\",\"ypg\",\"yph\",\"ypk\",\"ypm\",\"ypn\",\"ypo\",\"ypp\",\"ypz\",\"yra\",\"yrb\",\"yre\",\"yri\",\"yrk\",\"yrl\",\"yrm\",\"yrn\",\"yro\",\"yrs\",\"yrw\",\"yry\",\"ysc\",\"ysd\",\"ysg\",\"ysl\",\"ysn\",\"yso\",\"ysp\",\"ysr\",\"yss\",\"ysy\",\"yta\",\"ytl\",\"ytp\",\"ytw\",\"yty\",\"yua\",\"yub\",\"yuc\",\"yud\",\"yue\",\"yuf\",\"yug\",\"yui\",\"yuj\",\"yuk\",\"yul\",\"yum\",\"yun\",\"yup\",\"yuq\",\"yur\",\"yut\",\"yuu\",\"yuw\",\"yux\",\"yuy\",\"yuz\",\"yva\",\"yvt\",\"ywa\",\"ywg\",\"ywl\",\"ywn\",\"ywq\",\"ywr\",\"ywt\",\"ywu\",\"yww\",\"yxa\",\"yxg\",\"yxl\",\"yxm\",\"yxu\",\"yxy\",\"yyr\",\"yyu\",\"yyz\",\"yzg\",\"yzk\",\"zaa\",\"zab\",\"zac\",\"zad\",\"zae\",\"zaf\",\"zag\",\"zah\",\"zai\",\"zaj\",\"zak\",\"zal\",\"zam\",\"zao\",\"zap\",\"zaq\",\"zar\",\"zas\",\"zat\",\"zau\",\"zav\",\"zaw\",\"zax\",\"zay\",\"zaz\",\"zbc\",\"zbe\",\"zbl\",\"zbt\",\"zbw\",\"zca\",\"zch\",\"zdj\",\"zea\",\"zeg\",\"zeh\",\"zen\",\"zga\",\"zgb\",\"zgh\",\"zgm\",\"zgn\",\"zgr\",\"zhb\",\"zhd\",\"zhi\",\"zhn\",\"zhw\",\"zhx\",\"zia\",\"zib\",\"zik\",\"zil\",\"zim\",\"zin\",\"zir\",\"ziw\",\"ziz\",\"zka\",\"zkb\",\"zkd\",\"zkg\",\"zkh\",\"zkk\",\"zkn\",\"zko\",\"zkp\",\"zkr\",\"zkt\",\"zku\",\"zkv\",\"zkz\",\"zle\",\"zlj\",\"zlm\",\"zln\",\"zlq\",\"zls\",\"zlw\",\"zma\",\"zmb\",\"zmc\",\"zmd\",\"zme\",\"zmf\",\"zmg\",\"zmh\",\"zmi\",\"zmj\",\"zmk\",\"zml\",\"zmm\",\"zmn\",\"zmo\",\"zmp\",\"zmq\",\"zmr\",\"zms\",\"zmt\",\"zmu\",\"zmv\",\"zmw\",\"zmx\",\"zmy\",\"zmz\",\"zna\",\"znd\",\"zne\",\"zng\",\"znk\",\"zns\",\"zoc\",\"zoh\",\"zom\",\"zoo\",\"zoq\",\"zor\",\"zos\",\"zpa\",\"zpb\",\"zpc\",\"zpd\",\"zpe\",\"zpf\",\"zpg\",\"zph\",\"zpi\",\"zpj\",\"zpk\",\"zpl\",\"zpm\",\"zpn\",\"zpo\",\"zpp\",\"zpq\",\"zpr\",\"zps\",\"zpt\",\"zpu\",\"zpv\",\"zpw\",\"zpx\",\"zpy\",\"zpz\",\"zqe\",\"zra\",\"zrg\",\"zrn\",\"zro\",\"zrp\",\"zrs\",\"zsa\",\"zsk\",\"zsl\",\"zsm\",\"zsr\",\"zsu\",\"zte\",\"ztg\",\"ztl\",\"ztm\",\"ztn\",\"ztp\",\"ztq\",\"zts\",\"ztt\",\"ztu\",\"ztx\",\"zty\",\"zua\",\"zuh\",\"zum\",\"zun\",\"zuy\",\"zwa\",\"zxx\",\"zyb\",\"zyg\",\"zyj\",\"zyn\",\"zyp\",\"zza\",\"zzj\"],\nid:\"valid-lang\"}]},{id:\"image-alt\",selector:\"img, [role='img']\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-alt\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\",\"role-presentation\",\"role-none\"],none:[]},{id:\"image-redundant-alt\",selector:'button, [role=\"button\"], a[href], p, li, td, th',tags:[\"cat.text-alternatives\",\"best-practice\"],all:[],any:[],none:[\"duplicate-img-label\"]},{id:\"input-image-alt\",selector:'input[type=\"image\"]',tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-alt\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\"],none:[]},{id:\"label-title-only\",selector:\"input:not([type='hidden']):not([type='image']):not([type='button']):not([type='submit']):not([type='reset']), select, textarea\",enabled:!1,tags:[\"cat.forms\",\"best-practice\"],all:[],any:[],none:[\"title-only\"]},{id:\"label\",selector:\"input:not([type='hidden']):not([type='image']):not([type='button']):not([type='submit']):not([type='reset']), select, textarea\",tags:[\"cat.forms\",\"wcag2a\",\"wcag332\",\"wcag131\",\"section508\",\"section508.22.n\"],all:[],any:[\"aria-label\",\"aria-labelledby\",\"implicit-label\",\"explicit-label\",\"non-empty-title\"],none:[\"help-same-as-label\",\"multiple-label\"]},{id:\"layout-table\",selector:\"table\",matches:function(a){return!axe.commons.table.isDataTable(a)},tags:[\"cat.semantics\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"has-th\",\"has-caption\",\"has-summary\"]},{id:\"link-in-text-block\",selector:\"a[href]:not([role]), *[role=link]\",matches:function(a){return!!axe.commons.text.sanitize(a.textContent)&&!!axe.commons.dom.isVisible(a,!1)&&axe.commons.dom.isInTextBlock(a)},excludeHidden:!1,enabled:!1,tags:[\"cat.color\",\"experimental\",\"wcag2a\",\"wcag141\"],all:[\"link-in-text-block\"],any:[],none:[]},{id:\"link-name\",selector:'a[href]:not([role=\"button\"]), [role=link][href]',tags:[\"cat.name-role-value\",\"wcag2a\",\"wcag111\",\"wcag412\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-visible-text\",\"aria-label\",\"aria-labelledby\",\"role-presentation\",\"role-none\"],none:[\"focusable-no-name\"]},{id:\"list\",selector:\"ul:not([role]), ol:not([role])\",tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"only-listitems\"]},{id:\"listitem\",selector:\"li:not([role])\",tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[\"listitem\"],none:[]},{id:\"marquee\",selector:\"marquee\",excludeHidden:!1,tags:[\"cat.parsing\",\"wcag2a\",\"wcag222\"],all:[],any:[],none:[\"is-on-screen\"]},{id:\"meta-refresh\",selector:'meta[http-equiv=\"refresh\"]',excludeHidden:!1,tags:[\"cat.time\",\"wcag2a\",\"wcag2aaa\",\"wcag221\",\"wcag224\",\"wcag325\"],all:[],any:[\"meta-refresh\"],none:[]},{id:\"meta-viewport-large\",selector:'meta[name=\"viewport\"]',excludeHidden:!1,tags:[\"cat.sensory-and-visual-cues\",\"best-practice\"],all:[],any:[{options:{scaleMinimum:5,lowerBound:2},id:\"meta-viewport-large\"}],none:[]},{id:\"meta-viewport\",selector:'meta[name=\"viewport\"]',excludeHidden:!1,tags:[\"cat.sensory-and-visual-cues\",\"wcag2aa\",\"wcag144\"],all:[],any:[{options:{scaleMinimum:2},id:\"meta-viewport\"}],none:[]},{id:\"object-alt\",selector:\"object\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-visible-text\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\"],none:[]},{id:\"p-as-heading\",selector:\"p\",matches:function(a){var b=Array.from(a.parentNode.childNodes),c=a.textContent.trim();return!(0===c.length||(c.match(/[.!?:;](?![.!?:;])/g)||[]).length>=2)&&0!==b.slice(b.indexOf(a)+1).filter(function(a){return\"P\"===a.nodeName.toUpperCase()&&\"\"!==a.textContent.trim()}).length},tags:[\"cat.semantics\",\"wcag2a\",\"wcag131\",\"experimental\"],all:[{options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]},id:\"p-as-heading\"}],any:[],none:[]},{id:\"radiogroup\",selector:\"input[type=radio][name]\",tags:[\"cat.forms\",\"best-practice\"],all:[],any:[\"group-labelledby\",\"fieldset\"],none:[]},{id:\"region\",selector:\"html\",pageLevel:!0,enabled:!1,tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"region\"],none:[]},{id:\"scope-attr-valid\",selector:\"td[scope], th[scope]\",enabled:!0,tags:[\"cat.tables\",\"best-practice\"],all:[\"html5-scope\",\"scope-value\"],any:[],none:[]},{id:\"server-side-image-map\",selector:\"img[ismap]\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag211\",\"section508\",\"section508.22.f\"],all:[],any:[],none:[\"exists\"]},{id:\"skip-link\",selector:\"a[href]\",pageLevel:!0,enabled:!1,tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"skip-link\"],none:[]},{id:\"tabindex\",selector:\"[tabindex]\",tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"tabindex\"],none:[]},{id:\"table-duplicate-name\",selector:\"table\",tags:[\"cat.tables\",\"best-practice\"],all:[],any:[],none:[\"same-caption-summary\"]},{id:\"table-fake-caption\",selector:\"table\",matches:function(a){return axe.commons.table.isDataTable(a)},tags:[\"cat.tables\",\"experimental\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"caption-faked\"],any:[],none:[]},{id:\"td-has-header\",selector:\"table\",matches:function(a){if(axe.commons.table.isDataTable(a)){var b=axe.commons.table.toArray(a);return b.length>=3&&b[0].length>=3&&b[1].length>=3&&b[2].length>=3}return!1},tags:[\"cat.tables\",\"experimental\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"td-has-header\"],any:[],none:[]},{id:\"td-headers-attr\",selector:\"table\",tags:[\"cat.tables\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"td-headers-attr\"],any:[],none:[]},{id:\"th-has-data-cells\",selector:\"table\",matches:function(a){return axe.commons.table.isDataTable(a)},tags:[\"cat.tables\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"th-has-data-cells\"],any:[],none:[]},{id:\"valid-lang\",selector:\"[lang]:not(html), [xml\\\\:lang]:not(html)\",tags:[\"cat.language\",\"wcag2aa\",\"wcag312\"],all:[],any:[],none:[{\noptions:[\"aa\",\"ab\",\"ae\",\"af\",\"ak\",\"am\",\"an\",\"ar\",\"as\",\"av\",\"ay\",\"az\",\"ba\",\"be\",\"bg\",\"bh\",\"bi\",\"bm\",\"bn\",\"bo\",\"br\",\"bs\",\"ca\",\"ce\",\"ch\",\"co\",\"cr\",\"cs\",\"cu\",\"cv\",\"cy\",\"da\",\"de\",\"dv\",\"dz\",\"ee\",\"el\",\"en\",\"eo\",\"es\",\"et\",\"eu\",\"fa\",\"ff\",\"fi\",\"fj\",\"fo\",\"fr\",\"fy\",\"ga\",\"gd\",\"gl\",\"gn\",\"gu\",\"gv\",\"ha\",\"he\",\"hi\",\"ho\",\"hr\",\"ht\",\"hu\",\"hy\",\"hz\",\"ia\",\"id\",\"ie\",\"ig\",\"ii\",\"ik\",\"in\",\"io\",\"is\",\"it\",\"iu\",\"iw\",\"ja\",\"ji\",\"jv\",\"jw\",\"ka\",\"kg\",\"ki\",\"kj\",\"kk\",\"kl\",\"km\",\"kn\",\"ko\",\"kr\",\"ks\",\"ku\",\"kv\",\"kw\",\"ky\",\"la\",\"lb\",\"lg\",\"li\",\"ln\",\"lo\",\"lt\",\"lu\",\"lv\",\"mg\",\"mh\",\"mi\",\"mk\",\"ml\",\"mn\",\"mo\",\"mr\",\"ms\",\"mt\",\"my\",\"na\",\"nb\",\"nd\",\"ne\",\"ng\",\"nl\",\"nn\",\"no\",\"nr\",\"nv\",\"ny\",\"oc\",\"oj\",\"om\",\"or\",\"os\",\"pa\",\"pi\",\"pl\",\"ps\",\"pt\",\"qu\",\"rm\",\"rn\",\"ro\",\"ru\",\"rw\",\"sa\",\"sc\",\"sd\",\"se\",\"sg\",\"sh\",\"si\",\"sk\",\"sl\",\"sm\",\"sn\",\"so\",\"sq\",\"sr\",\"ss\",\"st\",\"su\",\"sv\",\"sw\",\"ta\",\"te\",\"tg\",\"th\",\"ti\",\"tk\",\"tl\",\"tn\",\"to\",\"tr\",\"ts\",\"tt\",\"tw\",\"ty\",\"ug\",\"uk\",\"ur\",\"uz\",\"ve\",\"vi\",\"vo\",\"wa\",\"wo\",\"xh\",\"yi\",\"yo\",\"za\",\"zh\",\"zu\",\"aaa\",\"aab\",\"aac\",\"aad\",\"aae\",\"aaf\",\"aag\",\"aah\",\"aai\",\"aak\",\"aal\",\"aam\",\"aan\",\"aao\",\"aap\",\"aaq\",\"aas\",\"aat\",\"aau\",\"aav\",\"aaw\",\"aax\",\"aaz\",\"aba\",\"abb\",\"abc\",\"abd\",\"abe\",\"abf\",\"abg\",\"abh\",\"abi\",\"abj\",\"abl\",\"abm\",\"abn\",\"abo\",\"abp\",\"abq\",\"abr\",\"abs\",\"abt\",\"abu\",\"abv\",\"abw\",\"abx\",\"aby\",\"abz\",\"aca\",\"acb\",\"acd\",\"ace\",\"acf\",\"ach\",\"aci\",\"ack\",\"acl\",\"acm\",\"acn\",\"acp\",\"acq\",\"acr\",\"acs\",\"act\",\"acu\",\"acv\",\"acw\",\"acx\",\"acy\",\"acz\",\"ada\",\"adb\",\"add\",\"ade\",\"adf\",\"adg\",\"adh\",\"adi\",\"adj\",\"adl\",\"adn\",\"ado\",\"adp\",\"adq\",\"adr\",\"ads\",\"adt\",\"adu\",\"adw\",\"adx\",\"ady\",\"adz\",\"aea\",\"aeb\",\"aec\",\"aed\",\"aee\",\"aek\",\"ael\",\"aem\",\"aen\",\"aeq\",\"aer\",\"aes\",\"aeu\",\"aew\",\"aey\",\"aez\",\"afa\",\"afb\",\"afd\",\"afe\",\"afg\",\"afh\",\"afi\",\"afk\",\"afn\",\"afo\",\"afp\",\"afs\",\"aft\",\"afu\",\"afz\",\"aga\",\"agb\",\"agc\",\"agd\",\"age\",\"agf\",\"agg\",\"agh\",\"agi\",\"agj\",\"agk\",\"agl\",\"agm\",\"agn\",\"ago\",\"agp\",\"agq\",\"agr\",\"ags\",\"agt\",\"agu\",\"agv\",\"agw\",\"agx\",\"agy\",\"agz\",\"aha\",\"ahb\",\"ahg\",\"ahh\",\"ahi\",\"ahk\",\"ahl\",\"ahm\",\"ahn\",\"aho\",\"ahp\",\"ahr\",\"ahs\",\"aht\",\"aia\",\"aib\",\"aic\",\"aid\",\"aie\",\"aif\",\"aig\",\"aih\",\"aii\",\"aij\",\"aik\",\"ail\",\"aim\",\"ain\",\"aio\",\"aip\",\"aiq\",\"air\",\"ais\",\"ait\",\"aiw\",\"aix\",\"aiy\",\"aja\",\"ajg\",\"aji\",\"ajn\",\"ajp\",\"ajt\",\"aju\",\"ajw\",\"ajz\",\"akb\",\"akc\",\"akd\",\"ake\",\"akf\",\"akg\",\"akh\",\"aki\",\"akj\",\"akk\",\"akl\",\"akm\",\"ako\",\"akp\",\"akq\",\"akr\",\"aks\",\"akt\",\"aku\",\"akv\",\"akw\",\"akx\",\"aky\",\"akz\",\"ala\",\"alc\",\"ald\",\"ale\",\"alf\",\"alg\",\"alh\",\"ali\",\"alj\",\"alk\",\"all\",\"alm\",\"aln\",\"alo\",\"alp\",\"alq\",\"alr\",\"als\",\"alt\",\"alu\",\"alv\",\"alw\",\"alx\",\"aly\",\"alz\",\"ama\",\"amb\",\"amc\",\"ame\",\"amf\",\"amg\",\"ami\",\"amj\",\"amk\",\"aml\",\"amm\",\"amn\",\"amo\",\"amp\",\"amq\",\"amr\",\"ams\",\"amt\",\"amu\",\"amv\",\"amw\",\"amx\",\"amy\",\"amz\",\"ana\",\"anb\",\"anc\",\"and\",\"ane\",\"anf\",\"ang\",\"anh\",\"ani\",\"anj\",\"ank\",\"anl\",\"anm\",\"ann\",\"ano\",\"anp\",\"anq\",\"anr\",\"ans\",\"ant\",\"anu\",\"anv\",\"anw\",\"anx\",\"any\",\"anz\",\"aoa\",\"aob\",\"aoc\",\"aod\",\"aoe\",\"aof\",\"aog\",\"aoh\",\"aoi\",\"aoj\",\"aok\",\"aol\",\"aom\",\"aon\",\"aor\",\"aos\",\"aot\",\"aou\",\"aox\",\"aoz\",\"apa\",\"apb\",\"apc\",\"apd\",\"ape\",\"apf\",\"apg\",\"aph\",\"api\",\"apj\",\"apk\",\"apl\",\"apm\",\"apn\",\"apo\",\"app\",\"apq\",\"apr\",\"aps\",\"apt\",\"apu\",\"apv\",\"apw\",\"apx\",\"apy\",\"apz\",\"aqa\",\"aqc\",\"aqd\",\"aqg\",\"aql\",\"aqm\",\"aqn\",\"aqp\",\"aqr\",\"aqt\",\"aqz\",\"arb\",\"arc\",\"ard\",\"are\",\"arh\",\"ari\",\"arj\",\"ark\",\"arl\",\"arn\",\"aro\",\"arp\",\"arq\",\"arr\",\"ars\",\"art\",\"aru\",\"arv\",\"arw\",\"arx\",\"ary\",\"arz\",\"asa\",\"asb\",\"asc\",\"asd\",\"ase\",\"asf\",\"asg\",\"ash\",\"asi\",\"asj\",\"ask\",\"asl\",\"asn\",\"aso\",\"asp\",\"asq\",\"asr\",\"ass\",\"ast\",\"asu\",\"asv\",\"asw\",\"asx\",\"asy\",\"asz\",\"ata\",\"atb\",\"atc\",\"atd\",\"ate\",\"atg\",\"ath\",\"ati\",\"atj\",\"atk\",\"atl\",\"atm\",\"atn\",\"ato\",\"atp\",\"atq\",\"atr\",\"ats\",\"att\",\"atu\",\"atv\",\"atw\",\"atx\",\"aty\",\"atz\",\"aua\",\"aub\",\"auc\",\"aud\",\"aue\",\"auf\",\"aug\",\"auh\",\"aui\",\"auj\",\"auk\",\"aul\",\"aum\",\"aun\",\"auo\",\"aup\",\"auq\",\"aur\",\"aus\",\"aut\",\"auu\",\"auw\",\"aux\",\"auy\",\"auz\",\"avb\",\"avd\",\"avi\",\"avk\",\"avl\",\"avm\",\"avn\",\"avo\",\"avs\",\"avt\",\"avu\",\"avv\",\"awa\",\"awb\",\"awc\",\"awd\",\"awe\",\"awg\",\"awh\",\"awi\",\"awk\",\"awm\",\"awn\",\"awo\",\"awr\",\"aws\",\"awt\",\"awu\",\"awv\",\"aww\",\"awx\",\"awy\",\"axb\",\"axe\",\"axg\",\"axk\",\"axl\",\"axm\",\"axx\",\"aya\",\"ayb\",\"ayc\",\"ayd\",\"aye\",\"ayg\",\"ayh\",\"ayi\",\"ayk\",\"ayl\",\"ayn\",\"ayo\",\"ayp\",\"ayq\",\"ayr\",\"ays\",\"ayt\",\"ayu\",\"ayx\",\"ayy\",\"ayz\",\"aza\",\"azb\",\"azc\",\"azd\",\"azg\",\"azj\",\"azm\",\"azn\",\"azo\",\"azt\",\"azz\",\"baa\",\"bab\",\"bac\",\"bad\",\"bae\",\"baf\",\"bag\",\"bah\",\"bai\",\"baj\",\"bal\",\"ban\",\"bao\",\"bap\",\"bar\",\"bas\",\"bat\",\"bau\",\"bav\",\"baw\",\"bax\",\"bay\",\"baz\",\"bba\",\"bbb\",\"bbc\",\"bbd\",\"bbe\",\"bbf\",\"bbg\",\"bbh\",\"bbi\",\"bbj\",\"bbk\",\"bbl\",\"bbm\",\"bbn\",\"bbo\",\"bbp\",\"bbq\",\"bbr\",\"bbs\",\"bbt\",\"bbu\",\"bbv\",\"bbw\",\"bbx\",\"bby\",\"bbz\",\"bca\",\"bcb\",\"bcc\",\"bcd\",\"bce\",\"bcf\",\"bcg\",\"bch\",\"bci\",\"bcj\",\"bck\",\"bcl\",\"bcm\",\"bcn\",\"bco\",\"bcp\",\"bcq\",\"bcr\",\"bcs\",\"bct\",\"bcu\",\"bcv\",\"bcw\",\"bcy\",\"bcz\",\"bda\",\"bdb\",\"bdc\",\"bdd\",\"bde\",\"bdf\",\"bdg\",\"bdh\",\"bdi\",\"bdj\",\"bdk\",\"bdl\",\"bdm\",\"bdn\",\"bdo\",\"bdp\",\"bdq\",\"bdr\",\"bds\",\"bdt\",\"bdu\",\"bdv\",\"bdw\",\"bdx\",\"bdy\",\"bdz\",\"bea\",\"beb\",\"bec\",\"bed\",\"bee\",\"bef\",\"beg\",\"beh\",\"bei\",\"bej\",\"bek\",\"bem\",\"beo\",\"bep\",\"beq\",\"ber\",\"bes\",\"bet\",\"beu\",\"bev\",\"bew\",\"bex\",\"bey\",\"bez\",\"bfa\",\"bfb\",\"bfc\",\"bfd\",\"bfe\",\"bff\",\"bfg\",\"bfh\",\"bfi\",\"bfj\",\"bfk\",\"bfl\",\"bfm\",\"bfn\",\"bfo\",\"bfp\",\"bfq\",\"bfr\",\"bfs\",\"bft\",\"bfu\",\"bfw\",\"bfx\",\"bfy\",\"bfz\",\"bga\",\"bgb\",\"bgc\",\"bgd\",\"bge\",\"bgf\",\"bgg\",\"bgi\",\"bgj\",\"bgk\",\"bgl\",\"bgm\",\"bgn\",\"bgo\",\"bgp\",\"bgq\",\"bgr\",\"bgs\",\"bgt\",\"bgu\",\"bgv\",\"bgw\",\"bgx\",\"bgy\",\"bgz\",\"bha\",\"bhb\",\"bhc\",\"bhd\",\"bhe\",\"bhf\",\"bhg\",\"bhh\",\"bhi\",\"bhj\",\"bhk\",\"bhl\",\"bhm\",\"bhn\",\"bho\",\"bhp\",\"bhq\",\"bhr\",\"bhs\",\"bht\",\"bhu\",\"bhv\",\"bhw\",\"bhx\",\"bhy\",\"bhz\",\"bia\",\"bib\",\"bic\",\"bid\",\"bie\",\"bif\",\"big\",\"bij\",\"bik\",\"bil\",\"bim\",\"bin\",\"bio\",\"bip\",\"biq\",\"bir\",\"bit\",\"biu\",\"biv\",\"biw\",\"bix\",\"biy\",\"biz\",\"bja\",\"bjb\",\"bjc\",\"bjd\",\"bje\",\"bjf\",\"bjg\",\"bjh\",\"bji\",\"bjj\",\"bjk\",\"bjl\",\"bjm\",\"bjn\",\"bjo\",\"bjp\",\"bjq\",\"bjr\",\"bjs\",\"bjt\",\"bju\",\"bjv\",\"bjw\",\"bjx\",\"bjy\",\"bjz\",\"bka\",\"bkb\",\"bkc\",\"bkd\",\"bkf\",\"bkg\",\"bkh\",\"bki\",\"bkj\",\"bkk\",\"bkl\",\"bkm\",\"bkn\",\"bko\",\"bkp\",\"bkq\",\"bkr\",\"bks\",\"bkt\",\"bku\",\"bkv\",\"bkw\",\"bkx\",\"bky\",\"bkz\",\"bla\",\"blb\",\"blc\",\"bld\",\"ble\",\"blf\",\"blg\",\"blh\",\"bli\",\"blj\",\"blk\",\"bll\",\"blm\",\"bln\",\"blo\",\"blp\",\"blq\",\"blr\",\"bls\",\"blt\",\"blv\",\"blw\",\"blx\",\"bly\",\"blz\",\"bma\",\"bmb\",\"bmc\",\"bmd\",\"bme\",\"bmf\",\"bmg\",\"bmh\",\"bmi\",\"bmj\",\"bmk\",\"bml\",\"bmm\",\"bmn\",\"bmo\",\"bmp\",\"bmq\",\"bmr\",\"bms\",\"bmt\",\"bmu\",\"bmv\",\"bmw\",\"bmx\",\"bmy\",\"bmz\",\"bna\",\"bnb\",\"bnc\",\"bnd\",\"bne\",\"bnf\",\"bng\",\"bni\",\"bnj\",\"bnk\",\"bnl\",\"bnm\",\"bnn\",\"bno\",\"bnp\",\"bnq\",\"bnr\",\"bns\",\"bnt\",\"bnu\",\"bnv\",\"bnw\",\"bnx\",\"bny\",\"bnz\",\"boa\",\"bob\",\"boe\",\"bof\",\"bog\",\"boh\",\"boi\",\"boj\",\"bok\",\"bol\",\"bom\",\"bon\",\"boo\",\"bop\",\"boq\",\"bor\",\"bot\",\"bou\",\"bov\",\"bow\",\"box\",\"boy\",\"boz\",\"bpa\",\"bpb\",\"bpd\",\"bpg\",\"bph\",\"bpi\",\"bpj\",\"bpk\",\"bpl\",\"bpm\",\"bpn\",\"bpo\",\"bpp\",\"bpq\",\"bpr\",\"bps\",\"bpt\",\"bpu\",\"bpv\",\"bpw\",\"bpx\",\"bpy\",\"bpz\",\"bqa\",\"bqb\",\"bqc\",\"bqd\",\"bqf\",\"bqg\",\"bqh\",\"bqi\",\"bqj\",\"bqk\",\"bql\",\"bqm\",\"bqn\",\"bqo\",\"bqp\",\"bqq\",\"bqr\",\"bqs\",\"bqt\",\"bqu\",\"bqv\",\"bqw\",\"bqx\",\"bqy\",\"bqz\",\"bra\",\"brb\",\"brc\",\"brd\",\"brf\",\"brg\",\"brh\",\"bri\",\"brj\",\"brk\",\"brl\",\"brm\",\"brn\",\"bro\",\"brp\",\"brq\",\"brr\",\"brs\",\"brt\",\"bru\",\"brv\",\"brw\",\"brx\",\"bry\",\"brz\",\"bsa\",\"bsb\",\"bsc\",\"bse\",\"bsf\",\"bsg\",\"bsh\",\"bsi\",\"bsj\",\"bsk\",\"bsl\",\"bsm\",\"bsn\",\"bso\",\"bsp\",\"bsq\",\"bsr\",\"bss\",\"bst\",\"bsu\",\"bsv\",\"bsw\",\"bsx\",\"bsy\",\"bta\",\"btb\",\"btc\",\"btd\",\"bte\",\"btf\",\"btg\",\"bth\",\"bti\",\"btj\",\"btk\",\"btl\",\"btm\",\"btn\",\"bto\",\"btp\",\"btq\",\"btr\",\"bts\",\"btt\",\"btu\",\"btv\",\"btw\",\"btx\",\"bty\",\"btz\",\"bua\",\"bub\",\"buc\",\"bud\",\"bue\",\"buf\",\"bug\",\"buh\",\"bui\",\"buj\",\"buk\",\"bum\",\"bun\",\"buo\",\"bup\",\"buq\",\"bus\",\"but\",\"buu\",\"buv\",\"buw\",\"bux\",\"buy\",\"buz\",\"bva\",\"bvb\",\"bvc\",\"bvd\",\"bve\",\"bvf\",\"bvg\",\"bvh\",\"bvi\",\"bvj\",\"bvk\",\"bvl\",\"bvm\",\"bvn\",\"bvo\",\"bvp\",\"bvq\",\"bvr\",\"bvt\",\"bvu\",\"bvv\",\"bvw\",\"bvx\",\"bvy\",\"bvz\",\"bwa\",\"bwb\",\"bwc\",\"bwd\",\"bwe\",\"bwf\",\"bwg\",\"bwh\",\"bwi\",\"bwj\",\"bwk\",\"bwl\",\"bwm\",\"bwn\",\"bwo\",\"bwp\",\"bwq\",\"bwr\",\"bws\",\"bwt\",\"bwu\",\"bww\",\"bwx\",\"bwy\",\"bwz\",\"bxa\",\"bxb\",\"bxc\",\"bxd\",\"bxe\",\"bxf\",\"bxg\",\"bxh\",\"bxi\",\"bxj\",\"bxk\",\"bxl\",\"bxm\",\"bxn\",\"bxo\",\"bxp\",\"bxq\",\"bxr\",\"bxs\",\"bxu\",\"bxv\",\"bxw\",\"bxx\",\"bxz\",\"bya\",\"byb\",\"byc\",\"byd\",\"bye\",\"byf\",\"byg\",\"byh\",\"byi\",\"byj\",\"byk\",\"byl\",\"bym\",\"byn\",\"byo\",\"byp\",\"byq\",\"byr\",\"bys\",\"byt\",\"byv\",\"byw\",\"byx\",\"byy\",\"byz\",\"bza\",\"bzb\",\"bzc\",\"bzd\",\"bze\",\"bzf\",\"bzg\",\"bzh\",\"bzi\",\"bzj\",\"bzk\",\"bzl\",\"bzm\",\"bzn\",\"bzo\",\"bzp\",\"bzq\",\"bzr\",\"bzs\",\"bzt\",\"bzu\",\"bzv\",\"bzw\",\"bzx\",\"bzy\",\"bzz\",\"caa\",\"cab\",\"cac\",\"cad\",\"cae\",\"caf\",\"cag\",\"cah\",\"cai\",\"caj\",\"cak\",\"cal\",\"cam\",\"can\",\"cao\",\"cap\",\"caq\",\"car\",\"cas\",\"cau\",\"cav\",\"caw\",\"cax\",\"cay\",\"caz\",\"cba\",\"cbb\",\"cbc\",\"cbd\",\"cbe\",\"cbg\",\"cbh\",\"cbi\",\"cbj\",\"cbk\",\"cbl\",\"cbn\",\"cbo\",\"cbq\",\"cbr\",\"cbs\",\"cbt\",\"cbu\",\"cbv\",\"cbw\",\"cby\",\"cca\",\"ccc\",\"ccd\",\"cce\",\"ccg\",\"cch\",\"ccj\",\"ccl\",\"ccm\",\"ccn\",\"cco\",\"ccp\",\"ccq\",\"ccr\",\"ccs\",\"cda\",\"cdc\",\"cdd\",\"cde\",\"cdf\",\"cdg\",\"cdh\",\"cdi\",\"cdj\",\"cdm\",\"cdn\",\"cdo\",\"cdr\",\"cds\",\"cdy\",\"cdz\",\"cea\",\"ceb\",\"ceg\",\"cek\",\"cel\",\"cen\",\"cet\",\"cfa\",\"cfd\",\"cfg\",\"cfm\",\"cga\",\"cgc\",\"cgg\",\"cgk\",\"chb\",\"chc\",\"chd\",\"chf\",\"chg\",\"chh\",\"chj\",\"chk\",\"chl\",\"chm\",\"chn\",\"cho\",\"chp\",\"chq\",\"chr\",\"cht\",\"chw\",\"chx\",\"chy\",\"chz\",\"cia\",\"cib\",\"cic\",\"cid\",\"cie\",\"cih\",\"cik\",\"cim\",\"cin\",\"cip\",\"cir\",\"ciw\",\"ciy\",\"cja\",\"cje\",\"cjh\",\"cji\",\"cjk\",\"cjm\",\"cjn\",\"cjo\",\"cjp\",\"cjr\",\"cjs\",\"cjv\",\"cjy\",\"cka\",\"ckb\",\"ckh\",\"ckl\",\"ckn\",\"cko\",\"ckq\",\"ckr\",\"cks\",\"ckt\",\"cku\",\"ckv\",\"ckx\",\"cky\",\"ckz\",\"cla\",\"clc\",\"cld\",\"cle\",\"clh\",\"cli\",\"clj\",\"clk\",\"cll\",\"clm\",\"clo\",\"clt\",\"clu\",\"clw\",\"cly\",\"cma\",\"cmc\",\"cme\",\"cmg\",\"cmi\",\"cmk\",\"cml\",\"cmm\",\"cmn\",\"cmo\",\"cmr\",\"cms\",\"cmt\",\"cna\",\"cnb\",\"cnc\",\"cng\",\"cnh\",\"cni\",\"cnk\",\"cnl\",\"cno\",\"cns\",\"cnt\",\"cnu\",\"cnw\",\"cnx\",\"coa\",\"cob\",\"coc\",\"cod\",\"coe\",\"cof\",\"cog\",\"coh\",\"coj\",\"cok\",\"col\",\"com\",\"con\",\"coo\",\"cop\",\"coq\",\"cot\",\"cou\",\"cov\",\"cow\",\"cox\",\"coy\",\"coz\",\"cpa\",\"cpb\",\"cpc\",\"cpe\",\"cpf\",\"cpg\",\"cpi\",\"cpn\",\"cpo\",\"cpp\",\"cps\",\"cpu\",\"cpx\",\"cpy\",\"cqd\",\"cqu\",\"cra\",\"crb\",\"crc\",\"crd\",\"crf\",\"crg\",\"crh\",\"cri\",\"crj\",\"crk\",\"crl\",\"crm\",\"crn\",\"cro\",\"crp\",\"crq\",\"crr\",\"crs\",\"crt\",\"crv\",\"crw\",\"crx\",\"cry\",\"crz\",\"csa\",\"csb\",\"csc\",\"csd\",\"cse\",\"csf\",\"csg\",\"csh\",\"csi\",\"csj\",\"csk\",\"csl\",\"csm\",\"csn\",\"cso\",\"csq\",\"csr\",\"css\",\"cst\",\"csu\",\"csv\",\"csw\",\"csy\",\"csz\",\"cta\",\"ctc\",\"ctd\",\"cte\",\"ctg\",\"cth\",\"ctl\",\"ctm\",\"ctn\",\"cto\",\"ctp\",\"cts\",\"ctt\",\"ctu\",\"ctz\",\"cua\",\"cub\",\"cuc\",\"cug\",\"cuh\",\"cui\",\"cuj\",\"cuk\",\"cul\",\"cum\",\"cuo\",\"cup\",\"cuq\",\"cur\",\"cus\",\"cut\",\"cuu\",\"cuv\",\"cuw\",\"cux\",\"cvg\",\"cvn\",\"cwa\",\"cwb\",\"cwd\",\"cwe\",\"cwg\",\"cwt\",\"cya\",\"cyb\",\"cyo\",\"czh\",\"czk\",\"czn\",\"czo\",\"czt\",\"daa\",\"dac\",\"dad\",\"dae\",\"daf\",\"dag\",\"dah\",\"dai\",\"daj\",\"dak\",\"dal\",\"dam\",\"dao\",\"dap\",\"daq\",\"dar\",\"das\",\"dau\",\"dav\",\"daw\",\"dax\",\"day\",\"daz\",\"dba\",\"dbb\",\"dbd\",\"dbe\",\"dbf\",\"dbg\",\"dbi\",\"dbj\",\"dbl\",\"dbm\",\"dbn\",\"dbo\",\"dbp\",\"dbq\",\"dbr\",\"dbt\",\"dbu\",\"dbv\",\"dbw\",\"dby\",\"dcc\",\"dcr\",\"dda\",\"ddd\",\"dde\",\"ddg\",\"ddi\",\"ddj\",\"ddn\",\"ddo\",\"ddr\",\"dds\",\"ddw\",\"dec\",\"ded\",\"dee\",\"def\",\"deg\",\"deh\",\"dei\",\"dek\",\"del\",\"dem\",\"den\",\"dep\",\"deq\",\"der\",\"des\",\"dev\",\"dez\",\"dga\",\"dgb\",\"dgc\",\"dgd\",\"dge\",\"dgg\",\"dgh\",\"dgi\",\"dgk\",\"dgl\",\"dgn\",\"dgo\",\"dgr\",\"dgs\",\"dgt\",\"dgu\",\"dgw\",\"dgx\",\"dgz\",\"dha\",\"dhd\",\"dhg\",\"dhi\",\"dhl\",\"dhm\",\"dhn\",\"dho\",\"dhr\",\"dhs\",\"dhu\",\"dhv\",\"dhw\",\"dhx\",\"dia\",\"dib\",\"dic\",\"did\",\"dif\",\"dig\",\"dih\",\"dii\",\"dij\",\"dik\",\"dil\",\"dim\",\"din\",\"dio\",\"dip\",\"diq\",\"dir\",\"dis\",\"dit\",\"diu\",\"diw\",\"dix\",\"diy\",\"diz\",\"dja\",\"djb\",\"djc\",\"djd\",\"dje\",\"djf\",\"dji\",\"djj\",\"djk\",\"djl\",\"djm\",\"djn\",\"djo\",\"djr\",\"dju\",\"djw\",\"dka\",\"dkk\",\"dkl\",\"dkr\",\"dks\",\"dkx\",\"dlg\",\"dlk\",\"dlm\",\"dln\",\"dma\",\"dmb\",\"dmc\",\"dmd\",\"dme\",\"dmg\",\"dmk\",\"dml\",\"dmm\",\"dmn\",\"dmo\",\"dmr\",\"dms\",\"dmu\",\"dmv\",\"dmw\",\"dmx\",\"dmy\",\"dna\",\"dnd\",\"dne\",\"dng\",\"dni\",\"dnj\",\"dnk\",\"dnn\",\"dnr\",\"dnt\",\"dnu\",\"dnv\",\"dnw\",\"dny\",\"doa\",\"dob\",\"doc\",\"doe\",\"dof\",\"doh\",\"doi\",\"dok\",\"dol\",\"don\",\"doo\",\"dop\",\"doq\",\"dor\",\"dos\",\"dot\",\"dov\",\"dow\",\"dox\",\"doy\",\"doz\",\"dpp\",\"dra\",\"drb\",\"drc\",\"drd\",\"dre\",\"drg\",\"drh\",\"dri\",\"drl\",\"drn\",\"dro\",\"drq\",\"drr\",\"drs\",\"drt\",\"dru\",\"drw\",\"dry\",\"dsb\",\"dse\",\"dsh\",\"dsi\",\"dsl\",\"dsn\",\"dso\",\"dsq\",\"dta\",\"dtb\",\"dtd\",\"dth\",\"dti\",\"dtk\",\"dtm\",\"dtn\",\"dto\",\"dtp\",\"dtr\",\"dts\",\"dtt\",\"dtu\",\"dty\",\"dua\",\"dub\",\"duc\",\"dud\",\"due\",\"duf\",\"dug\",\"duh\",\"dui\",\"duj\",\"duk\",\"dul\",\"dum\",\"dun\",\"duo\",\"dup\",\"duq\",\"dur\",\"dus\",\"duu\",\"duv\",\"duw\",\"dux\",\"duy\",\"duz\",\"dva\",\"dwa\",\"dwl\",\"dwr\",\"dws\",\"dwu\",\"dww\",\"dwy\",\"dya\",\"dyb\",\"dyd\",\"dyg\",\"dyi\",\"dym\",\"dyn\",\"dyo\",\"dyu\",\"dyy\",\"dza\",\"dzd\",\"dze\",\"dzg\",\"dzl\",\"dzn\",\"eaa\",\"ebg\",\"ebk\",\"ebo\",\"ebr\",\"ebu\",\"ecr\",\"ecs\",\"ecy\",\"eee\",\"efa\",\"efe\",\"efi\",\"ega\",\"egl\",\"ego\",\"egx\",\"egy\",\"ehu\",\"eip\",\"eit\",\"eiv\",\"eja\",\"eka\",\"ekc\",\"eke\",\"ekg\",\"eki\",\"ekk\",\"ekl\",\"ekm\",\"eko\",\"ekp\",\"ekr\",\"eky\",\"ele\",\"elh\",\"eli\",\"elk\",\"elm\",\"elo\",\"elp\",\"elu\",\"elx\",\"ema\",\"emb\",\"eme\",\"emg\",\"emi\",\"emk\",\"emm\",\"emn\",\"emo\",\"emp\",\"ems\",\"emu\",\"emw\",\"emx\",\"emy\",\"ena\",\"enb\",\"enc\",\"end\",\"enf\",\"enh\",\"enl\",\"enm\",\"enn\",\"eno\",\"enq\",\"enr\",\"enu\",\"env\",\"enw\",\"enx\",\"eot\",\"epi\",\"era\",\"erg\",\"erh\",\"eri\",\"erk\",\"ero\",\"err\",\"ers\",\"ert\",\"erw\",\"ese\",\"esg\",\"esh\",\"esi\",\"esk\",\"esl\",\"esm\",\"esn\",\"eso\",\"esq\",\"ess\",\"esu\",\"esx\",\"esy\",\"etb\",\"etc\",\"eth\",\"etn\",\"eto\",\"etr\",\"ets\",\"ett\",\"etu\",\"etx\",\"etz\",\"euq\",\"eve\",\"evh\",\"evn\",\"ewo\",\"ext\",\"eya\",\"eyo\",\"eza\",\"eze\",\"faa\",\"fab\",\"fad\",\"faf\",\"fag\",\"fah\",\"fai\",\"faj\",\"fak\",\"fal\",\"fam\",\"fan\",\"fap\",\"far\",\"fat\",\"fau\",\"fax\",\"fay\",\"faz\",\"fbl\",\"fcs\",\"fer\",\"ffi\",\"ffm\",\"fgr\",\"fia\",\"fie\",\"fil\",\"fip\",\"fir\",\"fit\",\"fiu\",\"fiw\",\"fkk\",\"fkv\",\"fla\",\"flh\",\"fli\",\"fll\",\"fln\",\"flr\",\"fly\",\"fmp\",\"fmu\",\"fnb\",\"fng\",\"fni\",\"fod\",\"foi\",\"fom\",\"fon\",\"for\",\"fos\",\"fox\",\"fpe\",\"fqs\",\"frc\",\"frd\",\"frk\",\"frm\",\"fro\",\"frp\",\"frq\",\"frr\",\"frs\",\"frt\",\"fse\",\"fsl\",\"fss\",\"fub\",\"fuc\",\"fud\",\"fue\",\"fuf\",\"fuh\",\"fui\",\"fuj\",\"fum\",\"fun\",\"fuq\",\"fur\",\"fut\",\"fuu\",\"fuv\",\"fuy\",\"fvr\",\"fwa\",\"fwe\",\"gaa\",\"gab\",\"gac\",\"gad\",\"gae\",\"gaf\",\"gag\",\"gah\",\"gai\",\"gaj\",\"gak\",\"gal\",\"gam\",\"gan\",\"gao\",\"gap\",\"gaq\",\"gar\",\"gas\",\"gat\",\"gau\",\"gav\",\"gaw\",\"gax\",\"gay\",\"gaz\",\"gba\",\"gbb\",\"gbc\",\"gbd\",\"gbe\",\"gbf\",\"gbg\",\"gbh\",\"gbi\",\"gbj\",\"gbk\",\"gbl\",\"gbm\",\"gbn\",\"gbo\",\"gbp\",\"gbq\",\"gbr\",\"gbs\",\"gbu\",\"gbv\",\"gbw\",\"gbx\",\"gby\",\"gbz\",\"gcc\",\"gcd\",\"gce\",\"gcf\",\"gcl\",\"gcn\",\"gcr\",\"gct\",\"gda\",\"gdb\",\"gdc\",\"gdd\",\"gde\",\"gdf\",\"gdg\",\"gdh\",\"gdi\",\"gdj\",\"gdk\",\"gdl\",\"gdm\",\"gdn\",\"gdo\",\"gdq\",\"gdr\",\"gds\",\"gdt\",\"gdu\",\"gdx\",\"gea\",\"geb\",\"gec\",\"ged\",\"geg\",\"geh\",\"gei\",\"gej\",\"gek\",\"gel\",\"gem\",\"geq\",\"ges\",\"gev\",\"gew\",\"gex\",\"gey\",\"gez\",\"gfk\",\"gft\",\"gfx\",\"gga\",\"ggb\",\"ggd\",\"gge\",\"ggg\",\"ggk\",\"ggl\",\"ggn\",\"ggo\",\"ggr\",\"ggt\",\"ggu\",\"ggw\",\"gha\",\"ghc\",\"ghe\",\"ghh\",\"ghk\",\"ghl\",\"ghn\",\"gho\",\"ghr\",\"ghs\",\"ght\",\"gia\",\"gib\",\"gic\",\"gid\",\"gig\",\"gih\",\"gil\",\"gim\",\"gin\",\"gio\",\"gip\",\"giq\",\"gir\",\"gis\",\"git\",\"giu\",\"giw\",\"gix\",\"giy\",\"giz\",\"gji\",\"gjk\",\"gjm\",\"gjn\",\"gjr\",\"gju\",\"gka\",\"gke\",\"gkn\",\"gko\",\"gkp\",\"gku\",\"glc\",\"gld\",\"glh\",\"gli\",\"glj\",\"glk\",\"gll\",\"glo\",\"glr\",\"glu\",\"glw\",\"gly\",\"gma\",\"gmb\",\"gmd\",\"gme\",\"gmg\",\"gmh\",\"gml\",\"gmm\",\"gmn\",\"gmq\",\"gmu\",\"gmv\",\"gmw\",\"gmx\",\"gmy\",\"gmz\",\"gna\",\"gnb\",\"gnc\",\"gnd\",\"gne\",\"gng\",\"gnh\",\"gni\",\"gnk\",\"gnl\",\"gnm\",\"gnn\",\"gno\",\"gnq\",\"gnr\",\"gnt\",\"gnu\",\"gnw\",\"gnz\",\"goa\",\"gob\",\"goc\",\"god\",\"goe\",\"gof\",\"gog\",\"goh\",\"goi\",\"goj\",\"gok\",\"gol\",\"gom\",\"gon\",\"goo\",\"gop\",\"goq\",\"gor\",\"gos\",\"got\",\"gou\",\"gow\",\"gox\",\"goy\",\"goz\",\"gpa\",\"gpe\",\"gpn\",\"gqa\",\"gqi\",\"gqn\",\"gqr\",\"gqu\",\"gra\",\"grb\",\"grc\",\"grd\",\"grg\",\"grh\",\"gri\",\"grj\",\"grk\",\"grm\",\"gro\",\"grq\",\"grr\",\"grs\",\"grt\",\"gru\",\"grv\",\"grw\",\"grx\",\"gry\",\"grz\",\"gse\",\"gsg\",\"gsl\",\"gsm\",\"gsn\",\"gso\",\"gsp\",\"gss\",\"gsw\",\"gta\",\"gti\",\"gtu\",\"gua\",\"gub\",\"guc\",\"gud\",\"gue\",\"guf\",\"gug\",\"guh\",\"gui\",\"guk\",\"gul\",\"gum\",\"gun\",\"guo\",\"gup\",\"guq\",\"gur\",\"gus\",\"gut\",\"guu\",\"guv\",\"guw\",\"gux\",\"guz\",\"gva\",\"gvc\",\"gve\",\"gvf\",\"gvj\",\"gvl\",\"gvm\",\"gvn\",\"gvo\",\"gvp\",\"gvr\",\"gvs\",\"gvy\",\"gwa\",\"gwb\",\"gwc\",\"gwd\",\"gwe\",\"gwf\",\"gwg\",\"gwi\",\"gwj\",\"gwm\",\"gwn\",\"gwr\",\"gwt\",\"gwu\",\"gww\",\"gwx\",\"gxx\",\"gya\",\"gyb\",\"gyd\",\"gye\",\"gyf\",\"gyg\",\"gyi\",\"gyl\",\"gym\",\"gyn\",\"gyr\",\"gyy\",\"gza\",\"gzi\",\"gzn\",\"haa\",\"hab\",\"hac\",\"had\",\"hae\",\"haf\",\"hag\",\"hah\",\"hai\",\"haj\",\"hak\",\"hal\",\"ham\",\"han\",\"hao\",\"hap\",\"haq\",\"har\",\"has\",\"hav\",\"haw\",\"hax\",\"hay\",\"haz\",\"hba\",\"hbb\",\"hbn\",\"hbo\",\"hbu\",\"hca\",\"hch\",\"hdn\",\"hds\",\"hdy\",\"hea\",\"hed\",\"heg\",\"heh\",\"hei\",\"hem\",\"hgm\",\"hgw\",\"hhi\",\"hhr\",\"hhy\",\"hia\",\"hib\",\"hid\",\"hif\",\"hig\",\"hih\",\"hii\",\"hij\",\"hik\",\"hil\",\"him\",\"hio\",\"hir\",\"hit\",\"hiw\",\"hix\",\"hji\",\"hka\",\"hke\",\"hkk\",\"hks\",\"hla\",\"hlb\",\"hld\",\"hle\",\"hlt\",\"hlu\",\"hma\",\"hmb\",\"hmc\",\"hmd\",\"hme\",\"hmf\",\"hmg\",\"hmh\",\"hmi\",\"hmj\",\"hmk\",\"hml\",\"hmm\",\"hmn\",\"hmp\",\"hmq\",\"hmr\",\"hms\",\"hmt\",\"hmu\",\"hmv\",\"hmw\",\"hmx\",\"hmy\",\"hmz\",\"hna\",\"hnd\",\"hne\",\"hnh\",\"hni\",\"hnj\",\"hnn\",\"hno\",\"hns\",\"hnu\",\"hoa\",\"hob\",\"hoc\",\"hod\",\"hoe\",\"hoh\",\"hoi\",\"hoj\",\"hok\",\"hol\",\"hom\",\"hoo\",\"hop\",\"hor\",\"hos\",\"hot\",\"hov\",\"how\",\"hoy\",\"hoz\",\"hpo\",\"hps\",\"hra\",\"hrc\",\"hre\",\"hrk\",\"hrm\",\"hro\",\"hrp\",\"hrr\",\"hrt\",\"hru\",\"hrw\",\"hrx\",\"hrz\",\"hsb\",\"hsh\",\"hsl\",\"hsn\",\"hss\",\"hti\",\"hto\",\"hts\",\"htu\",\"htx\",\"hub\",\"huc\",\"hud\",\"hue\",\"huf\",\"hug\",\"huh\",\"hui\",\"huj\",\"huk\",\"hul\",\"hum\",\"huo\",\"hup\",\"huq\",\"hur\",\"hus\",\"hut\",\"huu\",\"huv\",\"huw\",\"hux\",\"huy\",\"huz\",\"hvc\",\"hve\",\"hvk\",\"hvn\",\"hvv\",\"hwa\",\"hwc\",\"hwo\",\"hya\",\"hyx\",\"iai\",\"ian\",\"iap\",\"iar\",\"iba\",\"ibb\",\"ibd\",\"ibe\",\"ibg\",\"ibi\",\"ibl\",\"ibm\",\"ibn\",\"ibr\",\"ibu\",\"iby\",\"ica\",\"ich\",\"icl\",\"icr\",\"ida\",\"idb\",\"idc\",\"idd\",\"ide\",\"idi\",\"idr\",\"ids\",\"idt\",\"idu\",\"ifa\",\"ifb\",\"ife\",\"iff\",\"ifk\",\"ifm\",\"ifu\",\"ify\",\"igb\",\"ige\",\"igg\",\"igl\",\"igm\",\"ign\",\"igo\",\"igs\",\"igw\",\"ihb\",\"ihi\",\"ihp\",\"ihw\",\"iin\",\"iir\",\"ijc\",\"ije\",\"ijj\",\"ijn\",\"ijo\",\"ijs\",\"ike\",\"iki\",\"ikk\",\"ikl\",\"iko\",\"ikp\",\"ikr\",\"iks\",\"ikt\",\"ikv\",\"ikw\",\"ikx\",\"ikz\",\"ila\",\"ilb\",\"ilg\",\"ili\",\"ilk\",\"ill\",\"ilm\",\"ilo\",\"ilp\",\"ils\",\"ilu\",\"ilv\",\"ilw\",\"ima\",\"ime\",\"imi\",\"iml\",\"imn\",\"imo\",\"imr\",\"ims\",\"imy\",\"inb\",\"inc\",\"ine\",\"ing\",\"inh\",\"inj\",\"inl\",\"inm\",\"inn\",\"ino\",\"inp\",\"ins\",\"int\",\"inz\",\"ior\",\"iou\",\"iow\",\"ipi\",\"ipo\",\"iqu\",\"iqw\",\"ira\",\"ire\",\"irh\",\"iri\",\"irk\",\"irn\",\"iro\",\"irr\",\"iru\",\"irx\",\"iry\",\"isa\",\"isc\",\"isd\",\"ise\",\"isg\",\"ish\",\"isi\",\"isk\",\"ism\",\"isn\",\"iso\",\"isr\",\"ist\",\"isu\",\"itb\",\"itc\",\"itd\",\"ite\",\"iti\",\"itk\",\"itl\",\"itm\",\"ito\",\"itr\",\"its\",\"itt\",\"itv\",\"itw\",\"itx\",\"ity\",\"itz\",\"ium\",\"ivb\",\"ivv\",\"iwk\",\"iwm\",\"iwo\",\"iws\",\"ixc\",\"ixl\",\"iya\",\"iyo\",\"iyx\",\"izh\",\"izi\",\"izr\",\"izz\",\"jaa\",\"jab\",\"jac\",\"jad\",\"jae\",\"jaf\",\"jah\",\"jaj\",\"jak\",\"jal\",\"jam\",\"jan\",\"jao\",\"jaq\",\"jar\",\"jas\",\"jat\",\"jau\",\"jax\",\"jay\",\"jaz\",\"jbe\",\"jbi\",\"jbj\",\"jbk\",\"jbn\",\"jbo\",\"jbr\",\"jbt\",\"jbu\",\"jbw\",\"jcs\",\"jct\",\"jda\",\"jdg\",\"jdt\",\"jeb\",\"jee\",\"jeg\",\"jeh\",\"jei\",\"jek\",\"jel\",\"jen\",\"jer\",\"jet\",\"jeu\",\"jgb\",\"jge\",\"jgk\",\"jgo\",\"jhi\",\"jhs\",\"jia\",\"jib\",\"jic\",\"jid\",\"jie\",\"jig\",\"jih\",\"jii\",\"jil\",\"jim\",\"jio\",\"jiq\",\"jit\",\"jiu\",\"jiv\",\"jiy\",\"jje\",\"jjr\",\"jka\",\"jkm\",\"jko\",\"jkp\",\"jkr\",\"jku\",\"jle\",\"jls\",\"jma\",\"jmb\",\"jmc\",\"jmd\",\"jmi\",\"jml\",\"jmn\",\"jmr\",\"jms\",\"jmw\",\"jmx\",\"jna\",\"jnd\",\"jng\",\"jni\",\"jnj\",\"jnl\",\"jns\",\"job\",\"jod\",\"jog\",\"jor\",\"jos\",\"jow\",\"jpa\",\"jpr\",\"jpx\",\"jqr\",\"jra\",\"jrb\",\"jrr\",\"jrt\",\"jru\",\"jsl\",\"jua\",\"jub\",\"juc\",\"jud\",\"juh\",\"jui\",\"juk\",\"jul\",\"jum\",\"jun\",\"juo\",\"jup\",\"jur\",\"jus\",\"jut\",\"juu\",\"juw\",\"juy\",\"jvd\",\"jvn\",\"jwi\",\"jya\",\"jye\",\"jyy\",\"kaa\",\"kab\",\"kac\",\"kad\",\"kae\",\"kaf\",\"kag\",\"kah\",\"kai\",\"kaj\",\"kak\",\"kam\",\"kao\",\"kap\",\"kaq\",\"kar\",\"kav\",\"kaw\",\"kax\",\"kay\",\"kba\",\"kbb\",\"kbc\",\"kbd\",\"kbe\",\"kbf\",\"kbg\",\"kbh\",\"kbi\",\"kbj\",\"kbk\",\"kbl\",\"kbm\",\"kbn\",\"kbo\",\"kbp\",\"kbq\",\"kbr\",\"kbs\",\"kbt\",\"kbu\",\"kbv\",\"kbw\",\"kbx\",\"kby\",\"kbz\",\"kca\",\"kcb\",\"kcc\",\"kcd\",\"kce\",\"kcf\",\"kcg\",\"kch\",\"kci\",\"kcj\",\"kck\",\"kcl\",\"kcm\",\"kcn\",\"kco\",\"kcp\",\"kcq\",\"kcr\",\"kcs\",\"kct\",\"kcu\",\"kcv\",\"kcw\",\"kcx\",\"kcy\",\"kcz\",\"kda\",\"kdc\",\"kdd\",\"kde\",\"kdf\",\"kdg\",\"kdh\",\"kdi\",\"kdj\",\"kdk\",\"kdl\",\"kdm\",\"kdn\",\"kdo\",\"kdp\",\"kdq\",\"kdr\",\"kdt\",\"kdu\",\"kdv\",\"kdw\",\"kdx\",\"kdy\",\"kdz\",\"kea\",\"keb\",\"kec\",\"ked\",\"kee\",\"kef\",\"keg\",\"keh\",\"kei\",\"kej\",\"kek\",\"kel\",\"kem\",\"ken\",\"keo\",\"kep\",\"keq\",\"ker\",\"kes\",\"ket\",\"keu\",\"kev\",\"kew\",\"kex\",\"key\",\"kez\",\"kfa\",\"kfb\",\"kfc\",\"kfd\",\"kfe\",\"kff\",\"kfg\",\"kfh\",\"kfi\",\"kfj\",\"kfk\",\"kfl\",\"kfm\",\"kfn\",\"kfo\",\"kfp\",\"kfq\",\"kfr\",\"kfs\",\"kft\",\"kfu\",\"kfv\",\"kfw\",\"kfx\",\"kfy\",\"kfz\",\"kga\",\"kgb\",\"kgc\",\"kgd\",\"kge\",\"kgf\",\"kgg\",\"kgh\",\"kgi\",\"kgj\",\"kgk\",\"kgl\",\"kgm\",\"kgn\",\"kgo\",\"kgp\",\"kgq\",\"kgr\",\"kgs\",\"kgt\",\"kgu\",\"kgv\",\"kgw\",\"kgx\",\"kgy\",\"kha\",\"khb\",\"khc\",\"khd\",\"khe\",\"khf\",\"khg\",\"khh\",\"khi\",\"khj\",\"khk\",\"khl\",\"khn\",\"kho\",\"khp\",\"khq\",\"khr\",\"khs\",\"kht\",\"khu\",\"khv\",\"khw\",\"khx\",\"khy\",\"khz\",\"kia\",\"kib\",\"kic\",\"kid\",\"kie\",\"kif\",\"kig\",\"kih\",\"kii\",\"kij\",\"kil\",\"kim\",\"kio\",\"kip\",\"kiq\",\"kis\",\"kit\",\"kiu\",\"kiv\",\"kiw\",\"kix\",\"kiy\",\"kiz\",\"kja\",\"kjb\",\"kjc\",\"kjd\",\"kje\",\"kjf\",\"kjg\",\"kjh\",\"kji\",\"kjj\",\"kjk\",\"kjl\",\"kjm\",\"kjn\",\"kjo\",\"kjp\",\"kjq\",\"kjr\",\"kjs\",\"kjt\",\"kju\",\"kjv\",\"kjx\",\"kjy\",\"kjz\",\"kka\",\"kkb\",\"kkc\",\"kkd\",\"kke\",\"kkf\",\"kkg\",\"kkh\",\"kki\",\"kkj\",\"kkk\",\"kkl\",\"kkm\",\"kkn\",\"kko\",\"kkp\",\"kkq\",\"kkr\",\"kks\",\"kkt\",\"kku\",\"kkv\",\"kkw\",\"kkx\",\"kky\",\"kkz\",\"kla\",\"klb\",\"klc\",\"kld\",\"kle\",\"klf\",\"klg\",\"klh\",\"kli\",\"klj\",\"klk\",\"kll\",\"klm\",\"kln\",\"klo\",\"klp\",\"klq\",\"klr\",\"kls\",\"klt\",\"klu\",\"klv\",\"klw\",\"klx\",\"kly\",\"klz\",\"kma\",\"kmb\",\"kmc\",\"kmd\",\"kme\",\"kmf\",\"kmg\",\"kmh\",\"kmi\",\"kmj\",\"kmk\",\"kml\",\"kmm\",\"kmn\",\"kmo\",\"kmp\",\"kmq\",\"kmr\",\"kms\",\"kmt\",\"kmu\",\"kmv\",\"kmw\",\"kmx\",\"kmy\",\"kmz\",\"kna\",\"knb\",\"knc\",\"knd\",\"kne\",\"knf\",\"kng\",\"kni\",\"knj\",\"knk\",\"knl\",\"knm\",\"knn\",\"kno\",\"knp\",\"knq\",\"knr\",\"kns\",\"knt\",\"knu\",\"knv\",\"knw\",\"knx\",\"kny\",\"knz\",\"koa\",\"koc\",\"kod\",\"koe\",\"kof\",\"kog\",\"koh\",\"koi\",\"koj\",\"kok\",\"kol\",\"koo\",\"kop\",\"koq\",\"kos\",\"kot\",\"kou\",\"kov\",\"kow\",\"kox\",\"koy\",\"koz\",\"kpa\",\"kpb\",\"kpc\",\"kpd\",\"kpe\",\"kpf\",\"kpg\",\"kph\",\"kpi\",\"kpj\",\"kpk\",\"kpl\",\"kpm\",\"kpn\",\"kpo\",\"kpp\",\"kpq\",\"kpr\",\"kps\",\"kpt\",\"kpu\",\"kpv\",\"kpw\",\"kpx\",\"kpy\",\"kpz\",\"kqa\",\"kqb\",\"kqc\",\"kqd\",\"kqe\",\"kqf\",\"kqg\",\"kqh\",\"kqi\",\"kqj\",\"kqk\",\"kql\",\"kqm\",\"kqn\",\"kqo\",\"kqp\",\"kqq\",\"kqr\",\"kqs\",\"kqt\",\"kqu\",\"kqv\",\"kqw\",\"kqx\",\"kqy\",\"kqz\",\"kra\",\"krb\",\"krc\",\"krd\",\"kre\",\"krf\",\"krh\",\"kri\",\"krj\",\"krk\",\"krl\",\"krm\",\"krn\",\"kro\",\"krp\",\"krr\",\"krs\",\"krt\",\"kru\",\"krv\",\"krw\",\"krx\",\"kry\",\"krz\",\"ksa\",\"ksb\",\"ksc\",\"ksd\",\"kse\",\"ksf\",\"ksg\",\"ksh\",\"ksi\",\"ksj\",\"ksk\",\"ksl\",\"ksm\",\"ksn\",\"kso\",\"ksp\",\"ksq\",\"ksr\",\"kss\",\"kst\",\"ksu\",\"ksv\",\"ksw\",\"ksx\",\"ksy\",\"ksz\",\"kta\",\"ktb\",\"ktc\",\"ktd\",\"kte\",\"ktf\",\"ktg\",\"kth\",\"kti\",\"ktj\",\"ktk\",\"ktl\",\"ktm\",\"ktn\",\"kto\",\"ktp\",\"ktq\",\"ktr\",\"kts\",\"ktt\",\"ktu\",\"ktv\",\"ktw\",\"ktx\",\"kty\",\"ktz\",\"kub\",\"kuc\",\"kud\",\"kue\",\"kuf\",\"kug\",\"kuh\",\"kui\",\"kuj\",\"kuk\",\"kul\",\"kum\",\"kun\",\"kuo\",\"kup\",\"kuq\",\"kus\",\"kut\",\"kuu\",\"kuv\",\"kuw\",\"kux\",\"kuy\",\"kuz\",\"kva\",\"kvb\",\"kvc\",\"kvd\",\"kve\",\"kvf\",\"kvg\",\"kvh\",\"kvi\",\"kvj\",\"kvk\",\"kvl\",\"kvm\",\"kvn\",\"kvo\",\"kvp\",\"kvq\",\"kvr\",\"kvs\",\"kvt\",\"kvu\",\"kvv\",\"kvw\",\"kvx\",\"kvy\",\"kvz\",\"kwa\",\"kwb\",\"kwc\",\"kwd\",\"kwe\",\"kwf\",\"kwg\",\"kwh\",\"kwi\",\"kwj\",\"kwk\",\"kwl\",\"kwm\",\"kwn\",\"kwo\",\"kwp\",\"kwq\",\"kwr\",\"kws\",\"kwt\",\"kwu\",\"kwv\",\"kww\",\"kwx\",\"kwy\",\"kwz\",\"kxa\",\"kxb\",\"kxc\",\"kxd\",\"kxe\",\"kxf\",\"kxh\",\"kxi\",\"kxj\",\"kxk\",\"kxl\",\"kxm\",\"kxn\",\"kxo\",\"kxp\",\"kxq\",\"kxr\",\"kxs\",\"kxt\",\"kxu\",\"kxv\",\"kxw\",\"kxx\",\"kxy\",\"kxz\",\"kya\",\"kyb\",\"kyc\",\"kyd\",\"kye\",\"kyf\",\"kyg\",\"kyh\",\"kyi\",\"kyj\",\"kyk\",\"kyl\",\"kym\",\"kyn\",\"kyo\",\"kyp\",\"kyq\",\"kyr\",\"kys\",\"kyt\",\"kyu\",\"kyv\",\"kyw\",\"kyx\",\"kyy\",\"kyz\",\"kza\",\"kzb\",\"kzc\",\"kzd\",\"kze\",\"kzf\",\"kzg\",\"kzh\",\"kzi\",\"kzj\",\"kzk\",\"kzl\",\"kzm\",\"kzn\",\"kzo\",\"kzp\",\"kzq\",\"kzr\",\"kzs\",\"kzt\",\"kzu\",\"kzv\",\"kzw\",\"kzx\",\"kzy\",\"kzz\",\"laa\",\"lab\",\"lac\",\"lad\",\"lae\",\"laf\",\"lag\",\"lah\",\"lai\",\"laj\",\"lak\",\"lal\",\"lam\",\"lan\",\"lap\",\"laq\",\"lar\",\"las\",\"lau\",\"law\",\"lax\",\"lay\",\"laz\",\"lba\",\"lbb\",\"lbc\",\"lbe\",\"lbf\",\"lbg\",\"lbi\",\"lbj\",\"lbk\",\"lbl\",\"lbm\",\"lbn\",\"lbo\",\"lbq\",\"lbr\",\"lbs\",\"lbt\",\"lbu\",\"lbv\",\"lbw\",\"lbx\",\"lby\",\"lbz\",\"lcc\",\"lcd\",\"lce\",\"lcf\",\"lch\",\"lcl\",\"lcm\",\"lcp\",\"lcq\",\"lcs\",\"lda\",\"ldb\",\"ldd\",\"ldg\",\"ldh\",\"ldi\",\"ldj\",\"ldk\",\"ldl\",\"ldm\",\"ldn\",\"ldo\",\"ldp\",\"ldq\",\"lea\",\"leb\",\"lec\",\"led\",\"lee\",\"lef\",\"leg\",\"leh\",\"lei\",\"lej\",\"lek\",\"lel\",\"lem\",\"len\",\"leo\",\"lep\",\"leq\",\"ler\",\"les\",\"let\",\"leu\",\"lev\",\"lew\",\"lex\",\"ley\",\"lez\",\"lfa\",\"lfn\",\"lga\",\"lgb\",\"lgg\",\"lgh\",\"lgi\",\"lgk\",\"lgl\",\"lgm\",\"lgn\",\"lgq\",\"lgr\",\"lgt\",\"lgu\",\"lgz\",\"lha\",\"lhh\",\"lhi\",\"lhl\",\"lhm\",\"lhn\",\"lhp\",\"lhs\",\"lht\",\"lhu\",\"lia\",\"lib\",\"lic\",\"lid\",\"lie\",\"lif\",\"lig\",\"lih\",\"lii\",\"lij\",\"lik\",\"lil\",\"lio\",\"lip\",\"liq\",\"lir\",\"lis\",\"liu\",\"liv\",\"liw\",\"lix\",\"liy\",\"liz\",\"lja\",\"lje\",\"lji\",\"ljl\",\"ljp\",\"ljw\",\"ljx\",\"lka\",\"lkb\",\"lkc\",\"lkd\",\"lke\",\"lkh\",\"lki\",\"lkj\",\"lkl\",\"lkm\",\"lkn\",\"lko\",\"lkr\",\"lks\",\"lkt\",\"lku\",\"lky\",\"lla\",\"llb\",\"llc\",\"lld\",\"lle\",\"llf\",\"llg\",\"llh\",\"lli\",\"llj\",\"llk\",\"lll\",\"llm\",\"lln\",\"llo\",\"llp\",\"llq\",\"lls\",\"llu\",\"llx\",\"lma\",\"lmb\",\"lmc\",\"lmd\",\"lme\",\"lmf\",\"lmg\",\"lmh\",\"lmi\",\"lmj\",\"lmk\",\"lml\",\"lmm\",\"lmn\",\"lmo\",\"lmp\",\"lmq\",\"lmr\",\"lmu\",\"lmv\",\"lmw\",\"lmx\",\"lmy\",\"lmz\",\"lna\",\"lnb\",\"lnd\",\"lng\",\"lnh\",\"lni\",\"lnj\",\"lnl\",\"lnm\",\"lnn\",\"lno\",\"lns\",\"lnu\",\"lnw\",\"lnz\",\"loa\",\"lob\",\"loc\",\"loe\",\"lof\",\"log\",\"loh\",\"loi\",\"loj\",\"lok\",\"lol\",\"lom\",\"lon\",\"loo\",\"lop\",\"loq\",\"lor\",\"los\",\"lot\",\"lou\",\"lov\",\"low\",\"lox\",\"loy\",\"loz\",\"lpa\",\"lpe\",\"lpn\",\"lpo\",\"lpx\",\"lra\",\"lrc\",\"lre\",\"lrg\",\"lri\",\"lrk\",\"lrl\",\"lrm\",\"lrn\",\"lro\",\"lrr\",\"lrt\",\"lrv\",\"lrz\",\"lsa\",\"lsd\",\"lse\",\"lsg\",\"lsh\",\"lsi\",\"lsl\",\"lsm\",\"lso\",\"lsp\",\"lsr\",\"lss\",\"lst\",\"lsy\",\"ltc\",\"ltg\",\"lti\",\"ltn\",\"lto\",\"lts\",\"ltu\",\"lua\",\"luc\",\"lud\",\"lue\",\"luf\",\"lui\",\"luj\",\"luk\",\"lul\",\"lum\",\"lun\",\"luo\",\"lup\",\"luq\",\"lur\",\"lus\",\"lut\",\"luu\",\"luv\",\"luw\",\"luy\",\"luz\",\"lva\",\"lvk\",\"lvs\",\"lvu\",\"lwa\",\"lwe\",\"lwg\",\"lwh\",\"lwl\",\"lwm\",\"lwo\",\"lwt\",\"lwu\",\"lww\",\"lya\",\"lyg\",\"lyn\",\"lzh\",\"lzl\",\"lzn\",\"lzz\",\"maa\",\"mab\",\"mad\",\"mae\",\"maf\",\"mag\",\"mai\",\"maj\",\"mak\",\"mam\",\"man\",\"map\",\"maq\",\"mas\",\"mat\",\"mau\",\"mav\",\"maw\",\"max\",\"maz\",\"mba\",\"mbb\",\"mbc\",\"mbd\",\"mbe\",\"mbf\",\"mbh\",\"mbi\",\"mbj\",\"mbk\",\"mbl\",\"mbm\",\"mbn\",\"mbo\",\"mbp\",\"mbq\",\"mbr\",\"mbs\",\"mbt\",\"mbu\",\"mbv\",\"mbw\",\"mbx\",\"mby\",\"mbz\",\"mca\",\"mcb\",\"mcc\",\"mcd\",\"mce\",\"mcf\",\"mcg\",\"mch\",\"mci\",\"mcj\",\"mck\",\"mcl\",\"mcm\",\"mcn\",\"mco\",\"mcp\",\"mcq\",\"mcr\",\"mcs\",\"mct\",\"mcu\",\"mcv\",\"mcw\",\"mcx\",\"mcy\",\"mcz\",\"mda\",\"mdb\",\"mdc\",\"mdd\",\"mde\",\"mdf\",\"mdg\",\"mdh\",\"mdi\",\"mdj\",\"mdk\",\"mdl\",\"mdm\",\"mdn\",\"mdp\",\"mdq\",\"mdr\",\"mds\",\"mdt\",\"mdu\",\"mdv\",\"mdw\",\"mdx\",\"mdy\",\"mdz\",\"mea\",\"meb\",\"mec\",\"med\",\"mee\",\"mef\",\"meg\",\"meh\",\"mei\",\"mej\",\"mek\",\"mel\",\"mem\",\"men\",\"meo\",\"mep\",\"meq\",\"mer\",\"mes\",\"met\",\"meu\",\"mev\",\"mew\",\"mey\",\"mez\",\"mfa\",\"mfb\",\"mfc\",\"mfd\",\"mfe\",\"mff\",\"mfg\",\"mfh\",\"mfi\",\"mfj\",\"mfk\",\"mfl\",\"mfm\",\"mfn\",\"mfo\",\"mfp\",\"mfq\",\"mfr\",\"mfs\",\"mft\",\"mfu\",\"mfv\",\"mfw\",\"mfx\",\"mfy\",\"mfz\",\"mga\",\"mgb\",\"mgc\",\"mgd\",\"mge\",\"mgf\",\"mgg\",\"mgh\",\"mgi\",\"mgj\",\"mgk\",\"mgl\",\"mgm\",\"mgn\",\"mgo\",\"mgp\",\"mgq\",\"mgr\",\"mgs\",\"mgt\",\"mgu\",\"mgv\",\"mgw\",\"mgx\",\"mgy\",\"mgz\",\"mha\",\"mhb\",\"mhc\",\"mhd\",\"mhe\",\"mhf\",\"mhg\",\"mhh\",\"mhi\",\"mhj\",\"mhk\",\"mhl\",\"mhm\",\"mhn\",\"mho\",\"mhp\",\"mhq\",\"mhr\",\"mhs\",\"mht\",\"mhu\",\"mhw\",\"mhx\",\"mhy\",\"mhz\",\"mia\",\"mib\",\"mic\",\"mid\",\"mie\",\"mif\",\"mig\",\"mih\",\"mii\",\"mij\",\"mik\",\"mil\",\"mim\",\"min\",\"mio\",\"mip\",\"miq\",\"mir\",\"mis\",\"mit\",\"miu\",\"miw\",\"mix\",\"miy\",\"miz\",\"mja\",\"mjb\",\"mjc\",\"mjd\",\"mje\",\"mjg\",\"mjh\",\"mji\",\"mjj\",\"mjk\",\"mjl\",\"mjm\",\"mjn\",\"mjo\",\"mjp\",\"mjq\",\"mjr\",\"mjs\",\"mjt\",\"mju\",\"mjv\",\"mjw\",\"mjx\",\"mjy\",\"mjz\",\"mka\",\"mkb\",\"mkc\",\"mke\",\"mkf\",\"mkg\",\"mkh\",\"mki\",\"mkj\",\"mkk\",\"mkl\",\"mkm\",\"mkn\",\"mko\",\"mkp\",\"mkq\",\"mkr\",\"mks\",\"mkt\",\"mku\",\"mkv\",\"mkw\",\"mkx\",\"mky\",\"mkz\",\"mla\",\"mlb\",\"mlc\",\"mld\",\"mle\",\"mlf\",\"mlh\",\"mli\",\"mlj\",\"mlk\",\"mll\",\"mlm\",\"mln\",\"mlo\",\"mlp\",\"mlq\",\"mlr\",\"mls\",\"mlu\",\"mlv\",\"mlw\",\"mlx\",\"mlz\",\"mma\",\"mmb\",\"mmc\",\"mmd\",\"mme\",\"mmf\",\"mmg\",\"mmh\",\"mmi\",\"mmj\",\"mmk\",\"mml\",\"mmm\",\"mmn\",\"mmo\",\"mmp\",\"mmq\",\"mmr\",\"mmt\",\"mmu\",\"mmv\",\"mmw\",\"mmx\",\"mmy\",\"mmz\",\"mna\",\"mnb\",\"mnc\",\"mnd\",\"mne\",\"mnf\",\"mng\",\"mnh\",\"mni\",\"mnj\",\"mnk\",\"mnl\",\"mnm\",\"mnn\",\"mno\",\"mnp\",\"mnq\",\"mnr\",\"mns\",\"mnt\",\"mnu\",\"mnv\",\"mnw\",\"mnx\",\"mny\",\"mnz\",\"moa\",\"moc\",\"mod\",\"moe\",\"mof\",\"mog\",\"moh\",\"moi\",\"moj\",\"mok\",\"mom\",\"moo\",\"mop\",\"moq\",\"mor\",\"mos\",\"mot\",\"mou\",\"mov\",\"mow\",\"mox\",\"moy\",\"moz\",\"mpa\",\"mpb\",\"mpc\",\"mpd\",\"mpe\",\"mpg\",\"mph\",\"mpi\",\"mpj\",\"mpk\",\"mpl\",\"mpm\",\"mpn\",\"mpo\",\"mpp\",\"mpq\",\"mpr\",\"mps\",\"mpt\",\"mpu\",\"mpv\",\"mpw\",\"mpx\",\"mpy\",\"mpz\",\"mqa\",\"mqb\",\"mqc\",\"mqe\",\"mqf\",\"mqg\",\"mqh\",\"mqi\",\"mqj\",\"mqk\",\"mql\",\"mqm\",\"mqn\",\"mqo\",\"mqp\",\"mqq\",\"mqr\",\"mqs\",\"mqt\",\"mqu\",\"mqv\",\"mqw\",\"mqx\",\"mqy\",\"mqz\",\"mra\",\"mrb\",\"mrc\",\"mrd\",\"mre\",\"mrf\",\"mrg\",\"mrh\",\"mrj\",\"mrk\",\"mrl\",\"mrm\",\"mrn\",\"mro\",\"mrp\",\"mrq\",\"mrr\",\"mrs\",\"mrt\",\"mru\",\"mrv\",\"mrw\",\"mrx\",\"mry\",\"mrz\",\"msb\",\"msc\",\"msd\",\"mse\",\"msf\",\"msg\",\"msh\",\"msi\",\"msj\",\"msk\",\"msl\",\"msm\",\"msn\",\"mso\",\"msp\",\"msq\",\"msr\",\"mss\",\"mst\",\"msu\",\"msv\",\"msw\",\"msx\",\"msy\",\"msz\",\"mta\",\"mtb\",\"mtc\",\"mtd\",\"mte\",\"mtf\",\"mtg\",\"mth\",\"mti\",\"mtj\",\"mtk\",\"mtl\",\"mtm\",\"mtn\",\"mto\",\"mtp\",\"mtq\",\"mtr\",\"mts\",\"mtt\",\"mtu\",\"mtv\",\"mtw\",\"mtx\",\"mty\",\"mua\",\"mub\",\"muc\",\"mud\",\"mue\",\"mug\",\"muh\",\"mui\",\"muj\",\"muk\",\"mul\",\"mum\",\"mun\",\"muo\",\"mup\",\"muq\",\"mur\",\"mus\",\"mut\",\"muu\",\"muv\",\"mux\",\"muy\",\"muz\",\"mva\",\"mvb\",\"mvd\",\"mve\",\"mvf\",\"mvg\",\"mvh\",\"mvi\",\"mvk\",\"mvl\",\"mvm\",\"mvn\",\"mvo\",\"mvp\",\"mvq\",\"mvr\",\"mvs\",\"mvt\",\"mvu\",\"mvv\",\"mvw\",\"mvx\",\"mvy\",\"mvz\",\"mwa\",\"mwb\",\"mwc\",\"mwd\",\"mwe\",\"mwf\",\"mwg\",\"mwh\",\"mwi\",\"mwj\",\"mwk\",\"mwl\",\"mwm\",\"mwn\",\"mwo\",\"mwp\",\"mwq\",\"mwr\",\"mws\",\"mwt\",\"mwu\",\"mwv\",\"mww\",\"mwx\",\"mwy\",\"mwz\",\"mxa\",\"mxb\",\"mxc\",\"mxd\",\"mxe\",\"mxf\",\"mxg\",\"mxh\",\"mxi\",\"mxj\",\"mxk\",\"mxl\",\"mxm\",\"mxn\",\"mxo\",\"mxp\",\"mxq\",\"mxr\",\"mxs\",\"mxt\",\"mxu\",\"mxv\",\"mxw\",\"mxx\",\"mxy\",\"mxz\",\"myb\",\"myc\",\"myd\",\"mye\",\"myf\",\"myg\",\"myh\",\"myi\",\"myj\",\"myk\",\"myl\",\"mym\",\"myn\",\"myo\",\"myp\",\"myq\",\"myr\",\"mys\",\"myt\",\"myu\",\"myv\",\"myw\",\"myx\",\"myy\",\"myz\",\"mza\",\"mzb\",\"mzc\",\"mzd\",\"mze\",\"mzg\",\"mzh\",\"mzi\",\"mzj\",\"mzk\",\"mzl\",\"mzm\",\"mzn\",\"mzo\",\"mzp\",\"mzq\",\"mzr\",\"mzs\",\"mzt\",\"mzu\",\"mzv\",\"mzw\",\"mzx\",\"mzy\",\"mzz\",\"naa\",\"nab\",\"nac\",\"nad\",\"nae\",\"naf\",\"nag\",\"nah\",\"nai\",\"naj\",\"nak\",\"nal\",\"nam\",\"nan\",\"nao\",\"nap\",\"naq\",\"nar\",\"nas\",\"nat\",\"naw\",\"nax\",\"nay\",\"naz\",\"nba\",\"nbb\",\"nbc\",\"nbd\",\"nbe\",\"nbf\",\"nbg\",\"nbh\",\"nbi\",\"nbj\",\"nbk\",\"nbm\",\"nbn\",\"nbo\",\"nbp\",\"nbq\",\"nbr\",\"nbs\",\"nbt\",\"nbu\",\"nbv\",\"nbw\",\"nbx\",\"nby\",\"nca\",\"ncb\",\"ncc\",\"ncd\",\"nce\",\"ncf\",\"ncg\",\"nch\",\"nci\",\"ncj\",\"nck\",\"ncl\",\"ncm\",\"ncn\",\"nco\",\"ncp\",\"ncr\",\"ncs\",\"nct\",\"ncu\",\"ncx\",\"ncz\",\"nda\",\"ndb\",\"ndc\",\"ndd\",\"ndf\",\"ndg\",\"ndh\",\"ndi\",\"ndj\",\"ndk\",\"ndl\",\"ndm\",\"ndn\",\"ndp\",\"ndq\",\"ndr\",\"nds\",\"ndt\",\"ndu\",\"ndv\",\"ndw\",\"ndx\",\"ndy\",\"ndz\",\"nea\",\"neb\",\"nec\",\"ned\",\"nee\",\"nef\",\"neg\",\"neh\",\"nei\",\"nej\",\"nek\",\"nem\",\"nen\",\"neo\",\"neq\",\"ner\",\"nes\",\"net\",\"neu\",\"nev\",\"new\",\"nex\",\"ney\",\"nez\",\"nfa\",\"nfd\",\"nfl\",\"nfr\",\"nfu\",\"nga\",\"ngb\",\"ngc\",\"ngd\",\"nge\",\"ngf\",\"ngg\",\"ngh\",\"ngi\",\"ngj\",\"ngk\",\"ngl\",\"ngm\",\"ngn\",\"ngo\",\"ngp\",\"ngq\",\"ngr\",\"ngs\",\"ngt\",\"ngu\",\"ngv\",\"ngw\",\"ngx\",\"ngy\",\"ngz\",\"nha\",\"nhb\",\"nhc\",\"nhd\",\"nhe\",\"nhf\",\"nhg\",\"nhh\",\"nhi\",\"nhk\",\"nhm\",\"nhn\",\"nho\",\"nhp\",\"nhq\",\"nhr\",\"nht\",\"nhu\",\"nhv\",\"nhw\",\"nhx\",\"nhy\",\"nhz\",\"nia\",\"nib\",\"nic\",\"nid\",\"nie\",\"nif\",\"nig\",\"nih\",\"nii\",\"nij\",\"nik\",\"nil\",\"nim\",\"nin\",\"nio\",\"niq\",\"nir\",\"nis\",\"nit\",\"niu\",\"niv\",\"niw\",\"nix\",\"niy\",\"niz\",\"nja\",\"njb\",\"njd\",\"njh\",\"nji\",\"njj\",\"njl\",\"njm\",\"njn\",\"njo\",\"njr\",\"njs\",\"njt\",\"nju\",\"njx\",\"njy\",\"njz\",\"nka\",\"nkb\",\"nkc\",\"nkd\",\"nke\",\"nkf\",\"nkg\",\"nkh\",\"nki\",\"nkj\",\"nkk\",\"nkm\",\"nkn\",\"nko\",\"nkp\",\"nkq\",\"nkr\",\"nks\",\"nkt\",\"nku\",\"nkv\",\"nkw\",\"nkx\",\"nkz\",\"nla\",\"nlc\",\"nle\",\"nlg\",\"nli\",\"nlj\",\"nlk\",\"nll\",\"nln\",\"nlo\",\"nlq\",\"nlr\",\"nlu\",\"nlv\",\"nlw\",\"nlx\",\"nly\",\"nlz\",\"nma\",\"nmb\",\"nmc\",\"nmd\",\"nme\",\"nmf\",\"nmg\",\"nmh\",\"nmi\",\"nmj\",\"nmk\",\"nml\",\"nmm\",\"nmn\",\"nmo\",\"nmp\",\"nmq\",\"nmr\",\"nms\",\"nmt\",\"nmu\",\"nmv\",\"nmw\",\"nmx\",\"nmy\",\"nmz\",\"nna\",\"nnb\",\"nnc\",\"nnd\",\"nne\",\"nnf\",\"nng\",\"nnh\",\"nni\",\"nnj\",\"nnk\",\"nnl\",\"nnm\",\"nnn\",\"nnp\",\"nnq\",\"nnr\",\"nns\",\"nnt\",\"nnu\",\"nnv\",\"nnw\",\"nnx\",\"nny\",\"nnz\",\"noa\",\"noc\",\"nod\",\"noe\",\"nof\",\"nog\",\"noh\",\"noi\",\"noj\",\"nok\",\"nol\",\"nom\",\"non\",\"noo\",\"nop\",\"noq\",\"nos\",\"not\",\"nou\",\"nov\",\"now\",\"noy\",\"noz\",\"npa\",\"npb\",\"npg\",\"nph\",\"npi\",\"npl\",\"npn\",\"npo\",\"nps\",\"npu\",\"npy\",\"nqg\",\"nqk\",\"nqm\",\"nqn\",\"nqo\",\"nqq\",\"nqy\",\"nra\",\"nrb\",\"nrc\",\"nre\",\"nrf\",\"nrg\",\"nri\",\"nrk\",\"nrl\",\"nrm\",\"nrn\",\"nrp\",\"nrr\",\"nrt\",\"nru\",\"nrx\",\"nrz\",\"nsa\",\"nsc\",\"nsd\",\"nse\",\"nsf\",\"nsg\",\"nsh\",\"nsi\",\"nsk\",\"nsl\",\"nsm\",\"nsn\",\"nso\",\"nsp\",\"nsq\",\"nsr\",\"nss\",\"nst\",\"nsu\",\"nsv\",\"nsw\",\"nsx\",\"nsy\",\"nsz\",\"ntd\",\"nte\",\"ntg\",\"nti\",\"ntj\",\"ntk\",\"ntm\",\"nto\",\"ntp\",\"ntr\",\"nts\",\"ntu\",\"ntw\",\"ntx\",\"nty\",\"ntz\",\"nua\",\"nub\",\"nuc\",\"nud\",\"nue\",\"nuf\",\"nug\",\"nuh\",\"nui\",\"nuj\",\"nuk\",\"nul\",\"num\",\"nun\",\"nuo\",\"nup\",\"nuq\",\"nur\",\"nus\",\"nut\",\"nuu\",\"nuv\",\"nuw\",\"nux\",\"nuy\",\"nuz\",\"nvh\",\"nvm\",\"nvo\",\"nwa\",\"nwb\",\"nwc\",\"nwe\",\"nwg\",\"nwi\",\"nwm\",\"nwo\",\"nwr\",\"nwx\",\"nwy\",\"nxa\",\"nxd\",\"nxe\",\"nxg\",\"nxi\",\"nxk\",\"nxl\",\"nxm\",\"nxn\",\"nxo\",\"nxq\",\"nxr\",\"nxu\",\"nxx\",\"nyb\",\"nyc\",\"nyd\",\"nye\",\"nyf\",\"nyg\",\"nyh\",\"nyi\",\"nyj\",\"nyk\",\"nyl\",\"nym\",\"nyn\",\"nyo\",\"nyp\",\"nyq\",\"nyr\",\"nys\",\"nyt\",\"nyu\",\"nyv\",\"nyw\",\"nyx\",\"nyy\",\"nza\",\"nzb\",\"nzi\",\"nzk\",\"nzm\",\"nzs\",\"nzu\",\"nzy\",\"nzz\",\"oaa\",\"oac\",\"oar\",\"oav\",\"obi\",\"obk\",\"obl\",\"obm\",\"obo\",\"obr\",\"obt\",\"obu\",\"oca\",\"och\",\"oco\",\"ocu\",\"oda\",\"odk\",\"odt\",\"odu\",\"ofo\",\"ofs\",\"ofu\",\"ogb\",\"ogc\",\"oge\",\"ogg\",\"ogo\",\"ogu\",\"oht\",\"ohu\",\"oia\",\"oin\",\"ojb\",\"ojc\",\"ojg\",\"ojp\",\"ojs\",\"ojv\",\"ojw\",\"oka\",\"okb\",\"okd\",\"oke\",\"okg\",\"okh\",\"oki\",\"okj\",\"okk\",\"okl\",\"okm\",\"okn\",\"oko\",\"okr\",\"oks\",\"oku\",\"okv\",\"okx\",\"ola\",\"old\",\"ole\",\"olk\",\"olm\",\"olo\",\"olr\",\"olt\",\"olu\",\"oma\",\"omb\",\"omc\",\"ome\",\"omg\",\"omi\",\"omk\",\"oml\",\"omn\",\"omo\",\"omp\",\"omq\",\"omr\",\"omt\",\"omu\",\"omv\",\"omw\",\"omx\",\"ona\",\"onb\",\"one\",\"ong\",\"oni\",\"onj\",\"onk\",\"onn\",\"ono\",\"onp\",\"onr\",\"ons\",\"ont\",\"onu\",\"onw\",\"onx\",\"ood\",\"oog\",\"oon\",\"oor\",\"oos\",\"opa\",\"opk\",\"opm\",\"opo\",\"opt\",\"opy\",\"ora\",\"orc\",\"ore\",\"org\",\"orh\",\"orn\",\"oro\",\"orr\",\"ors\",\"ort\",\"oru\",\"orv\",\"orw\",\"orx\",\"ory\",\"orz\",\"osa\",\"osc\",\"osi\",\"oso\",\"osp\",\"ost\",\"osu\",\"osx\",\"ota\",\"otb\",\"otd\",\"ote\",\"oti\",\"otk\",\"otl\",\"otm\",\"otn\",\"oto\",\"otq\",\"otr\",\"ots\",\"ott\",\"otu\",\"otw\",\"otx\",\"oty\",\"otz\",\"oua\",\"oub\",\"oue\",\"oui\",\"oum\",\"oun\",\"ovd\",\"owi\",\"owl\",\"oyb\",\"oyd\",\"oym\",\"oyy\",\"ozm\",\"paa\",\"pab\",\"pac\",\"pad\",\"pae\",\"paf\",\"pag\",\"pah\",\"pai\",\"pak\",\"pal\",\"pam\",\"pao\",\"pap\",\"paq\",\"par\",\"pas\",\"pat\",\"pau\",\"pav\",\"paw\",\"pax\",\"pay\",\"paz\",\"pbb\",\"pbc\",\"pbe\",\"pbf\",\"pbg\",\"pbh\",\"pbi\",\"pbl\",\"pbn\",\"pbo\",\"pbp\",\"pbr\",\"pbs\",\"pbt\",\"pbu\",\"pbv\",\"pby\",\"pbz\",\"pca\",\"pcb\",\"pcc\",\"pcd\",\"pce\",\"pcf\",\"pcg\",\"pch\",\"pci\",\"pcj\",\"pck\",\"pcl\",\"pcm\",\"pcn\",\"pcp\",\"pcr\",\"pcw\",\"pda\",\"pdc\",\"pdi\",\"pdn\",\"pdo\",\"pdt\",\"pdu\",\"pea\",\"peb\",\"ped\",\"pee\",\"pef\",\"peg\",\"peh\",\"pei\",\"pej\",\"pek\",\"pel\",\"pem\",\"peo\",\"pep\",\"peq\",\"pes\",\"pev\",\"pex\",\"pey\",\"pez\",\"pfa\",\"pfe\",\"pfl\",\"pga\",\"pgd\",\"pgg\",\"pgi\",\"pgk\",\"pgl\",\"pgn\",\"pgs\",\"pgu\",\"pgy\",\"pgz\",\"pha\",\"phd\",\"phg\",\"phh\",\"phi\",\"phk\",\"phl\",\"phm\",\"phn\",\"pho\",\"phq\",\"phr\",\"pht\",\"phu\",\"phv\",\"phw\",\"pia\",\"pib\",\"pic\",\"pid\",\"pie\",\"pif\",\"pig\",\"pih\",\"pii\",\"pij\",\"pil\",\"pim\",\"pin\",\"pio\",\"pip\",\"pir\",\"pis\",\"pit\",\"piu\",\"piv\",\"piw\",\"pix\",\"piy\",\"piz\",\"pjt\",\"pka\",\"pkb\",\"pkc\",\"pkg\",\"pkh\",\"pkn\",\"pko\",\"pkp\",\"pkr\",\"pks\",\"pkt\",\"pku\",\"pla\",\"plb\",\"plc\",\"pld\",\"ple\",\"plf\",\"plg\",\"plh\",\"plj\",\"plk\",\"pll\",\"pln\",\"plo\",\"plp\",\"plq\",\"plr\",\"pls\",\"plt\",\"plu\",\"plv\",\"plw\",\"ply\",\"plz\",\"pma\",\"pmb\",\"pmc\",\"pmd\",\"pme\",\"pmf\",\"pmh\",\"pmi\",\"pmj\",\"pmk\",\"pml\",\"pmm\",\"pmn\",\"pmo\",\"pmq\",\"pmr\",\"pms\",\"pmt\",\"pmu\",\"pmw\",\"pmx\",\"pmy\",\"pmz\",\"pna\",\"pnb\",\"pnc\",\"pne\",\"png\",\"pnh\",\"pni\",\"pnj\",\"pnk\",\"pnl\",\"pnm\",\"pnn\",\"pno\",\"pnp\",\"pnq\",\"pnr\",\"pns\",\"pnt\",\"pnu\",\"pnv\",\"pnw\",\"pnx\",\"pny\",\"pnz\",\"poc\",\"pod\",\"poe\",\"pof\",\"pog\",\"poh\",\"poi\",\"pok\",\"pom\",\"pon\",\"poo\",\"pop\",\"poq\",\"pos\",\"pot\",\"pov\",\"pow\",\"pox\",\"poy\",\"poz\",\"ppa\",\"ppe\",\"ppi\",\"ppk\",\"ppl\",\"ppm\",\"ppn\",\"ppo\",\"ppp\",\"ppq\",\"ppr\",\"pps\",\"ppt\",\"ppu\",\"pqa\",\"pqe\",\"pqm\",\"pqw\",\"pra\",\"prb\",\"prc\",\"prd\",\"pre\",\"prf\",\"prg\",\"prh\",\"pri\",\"prk\",\"prl\",\"prm\",\"prn\",\"pro\",\"prp\",\"prq\",\"prr\",\"prs\",\"prt\",\"pru\",\"prw\",\"prx\",\"pry\",\"prz\",\"psa\",\"psc\",\"psd\",\"pse\",\"psg\",\"psh\",\"psi\",\"psl\",\"psm\",\"psn\",\"pso\",\"psp\",\"psq\",\"psr\",\"pss\",\"pst\",\"psu\",\"psw\",\"psy\",\"pta\",\"pth\",\"pti\",\"ptn\",\"pto\",\"ptp\",\"ptq\",\"ptr\",\"ptt\",\"ptu\",\"ptv\",\"ptw\",\"pty\",\"pua\",\"pub\",\"puc\",\"pud\",\"pue\",\"puf\",\"pug\",\"pui\",\"puj\",\"puk\",\"pum\",\"puo\",\"pup\",\"puq\",\"pur\",\"put\",\"puu\",\"puw\",\"pux\",\"puy\",\"puz\",\"pwa\",\"pwb\",\"pwg\",\"pwi\",\"pwm\",\"pwn\",\"pwo\",\"pwr\",\"pww\",\"pxm\",\"pye\",\"pym\",\"pyn\",\"pys\",\"pyu\",\"pyx\",\"pyy\",\"pzn\",\"qaa..qtz\",\"qua\",\"qub\",\"quc\",\"qud\",\"quf\",\"qug\",\"quh\",\"qui\",\"quk\",\"qul\",\"qum\",\"qun\",\"qup\",\"quq\",\"qur\",\"qus\",\"quv\",\"quw\",\"qux\",\"quy\",\"quz\",\"qva\",\"qvc\",\"qve\",\"qvh\",\"qvi\",\"qvj\",\"qvl\",\"qvm\",\"qvn\",\"qvo\",\"qvp\",\"qvs\",\"qvw\",\"qvy\",\"qvz\",\"qwa\",\"qwc\",\"qwe\",\"qwh\",\"qwm\",\"qws\",\"qwt\",\"qxa\",\"qxc\",\"qxh\",\"qxl\",\"qxn\",\"qxo\",\"qxp\",\"qxq\",\"qxr\",\"qxs\",\"qxt\",\"qxu\",\"qxw\",\"qya\",\"qyp\",\"raa\",\"rab\",\"rac\",\"rad\",\"raf\",\"rag\",\"rah\",\"rai\",\"raj\",\"rak\",\"ral\",\"ram\",\"ran\",\"rao\",\"rap\",\"raq\",\"rar\",\"ras\",\"rat\",\"rau\",\"rav\",\"raw\",\"rax\",\"ray\",\"raz\",\"rbb\",\"rbk\",\"rbl\",\"rbp\",\"rcf\",\"rdb\",\"rea\",\"reb\",\"ree\",\"reg\",\"rei\",\"rej\",\"rel\",\"rem\",\"ren\",\"rer\",\"res\",\"ret\",\"rey\",\"rga\",\"rge\",\"rgk\",\"rgn\",\"rgr\",\"rgs\",\"rgu\",\"rhg\",\"rhp\",\"ria\",\"rie\",\"rif\",\"ril\",\"rim\",\"rin\",\"rir\",\"rit\",\"riu\",\"rjg\",\"rji\",\"rjs\",\"rka\",\"rkb\",\"rkh\",\"rki\",\"rkm\",\"rkt\",\"rkw\",\"rma\",\"rmb\",\"rmc\",\"rmd\",\"rme\",\"rmf\",\"rmg\",\"rmh\",\"rmi\",\"rmk\",\"rml\",\"rmm\",\"rmn\",\"rmo\",\"rmp\",\"rmq\",\"rmr\",\"rms\",\"rmt\",\"rmu\",\"rmv\",\"rmw\",\"rmx\",\"rmy\",\"rmz\",\"rna\",\"rnd\",\"rng\",\"rnl\",\"rnn\",\"rnp\",\"rnr\",\"rnw\",\"roa\",\"rob\",\"roc\",\"rod\",\"roe\",\"rof\",\"rog\",\"rol\",\"rom\",\"roo\",\"rop\",\"ror\",\"rou\",\"row\",\"rpn\",\"rpt\",\"rri\",\"rro\",\"rrt\",\"rsb\",\"rsi\",\"rsl\",\"rsm\",\"rtc\",\"rth\",\"rtm\",\"rts\",\"rtw\",\"rub\",\"ruc\",\"rue\",\"ruf\",\"rug\",\"ruh\",\"rui\",\"ruk\",\"ruo\",\"rup\",\"ruq\",\"rut\",\"ruu\",\"ruy\",\"ruz\",\"rwa\",\"rwk\",\"rwm\",\"rwo\",\"rwr\",\"rxd\",\"rxw\",\"ryn\",\"rys\",\"ryu\",\"rzh\",\"saa\",\"sab\",\"sac\",\"sad\",\"sae\",\"saf\",\"sah\",\"sai\",\"saj\",\"sak\",\"sal\",\"sam\",\"sao\",\"sap\",\"saq\",\"sar\",\"sas\",\"sat\",\"sau\",\"sav\",\"saw\",\"sax\",\"say\",\"saz\",\"sba\",\"sbb\",\"sbc\",\"sbd\",\"sbe\",\"sbf\",\"sbg\",\"sbh\",\"sbi\",\"sbj\",\"sbk\",\"sbl\",\"sbm\",\"sbn\",\"sbo\",\"sbp\",\"sbq\",\"sbr\",\"sbs\",\"sbt\",\"sbu\",\"sbv\",\"sbw\",\"sbx\",\"sby\",\"sbz\",\"sca\",\"scb\",\"sce\",\"scf\",\"scg\",\"sch\",\"sci\",\"sck\",\"scl\",\"scn\",\"sco\",\"scp\",\"scq\",\"scs\",\"scu\",\"scv\",\"scw\",\"scx\",\"sda\",\"sdb\",\"sdc\",\"sde\",\"sdf\",\"sdg\",\"sdh\",\"sdj\",\"sdk\",\"sdl\",\"sdm\",\"sdn\",\"sdo\",\"sdp\",\"sdr\",\"sds\",\"sdt\",\"sdu\",\"sdv\",\"sdx\",\"sdz\",\"sea\",\"seb\",\"sec\",\"sed\",\"see\",\"sef\",\"seg\",\"seh\",\"sei\",\"sej\",\"sek\",\"sel\",\"sem\",\"sen\",\"seo\",\"sep\",\"seq\",\"ser\",\"ses\",\"set\",\"seu\",\"sev\",\"sew\",\"sey\",\"sez\",\"sfb\",\"sfe\",\"sfm\",\"sfs\",\"sfw\",\"sga\",\"sgb\",\"sgc\",\"sgd\",\"sge\",\"sgg\",\"sgh\",\"sgi\",\"sgj\",\"sgk\",\"sgl\",\"sgm\",\"sgn\",\"sgo\",\"sgp\",\"sgr\",\"sgs\",\"sgt\",\"sgu\",\"sgw\",\"sgx\",\"sgy\",\"sgz\",\"sha\",\"shb\",\"shc\",\"shd\",\"she\",\"shg\",\"shh\",\"shi\",\"shj\",\"shk\",\"shl\",\"shm\",\"shn\",\"sho\",\"shp\",\"shq\",\"shr\",\"shs\",\"sht\",\"shu\",\"shv\",\"shw\",\"shx\",\"shy\",\"shz\",\"sia\",\"sib\",\"sid\",\"sie\",\"sif\",\"sig\",\"sih\",\"sii\",\"sij\",\"sik\",\"sil\",\"sim\",\"sio\",\"sip\",\"siq\",\"sir\",\"sis\",\"sit\",\"siu\",\"siv\",\"siw\",\"six\",\"siy\",\"siz\",\"sja\",\"sjb\",\"sjd\",\"sje\",\"sjg\",\"sjk\",\"sjl\",\"sjm\",\"sjn\",\"sjo\",\"sjp\",\"sjr\",\"sjs\",\"sjt\",\"sju\",\"sjw\",\"ska\",\"skb\",\"skc\",\"skd\",\"ske\",\"skf\",\"skg\",\"skh\",\"ski\",\"skj\",\"skk\",\"skm\",\"skn\",\"sko\",\"skp\",\"skq\",\"skr\",\"sks\",\"skt\",\"sku\",\"skv\",\"skw\",\"skx\",\"sky\",\"skz\",\"sla\",\"slc\",\"sld\",\"sle\",\"slf\",\"slg\",\"slh\",\"sli\",\"slj\",\"sll\",\"slm\",\"sln\",\"slp\",\"slq\",\"slr\",\"sls\",\"slt\",\"slu\",\"slw\",\"slx\",\"sly\",\"slz\",\"sma\",\"smb\",\"smc\",\"smd\",\"smf\",\"smg\",\"smh\",\"smi\",\"smj\",\"smk\",\"sml\",\"smm\",\"smn\",\"smp\",\"smq\",\"smr\",\"sms\",\"smt\",\"smu\",\"smv\",\"smw\",\"smx\",\"smy\",\"smz\",\"snb\",\"snc\",\"sne\",\"snf\",\"sng\",\"snh\",\"sni\",\"snj\",\"snk\",\"snl\",\"snm\",\"snn\",\"sno\",\"snp\",\"snq\",\"snr\",\"sns\",\"snu\",\"snv\",\"snw\",\"snx\",\"sny\",\"snz\",\"soa\",\"sob\",\"soc\",\"sod\",\"soe\",\"sog\",\"soh\",\"soi\",\"soj\",\"sok\",\"sol\",\"son\",\"soo\",\"sop\",\"soq\",\"sor\",\"sos\",\"sou\",\"sov\",\"sow\",\"sox\",\"soy\",\"soz\",\"spb\",\"spc\",\"spd\",\"spe\",\"spg\",\"spi\",\"spk\",\"spl\",\"spm\",\"spn\",\"spo\",\"spp\",\"spq\",\"spr\",\"sps\",\"spt\",\"spu\",\"spv\",\"spx\",\"spy\",\"sqa\",\"sqh\",\"sqj\",\"sqk\",\"sqm\",\"sqn\",\"sqo\",\"sqq\",\"sqr\",\"sqs\",\"sqt\",\"squ\",\"sra\",\"srb\",\"src\",\"sre\",\"srf\",\"srg\",\"srh\",\"sri\",\"srk\",\"srl\",\"srm\",\"srn\",\"sro\",\"srq\",\"srr\",\"srs\",\"srt\",\"sru\",\"srv\",\"srw\",\"srx\",\"sry\",\"srz\",\"ssa\",\"ssb\",\"ssc\",\"ssd\",\"sse\",\"ssf\",\"ssg\",\"ssh\",\"ssi\",\"ssj\",\"ssk\",\"ssl\",\"ssm\",\"ssn\",\"sso\",\"ssp\",\"ssq\",\"ssr\",\"sss\",\"sst\",\"ssu\",\"ssv\",\"ssx\",\"ssy\",\"ssz\",\"sta\",\"stb\",\"std\",\"ste\",\"stf\",\"stg\",\"sth\",\"sti\",\"stj\",\"stk\",\"stl\",\"stm\",\"stn\",\"sto\",\"stp\",\"stq\",\"str\",\"sts\",\"stt\",\"stu\",\"stv\",\"stw\",\"sty\",\"sua\",\"sub\",\"suc\",\"sue\",\"sug\",\"sui\",\"suj\",\"suk\",\"sul\",\"sum\",\"suq\",\"sur\",\"sus\",\"sut\",\"suv\",\"suw\",\"sux\",\"suy\",\"suz\",\"sva\",\"svb\",\"svc\",\"sve\",\"svk\",\"svm\",\"svr\",\"svs\",\"svx\",\"swb\",\"swc\",\"swf\",\"swg\",\"swh\",\"swi\",\"swj\",\"swk\",\"swl\",\"swm\",\"swn\",\"swo\",\"swp\",\"swq\",\"swr\",\"sws\",\"swt\",\"swu\",\"swv\",\"sww\",\"swx\",\"swy\",\"sxb\",\"sxc\",\"sxe\",\"sxg\",\"sxk\",\"sxl\",\"sxm\",\"sxn\",\"sxo\",\"sxr\",\"sxs\",\"sxu\",\"sxw\",\"sya\",\"syb\",\"syc\",\"syd\",\"syi\",\"syk\",\"syl\",\"sym\",\"syn\",\"syo\",\"syr\",\"sys\",\"syw\",\"syx\",\"syy\",\"sza\",\"szb\",\"szc\",\"szd\",\"sze\",\"szg\",\"szl\",\"szn\",\"szp\",\"szv\",\"szw\",\"taa\",\"tab\",\"tac\",\"tad\",\"tae\",\"taf\",\"tag\",\"tai\",\"taj\",\"tak\",\"tal\",\"tan\",\"tao\",\"tap\",\"taq\",\"tar\",\"tas\",\"tau\",\"tav\",\"taw\",\"tax\",\"tay\",\"taz\",\"tba\",\"tbb\",\"tbc\",\"tbd\",\"tbe\",\"tbf\",\"tbg\",\"tbh\",\"tbi\",\"tbj\",\"tbk\",\"tbl\",\"tbm\",\"tbn\",\"tbo\",\"tbp\",\"tbq\",\"tbr\",\"tbs\",\"tbt\",\"tbu\",\"tbv\",\"tbw\",\"tbx\",\"tby\",\"tbz\",\"tca\",\"tcb\",\"tcc\",\"tcd\",\"tce\",\"tcf\",\"tcg\",\"tch\",\"tci\",\"tck\",\"tcl\",\"tcm\",\"tcn\",\"tco\",\"tcp\",\"tcq\",\"tcs\",\"tct\",\"tcu\",\"tcw\",\"tcx\",\"tcy\",\"tcz\",\"tda\",\"tdb\",\"tdc\",\"tdd\",\"tde\",\"tdf\",\"tdg\",\"tdh\",\"tdi\",\"tdj\",\"tdk\",\"tdl\",\"tdm\",\"tdn\",\"tdo\",\"tdq\",\"tdr\",\"tds\",\"tdt\",\"tdu\",\"tdv\",\"tdx\",\"tdy\",\"tea\",\"teb\",\"tec\",\"ted\",\"tee\",\"tef\",\"teg\",\"teh\",\"tei\",\"tek\",\"tem\",\"ten\",\"teo\",\"tep\",\"teq\",\"ter\",\"tes\",\"tet\",\"teu\",\"tev\",\"tew\",\"tex\",\"tey\",\"tfi\",\"tfn\",\"tfo\",\"tfr\",\"tft\",\"tga\",\"tgb\",\"tgc\",\"tgd\",\"tge\",\"tgf\",\"tgg\",\"tgh\",\"tgi\",\"tgj\",\"tgn\",\"tgo\",\"tgp\",\"tgq\",\"tgr\",\"tgs\",\"tgt\",\"tgu\",\"tgv\",\"tgw\",\"tgx\",\"tgy\",\"tgz\",\"thc\",\"thd\",\"the\",\"thf\",\"thh\",\"thi\",\"thk\",\"thl\",\"thm\",\"thn\",\"thp\",\"thq\",\"thr\",\"ths\",\"tht\",\"thu\",\"thv\",\"thw\",\"thx\",\"thy\",\"thz\",\"tia\",\"tic\",\"tid\",\"tie\",\"tif\",\"tig\",\"tih\",\"tii\",\"tij\",\"tik\",\"til\",\"tim\",\"tin\",\"tio\",\"tip\",\"tiq\",\"tis\",\"tit\",\"tiu\",\"tiv\",\"tiw\",\"tix\",\"tiy\",\"tiz\",\"tja\",\"tjg\",\"tji\",\"tjl\",\"tjm\",\"tjn\",\"tjo\",\"tjs\",\"tju\",\"tjw\",\"tka\",\"tkb\",\"tkd\",\"tke\",\"tkf\",\"tkg\",\"tkk\",\"tkl\",\"tkm\",\"tkn\",\"tkp\",\"tkq\",\"tkr\",\"tks\",\"tkt\",\"tku\",\"tkv\",\"tkw\",\"tkx\",\"tkz\",\"tla\",\"tlb\",\"tlc\",\"tld\",\"tlf\",\"tlg\",\"tlh\",\"tli\",\"tlj\",\"tlk\",\"tll\",\"tlm\",\"tln\",\"tlo\",\"tlp\",\"tlq\",\"tlr\",\"tls\",\"tlt\",\"tlu\",\"tlv\",\"tlw\",\"tlx\",\"tly\",\"tma\",\"tmb\",\"tmc\",\"tmd\",\"tme\",\"tmf\",\"tmg\",\"tmh\",\"tmi\",\"tmj\",\"tmk\",\"tml\",\"tmm\",\"tmn\",\"tmo\",\"tmp\",\"tmq\",\"tmr\",\"tms\",\"tmt\",\"tmu\",\"tmv\",\"tmw\",\"tmy\",\"tmz\",\"tna\",\"tnb\",\"tnc\",\"tnd\",\"tne\",\"tnf\",\"tng\",\"tnh\",\"tni\",\"tnk\",\"tnl\",\"tnm\",\"tnn\",\"tno\",\"tnp\",\"tnq\",\"tnr\",\"tns\",\"tnt\",\"tnu\",\"tnv\",\"tnw\",\"tnx\",\"tny\",\"tnz\",\"tob\",\"toc\",\"tod\",\"toe\",\"tof\",\"tog\",\"toh\",\"toi\",\"toj\",\"tol\",\"tom\",\"too\",\"top\",\"toq\",\"tor\",\"tos\",\"tou\",\"tov\",\"tow\",\"tox\",\"toy\",\"toz\",\"tpa\",\"tpc\",\"tpe\",\"tpf\",\"tpg\",\"tpi\",\"tpj\",\"tpk\",\"tpl\",\"tpm\",\"tpn\",\"tpo\",\"tpp\",\"tpq\",\"tpr\",\"tpt\",\"tpu\",\"tpv\",\"tpw\",\"tpx\",\"tpy\",\"tpz\",\"tqb\",\"tql\",\"tqm\",\"tqn\",\"tqo\",\"tqp\",\"tqq\",\"tqr\",\"tqt\",\"tqu\",\"tqw\",\"tra\",\"trb\",\"trc\",\"trd\",\"tre\",\"trf\",\"trg\",\"trh\",\"tri\",\"trj\",\"trk\",\"trl\",\"trm\",\"trn\",\"tro\",\"trp\",\"trq\",\"trr\",\"trs\",\"trt\",\"tru\",\"trv\",\"trw\",\"trx\",\"try\",\"trz\",\"tsa\",\"tsb\",\"tsc\",\"tsd\",\"tse\",\"tsf\",\"tsg\",\"tsh\",\"tsi\",\"tsj\",\"tsk\",\"tsl\",\"tsm\",\"tsp\",\"tsq\",\"tsr\",\"tss\",\"tst\",\"tsu\",\"tsv\",\"tsw\",\"tsx\",\"tsy\",\"tsz\",\"tta\",\"ttb\",\"ttc\",\"ttd\",\"tte\",\"ttf\",\"ttg\",\"tth\",\"tti\",\"ttj\",\"ttk\",\"ttl\",\"ttm\",\"ttn\",\"tto\",\"ttp\",\"ttq\",\"ttr\",\"tts\",\"ttt\",\"ttu\",\"ttv\",\"ttw\",\"tty\",\"ttz\",\"tua\",\"tub\",\"tuc\",\"tud\",\"tue\",\"tuf\",\"tug\",\"tuh\",\"tui\",\"tuj\",\"tul\",\"tum\",\"tun\",\"tuo\",\"tup\",\"tuq\",\"tus\",\"tut\",\"tuu\",\"tuv\",\"tuw\",\"tux\",\"tuy\",\"tuz\",\"tva\",\"tvd\",\"tve\",\"tvk\",\"tvl\",\"tvm\",\"tvn\",\"tvo\",\"tvs\",\"tvt\",\"tvu\",\"tvw\",\"tvy\",\"twa\",\"twb\",\"twc\",\"twd\",\"twe\",\"twf\",\"twg\",\"twh\",\"twl\",\"twm\",\"twn\",\"two\",\"twp\",\"twq\",\"twr\",\"twt\",\"twu\",\"tww\",\"twx\",\"twy\",\"txa\",\"txb\",\"txc\",\"txe\",\"txg\",\"txh\",\"txi\",\"txj\",\"txm\",\"txn\",\"txo\",\"txq\",\"txr\",\"txs\",\"txt\",\"txu\",\"txx\",\"txy\",\"tya\",\"tye\",\"tyh\",\"tyi\",\"tyj\",\"tyl\",\"tyn\",\"typ\",\"tyr\",\"tys\",\"tyt\",\"tyu\",\"tyv\",\"tyx\",\"tyz\",\"tza\",\"tzh\",\"tzj\",\"tzl\",\"tzm\",\"tzn\",\"tzo\",\"tzx\",\"uam\",\"uan\",\"uar\",\"uba\",\"ubi\",\"ubl\",\"ubr\",\"ubu\",\"uby\",\"uda\",\"ude\",\"udg\",\"udi\",\"udj\",\"udl\",\"udm\",\"udu\",\"ues\",\"ufi\",\"uga\",\"ugb\",\"uge\",\"ugn\",\"ugo\",\"ugy\",\"uha\",\"uhn\",\"uis\",\"uiv\",\"uji\",\"uka\",\"ukg\",\"ukh\",\"ukl\",\"ukp\",\"ukq\",\"uks\",\"uku\",\"ukw\",\"uky\",\"ula\",\"ulb\",\"ulc\",\"ule\",\"ulf\",\"uli\",\"ulk\",\"ull\",\"ulm\",\"uln\",\"ulu\",\"ulw\",\"uma\",\"umb\",\"umc\",\"umd\",\"umg\",\"umi\",\"umm\",\"umn\",\"umo\",\"ump\",\"umr\",\"ums\",\"umu\",\"una\",\"und\",\"une\",\"ung\",\"unk\",\"unm\",\"unn\",\"unp\",\"unr\",\"unu\",\"unx\",\"unz\",\"uok\",\"upi\",\"upv\",\"ura\",\"urb\",\"urc\",\"ure\",\"urf\",\"urg\",\"urh\",\"uri\",\"urj\",\"urk\",\"url\",\"urm\",\"urn\",\"uro\",\"urp\",\"urr\",\"urt\",\"uru\",\"urv\",\"urw\",\"urx\",\"ury\",\"urz\",\"usa\",\"ush\",\"usi\",\"usk\",\"usp\",\"usu\",\"uta\",\"ute\",\"utp\",\"utr\",\"utu\",\"uum\",\"uun\",\"uur\",\"uuu\",\"uve\",\"uvh\",\"uvl\",\"uwa\",\"uya\",\"uzn\",\"uzs\",\"vaa\",\"vae\",\"vaf\",\"vag\",\"vah\",\"vai\",\"vaj\",\"val\",\"vam\",\"van\",\"vao\",\"vap\",\"var\",\"vas\",\"vau\",\"vav\",\"vay\",\"vbb\",\"vbk\",\"vec\",\"ved\",\"vel\",\"vem\",\"veo\",\"vep\",\"ver\",\"vgr\",\"vgt\",\"vic\",\"vid\",\"vif\",\"vig\",\"vil\",\"vin\",\"vis\",\"vit\",\"viv\",\"vka\",\"vki\",\"vkj\",\"vkk\",\"vkl\",\"vkm\",\"vko\",\"vkp\",\"vkt\",\"vku\",\"vlp\",\"vls\",\"vma\",\"vmb\",\"vmc\",\"vmd\",\"vme\",\"vmf\",\"vmg\",\"vmh\",\"vmi\",\"vmj\",\"vmk\",\"vml\",\"vmm\",\"vmp\",\"vmq\",\"vmr\",\"vms\",\"vmu\",\"vmv\",\"vmw\",\"vmx\",\"vmy\",\"vmz\",\"vnk\",\"vnm\",\"vnp\",\"vor\",\"vot\",\"vra\",\"vro\",\"vrs\",\"vrt\",\"vsi\",\"vsl\",\"vsv\",\"vto\",\"vum\",\"vun\",\"vut\",\"vwa\",\"waa\",\"wab\",\"wac\",\"wad\",\"wae\",\"waf\",\"wag\",\"wah\",\"wai\",\"waj\",\"wak\",\"wal\",\"wam\",\"wan\",\"wao\",\"wap\",\"waq\",\"war\",\"was\",\"wat\",\"wau\",\"wav\",\"waw\",\"wax\",\"way\",\"waz\",\"wba\",\"wbb\",\"wbe\",\"wbf\",\"wbh\",\"wbi\",\"wbj\",\"wbk\",\"wbl\",\"wbm\",\"wbp\",\"wbq\",\"wbr\",\"wbt\",\"wbv\",\"wbw\",\"wca\",\"wci\",\"wdd\",\"wdg\",\"wdj\",\"wdk\",\"wdu\",\"wdy\",\"wea\",\"wec\",\"wed\",\"weg\",\"weh\",\"wei\",\"wem\",\"wen\",\"weo\",\"wep\",\"wer\",\"wes\",\"wet\",\"weu\",\"wew\",\"wfg\",\"wga\",\"wgb\",\"wgg\",\"wgi\",\"wgo\",\"wgu\",\"wgw\",\"wgy\",\"wha\",\"whg\",\"whk\",\"whu\",\"wib\",\"wic\",\"wie\",\"wif\",\"wig\",\"wih\",\"wii\",\"wij\",\"wik\",\"wil\",\"wim\",\"win\",\"wir\",\"wit\",\"wiu\",\"wiv\",\"wiw\",\"wiy\",\"wja\",\"wji\",\"wka\",\"wkb\",\"wkd\",\"wkl\",\"wku\",\"wkw\",\"wky\",\"wla\",\"wlc\",\"wle\",\"wlg\",\"wli\",\"wlk\",\"wll\",\"wlm\",\"wlo\",\"wlr\",\"wls\",\"wlu\",\"wlv\",\"wlw\",\"wlx\",\"wly\",\"wma\",\"wmb\",\"wmc\",\"wmd\",\"wme\",\"wmh\",\"wmi\",\"wmm\",\"wmn\",\"wmo\",\"wms\",\"wmt\",\"wmw\",\"wmx\",\"wnb\",\"wnc\",\"wnd\",\"wne\",\"wng\",\"wni\",\"wnk\",\"wnm\",\"wnn\",\"wno\",\"wnp\",\"wnu\",\"wnw\",\"wny\",\"woa\",\"wob\",\"woc\",\"wod\",\"woe\",\"wof\",\"wog\",\"woi\",\"wok\",\"wom\",\"won\",\"woo\",\"wor\",\"wos\",\"wow\",\"woy\",\"wpc\",\"wra\",\"wrb\",\"wrd\",\"wrg\",\"wrh\",\"wri\",\"wrk\",\"wrl\",\"wrm\",\"wrn\",\"wro\",\"wrp\",\"wrr\",\"wrs\",\"wru\",\"wrv\",\"wrw\",\"wrx\",\"wry\",\"wrz\",\"wsa\",\"wsg\",\"wsi\",\"wsk\",\"wsr\",\"wss\",\"wsu\",\"wsv\",\"wtf\",\"wth\",\"wti\",\"wtk\",\"wtm\",\"wtw\",\"wua\",\"wub\",\"wud\",\"wuh\",\"wul\",\"wum\",\"wun\",\"wur\",\"wut\",\"wuu\",\"wuv\",\"wux\",\"wuy\",\"wwa\",\"wwb\",\"wwo\",\"wwr\",\"www\",\"wxa\",\"wxw\",\"wya\",\"wyb\",\"wyi\",\"wym\",\"wyr\",\"wyy\",\"xaa\",\"xab\",\"xac\",\"xad\",\"xae\",\"xag\",\"xai\",\"xaj\",\"xak\",\"xal\",\"xam\",\"xan\",\"xao\",\"xap\",\"xaq\",\"xar\",\"xas\",\"xat\",\"xau\",\"xav\",\"xaw\",\"xay\",\"xba\",\"xbb\",\"xbc\",\"xbd\",\"xbe\",\"xbg\",\"xbi\",\"xbj\",\"xbm\",\"xbn\",\"xbo\",\"xbp\",\"xbr\",\"xbw\",\"xbx\",\"xby\",\"xcb\",\"xcc\",\"xce\",\"xcg\",\"xch\",\"xcl\",\"xcm\",\"xcn\",\"xco\",\"xcr\",\"xct\",\"xcu\",\"xcv\",\"xcw\",\"xcy\",\"xda\",\"xdc\",\"xdk\",\"xdm\",\"xdy\",\"xeb\",\"xed\",\"xeg\",\"xel\",\"xem\",\"xep\",\"xer\",\"xes\",\"xet\",\"xeu\",\"xfa\",\"xga\",\"xgb\",\"xgd\",\"xgf\",\"xgg\",\"xgi\",\"xgl\",\"xgm\",\"xgn\",\"xgr\",\"xgu\",\"xgw\",\"xha\",\"xhc\",\"xhd\",\"xhe\",\"xhr\",\"xht\",\"xhu\",\"xhv\",\"xia\",\"xib\",\"xii\",\"xil\",\"xin\",\"xip\",\"xir\",\"xis\",\"xiv\",\"xiy\",\"xjb\",\"xjt\",\"xka\",\"xkb\",\"xkc\",\"xkd\",\"xke\",\"xkf\",\"xkg\",\"xkh\",\"xki\",\"xkj\",\"xkk\",\"xkl\",\"xkn\",\"xko\",\"xkp\",\"xkq\",\"xkr\",\"xks\",\"xkt\",\"xku\",\"xkv\",\"xkw\",\"xkx\",\"xky\",\"xkz\",\"xla\",\"xlb\",\"xlc\",\"xld\",\"xle\",\"xlg\",\"xli\",\"xln\",\"xlo\",\"xlp\",\"xls\",\"xlu\",\"xly\",\"xma\",\"xmb\",\"xmc\",\"xmd\",\"xme\",\"xmf\",\"xmg\",\"xmh\",\"xmj\",\"xmk\",\"xml\",\"xmm\",\"xmn\",\"xmo\",\"xmp\",\"xmq\",\"xmr\",\"xms\",\"xmt\",\"xmu\",\"xmv\",\"xmw\",\"xmx\",\"xmy\",\"xmz\",\"xna\",\"xnb\",\"xnd\",\"xng\",\"xnh\",\"xni\",\"xnk\",\"xnn\",\"xno\",\"xnr\",\"xns\",\"xnt\",\"xnu\",\"xny\",\"xnz\",\"xoc\",\"xod\",\"xog\",\"xoi\",\"xok\",\"xom\",\"xon\",\"xoo\",\"xop\",\"xor\",\"xow\",\"xpa\",\"xpc\",\"xpe\",\"xpg\",\"xpi\",\"xpj\",\"xpk\",\"xpm\",\"xpn\",\"xpo\",\"xpp\",\"xpq\",\"xpr\",\"xps\",\"xpt\",\"xpu\",\"xpy\",\"xqa\",\"xqt\",\"xra\",\"xrb\",\"xrd\",\"xre\",\"xrg\",\"xri\",\"xrm\",\"xrn\",\"xrq\",\"xrr\",\"xrt\",\"xru\",\"xrw\",\"xsa\",\"xsb\",\"xsc\",\"xsd\",\"xse\",\"xsh\",\"xsi\",\"xsj\",\"xsl\",\"xsm\",\"xsn\",\"xso\",\"xsp\",\"xsq\",\"xsr\",\"xss\",\"xsu\",\"xsv\",\"xsy\",\"xta\",\"xtb\",\"xtc\",\"xtd\",\"xte\",\"xtg\",\"xth\",\"xti\",\"xtj\",\"xtl\",\"xtm\",\"xtn\",\"xto\",\"xtp\",\"xtq\",\"xtr\",\"xts\",\"xtt\",\"xtu\",\"xtv\",\"xtw\",\"xty\",\"xtz\",\"xua\",\"xub\",\"xud\",\"xug\",\"xuj\",\"xul\",\"xum\",\"xun\",\"xuo\",\"xup\",\"xur\",\"xut\",\"xuu\",\"xve\",\"xvi\",\"xvn\",\"xvo\",\"xvs\",\"xwa\",\"xwc\",\"xwd\",\"xwe\",\"xwg\",\"xwj\",\"xwk\",\"xwl\",\"xwo\",\"xwr\",\"xwt\",\"xww\",\"xxb\",\"xxk\",\"xxm\",\"xxr\",\"xxt\",\"xya\",\"xyb\",\"xyj\",\"xyk\",\"xyl\",\"xyt\",\"xyy\",\"xzh\",\"xzm\",\"xzp\",\"yaa\",\"yab\",\"yac\",\"yad\",\"yae\",\"yaf\",\"yag\",\"yah\",\"yai\",\"yaj\",\"yak\",\"yal\",\"yam\",\"yan\",\"yao\",\"yap\",\"yaq\",\"yar\",\"yas\",\"yat\",\"yau\",\"yav\",\"yaw\",\"yax\",\"yay\",\"yaz\",\"yba\",\"ybb\",\"ybd\",\"ybe\",\"ybh\",\"ybi\",\"ybj\",\"ybk\",\"ybl\",\"ybm\",\"ybn\",\"ybo\",\"ybx\",\"yby\",\"ych\",\"ycl\",\"ycn\",\"ycp\",\"yda\",\"ydd\",\"yde\",\"ydg\",\"ydk\",\"yds\",\"yea\",\"yec\",\"yee\",\"yei\",\"yej\",\"yel\",\"yen\",\"yer\",\"yes\",\"yet\",\"yeu\",\"yev\",\"yey\",\"yga\",\"ygi\",\"ygl\",\"ygm\",\"ygp\",\"ygr\",\"ygs\",\"ygu\",\"ygw\",\"yha\",\"yhd\",\"yhl\",\"yhs\",\"yia\",\"yif\",\"yig\",\"yih\",\"yii\",\"yij\",\"yik\",\"yil\",\"yim\",\"yin\",\"yip\",\"yiq\",\"yir\",\"yis\",\"yit\",\"yiu\",\"yiv\",\"yix\",\"yiy\",\"yiz\",\"yka\",\"ykg\",\"yki\",\"ykk\",\"ykl\",\"ykm\",\"ykn\",\"yko\",\"ykr\",\"ykt\",\"yku\",\"yky\",\"yla\",\"ylb\",\"yle\",\"ylg\",\"yli\",\"yll\",\"ylm\",\"yln\",\"ylo\",\"ylr\",\"ylu\",\"yly\",\"yma\",\"ymb\",\"ymc\",\"ymd\",\"yme\",\"ymg\",\"ymh\",\"ymi\",\"ymk\",\"yml\",\"ymm\",\"ymn\",\"ymo\",\"ymp\",\"ymq\",\"ymr\",\"yms\",\"ymt\",\"ymx\",\"ymz\",\"yna\",\"ynd\",\"yne\",\"yng\",\"ynh\",\"ynk\",\"ynl\",\"ynn\",\"yno\",\"ynq\",\"yns\",\"ynu\",\"yob\",\"yog\",\"yoi\",\"yok\",\"yol\",\"yom\",\"yon\",\"yos\",\"yot\",\"yox\",\"yoy\",\"ypa\",\"ypb\",\"ypg\",\"yph\",\"ypk\",\"ypm\",\"ypn\",\"ypo\",\"ypp\",\"ypz\",\"yra\",\"yrb\",\"yre\",\"yri\",\"yrk\",\"yrl\",\"yrm\",\"yrn\",\"yro\",\"yrs\",\"yrw\",\"yry\",\"ysc\",\"ysd\",\"ysg\",\"ysl\",\"ysn\",\"yso\",\"ysp\",\"ysr\",\"yss\",\"ysy\",\"yta\",\"ytl\",\"ytp\",\"ytw\",\"yty\",\"yua\",\"yub\",\"yuc\",\"yud\",\"yue\",\"yuf\",\"yug\",\"yui\",\"yuj\",\"yuk\",\"yul\",\"yum\",\"yun\",\"yup\",\"yuq\",\"yur\",\"yut\",\"yuu\",\"yuw\",\"yux\",\"yuy\",\"yuz\",\"yva\",\"yvt\",\"ywa\",\"ywg\",\"ywl\",\"ywn\",\"ywq\",\"ywr\",\"ywt\",\"ywu\",\"yww\",\"yxa\",\"yxg\",\"yxl\",\"yxm\",\"yxu\",\"yxy\",\"yyr\",\"yyu\",\"yyz\",\"yzg\",\"yzk\",\"zaa\",\"zab\",\"zac\",\"zad\",\"zae\",\"zaf\",\"zag\",\"zah\",\"zai\",\"zaj\",\"zak\",\"zal\",\"zam\",\"zao\",\"zap\",\"zaq\",\"zar\",\"zas\",\"zat\",\"zau\",\"zav\",\"zaw\",\"zax\",\"zay\",\"zaz\",\"zbc\",\"zbe\",\"zbl\",\"zbt\",\"zbw\",\"zca\",\"zch\",\"zdj\",\"zea\",\"zeg\",\"zeh\",\"zen\",\"zga\",\"zgb\",\"zgh\",\"zgm\",\"zgn\",\"zgr\",\"zhb\",\"zhd\",\"zhi\",\"zhn\",\"zhw\",\"zhx\",\"zia\",\"zib\",\"zik\",\"zil\",\"zim\",\"zin\",\"zir\",\"ziw\",\"ziz\",\"zka\",\"zkb\",\"zkd\",\"zkg\",\"zkh\",\"zkk\",\"zkn\",\"zko\",\"zkp\",\"zkr\",\"zkt\",\"zku\",\"zkv\",\"zkz\",\"zle\",\"zlj\",\"zlm\",\"zln\",\"zlq\",\"zls\",\"zlw\",\"zma\",\"zmb\",\"zmc\",\"zmd\",\"zme\",\"zmf\",\"zmg\",\"zmh\",\"zmi\",\"zmj\",\"zmk\",\"zml\",\"zmm\",\"zmn\",\"zmo\",\"zmp\",\"zmq\",\"zmr\",\"zms\",\"zmt\",\"zmu\",\"zmv\",\"zmw\",\"zmx\",\"zmy\",\"zmz\",\"zna\",\"znd\",\"zne\",\"zng\",\"znk\",\"zns\",\"zoc\",\"zoh\",\"zom\",\"zoo\",\"zoq\",\"zor\",\"zos\",\"zpa\",\"zpb\",\"zpc\",\"zpd\",\"zpe\",\"zpf\",\"zpg\",\"zph\",\"zpi\",\"zpj\",\"zpk\",\"zpl\",\"zpm\",\"zpn\",\"zpo\",\"zpp\",\"zpq\",\"zpr\",\"zps\",\"zpt\",\"zpu\",\"zpv\",\"zpw\",\"zpx\",\"zpy\",\"zpz\",\"zqe\",\"zra\",\"zrg\",\"zrn\",\"zro\",\"zrp\",\"zrs\",\"zsa\",\"zsk\",\"zsl\",\"zsm\",\"zsr\",\"zsu\",\"zte\",\"ztg\",\"ztl\",\"ztm\",\"ztn\",\"ztp\",\"ztq\",\"zts\",\"ztt\",\"ztu\",\"ztx\",\"zty\",\"zua\",\"zuh\",\"zum\",\"zun\",\"zuy\",\"zwa\",\"zxx\",\"zyb\",\"zyg\",\"zyj\",\"zyn\",\"zyp\",\"zza\",\"zzj\"],\nid:\"valid-lang\"}]},{id:\"video-caption\",selector:\"video\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag122\",\"wcag123\",\"section508\",\"section508.22.a\"],all:[],any:[],none:[\"caption\"]},{id:\"video-description\",selector:\"video\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2aa\",\"wcag125\",\"section508\",\"section508.22.b\"],all:[],any:[],none:[\"description\"]}],checks:[{id:\"abstractrole\",evaluate:function(a,b){return\"abstract\"===axe.commons.aria.getRoleType(a.getAttribute(\"role\"))}},{id:\"aria-allowed-attr\",evaluate:function(a,b){var c,d,e,f=[],g=a.getAttribute(\"role\"),h=a.attributes;if(g||(g=axe.commons.aria.implicitRole(a)),e=axe.commons.aria.allowedAttr(g),g&&e)for(var i=0,j=h.length;i<j;i++)c=h[i],d=c.name,axe.commons.aria.validateAttr(d)&&-1===e.indexOf(d)&&f.push(d+'=\"'+c.nodeValue+'\"');return!f.length||(this.data(f),!1)}},{id:\"invalidrole\",evaluate:function(a,b){return!axe.commons.aria.isValidRole(a.getAttribute(\"role\"))}},{id:\"aria-required-attr\",evaluate:function(a,b){var c=[];if(a.hasAttributes()){var d,e=a.getAttribute(\"role\"),f=axe.commons.aria.requiredAttr(e);if(e&&f)for(var g=0,h=f.length;g<h;g++)d=f[g],a.getAttribute(d)||c.push(d)}return!c.length||(this.data(c),!1)}},{id:\"aria-required-children\",evaluate:function(a,b){function c(a,b,c){if(null===a)return!1;var d=f(b),e=['[role=\"'+b+'\"]'];return d&&(e=e.concat(d)),e=e.join(\",\"),c?g(a,e)||!!a.querySelector(e):!!a.querySelector(e)}function d(a,b){var d,e;for(d=0,e=a.length;d<e;d++)if(null!==a[d]&&c(a[d],b,!0))return!0;return!1}var e=axe.commons.aria.requiredOwned,f=axe.commons.aria.implicitNodes,g=axe.commons.utils.matchesSelector,h=axe.commons.dom.idrefs,i=a.getAttribute(\"role\"),j=e(i);if(!j)return!0;var k=!1,l=j.one;if(!l){var k=!0;l=j.all}var m=function(a,b,e){var f,g=b.length,i=[],j=h(a,\"aria-owns\");for(f=0;f<g;f++){var k=b[f];if(c(a,k)||d(j,k)){if(!e)return null}else e&&i.push(k)}return i.length?i:!e&&b.length?b:null}(a,l,k);return!m||(this.data(m),!1)}},{id:\"aria-required-parent\",evaluate:function(a,b){function c(a){return(axe.commons.aria.implicitNodes(a)||[]).concat('[role=\"'+a+'\"]').join(\",\")}function d(a,b,d){var e,f,g=a.getAttribute(\"role\"),h=[];if(b||(b=axe.commons.aria.requiredContext(g)),!b)return null;for(e=0,f=b.length;e<f;e++){if(d&&axe.utils.matchesSelector(a,c(b[e])))return null;if(axe.commons.dom.findUp(a,c(b[e])))return null;h.push(b[e])}return h}var e=d(a);if(!e)return!0;var f=function(a){for(var b=[],c=null;a;)a.id&&(c=document.querySelector(\"[aria-owns~=\"+axe.commons.utils.escapeSelector(a.id)+\"]\"))&&b.push(c),a=a.parentNode;return b.length?b:null}(a);if(f)for(var g=0,h=f.length;g<h;g++)if(!(e=d(f[g],e,!0)))return!0;return this.data(e),!1}},{id:\"aria-valid-attr-value\",evaluate:function(a,b){b=Array.isArray(b)?b:[];for(var c,d,e=[],f=/^aria-/,g=a.attributes,h=0,i=g.length;h<i;h++)c=g[h],d=c.name,-1===b.indexOf(d)&&f.test(d)&&!axe.commons.aria.validateAttrValue(a,d)&&e.push(d+'=\"'+c.nodeValue+'\"');return!e.length||(this.data(e),!1)},options:[]},{id:\"aria-valid-attr\",evaluate:function(a,b){b=Array.isArray(b)?b:[];for(var c,d=[],e=/^aria-/,f=a.attributes,g=0,h=f.length;g<h;g++)c=f[g].name,-1===b.indexOf(c)&&e.test(c)&&!axe.commons.aria.validateAttr(c)&&d.push(c);return!d.length||(this.data(d),!1)},options:[]},{id:\"color-contrast\",evaluate:function(a,b){if(!axe.commons.dom.isVisible(a,!1))return!0;var c=!!(b||{}).noScroll,d=[],e=axe.commons.color.getBackgroundColor(a,d,c),f=axe.commons.color.getForegroundColor(a,c),g=window.getComputedStyle(a),h=parseFloat(g.getPropertyValue(\"font-size\")),i=g.getPropertyValue(\"font-weight\"),j=-1!==[\"bold\",\"bolder\",\"600\",\"700\",\"800\",\"900\"].indexOf(i),k=axe.commons.color.hasValidContrastRatio(e,f,h,j),l=Math.floor(100*k.contrastRatio)/100,m=[];null===f&&m.push(axe.commons.color.incompleteData.get(\"fgColor\")),null===e&&m.push(axe.commons.color.incompleteData.get(\"bgColor\"));var n={fgColor:f?f.toHexString():void 0,bgColor:e?e.toHexString():void 0,contrastRatio:k?l:void 0,fontSize:(72*h/96).toFixed(1)+\"pt\",fontWeight:j?\"bold\":\"normal\",missingData:m};return this.data(n),k.isValid||this.relatedNodes(d),null===f||null===e?(m=[],void axe.commons.color.incompleteData.clear()):k.isValid}},{id:\"link-in-text-block\",evaluate:function(a,b){function c(a,b){var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(c,d)+.05)/(Math.min(c,d)+.05)}function d(a){var b=window.getComputedStyle(a).getPropertyValue(\"display\");return-1!==f.indexOf(b)||\"table-\"===b.substr(0,6)}var e=axe.commons.color,f=[\"block\",\"list-item\",\"table\",\"flex\",\"grid\",\"inline-block\"];if(d(a))return!1;for(var g=a.parentNode;1===g.nodeType&&!d(g);)g=g.parentNode;if(e.elementIsDistinct(a,g))return!0;var h,i;if(h=e.getForegroundColor(a),i=e.getForegroundColor(g),h&&i){var j=c(h,i);if(1===j)return!0;if(j>=3)return axe.commons.color.incompleteData.set(\"fgColor\",{reason:\"bgContrast\"}),this.data({missingData:[axe.commons.color.incompleteData.get(\"fgColor\")]}),void axe.commons.color.incompleteData.clear();if(h=e.getBackgroundColor(a),i=e.getBackgroundColor(g),!h||!i||c(h,i)>=3){var k=void 0;return k=h&&i?\"bgContrast\":axe.commons.color.incompleteData.get(\"bgColor\").reason,axe.commons.color.incompleteData.set(\"fgColor\",{reason:k}),this.data({missingData:[axe.commons.color.incompleteData.get(\"fgColor\")]}),void axe.commons.color.incompleteData.clear()}return!1}}},{id:\"fieldset\",evaluate:function(a,b){function c(a,b){return axe.commons.utils.toArray(a.querySelectorAll('select,textarea,button,input:not([name=\"'+b+'\"]):not([type=\"hidden\"])'))}function d(a,b){var d=a.firstElementChild;if(!d||\"LEGEND\"!==d.nodeName.toUpperCase())return h.relatedNodes([a]),g=\"no-legend\",!1;if(!axe.commons.text.accessibleText(d))return h.relatedNodes([d]),g=\"empty-legend\",!1;var e=c(a,b);return!e.length||(h.relatedNodes(e),g=\"mixed-inputs\",!1)}function e(a,b){var d=axe.commons.dom.idrefs(a,\"aria-labelledby\").some(function(a){return a&&axe.commons.text.accessibleText(a)}),e=a.getAttribute(\"aria-label\");if(!(d||e&&axe.commons.text.sanitize(e)))return h.relatedNodes(a),g=\"no-group-label\",!1;var f=c(a,b);return!f.length||(h.relatedNodes(f),g=\"group-mixed-inputs\",!1)}function f(a,b){return axe.commons.utils.toArray(a).filter(function(a){return a!==b})}var g,h=this,i={name:a.getAttribute(\"name\"),type:a.getAttribute(\"type\")},j=function(b){var c=axe.commons.utils.escapeSelector(a.name),i=document.querySelectorAll('input[type=\"'+axe.commons.utils.escapeSelector(a.type)+'\"][name=\"'+c+'\"]');if(i.length<2)return!0;var j=axe.commons.dom.findUp(b,\"fieldset\"),k=axe.commons.dom.findUp(b,'[role=\"group\"]'+(\"radio\"===a.type?',[role=\"radiogroup\"]':\"\"));return k||j?j?d(j,c):e(k,c):(g=\"no-group\",h.relatedNodes(f(i,b)),!1)}(a);return j||(i.failureCode=g),this.data(i),j},after:function(a,b){var c={};return a.filter(function(a){if(a.result)return!0;var b=a.data;if(b){if(c[b.type]=c[b.type]||{},!c[b.type][b.name])return c[b.type][b.name]=[b],!0;var d=c[b.type][b.name].some(function(a){return a.failureCode===b.failureCode});return d||c[b.type][b.name].push(b),!d}return!1})}},{id:\"group-labelledby\",evaluate:function(a,b){this.data({name:a.getAttribute(\"name\"),type:a.getAttribute(\"type\")});var c=document.querySelectorAll('input[type=\"'+axe.commons.utils.escapeSelector(a.type)+'\"][name=\"'+axe.commons.utils.escapeSelector(a.name)+'\"]');return c.length<=1||0!==[].map.call(c,function(a){var b=a.getAttribute(\"aria-labelledby\");return b?b.split(/\\s+/):[]}).reduce(function(a,b){return a.filter(function(a){return-1!==b.indexOf(a)})}).filter(function(a){var b=document.getElementById(a);return b&&axe.commons.text.accessibleText(b)}).length},after:function(a,b){var c={};return a.filter(function(a){var b=a.data;return!(!b||(c[b.type]=c[b.type]||{},c[b.type][b.name]))&&(c[b.type][b.name]=!0,!0)})}},{id:\"accesskeys\",evaluate:function(a,b){return axe.commons.dom.isVisible(a,!1)&&(this.data(a.getAttribute(\"accesskey\")),this.relatedNodes([a])),!0},after:function(a,b){var c={};return a.filter(function(a){if(!a.data)return!1;var b=a.data.toUpperCase();return c[b]?(c[b].relatedNodes.push(a.relatedNodes[0]),!1):(c[b]=a,a.relatedNodes=[],!0)}).map(function(a){return a.result=!!a.relatedNodes.length,a})}},{id:\"focusable-no-name\",evaluate:function(a,b){var c=a.getAttribute(\"tabindex\");return!!(axe.commons.dom.isFocusable(a)&&c>-1)&&!axe.commons.text.accessibleText(a)}},{id:\"tabindex\",evaluate:function(a,b){return a.tabIndex<=0}},{id:\"duplicate-img-label\",evaluate:function(a,b){var c=a.querySelectorAll(\"img\"),d=axe.commons.text.visible(a,!0).toLowerCase();if(\"\"===d)return!1;for(var e=0,f=c.length;e<f;e++){var g=c[e];if(axe.commons.text.accessibleText(g).toLowerCase()===d&&\"presentation\"!==g.getAttribute(\"role\")&&axe.commons.dom.isVisible(g))return!0}return!1}},{id:\"explicit-label\",evaluate:function(a,b){if(a.id){var c=document.querySelector('label[for=\"'+axe.commons.utils.escapeSelector(a.id)+'\"]');if(c)return!!axe.commons.text.accessibleText(c)}return!1}},{id:\"help-same-as-label\",evaluate:function(a,b){var c=axe.commons.text.label(a),d=a.getAttribute(\"title\");if(!c)return!1;if(!d&&(d=\"\",a.getAttribute(\"aria-describedby\"))){d=axe.commons.dom.idrefs(a,\"aria-describedby\").map(function(a){return a?axe.commons.text.accessibleText(a):\"\"}).join(\"\")}return axe.commons.text.sanitize(d)===axe.commons.text.sanitize(c)},enabled:!1},{id:\"implicit-label\",evaluate:function(a,b){var c=axe.commons.dom.findUp(a,\"label\");return!!c&&!!axe.commons.text.accessibleText(c)}},{id:\"multiple-label\",evaluate:function(a,b){var c=[].slice.call(document.querySelectorAll('label[for=\"'+axe.commons.utils.escapeSelector(a.id)+'\"]')),d=a.parentNode;for(c.length&&(c=c.filter(function(a,b){if(0===b&&!axe.commons.dom.isVisible(a,!0)||axe.commons.dom.isVisible(a,!0))return a}));d;)\"LABEL\"===d.tagName&&-1===c.indexOf(d)&&c.push(d),d=d.parentNode;return this.relatedNodes(c),c.length>1}},{id:\"title-only\",evaluate:function(a,b){return!(axe.commons.text.label(a)||!a.getAttribute(\"title\")&&!a.getAttribute(\"aria-describedby\"))}},{id:\"has-lang\",evaluate:function(a,b){return!!(a.getAttribute(\"lang\")||a.getAttribute(\"xml:lang\")||\"\").trim()}},{id:\"valid-lang\",\noptions:[\"aa\",\"ab\",\"ae\",\"af\",\"ak\",\"am\",\"an\",\"ar\",\"as\",\"av\",\"ay\",\"az\",\"ba\",\"be\",\"bg\",\"bh\",\"bi\",\"bm\",\"bn\",\"bo\",\"br\",\"bs\",\"ca\",\"ce\",\"ch\",\"co\",\"cr\",\"cs\",\"cu\",\"cv\",\"cy\",\"da\",\"de\",\"dv\",\"dz\",\"ee\",\"el\",\"en\",\"eo\",\"es\",\"et\",\"eu\",\"fa\",\"ff\",\"fi\",\"fj\",\"fo\",\"fr\",\"fy\",\"ga\",\"gd\",\"gl\",\"gn\",\"gu\",\"gv\",\"ha\",\"he\",\"hi\",\"ho\",\"hr\",\"ht\",\"hu\",\"hy\",\"hz\",\"ia\",\"id\",\"ie\",\"ig\",\"ii\",\"ik\",\"in\",\"io\",\"is\",\"it\",\"iu\",\"iw\",\"ja\",\"ji\",\"jv\",\"jw\",\"ka\",\"kg\",\"ki\",\"kj\",\"kk\",\"kl\",\"km\",\"kn\",\"ko\",\"kr\",\"ks\",\"ku\",\"kv\",\"kw\",\"ky\",\"la\",\"lb\",\"lg\",\"li\",\"ln\",\"lo\",\"lt\",\"lu\",\"lv\",\"mg\",\"mh\",\"mi\",\"mk\",\"ml\",\"mn\",\"mo\",\"mr\",\"ms\",\"mt\",\"my\",\"na\",\"nb\",\"nd\",\"ne\",\"ng\",\"nl\",\"nn\",\"no\",\"nr\",\"nv\",\"ny\",\"oc\",\"oj\",\"om\",\"or\",\"os\",\"pa\",\"pi\",\"pl\",\"ps\",\"pt\",\"qu\",\"rm\",\"rn\",\"ro\",\"ru\",\"rw\",\"sa\",\"sc\",\"sd\",\"se\",\"sg\",\"sh\",\"si\",\"sk\",\"sl\",\"sm\",\"sn\",\"so\",\"sq\",\"sr\",\"ss\",\"st\",\"su\",\"sv\",\"sw\",\"ta\",\"te\",\"tg\",\"th\",\"ti\",\"tk\",\"tl\",\"tn\",\"to\",\"tr\",\"ts\",\"tt\",\"tw\",\"ty\",\"ug\",\"uk\",\"ur\",\"uz\",\"ve\",\"vi\",\"vo\",\"wa\",\"wo\",\"xh\",\"yi\",\"yo\",\"za\",\"zh\",\"zu\",\"aaa\",\"aab\",\"aac\",\"aad\",\"aae\",\"aaf\",\"aag\",\"aah\",\"aai\",\"aak\",\"aal\",\"aam\",\"aan\",\"aao\",\"aap\",\"aaq\",\"aas\",\"aat\",\"aau\",\"aav\",\"aaw\",\"aax\",\"aaz\",\"aba\",\"abb\",\"abc\",\"abd\",\"abe\",\"abf\",\"abg\",\"abh\",\"abi\",\"abj\",\"abl\",\"abm\",\"abn\",\"abo\",\"abp\",\"abq\",\"abr\",\"abs\",\"abt\",\"abu\",\"abv\",\"abw\",\"abx\",\"aby\",\"abz\",\"aca\",\"acb\",\"acd\",\"ace\",\"acf\",\"ach\",\"aci\",\"ack\",\"acl\",\"acm\",\"acn\",\"acp\",\"acq\",\"acr\",\"acs\",\"act\",\"acu\",\"acv\",\"acw\",\"acx\",\"acy\",\"acz\",\"ada\",\"adb\",\"add\",\"ade\",\"adf\",\"adg\",\"adh\",\"adi\",\"adj\",\"adl\",\"adn\",\"ado\",\"adp\",\"adq\",\"adr\",\"ads\",\"adt\",\"adu\",\"adw\",\"adx\",\"ady\",\"adz\",\"aea\",\"aeb\",\"aec\",\"aed\",\"aee\",\"aek\",\"ael\",\"aem\",\"aen\",\"aeq\",\"aer\",\"aes\",\"aeu\",\"aew\",\"aey\",\"aez\",\"afa\",\"afb\",\"afd\",\"afe\",\"afg\",\"afh\",\"afi\",\"afk\",\"afn\",\"afo\",\"afp\",\"afs\",\"aft\",\"afu\",\"afz\",\"aga\",\"agb\",\"agc\",\"agd\",\"age\",\"agf\",\"agg\",\"agh\",\"agi\",\"agj\",\"agk\",\"agl\",\"agm\",\"agn\",\"ago\",\"agp\",\"agq\",\"agr\",\"ags\",\"agt\",\"agu\",\"agv\",\"agw\",\"agx\",\"agy\",\"agz\",\"aha\",\"ahb\",\"ahg\",\"ahh\",\"ahi\",\"ahk\",\"ahl\",\"ahm\",\"ahn\",\"aho\",\"ahp\",\"ahr\",\"ahs\",\"aht\",\"aia\",\"aib\",\"aic\",\"aid\",\"aie\",\"aif\",\"aig\",\"aih\",\"aii\",\"aij\",\"aik\",\"ail\",\"aim\",\"ain\",\"aio\",\"aip\",\"aiq\",\"air\",\"ais\",\"ait\",\"aiw\",\"aix\",\"aiy\",\"aja\",\"ajg\",\"aji\",\"ajn\",\"ajp\",\"ajt\",\"aju\",\"ajw\",\"ajz\",\"akb\",\"akc\",\"akd\",\"ake\",\"akf\",\"akg\",\"akh\",\"aki\",\"akj\",\"akk\",\"akl\",\"akm\",\"ako\",\"akp\",\"akq\",\"akr\",\"aks\",\"akt\",\"aku\",\"akv\",\"akw\",\"akx\",\"aky\",\"akz\",\"ala\",\"alc\",\"ald\",\"ale\",\"alf\",\"alg\",\"alh\",\"ali\",\"alj\",\"alk\",\"all\",\"alm\",\"aln\",\"alo\",\"alp\",\"alq\",\"alr\",\"als\",\"alt\",\"alu\",\"alv\",\"alw\",\"alx\",\"aly\",\"alz\",\"ama\",\"amb\",\"amc\",\"ame\",\"amf\",\"amg\",\"ami\",\"amj\",\"amk\",\"aml\",\"amm\",\"amn\",\"amo\",\"amp\",\"amq\",\"amr\",\"ams\",\"amt\",\"amu\",\"amv\",\"amw\",\"amx\",\"amy\",\"amz\",\"ana\",\"anb\",\"anc\",\"and\",\"ane\",\"anf\",\"ang\",\"anh\",\"ani\",\"anj\",\"ank\",\"anl\",\"anm\",\"ann\",\"ano\",\"anp\",\"anq\",\"anr\",\"ans\",\"ant\",\"anu\",\"anv\",\"anw\",\"anx\",\"any\",\"anz\",\"aoa\",\"aob\",\"aoc\",\"aod\",\"aoe\",\"aof\",\"aog\",\"aoh\",\"aoi\",\"aoj\",\"aok\",\"aol\",\"aom\",\"aon\",\"aor\",\"aos\",\"aot\",\"aou\",\"aox\",\"aoz\",\"apa\",\"apb\",\"apc\",\"apd\",\"ape\",\"apf\",\"apg\",\"aph\",\"api\",\"apj\",\"apk\",\"apl\",\"apm\",\"apn\",\"apo\",\"app\",\"apq\",\"apr\",\"aps\",\"apt\",\"apu\",\"apv\",\"apw\",\"apx\",\"apy\",\"apz\",\"aqa\",\"aqc\",\"aqd\",\"aqg\",\"aql\",\"aqm\",\"aqn\",\"aqp\",\"aqr\",\"aqt\",\"aqz\",\"arb\",\"arc\",\"ard\",\"are\",\"arh\",\"ari\",\"arj\",\"ark\",\"arl\",\"arn\",\"aro\",\"arp\",\"arq\",\"arr\",\"ars\",\"art\",\"aru\",\"arv\",\"arw\",\"arx\",\"ary\",\"arz\",\"asa\",\"asb\",\"asc\",\"asd\",\"ase\",\"asf\",\"asg\",\"ash\",\"asi\",\"asj\",\"ask\",\"asl\",\"asn\",\"aso\",\"asp\",\"asq\",\"asr\",\"ass\",\"ast\",\"asu\",\"asv\",\"asw\",\"asx\",\"asy\",\"asz\",\"ata\",\"atb\",\"atc\",\"atd\",\"ate\",\"atg\",\"ath\",\"ati\",\"atj\",\"atk\",\"atl\",\"atm\",\"atn\",\"ato\",\"atp\",\"atq\",\"atr\",\"ats\",\"att\",\"atu\",\"atv\",\"atw\",\"atx\",\"aty\",\"atz\",\"aua\",\"aub\",\"auc\",\"aud\",\"aue\",\"auf\",\"aug\",\"auh\",\"aui\",\"auj\",\"auk\",\"aul\",\"aum\",\"aun\",\"auo\",\"aup\",\"auq\",\"aur\",\"aus\",\"aut\",\"auu\",\"auw\",\"aux\",\"auy\",\"auz\",\"avb\",\"avd\",\"avi\",\"avk\",\"avl\",\"avm\",\"avn\",\"avo\",\"avs\",\"avt\",\"avu\",\"avv\",\"awa\",\"awb\",\"awc\",\"awd\",\"awe\",\"awg\",\"awh\",\"awi\",\"awk\",\"awm\",\"awn\",\"awo\",\"awr\",\"aws\",\"awt\",\"awu\",\"awv\",\"aww\",\"awx\",\"awy\",\"axb\",\"axe\",\"axg\",\"axk\",\"axl\",\"axm\",\"axx\",\"aya\",\"ayb\",\"ayc\",\"ayd\",\"aye\",\"ayg\",\"ayh\",\"ayi\",\"ayk\",\"ayl\",\"ayn\",\"ayo\",\"ayp\",\"ayq\",\"ayr\",\"ays\",\"ayt\",\"ayu\",\"ayx\",\"ayy\",\"ayz\",\"aza\",\"azb\",\"azc\",\"azd\",\"azg\",\"azj\",\"azm\",\"azn\",\"azo\",\"azt\",\"azz\",\"baa\",\"bab\",\"bac\",\"bad\",\"bae\",\"baf\",\"bag\",\"bah\",\"bai\",\"baj\",\"bal\",\"ban\",\"bao\",\"bap\",\"bar\",\"bas\",\"bat\",\"bau\",\"bav\",\"baw\",\"bax\",\"bay\",\"baz\",\"bba\",\"bbb\",\"bbc\",\"bbd\",\"bbe\",\"bbf\",\"bbg\",\"bbh\",\"bbi\",\"bbj\",\"bbk\",\"bbl\",\"bbm\",\"bbn\",\"bbo\",\"bbp\",\"bbq\",\"bbr\",\"bbs\",\"bbt\",\"bbu\",\"bbv\",\"bbw\",\"bbx\",\"bby\",\"bbz\",\"bca\",\"bcb\",\"bcc\",\"bcd\",\"bce\",\"bcf\",\"bcg\",\"bch\",\"bci\",\"bcj\",\"bck\",\"bcl\",\"bcm\",\"bcn\",\"bco\",\"bcp\",\"bcq\",\"bcr\",\"bcs\",\"bct\",\"bcu\",\"bcv\",\"bcw\",\"bcy\",\"bcz\",\"bda\",\"bdb\",\"bdc\",\"bdd\",\"bde\",\"bdf\",\"bdg\",\"bdh\",\"bdi\",\"bdj\",\"bdk\",\"bdl\",\"bdm\",\"bdn\",\"bdo\",\"bdp\",\"bdq\",\"bdr\",\"bds\",\"bdt\",\"bdu\",\"bdv\",\"bdw\",\"bdx\",\"bdy\",\"bdz\",\"bea\",\"beb\",\"bec\",\"bed\",\"bee\",\"bef\",\"beg\",\"beh\",\"bei\",\"bej\",\"bek\",\"bem\",\"beo\",\"bep\",\"beq\",\"ber\",\"bes\",\"bet\",\"beu\",\"bev\",\"bew\",\"bex\",\"bey\",\"bez\",\"bfa\",\"bfb\",\"bfc\",\"bfd\",\"bfe\",\"bff\",\"bfg\",\"bfh\",\"bfi\",\"bfj\",\"bfk\",\"bfl\",\"bfm\",\"bfn\",\"bfo\",\"bfp\",\"bfq\",\"bfr\",\"bfs\",\"bft\",\"bfu\",\"bfw\",\"bfx\",\"bfy\",\"bfz\",\"bga\",\"bgb\",\"bgc\",\"bgd\",\"bge\",\"bgf\",\"bgg\",\"bgi\",\"bgj\",\"bgk\",\"bgl\",\"bgm\",\"bgn\",\"bgo\",\"bgp\",\"bgq\",\"bgr\",\"bgs\",\"bgt\",\"bgu\",\"bgv\",\"bgw\",\"bgx\",\"bgy\",\"bgz\",\"bha\",\"bhb\",\"bhc\",\"bhd\",\"bhe\",\"bhf\",\"bhg\",\"bhh\",\"bhi\",\"bhj\",\"bhk\",\"bhl\",\"bhm\",\"bhn\",\"bho\",\"bhp\",\"bhq\",\"bhr\",\"bhs\",\"bht\",\"bhu\",\"bhv\",\"bhw\",\"bhx\",\"bhy\",\"bhz\",\"bia\",\"bib\",\"bic\",\"bid\",\"bie\",\"bif\",\"big\",\"bij\",\"bik\",\"bil\",\"bim\",\"bin\",\"bio\",\"bip\",\"biq\",\"bir\",\"bit\",\"biu\",\"biv\",\"biw\",\"bix\",\"biy\",\"biz\",\"bja\",\"bjb\",\"bjc\",\"bjd\",\"bje\",\"bjf\",\"bjg\",\"bjh\",\"bji\",\"bjj\",\"bjk\",\"bjl\",\"bjm\",\"bjn\",\"bjo\",\"bjp\",\"bjq\",\"bjr\",\"bjs\",\"bjt\",\"bju\",\"bjv\",\"bjw\",\"bjx\",\"bjy\",\"bjz\",\"bka\",\"bkb\",\"bkc\",\"bkd\",\"bkf\",\"bkg\",\"bkh\",\"bki\",\"bkj\",\"bkk\",\"bkl\",\"bkm\",\"bkn\",\"bko\",\"bkp\",\"bkq\",\"bkr\",\"bks\",\"bkt\",\"bku\",\"bkv\",\"bkw\",\"bkx\",\"bky\",\"bkz\",\"bla\",\"blb\",\"blc\",\"bld\",\"ble\",\"blf\",\"blg\",\"blh\",\"bli\",\"blj\",\"blk\",\"bll\",\"blm\",\"bln\",\"blo\",\"blp\",\"blq\",\"blr\",\"bls\",\"blt\",\"blv\",\"blw\",\"blx\",\"bly\",\"blz\",\"bma\",\"bmb\",\"bmc\",\"bmd\",\"bme\",\"bmf\",\"bmg\",\"bmh\",\"bmi\",\"bmj\",\"bmk\",\"bml\",\"bmm\",\"bmn\",\"bmo\",\"bmp\",\"bmq\",\"bmr\",\"bms\",\"bmt\",\"bmu\",\"bmv\",\"bmw\",\"bmx\",\"bmy\",\"bmz\",\"bna\",\"bnb\",\"bnc\",\"bnd\",\"bne\",\"bnf\",\"bng\",\"bni\",\"bnj\",\"bnk\",\"bnl\",\"bnm\",\"bnn\",\"bno\",\"bnp\",\"bnq\",\"bnr\",\"bns\",\"bnt\",\"bnu\",\"bnv\",\"bnw\",\"bnx\",\"bny\",\"bnz\",\"boa\",\"bob\",\"boe\",\"bof\",\"bog\",\"boh\",\"boi\",\"boj\",\"bok\",\"bol\",\"bom\",\"bon\",\"boo\",\"bop\",\"boq\",\"bor\",\"bot\",\"bou\",\"bov\",\"bow\",\"box\",\"boy\",\"boz\",\"bpa\",\"bpb\",\"bpd\",\"bpg\",\"bph\",\"bpi\",\"bpj\",\"bpk\",\"bpl\",\"bpm\",\"bpn\",\"bpo\",\"bpp\",\"bpq\",\"bpr\",\"bps\",\"bpt\",\"bpu\",\"bpv\",\"bpw\",\"bpx\",\"bpy\",\"bpz\",\"bqa\",\"bqb\",\"bqc\",\"bqd\",\"bqf\",\"bqg\",\"bqh\",\"bqi\",\"bqj\",\"bqk\",\"bql\",\"bqm\",\"bqn\",\"bqo\",\"bqp\",\"bqq\",\"bqr\",\"bqs\",\"bqt\",\"bqu\",\"bqv\",\"bqw\",\"bqx\",\"bqy\",\"bqz\",\"bra\",\"brb\",\"brc\",\"brd\",\"brf\",\"brg\",\"brh\",\"bri\",\"brj\",\"brk\",\"brl\",\"brm\",\"brn\",\"bro\",\"brp\",\"brq\",\"brr\",\"brs\",\"brt\",\"bru\",\"brv\",\"brw\",\"brx\",\"bry\",\"brz\",\"bsa\",\"bsb\",\"bsc\",\"bse\",\"bsf\",\"bsg\",\"bsh\",\"bsi\",\"bsj\",\"bsk\",\"bsl\",\"bsm\",\"bsn\",\"bso\",\"bsp\",\"bsq\",\"bsr\",\"bss\",\"bst\",\"bsu\",\"bsv\",\"bsw\",\"bsx\",\"bsy\",\"bta\",\"btb\",\"btc\",\"btd\",\"bte\",\"btf\",\"btg\",\"bth\",\"bti\",\"btj\",\"btk\",\"btl\",\"btm\",\"btn\",\"bto\",\"btp\",\"btq\",\"btr\",\"bts\",\"btt\",\"btu\",\"btv\",\"btw\",\"btx\",\"bty\",\"btz\",\"bua\",\"bub\",\"buc\",\"bud\",\"bue\",\"buf\",\"bug\",\"buh\",\"bui\",\"buj\",\"buk\",\"bum\",\"bun\",\"buo\",\"bup\",\"buq\",\"bus\",\"but\",\"buu\",\"buv\",\"buw\",\"bux\",\"buy\",\"buz\",\"bva\",\"bvb\",\"bvc\",\"bvd\",\"bve\",\"bvf\",\"bvg\",\"bvh\",\"bvi\",\"bvj\",\"bvk\",\"bvl\",\"bvm\",\"bvn\",\"bvo\",\"bvp\",\"bvq\",\"bvr\",\"bvt\",\"bvu\",\"bvv\",\"bvw\",\"bvx\",\"bvy\",\"bvz\",\"bwa\",\"bwb\",\"bwc\",\"bwd\",\"bwe\",\"bwf\",\"bwg\",\"bwh\",\"bwi\",\"bwj\",\"bwk\",\"bwl\",\"bwm\",\"bwn\",\"bwo\",\"bwp\",\"bwq\",\"bwr\",\"bws\",\"bwt\",\"bwu\",\"bww\",\"bwx\",\"bwy\",\"bwz\",\"bxa\",\"bxb\",\"bxc\",\"bxd\",\"bxe\",\"bxf\",\"bxg\",\"bxh\",\"bxi\",\"bxj\",\"bxk\",\"bxl\",\"bxm\",\"bxn\",\"bxo\",\"bxp\",\"bxq\",\"bxr\",\"bxs\",\"bxu\",\"bxv\",\"bxw\",\"bxx\",\"bxz\",\"bya\",\"byb\",\"byc\",\"byd\",\"bye\",\"byf\",\"byg\",\"byh\",\"byi\",\"byj\",\"byk\",\"byl\",\"bym\",\"byn\",\"byo\",\"byp\",\"byq\",\"byr\",\"bys\",\"byt\",\"byv\",\"byw\",\"byx\",\"byy\",\"byz\",\"bza\",\"bzb\",\"bzc\",\"bzd\",\"bze\",\"bzf\",\"bzg\",\"bzh\",\"bzi\",\"bzj\",\"bzk\",\"bzl\",\"bzm\",\"bzn\",\"bzo\",\"bzp\",\"bzq\",\"bzr\",\"bzs\",\"bzt\",\"bzu\",\"bzv\",\"bzw\",\"bzx\",\"bzy\",\"bzz\",\"caa\",\"cab\",\"cac\",\"cad\",\"cae\",\"caf\",\"cag\",\"cah\",\"cai\",\"caj\",\"cak\",\"cal\",\"cam\",\"can\",\"cao\",\"cap\",\"caq\",\"car\",\"cas\",\"cau\",\"cav\",\"caw\",\"cax\",\"cay\",\"caz\",\"cba\",\"cbb\",\"cbc\",\"cbd\",\"cbe\",\"cbg\",\"cbh\",\"cbi\",\"cbj\",\"cbk\",\"cbl\",\"cbn\",\"cbo\",\"cbq\",\"cbr\",\"cbs\",\"cbt\",\"cbu\",\"cbv\",\"cbw\",\"cby\",\"cca\",\"ccc\",\"ccd\",\"cce\",\"ccg\",\"cch\",\"ccj\",\"ccl\",\"ccm\",\"ccn\",\"cco\",\"ccp\",\"ccq\",\"ccr\",\"ccs\",\"cda\",\"cdc\",\"cdd\",\"cde\",\"cdf\",\"cdg\",\"cdh\",\"cdi\",\"cdj\",\"cdm\",\"cdn\",\"cdo\",\"cdr\",\"cds\",\"cdy\",\"cdz\",\"cea\",\"ceb\",\"ceg\",\"cek\",\"cel\",\"cen\",\"cet\",\"cfa\",\"cfd\",\"cfg\",\"cfm\",\"cga\",\"cgc\",\"cgg\",\"cgk\",\"chb\",\"chc\",\"chd\",\"chf\",\"chg\",\"chh\",\"chj\",\"chk\",\"chl\",\"chm\",\"chn\",\"cho\",\"chp\",\"chq\",\"chr\",\"cht\",\"chw\",\"chx\",\"chy\",\"chz\",\"cia\",\"cib\",\"cic\",\"cid\",\"cie\",\"cih\",\"cik\",\"cim\",\"cin\",\"cip\",\"cir\",\"ciw\",\"ciy\",\"cja\",\"cje\",\"cjh\",\"cji\",\"cjk\",\"cjm\",\"cjn\",\"cjo\",\"cjp\",\"cjr\",\"cjs\",\"cjv\",\"cjy\",\"cka\",\"ckb\",\"ckh\",\"ckl\",\"ckn\",\"cko\",\"ckq\",\"ckr\",\"cks\",\"ckt\",\"cku\",\"ckv\",\"ckx\",\"cky\",\"ckz\",\"cla\",\"clc\",\"cld\",\"cle\",\"clh\",\"cli\",\"clj\",\"clk\",\"cll\",\"clm\",\"clo\",\"clt\",\"clu\",\"clw\",\"cly\",\"cma\",\"cmc\",\"cme\",\"cmg\",\"cmi\",\"cmk\",\"cml\",\"cmm\",\"cmn\",\"cmo\",\"cmr\",\"cms\",\"cmt\",\"cna\",\"cnb\",\"cnc\",\"cng\",\"cnh\",\"cni\",\"cnk\",\"cnl\",\"cno\",\"cns\",\"cnt\",\"cnu\",\"cnw\",\"cnx\",\"coa\",\"cob\",\"coc\",\"cod\",\"coe\",\"cof\",\"cog\",\"coh\",\"coj\",\"cok\",\"col\",\"com\",\"con\",\"coo\",\"cop\",\"coq\",\"cot\",\"cou\",\"cov\",\"cow\",\"cox\",\"coy\",\"coz\",\"cpa\",\"cpb\",\"cpc\",\"cpe\",\"cpf\",\"cpg\",\"cpi\",\"cpn\",\"cpo\",\"cpp\",\"cps\",\"cpu\",\"cpx\",\"cpy\",\"cqd\",\"cqu\",\"cra\",\"crb\",\"crc\",\"crd\",\"crf\",\"crg\",\"crh\",\"cri\",\"crj\",\"crk\",\"crl\",\"crm\",\"crn\",\"cro\",\"crp\",\"crq\",\"crr\",\"crs\",\"crt\",\"crv\",\"crw\",\"crx\",\"cry\",\"crz\",\"csa\",\"csb\",\"csc\",\"csd\",\"cse\",\"csf\",\"csg\",\"csh\",\"csi\",\"csj\",\"csk\",\"csl\",\"csm\",\"csn\",\"cso\",\"csq\",\"csr\",\"css\",\"cst\",\"csu\",\"csv\",\"csw\",\"csy\",\"csz\",\"cta\",\"ctc\",\"ctd\",\"cte\",\"ctg\",\"cth\",\"ctl\",\"ctm\",\"ctn\",\"cto\",\"ctp\",\"cts\",\"ctt\",\"ctu\",\"ctz\",\"cua\",\"cub\",\"cuc\",\"cug\",\"cuh\",\"cui\",\"cuj\",\"cuk\",\"cul\",\"cum\",\"cuo\",\"cup\",\"cuq\",\"cur\",\"cus\",\"cut\",\"cuu\",\"cuv\",\"cuw\",\"cux\",\"cvg\",\"cvn\",\"cwa\",\"cwb\",\"cwd\",\"cwe\",\"cwg\",\"cwt\",\"cya\",\"cyb\",\"cyo\",\"czh\",\"czk\",\"czn\",\"czo\",\"czt\",\"daa\",\"dac\",\"dad\",\"dae\",\"daf\",\"dag\",\"dah\",\"dai\",\"daj\",\"dak\",\"dal\",\"dam\",\"dao\",\"dap\",\"daq\",\"dar\",\"das\",\"dau\",\"dav\",\"daw\",\"dax\",\"day\",\"daz\",\"dba\",\"dbb\",\"dbd\",\"dbe\",\"dbf\",\"dbg\",\"dbi\",\"dbj\",\"dbl\",\"dbm\",\"dbn\",\"dbo\",\"dbp\",\"dbq\",\"dbr\",\"dbt\",\"dbu\",\"dbv\",\"dbw\",\"dby\",\"dcc\",\"dcr\",\"dda\",\"ddd\",\"dde\",\"ddg\",\"ddi\",\"ddj\",\"ddn\",\"ddo\",\"ddr\",\"dds\",\"ddw\",\"dec\",\"ded\",\"dee\",\"def\",\"deg\",\"deh\",\"dei\",\"dek\",\"del\",\"dem\",\"den\",\"dep\",\"deq\",\"der\",\"des\",\"dev\",\"dez\",\"dga\",\"dgb\",\"dgc\",\"dgd\",\"dge\",\"dgg\",\"dgh\",\"dgi\",\"dgk\",\"dgl\",\"dgn\",\"dgo\",\"dgr\",\"dgs\",\"dgt\",\"dgu\",\"dgw\",\"dgx\",\"dgz\",\"dha\",\"dhd\",\"dhg\",\"dhi\",\"dhl\",\"dhm\",\"dhn\",\"dho\",\"dhr\",\"dhs\",\"dhu\",\"dhv\",\"dhw\",\"dhx\",\"dia\",\"dib\",\"dic\",\"did\",\"dif\",\"dig\",\"dih\",\"dii\",\"dij\",\"dik\",\"dil\",\"dim\",\"din\",\"dio\",\"dip\",\"diq\",\"dir\",\"dis\",\"dit\",\"diu\",\"diw\",\"dix\",\"diy\",\"diz\",\"dja\",\"djb\",\"djc\",\"djd\",\"dje\",\"djf\",\"dji\",\"djj\",\"djk\",\"djl\",\"djm\",\"djn\",\"djo\",\"djr\",\"dju\",\"djw\",\"dka\",\"dkk\",\"dkl\",\"dkr\",\"dks\",\"dkx\",\"dlg\",\"dlk\",\"dlm\",\"dln\",\"dma\",\"dmb\",\"dmc\",\"dmd\",\"dme\",\"dmg\",\"dmk\",\"dml\",\"dmm\",\"dmn\",\"dmo\",\"dmr\",\"dms\",\"dmu\",\"dmv\",\"dmw\",\"dmx\",\"dmy\",\"dna\",\"dnd\",\"dne\",\"dng\",\"dni\",\"dnj\",\"dnk\",\"dnn\",\"dnr\",\"dnt\",\"dnu\",\"dnv\",\"dnw\",\"dny\",\"doa\",\"dob\",\"doc\",\"doe\",\"dof\",\"doh\",\"doi\",\"dok\",\"dol\",\"don\",\"doo\",\"dop\",\"doq\",\"dor\",\"dos\",\"dot\",\"dov\",\"dow\",\"dox\",\"doy\",\"doz\",\"dpp\",\"dra\",\"drb\",\"drc\",\"drd\",\"dre\",\"drg\",\"drh\",\"dri\",\"drl\",\"drn\",\"dro\",\"drq\",\"drr\",\"drs\",\"drt\",\"dru\",\"drw\",\"dry\",\"dsb\",\"dse\",\"dsh\",\"dsi\",\"dsl\",\"dsn\",\"dso\",\"dsq\",\"dta\",\"dtb\",\"dtd\",\"dth\",\"dti\",\"dtk\",\"dtm\",\"dtn\",\"dto\",\"dtp\",\"dtr\",\"dts\",\"dtt\",\"dtu\",\"dty\",\"dua\",\"dub\",\"duc\",\"dud\",\"due\",\"duf\",\"dug\",\"duh\",\"dui\",\"duj\",\"duk\",\"dul\",\"dum\",\"dun\",\"duo\",\"dup\",\"duq\",\"dur\",\"dus\",\"duu\",\"duv\",\"duw\",\"dux\",\"duy\",\"duz\",\"dva\",\"dwa\",\"dwl\",\"dwr\",\"dws\",\"dwu\",\"dww\",\"dwy\",\"dya\",\"dyb\",\"dyd\",\"dyg\",\"dyi\",\"dym\",\"dyn\",\"dyo\",\"dyu\",\"dyy\",\"dza\",\"dzd\",\"dze\",\"dzg\",\"dzl\",\"dzn\",\"eaa\",\"ebg\",\"ebk\",\"ebo\",\"ebr\",\"ebu\",\"ecr\",\"ecs\",\"ecy\",\"eee\",\"efa\",\"efe\",\"efi\",\"ega\",\"egl\",\"ego\",\"egx\",\"egy\",\"ehu\",\"eip\",\"eit\",\"eiv\",\"eja\",\"eka\",\"ekc\",\"eke\",\"ekg\",\"eki\",\"ekk\",\"ekl\",\"ekm\",\"eko\",\"ekp\",\"ekr\",\"eky\",\"ele\",\"elh\",\"eli\",\"elk\",\"elm\",\"elo\",\"elp\",\"elu\",\"elx\",\"ema\",\"emb\",\"eme\",\"emg\",\"emi\",\"emk\",\"emm\",\"emn\",\"emo\",\"emp\",\"ems\",\"emu\",\"emw\",\"emx\",\"emy\",\"ena\",\"enb\",\"enc\",\"end\",\"enf\",\"enh\",\"enl\",\"enm\",\"enn\",\"eno\",\"enq\",\"enr\",\"enu\",\"env\",\"enw\",\"enx\",\"eot\",\"epi\",\"era\",\"erg\",\"erh\",\"eri\",\"erk\",\"ero\",\"err\",\"ers\",\"ert\",\"erw\",\"ese\",\"esg\",\"esh\",\"esi\",\"esk\",\"esl\",\"esm\",\"esn\",\"eso\",\"esq\",\"ess\",\"esu\",\"esx\",\"esy\",\"etb\",\"etc\",\"eth\",\"etn\",\"eto\",\"etr\",\"ets\",\"ett\",\"etu\",\"etx\",\"etz\",\"euq\",\"eve\",\"evh\",\"evn\",\"ewo\",\"ext\",\"eya\",\"eyo\",\"eza\",\"eze\",\"faa\",\"fab\",\"fad\",\"faf\",\"fag\",\"fah\",\"fai\",\"faj\",\"fak\",\"fal\",\"fam\",\"fan\",\"fap\",\"far\",\"fat\",\"fau\",\"fax\",\"fay\",\"faz\",\"fbl\",\"fcs\",\"fer\",\"ffi\",\"ffm\",\"fgr\",\"fia\",\"fie\",\"fil\",\"fip\",\"fir\",\"fit\",\"fiu\",\"fiw\",\"fkk\",\"fkv\",\"fla\",\"flh\",\"fli\",\"fll\",\"fln\",\"flr\",\"fly\",\"fmp\",\"fmu\",\"fnb\",\"fng\",\"fni\",\"fod\",\"foi\",\"fom\",\"fon\",\"for\",\"fos\",\"fox\",\"fpe\",\"fqs\",\"frc\",\"frd\",\"frk\",\"frm\",\"fro\",\"frp\",\"frq\",\"frr\",\"frs\",\"frt\",\"fse\",\"fsl\",\"fss\",\"fub\",\"fuc\",\"fud\",\"fue\",\"fuf\",\"fuh\",\"fui\",\"fuj\",\"fum\",\"fun\",\"fuq\",\"fur\",\"fut\",\"fuu\",\"fuv\",\"fuy\",\"fvr\",\"fwa\",\"fwe\",\"gaa\",\"gab\",\"gac\",\"gad\",\"gae\",\"gaf\",\"gag\",\"gah\",\"gai\",\"gaj\",\"gak\",\"gal\",\"gam\",\"gan\",\"gao\",\"gap\",\"gaq\",\"gar\",\"gas\",\"gat\",\"gau\",\"gav\",\"gaw\",\"gax\",\"gay\",\"gaz\",\"gba\",\"gbb\",\"gbc\",\"gbd\",\"gbe\",\"gbf\",\"gbg\",\"gbh\",\"gbi\",\"gbj\",\"gbk\",\"gbl\",\"gbm\",\"gbn\",\"gbo\",\"gbp\",\"gbq\",\"gbr\",\"gbs\",\"gbu\",\"gbv\",\"gbw\",\"gbx\",\"gby\",\"gbz\",\"gcc\",\"gcd\",\"gce\",\"gcf\",\"gcl\",\"gcn\",\"gcr\",\"gct\",\"gda\",\"gdb\",\"gdc\",\"gdd\",\"gde\",\"gdf\",\"gdg\",\"gdh\",\"gdi\",\"gdj\",\"gdk\",\"gdl\",\"gdm\",\"gdn\",\"gdo\",\"gdq\",\"gdr\",\"gds\",\"gdt\",\"gdu\",\"gdx\",\"gea\",\"geb\",\"gec\",\"ged\",\"geg\",\"geh\",\"gei\",\"gej\",\"gek\",\"gel\",\"gem\",\"geq\",\"ges\",\"gev\",\"gew\",\"gex\",\"gey\",\"gez\",\"gfk\",\"gft\",\"gfx\",\"gga\",\"ggb\",\"ggd\",\"gge\",\"ggg\",\"ggk\",\"ggl\",\"ggn\",\"ggo\",\"ggr\",\"ggt\",\"ggu\",\"ggw\",\"gha\",\"ghc\",\"ghe\",\"ghh\",\"ghk\",\"ghl\",\"ghn\",\"gho\",\"ghr\",\"ghs\",\"ght\",\"gia\",\"gib\",\"gic\",\"gid\",\"gig\",\"gih\",\"gil\",\"gim\",\"gin\",\"gio\",\"gip\",\"giq\",\"gir\",\"gis\",\"git\",\"giu\",\"giw\",\"gix\",\"giy\",\"giz\",\"gji\",\"gjk\",\"gjm\",\"gjn\",\"gjr\",\"gju\",\"gka\",\"gke\",\"gkn\",\"gko\",\"gkp\",\"gku\",\"glc\",\"gld\",\"glh\",\"gli\",\"glj\",\"glk\",\"gll\",\"glo\",\"glr\",\"glu\",\"glw\",\"gly\",\"gma\",\"gmb\",\"gmd\",\"gme\",\"gmg\",\"gmh\",\"gml\",\"gmm\",\"gmn\",\"gmq\",\"gmu\",\"gmv\",\"gmw\",\"gmx\",\"gmy\",\"gmz\",\"gna\",\"gnb\",\"gnc\",\"gnd\",\"gne\",\"gng\",\"gnh\",\"gni\",\"gnk\",\"gnl\",\"gnm\",\"gnn\",\"gno\",\"gnq\",\"gnr\",\"gnt\",\"gnu\",\"gnw\",\"gnz\",\"goa\",\"gob\",\"goc\",\"god\",\"goe\",\"gof\",\"gog\",\"goh\",\"goi\",\"goj\",\"gok\",\"gol\",\"gom\",\"gon\",\"goo\",\"gop\",\"goq\",\"gor\",\"gos\",\"got\",\"gou\",\"gow\",\"gox\",\"goy\",\"goz\",\"gpa\",\"gpe\",\"gpn\",\"gqa\",\"gqi\",\"gqn\",\"gqr\",\"gqu\",\"gra\",\"grb\",\"grc\",\"grd\",\"grg\",\"grh\",\"gri\",\"grj\",\"grk\",\"grm\",\"gro\",\"grq\",\"grr\",\"grs\",\"grt\",\"gru\",\"grv\",\"grw\",\"grx\",\"gry\",\"grz\",\"gse\",\"gsg\",\"gsl\",\"gsm\",\"gsn\",\"gso\",\"gsp\",\"gss\",\"gsw\",\"gta\",\"gti\",\"gtu\",\"gua\",\"gub\",\"guc\",\"gud\",\"gue\",\"guf\",\"gug\",\"guh\",\"gui\",\"guk\",\"gul\",\"gum\",\"gun\",\"guo\",\"gup\",\"guq\",\"gur\",\"gus\",\"gut\",\"guu\",\"guv\",\"guw\",\"gux\",\"guz\",\"gva\",\"gvc\",\"gve\",\"gvf\",\"gvj\",\"gvl\",\"gvm\",\"gvn\",\"gvo\",\"gvp\",\"gvr\",\"gvs\",\"gvy\",\"gwa\",\"gwb\",\"gwc\",\"gwd\",\"gwe\",\"gwf\",\"gwg\",\"gwi\",\"gwj\",\"gwm\",\"gwn\",\"gwr\",\"gwt\",\"gwu\",\"gww\",\"gwx\",\"gxx\",\"gya\",\"gyb\",\"gyd\",\"gye\",\"gyf\",\"gyg\",\"gyi\",\"gyl\",\"gym\",\"gyn\",\"gyr\",\"gyy\",\"gza\",\"gzi\",\"gzn\",\"haa\",\"hab\",\"hac\",\"had\",\"hae\",\"haf\",\"hag\",\"hah\",\"hai\",\"haj\",\"hak\",\"hal\",\"ham\",\"han\",\"hao\",\"hap\",\"haq\",\"har\",\"has\",\"hav\",\"haw\",\"hax\",\"hay\",\"haz\",\"hba\",\"hbb\",\"hbn\",\"hbo\",\"hbu\",\"hca\",\"hch\",\"hdn\",\"hds\",\"hdy\",\"hea\",\"hed\",\"heg\",\"heh\",\"hei\",\"hem\",\"hgm\",\"hgw\",\"hhi\",\"hhr\",\"hhy\",\"hia\",\"hib\",\"hid\",\"hif\",\"hig\",\"hih\",\"hii\",\"hij\",\"hik\",\"hil\",\"him\",\"hio\",\"hir\",\"hit\",\"hiw\",\"hix\",\"hji\",\"hka\",\"hke\",\"hkk\",\"hks\",\"hla\",\"hlb\",\"hld\",\"hle\",\"hlt\",\"hlu\",\"hma\",\"hmb\",\"hmc\",\"hmd\",\"hme\",\"hmf\",\"hmg\",\"hmh\",\"hmi\",\"hmj\",\"hmk\",\"hml\",\"hmm\",\"hmn\",\"hmp\",\"hmq\",\"hmr\",\"hms\",\"hmt\",\"hmu\",\"hmv\",\"hmw\",\"hmx\",\"hmy\",\"hmz\",\"hna\",\"hnd\",\"hne\",\"hnh\",\"hni\",\"hnj\",\"hnn\",\"hno\",\"hns\",\"hnu\",\"hoa\",\"hob\",\"hoc\",\"hod\",\"hoe\",\"hoh\",\"hoi\",\"hoj\",\"hok\",\"hol\",\"hom\",\"hoo\",\"hop\",\"hor\",\"hos\",\"hot\",\"hov\",\"how\",\"hoy\",\"hoz\",\"hpo\",\"hps\",\"hra\",\"hrc\",\"hre\",\"hrk\",\"hrm\",\"hro\",\"hrp\",\"hrr\",\"hrt\",\"hru\",\"hrw\",\"hrx\",\"hrz\",\"hsb\",\"hsh\",\"hsl\",\"hsn\",\"hss\",\"hti\",\"hto\",\"hts\",\"htu\",\"htx\",\"hub\",\"huc\",\"hud\",\"hue\",\"huf\",\"hug\",\"huh\",\"hui\",\"huj\",\"huk\",\"hul\",\"hum\",\"huo\",\"hup\",\"huq\",\"hur\",\"hus\",\"hut\",\"huu\",\"huv\",\"huw\",\"hux\",\"huy\",\"huz\",\"hvc\",\"hve\",\"hvk\",\"hvn\",\"hvv\",\"hwa\",\"hwc\",\"hwo\",\"hya\",\"hyx\",\"iai\",\"ian\",\"iap\",\"iar\",\"iba\",\"ibb\",\"ibd\",\"ibe\",\"ibg\",\"ibi\",\"ibl\",\"ibm\",\"ibn\",\"ibr\",\"ibu\",\"iby\",\"ica\",\"ich\",\"icl\",\"icr\",\"ida\",\"idb\",\"idc\",\"idd\",\"ide\",\"idi\",\"idr\",\"ids\",\"idt\",\"idu\",\"ifa\",\"ifb\",\"ife\",\"iff\",\"ifk\",\"ifm\",\"ifu\",\"ify\",\"igb\",\"ige\",\"igg\",\"igl\",\"igm\",\"ign\",\"igo\",\"igs\",\"igw\",\"ihb\",\"ihi\",\"ihp\",\"ihw\",\"iin\",\"iir\",\"ijc\",\"ije\",\"ijj\",\"ijn\",\"ijo\",\"ijs\",\"ike\",\"iki\",\"ikk\",\"ikl\",\"iko\",\"ikp\",\"ikr\",\"iks\",\"ikt\",\"ikv\",\"ikw\",\"ikx\",\"ikz\",\"ila\",\"ilb\",\"ilg\",\"ili\",\"ilk\",\"ill\",\"ilm\",\"ilo\",\"ilp\",\"ils\",\"ilu\",\"ilv\",\"ilw\",\"ima\",\"ime\",\"imi\",\"iml\",\"imn\",\"imo\",\"imr\",\"ims\",\"imy\",\"inb\",\"inc\",\"ine\",\"ing\",\"inh\",\"inj\",\"inl\",\"inm\",\"inn\",\"ino\",\"inp\",\"ins\",\"int\",\"inz\",\"ior\",\"iou\",\"iow\",\"ipi\",\"ipo\",\"iqu\",\"iqw\",\"ira\",\"ire\",\"irh\",\"iri\",\"irk\",\"irn\",\"iro\",\"irr\",\"iru\",\"irx\",\"iry\",\"isa\",\"isc\",\"isd\",\"ise\",\"isg\",\"ish\",\"isi\",\"isk\",\"ism\",\"isn\",\"iso\",\"isr\",\"ist\",\"isu\",\"itb\",\"itc\",\"itd\",\"ite\",\"iti\",\"itk\",\"itl\",\"itm\",\"ito\",\"itr\",\"its\",\"itt\",\"itv\",\"itw\",\"itx\",\"ity\",\"itz\",\"ium\",\"ivb\",\"ivv\",\"iwk\",\"iwm\",\"iwo\",\"iws\",\"ixc\",\"ixl\",\"iya\",\"iyo\",\"iyx\",\"izh\",\"izi\",\"izr\",\"izz\",\"jaa\",\"jab\",\"jac\",\"jad\",\"jae\",\"jaf\",\"jah\",\"jaj\",\"jak\",\"jal\",\"jam\",\"jan\",\"jao\",\"jaq\",\"jar\",\"jas\",\"jat\",\"jau\",\"jax\",\"jay\",\"jaz\",\"jbe\",\"jbi\",\"jbj\",\"jbk\",\"jbn\",\"jbo\",\"jbr\",\"jbt\",\"jbu\",\"jbw\",\"jcs\",\"jct\",\"jda\",\"jdg\",\"jdt\",\"jeb\",\"jee\",\"jeg\",\"jeh\",\"jei\",\"jek\",\"jel\",\"jen\",\"jer\",\"jet\",\"jeu\",\"jgb\",\"jge\",\"jgk\",\"jgo\",\"jhi\",\"jhs\",\"jia\",\"jib\",\"jic\",\"jid\",\"jie\",\"jig\",\"jih\",\"jii\",\"jil\",\"jim\",\"jio\",\"jiq\",\"jit\",\"jiu\",\"jiv\",\"jiy\",\"jje\",\"jjr\",\"jka\",\"jkm\",\"jko\",\"jkp\",\"jkr\",\"jku\",\"jle\",\"jls\",\"jma\",\"jmb\",\"jmc\",\"jmd\",\"jmi\",\"jml\",\"jmn\",\"jmr\",\"jms\",\"jmw\",\"jmx\",\"jna\",\"jnd\",\"jng\",\"jni\",\"jnj\",\"jnl\",\"jns\",\"job\",\"jod\",\"jog\",\"jor\",\"jos\",\"jow\",\"jpa\",\"jpr\",\"jpx\",\"jqr\",\"jra\",\"jrb\",\"jrr\",\"jrt\",\"jru\",\"jsl\",\"jua\",\"jub\",\"juc\",\"jud\",\"juh\",\"jui\",\"juk\",\"jul\",\"jum\",\"jun\",\"juo\",\"jup\",\"jur\",\"jus\",\"jut\",\"juu\",\"juw\",\"juy\",\"jvd\",\"jvn\",\"jwi\",\"jya\",\"jye\",\"jyy\",\"kaa\",\"kab\",\"kac\",\"kad\",\"kae\",\"kaf\",\"kag\",\"kah\",\"kai\",\"kaj\",\"kak\",\"kam\",\"kao\",\"kap\",\"kaq\",\"kar\",\"kav\",\"kaw\",\"kax\",\"kay\",\"kba\",\"kbb\",\"kbc\",\"kbd\",\"kbe\",\"kbf\",\"kbg\",\"kbh\",\"kbi\",\"kbj\",\"kbk\",\"kbl\",\"kbm\",\"kbn\",\"kbo\",\"kbp\",\"kbq\",\"kbr\",\"kbs\",\"kbt\",\"kbu\",\"kbv\",\"kbw\",\"kbx\",\"kby\",\"kbz\",\"kca\",\"kcb\",\"kcc\",\"kcd\",\"kce\",\"kcf\",\"kcg\",\"kch\",\"kci\",\"kcj\",\"kck\",\"kcl\",\"kcm\",\"kcn\",\"kco\",\"kcp\",\"kcq\",\"kcr\",\"kcs\",\"kct\",\"kcu\",\"kcv\",\"kcw\",\"kcx\",\"kcy\",\"kcz\",\"kda\",\"kdc\",\"kdd\",\"kde\",\"kdf\",\"kdg\",\"kdh\",\"kdi\",\"kdj\",\"kdk\",\"kdl\",\"kdm\",\"kdn\",\"kdo\",\"kdp\",\"kdq\",\"kdr\",\"kdt\",\"kdu\",\"kdv\",\"kdw\",\"kdx\",\"kdy\",\"kdz\",\"kea\",\"keb\",\"kec\",\"ked\",\"kee\",\"kef\",\"keg\",\"keh\",\"kei\",\"kej\",\"kek\",\"kel\",\"kem\",\"ken\",\"keo\",\"kep\",\"keq\",\"ker\",\"kes\",\"ket\",\"keu\",\"kev\",\"kew\",\"kex\",\"key\",\"kez\",\"kfa\",\"kfb\",\"kfc\",\"kfd\",\"kfe\",\"kff\",\"kfg\",\"kfh\",\"kfi\",\"kfj\",\"kfk\",\"kfl\",\"kfm\",\"kfn\",\"kfo\",\"kfp\",\"kfq\",\"kfr\",\"kfs\",\"kft\",\"kfu\",\"kfv\",\"kfw\",\"kfx\",\"kfy\",\"kfz\",\"kga\",\"kgb\",\"kgc\",\"kgd\",\"kge\",\"kgf\",\"kgg\",\"kgh\",\"kgi\",\"kgj\",\"kgk\",\"kgl\",\"kgm\",\"kgn\",\"kgo\",\"kgp\",\"kgq\",\"kgr\",\"kgs\",\"kgt\",\"kgu\",\"kgv\",\"kgw\",\"kgx\",\"kgy\",\"kha\",\"khb\",\"khc\",\"khd\",\"khe\",\"khf\",\"khg\",\"khh\",\"khi\",\"khj\",\"khk\",\"khl\",\"khn\",\"kho\",\"khp\",\"khq\",\"khr\",\"khs\",\"kht\",\"khu\",\"khv\",\"khw\",\"khx\",\"khy\",\"khz\",\"kia\",\"kib\",\"kic\",\"kid\",\"kie\",\"kif\",\"kig\",\"kih\",\"kii\",\"kij\",\"kil\",\"kim\",\"kio\",\"kip\",\"kiq\",\"kis\",\"kit\",\"kiu\",\"kiv\",\"kiw\",\"kix\",\"kiy\",\"kiz\",\"kja\",\"kjb\",\"kjc\",\"kjd\",\"kje\",\"kjf\",\"kjg\",\"kjh\",\"kji\",\"kjj\",\"kjk\",\"kjl\",\"kjm\",\"kjn\",\"kjo\",\"kjp\",\"kjq\",\"kjr\",\"kjs\",\"kjt\",\"kju\",\"kjv\",\"kjx\",\"kjy\",\"kjz\",\"kka\",\"kkb\",\"kkc\",\"kkd\",\"kke\",\"kkf\",\"kkg\",\"kkh\",\"kki\",\"kkj\",\"kkk\",\"kkl\",\"kkm\",\"kkn\",\"kko\",\"kkp\",\"kkq\",\"kkr\",\"kks\",\"kkt\",\"kku\",\"kkv\",\"kkw\",\"kkx\",\"kky\",\"kkz\",\"kla\",\"klb\",\"klc\",\"kld\",\"kle\",\"klf\",\"klg\",\"klh\",\"kli\",\"klj\",\"klk\",\"kll\",\"klm\",\"kln\",\"klo\",\"klp\",\"klq\",\"klr\",\"kls\",\"klt\",\"klu\",\"klv\",\"klw\",\"klx\",\"kly\",\"klz\",\"kma\",\"kmb\",\"kmc\",\"kmd\",\"kme\",\"kmf\",\"kmg\",\"kmh\",\"kmi\",\"kmj\",\"kmk\",\"kml\",\"kmm\",\"kmn\",\"kmo\",\"kmp\",\"kmq\",\"kmr\",\"kms\",\"kmt\",\"kmu\",\"kmv\",\"kmw\",\"kmx\",\"kmy\",\"kmz\",\"kna\",\"knb\",\"knc\",\"knd\",\"kne\",\"knf\",\"kng\",\"kni\",\"knj\",\"knk\",\"knl\",\"knm\",\"knn\",\"kno\",\"knp\",\"knq\",\"knr\",\"kns\",\"knt\",\"knu\",\"knv\",\"knw\",\"knx\",\"kny\",\"knz\",\"koa\",\"koc\",\"kod\",\"koe\",\"kof\",\"kog\",\"koh\",\"koi\",\"koj\",\"kok\",\"kol\",\"koo\",\"kop\",\"koq\",\"kos\",\"kot\",\"kou\",\"kov\",\"kow\",\"kox\",\"koy\",\"koz\",\"kpa\",\"kpb\",\"kpc\",\"kpd\",\"kpe\",\"kpf\",\"kpg\",\"kph\",\"kpi\",\"kpj\",\"kpk\",\"kpl\",\"kpm\",\"kpn\",\"kpo\",\"kpp\",\"kpq\",\"kpr\",\"kps\",\"kpt\",\"kpu\",\"kpv\",\"kpw\",\"kpx\",\"kpy\",\"kpz\",\"kqa\",\"kqb\",\"kqc\",\"kqd\",\"kqe\",\"kqf\",\"kqg\",\"kqh\",\"kqi\",\"kqj\",\"kqk\",\"kql\",\"kqm\",\"kqn\",\"kqo\",\"kqp\",\"kqq\",\"kqr\",\"kqs\",\"kqt\",\"kqu\",\"kqv\",\"kqw\",\"kqx\",\"kqy\",\"kqz\",\"kra\",\"krb\",\"krc\",\"krd\",\"kre\",\"krf\",\"krh\",\"kri\",\"krj\",\"krk\",\"krl\",\"krm\",\"krn\",\"kro\",\"krp\",\"krr\",\"krs\",\"krt\",\"kru\",\"krv\",\"krw\",\"krx\",\"kry\",\"krz\",\"ksa\",\"ksb\",\"ksc\",\"ksd\",\"kse\",\"ksf\",\"ksg\",\"ksh\",\"ksi\",\"ksj\",\"ksk\",\"ksl\",\"ksm\",\"ksn\",\"kso\",\"ksp\",\"ksq\",\"ksr\",\"kss\",\"kst\",\"ksu\",\"ksv\",\"ksw\",\"ksx\",\"ksy\",\"ksz\",\"kta\",\"ktb\",\"ktc\",\"ktd\",\"kte\",\"ktf\",\"ktg\",\"kth\",\"kti\",\"ktj\",\"ktk\",\"ktl\",\"ktm\",\"ktn\",\"kto\",\"ktp\",\"ktq\",\"ktr\",\"kts\",\"ktt\",\"ktu\",\"ktv\",\"ktw\",\"ktx\",\"kty\",\"ktz\",\"kub\",\"kuc\",\"kud\",\"kue\",\"kuf\",\"kug\",\"kuh\",\"kui\",\"kuj\",\"kuk\",\"kul\",\"kum\",\"kun\",\"kuo\",\"kup\",\"kuq\",\"kus\",\"kut\",\"kuu\",\"kuv\",\"kuw\",\"kux\",\"kuy\",\"kuz\",\"kva\",\"kvb\",\"kvc\",\"kvd\",\"kve\",\"kvf\",\"kvg\",\"kvh\",\"kvi\",\"kvj\",\"kvk\",\"kvl\",\"kvm\",\"kvn\",\"kvo\",\"kvp\",\"kvq\",\"kvr\",\"kvs\",\"kvt\",\"kvu\",\"kvv\",\"kvw\",\"kvx\",\"kvy\",\"kvz\",\"kwa\",\"kwb\",\"kwc\",\"kwd\",\"kwe\",\"kwf\",\"kwg\",\"kwh\",\"kwi\",\"kwj\",\"kwk\",\"kwl\",\"kwm\",\"kwn\",\"kwo\",\"kwp\",\"kwq\",\"kwr\",\"kws\",\"kwt\",\"kwu\",\"kwv\",\"kww\",\"kwx\",\"kwy\",\"kwz\",\"kxa\",\"kxb\",\"kxc\",\"kxd\",\"kxe\",\"kxf\",\"kxh\",\"kxi\",\"kxj\",\"kxk\",\"kxl\",\"kxm\",\"kxn\",\"kxo\",\"kxp\",\"kxq\",\"kxr\",\"kxs\",\"kxt\",\"kxu\",\"kxv\",\"kxw\",\"kxx\",\"kxy\",\"kxz\",\"kya\",\"kyb\",\"kyc\",\"kyd\",\"kye\",\"kyf\",\"kyg\",\"kyh\",\"kyi\",\"kyj\",\"kyk\",\"kyl\",\"kym\",\"kyn\",\"kyo\",\"kyp\",\"kyq\",\"kyr\",\"kys\",\"kyt\",\"kyu\",\"kyv\",\"kyw\",\"kyx\",\"kyy\",\"kyz\",\"kza\",\"kzb\",\"kzc\",\"kzd\",\"kze\",\"kzf\",\"kzg\",\"kzh\",\"kzi\",\"kzj\",\"kzk\",\"kzl\",\"kzm\",\"kzn\",\"kzo\",\"kzp\",\"kzq\",\"kzr\",\"kzs\",\"kzt\",\"kzu\",\"kzv\",\"kzw\",\"kzx\",\"kzy\",\"kzz\",\"laa\",\"lab\",\"lac\",\"lad\",\"lae\",\"laf\",\"lag\",\"lah\",\"lai\",\"laj\",\"lak\",\"lal\",\"lam\",\"lan\",\"lap\",\"laq\",\"lar\",\"las\",\"lau\",\"law\",\"lax\",\"lay\",\"laz\",\"lba\",\"lbb\",\"lbc\",\"lbe\",\"lbf\",\"lbg\",\"lbi\",\"lbj\",\"lbk\",\"lbl\",\"lbm\",\"lbn\",\"lbo\",\"lbq\",\"lbr\",\"lbs\",\"lbt\",\"lbu\",\"lbv\",\"lbw\",\"lbx\",\"lby\",\"lbz\",\"lcc\",\"lcd\",\"lce\",\"lcf\",\"lch\",\"lcl\",\"lcm\",\"lcp\",\"lcq\",\"lcs\",\"lda\",\"ldb\",\"ldd\",\"ldg\",\"ldh\",\"ldi\",\"ldj\",\"ldk\",\"ldl\",\"ldm\",\"ldn\",\"ldo\",\"ldp\",\"ldq\",\"lea\",\"leb\",\"lec\",\"led\",\"lee\",\"lef\",\"leg\",\"leh\",\"lei\",\"lej\",\"lek\",\"lel\",\"lem\",\"len\",\"leo\",\"lep\",\"leq\",\"ler\",\"les\",\"let\",\"leu\",\"lev\",\"lew\",\"lex\",\"ley\",\"lez\",\"lfa\",\"lfn\",\"lga\",\"lgb\",\"lgg\",\"lgh\",\"lgi\",\"lgk\",\"lgl\",\"lgm\",\"lgn\",\"lgq\",\"lgr\",\"lgt\",\"lgu\",\"lgz\",\"lha\",\"lhh\",\"lhi\",\"lhl\",\"lhm\",\"lhn\",\"lhp\",\"lhs\",\"lht\",\"lhu\",\"lia\",\"lib\",\"lic\",\"lid\",\"lie\",\"lif\",\"lig\",\"lih\",\"lii\",\"lij\",\"lik\",\"lil\",\"lio\",\"lip\",\"liq\",\"lir\",\"lis\",\"liu\",\"liv\",\"liw\",\"lix\",\"liy\",\"liz\",\"lja\",\"lje\",\"lji\",\"ljl\",\"ljp\",\"ljw\",\"ljx\",\"lka\",\"lkb\",\"lkc\",\"lkd\",\"lke\",\"lkh\",\"lki\",\"lkj\",\"lkl\",\"lkm\",\"lkn\",\"lko\",\"lkr\",\"lks\",\"lkt\",\"lku\",\"lky\",\"lla\",\"llb\",\"llc\",\"lld\",\"lle\",\"llf\",\"llg\",\"llh\",\"lli\",\"llj\",\"llk\",\"lll\",\"llm\",\"lln\",\"llo\",\"llp\",\"llq\",\"lls\",\"llu\",\"llx\",\"lma\",\"lmb\",\"lmc\",\"lmd\",\"lme\",\"lmf\",\"lmg\",\"lmh\",\"lmi\",\"lmj\",\"lmk\",\"lml\",\"lmm\",\"lmn\",\"lmo\",\"lmp\",\"lmq\",\"lmr\",\"lmu\",\"lmv\",\"lmw\",\"lmx\",\"lmy\",\"lmz\",\"lna\",\"lnb\",\"lnd\",\"lng\",\"lnh\",\"lni\",\"lnj\",\"lnl\",\"lnm\",\"lnn\",\"lno\",\"lns\",\"lnu\",\"lnw\",\"lnz\",\"loa\",\"lob\",\"loc\",\"loe\",\"lof\",\"log\",\"loh\",\"loi\",\"loj\",\"lok\",\"lol\",\"lom\",\"lon\",\"loo\",\"lop\",\"loq\",\"lor\",\"los\",\"lot\",\"lou\",\"lov\",\"low\",\"lox\",\"loy\",\"loz\",\"lpa\",\"lpe\",\"lpn\",\"lpo\",\"lpx\",\"lra\",\"lrc\",\"lre\",\"lrg\",\"lri\",\"lrk\",\"lrl\",\"lrm\",\"lrn\",\"lro\",\"lrr\",\"lrt\",\"lrv\",\"lrz\",\"lsa\",\"lsd\",\"lse\",\"lsg\",\"lsh\",\"lsi\",\"lsl\",\"lsm\",\"lso\",\"lsp\",\"lsr\",\"lss\",\"lst\",\"lsy\",\"ltc\",\"ltg\",\"lti\",\"ltn\",\"lto\",\"lts\",\"ltu\",\"lua\",\"luc\",\"lud\",\"lue\",\"luf\",\"lui\",\"luj\",\"luk\",\"lul\",\"lum\",\"lun\",\"luo\",\"lup\",\"luq\",\"lur\",\"lus\",\"lut\",\"luu\",\"luv\",\"luw\",\"luy\",\"luz\",\"lva\",\"lvk\",\"lvs\",\"lvu\",\"lwa\",\"lwe\",\"lwg\",\"lwh\",\"lwl\",\"lwm\",\"lwo\",\"lwt\",\"lwu\",\"lww\",\"lya\",\"lyg\",\"lyn\",\"lzh\",\"lzl\",\"lzn\",\"lzz\",\"maa\",\"mab\",\"mad\",\"mae\",\"maf\",\"mag\",\"mai\",\"maj\",\"mak\",\"mam\",\"man\",\"map\",\"maq\",\"mas\",\"mat\",\"mau\",\"mav\",\"maw\",\"max\",\"maz\",\"mba\",\"mbb\",\"mbc\",\"mbd\",\"mbe\",\"mbf\",\"mbh\",\"mbi\",\"mbj\",\"mbk\",\"mbl\",\"mbm\",\"mbn\",\"mbo\",\"mbp\",\"mbq\",\"mbr\",\"mbs\",\"mbt\",\"mbu\",\"mbv\",\"mbw\",\"mbx\",\"mby\",\"mbz\",\"mca\",\"mcb\",\"mcc\",\"mcd\",\"mce\",\"mcf\",\"mcg\",\"mch\",\"mci\",\"mcj\",\"mck\",\"mcl\",\"mcm\",\"mcn\",\"mco\",\"mcp\",\"mcq\",\"mcr\",\"mcs\",\"mct\",\"mcu\",\"mcv\",\"mcw\",\"mcx\",\"mcy\",\"mcz\",\"mda\",\"mdb\",\"mdc\",\"mdd\",\"mde\",\"mdf\",\"mdg\",\"mdh\",\"mdi\",\"mdj\",\"mdk\",\"mdl\",\"mdm\",\"mdn\",\"mdp\",\"mdq\",\"mdr\",\"mds\",\"mdt\",\"mdu\",\"mdv\",\"mdw\",\"mdx\",\"mdy\",\"mdz\",\"mea\",\"meb\",\"mec\",\"med\",\"mee\",\"mef\",\"meg\",\"meh\",\"mei\",\"mej\",\"mek\",\"mel\",\"mem\",\"men\",\"meo\",\"mep\",\"meq\",\"mer\",\"mes\",\"met\",\"meu\",\"mev\",\"mew\",\"mey\",\"mez\",\"mfa\",\"mfb\",\"mfc\",\"mfd\",\"mfe\",\"mff\",\"mfg\",\"mfh\",\"mfi\",\"mfj\",\"mfk\",\"mfl\",\"mfm\",\"mfn\",\"mfo\",\"mfp\",\"mfq\",\"mfr\",\"mfs\",\"mft\",\"mfu\",\"mfv\",\"mfw\",\"mfx\",\"mfy\",\"mfz\",\"mga\",\"mgb\",\"mgc\",\"mgd\",\"mge\",\"mgf\",\"mgg\",\"mgh\",\"mgi\",\"mgj\",\"mgk\",\"mgl\",\"mgm\",\"mgn\",\"mgo\",\"mgp\",\"mgq\",\"mgr\",\"mgs\",\"mgt\",\"mgu\",\"mgv\",\"mgw\",\"mgx\",\"mgy\",\"mgz\",\"mha\",\"mhb\",\"mhc\",\"mhd\",\"mhe\",\"mhf\",\"mhg\",\"mhh\",\"mhi\",\"mhj\",\"mhk\",\"mhl\",\"mhm\",\"mhn\",\"mho\",\"mhp\",\"mhq\",\"mhr\",\"mhs\",\"mht\",\"mhu\",\"mhw\",\"mhx\",\"mhy\",\"mhz\",\"mia\",\"mib\",\"mic\",\"mid\",\"mie\",\"mif\",\"mig\",\"mih\",\"mii\",\"mij\",\"mik\",\"mil\",\"mim\",\"min\",\"mio\",\"mip\",\"miq\",\"mir\",\"mis\",\"mit\",\"miu\",\"miw\",\"mix\",\"miy\",\"miz\",\"mja\",\"mjb\",\"mjc\",\"mjd\",\"mje\",\"mjg\",\"mjh\",\"mji\",\"mjj\",\"mjk\",\"mjl\",\"mjm\",\"mjn\",\"mjo\",\"mjp\",\"mjq\",\"mjr\",\"mjs\",\"mjt\",\"mju\",\"mjv\",\"mjw\",\"mjx\",\"mjy\",\"mjz\",\"mka\",\"mkb\",\"mkc\",\"mke\",\"mkf\",\"mkg\",\"mkh\",\"mki\",\"mkj\",\"mkk\",\"mkl\",\"mkm\",\"mkn\",\"mko\",\"mkp\",\"mkq\",\"mkr\",\"mks\",\"mkt\",\"mku\",\"mkv\",\"mkw\",\"mkx\",\"mky\",\"mkz\",\"mla\",\"mlb\",\"mlc\",\"mld\",\"mle\",\"mlf\",\"mlh\",\"mli\",\"mlj\",\"mlk\",\"mll\",\"mlm\",\"mln\",\"mlo\",\"mlp\",\"mlq\",\"mlr\",\"mls\",\"mlu\",\"mlv\",\"mlw\",\"mlx\",\"mlz\",\"mma\",\"mmb\",\"mmc\",\"mmd\",\"mme\",\"mmf\",\"mmg\",\"mmh\",\"mmi\",\"mmj\",\"mmk\",\"mml\",\"mmm\",\"mmn\",\"mmo\",\"mmp\",\"mmq\",\"mmr\",\"mmt\",\"mmu\",\"mmv\",\"mmw\",\"mmx\",\"mmy\",\"mmz\",\"mna\",\"mnb\",\"mnc\",\"mnd\",\"mne\",\"mnf\",\"mng\",\"mnh\",\"mni\",\"mnj\",\"mnk\",\"mnl\",\"mnm\",\"mnn\",\"mno\",\"mnp\",\"mnq\",\"mnr\",\"mns\",\"mnt\",\"mnu\",\"mnv\",\"mnw\",\"mnx\",\"mny\",\"mnz\",\"moa\",\"moc\",\"mod\",\"moe\",\"mof\",\"mog\",\"moh\",\"moi\",\"moj\",\"mok\",\"mom\",\"moo\",\"mop\",\"moq\",\"mor\",\"mos\",\"mot\",\"mou\",\"mov\",\"mow\",\"mox\",\"moy\",\"moz\",\"mpa\",\"mpb\",\"mpc\",\"mpd\",\"mpe\",\"mpg\",\"mph\",\"mpi\",\"mpj\",\"mpk\",\"mpl\",\"mpm\",\"mpn\",\"mpo\",\"mpp\",\"mpq\",\"mpr\",\"mps\",\"mpt\",\"mpu\",\"mpv\",\"mpw\",\"mpx\",\"mpy\",\"mpz\",\"mqa\",\"mqb\",\"mqc\",\"mqe\",\"mqf\",\"mqg\",\"mqh\",\"mqi\",\"mqj\",\"mqk\",\"mql\",\"mqm\",\"mqn\",\"mqo\",\"mqp\",\"mqq\",\"mqr\",\"mqs\",\"mqt\",\"mqu\",\"mqv\",\"mqw\",\"mqx\",\"mqy\",\"mqz\",\"mra\",\"mrb\",\"mrc\",\"mrd\",\"mre\",\"mrf\",\"mrg\",\"mrh\",\"mrj\",\"mrk\",\"mrl\",\"mrm\",\"mrn\",\"mro\",\"mrp\",\"mrq\",\"mrr\",\"mrs\",\"mrt\",\"mru\",\"mrv\",\"mrw\",\"mrx\",\"mry\",\"mrz\",\"msb\",\"msc\",\"msd\",\"mse\",\"msf\",\"msg\",\"msh\",\"msi\",\"msj\",\"msk\",\"msl\",\"msm\",\"msn\",\"mso\",\"msp\",\"msq\",\"msr\",\"mss\",\"mst\",\"msu\",\"msv\",\"msw\",\"msx\",\"msy\",\"msz\",\"mta\",\"mtb\",\"mtc\",\"mtd\",\"mte\",\"mtf\",\"mtg\",\"mth\",\"mti\",\"mtj\",\"mtk\",\"mtl\",\"mtm\",\"mtn\",\"mto\",\"mtp\",\"mtq\",\"mtr\",\"mts\",\"mtt\",\"mtu\",\"mtv\",\"mtw\",\"mtx\",\"mty\",\"mua\",\"mub\",\"muc\",\"mud\",\"mue\",\"mug\",\"muh\",\"mui\",\"muj\",\"muk\",\"mul\",\"mum\",\"mun\",\"muo\",\"mup\",\"muq\",\"mur\",\"mus\",\"mut\",\"muu\",\"muv\",\"mux\",\"muy\",\"muz\",\"mva\",\"mvb\",\"mvd\",\"mve\",\"mvf\",\"mvg\",\"mvh\",\"mvi\",\"mvk\",\"mvl\",\"mvm\",\"mvn\",\"mvo\",\"mvp\",\"mvq\",\"mvr\",\"mvs\",\"mvt\",\"mvu\",\"mvv\",\"mvw\",\"mvx\",\"mvy\",\"mvz\",\"mwa\",\"mwb\",\"mwc\",\"mwd\",\"mwe\",\"mwf\",\"mwg\",\"mwh\",\"mwi\",\"mwj\",\"mwk\",\"mwl\",\"mwm\",\"mwn\",\"mwo\",\"mwp\",\"mwq\",\"mwr\",\"mws\",\"mwt\",\"mwu\",\"mwv\",\"mww\",\"mwx\",\"mwy\",\"mwz\",\"mxa\",\"mxb\",\"mxc\",\"mxd\",\"mxe\",\"mxf\",\"mxg\",\"mxh\",\"mxi\",\"mxj\",\"mxk\",\"mxl\",\"mxm\",\"mxn\",\"mxo\",\"mxp\",\"mxq\",\"mxr\",\"mxs\",\"mxt\",\"mxu\",\"mxv\",\"mxw\",\"mxx\",\"mxy\",\"mxz\",\"myb\",\"myc\",\"myd\",\"mye\",\"myf\",\"myg\",\"myh\",\"myi\",\"myj\",\"myk\",\"myl\",\"mym\",\"myn\",\"myo\",\"myp\",\"myq\",\"myr\",\"mys\",\"myt\",\"myu\",\"myv\",\"myw\",\"myx\",\"myy\",\"myz\",\"mza\",\"mzb\",\"mzc\",\"mzd\",\"mze\",\"mzg\",\"mzh\",\"mzi\",\"mzj\",\"mzk\",\"mzl\",\"mzm\",\"mzn\",\"mzo\",\"mzp\",\"mzq\",\"mzr\",\"mzs\",\"mzt\",\"mzu\",\"mzv\",\"mzw\",\"mzx\",\"mzy\",\"mzz\",\"naa\",\"nab\",\"nac\",\"nad\",\"nae\",\"naf\",\"nag\",\"nah\",\"nai\",\"naj\",\"nak\",\"nal\",\"nam\",\"nan\",\"nao\",\"nap\",\"naq\",\"nar\",\"nas\",\"nat\",\"naw\",\"nax\",\"nay\",\"naz\",\"nba\",\"nbb\",\"nbc\",\"nbd\",\"nbe\",\"nbf\",\"nbg\",\"nbh\",\"nbi\",\"nbj\",\"nbk\",\"nbm\",\"nbn\",\"nbo\",\"nbp\",\"nbq\",\"nbr\",\"nbs\",\"nbt\",\"nbu\",\"nbv\",\"nbw\",\"nbx\",\"nby\",\"nca\",\"ncb\",\"ncc\",\"ncd\",\"nce\",\"ncf\",\"ncg\",\"nch\",\"nci\",\"ncj\",\"nck\",\"ncl\",\"ncm\",\"ncn\",\"nco\",\"ncp\",\"ncr\",\"ncs\",\"nct\",\"ncu\",\"ncx\",\"ncz\",\"nda\",\"ndb\",\"ndc\",\"ndd\",\"ndf\",\"ndg\",\"ndh\",\"ndi\",\"ndj\",\"ndk\",\"ndl\",\"ndm\",\"ndn\",\"ndp\",\"ndq\",\"ndr\",\"nds\",\"ndt\",\"ndu\",\"ndv\",\"ndw\",\"ndx\",\"ndy\",\"ndz\",\"nea\",\"neb\",\"nec\",\"ned\",\"nee\",\"nef\",\"neg\",\"neh\",\"nei\",\"nej\",\"nek\",\"nem\",\"nen\",\"neo\",\"neq\",\"ner\",\"nes\",\"net\",\"neu\",\"nev\",\"new\",\"nex\",\"ney\",\"nez\",\"nfa\",\"nfd\",\"nfl\",\"nfr\",\"nfu\",\"nga\",\"ngb\",\"ngc\",\"ngd\",\"nge\",\"ngf\",\"ngg\",\"ngh\",\"ngi\",\"ngj\",\"ngk\",\"ngl\",\"ngm\",\"ngn\",\"ngo\",\"ngp\",\"ngq\",\"ngr\",\"ngs\",\"ngt\",\"ngu\",\"ngv\",\"ngw\",\"ngx\",\"ngy\",\"ngz\",\"nha\",\"nhb\",\"nhc\",\"nhd\",\"nhe\",\"nhf\",\"nhg\",\"nhh\",\"nhi\",\"nhk\",\"nhm\",\"nhn\",\"nho\",\"nhp\",\"nhq\",\"nhr\",\"nht\",\"nhu\",\"nhv\",\"nhw\",\"nhx\",\"nhy\",\"nhz\",\"nia\",\"nib\",\"nic\",\"nid\",\"nie\",\"nif\",\"nig\",\"nih\",\"nii\",\"nij\",\"nik\",\"nil\",\"nim\",\"nin\",\"nio\",\"niq\",\"nir\",\"nis\",\"nit\",\"niu\",\"niv\",\"niw\",\"nix\",\"niy\",\"niz\",\"nja\",\"njb\",\"njd\",\"njh\",\"nji\",\"njj\",\"njl\",\"njm\",\"njn\",\"njo\",\"njr\",\"njs\",\"njt\",\"nju\",\"njx\",\"njy\",\"njz\",\"nka\",\"nkb\",\"nkc\",\"nkd\",\"nke\",\"nkf\",\"nkg\",\"nkh\",\"nki\",\"nkj\",\"nkk\",\"nkm\",\"nkn\",\"nko\",\"nkp\",\"nkq\",\"nkr\",\"nks\",\"nkt\",\"nku\",\"nkv\",\"nkw\",\"nkx\",\"nkz\",\"nla\",\"nlc\",\"nle\",\"nlg\",\"nli\",\"nlj\",\"nlk\",\"nll\",\"nln\",\"nlo\",\"nlq\",\"nlr\",\"nlu\",\"nlv\",\"nlw\",\"nlx\",\"nly\",\"nlz\",\"nma\",\"nmb\",\"nmc\",\"nmd\",\"nme\",\"nmf\",\"nmg\",\"nmh\",\"nmi\",\"nmj\",\"nmk\",\"nml\",\"nmm\",\"nmn\",\"nmo\",\"nmp\",\"nmq\",\"nmr\",\"nms\",\"nmt\",\"nmu\",\"nmv\",\"nmw\",\"nmx\",\"nmy\",\"nmz\",\"nna\",\"nnb\",\"nnc\",\"nnd\",\"nne\",\"nnf\",\"nng\",\"nnh\",\"nni\",\"nnj\",\"nnk\",\"nnl\",\"nnm\",\"nnn\",\"nnp\",\"nnq\",\"nnr\",\"nns\",\"nnt\",\"nnu\",\"nnv\",\"nnw\",\"nnx\",\"nny\",\"nnz\",\"noa\",\"noc\",\"nod\",\"noe\",\"nof\",\"nog\",\"noh\",\"noi\",\"noj\",\"nok\",\"nol\",\"nom\",\"non\",\"noo\",\"nop\",\"noq\",\"nos\",\"not\",\"nou\",\"nov\",\"now\",\"noy\",\"noz\",\"npa\",\"npb\",\"npg\",\"nph\",\"npi\",\"npl\",\"npn\",\"npo\",\"nps\",\"npu\",\"npy\",\"nqg\",\"nqk\",\"nqm\",\"nqn\",\"nqo\",\"nqq\",\"nqy\",\"nra\",\"nrb\",\"nrc\",\"nre\",\"nrf\",\"nrg\",\"nri\",\"nrk\",\"nrl\",\"nrm\",\"nrn\",\"nrp\",\"nrr\",\"nrt\",\"nru\",\"nrx\",\"nrz\",\"nsa\",\"nsc\",\"nsd\",\"nse\",\"nsf\",\"nsg\",\"nsh\",\"nsi\",\"nsk\",\"nsl\",\"nsm\",\"nsn\",\"nso\",\"nsp\",\"nsq\",\"nsr\",\"nss\",\"nst\",\"nsu\",\"nsv\",\"nsw\",\"nsx\",\"nsy\",\"nsz\",\"ntd\",\"nte\",\"ntg\",\"nti\",\"ntj\",\"ntk\",\"ntm\",\"nto\",\"ntp\",\"ntr\",\"nts\",\"ntu\",\"ntw\",\"ntx\",\"nty\",\"ntz\",\"nua\",\"nub\",\"nuc\",\"nud\",\"nue\",\"nuf\",\"nug\",\"nuh\",\"nui\",\"nuj\",\"nuk\",\"nul\",\"num\",\"nun\",\"nuo\",\"nup\",\"nuq\",\"nur\",\"nus\",\"nut\",\"nuu\",\"nuv\",\"nuw\",\"nux\",\"nuy\",\"nuz\",\"nvh\",\"nvm\",\"nvo\",\"nwa\",\"nwb\",\"nwc\",\"nwe\",\"nwg\",\"nwi\",\"nwm\",\"nwo\",\"nwr\",\"nwx\",\"nwy\",\"nxa\",\"nxd\",\"nxe\",\"nxg\",\"nxi\",\"nxk\",\"nxl\",\"nxm\",\"nxn\",\"nxo\",\"nxq\",\"nxr\",\"nxu\",\"nxx\",\"nyb\",\"nyc\",\"nyd\",\"nye\",\"nyf\",\"nyg\",\"nyh\",\"nyi\",\"nyj\",\"nyk\",\"nyl\",\"nym\",\"nyn\",\"nyo\",\"nyp\",\"nyq\",\"nyr\",\"nys\",\"nyt\",\"nyu\",\"nyv\",\"nyw\",\"nyx\",\"nyy\",\"nza\",\"nzb\",\"nzi\",\"nzk\",\"nzm\",\"nzs\",\"nzu\",\"nzy\",\"nzz\",\"oaa\",\"oac\",\"oar\",\"oav\",\"obi\",\"obk\",\"obl\",\"obm\",\"obo\",\"obr\",\"obt\",\"obu\",\"oca\",\"och\",\"oco\",\"ocu\",\"oda\",\"odk\",\"odt\",\"odu\",\"ofo\",\"ofs\",\"ofu\",\"ogb\",\"ogc\",\"oge\",\"ogg\",\"ogo\",\"ogu\",\"oht\",\"ohu\",\"oia\",\"oin\",\"ojb\",\"ojc\",\"ojg\",\"ojp\",\"ojs\",\"ojv\",\"ojw\",\"oka\",\"okb\",\"okd\",\"oke\",\"okg\",\"okh\",\"oki\",\"okj\",\"okk\",\"okl\",\"okm\",\"okn\",\"oko\",\"okr\",\"oks\",\"oku\",\"okv\",\"okx\",\"ola\",\"old\",\"ole\",\"olk\",\"olm\",\"olo\",\"olr\",\"olt\",\"olu\",\"oma\",\"omb\",\"omc\",\"ome\",\"omg\",\"omi\",\"omk\",\"oml\",\"omn\",\"omo\",\"omp\",\"omq\",\"omr\",\"omt\",\"omu\",\"omv\",\"omw\",\"omx\",\"ona\",\"onb\",\"one\",\"ong\",\"oni\",\"onj\",\"onk\",\"onn\",\"ono\",\"onp\",\"onr\",\"ons\",\"ont\",\"onu\",\"onw\",\"onx\",\"ood\",\"oog\",\"oon\",\"oor\",\"oos\",\"opa\",\"opk\",\"opm\",\"opo\",\"opt\",\"opy\",\"ora\",\"orc\",\"ore\",\"org\",\"orh\",\"orn\",\"oro\",\"orr\",\"ors\",\"ort\",\"oru\",\"orv\",\"orw\",\"orx\",\"ory\",\"orz\",\"osa\",\"osc\",\"osi\",\"oso\",\"osp\",\"ost\",\"osu\",\"osx\",\"ota\",\"otb\",\"otd\",\"ote\",\"oti\",\"otk\",\"otl\",\"otm\",\"otn\",\"oto\",\"otq\",\"otr\",\"ots\",\"ott\",\"otu\",\"otw\",\"otx\",\"oty\",\"otz\",\"oua\",\"oub\",\"oue\",\"oui\",\"oum\",\"oun\",\"ovd\",\"owi\",\"owl\",\"oyb\",\"oyd\",\"oym\",\"oyy\",\"ozm\",\"paa\",\"pab\",\"pac\",\"pad\",\"pae\",\"paf\",\"pag\",\"pah\",\"pai\",\"pak\",\"pal\",\"pam\",\"pao\",\"pap\",\"paq\",\"par\",\"pas\",\"pat\",\"pau\",\"pav\",\"paw\",\"pax\",\"pay\",\"paz\",\"pbb\",\"pbc\",\"pbe\",\"pbf\",\"pbg\",\"pbh\",\"pbi\",\"pbl\",\"pbn\",\"pbo\",\"pbp\",\"pbr\",\"pbs\",\"pbt\",\"pbu\",\"pbv\",\"pby\",\"pbz\",\"pca\",\"pcb\",\"pcc\",\"pcd\",\"pce\",\"pcf\",\"pcg\",\"pch\",\"pci\",\"pcj\",\"pck\",\"pcl\",\"pcm\",\"pcn\",\"pcp\",\"pcr\",\"pcw\",\"pda\",\"pdc\",\"pdi\",\"pdn\",\"pdo\",\"pdt\",\"pdu\",\"pea\",\"peb\",\"ped\",\"pee\",\"pef\",\"peg\",\"peh\",\"pei\",\"pej\",\"pek\",\"pel\",\"pem\",\"peo\",\"pep\",\"peq\",\"pes\",\"pev\",\"pex\",\"pey\",\"pez\",\"pfa\",\"pfe\",\"pfl\",\"pga\",\"pgd\",\"pgg\",\"pgi\",\"pgk\",\"pgl\",\"pgn\",\"pgs\",\"pgu\",\"pgy\",\"pgz\",\"pha\",\"phd\",\"phg\",\"phh\",\"phi\",\"phk\",\"phl\",\"phm\",\"phn\",\"pho\",\"phq\",\"phr\",\"pht\",\"phu\",\"phv\",\"phw\",\"pia\",\"pib\",\"pic\",\"pid\",\"pie\",\"pif\",\"pig\",\"pih\",\"pii\",\"pij\",\"pil\",\"pim\",\"pin\",\"pio\",\"pip\",\"pir\",\"pis\",\"pit\",\"piu\",\"piv\",\"piw\",\"pix\",\"piy\",\"piz\",\"pjt\",\"pka\",\"pkb\",\"pkc\",\"pkg\",\"pkh\",\"pkn\",\"pko\",\"pkp\",\"pkr\",\"pks\",\"pkt\",\"pku\",\"pla\",\"plb\",\"plc\",\"pld\",\"ple\",\"plf\",\"plg\",\"plh\",\"plj\",\"plk\",\"pll\",\"pln\",\"plo\",\"plp\",\"plq\",\"plr\",\"pls\",\"plt\",\"plu\",\"plv\",\"plw\",\"ply\",\"plz\",\"pma\",\"pmb\",\"pmc\",\"pmd\",\"pme\",\"pmf\",\"pmh\",\"pmi\",\"pmj\",\"pmk\",\"pml\",\"pmm\",\"pmn\",\"pmo\",\"pmq\",\"pmr\",\"pms\",\"pmt\",\"pmu\",\"pmw\",\"pmx\",\"pmy\",\"pmz\",\"pna\",\"pnb\",\"pnc\",\"pne\",\"png\",\"pnh\",\"pni\",\"pnj\",\"pnk\",\"pnl\",\"pnm\",\"pnn\",\"pno\",\"pnp\",\"pnq\",\"pnr\",\"pns\",\"pnt\",\"pnu\",\"pnv\",\"pnw\",\"pnx\",\"pny\",\"pnz\",\"poc\",\"pod\",\"poe\",\"pof\",\"pog\",\"poh\",\"poi\",\"pok\",\"pom\",\"pon\",\"poo\",\"pop\",\"poq\",\"pos\",\"pot\",\"pov\",\"pow\",\"pox\",\"poy\",\"poz\",\"ppa\",\"ppe\",\"ppi\",\"ppk\",\"ppl\",\"ppm\",\"ppn\",\"ppo\",\"ppp\",\"ppq\",\"ppr\",\"pps\",\"ppt\",\"ppu\",\"pqa\",\"pqe\",\"pqm\",\"pqw\",\"pra\",\"prb\",\"prc\",\"prd\",\"pre\",\"prf\",\"prg\",\"prh\",\"pri\",\"prk\",\"prl\",\"prm\",\"prn\",\"pro\",\"prp\",\"prq\",\"prr\",\"prs\",\"prt\",\"pru\",\"prw\",\"prx\",\"pry\",\"prz\",\"psa\",\"psc\",\"psd\",\"pse\",\"psg\",\"psh\",\"psi\",\"psl\",\"psm\",\"psn\",\"pso\",\"psp\",\"psq\",\"psr\",\"pss\",\"pst\",\"psu\",\"psw\",\"psy\",\"pta\",\"pth\",\"pti\",\"ptn\",\"pto\",\"ptp\",\"ptq\",\"ptr\",\"ptt\",\"ptu\",\"ptv\",\"ptw\",\"pty\",\"pua\",\"pub\",\"puc\",\"pud\",\"pue\",\"puf\",\"pug\",\"pui\",\"puj\",\"puk\",\"pum\",\"puo\",\"pup\",\"puq\",\"pur\",\"put\",\"puu\",\"puw\",\"pux\",\"puy\",\"puz\",\"pwa\",\"pwb\",\"pwg\",\"pwi\",\"pwm\",\"pwn\",\"pwo\",\"pwr\",\"pww\",\"pxm\",\"pye\",\"pym\",\"pyn\",\"pys\",\"pyu\",\"pyx\",\"pyy\",\"pzn\",\"qaa..qtz\",\"qua\",\"qub\",\"quc\",\"qud\",\"quf\",\"qug\",\"quh\",\"qui\",\"quk\",\"qul\",\"qum\",\"qun\",\"qup\",\"quq\",\"qur\",\"qus\",\"quv\",\"quw\",\"qux\",\"quy\",\"quz\",\"qva\",\"qvc\",\"qve\",\"qvh\",\"qvi\",\"qvj\",\"qvl\",\"qvm\",\"qvn\",\"qvo\",\"qvp\",\"qvs\",\"qvw\",\"qvy\",\"qvz\",\"qwa\",\"qwc\",\"qwe\",\"qwh\",\"qwm\",\"qws\",\"qwt\",\"qxa\",\"qxc\",\"qxh\",\"qxl\",\"qxn\",\"qxo\",\"qxp\",\"qxq\",\"qxr\",\"qxs\",\"qxt\",\"qxu\",\"qxw\",\"qya\",\"qyp\",\"raa\",\"rab\",\"rac\",\"rad\",\"raf\",\"rag\",\"rah\",\"rai\",\"raj\",\"rak\",\"ral\",\"ram\",\"ran\",\"rao\",\"rap\",\"raq\",\"rar\",\"ras\",\"rat\",\"rau\",\"rav\",\"raw\",\"rax\",\"ray\",\"raz\",\"rbb\",\"rbk\",\"rbl\",\"rbp\",\"rcf\",\"rdb\",\"rea\",\"reb\",\"ree\",\"reg\",\"rei\",\"rej\",\"rel\",\"rem\",\"ren\",\"rer\",\"res\",\"ret\",\"rey\",\"rga\",\"rge\",\"rgk\",\"rgn\",\"rgr\",\"rgs\",\"rgu\",\"rhg\",\"rhp\",\"ria\",\"rie\",\"rif\",\"ril\",\"rim\",\"rin\",\"rir\",\"rit\",\"riu\",\"rjg\",\"rji\",\"rjs\",\"rka\",\"rkb\",\"rkh\",\"rki\",\"rkm\",\"rkt\",\"rkw\",\"rma\",\"rmb\",\"rmc\",\"rmd\",\"rme\",\"rmf\",\"rmg\",\"rmh\",\"rmi\",\"rmk\",\"rml\",\"rmm\",\"rmn\",\"rmo\",\"rmp\",\"rmq\",\"rmr\",\"rms\",\"rmt\",\"rmu\",\"rmv\",\"rmw\",\"rmx\",\"rmy\",\"rmz\",\"rna\",\"rnd\",\"rng\",\"rnl\",\"rnn\",\"rnp\",\"rnr\",\"rnw\",\"roa\",\"rob\",\"roc\",\"rod\",\"roe\",\"rof\",\"rog\",\"rol\",\"rom\",\"roo\",\"rop\",\"ror\",\"rou\",\"row\",\"rpn\",\"rpt\",\"rri\",\"rro\",\"rrt\",\"rsb\",\"rsi\",\"rsl\",\"rsm\",\"rtc\",\"rth\",\"rtm\",\"rts\",\"rtw\",\"rub\",\"ruc\",\"rue\",\"ruf\",\"rug\",\"ruh\",\"rui\",\"ruk\",\"ruo\",\"rup\",\"ruq\",\"rut\",\"ruu\",\"ruy\",\"ruz\",\"rwa\",\"rwk\",\"rwm\",\"rwo\",\"rwr\",\"rxd\",\"rxw\",\"ryn\",\"rys\",\"ryu\",\"rzh\",\"saa\",\"sab\",\"sac\",\"sad\",\"sae\",\"saf\",\"sah\",\"sai\",\"saj\",\"sak\",\"sal\",\"sam\",\"sao\",\"sap\",\"saq\",\"sar\",\"sas\",\"sat\",\"sau\",\"sav\",\"saw\",\"sax\",\"say\",\"saz\",\"sba\",\"sbb\",\"sbc\",\"sbd\",\"sbe\",\"sbf\",\"sbg\",\"sbh\",\"sbi\",\"sbj\",\"sbk\",\"sbl\",\"sbm\",\"sbn\",\"sbo\",\"sbp\",\"sbq\",\"sbr\",\"sbs\",\"sbt\",\"sbu\",\"sbv\",\"sbw\",\"sbx\",\"sby\",\"sbz\",\"sca\",\"scb\",\"sce\",\"scf\",\"scg\",\"sch\",\"sci\",\"sck\",\"scl\",\"scn\",\"sco\",\"scp\",\"scq\",\"scs\",\"scu\",\"scv\",\"scw\",\"scx\",\"sda\",\"sdb\",\"sdc\",\"sde\",\"sdf\",\"sdg\",\"sdh\",\"sdj\",\"sdk\",\"sdl\",\"sdm\",\"sdn\",\"sdo\",\"sdp\",\"sdr\",\"sds\",\"sdt\",\"sdu\",\"sdv\",\"sdx\",\"sdz\",\"sea\",\"seb\",\"sec\",\"sed\",\"see\",\"sef\",\"seg\",\"seh\",\"sei\",\"sej\",\"sek\",\"sel\",\"sem\",\"sen\",\"seo\",\"sep\",\"seq\",\"ser\",\"ses\",\"set\",\"seu\",\"sev\",\"sew\",\"sey\",\"sez\",\"sfb\",\"sfe\",\"sfm\",\"sfs\",\"sfw\",\"sga\",\"sgb\",\"sgc\",\"sgd\",\"sge\",\"sgg\",\"sgh\",\"sgi\",\"sgj\",\"sgk\",\"sgl\",\"sgm\",\"sgn\",\"sgo\",\"sgp\",\"sgr\",\"sgs\",\"sgt\",\"sgu\",\"sgw\",\"sgx\",\"sgy\",\"sgz\",\"sha\",\"shb\",\"shc\",\"shd\",\"she\",\"shg\",\"shh\",\"shi\",\"shj\",\"shk\",\"shl\",\"shm\",\"shn\",\"sho\",\"shp\",\"shq\",\"shr\",\"shs\",\"sht\",\"shu\",\"shv\",\"shw\",\"shx\",\"shy\",\"shz\",\"sia\",\"sib\",\"sid\",\"sie\",\"sif\",\"sig\",\"sih\",\"sii\",\"sij\",\"sik\",\"sil\",\"sim\",\"sio\",\"sip\",\"siq\",\"sir\",\"sis\",\"sit\",\"siu\",\"siv\",\"siw\",\"six\",\"siy\",\"siz\",\"sja\",\"sjb\",\"sjd\",\"sje\",\"sjg\",\"sjk\",\"sjl\",\"sjm\",\"sjn\",\"sjo\",\"sjp\",\"sjr\",\"sjs\",\"sjt\",\"sju\",\"sjw\",\"ska\",\"skb\",\"skc\",\"skd\",\"ske\",\"skf\",\"skg\",\"skh\",\"ski\",\"skj\",\"skk\",\"skm\",\"skn\",\"sko\",\"skp\",\"skq\",\"skr\",\"sks\",\"skt\",\"sku\",\"skv\",\"skw\",\"skx\",\"sky\",\"skz\",\"sla\",\"slc\",\"sld\",\"sle\",\"slf\",\"slg\",\"slh\",\"sli\",\"slj\",\"sll\",\"slm\",\"sln\",\"slp\",\"slq\",\"slr\",\"sls\",\"slt\",\"slu\",\"slw\",\"slx\",\"sly\",\"slz\",\"sma\",\"smb\",\"smc\",\"smd\",\"smf\",\"smg\",\"smh\",\"smi\",\"smj\",\"smk\",\"sml\",\"smm\",\"smn\",\"smp\",\"smq\",\"smr\",\"sms\",\"smt\",\"smu\",\"smv\",\"smw\",\"smx\",\"smy\",\"smz\",\"snb\",\"snc\",\"sne\",\"snf\",\"sng\",\"snh\",\"sni\",\"snj\",\"snk\",\"snl\",\"snm\",\"snn\",\"sno\",\"snp\",\"snq\",\"snr\",\"sns\",\"snu\",\"snv\",\"snw\",\"snx\",\"sny\",\"snz\",\"soa\",\"sob\",\"soc\",\"sod\",\"soe\",\"sog\",\"soh\",\"soi\",\"soj\",\"sok\",\"sol\",\"son\",\"soo\",\"sop\",\"soq\",\"sor\",\"sos\",\"sou\",\"sov\",\"sow\",\"sox\",\"soy\",\"soz\",\"spb\",\"spc\",\"spd\",\"spe\",\"spg\",\"spi\",\"spk\",\"spl\",\"spm\",\"spn\",\"spo\",\"spp\",\"spq\",\"spr\",\"sps\",\"spt\",\"spu\",\"spv\",\"spx\",\"spy\",\"sqa\",\"sqh\",\"sqj\",\"sqk\",\"sqm\",\"sqn\",\"sqo\",\"sqq\",\"sqr\",\"sqs\",\"sqt\",\"squ\",\"sra\",\"srb\",\"src\",\"sre\",\"srf\",\"srg\",\"srh\",\"sri\",\"srk\",\"srl\",\"srm\",\"srn\",\"sro\",\"srq\",\"srr\",\"srs\",\"srt\",\"sru\",\"srv\",\"srw\",\"srx\",\"sry\",\"srz\",\"ssa\",\"ssb\",\"ssc\",\"ssd\",\"sse\",\"ssf\",\"ssg\",\"ssh\",\"ssi\",\"ssj\",\"ssk\",\"ssl\",\"ssm\",\"ssn\",\"sso\",\"ssp\",\"ssq\",\"ssr\",\"sss\",\"sst\",\"ssu\",\"ssv\",\"ssx\",\"ssy\",\"ssz\",\"sta\",\"stb\",\"std\",\"ste\",\"stf\",\"stg\",\"sth\",\"sti\",\"stj\",\"stk\",\"stl\",\"stm\",\"stn\",\"sto\",\"stp\",\"stq\",\"str\",\"sts\",\"stt\",\"stu\",\"stv\",\"stw\",\"sty\",\"sua\",\"sub\",\"suc\",\"sue\",\"sug\",\"sui\",\"suj\",\"suk\",\"sul\",\"sum\",\"suq\",\"sur\",\"sus\",\"sut\",\"suv\",\"suw\",\"sux\",\"suy\",\"suz\",\"sva\",\"svb\",\"svc\",\"sve\",\"svk\",\"svm\",\"svr\",\"svs\",\"svx\",\"swb\",\"swc\",\"swf\",\"swg\",\"swh\",\"swi\",\"swj\",\"swk\",\"swl\",\"swm\",\"swn\",\"swo\",\"swp\",\"swq\",\"swr\",\"sws\",\"swt\",\"swu\",\"swv\",\"sww\",\"swx\",\"swy\",\"sxb\",\"sxc\",\"sxe\",\"sxg\",\"sxk\",\"sxl\",\"sxm\",\"sxn\",\"sxo\",\"sxr\",\"sxs\",\"sxu\",\"sxw\",\"sya\",\"syb\",\"syc\",\"syd\",\"syi\",\"syk\",\"syl\",\"sym\",\"syn\",\"syo\",\"syr\",\"sys\",\"syw\",\"syx\",\"syy\",\"sza\",\"szb\",\"szc\",\"szd\",\"sze\",\"szg\",\"szl\",\"szn\",\"szp\",\"szv\",\"szw\",\"taa\",\"tab\",\"tac\",\"tad\",\"tae\",\"taf\",\"tag\",\"tai\",\"taj\",\"tak\",\"tal\",\"tan\",\"tao\",\"tap\",\"taq\",\"tar\",\"tas\",\"tau\",\"tav\",\"taw\",\"tax\",\"tay\",\"taz\",\"tba\",\"tbb\",\"tbc\",\"tbd\",\"tbe\",\"tbf\",\"tbg\",\"tbh\",\"tbi\",\"tbj\",\"tbk\",\"tbl\",\"tbm\",\"tbn\",\"tbo\",\"tbp\",\"tbq\",\"tbr\",\"tbs\",\"tbt\",\"tbu\",\"tbv\",\"tbw\",\"tbx\",\"tby\",\"tbz\",\"tca\",\"tcb\",\"tcc\",\"tcd\",\"tce\",\"tcf\",\"tcg\",\"tch\",\"tci\",\"tck\",\"tcl\",\"tcm\",\"tcn\",\"tco\",\"tcp\",\"tcq\",\"tcs\",\"tct\",\"tcu\",\"tcw\",\"tcx\",\"tcy\",\"tcz\",\"tda\",\"tdb\",\"tdc\",\"tdd\",\"tde\",\"tdf\",\"tdg\",\"tdh\",\"tdi\",\"tdj\",\"tdk\",\"tdl\",\"tdm\",\"tdn\",\"tdo\",\"tdq\",\"tdr\",\"tds\",\"tdt\",\"tdu\",\"tdv\",\"tdx\",\"tdy\",\"tea\",\"teb\",\"tec\",\"ted\",\"tee\",\"tef\",\"teg\",\"teh\",\"tei\",\"tek\",\"tem\",\"ten\",\"teo\",\"tep\",\"teq\",\"ter\",\"tes\",\"tet\",\"teu\",\"tev\",\"tew\",\"tex\",\"tey\",\"tfi\",\"tfn\",\"tfo\",\"tfr\",\"tft\",\"tga\",\"tgb\",\"tgc\",\"tgd\",\"tge\",\"tgf\",\"tgg\",\"tgh\",\"tgi\",\"tgj\",\"tgn\",\"tgo\",\"tgp\",\"tgq\",\"tgr\",\"tgs\",\"tgt\",\"tgu\",\"tgv\",\"tgw\",\"tgx\",\"tgy\",\"tgz\",\"thc\",\"thd\",\"the\",\"thf\",\"thh\",\"thi\",\"thk\",\"thl\",\"thm\",\"thn\",\"thp\",\"thq\",\"thr\",\"ths\",\"tht\",\"thu\",\"thv\",\"thw\",\"thx\",\"thy\",\"thz\",\"tia\",\"tic\",\"tid\",\"tie\",\"tif\",\"tig\",\"tih\",\"tii\",\"tij\",\"tik\",\"til\",\"tim\",\"tin\",\"tio\",\"tip\",\"tiq\",\"tis\",\"tit\",\"tiu\",\"tiv\",\"tiw\",\"tix\",\"tiy\",\"tiz\",\"tja\",\"tjg\",\"tji\",\"tjl\",\"tjm\",\"tjn\",\"tjo\",\"tjs\",\"tju\",\"tjw\",\"tka\",\"tkb\",\"tkd\",\"tke\",\"tkf\",\"tkg\",\"tkk\",\"tkl\",\"tkm\",\"tkn\",\"tkp\",\"tkq\",\"tkr\",\"tks\",\"tkt\",\"tku\",\"tkv\",\"tkw\",\"tkx\",\"tkz\",\"tla\",\"tlb\",\"tlc\",\"tld\",\"tlf\",\"tlg\",\"tlh\",\"tli\",\"tlj\",\"tlk\",\"tll\",\"tlm\",\"tln\",\"tlo\",\"tlp\",\"tlq\",\"tlr\",\"tls\",\"tlt\",\"tlu\",\"tlv\",\"tlw\",\"tlx\",\"tly\",\"tma\",\"tmb\",\"tmc\",\"tmd\",\"tme\",\"tmf\",\"tmg\",\"tmh\",\"tmi\",\"tmj\",\"tmk\",\"tml\",\"tmm\",\"tmn\",\"tmo\",\"tmp\",\"tmq\",\"tmr\",\"tms\",\"tmt\",\"tmu\",\"tmv\",\"tmw\",\"tmy\",\"tmz\",\"tna\",\"tnb\",\"tnc\",\"tnd\",\"tne\",\"tnf\",\"tng\",\"tnh\",\"tni\",\"tnk\",\"tnl\",\"tnm\",\"tnn\",\"tno\",\"tnp\",\"tnq\",\"tnr\",\"tns\",\"tnt\",\"tnu\",\"tnv\",\"tnw\",\"tnx\",\"tny\",\"tnz\",\"tob\",\"toc\",\"tod\",\"toe\",\"tof\",\"tog\",\"toh\",\"toi\",\"toj\",\"tol\",\"tom\",\"too\",\"top\",\"toq\",\"tor\",\"tos\",\"tou\",\"tov\",\"tow\",\"tox\",\"toy\",\"toz\",\"tpa\",\"tpc\",\"tpe\",\"tpf\",\"tpg\",\"tpi\",\"tpj\",\"tpk\",\"tpl\",\"tpm\",\"tpn\",\"tpo\",\"tpp\",\"tpq\",\"tpr\",\"tpt\",\"tpu\",\"tpv\",\"tpw\",\"tpx\",\"tpy\",\"tpz\",\"tqb\",\"tql\",\"tqm\",\"tqn\",\"tqo\",\"tqp\",\"tqq\",\"tqr\",\"tqt\",\"tqu\",\"tqw\",\"tra\",\"trb\",\"trc\",\"trd\",\"tre\",\"trf\",\"trg\",\"trh\",\"tri\",\"trj\",\"trk\",\"trl\",\"trm\",\"trn\",\"tro\",\"trp\",\"trq\",\"trr\",\"trs\",\"trt\",\"tru\",\"trv\",\"trw\",\"trx\",\"try\",\"trz\",\"tsa\",\"tsb\",\"tsc\",\"tsd\",\"tse\",\"tsf\",\"tsg\",\"tsh\",\"tsi\",\"tsj\",\"tsk\",\"tsl\",\"tsm\",\"tsp\",\"tsq\",\"tsr\",\"tss\",\"tst\",\"tsu\",\"tsv\",\"tsw\",\"tsx\",\"tsy\",\"tsz\",\"tta\",\"ttb\",\"ttc\",\"ttd\",\"tte\",\"ttf\",\"ttg\",\"tth\",\"tti\",\"ttj\",\"ttk\",\"ttl\",\"ttm\",\"ttn\",\"tto\",\"ttp\",\"ttq\",\"ttr\",\"tts\",\"ttt\",\"ttu\",\"ttv\",\"ttw\",\"tty\",\"ttz\",\"tua\",\"tub\",\"tuc\",\"tud\",\"tue\",\"tuf\",\"tug\",\"tuh\",\"tui\",\"tuj\",\"tul\",\"tum\",\"tun\",\"tuo\",\"tup\",\"tuq\",\"tus\",\"tut\",\"tuu\",\"tuv\",\"tuw\",\"tux\",\"tuy\",\"tuz\",\"tva\",\"tvd\",\"tve\",\"tvk\",\"tvl\",\"tvm\",\"tvn\",\"tvo\",\"tvs\",\"tvt\",\"tvu\",\"tvw\",\"tvy\",\"twa\",\"twb\",\"twc\",\"twd\",\"twe\",\"twf\",\"twg\",\"twh\",\"twl\",\"twm\",\"twn\",\"two\",\"twp\",\"twq\",\"twr\",\"twt\",\"twu\",\"tww\",\"twx\",\"twy\",\"txa\",\"txb\",\"txc\",\"txe\",\"txg\",\"txh\",\"txi\",\"txj\",\"txm\",\"txn\",\"txo\",\"txq\",\"txr\",\"txs\",\"txt\",\"txu\",\"txx\",\"txy\",\"tya\",\"tye\",\"tyh\",\"tyi\",\"tyj\",\"tyl\",\"tyn\",\"typ\",\"tyr\",\"tys\",\"tyt\",\"tyu\",\"tyv\",\"tyx\",\"tyz\",\"tza\",\"tzh\",\"tzj\",\"tzl\",\"tzm\",\"tzn\",\"tzo\",\"tzx\",\"uam\",\"uan\",\"uar\",\"uba\",\"ubi\",\"ubl\",\"ubr\",\"ubu\",\"uby\",\"uda\",\"ude\",\"udg\",\"udi\",\"udj\",\"udl\",\"udm\",\"udu\",\"ues\",\"ufi\",\"uga\",\"ugb\",\"uge\",\"ugn\",\"ugo\",\"ugy\",\"uha\",\"uhn\",\"uis\",\"uiv\",\"uji\",\"uka\",\"ukg\",\"ukh\",\"ukl\",\"ukp\",\"ukq\",\"uks\",\"uku\",\"ukw\",\"uky\",\"ula\",\"ulb\",\"ulc\",\"ule\",\"ulf\",\"uli\",\"ulk\",\"ull\",\"ulm\",\"uln\",\"ulu\",\"ulw\",\"uma\",\"umb\",\"umc\",\"umd\",\"umg\",\"umi\",\"umm\",\"umn\",\"umo\",\"ump\",\"umr\",\"ums\",\"umu\",\"una\",\"und\",\"une\",\"ung\",\"unk\",\"unm\",\"unn\",\"unp\",\"unr\",\"unu\",\"unx\",\"unz\",\"uok\",\"upi\",\"upv\",\"ura\",\"urb\",\"urc\",\"ure\",\"urf\",\"urg\",\"urh\",\"uri\",\"urj\",\"urk\",\"url\",\"urm\",\"urn\",\"uro\",\"urp\",\"urr\",\"urt\",\"uru\",\"urv\",\"urw\",\"urx\",\"ury\",\"urz\",\"usa\",\"ush\",\"usi\",\"usk\",\"usp\",\"usu\",\"uta\",\"ute\",\"utp\",\"utr\",\"utu\",\"uum\",\"uun\",\"uur\",\"uuu\",\"uve\",\"uvh\",\"uvl\",\"uwa\",\"uya\",\"uzn\",\"uzs\",\"vaa\",\"vae\",\"vaf\",\"vag\",\"vah\",\"vai\",\"vaj\",\"val\",\"vam\",\"van\",\"vao\",\"vap\",\"var\",\"vas\",\"vau\",\"vav\",\"vay\",\"vbb\",\"vbk\",\"vec\",\"ved\",\"vel\",\"vem\",\"veo\",\"vep\",\"ver\",\"vgr\",\"vgt\",\"vic\",\"vid\",\"vif\",\"vig\",\"vil\",\"vin\",\"vis\",\"vit\",\"viv\",\"vka\",\"vki\",\"vkj\",\"vkk\",\"vkl\",\"vkm\",\"vko\",\"vkp\",\"vkt\",\"vku\",\"vlp\",\"vls\",\"vma\",\"vmb\",\"vmc\",\"vmd\",\"vme\",\"vmf\",\"vmg\",\"vmh\",\"vmi\",\"vmj\",\"vmk\",\"vml\",\"vmm\",\"vmp\",\"vmq\",\"vmr\",\"vms\",\"vmu\",\"vmv\",\"vmw\",\"vmx\",\"vmy\",\"vmz\",\"vnk\",\"vnm\",\"vnp\",\"vor\",\"vot\",\"vra\",\"vro\",\"vrs\",\"vrt\",\"vsi\",\"vsl\",\"vsv\",\"vto\",\"vum\",\"vun\",\"vut\",\"vwa\",\"waa\",\"wab\",\"wac\",\"wad\",\"wae\",\"waf\",\"wag\",\"wah\",\"wai\",\"waj\",\"wak\",\"wal\",\"wam\",\"wan\",\"wao\",\"wap\",\"waq\",\"war\",\"was\",\"wat\",\"wau\",\"wav\",\"waw\",\"wax\",\"way\",\"waz\",\"wba\",\"wbb\",\"wbe\",\"wbf\",\"wbh\",\"wbi\",\"wbj\",\"wbk\",\"wbl\",\"wbm\",\"wbp\",\"wbq\",\"wbr\",\"wbt\",\"wbv\",\"wbw\",\"wca\",\"wci\",\"wdd\",\"wdg\",\"wdj\",\"wdk\",\"wdu\",\"wdy\",\"wea\",\"wec\",\"wed\",\"weg\",\"weh\",\"wei\",\"wem\",\"wen\",\"weo\",\"wep\",\"wer\",\"wes\",\"wet\",\"weu\",\"wew\",\"wfg\",\"wga\",\"wgb\",\"wgg\",\"wgi\",\"wgo\",\"wgu\",\"wgw\",\"wgy\",\"wha\",\"whg\",\"whk\",\"whu\",\"wib\",\"wic\",\"wie\",\"wif\",\"wig\",\"wih\",\"wii\",\"wij\",\"wik\",\"wil\",\"wim\",\"win\",\"wir\",\"wit\",\"wiu\",\"wiv\",\"wiw\",\"wiy\",\"wja\",\"wji\",\"wka\",\"wkb\",\"wkd\",\"wkl\",\"wku\",\"wkw\",\"wky\",\"wla\",\"wlc\",\"wle\",\"wlg\",\"wli\",\"wlk\",\"wll\",\"wlm\",\"wlo\",\"wlr\",\"wls\",\"wlu\",\"wlv\",\"wlw\",\"wlx\",\"wly\",\"wma\",\"wmb\",\"wmc\",\"wmd\",\"wme\",\"wmh\",\"wmi\",\"wmm\",\"wmn\",\"wmo\",\"wms\",\"wmt\",\"wmw\",\"wmx\",\"wnb\",\"wnc\",\"wnd\",\"wne\",\"wng\",\"wni\",\"wnk\",\"wnm\",\"wnn\",\"wno\",\"wnp\",\"wnu\",\"wnw\",\"wny\",\"woa\",\"wob\",\"woc\",\"wod\",\"woe\",\"wof\",\"wog\",\"woi\",\"wok\",\"wom\",\"won\",\"woo\",\"wor\",\"wos\",\"wow\",\"woy\",\"wpc\",\"wra\",\"wrb\",\"wrd\",\"wrg\",\"wrh\",\"wri\",\"wrk\",\"wrl\",\"wrm\",\"wrn\",\"wro\",\"wrp\",\"wrr\",\"wrs\",\"wru\",\"wrv\",\"wrw\",\"wrx\",\"wry\",\"wrz\",\"wsa\",\"wsg\",\"wsi\",\"wsk\",\"wsr\",\"wss\",\"wsu\",\"wsv\",\"wtf\",\"wth\",\"wti\",\"wtk\",\"wtm\",\"wtw\",\"wua\",\"wub\",\"wud\",\"wuh\",\"wul\",\"wum\",\"wun\",\"wur\",\"wut\",\"wuu\",\"wuv\",\"wux\",\"wuy\",\"wwa\",\"wwb\",\"wwo\",\"wwr\",\"www\",\"wxa\",\"wxw\",\"wya\",\"wyb\",\"wyi\",\"wym\",\"wyr\",\"wyy\",\"xaa\",\"xab\",\"xac\",\"xad\",\"xae\",\"xag\",\"xai\",\"xaj\",\"xak\",\"xal\",\"xam\",\"xan\",\"xao\",\"xap\",\"xaq\",\"xar\",\"xas\",\"xat\",\"xau\",\"xav\",\"xaw\",\"xay\",\"xba\",\"xbb\",\"xbc\",\"xbd\",\"xbe\",\"xbg\",\"xbi\",\"xbj\",\"xbm\",\"xbn\",\"xbo\",\"xbp\",\"xbr\",\"xbw\",\"xbx\",\"xby\",\"xcb\",\"xcc\",\"xce\",\"xcg\",\"xch\",\"xcl\",\"xcm\",\"xcn\",\"xco\",\"xcr\",\"xct\",\"xcu\",\"xcv\",\"xcw\",\"xcy\",\"xda\",\"xdc\",\"xdk\",\"xdm\",\"xdy\",\"xeb\",\"xed\",\"xeg\",\"xel\",\"xem\",\"xep\",\"xer\",\"xes\",\"xet\",\"xeu\",\"xfa\",\"xga\",\"xgb\",\"xgd\",\"xgf\",\"xgg\",\"xgi\",\"xgl\",\"xgm\",\"xgn\",\"xgr\",\"xgu\",\"xgw\",\"xha\",\"xhc\",\"xhd\",\"xhe\",\"xhr\",\"xht\",\"xhu\",\"xhv\",\"xia\",\"xib\",\"xii\",\"xil\",\"xin\",\"xip\",\"xir\",\"xis\",\"xiv\",\"xiy\",\"xjb\",\"xjt\",\"xka\",\"xkb\",\"xkc\",\"xkd\",\"xke\",\"xkf\",\"xkg\",\"xkh\",\"xki\",\"xkj\",\"xkk\",\"xkl\",\"xkn\",\"xko\",\"xkp\",\"xkq\",\"xkr\",\"xks\",\"xkt\",\"xku\",\"xkv\",\"xkw\",\"xkx\",\"xky\",\"xkz\",\"xla\",\"xlb\",\"xlc\",\"xld\",\"xle\",\"xlg\",\"xli\",\"xln\",\"xlo\",\"xlp\",\"xls\",\"xlu\",\"xly\",\"xma\",\"xmb\",\"xmc\",\"xmd\",\"xme\",\"xmf\",\"xmg\",\"xmh\",\"xmj\",\"xmk\",\"xml\",\"xmm\",\"xmn\",\"xmo\",\"xmp\",\"xmq\",\"xmr\",\"xms\",\"xmt\",\"xmu\",\"xmv\",\"xmw\",\"xmx\",\"xmy\",\"xmz\",\"xna\",\"xnb\",\"xnd\",\"xng\",\"xnh\",\"xni\",\"xnk\",\"xnn\",\"xno\",\"xnr\",\"xns\",\"xnt\",\"xnu\",\"xny\",\"xnz\",\"xoc\",\"xod\",\"xog\",\"xoi\",\"xok\",\"xom\",\"xon\",\"xoo\",\"xop\",\"xor\",\"xow\",\"xpa\",\"xpc\",\"xpe\",\"xpg\",\"xpi\",\"xpj\",\"xpk\",\"xpm\",\"xpn\",\"xpo\",\"xpp\",\"xpq\",\"xpr\",\"xps\",\"xpt\",\"xpu\",\"xpy\",\"xqa\",\"xqt\",\"xra\",\"xrb\",\"xrd\",\"xre\",\"xrg\",\"xri\",\"xrm\",\"xrn\",\"xrq\",\"xrr\",\"xrt\",\"xru\",\"xrw\",\"xsa\",\"xsb\",\"xsc\",\"xsd\",\"xse\",\"xsh\",\"xsi\",\"xsj\",\"xsl\",\"xsm\",\"xsn\",\"xso\",\"xsp\",\"xsq\",\"xsr\",\"xss\",\"xsu\",\"xsv\",\"xsy\",\"xta\",\"xtb\",\"xtc\",\"xtd\",\"xte\",\"xtg\",\"xth\",\"xti\",\"xtj\",\"xtl\",\"xtm\",\"xtn\",\"xto\",\"xtp\",\"xtq\",\"xtr\",\"xts\",\"xtt\",\"xtu\",\"xtv\",\"xtw\",\"xty\",\"xtz\",\"xua\",\"xub\",\"xud\",\"xug\",\"xuj\",\"xul\",\"xum\",\"xun\",\"xuo\",\"xup\",\"xur\",\"xut\",\"xuu\",\"xve\",\"xvi\",\"xvn\",\"xvo\",\"xvs\",\"xwa\",\"xwc\",\"xwd\",\"xwe\",\"xwg\",\"xwj\",\"xwk\",\"xwl\",\"xwo\",\"xwr\",\"xwt\",\"xww\",\"xxb\",\"xxk\",\"xxm\",\"xxr\",\"xxt\",\"xya\",\"xyb\",\"xyj\",\"xyk\",\"xyl\",\"xyt\",\"xyy\",\"xzh\",\"xzm\",\"xzp\",\"yaa\",\"yab\",\"yac\",\"yad\",\"yae\",\"yaf\",\"yag\",\"yah\",\"yai\",\"yaj\",\"yak\",\"yal\",\"yam\",\"yan\",\"yao\",\"yap\",\"yaq\",\"yar\",\"yas\",\"yat\",\"yau\",\"yav\",\"yaw\",\"yax\",\"yay\",\"yaz\",\"yba\",\"ybb\",\"ybd\",\"ybe\",\"ybh\",\"ybi\",\"ybj\",\"ybk\",\"ybl\",\"ybm\",\"ybn\",\"ybo\",\"ybx\",\"yby\",\"ych\",\"ycl\",\"ycn\",\"ycp\",\"yda\",\"ydd\",\"yde\",\"ydg\",\"ydk\",\"yds\",\"yea\",\"yec\",\"yee\",\"yei\",\"yej\",\"yel\",\"yen\",\"yer\",\"yes\",\"yet\",\"yeu\",\"yev\",\"yey\",\"yga\",\"ygi\",\"ygl\",\"ygm\",\"ygp\",\"ygr\",\"ygs\",\"ygu\",\"ygw\",\"yha\",\"yhd\",\"yhl\",\"yhs\",\"yia\",\"yif\",\"yig\",\"yih\",\"yii\",\"yij\",\"yik\",\"yil\",\"yim\",\"yin\",\"yip\",\"yiq\",\"yir\",\"yis\",\"yit\",\"yiu\",\"yiv\",\"yix\",\"yiy\",\"yiz\",\"yka\",\"ykg\",\"yki\",\"ykk\",\"ykl\",\"ykm\",\"ykn\",\"yko\",\"ykr\",\"ykt\",\"yku\",\"yky\",\"yla\",\"ylb\",\"yle\",\"ylg\",\"yli\",\"yll\",\"ylm\",\"yln\",\"ylo\",\"ylr\",\"ylu\",\"yly\",\"yma\",\"ymb\",\"ymc\",\"ymd\",\"yme\",\"ymg\",\"ymh\",\"ymi\",\"ymk\",\"yml\",\"ymm\",\"ymn\",\"ymo\",\"ymp\",\"ymq\",\"ymr\",\"yms\",\"ymt\",\"ymx\",\"ymz\",\"yna\",\"ynd\",\"yne\",\"yng\",\"ynh\",\"ynk\",\"ynl\",\"ynn\",\"yno\",\"ynq\",\"yns\",\"ynu\",\"yob\",\"yog\",\"yoi\",\"yok\",\"yol\",\"yom\",\"yon\",\"yos\",\"yot\",\"yox\",\"yoy\",\"ypa\",\"ypb\",\"ypg\",\"yph\",\"ypk\",\"ypm\",\"ypn\",\"ypo\",\"ypp\",\"ypz\",\"yra\",\"yrb\",\"yre\",\"yri\",\"yrk\",\"yrl\",\"yrm\",\"yrn\",\"yro\",\"yrs\",\"yrw\",\"yry\",\"ysc\",\"ysd\",\"ysg\",\"ysl\",\"ysn\",\"yso\",\"ysp\",\"ysr\",\"yss\",\"ysy\",\"yta\",\"ytl\",\"ytp\",\"ytw\",\"yty\",\"yua\",\"yub\",\"yuc\",\"yud\",\"yue\",\"yuf\",\"yug\",\"yui\",\"yuj\",\"yuk\",\"yul\",\"yum\",\"yun\",\"yup\",\"yuq\",\"yur\",\"yut\",\"yuu\",\"yuw\",\"yux\",\"yuy\",\"yuz\",\"yva\",\"yvt\",\"ywa\",\"ywg\",\"ywl\",\"ywn\",\"ywq\",\"ywr\",\"ywt\",\"ywu\",\"yww\",\"yxa\",\"yxg\",\"yxl\",\"yxm\",\"yxu\",\"yxy\",\"yyr\",\"yyu\",\"yyz\",\"yzg\",\"yzk\",\"zaa\",\"zab\",\"zac\",\"zad\",\"zae\",\"zaf\",\"zag\",\"zah\",\"zai\",\"zaj\",\"zak\",\"zal\",\"zam\",\"zao\",\"zap\",\"zaq\",\"zar\",\"zas\",\"zat\",\"zau\",\"zav\",\"zaw\",\"zax\",\"zay\",\"zaz\",\"zbc\",\"zbe\",\"zbl\",\"zbt\",\"zbw\",\"zca\",\"zch\",\"zdj\",\"zea\",\"zeg\",\"zeh\",\"zen\",\"zga\",\"zgb\",\"zgh\",\"zgm\",\"zgn\",\"zgr\",\"zhb\",\"zhd\",\"zhi\",\"zhn\",\"zhw\",\"zhx\",\"zia\",\"zib\",\"zik\",\"zil\",\"zim\",\"zin\",\"zir\",\"ziw\",\"ziz\",\"zka\",\"zkb\",\"zkd\",\"zkg\",\"zkh\",\"zkk\",\"zkn\",\"zko\",\"zkp\",\"zkr\",\"zkt\",\"zku\",\"zkv\",\"zkz\",\"zle\",\"zlj\",\"zlm\",\"zln\",\"zlq\",\"zls\",\"zlw\",\"zma\",\"zmb\",\"zmc\",\"zmd\",\"zme\",\"zmf\",\"zmg\",\"zmh\",\"zmi\",\"zmj\",\"zmk\",\"zml\",\"zmm\",\"zmn\",\"zmo\",\"zmp\",\"zmq\",\"zmr\",\"zms\",\"zmt\",\"zmu\",\"zmv\",\"zmw\",\"zmx\",\"zmy\",\"zmz\",\"zna\",\"znd\",\"zne\",\"zng\",\"znk\",\"zns\",\"zoc\",\"zoh\",\"zom\",\"zoo\",\"zoq\",\"zor\",\"zos\",\"zpa\",\"zpb\",\"zpc\",\"zpd\",\"zpe\",\"zpf\",\"zpg\",\"zph\",\"zpi\",\"zpj\",\"zpk\",\"zpl\",\"zpm\",\"zpn\",\"zpo\",\"zpp\",\"zpq\",\"zpr\",\"zps\",\"zpt\",\"zpu\",\"zpv\",\"zpw\",\"zpx\",\"zpy\",\"zpz\",\"zqe\",\"zra\",\"zrg\",\"zrn\",\"zro\",\"zrp\",\"zrs\",\"zsa\",\"zsk\",\"zsl\",\"zsm\",\"zsr\",\"zsu\",\"zte\",\"ztg\",\"ztl\",\"ztm\",\"ztn\",\"ztp\",\"ztq\",\"zts\",\"ztt\",\"ztu\",\"ztx\",\"zty\",\"zua\",\"zuh\",\"zum\",\"zun\",\"zuy\",\"zwa\",\"zxx\",\"zyb\",\"zyg\",\"zyj\",\"zyn\",\"zyp\",\"zza\",\"zzj\"],\nevaluate:function(a,b){function c(a){return a.trim().split(\"-\")[0].toLowerCase()}var d,e;return d=(b||[]).map(c),e=[\"lang\",\"xml:lang\"].reduce(function(b,e){var f=a.getAttribute(e);if(\"string\"!=typeof f)return b;var g=c(f);return\"\"!==g&&-1===d.indexOf(g)&&b.push(e+'=\"'+a.getAttribute(e)+'\"'),b},[]),!!e.length&&(this.data(e),!0)}},{id:\"dlitem\",evaluate:function(a,b){return\"DL\"===a.parentNode.tagName}},{id:\"has-listitem\",evaluate:function(a,b){var c=a.children;if(0===c.length)return!0;for(var d=0;d<c.length;d++)if(\"LI\"===c[d].nodeName.toUpperCase())return!1;return!0}},{id:\"listitem\",evaluate:function(a,b){return-1!==[\"UL\",\"OL\"].indexOf(a.parentNode.nodeName.toUpperCase())||\"list\"===a.parentNode.getAttribute(\"role\")}},{id:\"only-dlitems\",evaluate:function(a,b){for(var c,d,e=[],f=a.childNodes,g=[\"STYLE\",\"META\",\"LINK\",\"MAP\",\"AREA\",\"SCRIPT\",\"DATALIST\",\"TEMPLATE\"],h=!1,i=0;i<f.length;i++){c=f[i];var d=c.nodeName.toUpperCase();1===c.nodeType&&\"DT\"!==d&&\"DD\"!==d&&-1===g.indexOf(d)?e.push(c):3===c.nodeType&&\"\"!==c.nodeValue.trim()&&(h=!0)}return e.length&&this.relatedNodes(e),!!e.length||h}},{id:\"only-listitems\",evaluate:function(a,b){for(var c,d,e=[],f=a.childNodes,g=[\"STYLE\",\"META\",\"LINK\",\"MAP\",\"AREA\",\"SCRIPT\",\"DATALIST\",\"TEMPLATE\"],h=!1,i=0;i<f.length;i++)c=f[i],d=c.nodeName.toUpperCase(),1===c.nodeType&&\"LI\"!==d&&-1===g.indexOf(d)?e.push(c):3===c.nodeType&&\"\"!==c.nodeValue.trim()&&(h=!0);return e.length&&this.relatedNodes(e),!!e.length||h}},{id:\"structured-dlitems\",evaluate:function(a,b){var c=a.children;if(!c||!c.length)return!1;for(var d,e=!1,f=!1,g=0;g<c.length;g++){if(d=c[g].nodeName.toUpperCase(),\"DT\"===d&&(e=!0),e&&\"DD\"===d)return!1;\"DD\"===d&&(f=!0)}return e||f}},{id:\"caption\",evaluate:function(a,b){var c=a.querySelectorAll(\"track\");if(c.length){for(var d=0;d<c.length;d++){var e=c[d].getAttribute(\"kind\");if(e&&\"captions\"===e)return!1}return!0}}},{id:\"description\",evaluate:function(a,b){var c=a.querySelectorAll(\"track\");if(c.length){for(var d=0;d<c.length;d++){var e=c[d].getAttribute(\"kind\");if(e&&\"descriptions\"===e)return!1}return!0}}},{id:\"meta-viewport-large\",evaluate:function(a,b){b=b||{};for(var c,d=a.getAttribute(\"content\")||\"\",e=d.split(/[;,]/),f={},g=b.scaleMinimum||2,h=b.lowerBound||!1,i=0,j=e.length;i<j;i++){c=e[i].split(\"=\");var k=c.shift().toLowerCase();k&&c.length&&(f[k.trim()]=c.shift().trim().toLowerCase())}return!!(h&&f[\"maximum-scale\"]&&parseFloat(f[\"maximum-scale\"])<h)||!(!h&&\"no\"===f[\"user-scalable\"])&&!(f[\"maximum-scale\"]&&parseFloat(f[\"maximum-scale\"])<g)},options:{scaleMinimum:5,lowerBound:2}},{id:\"meta-viewport\",evaluate:function(a,b){b=b||{};for(var c,d=a.getAttribute(\"content\")||\"\",e=d.split(/[;,]/),f={},g=b.scaleMinimum||2,h=b.lowerBound||!1,i=0,j=e.length;i<j;i++){c=e[i].split(\"=\");var k=c.shift().toLowerCase();k&&c.length&&(f[k.trim()]=c.shift().trim().toLowerCase())}return!!(h&&f[\"maximum-scale\"]&&parseFloat(f[\"maximum-scale\"])<h)||!(!h&&\"no\"===f[\"user-scalable\"])&&!(f[\"maximum-scale\"]&&parseFloat(f[\"maximum-scale\"])<g)},options:{scaleMinimum:2}},{id:\"header-present\",evaluate:function(a,b){return!!a.querySelector('h1, h2, h3, h4, h5, h6, [role=\"heading\"]')}},{id:\"heading-order\",evaluate:function(a,b){var c=a.getAttribute(\"aria-level\");if(null!==c)return this.data(parseInt(c,10)),!0;var d=a.tagName.match(/H(\\d)/);return!d||(this.data(parseInt(d[1],10)),!0)},after:function(a,b){if(a.length<2)return a;for(var c=a[0].data,d=1;d<a.length;d++)a[d].result&&a[d].data>c+1&&(a[d].result=!1),c=a[d].data;return a}},{id:\"href-no-hash\",evaluate:function(a,b){return\"#\"!==a.getAttribute(\"href\")}},{id:\"internal-link-present\",evaluate:function(a,b){return!!a.querySelector('a[href^=\"#\"]')}},{id:\"landmark\",evaluate:function(a,b){return a.getElementsByTagName(\"main\").length>0||!!a.querySelector('[role=\"main\"]')}},{id:\"meta-refresh\",evaluate:function(a,b){var c=a.getAttribute(\"content\")||\"\",d=c.split(/[;,]/);return\"\"===c||\"0\"===d[0]}},{id:\"p-as-heading\",evaluate:function(a,b){function c(a){for(var b=a,c=a.textContent.trim(),d=c;d===c&&void 0!==b;){var e=-1;if(a=b,0===a.children.length)return a;do{e++,d=a.children[e].textContent.trim()}while(\"\"===d&&e+1<a.children.length);b=a.children[e]}return a}function d(a){switch(a){case\"lighter\":return 100;case\"normal\":return 400;case\"bold\":return 700;case\"bolder\":return 900}return a=parseInt(a),isNaN(a)?400:a}function e(a){var b=window.getComputedStyle(c(a));return{fontWeight:d(b.getPropertyValue(\"font-weight\")),fontSize:parseInt(b.getPropertyValue(\"font-size\")),isItalic:\"italic\"===b.getPropertyValue(\"font-style\")}}function f(a,b,c){return c.reduce(function(c,d){return c||(!d.size||a.fontSize/d.size>b.fontSize)&&(!d.weight||a.fontWeight-d.weight>b.fontWeight)&&(!d.italic||a.isItalic&&!b.isItalic)},!1)}var g=Array.from(a.parentNode.children),h=g.indexOf(a);b=b||{};var i=b.margins||[],j=g.slice(h+1).find(function(a){return\"P\"===a.nodeName.toUpperCase()}),k=g.slice(0,h).reverse().find(function(a){return\"P\"===a.nodeName.toUpperCase()}),l=e(a),m=j?e(j):null,n=k?e(k):null;if(!m||!f(l,m,i))return!0;var o=axe.commons.dom.findUp(a,\"blockquote\");return!!(o&&\"BLOCKQUOTE\"===o.nodeName.toUpperCase()||n&&!f(l,n,i))&&void 0},options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]}},{id:\"region\",evaluate:function(a,b){function c(a){return h&&axe.commons.dom.isFocusable(axe.commons.dom.getElementByReference(h,\"href\"))&&h===a}function d(a){var b=a.getAttribute(\"role\");return b&&-1!==g.indexOf(b)}function e(a){return d(a)?null:c(a)?f(a):axe.commons.dom.isVisible(a,!0)&&(axe.commons.text.visible(a,!0,!0)||axe.commons.dom.isVisualContent(a))?a:f(a)}function f(a){var b=axe.commons.utils.toArray(a.children);return 0===b.length?[]:b.map(e).filter(function(a){return null!==a}).reduce(function(a,b){return a.concat(b)},[])}var g=axe.commons.aria.getRolesByType(\"landmark\"),h=a.querySelector(\"a[href]\"),i=f(a);return this.relatedNodes(i),!i.length},after:function(a,b){return[a[0]]}},{id:\"skip-link\",evaluate:function(a,b){return axe.commons.dom.isFocusable(axe.commons.dom.getElementByReference(a,\"href\"))},after:function(a,b){return[a[0]]}},{id:\"unique-frame-title\",evaluate:function(a,b){var c=axe.commons.text.sanitize(a.title).trim().toLowerCase();return this.data(c),!0},after:function(a,b){var c={};return a.forEach(function(a){c[a.data]=void 0!==c[a.data]?++c[a.data]:0}),a.forEach(function(a){a.result=!!c[a.data]}),a}},{id:\"aria-label\",evaluate:function(a,b){var c=a.getAttribute(\"aria-label\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"aria-labelledby\",evaluate:function(a,b){return(0,axe.commons.dom.idrefs)(a,\"aria-labelledby\").some(function(a){return a&&axe.commons.text.accessibleText(a,!0)})}},{id:\"button-has-visible-text\",evaluate:function(a,b){var c=a.nodeName.toUpperCase(),d=a.getAttribute(\"role\"),e=void 0;return(\"BUTTON\"===c||\"button\"===d&&\"INPUT\"!==c)&&(e=axe.commons.text.accessibleText(a),this.data(e),!!e)}},{id:\"doc-has-title\",evaluate:function(a,b){var c=document.title;return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"duplicate-id\",evaluate:function(a,b){if(!a.id.trim())return!0;for(var c=document.querySelectorAll('[id=\"'+axe.commons.utils.escapeSelector(a.id)+'\"]'),d=[],e=0;e<c.length;e++)c[e]!==a&&d.push(c[e]);return d.length&&this.relatedNodes(d),this.data(a.getAttribute(\"id\")),c.length<=1},after:function(a,b){var c=[];return a.filter(function(a){return-1===c.indexOf(a.data)&&(c.push(a.data),!0)})}},{id:\"exists\",evaluate:function(a,b){return!0}},{id:\"has-alt\",evaluate:function(a,b){var c=a.nodeName.toLowerCase();return a.hasAttribute(\"alt\")&&(\"img\"===c||\"input\"===c||\"area\"===c)}},{id:\"has-visible-text\",evaluate:function(a,b){return axe.commons.text.accessibleText(a).length>0}},{id:\"is-on-screen\",evaluate:function(a,b){return axe.commons.dom.isVisible(a,!1)&&!axe.commons.dom.isOffscreen(a)}},{id:\"non-empty-alt\",evaluate:function(a,b){var c=a.getAttribute(\"alt\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"non-empty-if-present\",evaluate:function(a,b){var c=a.nodeName.toUpperCase(),d=(a.getAttribute(\"type\")||\"\").toLowerCase(),e=a.getAttribute(\"value\");return this.data(e),\"INPUT\"===c&&-1!==[\"submit\",\"reset\"].indexOf(d)&&null===e}},{id:\"non-empty-title\",evaluate:function(a,b){var c=a.getAttribute(\"title\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"non-empty-value\",evaluate:function(a,b){var c=a.getAttribute(\"value\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"role-none\",evaluate:function(a,b){return\"none\"===a.getAttribute(\"role\")}},{id:\"role-presentation\",evaluate:function(a,b){return\"presentation\"===a.getAttribute(\"role\")}},{id:\"caption-faked\",evaluate:function(a,b){var c=axe.commons.table.toGrid(a),d=c[0];return c.length<=1||d.length<=1||a.rows.length<=1||d.reduce(function(a,b,c){return a||b!==d[c+1]&&void 0!==d[c+1]},!1)}},{id:\"has-caption\",evaluate:function(a,b){return!!a.caption}},{id:\"has-summary\",evaluate:function(a,b){return!!a.summary}},{id:\"has-th\",evaluate:function(a,b){for(var c,d,e=[],f=0,g=a.rows.length;f<g;f++){c=a.rows[f];for(var h=0,i=c.cells.length;h<i;h++)d=c.cells[h],\"TH\"!==d.nodeName.toUpperCase()&&-1===[\"rowheader\",\"columnheader\"].indexOf(d.getAttribute(\"role\"))||e.push(d)}return!!e.length&&(this.relatedNodes(e),!0)}},{id:\"html5-scope\",evaluate:function(a,b){return!axe.commons.dom.isHTML5(document)||\"TH\"===a.nodeName.toUpperCase()}},{id:\"same-caption-summary\",evaluate:function(a,b){return!(!a.summary||!a.caption)&&a.summary===axe.commons.text.accessibleText(a.caption)}},{id:\"scope-value\",evaluate:function(a,b){b=b||{};var c=a.getAttribute(\"scope\").toLowerCase();return-1!==([\"row\",\"col\",\"rowgroup\",\"colgroup\"]||b.values).indexOf(c)}},{id:\"td-has-header\",evaluate:function(a,b){var c=axe.commons.table,d=[];return c.getAllCells(a).forEach(function(a){if(axe.commons.dom.hasContent(a)&&c.isDataCell(a)&&!axe.commons.aria.label(a)){var b=c.getHeaders(a);(b=b.reduce(function(a,b){return a||null!==b&&!!axe.commons.dom.hasContent(b)},!1))||d.push(a)}}),!d.length||(this.relatedNodes(d),!1)}},{id:\"td-headers-attr\",evaluate:function(a,b){for(var c=[],d=0,e=a.rows.length;d<e;d++)for(var f=a.rows[d],g=0,h=f.cells.length;g<h;g++)c.push(f.cells[g]);var i=c.reduce(function(a,b){return b.id&&a.push(b.id),a},[]),j=c.reduce(function(a,b){var c,d,e=(b.getAttribute(\"headers\")||\"\").split(/\\s/).reduce(function(a,b){return b=b.trim(),b&&a.push(b),a},[]);return 0!==e.length&&(b.id&&(c=-1!==e.indexOf(b.id.trim())),d=e.reduce(function(a,b){return a||-1===i.indexOf(b)},!1),(c||d)&&a.push(b)),a},[]);return!(j.length>0)||(this.relatedNodes(j),!1)}},{id:\"th-has-data-cells\",evaluate:function(a,b){var c=axe.commons.table,d=c.getAllCells(a),e=this,f=[];d.forEach(function(a){var b=a.getAttribute(\"headers\");b&&(f=f.concat(b.split(/\\s+/)));var c=a.getAttribute(\"aria-labelledby\");c&&(f=f.concat(c.split(/\\s+/)))});var g=d.filter(function(a){return\"\"!==axe.commons.text.sanitize(a.textContent)&&(\"TH\"===a.nodeName.toUpperCase()||-1!==[\"rowheader\",\"columnheader\"].indexOf(a.getAttribute(\"role\")))}),h=c.toGrid(a);return!!g.reduce(function(a,b){if(b.id&&-1!==f.indexOf(b.id))return!!a||a;var d=!1,g=c.getCellPosition(b,h);return c.isColumnHeader(b)&&(d=c.traverse(\"down\",g,h).reduce(function(a,b){return a||axe.commons.dom.hasContent(b)&&!c.isColumnHeader(b)},!1)),!d&&c.isRowHeader(b)&&(d=c.traverse(\"right\",g,h).reduce(function(a,b){return a||axe.commons.dom.hasContent(b)&&!c.isRowHeader(b)},!1)),d||e.relatedNodes(b),a&&d},!0)||void 0}}],commons:function(){function a(a){return a.getPropertyValue(\"font-family\").split(/[,;]/g).map(function(a){return a.trim().toLowerCase()})}function b(b,c){var d=window.getComputedStyle(b);if(\"none\"!==d.getPropertyValue(\"background-image\"))return!0;if([\"border-bottom\",\"border-top\",\"outline\"].reduce(function(a,b){var c=new v.Color;return c.parseRgbString(d.getPropertyValue(b+\"-color\")),a||\"none\"!==d.getPropertyValue(b+\"-style\")&&parseFloat(d.getPropertyValue(b+\"-width\"))>0&&0!==c.alpha},!1))return!0;var e=window.getComputedStyle(c);if(a(d)[0]!==a(e)[0])return!0;var f=[\"text-decoration-line\",\"text-decoration-style\",\"font-weight\",\"font-style\",\"font-size\"].reduce(function(a,b){return a||d.getPropertyValue(b)!==e.getPropertyValue(b)},!1),g=d.getPropertyValue(\"text-decoration\");return g.split(\" \").length<3&&(f=f||g!==e.getPropertyValue(\"text-decoration\")),f}function c(a,b){var c=a.nodeName.toUpperCase();if(z.includes(c))return axe.commons.color.incompleteData.set(\"bgColor\",{reason:\"imgNode\"}),!0;b=b||window.getComputedStyle(a);var d=b.getPropertyValue(\"background-image\"),e=\"none\"!==d;if(e){var f=/gradient/.test(d);axe.commons.color.incompleteData.set(\"bgColor\",{reason:f?\"bgGradient\":\"bgImage\"})}return e}function d(a,b){b=b||window.getComputedStyle(a);var c=new v.Color;if(c.parseRgbString(b.getPropertyValue(\"background-color\")),0!==c.alpha){var d=b.getPropertyValue(\"opacity\");c.alpha=c.alpha*d}return c}function e(a,b){var c=0;if(a>0)for(var e=a-1;e>=0;e--){var f=b[e],g=window.getComputedStyle(f),h=d(f,g);h.alpha?c+=h.alpha:b.splice(e,1)}return c}function f(a,b,c){return a!==b&&!w.visuallyContains(a,b)&&0!==c.alpha}function g(a,b){\"use strict\";var c=b(a);for(a=a.firstChild;a;)!1!==c&&g(a,b),a=a.nextSibling}function h(a){\"use strict\";var b=window.getComputedStyle(a).getPropertyValue(\"display\");return-1!==A.indexOf(b)||\"table-\"===b.substr(0,6)}function i(a){\"use strict\";var b=a.match(/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/);return!(!b||5!==b.length)&&(b[3]-b[1]<=0&&b[2]-b[4]<=0)}function j(a){var b=null;return a.id&&(b=document.querySelector('label[for=\"'+axe.utils.escapeSelector(a.id)+'\"]'))?b:b=w.findUp(a,\"label\")}function k(a){return-1!==[\"button\",\"reset\",\"submit\"].indexOf(a.type)}function l(a){var b=a.nodeName.toUpperCase();return\"TEXTAREA\"===b||\"SELECT\"===b||\"INPUT\"===b&&\"hidden\"!==a.type.toLowerCase()}function m(a){return-1!==[\"BUTTON\",\"SUMMARY\",\"A\"].indexOf(a.nodeName.toUpperCase())}function n(a){return-1!==[\"TABLE\",\"FIGURE\"].indexOf(a.nodeName.toUpperCase())}function o(a){var b=a.nodeName.toUpperCase();if(\"INPUT\"===b)return!a.hasAttribute(\"type\")||-1!==D.indexOf(a.getAttribute(\"type\").toLowerCase())&&a.value?a.value:\"\";if(\"SELECT\"===b){var c=a.options;if(c&&c.length){for(var d=\"\",e=0;e<c.length;e++)c[e].selected&&(d+=\" \"+c[e].text);return y.sanitize(d)}return\"\"}return\"TEXTAREA\"===b&&a.value?a.value:\"\"}function p(a,b){var c=a.querySelector(b.toLowerCase());return c?y.accessibleText(c):\"\"}function q(a){if(!a)return!1;switch(a.nodeName.toUpperCase()){case\"SELECT\":case\"TEXTAREA\":return!0;case\"INPUT\":return!a.hasAttribute(\"type\")||-1!==D.indexOf(a.getAttribute(\"type\").toLowerCase());default:return!1}}function r(a){var b=a.nodeName.toUpperCase();return\"INPUT\"===b&&\"image\"===a.type.toLowerCase()||-1!==[\"IMG\",\"APPLET\",\"AREA\"].indexOf(b)}function s(a){return!!y.sanitize(a)}var commons={},t=commons.aria={},u=t._lut={};u.attributes={\"aria-activedescendant\":{type:\"idref\"},\"aria-atomic\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-autocomplete\":{type:\"nmtoken\",values:[\"inline\",\"list\",\"both\",\"none\"]},\"aria-busy\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-checked\":{type:\"nmtoken\",values:[\"true\",\"false\",\"mixed\",\"undefined\"]},\"aria-colcount\":{type:\"int\"},\"aria-colindex\":{type:\"int\"},\"aria-colspan\":{type:\"int\"},\"aria-controls\":{type:\"idrefs\"},\"aria-current\":{type:\"nmtoken\",values:[\"page\",\"step\",\"location\",\"date\",\"time\",\"true\",\"false\"]},\"aria-describedby\":{type:\"idrefs\"},\"aria-disabled\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-dropeffect\":{type:\"nmtokens\",values:[\"copy\",\"move\",\"reference\",\"execute\",\"popup\",\"none\"]},\"aria-expanded\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-flowto\":{type:\"idrefs\"},\"aria-grabbed\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-haspopup\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-hidden\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-invalid\":{type:\"nmtoken\",values:[\"true\",\"false\",\"spelling\",\"grammar\"]},\"aria-label\":{type:\"string\"},\"aria-labelledby\":{type:\"idrefs\"},\"aria-level\":{type:\"int\"},\"aria-live\":{type:\"nmtoken\",values:[\"off\",\"polite\",\"assertive\"]},\"aria-multiline\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-multiselectable\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-orientation\":{type:\"nmtoken\",values:[\"horizontal\",\"vertical\"]},\"aria-owns\":{type:\"idrefs\"},\"aria-posinset\":{type:\"int\"},\"aria-pressed\":{type:\"nmtoken\",values:[\"true\",\"false\",\"mixed\",\"undefined\"]},\"aria-readonly\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-relevant\":{type:\"nmtokens\",values:[\"additions\",\"removals\",\"text\",\"all\"]},\"aria-required\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-rowcount\":{type:\"int\"},\"aria-rowindex\":{type:\"int\"},\"aria-rowspan\":{type:\"int\"},\"aria-selected\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-setsize\":{type:\"int\"},\"aria-sort\":{type:\"nmtoken\",values:[\"ascending\",\"descending\",\"other\",\"none\"]},\"aria-valuemax\":{type:\"decimal\"},\"aria-valuemin\":{type:\"decimal\"},\"aria-valuenow\":{type:\"decimal\"},\"aria-valuetext\":{type:\"string\"}},u.globalAttributes=[\"aria-atomic\",\"aria-busy\",\"aria-controls\",\"aria-current\",\"aria-describedby\",\"aria-disabled\",\"aria-dropeffect\",\"aria-flowto\",\"aria-grabbed\",\"aria-haspopup\",\"aria-hidden\",\"aria-invalid\",\"aria-label\",\"aria-labelledby\",\"aria-live\",\"aria-owns\",\"aria-relevant\"],u.role={alert:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},alertdialog:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},application:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},article:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"article\"]},banner:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"header\"]},button:{type:\"widget\",attributes:{allowed:[\"aria-expanded\",\"aria-pressed\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"button\",'input[type=\"button\"]','input[type=\"image\"]','input[type=\"reset\"]','input[type=\"submit\"]',\"summary\"]},cell:{type:\"structure\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-rowindex\",\"aria-rowspan\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"td\",\"th\"]},checkbox:{type:\"widget\",attributes:{required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:['input[type=\"checkbox\"]']},columnheader:{type:\"structure\",attributes:{allowed:[\"aria-expanded\",\"aria-sort\",\"aria-readonly\",\"aria-selected\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"th\"]},combobox:{type:\"composite\",attributes:{required:[\"aria-expanded\"],allowed:[\"aria-autocomplete\",\"aria-required\",\"aria-activedescendant\"]},owned:{all:[\"listbox\",\"textbox\"]},nameFrom:[\"author\"],context:null},command:{nameFrom:[\"author\"],type:\"abstract\"},complementary:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"aside\"]},composite:{nameFrom:[\"author\"],type:\"abstract\"},contentinfo:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"footer\"]},definition:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"dd\"]},dialog:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"dialog\"]},directory:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},document:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"body\"]},form:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"form\"]},grid:{type:\"composite\",attributes:{allowed:[\"aria-level\",\"aria-multiselectable\",\"aria-readonly\",\"aria-activedescendant\",\"aria-expanded\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null,implicit:[\"table\"]},gridcell:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-readonly\",\"aria-expanded\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"td\",\"th\"]},group:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"details\",\"optgroup\"]},heading:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"h1\",\"h2\",\"h3\",\"h4\",\"h5\",\"h6\"]},img:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"img\"]},input:{nameFrom:[\"author\"],type:\"abstract\"},landmark:{nameFrom:[\"author\"],type:\"abstract\"},link:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"a[href]\"]},list:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:{all:[\"listitem\"]},nameFrom:[\"author\"],context:null,implicit:[\"ol\",\"ul\",\"dl\"]},listbox:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-multiselectable\",\"aria-required\",\"aria-expanded\"]},owned:{all:[\"option\"]},nameFrom:[\"author\"],context:null,implicit:[\"select\"]},listitem:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-posinset\",\"aria-setsize\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"list\"],implicit:[\"li\",\"dt\"]},log:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},main:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"main\"]},marquee:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},math:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"math\"]},menu:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:{one:[\"menuitem\",\"menuitemradio\",\"menuitemcheckbox\"]},nameFrom:[\"author\"],context:null,implicit:['menu[type=\"context\"]']},menubar:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},menuitem:{type:\"widget\",attributes:null,owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"command\"]']},menuitemcheckbox:{type:\"widget\",attributes:{required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"checkbox\"]']},menuitemradio:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-posinset\",\"aria-setsize\"],required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"radio\"]']},navigation:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"nav\"]},none:{type:\"structure\",attributes:null,owned:null,nameFrom:[\"author\"],context:null},note:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},option:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-posinset\",\"aria-setsize\",\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"listbox\"],implicit:[\"option\"]},presentation:{type:\"structure\",attributes:null,owned:null,nameFrom:[\"author\"],context:null},progressbar:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"progress\"]},radio:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-posinset\",\"aria-setsize\"],required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:['input[type=\"radio\"]']},radiogroup:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-required\",\"aria-expanded\"]},owned:{all:[\"radio\"]},nameFrom:[\"author\"],context:null},range:{nameFrom:[\"author\"],type:\"abstract\"},region:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"section\"]},roletype:{type:\"abstract\"},row:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-selected\",\"aria-activedescendant\",\"aria-expanded\"]},owned:{one:[\"cell\",\"columnheader\",\"rowheader\",\"gridcell\"]},nameFrom:[\"author\",\"contents\"],context:[\"rowgroup\",\"grid\",\"treegrid\",\"table\"],implicit:[\"tr\"]},rowgroup:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:{all:[\"row\"]},nameFrom:[\"author\",\"contents\"],context:[\"grid\",\"table\"],implicit:[\"tbody\",\"thead\",\"tfoot\"]},rowheader:{type:\"structure\",attributes:{allowed:[\"aria-sort\",\"aria-required\",\"aria-readonly\",\"aria-expanded\",\"aria-selected\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"th\"]},scrollbar:{type:\"widget\",attributes:{required:[\"aria-controls\",\"aria-orientation\",\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"],allowed:[\"aria-valuetext\"]},owned:null,nameFrom:[\"author\"],context:null},search:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},searchbox:{type:\"widget\",attributes:{allowed:[\"aria-activedescendant\",\"aria-autocomplete\",\"aria-multiline\",\"aria-readonly\",\"aria-required\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"search\"]']},section:{nameFrom:[\"author\",\"contents\"],type:\"abstract\"},sectionhead:{nameFrom:[\"author\",\"contents\"],type:\"abstract\"},select:{nameFrom:[\"author\"],type:\"abstract\"},separator:{type:\"structure\",attributes:{allowed:[\"aria-expanded\",\"aria-orientation\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"hr\"]},slider:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-orientation\"],required:[\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"range\"]']},spinbutton:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-required\"],required:[\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"number\"]']},status:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"output\"]},structure:{type:\"abstract\"},switch:{type:\"widget\",attributes:{required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},tab:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"tablist\"]},table:{type:\"structure\",attributes:{allowed:[\"aria-colcount\",\"aria-rowcount\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null,implicit:[\"table\"]},tablist:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-level\",\"aria-multiselectable\"]},owned:{all:[\"tab\"]},nameFrom:[\"author\"],context:null},tabpanel:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},text:{type:\"structure\",owned:null,nameFrom:[\"author\",\"contents\"],context:null},textbox:{type:\"widget\",attributes:{allowed:[\"aria-activedescendant\",\"aria-autocomplete\",\"aria-multiline\",\"aria-readonly\",\"aria-required\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"text\"]','input[type=\"email\"]','input[type=\"password\"]','input[type=\"tel\"]','input[type=\"url\"]',\"input:not([type])\",\"textarea\"]},timer:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},toolbar:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['menu[type=\"toolbar\"]']},tooltip:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},tree:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-multiselectable\",\"aria-required\",\"aria-expanded\"]},owned:{all:[\"treeitem\"]},nameFrom:[\"author\"],context:null},treegrid:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-level\",\"aria-multiselectable\",\"aria-readonly\",\"aria-required\"]},owned:{all:[\"treeitem\"]},nameFrom:[\"author\"],context:null},treeitem:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-selected\",\"aria-expanded\",\"aria-level\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"treegrid\",\"tree\"]},widget:{type:\"abstract\"},window:{nameFrom:[\"author\"],type:\"abstract\"}};var v={};commons.color=v;var w=commons.dom={},x=commons.table={},y=commons.text={};commons.utils=axe.utils;t.requiredAttr=function(a){\"use strict\";var b=u.role[a];return b&&b.attributes&&b.attributes.required||[]},t.allowedAttr=function(a){\"use strict\";var b=u.role[a],c=b&&b.attributes&&b.attributes.allowed||[],d=b&&b.attributes&&b.attributes.required||[];return c.concat(u.globalAttributes).concat(d)},t.validateAttr=function(a){\"use strict\";return!!u.attributes[a]},t.validateAttrValue=function(a,b){\"use strict\";var c,d,e=document,f=a.getAttribute(b),g=u.attributes[b];if(!g)return!0;switch(g.type){case\"boolean\":case\"nmtoken\":return\"string\"==typeof f&&-1!==g.values.indexOf(f.toLowerCase());case\"nmtokens\":return d=axe.utils.tokenList(f),d.reduce(function(a,b){return a&&-1!==g.values.indexOf(b)},0!==d.length);case\"idref\":return!(!f||!e.getElementById(f));case\"idrefs\":return d=axe.utils.tokenList(f),d.reduce(function(a,b){return!(!a||!e.getElementById(b))},0!==d.length);case\"string\":return!0;case\"decimal\":return!(!(c=f.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!c[1]&&!c[2]);case\"int\":return/^[-+]?[0-9]+$/.test(f)}},t.label=function(a){var b,c;return a.getAttribute(\"aria-labelledby\")&&(b=w.idrefs(a,\"aria-labelledby\"),c=b.map(function(a){return a?y.visible(a,!0):\"\"}).join(\" \").trim())?c:(c=a.getAttribute(\"aria-label\"),c&&(c=y.sanitize(c).trim())?c:null)},t.isValidRole=function(a){\"use strict\";return!!u.role[a]},t.getRolesWithNameFromContents=function(){return Object.keys(u.role).filter(function(a){return u.role[a].nameFrom&&-1!==u.role[a].nameFrom.indexOf(\"contents\")})},t.getRolesByType=function(a){return Object.keys(u.role).filter(function(b){return u.role[b].type===a})},t.getRoleType=function(a){var b=u.role[a];return b&&b.type||null},t.requiredOwned=function(a){\"use strict\";var b=null,c=u.role[a];return c&&(b=axe.utils.clone(c.owned)),b},t.requiredContext=function(a){\"use strict\";var b=null,c=u.role[a];return c&&(b=axe.utils.clone(c.context)),b},t.implicitNodes=function(a){\"use strict\";var b=null,c=u.role[a];return c&&c.implicit&&(b=axe.utils.clone(c.implicit)),b},t.implicitRole=function(a){\"use strict\";var b=function(b,c){var d=function(b){return axe.utils.matchesSelector(a,b)};return c.implicit&&c.implicit.some(d)&&b.push(c.name),b},c=Object.keys(u.role).map(function(a){var b=u.role[a];return{name:a,implicit:b&&b.implicit}}),d=c.reduce(b,[]);if(!d.length)return null;for(var e=a.attributes,f=[],g=0,h=e.length;g<h;g++){var i=e[g];i.name.match(/^aria-/)&&f.push(i.name)}return function(a,b){var c=function(a){return t.allowedAttr(a).reduce(function(a,c){return a+(b.indexOf(c)>-1?1:0)},0)};return a.map(function(a){return{score:c(a),name:a}}).sort(function(a,b){return b.score-a.score}).map(function(a){return a.name})}(d,f).shift()},v.Color=function(a,b,c,d){this.red=a,this.green=b,this.blue=c,this.alpha=d,this.toHexString=function(){var a=Math.round(this.red).toString(16),b=Math.round(this.green).toString(16),c=Math.round(this.blue).toString(16);return\"#\"+(this.red>15.5?a:\"0\"+a)+(this.green>15.5?b:\"0\"+b)+(this.blue>15.5?c:\"0\"+c)};this.parseRgbString=function(a){if(\"transparent\"===a)return this.red=0,this.green=0,this.blue=0,void(this.alpha=0);var b=a.match(/^rgb\\((\\d+), (\\d+), (\\d+)\\)$/);return b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),this.blue=parseInt(b[3],10),void(this.alpha=1)):(b=a.match(/^rgba\\((\\d+), (\\d+), (\\d+), (\\d*(\\.\\d+)?)\\)/),b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),\nthis.blue=parseInt(b[3],10),void(this.alpha=parseFloat(b[4]))):void 0)},this.getRelativeLuminance=function(){var a=this.red/255,b=this.green/255,c=this.blue/255;return.2126*(a<=.03928?a/12.92:Math.pow((a+.055)/1.055,2.4))+.7152*(b<=.03928?b/12.92:Math.pow((b+.055)/1.055,2.4))+.0722*(c<=.03928?c/12.92:Math.pow((c+.055)/1.055,2.4))}},v.flattenColors=function(a,b){var c=a.alpha,d=(1-c)*b.red+c*a.red,e=(1-c)*b.green+c*a.green,f=(1-c)*b.blue+c*a.blue,g=a.alpha+b.alpha*(1-a.alpha);return new v.Color(d,e,f,g)},v.getContrast=function(a,b){if(!b||!a)return null;b.alpha<1&&(b=v.flattenColors(b,a));var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(d,c)+.05)/(Math.min(d,c)+.05)},v.hasValidContrastRatio=function(a,b,c,d){var e=v.getContrast(a,b),f=d&&Math.ceil(72*c)/96<14||!d&&Math.ceil(72*c)/96<18;return{isValid:f&&e>=4.5||!f&&e>=3,contrastRatio:e}},v.elementIsDistinct=b;var z=[\"IMG\",\"CANVAS\",\"OBJECT\",\"IFRAME\",\"VIDEO\",\"SVG\"];v.getBackgroundStack=function(a){var b=a.getBoundingClientRect(),f=void 0,g=void 0;if(!(b.left>window.innerWidth||b.top>window.innerHeight)){f=Math.min(Math.ceil(b.left+b.width/2),window.innerWidth-1),g=Math.min(Math.ceil(b.top+b.height/2),window.innerHeight-1);var h=document.elementsFromPoint(f,g);h=w.reduceToElementsBelowFloating(h,a);var i=h.indexOf(document.body);i>1&&!c(document.documentElement)&&0===d(document.documentElement).alpha&&(h.splice(i,1),h.splice(h.indexOf(document.documentElement),1),h.push(document.body));var j=h.indexOf(a);return e(j,h)>=.99?(axe.commons.color.incompleteData.set(\"bgColor\",{reason:\"bgOverlap\"}),null):-1!==j?h:null}},v.getBackgroundColor=function(a){var b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];!0!==(arguments.length>2&&void 0!==arguments[2]&&arguments[2])&&a.scrollIntoView();var e=[],g=v.getBackgroundStack(a);if((g||[]).some(function(g){var h=window.getComputedStyle(g),i=d(g,h);return f(a,g,i)||c(g,h)?(e=null,b.push(g),!0):0!==i.alpha&&(b.push(g),e.push(i),1===i.alpha)}),null!==e&&null!==g){e.push(new v.Color(255,255,255,1));return e.reduce(v.flattenColors)}return null},w.isOpaque=function(a){var b=window.getComputedStyle(a);return c(a,b)||1===d(a,b).alpha},v.getForegroundColor=function(a,b){var c=window.getComputedStyle(a),d=new v.Color;d.parseRgbString(c.getPropertyValue(\"color\"));var e=c.getPropertyValue(\"opacity\");if(d.alpha=d.alpha*e,1===d.alpha)return d;var f=v.getBackgroundColor(a,[],b);if(null===f){var g=axe.commons.color.incompleteData.get(\"bgColor\").reason;return axe.commons.color.incompleteData.set(\"fgColor\",{reason:g}),null}return v.flattenColors(d,f)},v.incompleteData=function(){var a={};return{set:function(b,c){if(\"string\"!=typeof b)throw new Error(\"Incomplete data: key must be a string\");c&&(a[b]=c)},get:function(b){return a[b]},clear:function(){a={}}}}(),w.reduceToElementsBelowFloating=function(a,b){var c,d,e,f=[\"fixed\",\"sticky\"],g=[],h=!1;for(c=0;c<a.length;++c)d=a[c],d===b&&(h=!0),e=window.getComputedStyle(d),h||-1===f.indexOf(e.position)?g.push(d):g=[];return g},w.findUp=function(a,b){\"use strict\";var c,d=document.querySelectorAll(b);if(!d.length)return null;for(d=axe.utils.toArray(d),c=a.parentNode;c&&-1===d.indexOf(c);)c=c.parentNode;return c},w.getElementByReference=function(a,b){\"use strict\";var c,d=a.getAttribute(b),e=document;if(d&&\"#\"===d.charAt(0)){if(d=d.substring(1),c=e.getElementById(d))return c;if(c=e.getElementsByName(d),c.length)return c[0]}return null},w.getElementCoordinates=function(a){\"use strict\";var b=w.getScrollOffset(document),c=b.left,d=b.top,e=a.getBoundingClientRect();return{top:e.top+d,right:e.right+c,bottom:e.bottom+d,left:e.left+c,width:e.right-e.left,height:e.bottom-e.top}},w.getScrollOffset=function(a){\"use strict\";if(!a.nodeType&&a.document&&(a=a.document),9===a.nodeType){var b=a.documentElement,c=a.body;return{left:b&&b.scrollLeft||c&&c.scrollLeft||0,top:b&&b.scrollTop||c&&c.scrollTop||0}}return{left:a.scrollLeft,top:a.scrollTop}},w.getViewportSize=function(a){\"use strict\";var b,c=a.document,d=c.documentElement;return a.innerWidth?{width:a.innerWidth,height:a.innerHeight}:d?{width:d.clientWidth,height:d.clientHeight}:(b=c.body,{width:b.clientWidth,height:b.clientHeight})},w.hasContent=function(a){var b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];if(a.textContent.trim()||t.label(a))return!0;for(var c=a.querySelectorAll(\"*\"),d=0;d<c.length;d++)if(-1===b.indexOf(c[d])&&t.label(c[d])||w.isVisualContent(c[d]))return!0;return!1},w.idrefs=function(a,b){\"use strict\";var c,d,e=document,f=[],g=a.getAttribute(b);if(g)for(g=axe.utils.tokenList(g),c=0,d=g.length;c<d;c++)f.push(e.getElementById(g[c]));return f},w.isFocusable=function(a){\"use strict\";if(!a||a.disabled||!w.isVisible(a)&&\"AREA\"!==a.nodeName.toUpperCase())return!1;switch(a.nodeName.toUpperCase()){case\"A\":case\"AREA\":if(a.href)return!0;break;case\"INPUT\":return\"hidden\"!==a.type;case\"TEXTAREA\":case\"SELECT\":case\"DETAILS\":case\"BUTTON\":return!0}var b=a.getAttribute(\"tabindex\");return!(!b||isNaN(parseInt(b,10)))},w.isHTML5=function(a){var b=a.doctype;return null!==b&&(\"html\"===b.name&&!b.publicId&&!b.systemId)};var A=[\"block\",\"list-item\",\"table\",\"flex\",\"grid\",\"inline-block\"];w.isInTextBlock=function(a){\"use strict\";if(h(a))return!1;for(var b=a.parentNode;1===b.nodeType&&!h(b);)b=b.parentNode;var c=\"\",d=\"\",e=0;return g(b,function(b){if(2===e)return!1;if(3===b.nodeType&&(c+=b.nodeValue),1===b.nodeType){var f=(b.nodeName||\"\").toUpperCase();if(-1!==[\"BR\",\"HR\"].indexOf(f))0===e?(c=\"\",d=\"\"):e=2;else{if(\"none\"===b.style.display||\"hidden\"===b.style.overflow||-1===[\"\",null,\"none\"].indexOf(b.style.float)||-1===[\"\",null,\"relative\"].indexOf(b.style.position))return!1;if(\"A\"===f&&b.href||\"link\"===(b.getAttribute(\"role\")||\"\").toLowerCase())return b===a&&(e=1),d+=b.textContent,!1}}}),c=axe.commons.text.sanitize(c),d=axe.commons.text.sanitize(d),c.length>d.length},w.isNode=function(a){\"use strict\";return a instanceof Node},w.isOffscreen=function(a){\"use strict\";var b,c=document.documentElement,d=window.getComputedStyle(document.body||c).getPropertyValue(\"direction\"),e=w.getElementCoordinates(a);if(e.bottom<0&&function(a,b){for(a=a.parentNode;\"html\"!==a.nodeName.toLowerCase();){if(a.scrollTop&&(b+=a.scrollTop)>=0)return!1;a=a.parentNode}return!0}(a,e.bottom))return!0;if(0===e.left&&0===e.right)return!1;if(\"ltr\"===d){if(e.right<=0)return!0}else if(b=Math.max(c.scrollWidth,w.getViewportSize(window).width),e.left>=b)return!0;return!1},w.isVisible=function(a,b,c){\"use strict\";var d,e=a.nodeName.toUpperCase(),f=a.parentNode;return 9===a.nodeType||null!==(d=window.getComputedStyle(a,null))&&(!(\"none\"===d.getPropertyValue(\"display\")||\"STYLE\"===e.toUpperCase()||\"SCRIPT\"===e.toUpperCase()||!b&&i(d.getPropertyValue(\"clip\"))||!c&&(\"hidden\"===d.getPropertyValue(\"visibility\")||!b&&w.isOffscreen(a))||b&&\"true\"===a.getAttribute(\"aria-hidden\"))&&(!!f&&w.isVisible(f,b,!0)))};var B=[\"checkbox\",\"img\",\"radio\",\"range\",\"slider\",\"spinbutton\",\"textbox\"];w.isVisualContent=function(a){var b=a.getAttribute(\"role\");if(b)return-1!==B.indexOf(b);switch(a.tagName.toUpperCase()){case\"IMG\":case\"IFRAME\":case\"OBJECT\":case\"VIDEO\":case\"AUDIO\":case\"CANVAS\":case\"SVG\":case\"MATH\":case\"BUTTON\":case\"SELECT\":case\"TEXTAREA\":case\"KEYGEN\":case\"PROGRESS\":case\"METER\":return!0;case\"INPUT\":return\"hidden\"!==a.type;default:return!1}},w.visuallyContains=function(a,b){var c=a.getBoundingClientRect(),d={top:c.top+.01,bottom:c.bottom-.01,left:c.left+.01,right:c.right-.01},e=b.getBoundingClientRect(),f=e.top,g=e.left,h={top:f-b.scrollTop,bottom:f-b.scrollTop+b.scrollHeight,left:g-b.scrollLeft,right:g-b.scrollLeft+b.scrollWidth};if(d.left<h.left&&d.left<e.left||d.top<h.top&&d.top<e.top||d.right>h.right&&d.right>e.right||d.bottom>h.bottom&&d.bottom>e.bottom)return!1;var i=window.getComputedStyle(b);return!(d.right>e.right||d.bottom>e.bottom)||(\"scroll\"===i.overflow||\"auto\"===i.overflow||\"hidden\"===i.overflow||b instanceof HTMLBodyElement||b instanceof HTMLHtmlElement)},w.visuallyOverlaps=function(a,b){var c=b.getBoundingClientRect(),d=c.top,e=c.left,f={top:d-b.scrollTop,bottom:d-b.scrollTop+b.scrollHeight,left:e-b.scrollLeft,right:e-b.scrollLeft+b.scrollWidth};if(a.left>f.right&&a.left>c.right||a.top>f.bottom&&a.top>c.bottom||a.right<f.left&&a.right<c.left||a.bottom<f.top&&a.bottom<c.top)return!1;var g=window.getComputedStyle(b);return!(a.left>c.right||a.top>c.bottom)||(\"scroll\"===g.overflow||\"auto\"===g.overflow||b instanceof HTMLBodyElement||b instanceof HTMLHtmlElement)},x.getAllCells=function(a){var b,c,d,e,f=[];for(b=0,d=a.rows.length;b<d;b++)for(c=0,e=a.rows[b].cells.length;c<e;c++)f.push(a.rows[b].cells[c]);return f},x.getCellPosition=function(a,b){var c,d;for(b||(b=x.toGrid(w.findUp(a,\"table\"))),c=0;c<b.length;c++)if(b[c]&&-1!==(d=b[c].indexOf(a)))return{x:d,y:c}},x.getHeaders=function(a){if(a.hasAttribute(\"headers\"))return commons.dom.idrefs(a,\"headers\");var b=commons.table.toGrid(commons.dom.findUp(a,\"table\")),c=commons.table.getCellPosition(a,b);return[].concat(x.traverse(\"left\",c,b).filter(function(a){return x.isRowHeader(a)}),x.traverse(\"up\",c,b).filter(function(a){return x.isColumnHeader(a)})).reverse()},x.getScope=function(a){var b=a.getAttribute(\"scope\"),c=a.getAttribute(\"role\");if(a instanceof Element==!1||-1===[\"TD\",\"TH\"].indexOf(a.nodeName.toUpperCase()))throw new TypeError(\"Expected TD or TH element\");if(\"columnheader\"===c)return\"col\";if(\"rowheader\"===c)return\"row\";if(\"col\"===b||\"row\"===b)return b;if(\"TH\"!==a.nodeName.toUpperCase())return!1;var d=x.toGrid(w.findUp(a,\"table\")),e=x.getCellPosition(a);return d[e.y].reduce(function(a,b){return a&&\"TH\"===b.nodeName.toUpperCase()},!0)?\"col\":d.map(function(a){return a[e.x]}).reduce(function(a,b){return a&&\"TH\"===b.nodeName.toUpperCase()},!0)?\"row\":\"auto\"},x.isColumnHeader=function(a){return-1!==[\"col\",\"auto\"].indexOf(x.getScope(a))},x.isDataCell=function(a){return!(!a.children.length&&!a.textContent.trim())&&\"TD\"===a.nodeName.toUpperCase()},x.isDataTable=function(a){var b=a.getAttribute(\"role\");if((\"presentation\"===b||\"none\"===b)&&!w.isFocusable(a))return!1;if(\"true\"===a.getAttribute(\"contenteditable\")||w.findUp(a,'[contenteditable=\"true\"]'))return!0;if(\"grid\"===b||\"treegrid\"===b||\"table\"===b)return!0;if(\"landmark\"===commons.aria.getRoleType(b))return!0;if(\"0\"===a.getAttribute(\"datatable\"))return!1;if(a.getAttribute(\"summary\"))return!0;if(a.tHead||a.tFoot||a.caption)return!0;for(var c=0,d=a.children.length;c<d;c++)if(\"COLGROUP\"===a.children[c].nodeName.toUpperCase())return!0;for(var e,f,g=0,h=a.rows.length,i=!1,j=0;j<h;j++){e=a.rows[j];for(var k=0,l=e.cells.length;k<l;k++){if(f=e.cells[k],\"TH\"===f.nodeName.toUpperCase())return!0;if(i||f.offsetWidth===f.clientWidth&&f.offsetHeight===f.clientHeight||(i=!0),f.getAttribute(\"scope\")||f.getAttribute(\"headers\")||f.getAttribute(\"abbr\"))return!0;if(-1!==[\"columnheader\",\"rowheader\"].indexOf(f.getAttribute(\"role\")))return!0;if(1===f.children.length&&\"ABBR\"===f.children[0].nodeName.toUpperCase())return!0;g++}}if(a.getElementsByTagName(\"table\").length)return!1;if(h<2)return!1;var m=a.rows[Math.ceil(h/2)];if(1===m.cells.length&&1===m.cells[0].colSpan)return!1;if(m.cells.length>=5)return!0;if(i)return!0;var n,o;for(j=0;j<h;j++){if(e=a.rows[j],n&&n!==window.getComputedStyle(e).getPropertyValue(\"background-color\"))return!0;if(n=window.getComputedStyle(e).getPropertyValue(\"background-color\"),o&&o!==window.getComputedStyle(e).getPropertyValue(\"background-image\"))return!0;o=window.getComputedStyle(e).getPropertyValue(\"background-image\")}return h>=20||!(w.getElementCoordinates(a).width>.95*w.getViewportSize(window).width)&&(!(g<10)&&!a.querySelector(\"object, embed, iframe, applet\"))},x.isHeader=function(a){return!(!x.isColumnHeader(a)&&!x.isRowHeader(a))||!!a.id&&!!document.querySelector('[headers~=\"'+axe.utils.escapeSelector(a.id)+'\"]')},x.isRowHeader=function(a){return-1!==[\"row\",\"auto\"].indexOf(x.getScope(a))},x.toGrid=function(a){for(var b=[],c=a.rows,d=0,e=c.length;d<e;d++){var f=c[d].cells;b[d]=b[d]||[];for(var g=0,h=0,i=f.length;h<i;h++)for(var j=0;j<f[h].colSpan;j++){for(var k=0;k<f[h].rowSpan;k++){for(b[d+k]=b[d+k]||[];b[d+k][g];)g++;b[d+k][g]=f[h]}g++}}return b},x.toArray=x.toGrid,function(a){var b=function a(b,c,d,e){var f,g=d[c.y]?d[c.y][c.x]:void 0;return g?\"function\"==typeof e&&!0===(f=e(g,c,d))?[g]:(f=a(b,{x:c.x+b.x,y:c.y+b.y},d,e),f.unshift(g),f):[]};a.traverse=function(a,c,d,e){if(Array.isArray(c)&&(e=d,d=c,c={x:0,y:0}),\"string\"==typeof a)switch(a){case\"left\":a={x:-1,y:0};break;case\"up\":a={x:0,y:-1};break;case\"right\":a={x:1,y:0};break;case\"down\":a={x:0,y:1}}return b(a,{x:c.x+a.x,y:c.y+a.y},d,e)}}(x);var C={submit:\"Submit\",reset:\"Reset\"},D=[\"text\",\"search\",\"tel\",\"url\",\"email\",\"date\",\"time\",\"number\",\"range\",\"color\"],E=[\"A\",\"EM\",\"STRONG\",\"SMALL\",\"MARK\",\"ABBR\",\"DFN\",\"I\",\"B\",\"S\",\"U\",\"CODE\",\"VAR\",\"SAMP\",\"KBD\",\"SUP\",\"SUB\",\"Q\",\"CITE\",\"SPAN\",\"BDO\",\"BDI\",\"BR\",\"WBR\",\"INS\",\"DEL\",\"IMG\",\"EMBED\",\"OBJECT\",\"IFRAME\",\"MAP\",\"AREA\",\"SCRIPT\",\"NOSCRIPT\",\"RUBY\",\"VIDEO\",\"AUDIO\",\"INPUT\",\"TEXTAREA\",\"SELECT\",\"BUTTON\",\"LABEL\",\"OUTPUT\",\"DATALIST\",\"KEYGEN\",\"PROGRESS\",\"COMMAND\",\"CANVAS\",\"TIME\",\"METER\"];return y.accessibleText=function(a,b){function c(a,b,c){for(var d,e=a.childNodes,g=\"\",h=0;h<e.length;h++)d=e[h],3===d.nodeType?g+=d.textContent:1===d.nodeType&&(-1===E.indexOf(d.nodeName.toUpperCase())&&(g+=\" \"),g+=f(e[h],b,c));return g}function d(a,b,d){var e=\"\",g=a.nodeName.toUpperCase();if(m(a)&&(e=c(a,!1,!1)||\"\",s(e)))return e;if(\"FIGURE\"===g&&(e=p(a,\"figcaption\"),s(e)))return e;if(\"TABLE\"===g){if(e=p(a,\"caption\"),s(e))return e;if(e=a.getAttribute(\"title\")||a.getAttribute(\"summary\")||\"\",s(e))return e}if(r(a))return a.getAttribute(\"alt\")||\"\";if(l(a)&&!d){if(k(a))return a.value||a.title||C[a.type]||\"\";var h=j(a);if(h)return f(h,b,!0)}return\"\"}function e(a,b,c){return!b&&a.hasAttribute(\"aria-labelledby\")?y.sanitize(w.idrefs(a,\"aria-labelledby\").map(function(b){return a===b&&g.pop(),f(b,!0,a!==b)}).join(\" \")):c&&q(a)||!a.hasAttribute(\"aria-label\")?\"\":y.sanitize(a.getAttribute(\"aria-label\"))}var f,g=[];return f=function(a,b,f){\"use strict\";var h;if(null===a||-1!==g.indexOf(a))return\"\";if(!b&&!w.isVisible(a,!0))return\"\";g.push(a);var i=a.getAttribute(\"role\");return h=e(a,b,f),s(h)?h:(h=d(a,b,f),s(h)?h:f&&(h=o(a),s(h))?h:n(a)||i&&-1===t.getRolesWithNameFromContents().indexOf(i)||(h=c(a,b,f),!s(h))?a.hasAttribute(\"title\")?a.getAttribute(\"title\"):\"\":h)},y.sanitize(f(a,b))},y.label=function(a){var b,c;return(c=t.label(a))?c:a.id&&(b=document.querySelector('label[for=\"'+axe.utils.escapeSelector(a.id)+'\"]'),c=b&&y.visible(b,!0))?c:(b=w.findUp(a,\"label\"),(c=b&&y.visible(b,!0))||null)},y.sanitize=function(a){\"use strict\";return a.replace(/\\r\\n/g,\"\\n\").replace(/\\u00A0/g,\" \").replace(/[\\s]{2,}/g,\" \").trim()},y.visible=function(a,b,c){\"use strict\";var d,e,f=a.childNodes,g=f.length,h=\"\";for(d=0;d<g;d++)e=f[d],3===e.nodeType?e.nodeValue&&w.isVisible(a,b)&&(h+=e.nodeValue):c||(h+=y.visible(e,b));return y.sanitize(h)},axe.utils.toArray=function(a){\"use strict\";return Array.prototype.slice.call(a)},axe.utils.tokenList=function(a){\"use strict\";return a.trim().replace(/\\s{2,}/g,\" \").split(\" \")},commons}()})}(\"object\"==typeof window?window:this);";function runA11yChecks(){return window.axe.run(document,{elementRef:true,runOnly:{type:'tag',values:['wcag2a','wcag2aa']},rules:{'tabindex':{enabled:true},'table-fake-caption':{enabled:true},'td-has-header':{enabled:true},'area-alt':{enabled:false},'blink':{enabled:false},'server-side-image-map':{enabled:false}}}).then(axeResult=>{axeResult.violations.forEach(v=>v.nodes.forEach(node=>{node.path=getNodePath(node.element);node.snippet=getOuterHTMLSnippet(node.element);node.element=node.any=node.all=node.none=undefined;}));axeResult={violations:axeResult.violations};return axeResult;});function getNodePath(node){function getNodeIndex(node){let index=0;while(node=node.previousSibling){if(node.nodeType===Node.TEXT_NODE&&node.textContent.trim().length===0)continue;index++;}
return index;}
const path=[];while(node&&node.parentNode){const index=getNodeIndex(node);path.push([index,node.nodeName]);node=node.parentNode;}
path.reverse();return path.join(',');}
function getOuterHTMLSnippet(node){const reOpeningTag=/^.*?\>/;const match=node.outerHTML.match(reOpeningTag);return match&&match[0];}}
class Accessibility extends Gatherer{afterPass(options){const driver=options.driver;const expression=`(function () {
      ${axeLibSource};
      return (${runA11yChecks.toString()}());
    })()`;return driver.evaluateAsync(expression).then(returnedValue=>{if(!returnedValue){throw new Error('No axe-core results returned');}
if(!Array.isArray(returnedValue.violations)){throw new Error('Unable to parse axe results'+returnedValue);}
return returnedValue;});}}
module.exports=Accessibility;},{"./gatherer":16}],"./gatherers/cache-contents":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getCacheContents(){return caches.keys().then(cacheNames=>Promise.all(cacheNames.map(cacheName=>caches.open(cacheName)))).then(caches=>{const requests=[];return Promise.all(caches.map(cache=>{return cache.keys().then(reqs=>{requests.push(...reqs.map(r=>r.url));});})).then(_=>{return requests;});});}
class CacheContents extends Gatherer{afterPass(options){const driver=options.driver;return driver.evaluateAsync(`(${getCacheContents.toString()}())`).then(returnedValue=>{if(!returnedValue||!Array.isArray(returnedValue)){throw new Error('Unable to retrieve cache contents');}
return returnedValue;});}}
module.exports=CacheContents;},{"./gatherer":16}],"./gatherers/chrome-console-messages":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ChromeConsoleMessages extends Gatherer{constructor(){super();this._logEntries=[];this._onConsoleEntryAdded=this.onConsoleEntry.bind(this);}
onConsoleEntry(entry){this._logEntries.push(entry);}
beforePass(options){const driver=options.driver;driver.on('Log.entryAdded',this._onConsoleEntryAdded);return driver.sendCommand('Log.enable').then(()=>driver.sendCommand('Log.startViolationsReport',{config:[{name:'discouragedAPIUse',threshold:-1}]}));}
afterPass(options){return Promise.resolve().then(_=>options.driver.sendCommand('Log.stopViolationsReport')).then(_=>options.driver.off('Log.entryAdded',this._onConsoleEntryAdded)).then(_=>options.driver.sendCommand('Log.disable')).then(_=>this._logEntries);}}
module.exports=ChromeConsoleMessages;},{"./gatherer":16}],"./gatherers/css-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class CSSUsage extends Gatherer{beforePass(options){return options.driver.sendCommand('DOM.enable').then(_=>options.driver.sendCommand('CSS.enable')).then(_=>options.driver.sendCommand('CSS.startRuleUsageTracking')).catch(err=>{if(/startRuleUsageTracking/.test(err.message)){throw new Error('CSS Usage tracking requires Chrome \u2265 56');}
throw err;});}
afterPass(options){const driver=options.driver;return driver.sendCommand('CSS.stopRuleUsageTracking').then(results=>{return driver.sendCommand('CSS.disable').then(_=>driver.sendCommand('DOM.disable')).then(_=>results.ruleUsage);});}}
module.exports=CSSUsage;},{"./gatherer":16}],"./gatherers/dobetterweb/all-event-listeners":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class EventListeners extends Gatherer{listenForScriptParsedEvents(){this._listener=script=>{this._parsedScripts.set(script.scriptId,script);};this.driver.on('Debugger.scriptParsed',this._listener);return this.driver.sendCommand('Debugger.enable');}
unlistenForScriptParsedEvents(){this.driver.off('Debugger.scriptParsed',this._listener);return this.driver.sendCommand('Debugger.disable');}
_listEventListeners(nodeIdOrObject){let promise;if(typeof nodeIdOrObject==='string'){promise=this.driver.sendCommand('Runtime.evaluate',{expression:nodeIdOrObject,objectGroup:'event-listeners-gatherer'});}else{promise=this.driver.sendCommand('DOM.resolveNode',{nodeId:nodeIdOrObject,objectGroup:'event-listeners-gatherer'});}
return promise.then(result=>{const obj=result.object||result.result;return this.driver.sendCommand('DOMDebugger.getEventListeners',{objectId:obj.objectId}).then(results=>{return{listeners:results.listeners,tagName:obj.description};});});}
getEventListeners(nodeId){const matchedListeners=[];return this._listEventListeners(nodeId).then(results=>{results.listeners.forEach(listener=>{const script=this._parsedScripts.get(listener.scriptId);if(script){const combo=Object.assign(listener,script);combo.objectName=results.tagName;combo.line=combo.lineNumber+1;combo.col=combo.columnNumber+1;matchedListeners.push(combo);}});return matchedListeners;});}
collectListeners(nodes){return Promise.all(nodes.map(node=>{return this.getEventListeners(node.element?node.element.nodeId:node);})).then(nestedListeners=>[].concat(...nestedListeners));}
afterPass(options){this.driver=options.driver;this._parsedScripts=new Map();return options.driver.sendCommand('DOM.enable').then(()=>this.listenForScriptParsedEvents()).then(()=>this.unlistenForScriptParsedEvents()).then(()=>options.driver.getElementsInDocument()).then(nodes=>{nodes.push('document','window');return this.collectListeners(nodes);}).then(listeners=>{return options.driver.sendCommand('DOM.disable').then(()=>listeners);});}}
module.exports=EventListeners;},{"../gatherer":16}],"./gatherers/dobetterweb/anchors-with-no-rel-noopener":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const DOMHelpers=require('../../../lib/dom-helpers.js');class AnchorsWithNoRelNoopener extends Gatherer{afterPass(options){const expression=`(function() {
      ${DOMHelpers.getElementsInDocumentFnString}; // define function on page
      const selector = 'a[target="_blank"]:not([rel~="noopener"])';
      const elements = getElementsInDocument(selector);
      return elements.map(node => ({
        href: node.getAttribute('href'),
        rel: node.getAttribute('rel'),
        target: node.getAttribute('target')
      }));
    })()`;return options.driver.evaluateAsync(expression);}}
module.exports=AnchorsWithNoRelNoopener;},{"../../../lib/dom-helpers.js":18,"../gatherer":16}],"./gatherers/dobetterweb/appcache":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class AppCacheManifest extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('html').then(node=>node&&node.getAttribute('manifest'));}}
module.exports=AppCacheManifest;},{"../gatherer":16}],"./gatherers/dobetterweb/domstats":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function createSelectorsLabel(element){let name=element.localName||'';const idAttr=element.getAttribute&&element.getAttribute('id');if(idAttr){name+=`#${idAttr}`;}
if(element.classList){const className=element.classList.toString();if(className){name+=`.${className.trim().replace(/\s+/g,'.')}`;}}else if(ShadowRoot.prototype.isPrototypeOf(element)){name+='#shadow-root';}
return name;}
function elementPathInDOM(element){const visited=new Set();const path=[createSelectorsLabel(element)];let node=element;while(node){visited.add(node);if(ShadowRoot.prototype.isPrototypeOf(node)){const isShadowHost=node.host&&node.localName!=='a';node=isShadowHost?node.host:node.parentElement;}else{const isShadowHost=node.parentNode&&node.parentNode.host&&node.parentNode.localName!=='a';node=isShadowHost?node.parentNode.host:node.parentElement;}
if(visited.has(node)){node=null;}
if(node){path.unshift(createSelectorsLabel(node));}}
return path;}
function getDOMStats(element,deep=true){let deepestNode=null;let maxDepth=0;let maxWidth=0;let parentWithMostChildren=null;const _calcDOMWidthAndHeight=function(element,depth=1){if(depth>maxDepth){deepestNode=element;maxDepth=depth;}
if(element.children.length>maxWidth){parentWithMostChildren=element;maxWidth=element.children.length;}
let child=element.firstElementChild;while(child){_calcDOMWidthAndHeight(child,depth+1);if(deep&&child.shadowRoot){_calcDOMWidthAndHeight(child.shadowRoot,depth+1);}
child=child.nextElementSibling;}
return{maxDepth,maxWidth};};const result=_calcDOMWidthAndHeight(element);return{depth:{max:result.maxDepth,pathToElement:elementPathInDOM(deepestNode)},width:{max:result.maxWidth,pathToElement:elementPathInDOM(parentWithMostChildren)}};}
class DOMStats extends Gatherer{afterPass(options){const expression=`(function() {
      ${createSelectorsLabel.toString()};
      ${elementPathInDOM.toString()};
      return (${getDOMStats.toString()}(document.documentElement));
    })()`;return options.driver.sendCommand('DOM.enable').then(()=>options.driver.evaluateAsync(expression)).then(results=>options.driver.getElementsInDocument().then(allNodes=>{results.totalDOMNodes=allNodes.length;return options.driver.sendCommand('DOM.disable').then(()=>results);}));}}
module.exports=DOMStats;},{"../gatherer":16}],"./gatherers/dobetterweb/optimized-images":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const URL=require('../../../lib/url-shim');function getOptimizedNumBytes(url){return new Promise(function(resolve,reject){const img=new Image();const canvas=document.createElement('canvas');const context=canvas.getContext('2d');function getTypeStats(type,quality){const dataURI=canvas.toDataURL(type,quality);const base64=dataURI.slice(dataURI.indexOf(',')+1);return{base64:base64.length,binary:atob(base64).length};}
img.addEventListener('error',reject);img.addEventListener('load',()=>{try{canvas.height=img.height;canvas.width=img.width;context.drawImage(img,0,0);const jpeg=getTypeStats('image/jpeg',0.92);const webp=getTypeStats('image/webp',0.85);resolve({jpeg,webp});}catch(err){reject(err);}},false);img.src=url;});}
class OptimizedImages extends Gatherer{static filterImageRequests(pageUrl,networkRecords){const seenUrls=new Set();return networkRecords.reduce((prev,record)=>{if(seenUrls.has(record._url)||!record.finished){return prev;}
seenUrls.add(record._url);const isOptimizableImage=/image\/(png|bmp|jpeg)/.test(record._mimeType);const isSameOrigin=URL.originsMatch(pageUrl,record._url);const isBase64DataUri=/^data:.{2,40}base64\s*,/.test(record._url);if(isOptimizableImage){prev.push({isSameOrigin,isBase64DataUri,requestId:record._requestId,url:record._url,mimeType:record._mimeType,resourceSize:record._resourceSize});}
return prev;},[]);}
calculateImageStats(driver,networkRecord){if(!networkRecord.isSameOrigin&&!networkRecord.isBase64DataUri){return Promise.resolve(null);}
return Promise.resolve(networkRecord.url).then(uri=>{const script=`(${getOptimizedNumBytes.toString()})(${JSON.stringify(uri)})`;return driver.evaluateAsync(script).then(stats=>{if(!stats){return null;}
const isBase64DataUri=networkRecord.isBase64DataUri;const base64Length=networkRecord.url.length-networkRecord.url.indexOf(',')-1;return{originalSize:isBase64DataUri?base64Length:networkRecord.resourceSize,jpegSize:isBase64DataUri?stats.jpeg.base64:stats.jpeg.binary,webpSize:isBase64DataUri?stats.webp.base64:stats.webp.binary};});});}
computeOptimizedImages(driver,imageRecords){return imageRecords.reduce((promise,record)=>{return promise.then(results=>{return this.calculateImageStats(driver,record).catch(err=>({failed:true,err})).then(stats=>{if(!stats){return results;}
return results.concat(Object.assign(stats,record));});});},Promise.resolve([]));}
afterPass(options,traceData){const networkRecords=traceData.networkRecords;const imageRecords=OptimizedImages.filterImageRequests(options.url,networkRecords);return Promise.resolve().then(_=>this.computeOptimizedImages(options.driver,imageRecords)).then(results=>{const successfulResults=results.filter(result=>!result.failed);if(results.length&&!successfulResults.length){throw new Error('All image optimizations failed');}
return results;});}}
module.exports=OptimizedImages;},{"../../../lib/url-shim":30,"../gatherer":16}],"./gatherers/dobetterweb/password-inputs-with-prevented-paste":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function findPasswordInputsWithPreventedPaste(){function getOuterHTMLSnippet(node){const reOpeningTag=/^.*?\>/;const match=node.outerHTML.match(reOpeningTag);return match&&match[0];}
return Array.from(document.querySelectorAll('input[type="password"]')).filter(passwordInput=>!passwordInput.dispatchEvent(new ClipboardEvent('paste',{cancelable:true}))).map(passwordInput=>({snippet:getOuterHTMLSnippet(passwordInput)}));}
class PasswordInputsWithPreventedPaste extends Gatherer{afterPass(options){const driver=options.driver;return driver.evaluateAsync(`(${findPasswordInputsWithPreventedPaste.toString()}())`);}}
module.exports=PasswordInputsWithPreventedPaste;},{"../gatherer":16}],"./gatherers/dobetterweb/response-compression":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('../gatherer');const gzip=require('zlib').gzip;const compressionTypes=['gzip','br','deflate'];class ResponseCompression extends Gatherer{static filterUnoptimizedResponses(networkRecords){const unoptimizedResponses=[];networkRecords.forEach(record=>{const isTextBasedResource=record.resourceType()&&record.resourceType().isTextType();if(!isTextBasedResource||!record.resourceSize||!record.finished){return;}
const isContentEncoded=record.responseHeaders.find(header=>header.name.toLowerCase()==='content-encoding'&&compressionTypes.includes(header.value));if(!isContentEncoded){unoptimizedResponses.push({requestId:record.requestId,url:record.url,mimeType:record.mimeType,resourceSize:record.resourceSize});}});return unoptimizedResponses;}
afterPass(options,traceData){const networkRecords=traceData.networkRecords;const textRecords=ResponseCompression.filterUnoptimizedResponses(networkRecords);const driver=options.driver;return Promise.all(textRecords.map(record=>{return driver.getRequestContent(record.requestId).then(content=>{if(!content){record.gzipSize=0;return record;}
return new Promise((resolve,reject)=>{return gzip(content,(err,res)=>{if(err){return reject(err);}
record.gzipSize=Buffer.byteLength(res,'utf8');resolve(record);});});});}));}}
module.exports=ResponseCompression;}).call(this,require("buffer").Buffer);},{"../gatherer":16,"buffer":43,"zlib":40}],"./gatherers/dobetterweb/tags-blocking-first-paint":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function collectTagsThatBlockFirstPaint(){return new Promise((resolve,reject)=>{try{const tagList=[...document.querySelectorAll('link, head script[src]')].filter(tag=>{if(tag.tagName==='SCRIPT'){return!tag.hasAttribute('async')&&!tag.hasAttribute('defer')&&!/^data:/.test(tag.src);}
const blockingStylesheet=tag.rel==='stylesheet'&&window.matchMedia(tag.media).matches&&!tag.disabled;const blockingImport=tag.rel==='import'&&!tag.hasAttribute('async');return blockingStylesheet||blockingImport;}).map(tag=>{return{tagName:tag.tagName,url:tag.tagName==='LINK'?tag.href:tag.src,src:tag.src,href:tag.href,rel:tag.rel,media:tag.media,disabled:tag.disabled};});resolve(tagList);}catch(e){const friendly='Unable to gather Scripts/Stylesheets/HTML Imports on the page';reject(new Error(`${friendly}: ${e.message}`));}});}
function filteredAndIndexedByUrl(networkRecords){return networkRecords.reduce((prev,record)=>{if(!record.finished){return prev;}
const isParserGenerated=record._initiator.type==='parser';const isParserScriptOrStyle=/(css|script)/.test(record._mimeType)&&isParserGenerated;const isFailedRequest=record._failed;const isHtml=record._mimeType&&record._mimeType.includes('html');if(isHtml||isParserScriptOrStyle||isFailedRequest&&isParserGenerated){prev[record._url]={isLinkPreload:record.isLinkPreload,transferSize:record._transferSize,startTime:record._startTime,endTime:record._endTime};}
return prev;},{});}
class TagsBlockingFirstPaint extends Gatherer{constructor(){super();this._filteredAndIndexedByUrl=filteredAndIndexedByUrl;}
static findBlockingTags(driver,networkRecords){const scriptSrc=`(${collectTagsThatBlockFirstPaint.toString()}())`;return driver.evaluateAsync(scriptSrc).then(tags=>{const requests=filteredAndIndexedByUrl(networkRecords);return tags.reduce((prev,tag)=>{const request=requests[tag.url];if(request&&!request.isLinkPreload){prev.push({tag,transferSize:request.transferSize||0,startTime:request.startTime,endTime:request.endTime});requests[tag.url]=null;}
return prev;},[]);});}
afterPass(options,tracingData){return TagsBlockingFirstPaint.findBlockingTags(options.driver,tracingData.networkRecords);}}
module.exports=TagsBlockingFirstPaint;},{"../gatherer":16}],"./gatherers/dobetterweb/websql":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const MAX_WAIT_TIMEOUT=500;class WebSQL extends Gatherer{listenForDatabaseEvents(driver){let timeout;return new Promise((resolve,reject)=>{driver.once('Database.addDatabase',db=>{clearTimeout(timeout);driver.sendCommand('Database.disable').then(_=>resolve(db),reject);});driver.sendCommand('Database.enable').catch(reject);timeout=setTimeout(function(){resolve(null);},MAX_WAIT_TIMEOUT);});}
afterPass(options){return this.listenForDatabaseEvents(options.driver).then(result=>{return result&&result.database;});}}
module.exports=WebSQL;},{"../gatherer":16}],"./gatherers/html-without-javascript":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getBodyText(){const body=document.querySelector('body');return Promise.resolve(body?body.innerText:'');}
class HTMLWithoutJavaScript extends Gatherer{beforePass(options){options.disableJavaScript=true;}
afterPass(options){options.disableJavaScript=false;return options.driver.evaluateAsync(`(${getBodyText.toString()}())`).then(result=>{if(typeof result!=='string'){throw new Error('document body innerText returned by protocol was not a string');}
return{value:result};});}}
module.exports=HTMLWithoutJavaScript;},{"./gatherer":16}],"./gatherers/http-redirect":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class HTTPRedirect extends Gatherer{constructor(){super();this._preRedirectURL=undefined;}
beforePass(options){this._preRedirectURL=options.url;options.url=this._preRedirectURL.replace(/^https/,'http');}
afterPass(options){options.url=this._preRedirectURL;const timeout=options._testTimeout||10000;const securityPromise=options.driver.getSecurityState().then(state=>{return{value:state.schemeIsCryptographic};});let noSecurityChangesTimeout;const timeoutPromise=new Promise((resolve,reject)=>{noSecurityChangesTimeout=setTimeout(_=>{reject(new Error('Timed out waiting for HTTP redirection.'));},timeout);});return Promise.race([securityPromise,timeoutPromise]).then(result=>{clearTimeout(noSecurityChangesTimeout);return result;}).catch(err=>{clearTimeout(noSecurityChangesTimeout);throw err;});}}
module.exports=HTTPRedirect;},{"./gatherer":16}],"./gatherers/image-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const DOMHelpers=require('../../lib/dom-helpers.js');function collectImageElementInfo(){function getClientRect(element){const clientRect=element.getBoundingClientRect();return{top:clientRect.top,bottom:clientRect.bottom,left:clientRect.left,right:clientRect.right};}
const allElements=getElementsInDocument();const allImageElements=allElements.filter(element=>element.localName==='img');const htmlImages=allImageElements.map(element=>{return{src:element.currentSrc,clientWidth:element.clientWidth,clientHeight:element.clientHeight,clientRect:getClientRect(element),naturalWidth:element.naturalWidth,naturalHeight:element.naturalHeight,isCss:false,isPicture:element.parentElement.tagName==='PICTURE'};});const CSS_URL_REGEX=/^url\("([^"]+)"\)$/;const CSS_SIZE_REGEX=/(auto|contain|cover)/;const cssImages=allElements.reduce((images,element)=>{const style=window.getComputedStyle(element);if(!CSS_URL_REGEX.test(style.backgroundImage)||!CSS_SIZE_REGEX.test(style.backgroundSize)){return images;}
const imageMatch=style.backgroundImage.match(CSS_URL_REGEX);const url=imageMatch[1];const differentImages=images.filter(image=>image.src!==url);if(images.length-differentImages.length>2){return differentImages;}
images.push({src:url,clientWidth:element.clientWidth,clientHeight:element.clientHeight,clientRect:getClientRect(element),naturalWidth:Number.MAX_VALUE,naturalHeight:Number.MAX_VALUE,isCss:true,isPicture:false});return images;},[]);return htmlImages.concat(cssImages);}
function determineNaturalSize(url){return new Promise((resolve,reject)=>{const img=new Image();img.addEventListener('error',reject);img.addEventListener('load',()=>{resolve({naturalWidth:img.naturalWidth,naturalHeight:img.naturalHeight});});img.src=url;});}
class ImageUsage extends Gatherer{fetchElementWithSizeInformation(element){const url=JSON.stringify(element.src);return this.driver.evaluateAsync(`(${determineNaturalSize.toString()})(${url})`).then(size=>{return Object.assign(element,size);});}
afterPass(options,traceData){const driver=this.driver=options.driver;const indexedNetworkRecords=traceData.networkRecords.reduce((map,record)=>{if(/^image/.test(record._mimeType)&&record.finished){map[record._url]={url:record.url,resourceSize:record.resourceSize,startTime:record.startTime,endTime:record.endTime,responseReceivedTime:record.responseReceivedTime,mimeType:record._mimeType};}
return map;},{});const expression=`(function() {
      ${DOMHelpers.getElementsInDocumentFnString}; // define function on page
      return (${collectImageElementInfo.toString()})();
    })()`;return driver.evaluateAsync(expression).then(elements=>{return elements.reduce((promise,element)=>{return promise.then(collector=>{element.networkRecord=indexedNetworkRecords[element.src];const elementPromise=(element.isPicture||element.isCss)&&element.networkRecord?this.fetchElementWithSizeInformation(element):Promise.resolve(element);return elementPromise.then(element=>{collector.push(element);return collector;});});},Promise.resolve([]));});}}
module.exports=ImageUsage;},{"../../lib/dom-helpers.js":18,"./gatherer":16}],"./gatherers/manifest":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('./gatherer');const manifestParser=require('../../lib/manifest-parser');const BOM_LENGTH=3;const BOM_FIRSTCHAR=65279;class Manifest extends Gatherer{afterPass(options){return options.driver.getAppManifest().then(response=>{if(!response){return null;}
const isBomEncoded=response.data.charCodeAt(0)===BOM_FIRSTCHAR;if(isBomEncoded){response.data=Buffer.from(response.data).slice(BOM_LENGTH).toString();}
return manifestParser(response.data,response.url,options.url);});}}
module.exports=Manifest;}).call(this,require("buffer").Buffer);},{"../../lib/manifest-parser":23,"./gatherer":16,"buffer":43}],"./gatherers/offline":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const URL=require('../../lib/url-shim');class Offline extends Gatherer{beforePass(options){return options.driver.goOffline();}
afterPass(options,tracingData){const navigationRecord=tracingData.networkRecords.filter(record=>{return URL.equalWithExcludedFragments(record._url,options.url)&&record._fetchedViaServiceWorker;}).pop();return options.driver.goOnline(options).then(_=>navigationRecord?navigationRecord.statusCode:-1);}}
module.exports=Offline;},{"../../lib/url-shim":30,"./gatherer":16}],"./gatherers/service-worker":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ServiceWorker extends Gatherer{beforePass(options){const driver=options.driver;return driver.getServiceWorkerVersions().then(data=>{return{versions:data.versions};});}}
module.exports=ServiceWorker;},{"./gatherer":16}],"./gatherers/start-url":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const URL=require('../../lib/url-shim');const manifestParser=require('../../lib/manifest-parser');class StartUrl extends Gatherer{constructor(){super();this.startUrl=null;this.err=null;}
executeFetchRequest(driver,url){return new Promise((resolve,reject)=>{let requestId;const fetchRequestId=data=>{if(URL.equalWithExcludedFragments(data.request.url,url)){requestId=data.requestId;driver.off('Network.requestWillBeSent',fetchRequestId);}};const fetchDone=data=>{if(data.requestId===requestId){driver.off('Network.loadingFinished',fetchDone);driver.off('Network.loadingFailed',fetchDone);resolve();}};driver.on('Network.requestWillBeSent',fetchRequestId);driver.on('Network.loadingFinished',fetchDone);driver.on('Network.loadingFailed',fetchDone);driver.evaluateAsync(`fetch('${url}')
          .then(response => response.status)
          .catch(err => -1)`).catch(err=>reject(err));});}
pass(options){return options.driver.getAppManifest().then(response=>{return response&&manifestParser(response.data,response.url,options.url);}).then(manifest=>{if(!manifest||!manifest.value){const detailedMsg=manifest&&manifest.debugString;this.debugString=detailedMsg?`Error fetching web app manifest: ${detailedMsg}`:`No usable web app manifest found on page ${options.url}`;return;}
if(manifest.value.start_url.debugString){this.debugString=manifest.value.start_url.debugString;}
this.startUrl=manifest.value.start_url.value;return this.executeFetchRequest(options.driver,this.startUrl);});}
afterPass(options,tracingData){const networkRecords=tracingData.networkRecords;const navigationRecord=networkRecords.filter(record=>{return URL.equalWithExcludedFragments(record._url,this.startUrl)&&record._fetchedViaServiceWorker;}).pop();return options.driver.goOnline(options).then(_=>{if(!this.startUrl){return{statusCode:-1,debugString:this.debugString||'No start URL to fetch'};}else if(!navigationRecord){return{statusCode:-1,debugString:this.debugString||'Did not fetch start URL from service worker'};}else{return{statusCode:navigationRecord.statusCode,debugString:this.debugString};}});}}
module.exports=StartUrl;},{"../../lib/manifest-parser":23,"../../lib/url-shim":30,"./gatherer":16}],"./gatherers/styles":[function(require,module,exports){'use strict';const WebInspector=require('../../lib/web-inspector');const Gatherer=require('./gatherer');const log=require('lighthouse-logger');function getCSSPropsInStyleSheet(parseTree){const results=[];parseTree.traverseByType('declaration',function(node,index,parent){if(parent.type==='arguments'){return;}
const keyVal=node.toString().split(':').map(item=>item.trim());results.push({property:{name:keyVal[0],val:keyVal[1]},declarationRange:node.declarationRange,selector:parent.selectors.toString()});});return results;}
class Styles extends Gatherer{constructor(){super();this._activeStyleSheetIds=[];this._activeStyleHeaders={};this._onStyleSheetAdded=this.onStyleSheetAdded.bind(this);this._onStyleSheetRemoved=this.onStyleSheetRemoved.bind(this);}
onStyleSheetAdded(styleHeader){if(styleHeader.header.origin!=='regular'){return;}
this._activeStyleHeaders[styleHeader.header.styleSheetId]=styleHeader;this._activeStyleSheetIds.push(styleHeader.header.styleSheetId);}
onStyleSheetRemoved(styleHeader){delete this._activeStyleHeaders[styleHeader.styleSheetId];const idx=this._activeStyleSheetIds.indexOf(styleHeader.styleSheetId);if(idx!==-1){this._activeStyleSheetIds.splice(idx,1);}}
beginStylesCollect(driver){driver.on('CSS.styleSheetAdded',this._onStyleSheetAdded);driver.on('CSS.styleSheetRemoved',this._onStyleSheetRemoved);return driver.sendCommand('DOM.enable').then(_=>driver.sendCommand('CSS.enable'));}
endStylesCollect(driver){return new Promise((resolve,reject)=>{if(!this._activeStyleSheetIds.length){resolve([]);return;}
const parser=new WebInspector.SCSSParser();const contentPromises=this._activeStyleSheetIds.map(sheetId=>{return driver.sendCommand('CSS.getStyleSheetText',{styleSheetId:sheetId}).then(content=>{const styleHeader=this._activeStyleHeaders[sheetId];styleHeader.content=content.text;const parsedContent=parser.parse(styleHeader.content);if(parsedContent.error){const error=parsedContent.error.toString().slice(0,100);log.warn('Styles Gatherer',`Could not parse content: ${error}…`);styleHeader.parsedContent=[];}else{styleHeader.parsedContent=getCSSPropsInStyleSheet(parsedContent);}
return styleHeader;});});Promise.all(contentPromises).then(styleHeaders=>{driver.off('CSS.styleSheetAdded',this._onStyleSheetAdded);driver.off('CSS.styleSheetRemoved',this._onStyleSheetRemoved);return driver.sendCommand('CSS.disable').then(_=>driver.sendCommand('DOM.disable')).then(_=>resolve(styleHeaders));}).catch(err=>reject(err));});}
beforePass(options){return this.beginStylesCollect(options.driver);}
afterPass(options){return this.endStylesCollect(options.driver).then(stylesheets=>{const map=new Map(stylesheets.map(s=>[s.content,s]));return stylesheets.map(stylesheet=>{const idInMap=map.get(stylesheet.content).header.styleSheetId;stylesheet.isDuplicate=idInMap!==stylesheet.header.styleSheetId;return stylesheet;});});}}
module.exports=Styles;},{"../../lib/web-inspector":31,"./gatherer":16,"lighthouse-logger":109}],"./gatherers/theme-color":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ThemeColor extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('head meta[name="theme-color"]').then(node=>node&&node.getAttribute('content'));}}
module.exports=ThemeColor;},{"./gatherer":16}],"./gatherers/url":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class URL extends Gatherer{afterPass(options){return{initialUrl:options.initialUrl,finalUrl:options.url};}}
module.exports=URL;},{"./gatherer":16}],"./gatherers/viewport-dimensions":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getViewportDimensions(){return Promise.resolve({innerWidth:window.innerWidth,innerHeight:window.innerHeight,outerWidth:window.outerWidth,outerHeight:window.outerHeight,devicePixelRatio:window.devicePixelRatio});}
class ViewportDimensions extends Gatherer{afterPass(options){const driver=options.driver;return driver.evaluateAsync(`(${getViewportDimensions.toString()}())`).then(dimensions=>{const allNumeric=Object.keys(dimensions).every(key=>Number.isFinite(dimensions[key]));if(!allNumeric){const results=JSON.stringify(dimensions);throw new Error(`ViewportDimensions results were not numeric: ${results}`);}
return dimensions;});}}
module.exports=ViewportDimensions;},{"./gatherer":16}],"./gatherers/viewport":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class Viewport extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('head meta[name="viewport"]').then(node=>node&&node.getAttribute('content'));}}
module.exports=Viewport;},{"./gatherer":16}],1:[function(require,module,exports){'use strict';const Audit=require('../audit');class AxeAudit extends Audit{static audit(artifacts){const violations=artifacts.Accessibility.violations;const rule=violations.find(result=>result.id===this.meta.name);let nodeDetails=[];if(rule&&rule.nodes){nodeDetails=rule.nodes.map(node=>({type:'node',selector:Array.isArray(node.target)?node.target.join(' '):'',path:node.path,snippet:node.snippet}));}
return{rawValue:typeof rule==='undefined',extendedInfo:{value:rule},details:{type:'list',header:{type:'text',text:'View failing elements'},items:nodeDetails}};}}
module.exports=AxeAudit;},{"../audit":2}],2:[function(require,module,exports){'use strict';const statistics=require('../lib/statistics');const DEFAULT_PASS='defaultPass';class Audit{static get DEFAULT_PASS(){return DEFAULT_PASS;}
static get SCORING_MODES(){return{NUMERIC:'numeric',BINARY:'binary'};}
static get meta(){throw new Error('Audit meta information must be overridden.');}
static computeLogNormalScore(measuredValue,diminishingReturnsValue,medianValue){const distribution=statistics.getLogNormalDistribution(medianValue,diminishingReturnsValue);let score=100*distribution.computeComplementaryPercentile(measuredValue);score=Math.min(100,score);score=Math.max(0,score);return Math.round(score);}
static generateErrorAuditResult(audit,debugString){return Audit.generateAuditResult(audit,{rawValue:null,error:true,debugString});}
static makeTableRows(headings,results){const tableRows=results.map(item=>{return headings.map(heading=>{const value=item[heading.key];if(typeof value==='object'&&value&&value.type)return value;return{type:heading.itemType,text:value};});});return tableRows;}
static makeTableHeaders(headings){return headings.map(heading=>({type:'text',itemType:heading.itemType,text:heading.text}));}
static makeTableDetails(headings,results){const tableHeaders=Audit.makeTableHeaders(headings);const tableRows=Audit.makeTableRows(headings,results);return{type:'table',header:'View Details',itemHeaders:tableHeaders,items:tableRows};}
static generateAuditResult(audit,result){if(typeof result.rawValue==='undefined'){throw new Error('generateAuditResult requires a rawValue');}
const score=typeof result.score==='undefined'?result.rawValue:result.score;let displayValue=result.displayValue;if(typeof displayValue==='undefined'){displayValue=result.rawValue?result.rawValue:'';}
if(displayValue===score){displayValue='';}
let auditDescription=audit.meta.description;if(audit.meta.failureDescription){if(!score||typeof score==='number'&&score<100){auditDescription=audit.meta.failureDescription;}}
return{score,displayValue:`${displayValue}`,rawValue:result.rawValue,error:result.error,debugString:result.debugString,optimalValue:result.optimalValue,extendedInfo:result.extendedInfo,scoringMode:audit.meta.scoringMode||Audit.SCORING_MODES.BINARY,informative:audit.meta.informative,manual:audit.meta.manual,name:audit.meta.name,category:audit.meta.category,description:auditDescription,helpText:audit.meta.helpText,details:result.details};}}
module.exports=Audit;Audit.Headings;Audit.HeadingsResult;},{"../lib/statistics":25}],3:[function(require,module,exports){'use strict';const Audit=require('../audit');const Util=require('../../report/v2/renderer/util');const KB_IN_BYTES=1024;const WASTED_MS_FOR_AVERAGE=300;const WASTED_MS_FOR_POOR=750;class UnusedBytes extends Audit{static scoreForWastedMs(wastedMs){if(wastedMs===0)return 100;else
if(wastedMs<WASTED_MS_FOR_AVERAGE)return 90;else
if(wastedMs<WASTED_MS_FOR_POOR)return 65;else
return 0;}
static bytesToKbString(bytes){return Util.formatBytesToKB(bytes,0);}
static toSavingsString(bytes=0,percent=0){const kbDisplay=this.bytesToKbString(bytes);const percentDisplay=Util.formatNumber(Math.round(percent))+'%';return`${kbDisplay} (${percentDisplay})`;}
static bytesToMsString(bytes,networkThroughput){return Util.formatMilliseconds(bytes/networkThroughput*1000,10);}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLog).then(networkRecords=>this.audit_(artifacts,networkRecords)).then(result=>{return artifacts.requestNetworkThroughput(devtoolsLog).then(networkThroughput=>this.createAuditResult(result,networkThroughput));});}
static createAuditResult(result,networkThroughput){if(!Number.isFinite(networkThroughput)&&result.results.length){throw new Error('Invalid network timing information');}
const debugString=result.debugString;const results=result.results.map(item=>{const wastedPercent=100*item.wastedBytes/item.totalBytes;item.wastedKb=this.bytesToKbString(item.wastedBytes);item.wastedMs=this.bytesToMsString(item.wastedBytes,networkThroughput);item.totalKb=this.bytesToKbString(item.totalBytes);item.totalMs=this.bytesToMsString(item.totalBytes,networkThroughput);item.potentialSavings=this.toSavingsString(item.wastedBytes,wastedPercent);return item;}).sort((itemA,itemB)=>itemB.wastedBytes-itemA.wastedBytes);const wastedBytes=results.reduce((sum,item)=>sum+item.wastedBytes,0);const wastedKb=Math.round(wastedBytes/KB_IN_BYTES);const wastedMs=Math.round(wastedBytes/networkThroughput*100)*10;let displayValue=result.displayValue||'';if(typeof result.displayValue==='undefined'&&wastedBytes){const wastedKbDisplay=this.bytesToKbString(wastedBytes);const wastedMsDisplay=this.bytesToMsString(wastedBytes,networkThroughput);displayValue=`Potential savings of ${wastedKbDisplay} (~${wastedMsDisplay})`;}
const tableDetails=Audit.makeTableDetails(result.headings,results);return{debugString,displayValue,rawValue:wastedMs,score:UnusedBytes.scoreForWastedMs(wastedMs),extendedInfo:{value:{wastedMs,wastedKb,results}},details:tableDetails};}
static audit_(){throw new Error('audit_ unimplemented');}}
module.exports=UnusedBytes;},{"../../report/v2/renderer/util":32,"../audit":2}],4:[function(require,module,exports){'use strict';const Audit=require('../audit');class ManualAudit extends Audit{static get meta(){return{informative:true,manual:true,requiredArtifacts:[]};}
static audit(){return{rawValue:false};}}
module.exports=ManualAudit;},{"../audit":2}],5:[function(require,module,exports){'use strict';const Audit=require('./audit');class MultiCheckAudit extends Audit{static audit(artifacts){return Promise.resolve(this.audit_(artifacts)).then(result=>this.createAuditResult(result));}
static createAuditResult(result){const extendedInfo={value:result};if(result.failures.length>0){return{rawValue:false,debugString:`Failures: ${result.failures.join(', ')}.`,extendedInfo};}
let debugString;if(result.warnings&&result.warnings.length>0){debugString=`Warnings: ${result.warnings.join(', ')}`;}
return{rawValue:true,extendedInfo,debugString};}
static audit_(){throw new Error('audit_ unimplemented');}}
module.exports=MultiCheckAudit;},{"./audit":2}],6:[function(require,module,exports){'use strict';const Audit=require('./audit');class ViolationAudit extends Audit{static getViolationResults(artifacts,pattern){return artifacts.ChromeConsoleMessages.map(message=>message.entry).filter(entry=>entry.url&&entry.source==='violation'&&pattern.test(entry.text)).map(entry=>Object.assign({label:`line: ${entry.lineNumber}`},entry));}}
module.exports=ViolationAudit;},{"./audit":2}],7:[function(require,module,exports){(function(__dirname){'use strict';const defaultConfigPath='./default.js';const defaultConfig=require('./default.js');const fullConfig=require('./full-config.js');const GatherRunner=require('../gather/gather-runner');const log=require('lighthouse-logger');const path=require('path');const Audit=require('../audits/audit');const Runner=require('../runner');const _flatten=arr=>[].concat(...arr);function cleanTrace(trace){const traceEvents=trace.traceEvents;const threads=[];const countsByThread={};const traceStartEvents=[];const makeMockEvent=(evt,ts)=>{return{pid:evt.pid,tid:evt.tid,ts:ts||0,ph:'I',cat:'disabled-by-default-devtools.timeline',name:'TracingStartedInPage',args:{data:{page:evt.frame}},s:'t'};};let frame;let data;let name;let counter;traceEvents.forEach((evt,idx)=>{if(evt.name.startsWith('TracingStartedIn')){traceStartEvents.push(idx);}
data=evt.args&&(evt.args.data||evt.args.beginData||evt.args.counters);frame=evt.args&&evt.args.frame||data&&(data.frame||data.page);if(!frame){return;}
name=`pid${evt.pid}-tid${evt.tid}-frame${frame}`;counter=countsByThread[name];if(!counter){counter={pid:evt.pid,tid:evt.tid,frame:frame,count:0};countsByThread[name]=counter;threads.push(counter);}
counter.count++;});threads.sort((a,b)=>b.count-a.count);const mostActiveFrame=threads[0];const ts=traceEvents[traceStartEvents[0]]&&traceEvents[traceStartEvents[0]].ts;let i=0;for(const dup of traceStartEvents){traceEvents.splice(dup-i,1);i++;}
traceEvents.unshift(makeMockEvent(mostActiveFrame,ts));return trace;}
function validatePasses(passes,audits,rootPath){if(!Array.isArray(passes)){return;}
const requiredGatherers=Config.getGatherersNeededByAudits(audits);passes.forEach(pass=>{pass.gatherers.forEach(gatherer=>{const GathererClass=GatherRunner.getGathererClass(gatherer,rootPath);const isGatherRequiredByAudits=requiredGatherers.has(GathererClass.name);if(isGatherRequiredByAudits===false){const msg=`${GathererClass.name} gatherer requested, however no audit requires it.`;log.warn('config',msg);}});});const usedNames=new Set();let defaultUsed=false;passes.forEach((pass,index)=>{let passName=pass.passName;if(!passName){if(defaultUsed){throw new Error(`passes[${index}] requires a passName`);}
passName=Audit.DEFAULT_PASS;defaultUsed=true;}
if(usedNames.has(passName)){throw new Error(`Passes must have unique names (repeated passName: ${passName}.`);}
usedNames.add(passName);});}
function validateCategories(categories,audits,auditResults,groups){if(!categories){return;}
const auditIds=audits?audits.map(audit=>audit.meta.name):auditResults.map(audit=>audit.name);Object.keys(categories).forEach(categoryId=>{categories[categoryId].audits.forEach((audit,index)=>{if(!audit.id){throw new Error(`missing an audit id at ${categoryId}[${index}]`);}
if(!auditIds.includes(audit.id)){throw new Error(`could not find ${audit.id} audit for category ${categoryId}`);}
if(categoryId==='accessibility'&&!audit.group){throw new Error(`${audit.id} accessibility audit does not have a group`);}
if(audit.group&&!groups[audit.group]){throw new Error(`${audit.id} references unknown group ${audit.group}`);}});});}
function assertValidAudit(auditDefinition,auditPath){const auditName=auditPath||auditDefinition.meta.name;if(typeof auditDefinition.audit!=='function'){throw new Error(`${auditName} has no audit() method.`);}
if(typeof auditDefinition.meta.name!=='string'){throw new Error(`${auditName} has no meta.name property, or the property is not a string.`);}
if(typeof auditDefinition.meta.category!=='string'){throw new Error(`${auditName} has no meta.category property, or the property is not a string.`);}
if(typeof auditDefinition.meta.description!=='string'){throw new Error(`${auditName} has no meta.description property, or the property is not a string.`);}
if(typeof auditDefinition.meta.failureDescription!=='string'&&auditDefinition.meta.informative!==true&&auditDefinition.meta.scoringMode!==Audit.SCORING_MODES.NUMERIC){throw new Error(`${auditName} has no failureDescription and should.`);}
if(typeof auditDefinition.meta.helpText!=='string'){throw new Error(`${auditName} has no meta.helpText property, or the property is not a string.`);}else if(auditDefinition.meta.helpText===''){throw new Error(`${auditName} has an empty meta.helpText string. Please add a description for the UI.`);}
if(!Array.isArray(auditDefinition.meta.requiredArtifacts)){throw new Error(`${auditName} has no meta.requiredArtifacts property, or the property is not an array.`);}}
function expandArtifacts(artifacts){if(!artifacts){return null;}
if(artifacts.traces){Object.keys(artifacts.traces).forEach(key=>{log.log('info','Normalizng trace contents into expected state...');let trace=require(artifacts.traces[key]);if(Array.isArray(trace)){trace={traceEvents:trace};}
trace=cleanTrace(trace);artifacts.traces[key]=trace;});}
if(artifacts.devtoolsLogs){Object.keys(artifacts.devtoolsLogs).forEach(key=>{artifacts.devtoolsLogs[key]=require(artifacts.devtoolsLogs[key]);});}
return artifacts;}
function merge(base,extension){if(typeof base==='undefined'){return extension;}else if(Array.isArray(extension)){if(!Array.isArray(base))throw new TypeError(`Expected array but got ${typeof base}`);return base.concat(extension);}else if(typeof extension==='object'){if(typeof base!=='object')throw new TypeError(`Expected object but got ${typeof base}`);Object.keys(extension).forEach(key=>{base[key]=merge(base[key],extension[key]);});return base;}
return extension;}
function deepClone(json){return JSON.parse(JSON.stringify(json));}
class Config{constructor(configJSON,configPath){if(!configJSON){configJSON=defaultConfig;configPath=path.resolve(__dirname,defaultConfigPath);}
if(configPath&&!path.isAbsolute(configPath)){throw new Error('configPath must be an absolute path.');}
const inputConfig=configJSON;configJSON=deepClone(configJSON);if(Array.isArray(inputConfig.passes)){configJSON.passes.forEach((pass,i)=>{pass.gatherers=Array.from(inputConfig.passes[i].gatherers);});}
if(Array.isArray(inputConfig.audits)){configJSON.audits=Array.from(inputConfig.audits);}
if(configJSON.extends==='lighthouse:full'){const explodedFullConfig=Config.extendConfigJSON(deepClone(defaultConfig),deepClone(fullConfig));configJSON=Config.extendConfigJSON(explodedFullConfig,configJSON);}else if(configJSON.extends){configJSON=Config.extendConfigJSON(deepClone(defaultConfig),configJSON);}
if(configJSON.settings&&(Array.isArray(configJSON.settings.onlyCategories)||Array.isArray(configJSON.settings.onlyAudits)||Array.isArray(configJSON.settings.skipAudits))){const categoryIds=configJSON.settings.onlyCategories;const auditIds=configJSON.settings.onlyAudits;const skipAuditIds=configJSON.settings.skipAudits;configJSON=Config.generateNewFilteredConfig(configJSON,categoryIds,auditIds,skipAuditIds);}
this._configDir=configPath?path.dirname(configPath):undefined;this._passes=configJSON.passes||null;this._auditResults=configJSON.auditResults||null;if(this._auditResults&&!Array.isArray(this._auditResults)){throw new Error('config.auditResults must be an array');}
this._audits=Config.requireAudits(configJSON.audits,this._configDir);this._artifacts=expandArtifacts(configJSON.artifacts);this._categories=configJSON.categories;this._groups=configJSON.groups;validatePasses(configJSON.passes,this._audits,this._configDir);validateCategories(configJSON.categories,this._audits,this._auditResults,this._groups);}
static extendConfigJSON(baseJSON,extendJSON){if(extendJSON.passes){extendJSON.passes.forEach(pass=>{const basePass=baseJSON.passes.find(candidate=>candidate.passName===pass.passName);if(!basePass||!pass.passName){baseJSON.passes.push(pass);}else{merge(basePass,pass);}});delete extendJSON.passes;}
return merge(baseJSON,extendJSON);}
static generateNewFilteredConfig(oldConfig,categoryIds,auditIds,skipAuditIds){const config=deepClone(oldConfig);config.categories=Config.filterCategoriesAndAudits(config.categories,categoryIds,auditIds,skipAuditIds);const requestedAuditNames=Config.getAuditIdsInCategories(config.categories);const auditPathToNameMap=Config.getMapOfAuditPathToName(config);config.audits=config.audits.filter(auditPath=>requestedAuditNames.has(auditPathToNameMap.get(auditPath)));const auditObjectsSelected=Config.requireAudits(config.audits);const requiredGatherers=Config.getGatherersNeededByAudits(auditObjectsSelected);config.passes=Config.generatePassesNeededByGatherers(config.passes,requiredGatherers);return config;}
static filterCategoriesAndAudits(oldCategories,categoryIds,auditIds,skipAuditIds){if(auditIds&&skipAuditIds){throw new Error('Cannot set both skipAudits and onlyAudits');}
const categories={};const filterByIncludedCategory=!!categoryIds;const filterByIncludedAudit=!!auditIds;categoryIds=categoryIds||[];auditIds=auditIds||[];skipAuditIds=skipAuditIds||[];categoryIds.forEach(categoryId=>{if(!oldCategories[categoryId]){log.warn('config',`unrecognized category in 'onlyCategories': ${categoryId}`);}});const auditsToValidate=new Set(auditIds.concat(skipAuditIds));for(const auditId of auditsToValidate){const foundCategory=Object.keys(oldCategories).find(categoryId=>{const audits=oldCategories[categoryId].audits;return audits.find(candidate=>candidate.id===auditId);});if(!foundCategory){const parentKeyName=skipAuditIds.includes(auditId)?'skipAudits':'onlyAudits';log.warn('config',`unrecognized audit in '${parentKeyName}': ${auditId}`);}
if(auditIds.includes(auditId)&&categoryIds.includes(foundCategory)){log.warn('config',`${auditId} in 'onlyAudits' is already included by `+`${foundCategory} in 'onlyCategories'`);}}
Object.keys(oldCategories).forEach(categoryId=>{const category=deepClone(oldCategories[categoryId]);if(filterByIncludedCategory&&filterByIncludedAudit){if(!categoryIds.includes(categoryId)){category.audits=category.audits.filter(audit=>auditIds.includes(audit.id));}}else if(filterByIncludedCategory){if(!categoryIds.includes(categoryId)){return;}}else if(filterByIncludedAudit){category.audits=category.audits.filter(audit=>auditIds.includes(audit.id));}
category.audits=category.audits.filter(audit=>!skipAuditIds.includes(audit.id));if(category.audits.length){categories[categoryId]=category;}});return categories;}
static getAuditIdsInCategories(categories){const audits=_flatten(Object.keys(categories).map(id=>categories[id].audits));return new Set(audits.map(audit=>audit.id));}
static getCategories(config){return Object.keys(config.categories).map(id=>{const name=config.categories[id].name;return{id,name};});}
static getMapOfAuditPathToName(config){const auditObjectsAll=Config.requireAudits(config.audits);const auditPathToName=new Map(auditObjectsAll.map((AuditClass,index)=>{const auditPath=config.audits[index];const auditName=AuditClass.meta.name;return[auditPath,auditName];}));return auditPathToName;}
static getGatherersNeededByAudits(audits){if(!audits){return new Set();}
return audits.reduce((list,audit)=>{audit.meta.requiredArtifacts.forEach(artifact=>list.add(artifact));return list;},new Set());}
static generatePassesNeededByGatherers(oldPasses,requiredGatherers){const auditsNeedTrace=requiredGatherers.has('traces');const passes=JSON.parse(JSON.stringify(oldPasses));const filteredPasses=passes.map(pass=>{pass.gatherers=pass.gatherers.filter(gathererName=>{gathererName=GatherRunner.getGathererClass(gathererName).name;return requiredGatherers.has(gathererName);});if(pass.recordTrace&&!auditsNeedTrace){const passName=pass.passName||'unknown pass';log.warn('config',`Trace not requested by an audit, dropping trace in ${passName}`);pass.recordTrace=false;}
return pass;}).filter(pass=>{if(pass.recordTrace)return true;if(pass.passName==='defaultPass')return true;return pass.gatherers.length>0;});return filteredPasses;}
static requireAudits(audits,configPath){if(!audits){return null;}
const coreList=Runner.getAuditList();return audits.map(pathOrAuditClass=>{let AuditClass;if(typeof pathOrAuditClass==='string'){const path=pathOrAuditClass;const coreAudit=coreList.find(a=>a===`${path}.js`);let requirePath=`../audits/${path}`;if(!coreAudit){requirePath=Runner.resolvePlugin(path,configPath,'audit');}
AuditClass=require(requirePath);assertValidAudit(AuditClass,path);}else{AuditClass=pathOrAuditClass;assertValidAudit(AuditClass);}
return AuditClass;});}
get configDir(){return this._configDir;}
get passes(){return this._passes;}
get audits(){return this._audits;}
get auditResults(){return this._auditResults;}
get artifacts(){return this._artifacts;}
get categories(){return this._categories;}
get groups(){return this._groups;}}
module.exports=Config;}).call(this,"/../lighthouse-core/config");},{"../audits/audit":2,"../gather/gather-runner":15,"../runner":34,"./default.js":8,"./full-config.js":9,"lighthouse-logger":109,"path":58}],8:[function(require,module,exports){'use strict';module.exports={settings:{},passes:[{passName:'defaultPass',recordTrace:true,pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250,useThrottling:true,gatherers:['url','viewport','viewport-dimensions','theme-color','manifest','chrome-console-messages','image-usage','accessibility','dobetterweb/all-event-listeners','dobetterweb/anchors-with-no-rel-noopener','dobetterweb/appcache','dobetterweb/domstats','dobetterweb/optimized-images','dobetterweb/password-inputs-with-prevented-paste','dobetterweb/response-compression','dobetterweb/tags-blocking-first-paint','dobetterweb/websql']},{passName:'offlinePass',useThrottling:false,networkQuietThresholdMs:0,gatherers:['service-worker','offline','start-url']},{passName:'redirectPass',useThrottling:false,networkQuietThresholdMs:0,blockedUrlPatterns:['*.css','*.jpg','*.jpeg','*.png','*.gif','*.svg','*.ttf','*.woff','*.woff2'],gatherers:['http-redirect','html-without-javascript']}],audits:['is-on-https','redirects-http','service-worker','works-offline','viewport','without-javascript','first-meaningful-paint','load-fast-enough-for-pwa','speed-index-metric','screenshot-thumbnails','estimated-input-latency','first-interactive','consistently-interactive','user-timings','critical-request-chains','webapp-install-banner','splash-screen','themed-omnibox','manifest-short-name-length','content-width','deprecations','manual/pwa-cross-browser','manual/pwa-page-transitions','manual/pwa-each-page-has-url','accessibility/accesskeys','accessibility/aria-allowed-attr','accessibility/aria-required-attr','accessibility/aria-required-children','accessibility/aria-required-parent','accessibility/aria-roles','accessibility/aria-valid-attr-value','accessibility/aria-valid-attr','accessibility/audio-caption','accessibility/button-name','accessibility/bypass','accessibility/color-contrast','accessibility/definition-list','accessibility/dlitem','accessibility/document-title','accessibility/duplicate-id','accessibility/frame-title','accessibility/html-has-lang','accessibility/html-lang-valid','accessibility/image-alt','accessibility/input-image-alt','accessibility/label','accessibility/layout-table','accessibility/link-name','accessibility/list','accessibility/listitem','accessibility/meta-refresh','accessibility/meta-viewport','accessibility/object-alt','accessibility/tabindex','accessibility/td-headers-attr','accessibility/th-has-data-cells','accessibility/valid-lang','accessibility/video-caption','accessibility/video-description','byte-efficiency/total-byte-weight','byte-efficiency/offscreen-images','byte-efficiency/uses-webp-images','byte-efficiency/uses-optimized-images','byte-efficiency/uses-request-compression','byte-efficiency/uses-responsive-images','dobetterweb/appcache-manifest','dobetterweb/dom-size','dobetterweb/external-anchors-use-rel-noopener','dobetterweb/geolocation-on-start','dobetterweb/link-blocking-first-paint','dobetterweb/no-document-write','dobetterweb/no-mutation-events','dobetterweb/no-websql','dobetterweb/notification-on-start','dobetterweb/password-inputs-can-be-pasted-into','dobetterweb/script-blocking-first-paint','dobetterweb/uses-http2','dobetterweb/uses-passive-event-listeners'],groups:{'perf-metric':{title:'Metrics',description:'These metrics encapsulate your app\'s performance across a number of dimensions.'},'perf-hint':{title:'Opportunities',description:'These are opportunities to speed up your application by optimizing the following resources.'},'perf-info':{title:'Diagnostics',description:'More information about the performance of your application.'},'a11y-color-contrast':{title:'Color Contrast Is Satisfactory',description:'Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content.'},'a11y-describe-contents':{title:'Elements Describe Contents Well',description:'Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content.'},'a11y-well-structured':{title:'Elements Are Well Structured',description:'Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content.'},'a11y-aria':{title:'ARIA Attributes Follow Best Practices',description:'Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content.'},'a11y-correct-attributes':{title:'Elements Use Attributes Correctly',description:'Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content.'},'a11y-element-names':{title:'Elements Have Discernable Names',description:'Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content.'},'a11y-language':{title:'Page Specifies Valid Language',description:'Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content.'},'a11y-meta':{title:'Meta Tags Used Properly',description:'Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content.'},'manual-pwa-checks':{title:'Manual checks to verify',description:'These audits are required by the baseline '+'[PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist) but are '+'not automatically checked by Lighthouse. They do not affect your score but it\'s important that you verify them manually.'}},categories:{'pwa':{name:'Progressive Web App',weight:1,description:'These audits validate the aspects of a Progressive Web App, as specified by the baseline [PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist).',audits:[{id:'service-worker',weight:1},{id:'works-offline',weight:1},{id:'without-javascript',weight:1},{id:'is-on-https',weight:1},{id:'redirects-http',weight:1},{id:'load-fast-enough-for-pwa',weight:1},{id:'webapp-install-banner',weight:1},{id:'splash-screen',weight:1},{id:'themed-omnibox',weight:1},{id:'viewport',weight:1},{id:'content-width',weight:1},{id:'pwa-cross-browser',weight:0,group:'manual-pwa-checks'},{id:'pwa-page-transitions',weight:0,group:'manual-pwa-checks'},{id:'pwa-each-page-has-url',weight:0,group:'manual-pwa-checks'}]},'performance':{name:'Performance',description:'These encapsulate your app\'s performance.',audits:[{id:'first-meaningful-paint',weight:5,group:'perf-metric'},{id:'first-interactive',weight:5,group:'perf-metric'},{id:'consistently-interactive',weight:5,group:'perf-metric'},{id:'speed-index-metric',weight:1,group:'perf-metric'},{id:'estimated-input-latency',weight:1,group:'perf-metric'},{id:'link-blocking-first-paint',weight:0,group:'perf-hint'},{id:'script-blocking-first-paint',weight:0,group:'perf-hint'},{id:'uses-responsive-images',weight:0,group:'perf-hint'},{id:'offscreen-images',weight:0,group:'perf-hint'},{id:'uses-optimized-images',weight:0,group:'perf-hint'},{id:'uses-webp-images',weight:0,group:'perf-hint'},{id:'uses-request-compression',weight:0,group:'perf-hint'},{id:'total-byte-weight',weight:0,group:'perf-info'},{id:'dom-size',weight:0,group:'perf-info'},{id:'critical-request-chains',weight:0,group:'perf-info'},{id:'user-timings',weight:0,group:'perf-info'},{id:'screenshot-thumbnails',weight:0}]},'accessibility':{name:'Accessibility',description:'These checks highlight opportunities to [improve the accessibility of your app](https://developers.google.com/web/fundamentals/accessibility).',audits:[{id:'accesskeys',weight:1,group:'a11y-correct-attributes'},{id:'aria-allowed-attr',weight:1,group:'a11y-aria'},{id:'aria-required-attr',weight:1,group:'a11y-aria'},{id:'aria-required-children',weight:1,group:'a11y-aria'},{id:'aria-required-parent',weight:1,group:'a11y-aria'},{id:'aria-roles',weight:1,group:'a11y-aria'},{id:'aria-valid-attr-value',weight:1,group:'a11y-aria'},{id:'aria-valid-attr',weight:1,group:'a11y-aria'},{id:'audio-caption',weight:1,group:'a11y-correct-attributes'},{id:'button-name',weight:1,group:'a11y-element-names'},{id:'bypass',weight:1,group:'a11y-describe-contents'},{id:'color-contrast',weight:1,group:'a11y-color-contrast'},{id:'definition-list',weight:1,group:'a11y-well-structured'},{id:'dlitem',weight:1,group:'a11y-well-structured'},{id:'document-title',weight:1,group:'a11y-describe-contents'},{id:'duplicate-id',weight:1,group:'a11y-well-structured'},{id:'frame-title',weight:1,group:'a11y-describe-contents'},{id:'html-has-lang',weight:1,group:'a11y-language'},{id:'html-lang-valid',weight:1,group:'a11y-language'},{id:'image-alt',weight:1,group:'a11y-correct-attributes'},{id:'input-image-alt',weight:1,group:'a11y-correct-attributes'},{id:'label',weight:1,group:'a11y-describe-contents'},{id:'layout-table',weight:1,group:'a11y-describe-contents'},{id:'link-name',weight:1,group:'a11y-element-names'},{id:'list',weight:1,group:'a11y-well-structured'},{id:'listitem',weight:1,group:'a11y-well-structured'},{id:'meta-refresh',weight:1,group:'a11y-meta'},{id:'meta-viewport',weight:1,group:'a11y-meta'},{id:'object-alt',weight:1,group:'a11y-describe-contents'},{id:'tabindex',weight:1,group:'a11y-correct-attributes'},{id:'td-headers-attr',weight:1,group:'a11y-correct-attributes'},{id:'th-has-data-cells',weight:1,group:'a11y-correct-attributes'},{id:'valid-lang',weight:1,group:'a11y-language'},{id:'video-caption',weight:1,group:'a11y-describe-contents'},{id:'video-description',weight:1,group:'a11y-describe-contents'}]},'best-practices':{name:'Best Practices',description:'We\'ve compiled some recommendations for modernizing your web app and avoiding performance pitfalls. These audits do not affect your score but are worth a look.',audits:[{id:'appcache-manifest',weight:1},{id:'no-websql',weight:1},{id:'is-on-https',weight:1},{id:'uses-http2',weight:1},{id:'uses-passive-event-listeners',weight:1},{id:'no-mutation-events',weight:1},{id:'no-document-write',weight:1},{id:'external-anchors-use-rel-noopener',weight:1},{id:'geolocation-on-start',weight:1},{id:'notification-on-start',weight:1},{id:'deprecations',weight:1},{id:'manifest-short-name-length',weight:1},{id:'password-inputs-can-be-pasted-into',weight:1}]}}};},{}],9:[function(require,module,exports){'use strict';module.exports={extends:'lighthouse:default',passes:[{passName:'extraPass',gatherers:['styles']}],audits:['dobetterweb/no-old-flexbox'],categories:{'best-practices':{audits:[{id:'no-old-flexbox',weight:1}]}}};},{}],10:[function(require,module,exports){'use strict';const EventEmitter=require('events').EventEmitter;const log=require('lighthouse-logger');class Connection{constructor(){this._lastCommandId=0;this._callbacks=new Map();this._eventEmitter=new EventEmitter();}
connect(){return Promise.reject(new Error('Not implemented'));}
disconnect(){return Promise.reject(new Error('Not implemented'));}
sendCommand(method,params={},cmdOpts={}){log.formatProtocol('method => browser',{method,params},'verbose');const id=++this._lastCommandId;const message=JSON.stringify({id,method,params});this.sendRawMessage(message);return new Promise((resolve,reject)=>{this._callbacks.set(id,{resolve,reject,method,options:cmdOpts});});}
on(eventName,cb){if(eventName!=='notification'){throw new Error('Only supports "notification" events');}
this._eventEmitter.on(eventName,cb);}
sendRawMessage(message){return Promise.reject(new Error('Not implemented'));}
handleRawMessage(message){const object=JSON.parse(message);if(this._callbacks.has(object.id)){const callback=this._callbacks.get(object.id);this._callbacks.delete(object.id);return callback.resolve(Promise.resolve().then(_=>{if(object.error){const logLevel=callback.options&&callback.options.silent?'verbose':'error';log.formatProtocol('method <= browser ERR',{method:callback.method},logLevel);let errMsg=`(${callback.method}): ${object.error.message}`;if(object.error.data)errMsg+=` (${object.error.data})`;throw new Error(`Protocol error ${errMsg}`);}
log.formatProtocol('method <= browser OK',{method:callback.method,params:object.result},'verbose');return object.result;}));}else if(object.id){const error=object.error&&object.error.message;log.formatProtocol(`disowned method <= browser ${error?'ERR':'OK'}`,{method:object.method,params:error||object.result},'verbose');}else{log.formatProtocol('<= event',{method:object.method,params:object.params},'verbose');this.emitNotification(object.method,object.params);}}
emitNotification(method,params){this._eventEmitter.emit('notification',{method,params});}
dispose(){this._eventEmitter.removeAllListeners();this._eventEmitter=null;}}
module.exports=Connection;},{"events":45,"lighthouse-logger":109}],11:[function(require,module,exports){'use strict';const Connection=require('./connection.js');const log=require('lighthouse-logger');class ExtensionConnection extends Connection{constructor(){super();this._tabId=null;this._onEvent=this._onEvent.bind(this);this._onUnexpectedDetach=this._onUnexpectedDetach.bind(this);}
_onEvent(source,method,params){log.log('<=',method,params);this.emitNotification(method,params);}
_onUnexpectedDetach(debuggee,detachReason){this._detachCleanup();throw new Error('Lighthouse detached from browser: '+detachReason);}
_detachCleanup(){this._tabId=null;chrome.debugger.onEvent.removeListener(this._onEvent);chrome.debugger.onDetach.removeListener(this._onUnexpectedDetach);this.dispose();}
connect(){if(this._tabId!==null){return Promise.resolve();}
return this._queryCurrentTab().then(tab=>{const tabId=this._tabId=tab.id;chrome.debugger.onEvent.addListener(this._onEvent);chrome.debugger.onDetach.addListener(this._onUnexpectedDetach);return new Promise((resolve,reject)=>{chrome.debugger.attach({tabId},'1.1',_=>{if(chrome.runtime.lastError){return reject(new Error(chrome.runtime.lastError.message));}
resolve(tabId);});});});}
disconnect(){if(this._tabId===null){log.warn('ExtensionConnection','disconnect() was called without an established connection.');return Promise.resolve();}
const tabId=this._tabId;return new Promise((resolve,reject)=>{chrome.debugger.detach({tabId},_=>{if(chrome.runtime.lastError){return reject(new Error(chrome.runtime.lastError.message));}
chrome.tabs.reload(tabId);resolve();});}).then(_=>this._detachCleanup());}
sendCommand(command,params){return new Promise((resolve,reject)=>{log.formatProtocol('method => browser',{method:command,params:params},'verbose');if(!this._tabId){log.error('ExtensionConnection','No tabId set for sendCommand');}
chrome.debugger.sendCommand({tabId:this._tabId},command,params,result=>{if(chrome.runtime.lastError){const message=chrome.runtime.lastError.message;let errorMessage;try{errorMessage=JSON.parse(message).message;}catch(e){}
errorMessage=errorMessage||'Unknown debugger protocol error.';log.formatProtocol('method <= browser ERR',{method:command},'error');return reject(new Error(`Protocol error (${command}): ${errorMessage}`));}
log.formatProtocol('method <= browser OK',{method:command,params:result},'verbose');resolve(result);});});}
_queryCurrentTab(){return new Promise((resolve,reject)=>{const queryOpts={active:true,currentWindow:true};chrome.tabs.query(queryOpts,tabs=>{if(chrome.runtime.lastError){return reject(chrome.runtime.lastError);}
if(tabs.length===0){const message='Couldn\'t resolve current tab. Please file a bug.';return reject(new Error(message));}
if(tabs.length>1){log.warn('ExtensionConnection','_queryCurrentTab returned multiple tabs');}
resolve(tabs[0]);});});}
getCurrentTabURL(){return this._queryCurrentTab().then(tab=>{if(!tab.url){log.error('ExtensionConnection','getCurrentTabURL returned empty string',tab);}
return tab.url;});}}
module.exports=ExtensionConnection;},{"./connection.js":10,"lighthouse-logger":109}],12:[function(require,module,exports){'use strict';const Connection=require('./connection.js');class Port{on(eventName,cb){}
send(message){}
close(){}}
class RawConnection extends Connection{constructor(port){super();this._port=port;this._port.on('message',this.handleRawMessage.bind(this));this._port.on('close',this.dispose.bind(this));}
connect(){return Promise.resolve();}
disconnect(){this._port.close();return Promise.resolve();}
sendRawMessage(message){this._port.send(message);}}
module.exports=RawConnection;},{"./connection.js":10}],13:[function(require,module,exports){'use strict';class DevtoolsLog{constructor(regexFilter){this._filter=regexFilter;this._messages=[];this._isRecording=false;}
get messages(){return this._messages;}
reset(){this._messages=[];}
beginRecording(){this._isRecording=true;}
endRecording(){this._isRecording=false;}
record(message){if(this._isRecording&&(!this._filter||this._filter.test(message.method))){this._messages.push(message);}}}
module.exports=DevtoolsLog;},{}],14:[function(require,module,exports){'use strict';const NetworkRecorder=require('../lib/network-recorder');const emulation=require('../lib/emulation');const Element=require('../lib/element');const EventEmitter=require('events').EventEmitter;const URL=require('../lib/url-shim');const TraceParser=require('../lib/traces/trace-parser');const log=require('lighthouse-logger');const DevtoolsLog=require('./devtools-log');const DEFAULT_PAUSE_AFTER_LOAD=0;const DEFAULT_NETWORK_QUIET_THRESHOLD=5000;const DEFAULT_CPU_QUIET_THRESHOLD=0;const _uniq=arr=>Array.from(new Set(arr));class Driver{static get MAX_WAIT_FOR_FULLY_LOADED(){return 30*1000;}
constructor(connection){this._traceEvents=[];this._traceCategories=Driver.traceCategories;this._eventEmitter=new EventEmitter();this._connection=connection;this._devtoolsLog=new DevtoolsLog(/^(Page|Network)\./);this.online=true;this._domainEnabledCounts=new Map();this._networkStatusMonitor=null;this._monitoredUrl=null;connection.on('notification',event=>{this._devtoolsLog.record(event);if(this._networkStatusMonitor){this._networkStatusMonitor.dispatch(event.method,event.params);}
this._eventEmitter.emit(event.method,event.params);});}
static get traceCategories(){return['-*','toplevel','blink.console','blink.user_timing','benchmark','loading','latencyInfo','devtools.timeline','disabled-by-default-devtools.timeline','disabled-by-default-devtools.timeline.frame','disabled-by-default-devtools.timeline.stack','disabled-by-default-devtools.screenshot'];}
getUserAgent(){return this.evaluateAsync('navigator.userAgent');}
connect(){return this._connection.connect();}
disconnect(){return this._connection.disconnect();}
on(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen for event =>',{method:eventName},'verbose');this._eventEmitter.on(eventName,cb);}
once(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen once for event =>',{method:eventName},'verbose');this._eventEmitter.once(eventName,cb);}
off(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to remove an event listener.');}
this._eventEmitter.removeListener(eventName,cb);}
_shouldToggleDomain(domain,enable){const enabledCount=this._domainEnabledCounts.get(domain)||0;const newCount=enabledCount+(enable?1:-1);this._domainEnabledCounts.set(domain,Math.max(0,newCount));if(enable&&newCount===1||!enable&&newCount===0){log.verbose('Driver',`${domain}.${enable?'enable':'disable'}`);return true;}else{if(newCount<0){log.error('Driver',`Attempted to disable domain '${domain}' when already disabled.`);}
return false;}}
sendCommand(method,params,cmdOpts){const domainCommand=/^(\w+)\.(enable|disable)$/.exec(method);if(domainCommand){const enable=domainCommand[2]==='enable';if(!this._shouldToggleDomain(domainCommand[1],enable)){return Promise.resolve();}}
return this._connection.sendCommand(method,params,cmdOpts);}
isDomainEnabled(domain){return!!this._domainEnabledCounts.get(domain);}
evaluteScriptOnNewDocument(scriptSource){return this.sendCommand('Page.addScriptToEvaluateOnLoad',{scriptSource});}
evaluateAsync(expression){return new Promise((resolve,reject)=>{const asyncTimeout=setTimeout(_=>reject(new Error('The asynchronous expression exceeded the allotted time of 60s')),60000);this.sendCommand('Runtime.evaluate',{expression:`(function wrapInNativePromise() {
          const __nativePromise = window.__nativePromise || Promise;
          return new __nativePromise(function (resolve) {
            return __nativePromise.resolve()
              .then(_ => ${expression})
              .catch(${wrapRuntimeEvalErrorInBrowser.toString()})
              .then(resolve);
          });
        }())`,includeCommandLineAPI:true,awaitPromise:true,returnByValue:true}).then(result=>{clearTimeout(asyncTimeout);const value=result.result.value;if(result.exceptionDetails){reject(new Error('an unexpected driver error occurred'));}if(value&&value.__failedInBrowser){reject(Object.assign(new Error(),value));}else{resolve(value);}}).catch(err=>{clearTimeout(asyncTimeout);reject(err);});});}
getAppManifest(){return this.sendCommand('Page.getAppManifest').then(response=>{if(!response.data){return null;}
return response;});}
getSecurityState(){return new Promise((resolve,reject)=>{this.once('Security.securityStateChanged',data=>{this.sendCommand('Security.disable').then(_=>resolve(data),reject);});this.sendCommand('Security.enable').catch(reject);});}
getServiceWorkerVersions(){return new Promise((resolve,reject)=>{const versionUpdatedListener=data=>{const activateCandidates=data.versions.filter(sw=>{return sw.status!=='redundant';});const hasActiveServiceWorker=activateCandidates.find(sw=>{return sw.status==='activated';});if(!activateCandidates.length||hasActiveServiceWorker){this.off('ServiceWorker.workerVersionUpdated',versionUpdatedListener);this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);}};this.on('ServiceWorker.workerVersionUpdated',versionUpdatedListener);this.sendCommand('ServiceWorker.enable').catch(reject);});}
getServiceWorkerRegistrations(){return new Promise((resolve,reject)=>{this.once('ServiceWorker.workerRegistrationUpdated',data=>{this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);});this.sendCommand('ServiceWorker.enable').catch(reject);});}
assertNoSameOriginServiceWorkerClients(pageUrl){let registrations;let versions;return this.getServiceWorkerRegistrations().then(data=>{registrations=data.registrations;}).then(_=>this.getServiceWorkerVersions()).then(data=>{versions=data.versions;}).then(_=>{const origin=new URL(pageUrl).origin;registrations.filter(reg=>{const swOrigin=new URL(reg.scopeURL).origin;return origin===swOrigin;}).forEach(reg=>{versions.forEach(ver=>{if(ver.registrationId!==reg.registrationId){return;}
if(ver.controlledClients&&ver.controlledClients.length>0){throw new Error('You probably have multiple tabs open to the same origin.');}});});});}
_waitForNetworkIdle(networkQuietThresholdMs,pauseAfterNetworkQuietMs){let idleTimeout;let cancel;const promise=new Promise((resolve,reject)=>{const onIdle=()=>{this._networkStatusMonitor.once('network-2-busy',onBusy);idleTimeout=setTimeout(_=>{cancel();resolve();},networkQuietThresholdMs);};const onBusy=()=>{this._networkStatusMonitor.once('network-2-idle',onIdle);clearTimeout(idleTimeout);};const domContentLoadedListener=()=>{if(this._networkStatusMonitor.is2Idle()){onIdle();}else{onBusy();}};this.once('Page.domContentEventFired',domContentLoadedListener);cancel=()=>{clearTimeout(idleTimeout);this.off('Page.domContentEventFired',domContentLoadedListener);this._networkStatusMonitor.removeListener('network-2-busy',onBusy);this._networkStatusMonitor.removeListener('network-2-idle',onIdle);};}).then(()=>{return new Promise(resolve=>setTimeout(resolve,pauseAfterNetworkQuietMs));});return{promise,cancel};}
_waitForCPUIdle(waitForCPUQuiet){if(!waitForCPUQuiet){return{markAsResolvable:()=>undefined,promise:Promise.resolve(),cancel:()=>undefined};}
let lastTimeout;let cancelled=false;let isResolvable=false;function checkForQuiet(driver,resolve){if(cancelled)return;const tryLater=timeToWait=>{lastTimeout=setTimeout(()=>checkForQuiet(driver,resolve),timeToWait);};if(!isResolvable){return tryLater(1000);}
return driver.evaluateAsync(`(${checkTimeSinceLastLongTask.toString()})()`).then(timeSinceLongTask=>{if(cancelled)return;if(typeof timeSinceLongTask==='number'&&timeSinceLongTask>=waitForCPUQuiet){log.verbose('Driver',`CPU has been idle for ${timeSinceLongTask} ms`);resolve();}else{log.verbose('Driver',`CPU has been idle for ${timeSinceLongTask} ms`);tryLater(waitForCPUQuiet-timeSinceLongTask);}});}
let cancel;const promise=new Promise((resolve,reject)=>{checkForQuiet(this,resolve);cancel=()=>{cancelled=true;if(lastTimeout)clearTimeout(lastTimeout);reject(new Error('Wait for CPU idle cancelled'));};});return{markAsResolvable:()=>{isResolvable=true;},promise,cancel};}
_waitForLoadEvent(pauseAfterLoadMs){let loadListener;let loadTimeout;const promise=new Promise((resolve,reject)=>{loadListener=function(){loadTimeout=setTimeout(resolve,pauseAfterLoadMs);};this.once('Page.loadEventFired',loadListener);});const cancel=()=>{this.off('Page.loadEventFired',loadListener);clearTimeout(loadTimeout);};return{promise,cancel};}
_waitForFullyLoaded(pauseAfterLoadMs,networkQuietThresholdMs,cpuQuietThresholdMs,maxWaitForLoadedMs){let maxTimeoutHandle;const waitForLoadEvent=this._waitForLoadEvent(pauseAfterLoadMs);const waitForNetworkIdle=this._waitForNetworkIdle(networkQuietThresholdMs);const waitForCPUIdle=this._waitForCPUIdle(cpuQuietThresholdMs);const loadPromise=Promise.all([waitForLoadEvent.promise,waitForNetworkIdle.promise.then(waitForCPUIdle.markAsResolvable),waitForCPUIdle.promise]).then(()=>{return function(){log.verbose('Driver','loadEventFired and network considered idle');clearTimeout(maxTimeoutHandle);};});const maxTimeoutPromise=new Promise((resolve,reject)=>{maxTimeoutHandle=setTimeout(resolve,maxWaitForLoadedMs);}).then(_=>{return function(){log.warn('Driver','Timed out waiting for page load. Moving on...');waitForLoadEvent.cancel();waitForNetworkIdle.cancel();waitForCPUIdle.cancel();};});return Promise.race([loadPromise,maxTimeoutPromise]).then(cleanup=>cleanup());}
_beginNetworkStatusMonitoring(startingUrl){this._networkStatusMonitor=new NetworkRecorder([]);this._monitoredUrl=startingUrl;this._networkStatusMonitor.on('requestloaded',redirectRequest=>{if(!redirectRequest.redirectSource){return;}
const earlierRequest=redirectRequest.redirectSource;if(earlierRequest.url===this._monitoredUrl){this._monitoredUrl=redirectRequest.url;}});return this.sendCommand('Network.enable');}
_endNetworkStatusMonitoring(){this._networkStatusMonitor=null;const finalUrl=this._monitoredUrl;this._monitoredUrl=null;return finalUrl;}
gotoURL(url,options={}){const waitForLoad=options.waitForLoad||false;const disableJS=options.disableJavaScript||false;let pauseAfterLoadMs=options.config&&options.config.pauseAfterLoadMs;let networkQuietThresholdMs=options.config&&options.config.networkQuietThresholdMs;let cpuQuietThresholdMs=options.config&&options.config.cpuQuietThresholdMs;let maxWaitMs=options.flags&&options.flags.maxWaitForLoad;if(typeof pauseAfterLoadMs!=='number')pauseAfterLoadMs=DEFAULT_PAUSE_AFTER_LOAD;if(typeof networkQuietThresholdMs!=='number')networkQuietThresholdMs=DEFAULT_NETWORK_QUIET_THRESHOLD;if(typeof cpuQuietThresholdMs!=='number')cpuQuietThresholdMs=DEFAULT_CPU_QUIET_THRESHOLD;if(typeof maxWaitMs!=='number')maxWaitMs=Driver.MAX_WAIT_FOR_FULLY_LOADED;return this._beginNetworkStatusMonitoring(url).then(_=>{this.sendCommand('Page.enable');this.sendCommand('Emulation.setScriptExecutionDisabled',{value:disableJS});this.sendCommand('Page.navigate',{url});}).then(_=>waitForLoad&&this._waitForFullyLoaded(pauseAfterLoadMs,networkQuietThresholdMs,cpuQuietThresholdMs,maxWaitMs)).then(_=>this._endNetworkStatusMonitoring());}
getObjectProperty(objectId,propName){return new Promise((resolve,reject)=>{this.sendCommand('Runtime.getProperties',{objectId,accessorPropertiesOnly:true,generatePreview:false,ownProperties:false}).then(properties=>{const propertyForName=properties.result.find(property=>property.name===propName);if(propertyForName&&propertyForName.value){resolve(propertyForName.value.value);}else{resolve(null);}}).catch(reject);});}
getRequestContent(requestId){return this.sendCommand('Network.getResponseBody',{requestId}).then(result=>result.body);}
queryPermissionState(name){const expressionToEval=`
      navigator.permissions.query({name: '${name}'}).then(result => {
        return result.state;
      })
    `;return this.evaluateAsync(expressionToEval);}
querySelector(selector){return this.sendCommand('DOM.getDocument').then(result=>result.root.nodeId).then(nodeId=>this.sendCommand('DOM.querySelector',{nodeId,selector})).then(element=>{if(element.nodeId===0){return null;}
return new Element(element,this);});}
querySelectorAll(selector){return this.sendCommand('DOM.getDocument').then(result=>result.root.nodeId).then(nodeId=>this.sendCommand('DOM.querySelectorAll',{nodeId,selector})).then(nodeList=>{const elementList=[];nodeList.nodeIds.forEach(nodeId=>{if(nodeId!==0){elementList.push(new Element({nodeId},this));}});return elementList;});}
getElementsInDocument(pierce=true){return this.sendCommand('DOM.getFlattenedDocument',{depth:-1,pierce}).then(result=>{const elements=result.nodes.filter(node=>node.nodeType===1);return elements.map(node=>new Element({nodeId:node.nodeId},this));});}
beginTrace(flags){const additionalCategories=flags&&flags.additionalTraceCategories&&flags.additionalTraceCategories.split(',')||[];const traceCategories=this._traceCategories.concat(additionalCategories);const tracingOpts={categories:_uniq(traceCategories).join(','),transferMode:'ReturnAsStream',options:'sampling-frequency=10000'};if(this.isDomainEnabled('Debugger')){throw new Error('Debugger domain enabled when starting trace');}
if(this.isDomainEnabled('CSS')){throw new Error('CSS domain enabled when starting trace');}
if(this.isDomainEnabled('DOM')){throw new Error('DOM domain enabled when starting trace');}
return this.sendCommand('Page.enable').then(_=>this.endTraceIfStarted()).then(_=>this.sendCommand('Tracing.start',tracingOpts));}
endTraceIfStarted(){return new Promise(resolve=>{const traceCallback=()=>resolve();this.once('Tracing.tracingComplete',traceCallback);return this.sendCommand('Tracing.end',undefined,{silent:true}).catch(()=>{this.off('Tracing.tracingComplete',traceCallback);traceCallback();});});}
endTrace(){return new Promise((resolve,reject)=>{this.once('Tracing.tracingComplete',streamHandle=>{this._readTraceFromStream(streamHandle).then(traceContents=>resolve(traceContents),reject);});return this.sendCommand('Tracing.end').catch(reject);});}
_readTraceFromStream(streamHandle){return new Promise((resolve,reject)=>{let isEOF=false;const parser=new TraceParser();const readArguments={handle:streamHandle.stream};const onChunkRead=response=>{if(isEOF){return;}
parser.parseChunk(response.data);if(response.eof){isEOF=true;return resolve(parser.getTrace());}
return this.sendCommand('IO.read',readArguments).then(onChunkRead);};this.sendCommand('IO.read',readArguments).then(onChunkRead).catch(reject);});}
beginDevtoolsLog(){this._devtoolsLog.reset();this._devtoolsLog.beginRecording();}
endDevtoolsLog(){this._devtoolsLog.endRecording();return this._devtoolsLog.messages;}
enableRuntimeEvents(){return this.sendCommand('Runtime.enable');}
beginEmulation(flags){return Promise.resolve().then(_=>{if(!flags.disableDeviceEmulation)return emulation.enableNexus5X(this);}).then(_=>this.setThrottling(flags,{useThrottling:true}));}
setThrottling(flags,passConfig){const throttleCpu=passConfig.useThrottling&&!flags.disableCpuThrottling;const throttleNetwork=passConfig.useThrottling&&!flags.disableNetworkThrottling;const cpuPromise=throttleCpu?emulation.enableCPUThrottling(this):emulation.disableCPUThrottling(this);const networkPromise=throttleNetwork?emulation.enableNetworkThrottling(this):emulation.disableNetworkThrottling(this);return Promise.all([cpuPromise,networkPromise]);}
goOffline(){return this.sendCommand('Network.enable').then(_=>emulation.goOffline(this)).then(_=>this.online=false);}
goOnline(options){return this.setThrottling(options.flags,options.config).then(_=>this.online=true);}
cleanBrowserCaches(){return this.sendCommand('Network.clearBrowserCache').then(_=>this.sendCommand('Network.setCacheDisabled',{cacheDisabled:true})).then(_=>this.sendCommand('Network.setCacheDisabled',{cacheDisabled:false}));}
clearDataForOrigin(url){const origin=new URL(url).origin;const typesToClear=['appcache','file_systems','indexeddb','local_storage','shader_cache','websql','service_workers','cache_storage'].join(',');return this.sendCommand('Storage.clearDataForOrigin',{origin:origin,storageTypes:typesToClear});}
cacheNatives(){return this.evaluteScriptOnNewDocument(`window.__nativePromise = Promise;
        window.__nativeError = Error;`);}
registerPerformanceObserver(){return this.evaluteScriptOnNewDocument(`(${registerPerformanceObserverInPage.toString()})()`);}
captureFunctionCallSites(funcName){const globalVarToPopulate=`window['__${funcName}StackTraces']`;const collectUsage=()=>{return this.evaluateAsync(`Promise.resolve(Array.from(${globalVarToPopulate}).map(item => JSON.parse(item)))`).then(result=>{if(!Array.isArray(result)){throw new Error('Driver failure: Expected evaluateAsync results to be an array '+`but got "${JSON.stringify(result)}" instead.`);}
return result.filter(item=>!item.isExtension);});};const funcBody=captureJSCallUsage.toString();this.evaluteScriptOnNewDocument(`
        ${globalVarToPopulate} = new Set();
        (${funcName} = ${funcBody}(${funcName}, ${globalVarToPopulate}))`);return collectUsage;}
blockUrlPatterns(urls){return this.sendCommand('Network.setBlockedURLs',{urls}).catch(err=>{if(!/wasn't found/.test(err.message)){throw err;}});}
dismissJavaScriptDialogs(){return this.sendCommand('Page.enable').then(_=>{this.on('Page.javascriptDialogOpening',data=>{log.warn('Driver',`${data.type} dialog opened by the page automatically suppressed.`);this.sendCommand('Page.handleJavaScriptDialog',{accept:true,promptText:'Lighthouse prompt response'});});});}}
function captureJSCallUsage(funcRef,set){const __nativeError=window.__nativeError||Error;const originalFunc=funcRef;const originalPrepareStackTrace=__nativeError.prepareStackTrace;return function(...args){__nativeError.prepareStackTrace=function(error,structStackTrace){const callFrame=structStackTrace[1];let url=callFrame.getFileName()||callFrame.getEvalOrigin();const line=callFrame.getLineNumber();const col=callFrame.getColumnNumber();const isEval=callFrame.isEval();let isExtension=false;const stackTrace=structStackTrace.slice(1).map(callsite=>callsite.toString());if(isEval){url=stackTrace[1];}
if(stackTrace[0].startsWith('<anonymous>')){url=stackTrace[0];isExtension=true;}
return{url,args,line,col,isEval,isExtension};};const e=new __nativeError(`__called ${funcRef.name}__`);set.add(JSON.stringify(e.stack));__nativeError.prepareStackTrace=originalPrepareStackTrace;return originalFunc.apply(this,args);};}
function wrapRuntimeEvalErrorInBrowser(err){err=err||new Error();const fallbackMessage=typeof err==='string'?err:'unknown error';return{__failedInBrowser:true,name:err.name||'Error',message:err.message||fallbackMessage,stack:err.stack||new Error().stack};}
function registerPerformanceObserverInPage(){window.____lastLongTask=window.performance.now();const observer=new window.PerformanceObserver(entryList=>{const entries=entryList.getEntries();for(const entry of entries){if(entry.entryType==='longtask'){const taskEnd=entry.startTime+entry.duration;window.____lastLongTask=Math.max(window.____lastLongTask,taskEnd);}}});observer.observe({entryTypes:['longtask']});window.____lhPerformanceObserver=observer;}
function checkTimeSinceLastLongTask(){return new Promise(resolve=>{const timeoutRequested=window.performance.now()+50;setTimeout(()=>{const timeoutFired=window.performance.now();const timeSinceLongTask=timeoutFired-timeoutRequested<50?timeoutFired-window.____lastLongTask:0;resolve(timeSinceLongTask);},50);});}
module.exports=Driver;},{"../lib/element":19,"../lib/emulation":20,"../lib/network-recorder":24,"../lib/traces/trace-parser":28,"../lib/url-shim":30,"./devtools-log":13,"events":45,"lighthouse-logger":109}],15:[function(require,module,exports){'use strict';const log=require('lighthouse-logger');const Audit=require('../audits/audit');const URL=require('../lib/url-shim');const NetworkRecorder=require('../lib/network-recorder.js');let GathererResults;class GatherRunner{static loadBlank(driver,url='about:blank',duration=300){return driver.gotoURL(url).then(_=>new Promise(resolve=>setTimeout(resolve,duration)));}
static loadPage(driver,options){return driver.gotoURL(options.url,{waitForLoad:true,disableJavaScript:!!options.disableJavaScript,flags:options.flags,config:options.config}).then(finalUrl=>{options.url=finalUrl;});}
static setupDriver(driver,gathererResults,options){log.log('status','Initializing…');const resetStorage=!options.flags.disableStorageReset;return driver.assertNoSameOriginServiceWorkerClients(options.url).then(_=>gathererResults.UserAgent=[driver.getUserAgent()]).then(_=>driver.beginEmulation(options.flags)).then(_=>driver.enableRuntimeEvents()).then(_=>driver.cacheNatives()).then(_=>driver.registerPerformanceObserver()).then(_=>driver.dismissJavaScriptDialogs()).then(_=>resetStorage&&driver.clearDataForOrigin(options.url));}
static disposeDriver(driver){log.log('status','Disconnecting from browser...');return driver.disconnect().catch(err=>{if(!/close\/.*status: 500$/.test(err.message)){log.error('GatherRunner disconnect',err.message);}});}
static recoverOrThrow(promise){return promise.catch(err=>{if(err.fatal){throw err;}});}
static assertPageLoaded(url,driver,networkRecords){const mainRecord=networkRecords.find(record=>{return URL.equalWithExcludedFragments(record.url,url);});if(driver.online&&(!mainRecord||mainRecord.failed)){const message=mainRecord?mainRecord.localizedFailDescription:'timeout reached';log.error('GatherRunner',message);const error=new Error(`Unable to load the page: ${message}`);error.code='PAGE_LOAD_ERROR';throw error;}}
static beforePass(options,gathererResults){const blockedUrls=(options.config.blockedUrlPatterns||[]).concat(options.flags.blockedUrlPatterns||[]);const blankPage=options.config.blankPage;const blankDuration=options.config.blankDuration;const pass=GatherRunner.loadBlank(options.driver,blankPage,blankDuration).then(()=>options.driver.blockUrlPatterns(blockedUrls));return options.config.gatherers.reduce((chain,gatherer)=>{return chain.then(_=>{const artifactPromise=Promise.resolve().then(_=>gatherer.beforePass(options));gathererResults[gatherer.name]=[artifactPromise];return GatherRunner.recoverOrThrow(artifactPromise);});},pass);}
static pass(options,gathererResults){const driver=options.driver;const config=options.config;const gatherers=config.gatherers;const recordTrace=config.recordTrace;const isPerfRun=!options.flags.disableStorageReset&&recordTrace&&config.useThrottling;const gatherernames=gatherers.map(g=>g.name).join(', ');const status='Loading page & waiting for onload';log.log('status',status,gatherernames);const pass=Promise.resolve().then(_=>isPerfRun&&driver.cleanBrowserCaches()).then(_=>driver.beginDevtoolsLog()).then(_=>recordTrace&&driver.beginTrace(options.flags)).then(_=>GatherRunner.loadPage(driver,options)).then(_=>log.log('statusEnd',status));return gatherers.reduce((chain,gatherer)=>{return chain.then(_=>{const artifactPromise=Promise.resolve().then(_=>gatherer.pass(options));gathererResults[gatherer.name].push(artifactPromise);return GatherRunner.recoverOrThrow(artifactPromise);});},pass);}
static afterPass(options,gathererResults){const driver=options.driver;const config=options.config;const gatherers=config.gatherers;const passData={};let pass=Promise.resolve();if(config.recordTrace){pass=pass.then(_=>{log.log('status','Retrieving trace');return driver.endTrace();}).then(traceContents=>{passData.trace=Array.isArray(traceContents)?{traceEvents:traceContents}:traceContents;log.verbose('statusEnd','Retrieving trace');});}
pass=pass.then(_=>{const status='Retrieving devtoolsLog and network records';log.log('status',status);const devtoolsLog=driver.endDevtoolsLog();const networkRecords=NetworkRecorder.recordsFromLogs(devtoolsLog);GatherRunner.assertPageLoaded(options.url,driver,networkRecords);log.verbose('statusEnd',status);passData.devtoolsLog=devtoolsLog;passData.networkRecords=networkRecords;});pass=pass.then(_=>driver.setThrottling(options.flags,{useThrottling:false}));pass=gatherers.reduce((chain,gatherer)=>{const status=`Retrieving: ${gatherer.name}`;return chain.then(_=>{log.log('status',status);const artifactPromise=Promise.resolve().then(_=>gatherer.afterPass(options,passData));gathererResults[gatherer.name].push(artifactPromise);return GatherRunner.recoverOrThrow(artifactPromise);}).then(_=>{log.verbose('statusEnd',status);});},pass);return pass.then(_=>passData);}
static collectArtifacts(gathererResults){const artifacts={};return Object.keys(gathererResults).reduce((chain,gathererName)=>{return chain.then(_=>{const phaseResultsPromises=gathererResults[gathererName];return Promise.all(phaseResultsPromises).then(phaseResults=>{const definedResults=phaseResults.filter(element=>element!==undefined);const artifact=definedResults[definedResults.length-1];if(artifact===undefined){throw new Error(`${gathererName} failed to provide an artifact.`);}
artifacts[gathererName]=artifact;},err=>{artifacts[gathererName]=err;});});},Promise.resolve()).then(_=>{return artifacts;});}
static run(passes,options){const driver=options.driver;const tracingData={traces:{},devtoolsLogs:{},networkRecords:{}};if(typeof options.url!=='string'||options.url.length===0){return Promise.reject(new Error('You must provide a url to the gather-runner'));}
if(typeof options.flags==='undefined'){options.flags={};}
if(typeof options.config==='undefined'){return Promise.reject(new Error('You must provide a config'));}
if(typeof options.flags.disableCpuThrottling==='undefined'){options.flags.disableCpuThrottling=false;}
passes=this.instantiateGatherers(passes,options.config.configDir);const gathererResults={};return driver.connect().then(_=>GatherRunner.loadBlank(driver)).then(_=>GatherRunner.setupDriver(driver,gathererResults,options)).then(_=>{let urlAfterRedirects;return passes.reduce((chain,config,passIndex)=>{const runOptions=Object.assign({},options,{config});return chain.then(_=>driver.setThrottling(options.flags,config)).then(_=>GatherRunner.beforePass(runOptions,gathererResults)).then(_=>GatherRunner.pass(runOptions,gathererResults)).then(_=>GatherRunner.afterPass(runOptions,gathererResults)).then(passData=>{const passName=config.passName||Audit.DEFAULT_PASS;tracingData.devtoolsLogs[passName]=passData.devtoolsLog;if(config.recordTrace){tracingData.traces[passName]=passData.trace;}
if(passIndex===0){urlAfterRedirects=runOptions.url;}});},Promise.resolve()).then(_=>{options.url=urlAfterRedirects;});}).then(_=>GatherRunner.disposeDriver(driver)).then(_=>GatherRunner.collectArtifacts(gathererResults)).then(artifacts=>{return Object.assign(artifacts,tracingData);}).catch(err=>{GatherRunner.disposeDriver(driver);throw err;});}
static getGathererClass(nameOrGathererClass,configPath){const Runner=require('../runner');const coreList=Runner.getGathererList();let GathererClass;if(typeof nameOrGathererClass==='string'){const name=nameOrGathererClass;const coreGatherer=coreList.find(a=>a===`${name}.js`);let requirePath=`./gatherers/${name}`;if(!coreGatherer){requirePath=Runner.resolvePlugin(name,configPath,'gatherer');}
GathererClass=require(requirePath);this.assertValidGatherer(GathererClass,name);}else{GathererClass=nameOrGathererClass;this.assertValidGatherer(GathererClass);}
return GathererClass;}
static assertValidGatherer(GathererDefinition,gathererName){const gathererInstance=new GathererDefinition();gathererName=gathererName||gathererInstance.name||'gatherer';if(typeof gathererInstance.beforePass!=='function'){throw new Error(`${gathererName} has no beforePass() method.`);}
if(typeof gathererInstance.pass!=='function'){throw new Error(`${gathererName} has no pass() method.`);}
if(typeof gathererInstance.afterPass!=='function'){throw new Error(`${gathererName} has no afterPass() method.`);}}
static instantiateGatherers(passes,rootPath){return passes.map(pass=>{pass.gatherers=pass.gatherers.map(gatherer=>{if(typeof gatherer!=='string'){return gatherer;}
const GathererClass=GatherRunner.getGathererClass(gatherer,rootPath);return new GathererClass();});return pass;});}}
module.exports=GatherRunner;},{"../audits/audit":2,"../lib/network-recorder.js":24,"../lib/url-shim":30,"../runner":34,"lighthouse-logger":109}],16:[function(require,module,exports){'use strict';class Gatherer{get name(){return this.constructor.name;}
beforePass(options){}
pass(options){}
afterPass(options,loadData){}}
module.exports=Gatherer;},{}],17:[function(require,module,exports){'use strict';const log=require('lighthouse-logger');class ConsoleQuieter{static mute(opts){ConsoleQuieter._logs=ConsoleQuieter._logs||[];console.log=function(...args){ConsoleQuieter._logs.push({type:'log',args,prefix:opts.prefix});};console.warn=function(...args){ConsoleQuieter._logs.push({type:'warn',args,prefix:opts.prefix});};console.error=function(...args){ConsoleQuieter._logs.push({type:'error',args,prefix:opts.prefix});};}
static unmuteAndFlush(){console.log=ConsoleQuieter._consolelog;console.warn=ConsoleQuieter._consolewarn;console.error=ConsoleQuieter._consoleerror;ConsoleQuieter._logs.forEach(entry=>{log.verbose(`${entry.prefix}-${entry.type}`,...entry.args);});ConsoleQuieter._logs=[];}}
ConsoleQuieter._consolelog=console.log.bind(console);ConsoleQuieter._consolewarn=console.warn.bind(console);ConsoleQuieter._consoleerror=console.error.bind(console);module.exports=ConsoleQuieter;},{"lighthouse-logger":109}],18:[function(require,module,exports){'use strict';function getElementsInDocument(selector){const results=[];const _findAllElements=nodes=>{for(let i=0,el;el=nodes[i];++i){if(!selector||el.matches(selector)){results.push(el);}
if(el.shadowRoot){_findAllElements(el.shadowRoot.querySelectorAll('*'));}}};_findAllElements(document.querySelectorAll('*'));return results;}
module.exports={getElementsInDocumentFnString:getElementsInDocument.toString()};},{}],19:[function(require,module,exports){'use strict';class Element{constructor(element,driver){if(!element||!driver){throw Error('Driver and element required to create Element');}
this.driver=driver;this.element=element;}
getAttribute(name){return this.driver.sendCommand('DOM.getAttributes',{nodeId:this.element.nodeId}).then(resp=>{const attrIndex=resp.attributes.indexOf(name);if(attrIndex===-1){return null;}
return resp.attributes[attrIndex+1];});}
getProperty(propName){return this.driver.sendCommand('DOM.resolveNode',{nodeId:this.element.nodeId}).then(resp=>{return this.driver.getObjectProperty(resp.object.objectId,propName);});}}
module.exports=Element;},{}],20:[function(require,module,exports){'use strict';const NEXUS5X_EMULATION_METRICS={mobile:true,screenWidth:412,screenHeight:732,width:412,height:732,positionX:0,positionY:0,scale:1,deviceScaleFactor:2.625,fitWindow:false,screenOrientation:{angle:0,type:'portraitPrimary'}};const NEXUS5X_USERAGENT={userAgent:'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5 Build/MRA58N) AppleWebKit/537.36'+'(KHTML, like Gecko) Chrome/61.0.3116.0 Mobile Safari/537.36'};const LATENCY_FACTOR=3.75;const THROUGHPUT_FACTOR=0.9;const TARGET_LATENCY=150;const TARGET_DOWNLOAD_THROUGHPUT=Math.floor(1.6*1024*1024/8);const TARGET_UPLOAD_THROUGHPUT=Math.floor(750*1024/8);const TYPICAL_MOBILE_THROTTLING_METRICS={targetLatency:TARGET_LATENCY,latency:TARGET_LATENCY*LATENCY_FACTOR,targetDownloadThroughput:TARGET_DOWNLOAD_THROUGHPUT,downloadThroughput:TARGET_DOWNLOAD_THROUGHPUT*THROUGHPUT_FACTOR,targetUploadThroughput:TARGET_UPLOAD_THROUGHPUT,uploadThroughput:TARGET_UPLOAD_THROUGHPUT*THROUGHPUT_FACTOR,offline:false};const OFFLINE_METRICS={offline:true,latency:0,downloadThroughput:0,uploadThroughput:0};const NO_THROTTLING_METRICS={latency:0,downloadThroughput:0,uploadThroughput:0,offline:false};const NO_CPU_THROTTLE_METRICS={rate:1};const CPU_THROTTLE_METRICS={rate:4};function enableNexus5X(driver){const injectedTouchEventsFunction=function(){const touchEvents=['ontouchstart','ontouchend','ontouchmove','ontouchcancel'];const recepients=[window.__proto__,document.__proto__];for(let i=0;i<touchEvents.length;++i){for(let j=0;j<recepients.length;++j){if(!(touchEvents[i]in recepients[j])){Object.defineProperty(recepients[j],touchEvents[i],{value:null,writable:true,configurable:true,enumerable:true});}}}};return Promise.all([driver.sendCommand('Emulation.setDeviceMetricsOverride',NEXUS5X_EMULATION_METRICS),driver.sendCommand('Emulation.setVisibleSize',{width:NEXUS5X_EMULATION_METRICS.screenWidth,height:NEXUS5X_EMULATION_METRICS.screenHeight}),driver.sendCommand('Network.enable'),driver.sendCommand('Network.setUserAgentOverride',NEXUS5X_USERAGENT),driver.sendCommand('Emulation.setTouchEmulationEnabled',{enabled:true,configuration:'mobile'}),driver.sendCommand('Page.addScriptToEvaluateOnLoad',{scriptSource:'('+injectedTouchEventsFunction.toString()+')()'})]);}
function enableNetworkThrottling(driver){return driver.sendCommand('Network.emulateNetworkConditions',TYPICAL_MOBILE_THROTTLING_METRICS);}
function disableNetworkThrottling(driver){return driver.sendCommand('Network.emulateNetworkConditions',NO_THROTTLING_METRICS);}
function goOffline(driver){return driver.sendCommand('Network.emulateNetworkConditions',OFFLINE_METRICS);}
function enableCPUThrottling(driver){return driver.sendCommand('Emulation.setCPUThrottlingRate',CPU_THROTTLE_METRICS);}
function disableCPUThrottling(driver){return driver.sendCommand('Emulation.setCPUThrottlingRate',NO_CPU_THROTTLE_METRICS);}
function getEmulationDesc(){const{latency,downloadThroughput,uploadThroughput}=TYPICAL_MOBILE_THROTTLING_METRICS;const byteToMbit=bytes=>(bytes/1024/1024*8).toFixed(1);return{'deviceEmulation':'Nexus 5X','cpuThrottling':`${CPU_THROTTLE_METRICS.rate}x slowdown`,'networkThrottling':`${latency}ms RTT, ${byteToMbit(downloadThroughput)}Mbps down, `+`${byteToMbit(uploadThroughput)}Mbps up`};}
module.exports={enableNexus5X,enableNetworkThrottling,disableNetworkThrottling,enableCPUThrottling,disableCPUThrottling,goOffline,getEmulationDesc,settings:{NEXUS5X_EMULATION_METRICS,NEXUS5X_USERAGENT,TYPICAL_MOBILE_THROTTLING_METRICS,OFFLINE_METRICS,NO_THROTTLING_METRICS,NO_CPU_THROTTLE_METRICS,CPU_THROTTLE_METRICS}};},{}],21:[function(require,module,exports){'use strict';function addFormattedCodeSnippet(listener){const handler=listener.handler?listener.handler.description:'...';const objectName=listener.objectName.toLowerCase().replace('#document','document');return Object.assign({label:`line: ${listener.line}, col: ${listener.col}`,pre:`${objectName}.addEventListener('${listener.type}', ${handler})`},listener);}
function groupCodeSnippetsByLocation(listeners){const locToListenersMap=new Map();listeners.forEach(loc=>{const key=JSON.stringify({line:loc.line,col:loc.col,url:loc.url,type:loc.type});if(locToListenersMap.has(key)){locToListenersMap.get(key).push(loc);}else{locToListenersMap.set(key,[loc]);}});const results=[];locToListenersMap.forEach((listenersForLocation,key)=>{const lineColUrlObj=JSON.parse(key);const codeSnippets=listenersForLocation.reduce((prev,loc)=>{return prev+loc.pre.trim()+'\n\n';},'');lineColUrlObj.pre=codeSnippets;lineColUrlObj.label=listenersForLocation[0].label;results.push(lineColUrlObj);});return results;}
module.exports={addFormattedCodeSnippet,groupCodeSnippetsByLocation};},{}],22:[function(require,module,exports){'use strict';function doExist(manifest){if(!manifest||!manifest.icons){return false;}
if(manifest.icons.value.length===0){return false;}
return true;}
function sizeAtLeast(sizeRequirement,manifest){const iconValues=manifest.icons.value;const nestedSizes=iconValues.map(icon=>icon.value.sizes.value);const flattenedSizes=[].concat(...nestedSizes);return flattenedSizes.filter(size=>typeof size==='string').filter(size=>/\d+x\d+/.test(size)).filter(size=>{const sizeStrs=size.split(/x/i);const sizeNums=[parseFloat(sizeStrs[0]),parseFloat(sizeStrs[1])];const areIconsBigEnough=sizeNums[0]>=sizeRequirement&&sizeNums[1]>=sizeRequirement;const areIconsSquare=sizeNums[0]===sizeNums[1];return areIconsBigEnough&&areIconsSquare;});}
module.exports={doExist,sizeAtLeast};},{}],23:[function(require,module,exports){'use strict';const URL=require('./url-shim');const validateColor=require('./web-inspector').Color.parse;const ALLOWED_DISPLAY_VALUES=['fullscreen','standalone','minimal-ui','browser'];const DEFAULT_DISPLAY_MODE='browser';const ALLOWED_ORIENTATION_VALUES=['any','natural','landscape','portrait','portrait-primary','portrait-secondary','landscape-primary','landscape-secondary'];function parseString(raw,trim){let value;let debugString;if(typeof raw==='string'){value=trim?raw.trim():raw;}else{if(raw!==undefined){debugString='ERROR: expected a string.';}
value=undefined;}
return{raw,value,debugString};}
function parseColor(raw){const color=parseString(raw);if(color.value===undefined){return color;}
const validatedColor=validateColor(color.raw);if(!validatedColor){color.value=undefined;color.debugString='ERROR: color parsing failed.';}
return color;}
function parseName(jsonInput){return parseString(jsonInput.name,true);}
function parseShortName(jsonInput){return parseString(jsonInput.short_name,true);}
function checkSameOrigin(url1,url2){const parsed1=new URL(url1);const parsed2=new URL(url2);return parsed1.origin===parsed2.origin;}
function parseStartUrl(jsonInput,manifestUrl,documentUrl){const raw=jsonInput.start_url;if(raw===''){return{raw,value:documentUrl,debugString:'ERROR: start_url string empty'};}
const parsedAsString=parseString(raw);if(!parsedAsString.value){parsedAsString.value=documentUrl;return parsedAsString;}
let startUrl;try{startUrl=new URL(raw,manifestUrl).href;}catch(e){return{raw,value:documentUrl,debugString:'ERROR: invalid start_url relative to ${manifestUrl}'};}
if(!checkSameOrigin(startUrl,documentUrl)){return{raw,value:documentUrl,debugString:'ERROR: start_url must be same-origin as document'};}
return{raw,value:startUrl};}
function parseDisplay(jsonInput){const display=parseString(jsonInput.display,true);if(!display.value){display.value=DEFAULT_DISPLAY_MODE;return display;}
display.value=display.value.toLowerCase();if(!ALLOWED_DISPLAY_VALUES.includes(display.value)){display.debugString='ERROR: \'display\' has invalid value '+display.value+` will fall back to ${DEFAULT_DISPLAY_MODE}.`;display.value=DEFAULT_DISPLAY_MODE;}
return display;}
function parseOrientation(jsonInput){const orientation=parseString(jsonInput.orientation,true);if(orientation.value&&!ALLOWED_ORIENTATION_VALUES.includes(orientation.value.toLowerCase())){orientation.value=undefined;orientation.debugString='ERROR: \'orientation\' has an invalid value, will be ignored.';}
return orientation;}
function parseIcon(raw,manifestUrl){const src=parseString(raw.src,true);if(src.value===''){src.value=undefined;}
if(src.value){src.value=new URL(src.value,manifestUrl).href;}
const type=parseString(raw.type,true);const density={raw:raw.density,value:1,debugString:undefined};if(density.raw!==undefined){density.value=parseFloat(density.raw);if(isNaN(density.value)||!isFinite(density.value)||density.value<=0){density.value=1;density.debugString='ERROR: icon density cannot be NaN, +∞, or less than or equal to +0.';}}
const sizes=parseString(raw.sizes);if(sizes.value!==undefined){const set=new Set();sizes.value.trim().split(/\s+/).forEach(size=>set.add(size.toLowerCase()));sizes.value=set.size>0?Array.from(set):undefined;}
return{raw,value:{src,type,density,sizes},debugString:undefined};}
function parseIcons(jsonInput,manifestUrl){const raw=jsonInput.icons;if(raw===undefined){return{raw,value:[],debugString:undefined};}
if(!Array.isArray(raw)){return{raw,value:[],debugString:'ERROR: \'icons\' expected to be an array but is not.'};}
const value=raw.filter(icon=>icon.src!==undefined).map(icon=>parseIcon(icon,manifestUrl)).filter(parsedIcon=>parsedIcon.value.src.value!==undefined);return{raw,value,debugString:undefined};}
function parseApplication(raw){const platform=parseString(raw.platform,true);const id=parseString(raw.id,true);const appUrl=parseString(raw.url,true);if(appUrl.value){try{appUrl.value=new URL(appUrl.value).href;}catch(e){appUrl.value=undefined;appUrl.debugString='ERROR: invalid application URL ${raw.url}';}}
return{raw,value:{platform,id,url:appUrl},debugString:undefined};}
function parseRelatedApplications(jsonInput){const raw=jsonInput.related_applications;if(raw===undefined){return{raw,value:undefined,debugString:undefined};}
if(!Array.isArray(raw)){return{raw,value:undefined,debugString:'ERROR: \'related_applications\' expected to be an array but is not.'};}
const value=raw.filter(application=>!!application.platform).map(parseApplication).filter(parsedApp=>!!parsedApp.value.id.value||!!parsedApp.value.url.value);return{raw,value,debugString:undefined};}
function parsePreferRelatedApplications(jsonInput){const raw=jsonInput.prefer_related_applications;let value;let debugString;if(typeof raw==='boolean'){value=raw;}else{if(raw!==undefined){debugString='ERROR: \'prefer_related_applications\' expected to be a boolean.';}
value=undefined;}
return{raw,value,debugString};}
function parseThemeColor(jsonInput){return parseColor(jsonInput.theme_color);}
function parseBackgroundColor(jsonInput){return parseColor(jsonInput.background_color);}
function parse(string,manifestUrl,documentUrl){if(manifestUrl===undefined||documentUrl===undefined){throw new Error('Manifest and document URLs required for manifest parsing.');}
let jsonInput;try{jsonInput=JSON.parse(string);}catch(e){return{raw:string,value:undefined,debugString:'ERROR: file isn\'t valid JSON: '+e};}
const manifest={name:parseName(jsonInput),short_name:parseShortName(jsonInput),start_url:parseStartUrl(jsonInput,manifestUrl,documentUrl),display:parseDisplay(jsonInput),orientation:parseOrientation(jsonInput),icons:parseIcons(jsonInput,manifestUrl),related_applications:parseRelatedApplications(jsonInput),prefer_related_applications:parsePreferRelatedApplications(jsonInput),theme_color:parseThemeColor(jsonInput),background_color:parseBackgroundColor(jsonInput)};return{raw:string,value:manifest,debugString:undefined};}
module.exports=parse;},{"./url-shim":30,"./web-inspector":31}],24:[function(require,module,exports){'use strict';const NetworkManager=require('./web-inspector').NetworkManager;const EventEmitter=require('events').EventEmitter;const log=require('lighthouse-logger');class NetworkRecorder extends EventEmitter{constructor(recordArray){super();this._records=recordArray;this.networkManager=NetworkManager.createWithFakeTarget();this.startedRequestCount=0;this.finishedRequestCount=0;this.networkManager.addEventListener(this.EventTypes.RequestStarted,this.onRequestStarted.bind(this));this.networkManager.addEventListener(this.EventTypes.RequestFinished,this.onRequestFinished.bind(this));}
get EventTypes(){return NetworkManager.Events;}
activeRequestCount(){return this.startedRequestCount-this.finishedRequestCount;}
isIdle(){return this.activeRequestCount()===0;}
is2Idle(){return this.activeRequestCount()<=2;}
onRequestStarted(request){this.startedRequestCount++;this._records.push(request.data);const activeCount=this.activeRequestCount();log.verbose('NetworkRecorder',`Request started. ${activeCount} requests in progress`+` (${this.startedRequestCount} started and ${this.finishedRequestCount} finished).`);if(activeCount===1){this.emit('networkbusy');}
if(activeCount===3){this.emit('network-2-busy');}}
onRequestFinished(request){this.finishedRequestCount++;this.emit('requestloaded',request.data);const activeCount=this.activeRequestCount();log.verbose('NetworkRecorder',`Request finished. ${activeCount} requests in progress`+` (${this.startedRequestCount} started and ${this.finishedRequestCount} finished).`);if(this.isIdle()){this.emit('networkidle');}
if(this.is2Idle()){this.emit('network-2-idle');}}
onRequestWillBeSent(data){this.networkManager._dispatcher.requestWillBeSent(data.requestId,data.frameId,data.loaderId,data.documentURL,data.request,data.timestamp,data.wallTime,data.initiator,data.redirectResponse,data.type);}
onRequestServedFromCache(data){this.networkManager._dispatcher.requestServedFromCache(data.requestId);}
onResponseReceived(data){this.networkManager._dispatcher.responseReceived(data.requestId,data.frameId,data.loaderId,data.timestamp,data.type,data.response);}
onDataReceived(data){this.networkManager._dispatcher.dataReceived(data.requestId,data.timestamp,data.dataLength,data.encodedDataLength);}
onLoadingFinished(data){this.networkManager._dispatcher.loadingFinished(data.requestId,data.timestamp,data.encodedDataLength);}
onLoadingFailed(data){this.networkManager._dispatcher.loadingFailed(data.requestId,data.timestamp,data.type,data.errorText,data.canceled,data.blockedReason);}
onResourceChangedPriority(data){this.networkManager._dispatcher.resourceChangedPriority(data.requestId,data.newPriority,data.timestamp);}
dispatch(method,params){if(!method.startsWith('Network.')){return;}
switch(method){case'Network.requestWillBeSent':return this.onRequestWillBeSent(params);case'Network.requestServedFromCache':return this.onRequestServedFromCache(params);case'Network.responseReceived':return this.onResponseReceived(params);case'Network.dataReceived':return this.onDataReceived(params);case'Network.loadingFinished':return this.onLoadingFinished(params);case'Network.loadingFailed':return this.onLoadingFailed(params);case'Network.resourceChangedPriority':return this.onResourceChangedPriority(params);default:return;}}
static recordsFromLogs(devtoolsLog){const records=[];const nr=new NetworkRecorder(records);devtoolsLog.forEach(message=>{nr.dispatch(message.method,message.params);});return records;}}
module.exports=NetworkRecorder;},{"./web-inspector":31,"events":45,"lighthouse-logger":109}],25:[function(require,module,exports){'use strict';function erf(x){const sign=Math.sign(x);x=Math.abs(x);const a1=0.254829592;const a2=-0.284496736;const a3=1.421413741;const a4=-1.453152027;const a5=1.061405429;const p=0.3275911;const t=1/(1+p*x);const y=t*(a1+t*(a2+t*(a3+t*(a4+t*a5))));return sign*(1-y*Math.exp(-x*x));}
function getLogNormalDistribution(median,falloff){const location=Math.log(median);const logRatio=Math.log(falloff/median);const shape=Math.sqrt(1-3*logRatio-Math.sqrt((logRatio-3)*(logRatio-3)-8))/2;return{computeComplementaryPercentile(x){const standardizedX=(Math.log(x)-location)/(Math.SQRT2*shape);return(1-erf(standardizedX))/2;}};}
module.exports={getLogNormalDistribution};},{}],26:[function(require,module,exports){'use strict';function filterStylesheetsByUsage(stylesheets,propName,propVal){if(!propName&&!propVal){return[];}
const deepClone=stylesheets.map(sheet=>Object.assign({},sheet));return deepClone.filter(s=>{if(s.isDuplicate){return false;}
s.parsedContent=s.parsedContent.filter(item=>{let usedName='';let usedVal='';if(propName){propName=Array.isArray(propName)?propName:[propName];usedName=propName.includes(item.property.name);}
if(propVal){propVal=Array.isArray(propVal)?propVal:[propVal];usedVal=propVal.includes(item.property.val);}
if(propName&&!propVal){return usedName;}else if(!propName&&propVal){return usedVal;}else if(propName&&propVal){return usedName&&usedVal;}
return false;});return s.parsedContent.length>0;});}
function getFormattedStyleRule(content,parsedContent){const lines=content.split('\n');const declarationRange=parsedContent.declarationRange;const startLine=declarationRange.startLine;const endLine=declarationRange.endLine;const start=declarationRange.startColumn;const end=declarationRange.endColumn;let rule;if(startLine===endLine){rule=lines[startLine].substring(start,end);}else{rule=lines.slice(startLine,endLine+1).reduce((prev,line)=>{prev.push(line);return prev;},[]).join('\n');}
const block=parsedContent.selector+' {\n'+`  ${rule.trim()}\n`+'}';return{styleRule:block.trim(),startLine,location:`${start}:${end}`};}
function addVendorPrefixes(propsNames){const vendorPrefixes=['-o-','-ms-','-moz-','-webkit-'];propsNames=Array.isArray(propsNames)?propsNames:[propsNames];let propsNamesWithPrefixes=propsNames;for(const prefix of vendorPrefixes){const temp=propsNames.map(propName=>`${prefix}${propName}`);propsNamesWithPrefixes=propsNamesWithPrefixes.concat(temp);}
return propsNamesWithPrefixes;}
module.exports={filterStylesheetsByUsage,getFormattedStyleRule,addVendorPrefixes};},{}],27:[function(require,module,exports){'use strict';const WebInspector=require('../web-inspector');const ConsoleQuieter=require('../console-quieter');const TimelineModelTreeView=require('devtools-timeline-model/lib/timeline-model-treeview.js')(WebInspector);class TimelineModel{constructor(events){this.init(events);}
init(events){this._tracingModel=new WebInspector.TracingModel(new WebInspector.TempFileBackingStorage('tracing'));this._timelineModel=new WebInspector.TimelineModel(WebInspector.TimelineUIUtils.visibleEventsFilter());if(typeof events==='string'){events=JSON.parse(events);}
if(events.hasOwnProperty('traceEvents')){events=events.traceEvents;}
this._tracingModel.reset();ConsoleQuieter.mute({prefix:'timelineModel'});this._tracingModel.addEvents(events);this._tracingModel.tracingComplete();this._timelineModel.setEvents(this._tracingModel);ConsoleQuieter.unmuteAndFlush();return this;}
_createAggregator(){return WebInspector.AggregatedTimelineTreeView.prototype._createAggregator();}
timelineModel(){return this._timelineModel;}
tracingModel(){return this._tracingModel;}
topDown(){const filters=[];filters.push(WebInspector.TimelineUIUtils.visibleEventsFilter());filters.push(new WebInspector.ExcludeTopLevelFilter());const nonessentialEvents=[WebInspector.TimelineModel.RecordType.EventDispatch,WebInspector.TimelineModel.RecordType.FunctionCall,WebInspector.TimelineModel.RecordType.TimerFire];filters.push(new WebInspector.ExclusiveNameFilter(nonessentialEvents));const topDown=WebInspector.TimelineProfileTree.buildTopDown(this._timelineModel.mainThreadEvents(),filters,0,Infinity,WebInspector.TimelineAggregator.eventId);return topDown;}
bottomUp(){const topDown=this.topDown();const noGrouping=WebInspector.TimelineAggregator.GroupBy.None;const noGroupAggregator=this._createAggregator().groupFunction(noGrouping);return WebInspector.TimelineProfileTree.buildBottomUp(topDown,noGroupAggregator);}
bottomUpGroupBy(grouping){const topDown=this.topDown();const groupSetting=WebInspector.TimelineAggregator.GroupBy[grouping];const groupingAggregator=this._createAggregator().groupFunction(groupSetting);const bottomUpGrouped=WebInspector.TimelineProfileTree.buildBottomUp(topDown,groupingAggregator);new TimelineModelTreeView(bottomUpGrouped).sortingChanged('self','desc');return bottomUpGrouped;}
frameModel(){const frameModel=new WebInspector.TimelineFrameModel(event=>WebInspector.TimelineUIUtils.eventStyle(event).category.name);frameModel.addTraceEvents({},this._timelineModel.inspectedTargetEvents(),this._timelineModel.sessionId()||'');return frameModel;}
filmStripModel(){return new WebInspector.FilmStripModel(this._tracingModel);}
interactionModel(){const irModel=new WebInspector.TimelineIRModel();irModel.populate(this._timelineModel);return irModel;}}
module.exports=TimelineModel;},{"../console-quieter":17,"../web-inspector":31,"devtools-timeline-model/lib/timeline-model-treeview.js":104}],28:[function(require,module,exports){'use strict';const WebInspector=require('../web-inspector');class TraceParser{constructor(){this.traceEvents=[];this.tracingModel={reset:_=>this._reset(),addEvents:evts=>this._addEvents(evts)};const delegateMock={loadingProgress:_=>{},loadingStarted:_=>{},loadingComplete:success=>{if(!success)throw new Error('Parsing problem');}};this.loader=new WebInspector.TimelineLoader(this.tracingModel,delegateMock);}
_reset(){this.traceEvents=[];}
_addEvents(evts){this.traceEvents.push(...evts);}
parseChunk(data){this.loader.write(data);}
getTrace(){return{traceEvents:this.traceEvents};}}
module.exports=TraceParser;},{"../web-inspector":31}],29:[function(require,module,exports){'use strict';const BASE_RESPONSE_LATENCY=16;const SCHEDULABLE_TASK_TITLE='TaskQueueManager::ProcessTaskFromWorkQueue';class TraceProcessor{static _riskPercentiles(durations,totalTime,percentiles,clippedLength=0){let busyTime=0;for(let i=0;i<durations.length;i++){busyTime+=durations[i];}
busyTime-=clippedLength;let completedTime=totalTime-busyTime;let duration=0;let cdfTime=completedTime;const results=[];let durationIndex=-1;let remainingCount=durations.length+1;if(clippedLength>0){remainingCount--;}
for(const percentile of percentiles){const percentileTime=percentile*totalTime;while(cdfTime<percentileTime&&durationIndex<durations.length-1){completedTime+=duration;remainingCount-=duration<0?-1:1;if(clippedLength>0&&clippedLength<durations[durationIndex+1]){duration=-clippedLength;clippedLength=0;}else{durationIndex++;duration=durations[durationIndex];}
cdfTime=completedTime+Math.abs(duration)*remainingCount;}
results.push({percentile,time:Math.max(0,(percentileTime-completedTime)/remainingCount)+BASE_RESPONSE_LATENCY});}
return results;}
static getRiskToResponsiveness(tabTrace,startTime=0,endTime=tabTrace.timings.traceEnd,percentiles=[0.5,0.75,0.9,0.99,1])
{const totalTime=endTime-startTime;percentiles.sort((a,b)=>a-b);const ret=TraceProcessor.getMainThreadTopLevelEventDurations(tabTrace,startTime,endTime);return TraceProcessor._riskPercentiles(ret.durations,totalTime,percentiles,ret.clippedLength);}
static getMainThreadTopLevelEventDurations(tabTrace,startTime=0,endTime=Infinity){const topLevelEvents=TraceProcessor.getMainThreadTopLevelEvents(tabTrace,startTime,endTime);const durations=[];let clippedLength=0;topLevelEvents.forEach(event=>{let duration=event.duration;let eventStart=event.start;if(eventStart<startTime){eventStart=startTime;duration=event.end-startTime;}
if(event.end>endTime){clippedLength=duration-(endTime-eventStart);}
durations.push(duration);});durations.sort((a,b)=>a-b);return{durations,clippedLength};}
static getMainThreadTopLevelEvents(tabTrace,startTime=0,endTime=Infinity){const topLevelEvents=[];for(const event of tabTrace.mainThreadEvents){if(event.name!==SCHEDULABLE_TASK_TITLE||!event.dur)continue;const start=(event.ts-tabTrace.navigationStartEvt.ts)/1000;const end=(event.ts+event.dur-tabTrace.navigationStartEvt.ts)/1000;if(start>endTime||end<startTime)continue;topLevelEvents.push({start,end,duration:event.dur/1000});}
return topLevelEvents;}}
module.exports=TraceProcessor;},{}],30:[function(require,module,exports){'use strict';const Util=require('../report/v2/renderer/util.js');const URL=typeof self!=='undefined'&&self.URL||require('whatwg-url').URL;URL.INVALID_URL_DEBUG_STRING='Lighthouse was unable to determine the URL of some script executions. '+'It\'s possible a Chrome extension or other eval\'d code is the source.';URL.isValid=function isValid(url){try{new URL(url);return true;}catch(e){return false;}};URL.hostsMatch=function hostsMatch(urlA,urlB){try{return new URL(urlA).host===new URL(urlB).host;}catch(e){return false;}};URL.originsMatch=function originsMatch(urlA,urlB){try{return new URL(urlA).origin===new URL(urlB).origin;}catch(e){return false;}};URL.getOrigin=function getOrigin(url){try{const urlInfo=new URL(url);return urlInfo.host&&urlInfo.origin||null;}catch(e){return null;}};URL.getURLDisplayName=function getURLDisplayName(url,options){return Util.getURLDisplayName(new URL(url),options);};URL.elideDataURI=function elideDataURI(url){try{const parsed=new URL(url);return parsed.protocol==='data:'?url.slice(0,100):url;}catch(e){return url;}};function rewriteChromeInternalUrl(url){if(!url||!url.startsWith('chrome://'))return url;return url.replace(/^chrome:\/\/chrome\//,'chrome://');}
URL.equalWithExcludedFragments=function(url1,url2){[url1,url2]=[url1,url2].map(rewriteChromeInternalUrl);try{url1=new URL(url1);url1.hash='';url2=new URL(url2);url2.hash='';return url1.href===url2.href;}catch(e){return false;}};module.exports=URL;},{"../report/v2/renderer/util.js":32,"whatwg-url":41}],31:[function(require,module,exports){(function(global){'use strict';module.exports=function(){if(global.WebInspector){return global.WebInspector;}
if(global.self!==global){global.self=global;}
if(typeof global.window==='undefined'){global.window=global;}
global.Runtime={};global.Runtime.experiments={isEnabled(experimentName){switch(experimentName){case'timelineLatencyInfo':return true;default:return false;}}};global.Runtime.queryParam=function(arg){switch(arg){case'remoteFrontend':return false;case'ws':return false;default:throw Error('Mock queryParam case not implemented.');}};global.TreeElement={};global.WorkerRuntime={};global.Protocol={Agents(){}};global.WebInspector={};const WebInspector=global.WebInspector;WebInspector._moduleSettings={cacheDisabled:{addChangeListener(){},get(){return false;}},monitoringXHREnabled:{addChangeListener(){},get(){return false;}},showNativeFunctionsInJSProfile:{addChangeListener(){},get(){return true;}}};WebInspector.moduleSetting=function(settingName){return this._moduleSettings[settingName];};global.NetworkAgent={RequestMixedContentType:{Blockable:'blockable',OptionallyBlockable:'optionally-blockable',None:'none'},BlockedReason:{CSP:'csp',MixedContent:'mixed-content',Origin:'origin',Inspector:'inspector',Other:'other'},InitiatorType:{Other:'other',Parser:'parser',Redirect:'redirect',Script:'script'}};global.SecurityAgent={SecurityState:{Unknown:'unknown',Neutral:'neutral',Insecure:'insecure',Warning:'warning',Secure:'secure',Info:'info'}};global.PageAgent={ResourceType:{Document:'document',Stylesheet:'stylesheet',Image:'image',Media:'media',Font:'font',Script:'script',TextTrack:'texttrack',XHR:'xhr',Fetch:'fetch',EventSource:'eventsource',WebSocket:'websocket',Manifest:'manifest',Other:'other'}};require('chrome-devtools-frontend/front_end/common/Object.js');require('chrome-devtools-frontend/front_end/common/ParsedURL.js');require('chrome-devtools-frontend/front_end/common/ResourceType.js');require('chrome-devtools-frontend/front_end/common/UIString.js');require('chrome-devtools-frontend/front_end/platform/utilities.js');require('chrome-devtools-frontend/front_end/sdk/Target.js');require('chrome-devtools-frontend/front_end/sdk/TargetManager.js');require('chrome-devtools-frontend/front_end/sdk/NetworkManager.js');require('chrome-devtools-frontend/front_end/sdk/NetworkRequest.js');WebInspector.targetManager={observeTargets(){},addEventListener(){}};WebInspector.settings={createSetting(){return{get(){return false;},addChangeListener(){}};}};WebInspector.console={error(){}};WebInspector.VBox=function(){};WebInspector.HBox=function(){};WebInspector.ViewportDataGrid=function(){};WebInspector.ViewportDataGridNode=function(){};global.WorkerRuntime.Worker=function(){};require('chrome-devtools-frontend/front_end/common/SegmentedRange.js');require('chrome-devtools-frontend/front_end/bindings/TempFile.js');require('chrome-devtools-frontend/front_end/sdk/TracingModel.js');require('chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js');require('chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js');require('chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js');require('chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js');require('chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js');require('chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js');require('chrome-devtools-frontend/front_end/common/TextUtils.js');require('chrome-devtools-frontend/front_end/timeline/TimelineLoader.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js');require('chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js');WebInspector.DeferredTempFile=function(){};WebInspector.DeferredTempFile.prototype={write:function(){},finishWriting:function(){}};WebInspector.ConsoleMessage=function(){};WebInspector.ConsoleMessage.MessageSource={Network:'network'};WebInspector.ConsoleMessage.MessageLevel={Log:'log'};WebInspector.ConsoleMessage.MessageType={Log:'log'};WebInspector.NetworkLog=function(target){this._requests=new Map();target.networkManager.addEventListener(WebInspector.NetworkManager.Events.RequestStarted,this._onRequestStarted,this);};WebInspector.NetworkLog.prototype={requestForURL:function(url){return this._requests.get(url)||null;},_onRequestStarted:function(event){const request=event.data;if(this._requests.has(request.url)){return;}
this._requests.set(request.url,request);}};require('chrome-devtools-frontend/front_end/common/Color.js');const Dispatcher=WebInspector.NetworkDispatcher;const origUpdateRequest=Dispatcher.prototype._updateNetworkRequestWithRequest;Dispatcher.prototype._updateNetworkRequestWithRequest=function(netRecord,request){origUpdateRequest.apply(this,arguments);netRecord.isLinkPreload=Boolean(request.isLinkPreload);netRecord._isLinkPreload=Boolean(request.isLinkPreload);};WebInspector.NetworkManager.createWithFakeTarget=function(){const fakeNetworkAgent={enable(){},getResponseBody(){throw new Error('Use driver.getRequestContent() for network request content');}};const fakeConsoleModel={addMessage(){},target(){}};const fakeTarget={_modelByConstructor:new Map(),get consoleModel(){return fakeConsoleModel;},networkAgent(){return fakeNetworkAgent;},registerNetworkDispatcher(){},model(){}};fakeTarget.networkManager=new WebInspector.NetworkManager(fakeTarget);fakeTarget.networkLog=new WebInspector.NetworkLog(fakeTarget);WebInspector.NetworkLog.fromTarget=()=>{return fakeTarget.networkLog;};return fakeTarget.networkManager;};require('chrome-devtools-frontend/front_end/common/TextRange.js');const gonzales=require('chrome-devtools-frontend/front_end/gonzales/gonzales-scss.js');require('chrome-devtools-frontend/front_end/gonzales/SCSSParser.js');WebInspector.SCSSParser.prototype.parse=function(content){let ast=null;try{ast=gonzales.parse(content,{syntax:'css'});}catch(e){return{error:e};}
const rootBlock={properties:[],node:ast};const blocks=[rootBlock];ast.selectors=[];WebInspector.SCSSParser.extractNodes(ast,blocks,rootBlock);return ast;};return WebInspector;}();}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"chrome-devtools-frontend/front_end/bindings/TempFile.js":72,"chrome-devtools-frontend/front_end/common/Color.js":73,"chrome-devtools-frontend/front_end/common/Object.js":74,"chrome-devtools-frontend/front_end/common/ParsedURL.js":75,"chrome-devtools-frontend/front_end/common/ResourceType.js":76,"chrome-devtools-frontend/front_end/common/SegmentedRange.js":77,"chrome-devtools-frontend/front_end/common/TextRange.js":78,"chrome-devtools-frontend/front_end/common/TextUtils.js":79,"chrome-devtools-frontend/front_end/common/UIString.js":80,"chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js":81,"chrome-devtools-frontend/front_end/gonzales/SCSSParser.js":82,"chrome-devtools-frontend/front_end/gonzales/gonzales-scss.js":83,"chrome-devtools-frontend/front_end/platform/utilities.js":84,"chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js":85,"chrome-devtools-frontend/front_end/sdk/NetworkManager.js":86,"chrome-devtools-frontend/front_end/sdk/NetworkRequest.js":87,"chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js":88,"chrome-devtools-frontend/front_end/sdk/Target.js":89,"chrome-devtools-frontend/front_end/sdk/TargetManager.js":90,"chrome-devtools-frontend/front_end/sdk/TracingModel.js":91,"chrome-devtools-frontend/front_end/timeline/TimelineLoader.js":92,"chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js":93,"chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js":94,"chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js":95,"chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js":96,"chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js":97,"chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js":98,"chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js":99,"chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js":100,"chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js":101}],32:[function(require,module,exports){'use strict';const ELLIPSIS='\u2026';const NBSP='\xa0';const RATINGS={PASS:{label:'pass',minScore:75},AVERAGE:{label:'average',minScore:45},FAIL:{label:'fail'}};class Util{static calculateRating(score){let rating=RATINGS.FAIL.label;if(score>=RATINGS.PASS.minScore){rating=RATINGS.PASS.label;}else if(score>=RATINGS.AVERAGE.minScore){rating=RATINGS.AVERAGE.label;}
return rating;}
static formatNumber(number,decimalPlaces=1){return number.toLocaleString(undefined,{maximumFractionDigits:decimalPlaces});}
static formatBytesToKB(size,decimalPlaces=2){const kbs=(size/1024).toLocaleString(undefined,{maximumFractionDigits:decimalPlaces});return`${kbs}${NBSP}KB`;}
static formatMilliseconds(ms,granularity=10){const coarseTime=Math.round(ms/granularity)*granularity;return`${coarseTime.toLocaleString()}${NBSP}ms`;}
static formatDateTime(date){const options={month:'short',day:'numeric',year:'numeric',hour:'numeric',minute:'numeric',timeZoneName:'short'};let formatter=new Intl.DateTimeFormat('en-US',options);const tz=formatter.resolvedOptions().timeZone;if(!tz||tz.toLowerCase()==='etc/unknown'){options.timeZone='UTC';formatter=new Intl.DateTimeFormat('en-US',options);}
return formatter.format(new Date(date));}
static getURLDisplayName(parsedUrl,options={}){const numPathParts=options.numPathParts!==undefined?options.numPathParts:2;const preserveQuery=options.preserveQuery!==undefined?options.preserveQuery:true;const preserveHost=options.preserveHost||false;let name;if(parsedUrl.protocol==='about:'||parsedUrl.protocol==='data:'){name=parsedUrl.href;}else{name=parsedUrl.pathname;const parts=name.split('/').filter(part=>part.length);if(numPathParts&&parts.length>numPathParts){name=ELLIPSIS+parts.slice(-1*numPathParts).join('/');}
if(preserveHost){name=`${parsedUrl.host}/${name.replace(/^\//,'')}`;}
if(preserveQuery){name=`${name}${parsedUrl.search}`;}}
const MAX_LENGTH=64;name=name.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${ELLIPSIS}`);if(name.length>MAX_LENGTH&&name.includes('?')){name=name.replace(/\?([^=]*)(=)?.*/,`?$1$2${ELLIPSIS}`);if(name.length>MAX_LENGTH){name=name.replace(/\?.*/,`?${ELLIPSIS}`);}}
if(name.length>MAX_LENGTH){const dotIndex=name.lastIndexOf('.');if(dotIndex>=0){name=name.slice(0,MAX_LENGTH-1-(name.length-dotIndex))+`${ELLIPSIS}${name.slice(dotIndex)}`;}else{name=name.slice(0,MAX_LENGTH-1)+ELLIPSIS;}}
return name;}
static parseURL(url){const parsedUrl=new URL(url);return{file:Util.getURLDisplayName(parsedUrl),hostname:parsedUrl.hostname};}
static chainDuration(startTime,endTime){return Util.formatNumber((endTime-startTime)*1000);}}
if(typeof module!=='undefined'&&module.exports){module.exports=Util;}else{self.Util=Util;}},{}],33:[function(require,module,exports){'use strict';const REPORT_TEMPLATE="<!--\nCopyright 2017 Google Inc. All Rights Reserved.\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\nUnless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n-->\n<!doctype html>\n<html lang=\"en\">\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, minimum-scale=1\">\n  <link rel=\"icon\" href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAADjklEQVR4AWI08P/HQEvAQrxSQKvlECfLFYXx75xCY2qmh89GbNvOMjb3v9jOOlxnFWxj206ebQ3b7q6q+z1rNagu8/zvPSZACAABpeUAA0miMgU7SA7JjCraFGwZwECOwvL75dWjsKgWBKtx0jvWo+vkBAFbACCkByMP6nMn48+AVgXB2fzSCwsv22/lMGlUhmJ0AE7BH8dyUUDbUEgN6RzJRSeaPxhdRYR0Inel+7Hd5lBiFpkMAxACc0394//9C4voFHDiAAGLpuOXebdfdHfctgwJKaZRLRKy6ItrSis6RBnVBgGtbHyKTEmJHQoEXoBCE5BCrDeA2ogMUIGDAKEBDEhUqwgMqBYDjW4DQzmuffVdqff42/ZQYYqVcMXGZsMPyCsH3lyJSetxvEaxAQXdjR1HjfwCdIS7lo2DZke26Qe+MXO12OWkGT0O6oE7vMGkMnkYw4aN1KQgMKExhXqswfiov4+a7MQ11XPnbr/5qpKlgACAAQj94Lu271bN9DUecQasIZlNzG72llRAAKJiAi+/BSHrSFjRvQhg3DEKEqJh08tsmLTx597+f6enr4cc2Zpk57pihfX24dW7RHcOLLUbJYhJSl0ErQCI9BVXH/XrO97QasuvQQSiECa0BrQCIIJp6X9T/r8QG6L71WYSqCoIIGo2BZDUBnS/D9EA9Nun1iYvbM0MFExIDQRoKFatc1Z6zrm5uWeObJotq0BGV9FuQBWq5a4Fw3PPz848rZHstZSuA5FWAFSMP2nOppOOGpl6qh9PCSg0IFyHKjSQyDNQHTru2t75NOEe0fsf246oAmFkI6vCdnWvbQFQFCKx8vCswV8TrDLiDLgH4Nr7RAtNsrC9d8sfk7b8ls4igdNy8CQKAISlsB0FjZfd3Lfp155tf8fKI4BxZZIj/oTdVEAIAcJFOCmzauHG71I7/rdreUAgAqpDP05fDARCAQQARwEIBQSVxq0FyaLvZZtevpHa8WHw8cft6cpxlq8eAJtIhnSbWDf951yx3y13OqUuu5qyGgkxCgGFh9cDihDGbTa6BqvT1lWmrav3bmt2ZMJ4mU6TGgIC4DBzcv/JqAau1WhzSt3x9Ixk/4Jk/8J4ZrrViFMA4W6A7+WK8xcVjvyrOmVD0FbAXokcT48r+xVqLKvuJYbmpNadnlp3mpufJHOe/GXktM+r09bT8kEdq9BRYAbGSgzP7ll82U71Mc+ZFooXgwAAAABJRU5ErkJggg==\">\n  <title>Lighthouse Report</title>\n  <style>/*%%LIGHTHOUSE_CSS%%*/</style>\n</head>\n<body class=\"lh-root lh-vars\">\n  <noscript>Lighthouse report requires JavaScript. Please enable.</noscript>\n  <div hidden>%%LIGHTHOUSE_TEMPLATES%%</div>\n\n  <main><!-- report populated here --></main>\n\n  <div id=\"lh-log\"></div>\n\n  <script>%%LIGHTHOUSE_JAVASCRIPT%%</script>\n  <script>window.__LIGHTHOUSE_JSON__ = %%LIGHTHOUSE_JSON%%;</script>\n  <script>\n    window.addEventListener('DOMContentLoaded', _ => {\n      const dom = new DOM(document);\n      const detailsRenderer = new DetailsRenderer(dom);\n      const categoryRenderer = new CategoryRenderer(dom, detailsRenderer);\n      const renderer = new ReportRenderer(dom, categoryRenderer);\n\n      const container = document.querySelector('main');\n      renderer.renderReport(window.__LIGHTHOUSE_JSON__, container);\n\n      // Hook in JS features and page-level event listeners after the report\n      // is in the document.\n      const features = new ReportUIFeatures(dom);\n      features.initFeatures(window.__LIGHTHOUSE_JSON__);\n    });\n\n    document.addEventListener('lh-analytics', e => {\n      if (window.ga) {\n        ga(e.detail.cmd, e.detail.fields);\n      }\n    });\n\n    document.addEventListener('lh-log', e => {\n      const logger = new Logger(document.querySelector('#lh-log'));\n\n      switch (e.detail.cmd) {\n        case 'log':\n          logger.log(e.detail.msg);\n          break;\n        case 'warn':\n          logger.warn(e.detail.msg);\n          break;\n        case 'error':\n          logger.error(e.detail.msg);\n          break;\n        case 'hide':\n          logger.hide();\n          break;\n      }\n    });\n  </script>\n</body>\n</html>\n";const REPORT_JAVASCRIPT=["/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/* globals self URL */\n\nconst ELLIPSIS = '\\u2026';\nconst NBSP = '\\xa0';\n\nconst RATINGS = {\n  PASS: {label: 'pass', minScore: 75},\n  AVERAGE: {label: 'average', minScore: 45},\n  FAIL: {label: 'fail'}\n};\n\nclass Util {\n  /**\n   * Convert a score to a rating label.\n   * @param {number} score\n   * @return {string}\n   */\n  static calculateRating(score) {\n    let rating = RATINGS.FAIL.label;\n    if (score >= RATINGS.PASS.minScore) {\n      rating = RATINGS.PASS.label;\n    } else if (score >= RATINGS.AVERAGE.minScore) {\n      rating = RATINGS.AVERAGE.label;\n    }\n    return rating;\n  }\n\n  /**\n   * Format number.\n   * @param {number} number\n   * @param {number=} decimalPlaces Number of decimal places to include. Defaults to 1.\n   * @return {string}\n   */\n  static formatNumber(number, decimalPlaces = 1) {\n    return number.toLocaleString(undefined, {maximumFractionDigits: decimalPlaces});\n  }\n\n  /**\n   * @param {number} size\n   * @param {number=} decimalPlaces Number of decimal places to include. Defaults to 2.\n   * @return {string}\n   */\n  static formatBytesToKB(size, decimalPlaces = 2) {\n    const kbs = (size / 1024).toLocaleString(undefined, {maximumFractionDigits: decimalPlaces});\n    return `${kbs}${NBSP}KB`;\n  }\n\n  /**\n   * @param {number} ms\n   * @param {number=} granularity Controls how coarse the displayed value is, defaults to 10\n   * @return {string}\n   */\n  static formatMilliseconds(ms, granularity = 10) {\n    const coarseTime = Math.round(ms / granularity) * granularity;\n    return `${coarseTime.toLocaleString()}${NBSP}ms`;\n  }\n\n  /**\n   * Format time.\n   * @param {string} date\n   * @return {string}\n   */\n  static formatDateTime(date) {\n    const options = {\n      month: 'short', day: 'numeric', year: 'numeric',\n      hour: 'numeric', minute: 'numeric', timeZoneName: 'short'\n    };\n    let formatter = new Intl.DateTimeFormat('en-US', options);\n\n    // Force UTC if runtime timezone could not be detected.\n    // See https://github.com/GoogleChrome/lighthouse/issues/1056\n    const tz = formatter.resolvedOptions().timeZone;\n    if (!tz || tz.toLowerCase() === 'etc/unknown') {\n      options.timeZone = 'UTC';\n      formatter = new Intl.DateTimeFormat('en-US', options);\n    }\n    return formatter.format(new Date(date));\n  }\n\n  /**\n   * @param {!URL} parsedUrl\n   * @param {{numPathParts: (number|undefined), preserveQuery: (boolean|undefined), preserveHost: (boolean|undefined)}=} options\n   * @return {string}\n   */\n  static getURLDisplayName(parsedUrl, options = {}) {\n    const numPathParts = options.numPathParts !== undefined ? options.numPathParts : 2;\n    const preserveQuery = options.preserveQuery !== undefined ? options.preserveQuery : true;\n    const preserveHost = options.preserveHost || false;\n\n    let name;\n\n    if (parsedUrl.protocol === 'about:' || parsedUrl.protocol === 'data:') {\n      // Handle 'about:*' and 'data:*' URLs specially since they have no path.\n      name = parsedUrl.href;\n    } else {\n      name = parsedUrl.pathname;\n      const parts = name.split('/').filter(part => part.length);\n      if (numPathParts && parts.length > numPathParts) {\n        name = ELLIPSIS + parts.slice(-1 * numPathParts).join('/');\n      }\n\n      if (preserveHost) {\n        name = `${parsedUrl.host}/${name.replace(/^\\//, '')}`;\n      }\n      if (preserveQuery) {\n        name = `${name}${parsedUrl.search}`;\n      }\n    }\n\n    const MAX_LENGTH = 64;\n    // Always elide hash\n    name = name.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g, `$1${ELLIPSIS}`);\n\n    // Elide query params first\n    if (name.length > MAX_LENGTH && name.includes('?')) {\n      // Try to leave the first query parameter intact\n      name = name.replace(/\\?([^=]*)(=)?.*/, `?$1$2${ELLIPSIS}`);\n\n      // Remove it all if it's still too long\n      if (name.length > MAX_LENGTH) {\n        name = name.replace(/\\?.*/, `?${ELLIPSIS}`);\n      }\n    }\n\n    // Elide too long names next\n    if (name.length > MAX_LENGTH) {\n      const dotIndex = name.lastIndexOf('.');\n      if (dotIndex >= 0) {\n        name = name.slice(0, MAX_LENGTH - 1 - (name.length - dotIndex)) +\n            // Show file extension\n            `${ELLIPSIS}${name.slice(dotIndex)}`;\n      } else {\n        name = name.slice(0, MAX_LENGTH - 1) + ELLIPSIS;\n      }\n    }\n\n    return name;\n  }\n\n  /**\n   * Split a URL into a file and hostname for easy display.\n   * @param {string} url\n   * @return {{file: string, hostname: string}}\n   */\n  static parseURL(url) {\n    const parsedUrl = new URL(url);\n    return {file: Util.getURLDisplayName(parsedUrl), hostname: parsedUrl.hostname};\n  }\n\n  /**\n   * @param {number} startTime\n   * @param {number} endTime\n   * @return {string}\n   */\n  static chainDuration(startTime, endTime) {\n    return Util.formatNumber((endTime - startTime) * 1000);\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = Util;\n} else {\n  self.Util = Util;\n}\n","/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/* globals URL self */\n\nclass DOM {\n  /**\n   * @param {!Document} document\n   */\n  constructor(document) {\n    /** @private {!Document} */\n    this._document = document;\n  }\n\n  /**\n   * @param {string} name\n   * @param {string=} className\n   * @param {!Object<string, (string|undefined)>=} attrs Attribute key/val pairs.\n   *     Note: if an attribute key has an undefined value, this method does not\n   *     set the attribute on the node.\n   * @return {!Element}\n   */\n  createElement(name, className, attrs = {}) {\n    const element = this._document.createElement(name);\n    if (className) {\n      element.className = className;\n    }\n    Object.keys(attrs).forEach(key => {\n      const value = attrs[key];\n      if (typeof value !== 'undefined') {\n        element.setAttribute(key, value);\n      }\n    });\n    return element;\n  }\n\n  /**\n   * @param {!Element} parentElem\n   * @param {string} elementName\n   * @param {string=} className\n   * @param {!Object<string, (string|undefined)>=} attrs Attribute key/val pairs.\n   *     Note: if an attribute key has an undefined value, this method does not\n   *     set the attribute on the node.\n   * @return {!Element}\n   */\n  createChildOf(parentElem, elementName, className, attrs) {\n    const element = this.createElement(elementName, className, attrs);\n    parentElem.appendChild(element);\n    return element;\n  }\n\n  /**\n   * @param {string} selector\n   * @param {!Node} context\n   * @return {!DocumentFragment} A clone of the template content.\n   * @throws {Error}\n   */\n  cloneTemplate(selector, context) {\n    const template = /** @type {?HTMLTemplateElement} */ (context.querySelector(selector));\n    if (!template) {\n      throw new Error(`Template not found: template${selector}`);\n    }\n\n    const clone = /** @type {!DocumentFragment} */ (\n        this._document.importNode(template.content, true));\n\n    // Prevent duplicate styles in the DOM. After a template has been stamped\n    // for the first time, remove the clone's styles so they're not re-added.\n    if (template.hasAttribute('data-stamped')) {\n      this.findAll('style', clone).forEach(style => style.remove());\n    }\n    template.setAttribute('data-stamped', true);\n\n    return clone;\n  }\n\n  /**\n   * Resets the \"stamped\" state of the templates.\n   */\n  resetTemplates() {\n    this.findAll('template[data-stamped]', this._document).forEach(t => {\n      t.removeAttribute('data-stamped');\n    });\n  }\n\n  /**\n   * @param {string} text\n   * @return {!Element}\n   */\n  convertMarkdownLinkSnippets(text) {\n    const element = this.createElement('span');\n\n    // Split on markdown links (e.g. [some link](https://...)).\n    const parts = text.split(/\\[(.*?)\\]\\((https?:\\/\\/.*?)\\)/g);\n\n    while (parts.length) {\n      // Pop off the same number of elements as there are capture groups.\n      const [preambleText, linkText, linkHref] = parts.splice(0, 3);\n      element.appendChild(this._document.createTextNode(preambleText));\n\n      // Append link if there are any.\n      if (linkText && linkHref) {\n        const a = /** @type {!HTMLAnchorElement} */ (this.createElement('a'));\n        a.rel = 'noopener';\n        a.target = '_blank';\n        a.textContent = linkText;\n        a.href = (new URL(linkHref)).href;\n        element.appendChild(a);\n      }\n    }\n\n    return element;\n  }\n\n  /**\n   * @param {string} text\n   * @return {!Element}\n   */\n  convertMarkdownCodeSnippets(text) {\n    const element = this.createElement('span');\n\n    const parts = text.split(/`(.*?)`/g); // Split on markdown code slashes\n    while (parts.length) {\n      // Pop off the same number of elements as there are capture groups.\n      const [preambleText, codeText] = parts.splice(0, 2);\n      element.appendChild(this._document.createTextNode(preambleText));\n      if (codeText) {\n        const pre = /** @type {!HTMLPreElement} */ (this.createElement('code'));\n        pre.textContent = codeText;\n        element.appendChild(pre);\n      }\n    }\n\n    return element;\n  }\n\n  /**\n   * @return {!Document}\n   */\n  document() {\n    return this._document;\n  }\n\n  /**\n   * Guaranteed context.querySelector. Always returns an element or throws if\n   * nothing matches query.\n   * @param {string} query\n   * @param {!Node} context\n   * @return {!Element}\n   */\n  find(query, context) {\n    const result = context.querySelector(query);\n    if (result === null) {\n      throw new Error(`query ${query} not found`);\n    }\n    return result;\n  }\n\n  /**\n   * Helper for context.querySelectorAll. Returns an Array instead of a NodeList.\n   * @param {string} query\n   * @param {!Node} context\n   * @return {!Array<!Element>}\n   */\n  findAll(query, context) {\n    return Array.from(context.querySelectorAll(query));\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = DOM;\n} else {\n  self.DOM = DOM;\n}\n","/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/* globals self CriticalRequestChainRenderer Util */\n\nclass DetailsRenderer {\n  /**\n   * @param {!DOM} dom\n   */\n  constructor(dom) {\n    /** @private {!DOM} */\n    this._dom = dom;\n    /** @private {!Document|!Element} */\n    this._templateContext; // eslint-disable-line no-unused-expressions\n  }\n\n  /**\n   * @param {!Document|!Element} context\n   */\n  setTemplateContext(context) {\n    this._templateContext = context;\n  }\n\n  /**\n   * @param {!DetailsRenderer.DetailsJSON} details\n   * @return {!Node}\n   */\n  render(details) {\n    switch (details.type) {\n      case 'text':\n        return this._renderText(details);\n      case 'url':\n        return this._renderURL(details);\n      case 'thumbnail':\n        return this._renderThumbnail(/** @type {!DetailsRenderer.ThumbnailDetails} */ (details));\n      case 'filmstrip':\n        return this._renderFilmstrip(/** @type {!DetailsRenderer.FilmstripDetails} */ (details));\n      case 'cards':\n        return this._renderCards(/** @type {!DetailsRenderer.CardsDetailsJSON} */ (details));\n      case 'table':\n        return this._renderTable(/** @type {!DetailsRenderer.TableDetailsJSON} */ (details));\n      case 'code':\n        return this._renderCode(details);\n      case 'node':\n        return this.renderNode(/** @type {!DetailsRenderer.NodeDetailsJSON} */(details));\n      case 'criticalrequestchain':\n        return CriticalRequestChainRenderer.render(this._dom, this._templateContext,\n            /** @type {!CriticalRequestChainRenderer.CRCDetailsJSON} */ (details));\n      case 'list':\n        return this._renderList(/** @type {!DetailsRenderer.ListDetailsJSON} */ (details));\n      default:\n        throw new Error(`Unknown type: ${details.type}`);\n    }\n  }\n\n  /**\n   * @param {!DetailsRenderer.DetailsJSON} text\n   * @return {!Element}\n   */\n  _renderURL(text) {\n    const url = text.text || '';\n\n    let displayedURL;\n    let title;\n    try {\n      displayedURL = Util.parseURL(url).file;\n      title = url;\n    } catch (/** @type {!Error} */ e) {\n      if (!(e instanceof TypeError)) {\n        throw e;\n      }\n      displayedURL = url;\n    }\n\n    const element = this._renderText({\n      type: 'url',\n      text: displayedURL\n    });\n    element.classList.add('lh-text__url');\n\n    if (title) {\n      element.title = url;\n    }\n\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.DetailsJSON} text\n   * @return {!Element}\n   */\n  _renderText(text) {\n    const element = this._dom.createElement('div', 'lh-text');\n    element.textContent = text.text;\n    return element;\n  }\n\n  /**\n   * Create small thumbnail with scaled down image asset.\n   * If the supplied details doesn't have an image/* mimeType, then an empty span is returned.\n   * @param {!DetailsRenderer.ThumbnailDetails} value\n   * @return {!Element}\n   */\n  _renderThumbnail(value) {\n    if (/^image/.test(value.mimeType) === false) {\n      return this._dom.createElement('span');\n    }\n\n    const element = this._dom.createElement('img', 'lh-thumbnail');\n    element.src = value.url;\n    element.alt = '';\n    element.title = value.url;\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.ListDetailsJSON} list\n   * @return {!Element}\n   */\n  _renderList(list) {\n    if (!list.items.length) return this._dom.createElement('span');\n\n    const element = this._dom.createElement('details', 'lh-details');\n    element.open = true;\n    if (list.header) {\n      const summary = this._dom.createElement('summary', 'lh-list__header');\n      summary.textContent = list.header.text;\n      element.appendChild(summary);\n    }\n\n    const itemsElem = this._dom.createChildOf(element, 'div', 'lh-list__items');\n    for (const item of list.items) {\n      const itemElem = this._dom.createChildOf(itemsElem, 'span', 'lh-list__item');\n      itemElem.appendChild(this.render(item));\n    }\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.TableDetailsJSON} details\n   * @return {!Element}\n   */\n  _renderTable(details) {\n    if (!details.items.length) return this._dom.createElement('span');\n\n    const element = this._dom.createElement('details', 'lh-details');\n    element.open = true;\n    if (details.header) {\n      element.appendChild(this._dom.createElement('summary')).textContent = details.header;\n    }\n\n    const tableElem = this._dom.createChildOf(element, 'table', 'lh-table');\n    const theadElem = this._dom.createChildOf(tableElem, 'thead');\n    const theadTrElem = this._dom.createChildOf(theadElem, 'tr');\n\n    for (const heading of details.itemHeaders) {\n      const itemType = heading.itemType || 'text';\n      const classes = `lh-table-column--${itemType}`;\n      this._dom.createChildOf(theadTrElem, 'th', classes).appendChild(this.render(heading));\n    }\n\n    const tbodyElem = this._dom.createChildOf(tableElem, 'tbody');\n    for (const row of details.items) {\n      const rowElem = this._dom.createChildOf(tbodyElem, 'tr');\n      for (const columnItem of row) {\n        const classes = `lh-table-column--${columnItem.type}`;\n        this._dom.createChildOf(rowElem, 'td', classes).appendChild(this.render(columnItem));\n      }\n    }\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.NodeDetailsJSON} item\n   * @return {!Element}\n   * @protected\n   */\n  renderNode(item) {\n    const element = this._dom.createElement('span', 'lh-node');\n    element.textContent = item.snippet;\n    element.title = item.selector;\n    if (item.text) element.setAttribute('data-text', item.text);\n    if (item.path) element.setAttribute('data-path', item.path);\n    if (item.selector) element.setAttribute('data-selector', item.selector);\n    if (item.snippet) element.setAttribute('data-snippet', item.snippet);\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.CardsDetailsJSON} details\n   * @return {!Element}\n   */\n  _renderCards(details) {\n    const element = this._dom.createElement('details', 'lh-details');\n    element.open = true;\n    if (details.header) {\n      element.appendChild(this._dom.createElement('summary')).textContent = details.header.text;\n    }\n\n    const cardsParent = this._dom.createElement('div', 'lh-scorecards');\n    for (const item of details.items) {\n      const card = cardsParent.appendChild(\n          this._dom.createElement('div', 'lh-scorecard', {title: item.snippet}));\n      const titleEl = this._dom.createElement('div', 'lh-scorecard__title');\n      const valueEl = this._dom.createElement('div', 'lh-scorecard__value');\n      const targetEl = this._dom.createElement('div', 'lh-scorecard__target');\n\n      card.appendChild(titleEl).textContent = item.title;\n      card.appendChild(valueEl).textContent = item.value;\n\n      if (item.target) {\n        card.appendChild(targetEl).textContent = `target: ${item.target}`;\n      }\n    }\n\n    element.appendChild(cardsParent);\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.FilmstripDetails} details\n   * @return {!Element}\n   */\n  _renderFilmstrip(details) {\n    const filmstripEl = this._dom.createElement('div', 'lh-filmstrip');\n\n    for (const thumbnail of details.items) {\n      const frameEl = this._dom.createChildOf(filmstripEl, 'div', 'lh-filmstrip__frame');\n\n      let timing = Util.formatMilliseconds(thumbnail.timing, 1);\n      if (thumbnail.timing > 1000) {\n        timing = Util.formatNumber(thumbnail.timing / 1000) + ' s';\n      }\n\n      const timingEl = this._dom.createChildOf(frameEl, 'div', 'lh-filmstrip__timestamp');\n      timingEl.textContent = timing;\n\n      const base64data = thumbnail.data;\n      this._dom.createChildOf(frameEl, 'img', 'lh-filmstrip__thumbnail', {\n        src: `data:image/jpeg;base64,${base64data}`,\n        alt: `Screenshot at ${timing}`,\n      });\n    }\n\n    return filmstripEl;\n  }\n\n  /**\n   * @param {!DetailsRenderer.DetailsJSON} details\n   * @return {!Element}\n   */\n  _renderCode(details) {\n    const pre = this._dom.createElement('pre', 'lh-code');\n    pre.textContent = details.text;\n    return pre;\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = DetailsRenderer;\n} else {\n  self.DetailsRenderer = DetailsRenderer;\n}\n\n/**\n * @typedef {{\n *     type: string,\n *     text: (string|undefined)\n * }}\n */\nDetailsRenderer.DetailsJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     type: string,\n *     header: ({text: string}|undefined),\n *     items: !Array<{type: string, text: (string|undefined)}>\n * }}\n */\nDetailsRenderer.ListDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     type: string,\n *     text: (string|undefined),\n *     path: (string|undefined),\n *     selector: (string|undefined),\n *     snippet:(string|undefined)\n * }}\n */\nDetailsRenderer.NodeDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     type: string,\n *     header: ({text: string}|undefined),\n *     items: !Array<{title: string, value: string, snippet: (string|undefined), target: string}>\n * }}\n */\nDetailsRenderer.CardsDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     type: string,\n *     itemType: (string|undefined),\n *     text: (string|undefined)\n * }}\n */\nDetailsRenderer.TableHeaderJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     type: string,\n *     text: (string|undefined),\n *     path: (string|undefined),\n *     selector: (string|undefined),\n *     snippet:(string|undefined)\n * }}\n */\nDetailsRenderer.NodeDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     type: string,\n *     header: ({text: string}|undefined),\n *     items: !Array<!Array<!DetailsRenderer.DetailsJSON>>,\n *     itemHeaders: !Array<!DetailsRenderer.TableHeaderJSON>\n * }}\n */\nDetailsRenderer.TableDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     type: string,\n *     url: ({text: string}|undefined),\n *     mimeType: ({text: string}|undefined)\n * }}\n */\nDetailsRenderer.ThumbnailDetails; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     type: string,\n *     scale: number,\n *     items: !Array<{timing: number, timestamp: number, data: string}>,\n * }}\n */\nDetailsRenderer.FilmstripDetails; // eslint-disable-line no-unused-expressions\n","/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/**\n * @fileoverview This file contains helpers for constructing and rendering the\n * critical request chains network tree.\n */\n\n/* globals self Util */\n\nclass CriticalRequestChainRenderer {\n  /**\n   * Create render context for critical-request-chain tree display.\n   * @param {!Object<string, !CriticalRequestChainRenderer.CRCNode>} tree\n   * @return {{tree: !Object<string, !CriticalRequestChainRenderer.CRCNode>, startTime: number, transferSize: number}}\n   */\n  static initTree(tree) {\n    let startTime = 0;\n    const rootNodes = Object.keys(tree);\n    if (rootNodes.length > 0) {\n      const node = tree[rootNodes[0]];\n      startTime = node.request.startTime;\n    }\n\n    return {tree, startTime, transferSize: 0};\n  }\n\n  /**\n   * Helper to create context for each critical-request-chain node based on its\n   * parent. Calculates if this node is the last child, whether it has any\n   * children itself and what the tree looks like all the way back up to the root,\n   * so the tree markers can be drawn correctly.\n   * @param {!Object<string, !CriticalRequestChainRenderer.CRCNode>} parent\n   * @param {string} id\n   * @param {number} startTime\n   * @param {number} transferSize\n   * @param {!Array<boolean>=} treeMarkers\n   * @param {boolean=} parentIsLastChild\n   * @return {!CriticalRequestChainRenderer.CRCSegment}\n   */\n  static createSegment(parent, id, startTime, transferSize, treeMarkers, parentIsLastChild) {\n    const node = parent[id];\n    const siblings = Object.keys(parent);\n    const isLastChild = siblings.indexOf(id) === (siblings.length - 1);\n    const hasChildren = Object.keys(node.children).length > 0;\n\n    // Copy the tree markers so that we don't change by reference.\n    const newTreeMarkers = Array.isArray(treeMarkers) ? treeMarkers.slice(0) : [];\n\n    // Add on the new entry.\n    if (typeof parentIsLastChild !== 'undefined') {\n      newTreeMarkers.push(!parentIsLastChild);\n    }\n\n    return {\n      node,\n      isLastChild,\n      hasChildren,\n      startTime,\n      transferSize: transferSize + node.request.transferSize,\n      treeMarkers: newTreeMarkers\n    };\n  }\n\n  /**\n   * Creates the DOM for a tree segment.\n   * @param {!DOM} dom\n   * @param {!DocumentFragment} tmpl\n   * @param {!CriticalRequestChainRenderer.CRCSegment} segment\n   * @return {!Node}\n   */\n  static createChainNode(dom, tmpl, segment) {\n    const chainsEl = dom.cloneTemplate('#tmpl-lh-crc__chains', tmpl);\n\n    // Hovering over request shows full URL.\n    dom.find('.crc-node', chainsEl).setAttribute('title', segment.node.request.url);\n\n    const treeMarkeEl = dom.find('.crc-node__tree-marker', chainsEl);\n\n    // Construct lines and add spacers for sub requests.\n    segment.treeMarkers.forEach(separator => {\n      if (separator) {\n        treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker vert'));\n        treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker'));\n      } else {\n        treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker'));\n        treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker'));\n      }\n    });\n\n    if (segment.isLastChild) {\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker up-right'));\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker right'));\n    } else {\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker vert-right'));\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker right'));\n    }\n\n    if (segment.hasChildren) {\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker horiz-down'));\n    } else {\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker right'));\n    }\n\n    // Fill in url, host, and request size information.\n    const {file, hostname} = Util.parseURL(segment.node.request.url);\n    const treevalEl = dom.find('.crc-node__tree-value', chainsEl);\n    dom.find('.crc-node__tree-file', treevalEl).textContent = `${file}`;\n    dom.find('.crc-node__tree-hostname', treevalEl).textContent = `(${hostname})`;\n\n    if (!segment.hasChildren) {\n      const span = dom.createElement('span', 'crc-node__chain-duration');\n      span.textContent = ' - ' + Util.chainDuration(\n          segment.node.request.startTime, segment.node.request.endTime) + 'ms, ';\n      const span2 = dom.createElement('span', 'crc-node__chain-duration');\n      span2.textContent = Util.formatBytesToKB(segment.node.request.transferSize);\n\n      treevalEl.appendChild(span);\n      treevalEl.appendChild(span2);\n    }\n\n    return chainsEl;\n  }\n\n  /**\n   * Recursively builds a tree from segments.\n   * @param {!DOM} dom\n   * @param {!DocumentFragment} tmpl\n   * @param {!CriticalRequestChainRenderer.CRCSegment} segment\n   * @param {!Element} detailsEl Parent details element.\n   * @param {!CriticalRequestChainRenderer.CRCDetailsJSON} details\n   */\n  static buildTree(dom, tmpl, segment, detailsEl, details) {\n    detailsEl.appendChild(CriticalRequestChainRenderer.createChainNode(dom, tmpl, segment));\n\n    for (const key of Object.keys(segment.node.children)) {\n      const childSegment = CriticalRequestChainRenderer.createSegment(segment.node.children, key,\n         segment.startTime, segment.transferSize, segment.treeMarkers, segment.isLastChild);\n      CriticalRequestChainRenderer.buildTree(dom, tmpl, childSegment, detailsEl, details);\n    }\n  }\n\n  /**\n   * @param {!DOM} dom\n   * @param {!Node} templateContext\n   * @param {!CriticalRequestChainRenderer.CRCDetailsJSON} details\n   * @return {!Node}\n   */\n  static render(dom, templateContext, details) {\n    const tmpl = dom.cloneTemplate('#tmpl-lh-crc', templateContext);\n\n    // Fill in top summary.\n    dom.find('.lh-crc__longest_duration', tmpl).textContent =\n        Util.formatNumber(details.longestChain.duration) + 'ms';\n    dom.find('.lh-crc__longest_length', tmpl).textContent = details.longestChain.length;\n    dom.find('.lh-crc__longest_transfersize', tmpl).textContent =\n        Util.formatBytesToKB(details.longestChain.transferSize);\n\n    const detailsEl = dom.find('.lh-details', tmpl);\n    detailsEl.open = true;\n\n    dom.find('.lh-details > summary', tmpl).textContent = details.header.text;\n\n    // Construct visual tree.\n    const root = CriticalRequestChainRenderer.initTree(details.chains);\n    for (const key of Object.keys(root.tree)) {\n      const segment = CriticalRequestChainRenderer.createSegment(root.tree, key,\n          root.startTime, root.transferSize);\n      CriticalRequestChainRenderer.buildTree(dom, tmpl, segment, detailsEl, details);\n    }\n\n    return tmpl;\n  }\n}\n\n// Allow Node require()'ing.\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = CriticalRequestChainRenderer;\n} else {\n  self.CriticalRequestChainRenderer = CriticalRequestChainRenderer;\n}\n\n/** @typedef {{\n *     type: string,\n *     header: {text: string},\n *     longestChain: {duration: number, length: number, transferSize: number},\n *     chains: !Object<string, !CriticalRequestChainRenderer.CRCNode>\n * }}\n */\nCriticalRequestChainRenderer.CRCDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     endTime: number,\n *     responseReceivedTime: number,\n *     startTime: number,\n *     transferSize: number,\n *     url: string\n * }}\n */\nCriticalRequestChainRenderer.CRCRequest; // eslint-disable-line no-unused-expressions\n\n/**\n * Record type so children can circularly have CRCNode values.\n * @struct\n * @record\n */\nCriticalRequestChainRenderer.CRCNode = function() {};\n\n/** @type {!Object<string, !CriticalRequestChainRenderer.CRCNode>} */\nCriticalRequestChainRenderer.CRCNode.prototype.children; // eslint-disable-line no-unused-expressions\n\n/** @type {!CriticalRequestChainRenderer.CRCRequest} */\nCriticalRequestChainRenderer.CRCNode.prototype.request; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     node: !CriticalRequestChainRenderer.CRCNode,\n *     isLastChild: boolean,\n *     hasChildren: boolean,\n *     startTime: number,\n *     transferSize: number,\n *     treeMarkers: !Array<boolean>\n * }}\n */\nCriticalRequestChainRenderer.CRCSegment; // eslint-disable-line no-unused-expressions\n","/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/* global URL */\n\n/**\n * Generate a filenamePrefix of hostname_YYYY-MM-DD_HH-MM-SS\n * Date/time uses the local timezone, however Node has unreliable ICU\n * support, so we must construct a YYYY-MM-DD date format manually. :/\n * @param {{url: string, generatedTime: string}} results\n * @return {string}\n */\nfunction getFilenamePrefix(results) {\n  const hostname = new (URLConstructor || URL)(results.url).hostname;\n  const date = (results.generatedTime && new Date(results.generatedTime)) || new Date();\n\n  const timeStr = date.toLocaleTimeString('en-US', {hour12: false});\n  const dateParts = date.toLocaleDateString('en-US', {\n    year: 'numeric', month: '2-digit', day: '2-digit'\n  }).split('/');\n  dateParts.unshift(dateParts.pop());\n  const dateStr = dateParts.join('-');\n\n  const filenamePrefix = `${hostname}_${dateStr}_${timeStr}`;\n  // replace characters that are unfriendly to filenames\n  return filenamePrefix.replace(/[\\/\\?<>\\\\:\\*\\|\":]/g, '-');\n}\n\nlet URLConstructor;\nif (typeof module !== 'undefined' && module.exports) {\n  URLConstructor = require('./url-shim');\n\n  module.exports = {getFilenamePrefix};\n}\n","/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/**\n * Logs messages via a UI butter.\n */\nclass Logger {\n  /**\n   * @param {!Element} element\n   */\n  constructor(element) {\n    /** @type {!Element} */\n    this.el = element;\n    /** @private {?number} */\n    this._id = null;\n  }\n\n  /**\n   * Shows a butter bar.\n   * @param {!string} msg The message to show.\n   * @param {boolean=} autoHide True to hide the message after a duration.\n   *     Default is true.\n   */\n  log(msg, autoHide = true) {\n    clearTimeout(this._id);\n\n    this.el.textContent = msg;\n    this.el.classList.add('show');\n    if (autoHide) {\n      this._id = setTimeout(_ => {\n        this.el.classList.remove('show');\n      }, 7000);\n    }\n  }\n\n  /**\n   * @param {string} msg\n   */\n  warn(msg) {\n    this.log('Warning: ' + msg);\n  }\n\n  /**\n   * @param {string} msg\n   */\n  error(msg) {\n    this.log(msg);\n  }\n\n  /**\n   * Explicitly hides the butter bar.\n   */\n  hide() {\n    clearTimeout(this._id);\n    this.el.classList.remove('show');\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = Logger;\n}\n","/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/**\n * @fileoverview Adds export button, print, and other dynamic functionality to\n * the report.\n */\n\n/* globals self URL Blob CustomEvent getFilenamePrefix window */\n\nclass ReportUIFeatures {\n\n  /**\n   * @param {!DOM} dom\n   */\n  constructor(dom) {\n    /** @type {!ReportRenderer.ReportJSON} */\n    this.json; // eslint-disable-line no-unused-expressions\n    /** @protected {!DOM} */\n    this._dom = dom;\n    /** @protected {!Document} */\n    this._document = this._dom.document();\n    /** @private {boolean} */\n    this._copyAttempt = false;\n    /** @type {!Element} **/\n    this.exportButton; // eslint-disable-line no-unused-expressions\n\n    this.onMediaQueryChange = this.onMediaQueryChange.bind(this);\n    this.onCopy = this.onCopy.bind(this);\n    this.onExportButtonClick = this.onExportButtonClick.bind(this);\n    this.onExport = this.onExport.bind(this);\n    this.onKeyDown = this.onKeyDown.bind(this);\n    this.printShortCutDetect = this.printShortCutDetect.bind(this);\n  }\n\n  /**\n   * Adds export button, print, and other functionality to the report. The method\n   * should be called whenever the report needs to be re-rendered.\n   * @param {!ReportRenderer.ReportJSON} report\n   */\n  initFeatures(report) {\n    this.json = report;\n    this._setupMediaQueryListeners();\n    this._setupExportButton();\n    this._setUpCollapseDetailsAfterPrinting();\n    this._resetUIState();\n    this._document.addEventListener('keydown', this.printShortCutDetect);\n    this._document.addEventListener('copy', this.onCopy);\n  }\n\n  /**\n   * Fires a custom DOM event on target.\n   * @param {string} name Name of the event.\n   * @param {!Node=} target DOM node to fire the event on.\n   * @param {*=} detail Custom data to include.\n   */\n  _fireEventOn(name, target = this._document, detail) {\n    const event = new CustomEvent(name, detail ? {detail} : null);\n    this._document.dispatchEvent(event);\n  }\n\n  _setupMediaQueryListeners() {\n    const mediaQuery = self.matchMedia('(max-width: 600px)');\n    mediaQuery.addListener(this.onMediaQueryChange);\n    // Ensure the handler is called on init\n    this.onMediaQueryChange(mediaQuery);\n  }\n\n  /**\n   * Handle media query change events.\n   * @param {!MediaQueryList} mql\n   */\n  onMediaQueryChange(mql) {\n    const root = this._dom.find('.lh-root', this._document);\n    root.classList.toggle('lh-narrow', mql.matches);\n  }\n\n  _setupExportButton() {\n    this.exportButton = this._dom.find('.lh-export__button', this._document);\n    this.exportButton.addEventListener('click', this.onExportButtonClick);\n\n    const dropdown = this._dom.find('.lh-export__dropdown', this._document);\n    dropdown.addEventListener('click', this.onExport);\n  }\n\n  /**\n   * Handle copy events.\n   * @param {!Event} e\n   */\n  onCopy(e) {\n    // Only handle copy button presses (e.g. ignore the user copying page text).\n    if (this._copyAttempt) {\n      // We want to write our own data to the clipboard, not the user's text selection.\n      e.preventDefault();\n      e.clipboardData.setData('text/plain', JSON.stringify(this.json, null, 2));\n\n      this._fireEventOn('lh-log', this._document, {\n        cmd: 'log', msg: 'Report JSON copied to clipboard'\n      });\n    }\n\n    this._copyAttempt = false;\n  }\n\n  /**\n   * Copies the report JSON to the clipboard (if supported by the browser).\n   * @suppress {reportUnknownTypes}\n   */\n  onCopyButtonClick() {\n    this._fireEventOn('lh-analytics', this._document, {\n      cmd: 'send',\n      fields: {hitType: 'event', eventCategory: 'report', eventAction: 'copy'}\n    });\n\n    try {\n      if (this._document.queryCommandSupported('copy')) {\n        this._copyAttempt = true;\n\n        // Note: In Safari 10.0.1, execCommand('copy') returns true if there's\n        // a valid text selection on the page. See http://caniuse.com/#feat=clipboard.\n        if (!this._document.execCommand('copy')) {\n          this._copyAttempt = false; // Prevent event handler from seeing this as a copy attempt.\n\n          this._fireEventOn('lh-log', this._document, {\n            cmd: 'warn', msg: 'Your browser does not support copy to clipboard.'\n          });\n        }\n      }\n    } catch (/** @type {!Error} */ e) {\n      this._copyAttempt = false;\n      this._fireEventOn('lh-log', this._document, {cmd: 'log', msg: e.message});\n    }\n  }\n\n  closeExportDropdown() {\n    this.exportButton.classList.remove('active');\n  }\n\n  /**\n   * Click handler for export button.\n   * @param {!Event} e\n   */\n  onExportButtonClick(e) {\n    e.preventDefault();\n    const el = /** @type {!Element} */ (e.target);\n    el.classList.toggle('active');\n    this._document.addEventListener('keydown', this.onKeyDown);\n  }\n\n  /**\n   * Resets the state of page before capturing the page for export.\n   * When the user opens the exported HTML page, certain UI elements should\n   * be in their closed state (not opened) and the templates should be unstamped.\n   */\n  _resetUIState() {\n    this.closeExportDropdown();\n    this._dom.resetTemplates();\n  }\n\n  /**\n   * Handler for \"export as\" button.\n   * @param {!Event} e\n   */\n  onExport(e) {\n    e.preventDefault();\n\n    const el = /** @type {!Element} */ (e.target);\n\n    if (!el.hasAttribute('data-action')) {\n      return;\n    }\n\n    switch (el.getAttribute('data-action')) {\n      case 'copy':\n        this.onCopyButtonClick();\n        break;\n      case 'print':\n        this.expandAllDetails();\n        self.print();\n        break;\n      case 'save-json': {\n        const jsonStr = JSON.stringify(this.json, null, 2);\n        this._saveFile(new Blob([jsonStr], {type: 'application/json'}));\n        break;\n      }\n      case 'save-html': {\n        const htmlStr = this.getReportHtml();\n        try {\n          this._saveFile(new Blob([htmlStr], {type: 'text/html'}));\n        } catch (/** @type {!Error} */ e) {\n          this._fireEventOn('lh-log', this._document, {\n            cmd: 'error', msg: 'Could not export as HTML. ' + e.message\n          });\n        }\n        break;\n      }\n      case 'open-viewer': {\n        this.sendJsonReport();\n        break;\n      }\n      case 'save-gist': {\n        this.saveAsGist();\n        break;\n      }\n    }\n\n    this.closeExportDropdown();\n    this._document.removeEventListener('keydown', this.onKeyDown);\n  }\n\n  /**\n   * Keydown handler for the document.\n   * @param {!Event} e\n   */\n  onKeyDown(e) {\n    if (e.keyCode === 27) { // ESC\n      this.closeExportDropdown();\n    }\n  }\n\n  /**\n   * Opens a new tab to the online viewer and sends the local page's JSON results\n   * to the online viewer using postMessage.\n   * @protected\n   */\n  sendJsonReport() {\n    const VIEWER_ORIGIN = 'https://googlechrome.github.io';\n    const VIEWER_URL = `${VIEWER_ORIGIN}/lighthouse/viewer/`;\n\n    // Chrome doesn't allow us to immediately postMessage to a popup right\n    // after it's created. Normally, we could also listen for the popup window's\n    // load event, however it is cross-domain and won't fire. Instead, listen\n    // for a message from the target app saying \"I'm open\".\n    const json = this.json;\n    window.addEventListener('message', function msgHandler(/** @type {!Event} */ e) {\n      const messageEvent = /** @type {!MessageEvent<{opened: boolean}>} */ (e);\n      if (messageEvent.origin !== VIEWER_ORIGIN) {\n        return;\n      }\n\n      if (messageEvent.data.opened) {\n        popup.postMessage({lhresults: json}, VIEWER_ORIGIN);\n        window.removeEventListener('message', msgHandler);\n      }\n    });\n\n    const popup = /** @type {!Window} */ (window.open(VIEWER_URL, '_blank'));\n  }\n\n  /**\n   * Expands audit details when user prints via keyboard shortcut.\n   * @param {!Event} e\n   */\n  printShortCutDetect(e) {\n    if ((e.ctrlKey || e.metaKey) && e.keyCode === 80) { // Ctrl+P\n      this.expandAllDetails();\n    }\n  }\n\n  /**\n   * Expands all audit `<details>`.\n   * Ideally, a print stylesheet could take care of this, but CSS has no way to\n   * open a `<details>` element.\n   */\n  expandAllDetails() {\n    const details = this._dom.findAll('.lh-categories details', this._document);\n    details.map(detail => detail.open = true);\n  }\n\n  /**\n   * Collapses all audit `<details>`.\n   * open a `<details>` element.\n   */\n  collapseAllDetails() {\n    const details = this._dom.findAll('.lh-categories details', this._document);\n    details.map(detail => detail.open = false);\n  }\n\n  /**\n   * Sets up listeners to collapse audit `<details>` when the user closes the\n   * print dialog, all `<details>` are collapsed.\n   */\n  _setUpCollapseDetailsAfterPrinting() {\n    // FF and IE implement these old events.\n    if ('onbeforeprint' in self) {\n      self.addEventListener('afterprint', this.collapseAllDetails);\n    } else {\n      // Note: FF implements both window.onbeforeprint and media listeners. However,\n      // it doesn't matchMedia doesn't fire when matching 'print'.\n      self.matchMedia('print').addListener(mql => {\n        if (mql.matches) {\n          this.expandAllDetails();\n        } else {\n          this.collapseAllDetails();\n        }\n      });\n    }\n  }\n\n  /**\n   * Returns the html that recreates this report.\n   * @return {string}\n   * @protected\n   */\n  getReportHtml() {\n    this._resetUIState();\n    return this._document.documentElement.outerHTML;\n  }\n\n  /**\n   * Save json as a gist. Unimplemented in base UI features.\n   * @protected\n   */\n  saveAsGist() {\n    throw new Error('Cannot save as gist from base report');\n  }\n\n  /**\n   * Downloads a file (blob) using a[download].\n   * @param {!Blob|!File} blob The file to save.\n   * @private\n   */\n  _saveFile(blob) {\n    const filename = getFilenamePrefix({\n      url: this.json.url,\n      generatedTime: this.json.generatedTime\n    });\n\n    const ext = blob.type.match('json') ? '.json' : '.html';\n    const href = URL.createObjectURL(blob);\n\n    const a = /** @type {!HTMLAnchorElement} */ (this._dom.createElement('a'));\n    a.download = `${filename}${ext}`;\n    a.href = href;\n    this._document.body.appendChild(a); // Firefox requires anchor to be in the DOM.\n    a.click();\n\n    // cleanup.\n    this._document.body.removeChild(a);\n    setTimeout(_ => URL.revokeObjectURL(href), 500);\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = ReportUIFeatures;\n} else {\n  self.ReportUIFeatures = ReportUIFeatures;\n}\n","/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/* globals self, Util */\n\nclass CategoryRenderer {\n  /**\n   * @param {!DOM} dom\n   * @param {!DetailsRenderer} detailsRenderer\n   */\n  constructor(dom, detailsRenderer) {\n    /** @private {!DOM} */\n    this._dom = dom;\n    /** @private {!DetailsRenderer} */\n    this._detailsRenderer = detailsRenderer;\n    /** @private {!Document|!Element} */\n    this._templateContext = this._dom.document();\n\n    this._detailsRenderer.setTemplateContext(this._templateContext);\n  }\n\n  /**\n   * @param {!ReportRenderer.AuditJSON} audit\n   * @return {!Element}\n   */\n  _renderAuditScore(audit) {\n    const tmpl = this._dom.cloneTemplate('#tmpl-lh-audit-score', this._templateContext);\n\n    const scoringMode = audit.result.scoringMode;\n    const description = audit.result.helpText;\n    let title = audit.result.description;\n\n    if (audit.result.displayValue) {\n      title += `:  ${audit.result.displayValue}`;\n    }\n    if (audit.result.optimalValue) {\n      title += ` (target: ${audit.result.optimalValue})`;\n    }\n\n    if (audit.result.debugString) {\n      const debugStrEl = tmpl.appendChild(this._dom.createElement('div', 'lh-debug'));\n      debugStrEl.textContent = audit.result.debugString;\n    }\n\n    // Append audit details to header section so the entire audit is within a <details>.\n    const header = /** @type {!HTMLDetailsElement} */ (this._dom.find('.lh-score__header', tmpl));\n    if (audit.result.details) {\n      header.appendChild(this._detailsRenderer.render(audit.result.details));\n    }\n\n    const scoreEl = this._dom.find('.lh-score', tmpl);\n    if (audit.result.informative) {\n      scoreEl.classList.add('lh-score--informative');\n    }\n    if (audit.result.manual) {\n      scoreEl.classList.add('lh-score--manual');\n    }\n\n    return this._populateScore(tmpl, audit.score, scoringMode, title, description);\n  }\n\n  /**\n   * @param {!DocumentFragment|!Element} element DOM node to populate with values.\n   * @param {number} score\n   * @param {string} scoringMode\n   * @param {string} title\n   * @param {string} description\n   * @return {!Element}\n   */\n  _populateScore(element, score, scoringMode, title, description) {\n    // Fill in the blanks.\n    const valueEl = this._dom.find('.lh-score__value', element);\n    valueEl.textContent = Util.formatNumber(score);\n    valueEl.classList.add(`lh-score__value--${Util.calculateRating(score)}`,\n        `lh-score__value--${scoringMode}`);\n\n    this._dom.find('.lh-score__title', element).appendChild(\n        this._dom.convertMarkdownCodeSnippets(title));\n    this._dom.find('.lh-score__description', element)\n        .appendChild(this._dom.convertMarkdownLinkSnippets(description));\n\n    return /** @type {!Element} **/ (element);\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @return {!Element}\n   */\n  _renderCategoryScore(category) {\n    const tmpl = this._dom.cloneTemplate('#tmpl-lh-category-score', this._templateContext);\n    const score = Math.round(category.score);\n\n    const gaugeContainerEl = this._dom.find('.lh-score__gauge', tmpl);\n    const gaugeEl = this.renderScoreGauge(category);\n    gaugeContainerEl.appendChild(gaugeEl);\n\n    return this._populateScore(tmpl, score, 'numeric', category.name, category.description);\n  }\n\n  /**\n   * @param {!ReportRenderer.AuditJSON} audit\n   * @return {!Element}\n   */\n  _renderAudit(audit) {\n    const element = this._dom.createElement('div', 'lh-audit');\n    element.appendChild(this._renderAuditScore(audit));\n    return element;\n  }\n\n  /**\n   * @param {!ReportRenderer.AuditJSON} audit\n   * @param {number} scale\n   * @return {!Element}\n   */\n  _renderTimelineMetricAudit(audit, scale) {\n    const tmpl = this._dom.cloneTemplate('#tmpl-lh-timeline-metric', this._templateContext);\n    const element = this._dom.find('.lh-timeline-metric', tmpl);\n    element.classList.add(`lh-timeline-metric--${Util.calculateRating(audit.score)}`);\n\n    const titleEl = this._dom.find('.lh-timeline-metric__title', tmpl);\n    titleEl.textContent = audit.result.description;\n\n    const valueEl = this._dom.find('.lh-timeline-metric__value', tmpl);\n    valueEl.textContent = audit.result.displayValue;\n\n    const descriptionEl = this._dom.find('.lh-timeline-metric__description', tmpl);\n    descriptionEl.appendChild(this._dom.convertMarkdownLinkSnippets(audit.result.helpText));\n\n    if (typeof audit.result.rawValue !== 'number') {\n      const debugStrEl = this._dom.createChildOf(element, 'div', 'lh-debug');\n      debugStrEl.textContent = audit.result.debugString || 'Report error: no metric information';\n      return element;\n    }\n\n    const sparklineBarEl = this._dom.find('.lh-sparkline__bar', tmpl);\n    sparklineBarEl.style.width = `${audit.result.rawValue / scale * 100}%`;\n\n    return element;\n  }\n\n  /**\n   * @param {!ReportRenderer.AuditJSON} audit\n   * @param {number} scale\n   * @return {!Element}\n   */\n  _renderPerfHintAudit(audit, scale) {\n    const extendedInfo = /** @type {!CategoryRenderer.PerfHintExtendedInfo}\n        */ (audit.result.extendedInfo);\n    const tooltipAttrs = {title: audit.result.displayValue};\n\n    const element = this._dom.createElement('details', [\n      'lh-perf-hint',\n      `lh-perf-hint--${Util.calculateRating(audit.score)}`,\n      'lh-expandable-details',\n    ].join(' '));\n\n    const summary = this._dom.createChildOf(element, 'summary', 'lh-perf-hint__summary ' +\n        'lh-expandable-details__summary');\n    const titleEl = this._dom.createChildOf(summary, 'div', 'lh-perf-hint__title');\n    titleEl.textContent = audit.result.description;\n\n    this._dom.createChildOf(summary, 'div', 'lh-toggle-arrow', {title: 'See resources'});\n\n    if (!extendedInfo || typeof audit.result.rawValue !== 'number') {\n      const debugStrEl = this._dom.createChildOf(summary, 'div', 'lh-debug');\n      debugStrEl.textContent = audit.result.debugString || 'Report error: no extended information';\n      return element;\n    }\n\n    const sparklineContainerEl = this._dom.createChildOf(summary, 'div', 'lh-perf-hint__sparkline',\n        tooltipAttrs);\n    const sparklineEl = this._dom.createChildOf(sparklineContainerEl, 'div', 'lh-sparkline');\n    const sparklineBarEl = this._dom.createChildOf(sparklineEl, 'div', 'lh-sparkline__bar');\n    sparklineBarEl.style.width = audit.result.rawValue / scale * 100 + '%';\n\n    const statsEl = this._dom.createChildOf(summary, 'div', 'lh-perf-hint__stats', tooltipAttrs);\n    const statsMsEl = this._dom.createChildOf(statsEl, 'div', 'lh-perf-hint__primary-stat');\n    statsMsEl.textContent = Util.formatMilliseconds(audit.result.rawValue);\n\n    if (extendedInfo.value.wastedKb) {\n      const statsKbEl = this._dom.createChildOf(statsEl, 'div', 'lh-perf-hint__secondary-stat');\n      statsKbEl.textContent = Util.formatNumber(extendedInfo.value.wastedKb) + ' KB';\n    }\n\n    const descriptionEl = this._dom.createChildOf(element, 'div', 'lh-perf-hint__description');\n    descriptionEl.appendChild(this._dom.convertMarkdownLinkSnippets(audit.result.helpText));\n\n    if (audit.result.debugString) {\n      const debugStrEl = this._dom.createChildOf(summary, 'div', 'lh-debug');\n      debugStrEl.textContent = audit.result.debugString;\n    }\n\n    if (audit.result.details) {\n      element.appendChild(this._detailsRenderer.render(audit.result.details));\n    }\n\n    return element;\n  }\n\n  /**\n   * Renders the group container for a group of audits. Individual audit elements can be added\n   * directly to the returned element.\n   * @param {!ReportRenderer.GroupJSON} group\n   * @param {{expandable: boolean}} opts\n   * @return {!Element}\n   */\n  _renderAuditGroup(group, opts) {\n    const expandable = opts.expandable;\n    const element = this._dom.createElement(expandable ? 'details' :'div', 'lh-audit-group');\n    const summmaryEl = this._dom.createChildOf(element, 'summary', 'lh-audit-group__summary');\n    const headerEl = this._dom.createChildOf(summmaryEl, 'div', 'lh-audit-group__header');\n    this._dom.createChildOf(summmaryEl, 'div',\n      `lh-toggle-arrow  ${expandable ? '' : ' lh-toggle-arrow-unexpandable'}`, {\n        title: 'See audits',\n      });\n\n    if (group.description) {\n      const auditGroupDescription = this._dom.createElement('div', 'lh-audit-group__description');\n      auditGroupDescription.appendChild(this._dom.convertMarkdownLinkSnippets(group.description));\n      element.appendChild(auditGroupDescription);\n    }\n    headerEl.textContent = group.title;\n\n    return element;\n  }\n\n  /**\n   * @param {!Array<!Element>} elements\n   * @return {!Element}\n   */\n  _renderPassedAuditsSection(elements) {\n    const passedElem = this._renderAuditGroup({\n      title: `${elements.length} Passed Audits`,\n    }, {expandable: true});\n    passedElem.classList.add('lh-passed-audits');\n    elements.forEach(elem => passedElem.appendChild(elem));\n    return passedElem;\n  }\n\n  /**\n   * @param {!Array<!ReportRenderer.AuditJSON>} manualAudits\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groupDefinitions\n   * @param {!Element} element Parent container to add the manual audits to.\n   */\n  _renderManualAudits(manualAudits, groupDefinitions, element) {\n    const auditsGroupedByGroup = /** @type {!Object<string,\n        !Array<!ReportRenderer.AuditJSON>>} */ ({});\n    manualAudits.forEach(audit => {\n      const group = auditsGroupedByGroup[audit.group] || [];\n      group.push(audit);\n      auditsGroupedByGroup[audit.group] = group;\n    });\n\n    Object.keys(auditsGroupedByGroup).forEach(groupId => {\n      const group = groupDefinitions[groupId];\n      const auditGroupElem = this._renderAuditGroup(group, {expandable: true});\n      auditGroupElem.classList.add('lh-audit-group--manual');\n\n      auditsGroupedByGroup[groupId].forEach(audit => {\n        auditGroupElem.appendChild(this._renderAudit(audit));\n      });\n\n      element.appendChild(auditGroupElem);\n    });\n  }\n\n  /**\n   * @param {!Document|!Element} context\n   */\n  setTemplateContext(context) {\n    this._templateContext = context;\n    this._detailsRenderer.setTemplateContext(context);\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @return {!DocumentFragment}\n   */\n  renderScoreGauge(category) {\n    const tmpl = this._dom.cloneTemplate('#tmpl-lh-gauge', this._templateContext);\n    this._dom.find('.lh-gauge__wrapper', tmpl).href = `#${category.id}`;\n    this._dom.find('.lh-gauge__label', tmpl).textContent = category.name;\n\n    const score = Math.round(category.score);\n    const fillRotation = Math.floor((score / 100) * 180);\n\n    const gauge = this._dom.find('.lh-gauge', tmpl);\n    gauge.setAttribute('data-progress', score); // .dataset not supported in jsdom.\n    gauge.classList.add(`lh-gauge--${Util.calculateRating(score)}`);\n\n    this._dom.findAll('.lh-gauge__fill', gauge).forEach(el => {\n      el.style.transform = `rotate(${fillRotation}deg)`;\n    });\n\n    this._dom.find('.lh-gauge__mask--full', gauge).style.transform =\n        `rotate(${fillRotation}deg)`;\n    this._dom.find('.lh-gauge__fill--fix', gauge).style.transform =\n        `rotate(${fillRotation * 2}deg)`;\n    this._dom.find('.lh-gauge__percentage', gauge).textContent = score;\n\n    return tmpl;\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groups\n   * @return {!Element}\n   */\n  render(category, groups) {\n    switch (category.id) {\n      case 'performance':\n        return this._renderPerformanceCategory(category, groups);\n      case 'accessibility':\n        return this._renderAccessibilityCategory(category, groups);\n      default:\n        return this._renderDefaultCategory(category, groups);\n    }\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groupDefinitions\n   * @return {!Element}\n   */\n  _renderDefaultCategory(category, groupDefinitions) {\n    const element = this._dom.createElement('div', 'lh-category');\n    this._createPermalinkSpan(element, category.id);\n    element.appendChild(this._renderCategoryScore(category));\n\n    const manualAudits = category.audits.filter(audit => audit.result.manual);\n    const nonManualAudits = category.audits.filter(audit => !manualAudits.includes(audit));\n    const passedAudits = nonManualAudits.filter(audit => audit.score === 100 &&\n        !audit.result.debugString);\n    const nonPassedAudits = nonManualAudits.filter(audit => !passedAudits.includes(audit));\n\n    const nonPassedElem = this._renderAuditGroup({\n      title: `${nonPassedAudits.length} failed audits`,\n    }, {expandable: false});\n    nonPassedElem.classList.add('lh-failed-audits');\n    nonPassedAudits.forEach(audit => nonPassedElem.appendChild(this._renderAudit(audit)));\n    element.appendChild(nonPassedElem);\n\n    // Create a passed section if there are passing audits.\n    if (passedAudits.length) {\n      const passedElem = this._renderPassedAuditsSection(\n        passedAudits.map(audit => this._renderAudit(audit))\n      );\n      element.appendChild(passedElem);\n    }\n\n    // Render manual audits after passing.\n    this._renderManualAudits(manualAudits, groupDefinitions, element);\n\n    return element;\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groups\n   * @return {!Element}\n   */\n  _renderPerformanceCategory(category, groups) {\n    const element = this._dom.createElement('div', 'lh-category');\n    this._createPermalinkSpan(element, category.id);\n    element.appendChild(this._renderCategoryScore(category));\n\n    const metricAudits = category.audits.filter(audit => audit.group === 'perf-metric');\n    const metricAuditsEl = this._renderAuditGroup(groups['perf-metric'], {expandable: false});\n    const timelineContainerEl = this._dom.createChildOf(metricAuditsEl, 'div',\n        'lh-timeline-container');\n    const timelineEl = this._dom.createChildOf(timelineContainerEl, 'div', 'lh-timeline');\n\n    let perfTimelineScale = 0;\n    metricAudits.forEach(audit => {\n      if (typeof audit.result.rawValue === 'number' && audit.result.rawValue) {\n        perfTimelineScale = Math.max(perfTimelineScale, audit.result.rawValue);\n      }\n    });\n\n    const thumbnailAudit = category.audits.find(audit => audit.id === 'screenshot-thumbnails');\n    const thumbnailResult = thumbnailAudit && thumbnailAudit.result;\n    if (thumbnailResult && thumbnailResult.details) {\n      const thumbnailDetails = /** @type {!DetailsRenderer.FilmstripDetails} */\n          (thumbnailResult.details);\n      perfTimelineScale = Math.max(perfTimelineScale, thumbnailDetails.scale);\n      const filmstripEl = this._detailsRenderer.render(thumbnailDetails);\n      timelineEl.appendChild(filmstripEl);\n    }\n\n    metricAudits.forEach(item => {\n      if (item.id === 'speed-index-metric' || item.id === 'estimated-input-latency') {\n        return metricAuditsEl.appendChild(this._renderAudit(item));\n      }\n\n      timelineEl.appendChild(this._renderTimelineMetricAudit(item, perfTimelineScale));\n    });\n\n    metricAuditsEl.open = true;\n    element.appendChild(metricAuditsEl);\n\n    const hintAudits = category.audits\n        .filter(audit => audit.group === 'perf-hint' && audit.score < 100)\n        .sort((auditA, auditB) => auditB.result.rawValue - auditA.result.rawValue);\n    if (hintAudits.length) {\n      const maxWaste = Math.max(...hintAudits.map(audit => audit.result.rawValue));\n      const scale = Math.ceil(maxWaste / 1000) * 1000;\n      const hintAuditsEl = this._renderAuditGroup(groups['perf-hint'], {expandable: false});\n      hintAudits.forEach(item => hintAuditsEl.appendChild(this._renderPerfHintAudit(item, scale)));\n      hintAuditsEl.open = true;\n      element.appendChild(hintAuditsEl);\n    }\n\n    const infoAudits = category.audits\n        .filter(audit => audit.group === 'perf-info' && audit.score < 100);\n    if (infoAudits.length) {\n      const infoAuditsEl = this._renderAuditGroup(groups['perf-info'], {expandable: false});\n      infoAudits.forEach(item => infoAuditsEl.appendChild(this._renderAudit(item)));\n      infoAuditsEl.open = true;\n      element.appendChild(infoAuditsEl);\n    }\n\n    const passedElements = category.audits\n        .filter(audit => (audit.group === 'perf-hint' || audit.group === 'perf-info') &&\n            audit.score === 100)\n        .map(audit => this._renderAudit(audit));\n\n    if (!passedElements.length) return element;\n\n    const passedElem = this._renderPassedAuditsSection(passedElements);\n    element.appendChild(passedElem);\n    return element;\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groupDefinitions\n   * @return {!Element}\n   */\n  _renderAccessibilityCategory(category, groupDefinitions) {\n    const element = this._dom.createElement('div', 'lh-category');\n    this._createPermalinkSpan(element, category.id);\n    element.appendChild(this._renderCategoryScore(category));\n\n    const auditsGroupedByGroup = /** @type {!Object<string,\n        {passed: !Array<!ReportRenderer.AuditJSON>,\n        failed: !Array<!ReportRenderer.AuditJSON>}>} */ ({});\n    category.audits.forEach(audit => {\n      const groupId = audit.group;\n      const groups = auditsGroupedByGroup[groupId] || {passed: [], failed: []};\n\n      if (audit.score === 100) {\n        groups.passed.push(audit);\n      } else {\n        groups.failed.push(audit);\n      }\n\n      auditsGroupedByGroup[groupId] = groups;\n    });\n\n    const passedElements = /** @type {!Array<!Element>} */ ([]);\n    Object.keys(auditsGroupedByGroup).forEach(groupId => {\n      const group = groupDefinitions[groupId];\n      const groups = auditsGroupedByGroup[groupId];\n      if (groups.failed.length) {\n        const auditGroupElem = this._renderAuditGroup(group, {expandable: false});\n        groups.failed.forEach(item => auditGroupElem.appendChild(this._renderAudit(item)));\n        auditGroupElem.open = true;\n        element.appendChild(auditGroupElem);\n      }\n\n      if (groups.passed.length) {\n        const auditGroupElem = this._renderAuditGroup(group, {expandable: true});\n        groups.passed.forEach(item => auditGroupElem.appendChild(this._renderAudit(item)));\n        passedElements.push(auditGroupElem);\n      }\n    });\n\n    // don't create a passed section if there are no passed\n    if (!passedElements.length) return element;\n\n    const passedElem = this._renderPassedAuditsSection(passedElements);\n    element.appendChild(passedElem);\n    return element;\n  }\n\n  /**\n   * Create a non-semantic span used for hash navigation of categories\n   * @param {!Element} element\n   * @param {string} id\n   */\n  _createPermalinkSpan(element, id) {\n    const permalinkEl = this._dom.createChildOf(element, 'span', 'lh-permalink');\n    permalinkEl.id = id;\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = CategoryRenderer;\n} else {\n  self.CategoryRenderer = CategoryRenderer;\n}\n\n\n/**\n * @typedef {{\n *     value: {\n *       wastedMs: (number|undefined),\n *       wastedKb: (number|undefined),\n *     }\n * }}\n */\nCategoryRenderer.PerfHintExtendedInfo; // eslint-disable-line no-unused-expressions\n","/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n'use strict';\n\n/**\n * @fileoverview The entry point for rendering the Lighthouse report based on the JSON output.\n *    This file is injected into the report HTML along with the JSON report.\n *\n * Dummy text for ensuring report robustness: </script> pre$`post %%LIGHTHOUSE_JSON%%\n */\n\n/* globals self, Util */\n\nclass ReportRenderer {\n  /**\n   * @param {!DOM} dom\n   * @param {!CategoryRenderer} categoryRenderer\n   */\n  constructor(dom, categoryRenderer) {\n    /** @private {!DOM} */\n    this._dom = dom;\n    /** @private {!CategoryRenderer} */\n    this._categoryRenderer = categoryRenderer;\n    /** @private {!Document|!Element} */\n    this._templateContext = this._dom.document();\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @param {!Element} container Parent element to render the report into.\n   */\n  renderReport(report, container) {\n    container.textContent = ''; // Remove previous report.\n    const element = container.appendChild(this._renderReport(report));\n\n    return /** @type {!Element} **/ (element);\n  }\n\n  /**\n   * Define a custom element for <templates> to be extracted from. For example:\n   *     this.setTemplateContext(new DOMParser().parseFromString(htmlStr, 'text/html'))\n   * @param {!Document|!Element} context\n   */\n  setTemplateContext(context) {\n    this._templateContext = context;\n    this._categoryRenderer.setTemplateContext(context);\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @return {!DocumentFragment}\n   */\n  _renderReportHeader(report) {\n    const header = this._dom.cloneTemplate('#tmpl-lh-heading', this._templateContext);\n    this._dom.find('.lh-config__timestamp', header).textContent =\n        Util.formatDateTime(report.generatedTime);\n    const url = this._dom.find('.lh-metadata__url', header);\n    url.href = report.url;\n    url.textContent = report.url;\n\n    this._dom.find('.lh-env__item__ua', header).textContent = report.userAgent;\n\n    const env = this._dom.find('.lh-env__items', header);\n    report.runtimeConfig.environment.forEach(runtime => {\n      const item = this._dom.cloneTemplate('#tmpl-lh-env__items', env);\n      this._dom.find('.lh-env__name', item).textContent = runtime.name;\n      this._dom.find('.lh-env__description', item).textContent = runtime.description;\n      this._dom.find('.lh-env__enabled', item).textContent =\n          runtime.enabled ? 'Enabled' : 'Disabled';\n      env.appendChild(item);\n    });\n\n    return header;\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @return {!DocumentFragment}\n   */\n  _renderReportFooter(report) {\n    const footer = this._dom.cloneTemplate('#tmpl-lh-footer', this._templateContext);\n    this._dom.find('.lh-footer__version', footer).textContent = report.lighthouseVersion;\n    this._dom.find('.lh-footer__timestamp', footer).textContent =\n        Util.formatDateTime(report.generatedTime);\n    return footer;\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @return {!DocumentFragment}\n   */\n  _renderReportNav(report) {\n    const leftNav = this._dom.cloneTemplate('#tmpl-lh-leftnav', this._templateContext);\n\n    this._dom.find('.leftnav__header__version', leftNav).textContent =\n        `Version: ${report.lighthouseVersion}`;\n\n    const nav = this._dom.find('.lh-leftnav', leftNav);\n    for (const category of report.reportCategories) {\n      const itemsTmpl = this._dom.cloneTemplate('#tmpl-lh-leftnav__items', leftNav);\n\n      const navItem = this._dom.find('.lh-leftnav__item', itemsTmpl);\n      navItem.href = `#${category.id}`;\n\n      this._dom.find('.leftnav-item__category', navItem).textContent = category.name;\n      const score = this._dom.find('.leftnav-item__score', navItem);\n      score.classList.add(`lh-score__value--${Util.calculateRating(category.score)}`);\n      score.textContent = Math.round(category.score);\n      nav.appendChild(navItem);\n    }\n    return leftNav;\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @return {!Element}\n   */\n  _renderReport(report) {\n    const container = this._dom.createElement('div', 'lh-container');\n    container.appendChild(this._renderReportHeader(report)); // sticky header goes at the top.\n    container.appendChild(this._renderReportNav(report));\n    const reportSection = container.appendChild(this._dom.createElement('div', 'lh-report'));\n\n    let scoreHeader;\n    const isSoloCategory = report.reportCategories.length === 1;\n    if (!isSoloCategory) {\n      scoreHeader = reportSection.appendChild(this._dom.createElement('div', 'lh-scores-header'));\n    }\n\n    const categories = reportSection.appendChild(this._dom.createElement('div', 'lh-categories'));\n    for (const category of report.reportCategories) {\n      if (scoreHeader) {\n        scoreHeader.appendChild(this._categoryRenderer.renderScoreGauge(category));\n      }\n      categories.appendChild(this._categoryRenderer.render(category, report.reportGroups));\n    }\n\n    reportSection.appendChild(this._renderReportFooter(report));\n\n    return container;\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = ReportRenderer;\n} else {\n  self.ReportRenderer = ReportRenderer;\n}\n\n/**\n * @typedef {{\n *     id: string,\n *     weight: number,\n *     score: number,\n *     group: string,\n *     result: {\n *       rawValue: (number|undefined),\n *       description: string,\n *       informative: boolean,\n *       manual: boolean,\n *       debugString: string,\n *       displayValue: string,\n *       helpText: string,\n *       score: (number|boolean),\n *       scoringMode: string,\n *       optimalValue: number,\n *       extendedInfo: Object,\n *       details: (!DetailsRenderer.DetailsJSON|undefined)\n *     }\n * }}\n */\nReportRenderer.AuditJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     name: string,\n *     id: string,\n *     weight: number,\n *     score: number,\n *     description: string,\n *     audits: !Array<!ReportRenderer.AuditJSON>\n * }}\n */\nReportRenderer.CategoryJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     title: string,\n *     description: (string|undefined),\n * }}\n */\nReportRenderer.GroupJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     lighthouseVersion: string,\n *     userAgent: string,\n *     generatedTime: string,\n *     timing: {total: number},\n *     initialUrl: string,\n *     url: string,\n *     artifacts: {traces: !Object},\n *     reportCategories: !Array<!ReportRenderer.CategoryJSON>,\n *     reportGroups: !Object<string, !ReportRenderer.GroupJSON>,\n *     runtimeConfig: {\n *       blockedUrlPatterns: !Array<string>,\n *       environment: !Array<{description: string, enabled: boolean, name: string}>\n *     }\n * }}\n */\nReportRenderer.ReportJSON; // eslint-disable-line no-unused-expressions\n"].join(';\n');const REPORT_CSS="/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n\n.lh-vars {\n  --text-font-family: Roboto, Helvetica, Arial, sans-serif;\n  --monospace-font-family: 'Menlo', 'dejavu sans mono', 'Consolas', 'Lucida Console', monospace;\n  --body-font-size: 14px;\n  --body-line-height: 18px;\n  --subheader-font-size: 16px;\n  --subheader-line-height: 20px;\n  --header-font-size: 20px;\n  --header-line-height: 24px;\n  --title-font-size: 24px;\n  --title-line-height: 28px;\n  --caption-font-size: 12px;\n  --caption-line-height: 16px;\n  --default-padding: 12px;\n  --section-padding: 20px;\n  --section-indent: 16px;\n  --audit-group-indent: 16px;\n  --audit-indent: 16px;\n  --expandable-indent: 20px;\n  --secondary-text-color: #565656;\n  /*--accent-color: #3879d9;*/\n  --fail-color: #df332f;\n  --pass-color: #2b882f;\n  --informative-color: #0c50c7;\n  --manual-color: #757575;\n  --average-color: #ef6c00; /* md orange 800 */\n  --warning-color: #ffab00; /* md amber a700 */\n  --report-border-color: #ccc;\n  --report-secondary-border-color: #ebebeb;\n  --report-width: calc(60 * var(--body-font-size));\n  --report-menu-width: calc(20 * var(--body-font-size));\n  --report-content-width: calc(var(--report-width) + var(--report-menu-width));\n  --navitem-font-size: var(--body-font-size);\n  --navitem-line-height: var(--body-line-height);\n  --navitem-hpadding: var(--body-font-size);\n  --navitem-vpadding: calc(var(--navitem-line-height) / 2);\n  --lh-score-highlight-bg: #fafafa;\n  --lh-score-icon-background-size: 24px;\n  --lh-score-margin: 12px;\n  --lh-table-header-bg: #ccc;\n  --lh-table-higlight-bg: #fafafa;\n  --lh-sparkline-height: 5px;\n  --lh-sparkline-thin-height: 3px;\n  --lh-filmstrip-thumbnail-width: 60px;\n  --lh-audit-score-width: calc(5 * var(--body-font-size));\n  --lh-category-score-width: calc(5 * var(--body-font-size));\n  --lh-audit-vpadding: 8px;\n  --lh-audit-hgap: 12px;\n  --lh-audit-group-vpadding: 12px;\n  --lh-section-vpadding: 12px;\n  --pass-icon-url: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><path stroke=\"#007F04\" stroke-width=\"1.5\" d=\"M1 5.75l3.5 3.5 6.5-6.5\" fill=\"none\" fill-rule=\"evenodd\"/></svg>');\n  --fail-icon-url: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><g stroke=\"#EE1D0A\" stroke-width=\"1.5\" fill=\"none\" fill-rule=\"evenodd\"><path d=\"M2 10l8-8M10 10L2 2\"/></g></svg>');\n  --collapsed-icon-url: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"none\" fill-rule=\"evenodd\"><path fill=\"none\" d=\"M0 0h12v12H0z\"/><path fill=\"hsl(0, 0%, 60%)\" d=\"M3 2l6 4-6 4z\"/></g></svg>');\n  --expanded-icon-url: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"none\" fill-rule=\"evenodd\"><path fill=\"none\" d=\"M0 0h12v12H0z\"/><path fill=\"hsl(0, 0%, 60%)\" d=\"M10 3L6 9 2 3z\"/></g></svg>');\n}\n\n.lh-vars.lh-devtools {\n  --text-font-family: '.SFNSDisplay-Regular', 'Helvetica Neue', 'Lucida Grande', sans-serif;\n  --monospace-font-family: 'Menlo', 'dejavu sans mono', 'Consolas', 'Lucida Console', monospace;\n  --body-font-size: 12px;\n  --body-line-height: 16px;\n  --subheader-font-size: 14px;\n  --subheader-line-height: 18px;\n  --header-font-size: 16px;\n  --header-line-height: 20px;\n  --title-font-size: 20px;\n  --title-line-height: 24px;\n  --caption-font-size: 11px;\n  --caption-line-height: 14px;\n  --default-padding: 12px;\n  --section-padding: 16px;\n  --section-indent: 16px;\n  --audit-group-indent: 16px;\n  --audit-indent: 16px;\n  --expandable-indent: 16px;\n\n  --lh-audit-vpadding: 4px;\n  --lh-audit-hgap: 12px;\n  --lh-audit-group-vpadding: 8px;\n  --lh-section-vpadding: 8px;\n}\n\n.lh-root * {\n  box-sizing: border-box;\n}\n\n.lh-root {\n  font-family: var(--text-font-family);\n  font-size: var(--body-font-size);\n  margin: 0;\n  line-height: var(--body-line-height);\n  background: #f5f5f5;\n  scroll-behavior: smooth;\n}\n\n.lh-root :focus {\n    outline: -webkit-focus-ring-color auto 3px;\n}\n\n.lh-root [hidden] {\n  display: none !important;\n}\n\na {\n  color: #0c50c7;\n}\n\nsummary {\n  cursor: pointer;\n}\n\n.lh-details {\n  font-size: var(--body-font-size);\n  margin-top: var(--default-padding);\n}\n\n.lh-details[open] summary {\n  margin-bottom: var(--default-padding);\n}\n\n.lh-details summary::-webkit-details-marker {\n  color: #9e9e9e;\n}\n\n.lh-details.flex .lh-code {\n  max-width: 70%;\n}\n\n/* Report header */\n\n.report-icon {\n  opacity: 0.7;\n}\n.report-icon:hover {\n  opacity: 1;\n}\n.report-icon[disabled] {\n  opacity: 0.3;\n  pointer-events: none;\n}\n\n.report-icon--share {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path fill=\"none\" d=\"M0 0h24v24H0z\"/><path d=\"M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z\"/></svg>');\n}\n.report-icon--print {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path d=\"M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z\"/><path fill=\"none\" d=\"M0 0h24v24H0z\"/></svg>');\n}\n.report-icon--copy {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z\"/></svg>');\n}\n.report-icon--open {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z\"/></svg>');\n}\n.report-icon--download {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z\"/><path d=\"M0 0h24v24H0z\" fill=\"none\"/></svg>');\n}\n\n/* List */\n.lh-list {\n  font-size: smaller;\n  margin-top: var(--default-padding);\n}\n\n.lh-list__items {\n  padding-left: var(--default-padding);\n}\n\n.lh-list__item {\n  margin-bottom: 2px;\n}\n\n/* Node */\n.lh-node {\n  display: block;\n  font-family: var(--monospace-font-family);\n  word-break: break-word;\n  color: hsl(174, 100%, 27%);\n}\nspan.lh-node:hover {\n    background: hsl(0, 0%, 98%);\n    border-radius: 2px;\n}\n\n/* Card */\n.lh-scorecards {\n  display: flex;\n  flex-wrap: wrap;\n}\n.lh-scorecard {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex: 0 0 calc(12 * var(--body-font-size));\n  flex-direction: column;\n  padding: var(--default-padding);\n  padding-top: calc(32px + var(--default-padding));\n  border-radius: 3px;\n  margin-right: var(--default-padding);\n  position: relative;\n  line-height: inherit;\n  border: 1px solid #ebebeb;\n}\n.lh-scorecard__title {\n  background-color: #eee;\n  position: absolute;\n  top: 0;\n  right: 0;\n  left: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: calc(var(--default-padding) / 2);\n}\n.lh-scorecard__value {\n  font-size: calc(1.6 * var(--body-font-size));\n}\n.lh-scorecard__target {\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n/* Score */\n\n.lh-score {\n  display: flex;\n  align-items: flex-start;\n}\n\n.lh-score__value {\n  flex: none;\n  margin-left: var(--lh-score-margin);\n  width: calc(var(--lh-audit-score-width) - var(--lh-score-margin));\n  position: relative;\n  font-weight: bold;\n  top: 1px;\n  text-align: right;\n}\n\n.lh-score__value::after {\n  content: '';\n  position: absolute;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  border-radius: inherit;\n  width: 16px;\n}\n\n.lh-score--informative .lh-score__value {\n  color: var(--informative-color);\n  border-radius: 50%;\n  top: 3px;\n}\n\n.lh-score--informative .lh-score__value::after {\n  display: none;\n  background: url('data:image/svg+xml;utf8,<svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>info</title><path d=\"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z\" fill=\"hsl(218, 89%, 41%)\"/></svg>') no-repeat 50% 50%;\n  background-size: var(--lh-score-icon-background-size);\n}\n\n.lh-score--manual .lh-score__value::after {\n  background: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>manual</title><path d=\"M2 5h8v2H2z\" fill=\"hsl(0, 0%, 100%)\" fill-rule=\"evenodd\"/></svg>') no-repeat 50% 50%;\n  background-size: 18px;\n  background-color: var(--manual-color);\n  width: 20px;\n  height:  20px;\n  position: relative;\n}\n\n.lh-score__value--binary {\n  color: transparent !important;\n}\n\n/* No icon for audits with number scores. */\n.lh-score__value:not(.lh-score__value--binary)::after {\n  content: none;\n}\n\n.lh-score__value--pass {\n  color: var(--pass-color);\n}\n\n.lh-score__value--pass::after {\n  background: var(--pass-icon-url) no-repeat center center / 12px 12px;\n}\n\n.lh-score__value--average {\n  color: var(--average-color);\n}\n\n.lh-score__value--average::after {\n  background: none;\n  content: '!';\n  color: var(--average-color);\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  font-weight: 500;\n  font-size: 15px;\n}\n\n.lh-score__value--fail {\n  color: var(--fail-color);\n}\n\n.lh-score__value--fail::after {\n  background: var(--fail-icon-url) no-repeat center center / 12px 12px;\n}\n\n.lh-score__description {\n  font-size: var(--body-font-size);\n  color: var(--secondary-text-color);\n  line-height: var(--body-line-height);\n}\n\n.lh-score__snippet {\n  align-items: center;\n  justify-content: space-between;\n  /*outline: none;*/\n}\n\n.lh-score__snippet::-moz-list-bullet {\n  display: none;\n}\n\n.lh-score__title {\n  flex: 1;\n}\n\n.lh-toggle-arrow {\n  background: var(--collapsed-icon-url) no-repeat center center / 12px 12px;\n  background-color: transparent;\n  width: 12px;\n  height: 12px;\n  flex: none;\n  transition: transform 150ms ease-in-out;\n  cursor: pointer;\n  border: none;\n  order: -1;\n  margin-right: calc(var(--expandable-indent) - 12px);\n  align-self: flex-start;\n}\n\n.lh-toggle-arrow-unexpandable {\n  visibility: hidden;\n}\n\n/* Expandable Details (Audit Groups, Audits) */\n\n.lh-score__header {\n  order: -1;\n  flex: 1;\n}\n\n.lh-expandable-details {\n  padding-left: var(--expandable-indent);\n}\n\n.lh-expandable-details__summary {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n  margin-left: calc(0px - var(--expandable-indent));\n}\n\n.lh-expandable-details[open] > .lh-expandable-details__summary > .lh-toggle-arrow {\n  background-image: var(--expanded-icon-url);\n}\n\n.lh-audit-group__summary::-webkit-details-marker,\n.lh-expandable-details__summary::-webkit-details-marker {\n  display: none;\n}\n\n.lh-score__snippet .lh-toggle-arrow {\n  margin-top: calc((var(--body-line-height) - 12px) / 2);\n}\n\n/* Perf Timeline */\n\n.lh-timeline {\n  padding: 0;\n  padding-bottom: 0;\n  min-width: calc(var(--lh-filmstrip-thumbnail-width) * 10 + var(--default-padding) * 2);\n}\n\n.lh-narrow .lh-timeline-container {\n  width: calc(100vw - var(--section-padding) * 2);\n  overflow-x: scroll;\n}\n\n.lh-devtools .lh-timeline-container {\n  width: 100%;\n  overflow-x: scroll;\n}\n\n/* Perf Timeline Metric */\n\n.lh-timeline-metric {\n  position: relative;\n  margin-bottom: calc(2 * var(--lh-audit-vpadding));\n  padding-top: var(--lh-audit-vpadding);\n  border-top: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-timeline-metric__header {\n  display: flex;\n}\n\n.lh-timeline-metric__details {\n  order: -1;\n}\n\n.lh-timeline-metric__title {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n  display: flex;\n}\n\n.lh-timeline-metric__name {\n  flex: 1;\n}\n\n.lh-timeline-metric__description {\n  color: var(--secondary-text-color);\n}\n\n.lh-timeline-metric__value {\n  width: var(--lh-audit-score-width);\n  text-align: right;\n}\n\n.lh-timeline-metric--pass .lh-timeline-metric__value {\n  color: var(--pass-color);\n}\n\n.lh-timeline-metric--average .lh-timeline-metric__value {\n  color: var(--average-color);\n}\n\n.lh-timeline-metric--fail .lh-timeline-metric__value {\n  color: var(--fail-color);\n}\n\n.lh-timeline-metric__sparkline {\n  position: absolute;\n  left: 0;\n  right: 0;\n  top: -1px;\n  height: 3px;\n  width: 100%;\n}\n\n.lh-timeline-metric__sparkline .lh-sparkline__bar {\n  float: none;\n}\n\n.lh-timeline-metric--pass .lh-sparkline__bar {\n  background: var(--pass-color);\n}\n\n.lh-timeline-metric--average .lh-sparkline__bar {\n  background: var(--average-color);\n}\n\n.lh-timeline-metric--fail .lh-sparkline__bar {\n  background: var(--fail-color);\n}\n\n.lh-timeline-metric .lh-debug {\n  margin-left: var(--expandable-indent);\n}\n\n/* Perf Hint */\n\n.lh-perf-hint {\n  padding-top: var(--lh-audit-vpadding);\n  padding-bottom: var(--lh-audit-vpadding);\n  border-top: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-perf-hint:last-of-type {\n  border-bottom: none;\n}\n\n.lh-perf-hint__summary {\n  display: flex;\n  align-items: flex-start;\n  flex-wrap: wrap;\n  min-height: calc(var(--body-line-height) + var(--caption-line-height));\n}\n\n.lh-perf-hint__summary .lh-toggle-arrow {\n  margin-top: calc((var(--subheader-line-height) - 12px) / 2);\n}\n\n.lh-perf-hint__summary .lh-debug {\n  width: calc(100% - var(--expandable-indent));\n  margin: 0 var(--expandable-indent);\n}\n\n.lh-perf-hint__title {\n  font-size: var(--body-font-size);\n  flex: 10;\n}\n\n.lh-perf-hint__sparkline {\n  flex: 0 0 50%;\n  margin-top: calc((var(--body-line-height) - var(--lh-sparkline-height)) / 2);\n}\n\n.lh-perf-hint__sparkline .lh-sparkline {\n  width: 100%;\n  float: right;\n  margin: 0;\n}\n\n.lh-perf-hint__stats {\n  text-align: right;\n  flex: 0 0 var(--lh-audit-score-width);\n}\n\n.lh-perf-hint__primary-stat {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n}\n\n.lh-perf-hint__secondary-stat {\n  font-size: var(--caption-font-size);\n  line-height: var(--caption-line-height);\n}\n\n.lh-perf-hint__description {\n  color: var(--secondary-text-color);\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n.lh-perf-hint--pass .lh-perf-hint__stats {\n  color: var(--pass-color);\n}\n\n.lh-perf-hint--pass .lh-sparkline__bar {\n  background: var(--pass-color);\n}\n\n.lh-perf-hint--average .lh-sparkline__bar {\n  background: var(--average-color);\n}\n\n.lh-perf-hint--average .lh-perf-hint__stats {\n  color: var(--average-color);\n}\n\n.lh-perf-hint--fail .lh-sparkline__bar {\n  background: var(--fail-color);\n}\n\n.lh-perf-hint--fail .lh-perf-hint__stats {\n  color: var(--fail-color);\n}\n\n/* Filmstrip */\n\n.lh-filmstrip {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  padding-bottom: var(--default-padding);\n}\n\n.lh-filmstrip__frame {\n  text-align: center;\n}\n\n.lh-filmstrip__timestamp {\n  margin-bottom: calc(0.5 * var(--caption-line-height));\n  font-size: var(--caption-font-size);\n  line-height: var(--caption-line-height);\n}\n\n.lh-filmstrip__thumbnail {\n  border: 1px solid var(--report-secondary-border-color);\n  max-height: 100px;\n}\n\n/* Sparkline */\n\n.lh-sparkline {\n  margin: 5px;\n  height: var(--lh-sparkline-height);\n  width: 100%;\n}\n\n.lh-sparkline--thin {\n  height: calc(var(--lh-sparkline-height) / 2);\n}\n\n.lh-sparkline__bar {\n  background: var(--warning-color);\n  height: 100%;\n  float: right;\n}\n\n/* Audit */\n\n.lh-audit {\n  margin-bottom: var(--lh-audit-vpadding);\n  padding-top: var(--lh-audit-vpadding);\n  border-top: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-audit:last-of-type {\n  border-bottom: none;\n}\n\n.lh-audit > .lh-score {\n  font-size: var(--body-font-size);\n}\n\n.lh-audit .lh-debug {\n  margin-left: var(--expandable-indent);\n  margin-right: var(--lh-audit-score-width);\n}\n\n/* Audit Group */\n\n.lh-audit-group {\n  padding-top: var(--lh-audit-group-vpadding);\n  border-top: 1px solid var(--report-secondary-border-color);\n  padding-left: var(--expandable-indent);\n}\n\n.lh-audit-group__header {\n  font-size: var(--subheader-font-size);\n  line-height: var(--subheader-line-height);\n}\n\n.lh-audit-group__summary {\n  display: flex;\n  align-items: center;\n  margin-bottom: var(--lh-audit-group-vpadding);\n  margin-left: calc(0px - var(--expandable-indent));\n}\n\n.lh-audit-group__summary .lh-toggle-arrow {\n  margin-top: calc((var(--subheader-line-height) - 12px) / 2);\n}\n\n.lh-audit-group__description {\n  font-size: var(--body-font-size);\n  color: var(--secondary-text-color);\n  margin-top: calc(0px - var(--lh-audit-group-vpadding));\n  margin-bottom: var(--lh-audit-group-vpadding);\n  line-height: var(--body-line-height);\n}\n\n\n.lh-debug {\n  font-size: var(--caption-font-size);\n  line-height: var(--caption-line-height);\n  color: var(--fail-color);\n  margin-top: 3px;\n}\n\n.lh-debug::before {\n  display: none;\n  content: '';\n  background: url('data:image/svg+xml;utf8,<svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>warn</title><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z\" fill=\"hsl(40, 100%, 50%)\"/></svg>') no-repeat 50% 50%;\n  background-size: contain;\n  width: 20px;\n  height: 20px;\n  position: relative;\n  margin-right: calc(var(--default-padding) / 2);\n  top: 5px;\n}\n\n\n/* Report */\n\n.lh-container {\n  display: flex;\n  max-width: var(--report-content-width);\n  word-wrap: break-word;\n  margin: 0 auto;\n}\n\n.lh-report {\n  margin-left: var(--report-menu-width);\n  background-color: #fff;\n  padding-top: var(--report-header-height);\n}\n@media screen {\n  .lh-report {\n    width: var(--report-width);\n  }\n}\n\n.lh-exception {\n  font-size: large;\n}\n\n.lh-text__url {\n  white-space: nowrap;\n}\n\n.lh-code {\n  text-overflow: ellipsis;\n  white-space: pre-line;\n  margin-top: 0;\n}\n\n.lh-scores-header {\n  display: flex;\n  justify-content: center;\n  overflow-x: hidden;\n  padding: var(--section-padding);\n  border-bottom: 1px solid var(--report-border-color);\n}\n.lh-scores-header__solo {\n  padding: 0;\n  border: 0;\n}\n\n.lh-categories {\n  width: 100%;\n  overflow: hidden;\n}\n\n.lh-category {\n  padding: var(--section-padding);\n  border-top: 1px solid var(--report-border-color);\n}\n\n/* section hash link jump should preserve fixed header\n   https://css-tricks.com/hash-tag-links-padding/\n*/\n.lh-category > .lh-permalink {\n  margin-top: calc((var(--report-header-height) + var(--default-padding)) * -1);\n  padding-bottom: calc(var(--report-header-height) + var(--default-padding));\n  display: block;\n  visibility: hidden;\n}\n\n.lh-category:first-of-type {\n  border: none;\n}\n\n.lh-category > .lh-score {\n  font-size: var(--header-font-size);\n  padding-bottom: var(--lh-section-vpadding);\n}\n\n.lh-category > .lh-score .lh-score__value,\n.lh-category > .lh-score .lh-score__gauge .lh-gauge__label {\n  display: none;\n}\n\n.lh-category .lh-score__gauge {\n  margin-left: var(--section-indent);\n  flex-basis: var(--circle-size);\n  flex-shrink: 0;\n}\n\n.lh-category .lh-score__gauge .lh-gauge {\n  --circle-size: calc(2.5 * var(--header-font-size));\n}\n\n/* Category snippet shouldnt have pointer cursor. */\n.lh-category > .lh-score .lh-score__snippet {\n  cursor: initial;\n}\n\n.lh-category > .lh-score .lh-score__title {\n  font-size: var(--header-font-size);\n  line-height: var(--header-line-height);\n}\n\n.lh-passed-audits[open] summary.lh-passed-audits-summary {\n  margin-bottom: calc(var(--default-padding) * 2);\n}\n\nsummary.lh-passed-audits-summary {\n  margin: calc(var(--default-padding) * 2) var(--default-padding);\n  margin-left: var(--default-padding);\n  margin-bottom: 0;\n  font-size: 15px;\n  display: flex;\n  align-items: center;\n}\n\n#lh-log {\n  position: fixed;\n  background-color: #323232;\n  color: #fff;\n  min-height: 48px;\n  min-width: 288px;\n  padding: 16px 24px;\n  box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);\n  border-radius: 2px;\n  margin: 12px;\n  font-size: 14px;\n  cursor: default;\n  transition: transform 0.3s, opacity 0.3s;\n  transform: translateY(100px);\n  opacity: 0;\n  -webkit-font-smoothing: antialiased;\n  bottom: 0;\n  left: 0;\n  z-index: 3;\n}\n\n#lh-log.show {\n  opacity: 1;\n  transform: translateY(0);\n}\n\n/* 964 fits the min-width of the filmstrip */\n@media screen and (max-width: 964px) {\n  .lh-report {\n    margin-left: 0;\n    width: 100%;\n    min-width: 400px;\n  }\n}\n\n@media print {\n  body {\n    -webkit-print-color-adjust: exact; /* print background colors */\n  }\n  .lh-container {\n    display: block;\n  }\n  .lh-report {\n    margin-left: 0;\n    padding-top: 0;\n  }\n  .lh-categories {\n    margin-top: 0;\n  }\n}\n\n.lh-table {\n  --image-preview-size: 24px;\n  border: 1px solid var(--report-secondary-border-color);\n  border-collapse: collapse;\n  table-layout: fixed;\n  width: 100%;\n}\n\n.lh-table thead {\n  background: var(--lh-table-header-bg);\n}\n\n.lh-table tbody tr:nth-child(even) {\n  background-color: var(--lh-table-higlight-bg);\n}\n\n.lh-table th,\n.lh-table td {\n  padding: 10px;\n  overflow: auto;\n}\n\n.lh-table-column--text {\n  text-align: right;\n}\n\n.lh-table-column--thumbnail {\n  width: calc(var(--image-preview-size) * 2);\n}\n\n.lh-table-column--url {\n  text-align: left;\n  min-width: 250px;\n  white-space: nowrap;\n}\n\n.lh-thumbnail {\n  height: var(--image-preview-size);\n  width: var(--image-preview-size);\n  object-fit: contain;\n}\n\n/*# sourceURL=report.styles.css */\n";const REPORT_TEMPLATES="<!-- Lighthouse category score -->\n<template id=\"tmpl-lh-category-score\">\n  <div class=\"lh-score\">\n    <div class=\"lh-score__value\"><!-- fill me --></div>\n    <div class=\"lh-score__gauge\"></div>\n    <div class=\"lh-score__header\">\n      <div class=\"lh-score__snippet\">\n        <span class=\"lh-score__title\"><!-- fill me --></span>\n      </div>\n      <div class=\"lh-score__description\"><!-- fill me --></div>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse audit score -->\n<template id=\"tmpl-lh-audit-score\">\n  <div class=\"lh-score\">\n    <div class=\"lh-score__value\"><!-- fill me --></div>\n    <details class=\"lh-score__header lh-expandable-details\">\n      <summary class=\"lh-score__snippet lh-expandable-details__summary\">\n        <span class=\"lh-score__title\"><!-- fill me --></span>\n        <div class=\"lh-toggle-arrow\" title=\"See audits\"></div>\n      </summary>\n      <div class=\"lh-score__description\"><!-- fill me --></div>\n    </details>\n  </div>\n</template>\n\n<!-- Lighthouse timeline metric -->\n<template id=\"tmpl-lh-timeline-metric\">\n  <div class=\"lh-timeline-metric\">\n    <div class=\"lh-timeline-metric__sparkline\">\n      <div class=\"lh-sparkline__bar\"></div>\n    </div>\n    <div class=\"lh-timeline-metric__header\">\n      <div class=\"lh-timeline-metric__value\"><!-- fill me --></div>\n      <details class=\"lh-timeline-metric__details lh-expandable-details\">\n        <summary class=\"lh-timeline-metric__summary lh-expandable-details__summary\">\n          <span class=\"lh-timeline-metric__title\"><!-- fill me --></span>\n          <div class=\"lh-toggle-arrow\" title=\"See audits\"></div>\n        </summary>\n        <div class=\"lh-timeline-metric__description\"><!-- fill me --></div>\n      </details>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse left nav -->\n<template id=\"tmpl-lh-leftnav\">\n  <style>\n    .lh-leftnav {\n      width: var(--report-menu-width);\n      border-right: 1px solid var(--report-border-color);\n      position: fixed;\n      height: 100%;\n      background: #fff;\n      will-change: transform; /* prevent excessive paints */\n      z-index: 2;\n    }\n    .lh-leftnav__item {\n      padding: var(--navitem-vpadding) var(--navitem-hpadding);\n      color: var(--secondary-text-color);\n      font-size: var(--navitem-font-size);\n      line-height: var(--navitem-line-height);\n      display: flex;\n      justify-content: space-between;\n      text-decoration: none;\n      color: inherit;\n    }\n    .leftnav-item__score {\n      background: transparent;\n    }\n    .leftnav-item__score::after {\n      content: '';\n    }\n    .leftnav-item__score.lh-score__value--pass {\n      color: var(--pass-color);\n    }\n    .leftnav-item__score.lh-score__value--average {\n      color: var(--average-color);\n    }\n    .leftnav-item__score.lh-score__value--fail {\n      color: var(--fail-color);\n    }\n    .leftnav__header {\n      padding: 0 20px;\n      margin-bottom: var(--navitem-vpadding);\n      height: 115px;\n      font-size: 18px;\n      display: flex;\n      flex-direction: column;\n      justify-content: center;\n      background: url(data:image/png;base64,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) no-repeat 150% 100%;\n      background-color: #2238b3;\n      background-size: 205px;\n      background-blend-mode: luminosity;\n    }\n    .leftnav__header__title {\n      font-family: var(--text-font-family);\n      font-size: var(--title-font-size);\n      line-height: var(--title-line-height);\n      font-weight: 300;\n      color: #fff;\n      margin: 0;\n      padding: 0;\n    }\n    .leftnav__header__version {\n      color: #aab3ed;\n      font-family: var(--text-font-family);\n      font-size: var(--body-font-size);\n      line-height: var(--body-line-height);\n    }\n    @media screen and (max-width: 964px) {\n      .lh-leftnav {\n        display: none;\n      }\n    }\n    @media print {\n      .lh-leftnav {\n        display: none;\n      }\n    }\n  </style>\n  <nav class=\"lh-leftnav\">\n    <div class=\"leftnav__header\">\n      <h1 class=\"leftnav__header__title\">Lighthouse</h1>\n      <div class=\"leftnav__header__version\"><!-- fill me --></div>\n    </div>\n    <template id=\"tmpl-lh-leftnav__items\">\n      <a href=\"#\" class=\"lh-leftnav__item\">\n        <span class=\"leftnav-item__category\"><!-- fill me --></span>\n        <span class=\"leftnav-item__score\"><!-- fill me --></span>\n      </a>\n    </template>\n  </nav>\n</template>\n\n<!-- Lighthouse header -->\n<template id=\"tmpl-lh-heading\">\n  <style>\n    :root {\n      --report-header-height: 58px;\n      --report-header-bg-color: #fafafa;\n    }\n    .lh-header {\n      display: flex;\n      height: var(--report-header-height);\n      left: 0;\n      right: 0;\n      max-width: 100%; /* support text-overflow on url */\n      border-bottom: 1px solid var(--report-secondary-border-color);\n      position: fixed;\n      z-index: 1;\n      will-change: transform;\n      background-color: var(--report-header-bg-color);\n      margin-left: var(--report-menu-width);\n      align-items: center;\n      padding: 0 calc(var(--default-padding) * 2);\n    }\n    .lh-metadata {\n      flex: 1 1 0;\n      padding-right: calc(var(--default-padding) / 2);\n      line-height: 20px;\n      color: var(--secondary-text-color);\n      overflow-x: hidden;\n    }\n    .lh-metadata__results {\n      overflow: hidden;\n      text-overflow: ellipsis;\n      white-space: nowrap;\n    }\n    .lh-metadata__url {\n      color: currentColor;\n    }\n    .lh-export {\n      position: relative;\n    }\n    .lh-export__button {\n      background-color: #fff;\n      border: 1px solid var(--report-border-color);\n      border-radius: 3px;\n      cursor: pointer;\n      outline: none;\n      height: 32px;\n      width: 48px;\n      background-repeat: no-repeat;\n      background-size: 20px;\n      background-position: 50% 50%;\n    }\n    .lh-export__button:focus,\n    .lh-export__button.active {\n      box-shadow: 1px 1px 3px #ccc;\n    }\n    .lh-export__button.active + .lh-export__dropdown {\n      opacity: 1;\n      clip: rect(0, 164px, 200px, 0);\n    }\n    .lh-export__dropdown {\n      position: absolute;\n      background-color: #fff;\n      border: 1px solid var(--report-border-color);\n      border-radius: 3px;\n      padding: calc(var(--default-padding) / 2) 0;\n      cursor: pointer;\n      top: 36px;\n      right: 0;\n      box-shadow: 1px 1px 3px #ccc;\n      min-width: 125px;\n      clip: rect(0, 164px, 0, 0);\n      opacity: 0;\n      transition: all 200ms cubic-bezier(0,0,0.2,1);\n    }\n    .lh-export__dropdown a {\n      display: block;\n      color: currentColor;\n      text-decoration: none;\n      white-space: nowrap;\n      padding: 0 12px;\n      line-height: 2;\n    }\n    .lh-export__dropdown a:hover,\n    .lh-export__dropdown a:focus {\n      background-color: #efefef;\n      outline: none;\n    }\n    .lh-export__dropdown .report-icon {\n      cursor: pointer;\n      background-repeat: no-repeat;\n      background-position: 8px 50%;\n      background-size: 18px;\n      background-color: transparent;\n      text-indent: 18px;\n    }\n    /* copy icon needs slight adjustments to look great */\n    .lh-export__dropdown .report-icon--copy {\n      background-size: 16px;\n      background-position: 9px 50%;\n    }\n    /* save-as-gist option hidden in report */\n    .lh-export__dropdown .lh-export--gist {\n      display: none;\n    }\n    .lh-config {\n      display: flex;\n    }\n    .lh-env {\n      padding: var(--default-padding) 0 var(--default-padding) calc(var(--default-padding) * 2);\n      left: 0;\n      top: 100%;\n      position: absolute;\n      width: 100%;\n      background-color: var(--report-header-bg-color);\n      border-top: 1px solid var(--report-secondary-border-color);\n      border-bottom: 1px solid var(--report-secondary-border-color);\n    }\n    .lh-env__title {\n      font-size: var(--header-font-size);\n    }\n    .lh-env__items {\n      margin: var(--default-padding) 0 0 0;\n    }\n    .lh-config__timestamp {\n      margin-right: 6px;\n    }\n    .lh-config__settings-toggle {\n      margin-left: 6px;\n    }\n    .lh-config__timestamp,\n    .lh-config__settings-toggle summary {\n      color: var(--secondary-text-color);\n    }\n    .lh-config__settings-toggle summary {\n      display: flex;\n      align-items: center;\n    }\n    .lh-config__settings-toggle .lh-toggle-arrow {\n      width: 16px;\n      height: 16px;\n      margin-left: 2px;\n    }\n    .lh-config__settings-toggle[open] .lh-toggle-arrow {\n      transform: rotateZ(90deg);\n    }\n    .lh-config__settings-toggle summary::-moz-list-bullet {\n      display: none;\n    }\n    .lh-config__settings-toggle summary::-webkit-details-marker {\n      display: none;\n    }\n    @media screen and (min-width: 965px) {\n      .lh-header {\n        width: var(--report-width);\n        right: initial;\n        left: initial;\n      }\n    }\n    @media screen and (max-width: 964px) {\n      .lh-export__dropdown {\n        right: 0;\n        left: initial;\n      }\n      .lh-header {\n        padding: 0 var(--default-padding);\n        margin-left: 0;\n      }\n    }\n    @media print {\n      .lh-header {\n        position: static;\n        margin-left: 0;\n      }\n    }\n  </style>\n  <div class=\"lh-header\">\n    <div class=\"lh-metadata\">\n      <div class=\"lh-metadata__results\">Results for: <a href=\"\" class=\"lh-metadata__url\" target=\"_blank\" rel=\"noopener\"><!-- fill me --></a></div>\n      <div class=\"lh-config\">\n        <span class=\"lh-config__timestamp\"><!-- fill me --></span> &bullet;\n        <details class=\"lh-config__settings-toggle\">\n          <summary>\n            <span>Runtime settings</span>\n            <span class=\"lh-toggle-arrow\" title=\"See report's runtime settings\"></span>\n          </summary>\n          <div class=\"lh-env\">\n            <div class=\"lh-env__title\">Runtime environment</div>\n            <ul class=\"lh-env__items\">\n              <li class=\"lh-env__item\">\n                <span class=\"lh-env__name\">User agent:</span>\n                <b class=\"lh-env__item__ua\"><!-- fill me --></b>\n              </li>\n              <template id=\"tmpl-lh-env__items\">\n                <li class=\"lh-env__item\">\n                  <span class=\"lh-env__name\"><!-- fill me --></span>\n                  <span class=\"lh-env__description\"><!-- fill me --></span>:\n                  <b class=\"lh-env__enabled\"><!-- fill me --></b>\n                </li>\n              </template>\n            </ul>\n          </div>\n        </details>\n      </div>\n    </div>\n    <div class=\"lh-export\">\n      <button class=\"report-icon report-icon--share lh-export__button\" title=\"Export report\"></button>\n      <div class=\"lh-export__dropdown\">\n        <a href=\"#\" class=\"report-icon report-icon--print\" data-action=\"print\">Print...</a>\n        <a href=\"#\" class=\"report-icon report-icon--copy\" data-action=\"copy\">Copy JSON</a>\n        <a href=\"#\" class=\"report-icon report-icon--download\" data-action=\"save-html\">Save as HTML</a>\n        <a href=\"#\" class=\"report-icon report-icon--download\" data-action=\"save-json\">Save as JSON</a>\n        <a href=\"#\" class=\"report-icon report-icon--open lh-export--viewer\" data-action=\"open-viewer\">Open in Viewer</a>\n        <a href=\"#\" class=\"report-icon report-icon--open lh-export--gist\" data-action=\"save-gist\">Save as Gist</a>\n      </div>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse footer -->\n<template id=\"tmpl-lh-footer\">\n  <style>\n    .lh-footer {\n      min-height: 90px;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      background-color: var(--report-header-bg-color);\n      border-top: 1px solid var(--report-secondary-border-color);\n    }\n\n    .lh-footer span {\n      text-align: center;\n    }\n  </style>\n  <footer class=\"lh-footer\">\n    <span>\n      Generated by <b>Lighthouse</b> <span class=\"lh-footer__version\"><!-- fill me --></span> on\n      <span class=\"lh-footer__timestamp\"><!-- fill me --></span> |\n      <a href=\"https://github.com/GoogleChrome/Lighthouse/issues\" target=\"_blank\" rel=\"noopener\">File an issue</a>\n    </span>\n  </footer>\n</template>\n\n<!-- Lighthouse score gauge -->\n<template id=\"tmpl-lh-gauge\">\n  <style>\n    .lh-gauge {\n      --circle-size: calc(2.5 * var(--header-font-size));\n      --circle-size-half: calc(var(--circle-size) / 2);\n      --circle-background: #ccc;\n      --circle-border-width: 2px;\n      --inset-size: calc(var(--circle-size) - 2 * var(--circle-border-width));\n      --inset-color: #fff;\n      --transition-length: 1s;\n      width: var(--circle-size);\n      height: var(--circle-size);\n      background-color: var(--circle-background);\n      border-radius: 50%;\n    }\n    .lh-gauge--pass {\n      --circle-color: var(--pass-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge--average {\n      --circle-color: var(--average-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge--fail {\n      --circle-color: var(--fail-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge__mask,\n    .lh-gauge__fill {\n      width: var(--circle-size);\n      height: var(--circle-size);\n      position: absolute;\n      transition: transform var(--transition-length);\n      border-radius: 50%;\n    }\n    .lh-gauge__mask {\n      clip: rect(0px, var(--circle-size), var(--circle-size), var(--circle-size-half));\n    }\n    .lh-gauge__mask .lh-gauge__fill {\n      clip: rect(0px, var(--circle-size-half), var(--circle-size), 0px);\n      background-color: var(--circle-color);\n      backface-visibility: hidden;\n    }\n    .lh-gauge__percentage {\n      --spacer: calc((var(--circle-size) - var(--inset-size)) / 2);\n      width: var(--inset-size);\n      height: var(--inset-size);\n      position: absolute;\n      margin-left: var(--spacer);\n      margin-top: var(--spacer);\n      background-color: var(--inset-color);\n      border-radius: inherit;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      font-size: var(--header-font-size);\n    }\n    .lh-gauge__wrapper {\n      display: inline-flex;\n      align-items: center;\n      flex-direction: column;\n      text-decoration: none;\n      color: inherit;\n      flex: 1;\n      min-width: auto;\n      position: relative;\n    }\n    .lh-scores-header .lh-gauge__wrapper {\n      width: calc(10.5 * var(--body-font-size));\n    }\n    .lh-gauge__label {\n      font-size: var(--body-font-size);\n      line-height: var(--body-line-height);\n      margin-top: calc(0.5 * var(--body-line-height));\n    }\n  </style>\n  <a href=\"#\" class=\"lh-gauge__wrapper\">\n    <div class=\"lh-gauge\" data-progress=\"0\">\n      <div class=\"lh-gauge__circle\">\n        <div class=\"lh-gauge__mask lh-gauge__mask--full\">\n          <div class=\"lh-gauge__fill\"></div>\n        </div>\n        <div class=\"lh-gauge__mask lh-gauge__mask--half\">\n          <div class=\"lh-gauge__fill\"></div>\n          <div class=\"lh-gauge__fill lh-gauge__fill--fix\"></div>\n        </div>\n      </div>\n      <div class=\"lh-gauge__percentage\"></div>\n    </div>\n    <div class=\"lh-gauge__label\"><!-- fill me --></div>\n  </a>\n</template>\n\n<!-- Lighthouse crtiical request chains component -->\n<template id=\"tmpl-lh-crc\">\n  <style>\n    .lh-crc .tree-marker {\n      width: 12px;\n      height: 26px;\n      display: block;\n      float: left;\n      background-position: top left;\n    }\n    .lh-crc .horiz-down {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"#D8D8D8\" fill-rule=\"evenodd\"><path d=\"M16 12v2H-2v-2z\"/><path d=\"M9 12v14H7V12z\"/></g></svg>');\n    }\n    .lh-crc .right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 12v2H0v-2z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .up-right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v14H7zm2 12h7v2H9z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .vert-right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v27H7zm2 12h7v2H9z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .vert {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v26H7z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .crc-tree {\n      font-size: 14px;\n      width: 100%;\n      overflow-x: auto;\n    }\n    .lh-crc .crc-node {\n      height: 26px;\n      line-height: 26px;\n      white-space: nowrap;\n    }\n    .lh-crc .crc-node__tree-value {\n      margin-left: 10px;\n    }\n    .lh-crc .crc-node__chain-duration {\n      font-weight: 700;\n    }\n    .lh-crc .crc-node__tree-hostname {\n      color: #595959;\n    }\n    .lh-crc .crc-initial-nav {\n      color: #595959;\n      font-style: italic;\n    }\n  </style>\n  <div class=\"lh-score__description\">\n    Longest chain: <b class=\"lh-crc__longest_duration\"><!-- fill me: longestChain.duration --></b>\n    over <b class=\"lh-crc__longest_length\"><!-- fill me: longestChain.length --></b> requests, totalling\n    <b class=\"lh-crc__longest_transfersize\"><!-- fill me: longestChain.length --></b>\n  </div>\n  <div class=\"lh-crc\">\n    <details class=\"lh-details\">\n      <summary><!-- fill me --></summary>\n      <div class=\"crc-initial-nav\">Initial Navigation</div>\n      <!-- stamp for each chain -->\n      <template id=\"tmpl-lh-crc__chains\">\n        <div class=\"crc-node\">\n          <span class=\"crc-node__tree-marker\">\n            <!-- fill me -->\n          </span>\n          <span class=\"crc-node__tree-value\">\n            <span class=\"crc-node__tree-file\"><!-- fill me: node.request.url.file --></span>\n            <span class=\"crc-node__tree-hostname\">(<!-- fill me: node.request.url.host -->)</span>\n            <!-- fill me -->\n          </span>\n        </div>\n      </template>\n    </details>\n  </div>\n</template>\n";class ReportGeneratorV2{static get reportJs(){return REPORT_JAVASCRIPT;}
static get reportCss(){return REPORT_CSS;}
static get reportTemplates(){return REPORT_TEMPLATES;}
static arithmeticMean(items){const results=items.reduce((result,item)=>{const score=Number(item.score)||0;const weight=Number(item.weight)||0;return{weight:result.weight+weight,sum:result.sum+score*weight};},{weight:0,sum:0});return results.sum/results.weight||0;}
static replaceStrings(source,replacements){if(replacements.length===0){return source;}
const firstReplacement=replacements[0];const nextReplacements=replacements.slice(1);return source.split(firstReplacement.search).map(part=>ReportGeneratorV2.replaceStrings(part,nextReplacements)).join(firstReplacement.replacement);}
generateReportJson(config,resultsByAuditId){const categories=Object.keys(config.categories).map(categoryId=>{const category=config.categories[categoryId];category.id=categoryId;const audits=category.audits.map(audit=>{const result=resultsByAuditId[audit.id];let auditScore=Number(result.score)||0;if(typeof result.score==='boolean'){auditScore=result.score?100:0;}
return Object.assign({},audit,{result,score:auditScore});});const categoryScore=ReportGeneratorV2.arithmeticMean(audits);return Object.assign({},category,{audits,score:categoryScore});});const overallScore=ReportGeneratorV2.arithmeticMean(categories);return{score:overallScore,categories};}
generateReportHtml(reportAsJson){const sanitizedJson=JSON.stringify(reportAsJson).replace(/</g,'\\u003c');const sanitizedJavascript=REPORT_JAVASCRIPT.replace(/<\//g,'\\u003c/');return ReportGeneratorV2.replaceStrings(REPORT_TEMPLATE,[{search:'%%LIGHTHOUSE_JSON%%',replacement:sanitizedJson},{search:'%%LIGHTHOUSE_JAVASCRIPT%%',replacement:sanitizedJavascript},{search:'/*%%LIGHTHOUSE_CSS%%*/',replacement:REPORT_CSS},{search:'%%LIGHTHOUSE_TEMPLATES%%',replacement:REPORT_TEMPLATES}]);}}
module.exports=ReportGeneratorV2;},{}],34:[function(require,module,exports){(function(process,__dirname){'use strict';const Driver=require('./gather/driver.js');const GatherRunner=require('./gather/gather-runner');const ReportGeneratorV2=require('./report/v2/report-generator');const Audit=require('./audits/audit');const emulation=require('./lib/emulation');const log=require('lighthouse-logger');const path=require('path');const URL=require('./lib/url-shim');class Runner{static run(connection,opts){opts.flags=opts.flags||{};const config=opts.config;opts.initialUrl=opts.url;if(typeof opts.initialUrl!=='string'||opts.initialUrl.length===0){return Promise.reject(new Error('You must provide a url to the runner'));}
let parsedURL;try{parsedURL=new URL(opts.url);}catch(e){const err=new Error('The url provided should have a proper protocol and hostname.');return Promise.reject(err);}
if(parsedURL.protocol!=='https:'&&parsedURL.hostname!=='localhost'){log.warn('Lighthouse','The URL provided should be on HTTPS');log.warn('Lighthouse','Performance stats will be skewed redirecting from HTTP to HTTPS.');}
opts.url=parsedURL.href;const validPassesAndAudits=config.passes&&config.audits;const validArtifactsAndAudits=config.artifacts&&config.audits;let run=Promise.resolve();if(validPassesAndAudits||validArtifactsAndAudits){if(validPassesAndAudits){opts.driver=opts.driverMock||new Driver(connection);run=run.then(_=>GatherRunner.run(config.passes,opts));}else if(validArtifactsAndAudits){run=run.then(_=>config.artifacts);}
run=run.then(artifacts=>{return Object.assign({},artifacts,Runner.instantiateComputedArtifacts());});run=run.then(artifacts=>{for(const passName of Object.keys(artifacts.traces||{})){const trace=artifacts.traces[passName];if(!Array.isArray(trace.traceEvents)){throw new Error(passName+' trace was invalid. `traceEvents` was not an array.');}}
return artifacts;});run=run.then(artifacts=>{log.log('status','Analyzing and running audits...');return artifacts;});const auditResults=[];for(const audit of config.audits){run=run.then(artifacts=>{return Runner._runAudit(audit,artifacts).then(ret=>auditResults.push(ret)).then(_=>artifacts);});}
run=run.then(artifacts=>{return{artifacts,auditResults};});}else if(config.auditResults){const artifacts=Object.assign({},config.artifacts||{},Runner.instantiateComputedArtifacts());run=run.then(_=>{return{artifacts,auditResults:config.auditResults};});}else{const err=Error('The config must provide passes and audits, artifacts and audits, or auditResults');return Promise.reject(err);}
run=run.then(runResults=>{log.log('status','Generating results...');const resultsById=runResults.auditResults.reduce((results,audit)=>{results[audit.name]=audit;return results;},{});let reportCategories=[];let score=0;if(config.categories){const reportGenerator=new ReportGeneratorV2();const report=reportGenerator.generateReportJson(config,resultsById);reportCategories=report.categories;score=report.score;}
return{userAgent:runResults.artifacts.UserAgent,lighthouseVersion:require('../package').version,generatedTime:new Date().toJSON(),initialUrl:opts.initialUrl,url:opts.url,audits:resultsById,artifacts:runResults.artifacts,runtimeConfig:Runner.getRuntimeConfig(opts.flags),score,reportCategories,reportGroups:config.groups};});return run;}
static _runAudit(audit,artifacts){const status=`Evaluating: ${audit.meta.description}`;return Promise.resolve().then(_=>{log.log('status',status);for(const artifactName of audit.meta.requiredArtifacts){const noArtifact=typeof artifacts[artifactName]==='undefined';const noTrace=artifactName==='traces'&&!artifacts.traces[Audit.DEFAULT_PASS];if(noArtifact||noTrace){log.warn('Runner',`${artifactName} gatherer, required by audit ${audit.meta.name}, did not run.`);throw new Error(`Required ${artifactName} gatherer did not run.`);}
if(artifacts[artifactName]instanceof Error){const artifactError=artifacts[artifactName];log.warn('Runner',`${artifactName} gatherer, required by audit ${audit.meta.name},`+` encountered an error: ${artifactError.message}`);throw new Error(`Required ${artifactName} gatherer encountered an error: ${artifactError.message}`);}}
return audit.audit(artifacts);}).then(auditResult=>Audit.generateAuditResult(audit,auditResult)).catch(err=>{log.warn(audit.meta.name,`Caught exception: ${err.message}`);if(err.fatal){throw err;}
return Audit.generateErrorAuditResult(audit,'Audit error: '+err.message);}).then(result=>{log.verbose('statusEnd',status);return result;});}
static getAuditList(){const ignoredFiles=['audit.js','violation-audit.js','accessibility/axe-audit.js','multi-check-audit.js','byte-efficiency/byte-efficiency-audit.js','manual/manual-audit.js'];const fileList=[...["accessibility","audit.js","byte-efficiency","cache-start-url.js","consistently-interactive.js","content-width.js","critical-request-chains.js","deprecations.js","dobetterweb","estimated-input-latency.js","first-interactive.js","first-meaningful-paint.js","is-on-https.js","load-fast-enough-for-pwa.js","manifest-short-name-length.js","manual","multi-check-audit.js","redirects-http.js","screenshot-thumbnails.js","service-worker.js","speed-index-metric.js","splash-screen.js","themed-omnibox.js","time-to-firstbyte.js","user-timings.js","viewport.js","violation-audit.js","webapp-install-banner.js","without-javascript.js","works-offline.js"],...["appcache-manifest.js","dom-size.js","external-anchors-use-rel-noopener.js","geolocation-on-start.js","link-blocking-first-paint.js","no-document-write.js","no-mutation-events.js","no-old-flexbox.js","no-websql.js","notification-on-start.js","password-inputs-can-be-pasted-into.js","script-blocking-first-paint.js","uses-http2.js","uses-passive-event-listeners.js"].map(f=>`dobetterweb/${f}`),...["accesskeys.js","aria-allowed-attr.js","aria-required-attr.js","aria-required-children.js","aria-required-parent.js","aria-roles.js","aria-valid-attr-value.js","aria-valid-attr.js","audio-caption.js","axe-audit.js","button-name.js","bypass.js","color-contrast.js","definition-list.js","dlitem.js","document-title.js","duplicate-id.js","frame-title.js","html-has-lang.js","html-lang-valid.js","image-alt.js","input-image-alt.js","label.js","layout-table.js","link-name.js","list.js","listitem.js","meta-refresh.js","meta-viewport.js","object-alt.js","tabindex.js","td-headers-attr.js","th-has-data-cells.js","valid-lang.js","video-caption.js","video-description.js"].map(f=>`accessibility/${f}`),...["byte-efficiency-audit.js","offscreen-images.js","total-byte-weight.js","unused-css-rules.js","uses-optimized-images.js","uses-request-compression.js","uses-responsive-images.js","uses-webp-images.js"].map(f=>`byte-efficiency/${f}`),...["manual-audit.js","pwa-cross-browser.js","pwa-each-page-has-url.js","pwa-page-transitions.js"].map(f=>`manual/${f}`)];return fileList.filter(f=>{return/\.js$/.test(f)&&!ignoredFiles.includes(f);}).sort();}
static getGathererList(){const fileList=[...["accessibility.js","cache-contents.js","chrome-console-messages.js","css-usage.js","dobetterweb","gatherer.js","html-without-javascript.js","http-redirect.js","image-usage.js","manifest.js","offline.js","service-worker.js","start-url.js","styles.js","theme-color.js","url.js","viewport-dimensions.js","viewport.js"],...["all-event-listeners.js","anchors-with-no-rel-noopener.js","appcache.js","domstats.js","optimized-images.js","password-inputs-with-prevented-paste.js","response-compression.js","tags-blocking-first-paint.js","websql.js"].map(f=>`dobetterweb/${f}`)];return fileList.filter(f=>/\.js$/.test(f)&&f!=='gatherer.js').sort();}
static instantiateComputedArtifacts(){const computedArtifacts={};["computed-artifact.js","critical-request-chains.js","first-interactive.js","manifest-values.js","network-records.js","network-throughput.js","pushed-requests.js","screenshots.js","speedline.js","trace-of-tab.js"].forEach(function(filename){if(filename==='computed-artifact.js')return;filename=filename.replace(/\.js$/,'');const ArtifactClass=require('./gather/computed/'+filename);const artifact=new ArtifactClass(computedArtifacts);computedArtifacts['request'+artifact.name]=artifact.request.bind(artifact);});return computedArtifacts;}
static resolvePlugin(plugin,configDir,category){try{return require.resolve(plugin);}catch(e){}
const cwdPath=path.resolve(process.cwd(),plugin);try{return require.resolve(cwdPath);}catch(e){}
const errorString='Unable to locate '+(category?`${category}: `:'')+`${plugin} (tried to require() from '${__dirname}' and load from '${cwdPath}'`;if(!configDir){throw new Error(errorString+')');}
const relativePath=path.resolve(configDir,plugin);try{return require.resolve(relativePath);}catch(requireError){}
throw new Error(errorString+` and '${relativePath}')`);}
static getRuntimeConfig(flags){const emulationDesc=emulation.getEmulationDesc();const environment=[{name:'Device Emulation',enabled:!flags.disableDeviceEmulation,description:emulationDesc['deviceEmulation']},{name:'Network Throttling',enabled:!flags.disableNetworkThrottling,description:emulationDesc['networkThrottling']},{name:'CPU Throttling',enabled:!flags.disableCpuThrottling,description:emulationDesc['cpuThrottling']}];return{environment,blockedUrlPatterns:flags.blockedUrlPatterns||[]};}}
module.exports=Runner;}).call(this,require('_process'),"/../lighthouse-core");},{"../package":115,"./audits/audit":2,"./gather/driver.js":14,"./gather/gather-runner":15,"./lib/emulation":20,"./lib/url-shim":30,"./report/v2/report-generator":33,"_process":60,"lighthouse-logger":109,"path":58}],35:[function(require,module,exports){'use strict';const ExtensionProtocol=require('../../../lighthouse-core/gather/connections/extension');const RawProtocol=require('../../../lighthouse-core/gather/connections/raw');const Runner=require('../../../lighthouse-core/runner');const Config=require('../../../lighthouse-core/config/config');const defaultConfig=require('../../../lighthouse-core/config/default.js');const log=require('lighthouse-logger');const ReportGeneratorV2=require('../../../lighthouse-core/report/v2/report-generator');const STORAGE_KEY='lighthouse_audits';const SETTINGS_KEY='lighthouse_settings';let disableExtensionsDuringRun=false;let lighthouseIsRunning=false;let latestStatusLog=[];function updateBadgeUI(optUrl){if(window.chrome&&chrome.runtime){const manifest=chrome.runtime.getManifest();let title=manifest.browser_action.default_title;let path=manifest.browser_action.default_icon['38'];if(lighthouseIsRunning){title=`Testing ${optUrl}`;path='images/lh_logo_icon_light.png';}
chrome.browserAction.setTitle({title});chrome.browserAction.setIcon({path});}}
function filterOutArtifacts(result){result.artifacts=undefined;}
window.runLighthouseForConnection=function(connection,url,options,categoryIDs){const config=new Config({extends:'lighthouse:default',settings:{onlyCategories:categoryIDs}});const runOptions=Object.assign({},options,{url,config});lighthouseIsRunning=true;updateBadgeUI(url);return Runner.run(connection,runOptions).then(result=>{lighthouseIsRunning=false;updateBadgeUI();return result;}).catch(err=>{lighthouseIsRunning=false;updateBadgeUI();throw err;});};window.runLighthouseInExtension=function(options,categoryIDs){log.setLevel('info');const connection=new ExtensionProtocol();return connection.getCurrentTabURL().then(url=>window.runLighthouseForConnection(connection,url,options,categoryIDs)).then(results=>{filterOutArtifacts(results);const blobURL=window.createReportPageAsBlob(results,'extension');chrome.tabs.create({url:blobURL});}).catch(err=>{throw err;});};window.runLighthouseInWorker=function(port,url,options,categoryIDs){log.setLevel('info');const connection=new RawProtocol(port);return window.runLighthouseForConnection(connection,url,options,categoryIDs);};window.createReportPageAsBlob=function(results){performance.mark('report-start');const html=new ReportGeneratorV2().generateReportHtml(results);const blob=new Blob([html],{type:'text/html'});const blobURL=window.URL.createObjectURL(blob);performance.mark('report-end');performance.measure('generate report','report-start','report-end');return blobURL;};window.getDefaultCategories=function(){return Config.getCategories(defaultConfig);};window.saveSettings=function(settings){const storage={[STORAGE_KEY]:{},[SETTINGS_KEY]:{}};window.getDefaultCategories().forEach(category=>{storage[STORAGE_KEY][category.id]=settings.selectedCategories.includes(category.id);});disableExtensionsDuringRun=settings.disableExtensions;storage[SETTINGS_KEY].disableExtensions=disableExtensionsDuringRun;chrome.storage.local.set(storage);};window.loadSettings=function(){return new Promise(resolve=>{chrome.storage.local.get([STORAGE_KEY,SETTINGS_KEY],result=>{const defaultCategories={};window.getDefaultCategories().forEach(category=>{defaultCategories[category.id]=true;});const savedCategories=Object.assign(defaultCategories,result[STORAGE_KEY]);const defaultSettings={disableExtensions:disableExtensionsDuringRun};const savedSettings=Object.assign(defaultSettings,result[SETTINGS_KEY]);resolve({selectedCategories:savedCategories,disableExtensions:savedSettings.disableExtensions});});});};window.listenForStatus=function(callback){log.events.addListener('status',function(log){latestStatusLog=log;callback(log);});if(lighthouseIsRunning&&latestStatusLog){callback(latestStatusLog);}};window.isRunning=function(){return lighthouseIsRunning;};if(window.chrome&&chrome.runtime){chrome.runtime.onInstalled.addListener(details=>{if(details.previousVersion){console.log('previousVersion',details.previousVersion);}});}},{"../../../lighthouse-core/config/config":7,"../../../lighthouse-core/config/default.js":8,"../../../lighthouse-core/gather/connections/extension":11,"../../../lighthouse-core/gather/connections/raw":12,"../../../lighthouse-core/report/v2/report-generator":33,"../../../lighthouse-core/runner":34,"lighthouse-logger":109}],36:[function(require,module,exports){(function(global){'use strict';function compare(a,b){if(a===b){return 0;}
var x=a.length;var y=b.length;for(var i=0,len=Math.min(x,y);i<len;++i){if(a[i]!==b[i]){x=a[i];y=b[i];break;}}
if(x<y){return-1;}
if(y<x){return 1;}
return 0;}
function isBuffer(b){if(global.Buffer&&typeof global.Buffer.isBuffer==='function'){return global.Buffer.isBuffer(b);}
return!!(b!=null&&b._isBuffer);}
var util=require('util/');var hasOwn=Object.prototype.hasOwnProperty;var pSlice=Array.prototype.slice;var functionsHaveNames=function(){return function foo(){}.name==='foo';}();function pToString(obj){return Object.prototype.toString.call(obj);}
function isView(arrbuf){if(isBuffer(arrbuf)){return false;}
if(typeof global.ArrayBuffer!=='function'){return false;}
if(typeof ArrayBuffer.isView==='function'){return ArrayBuffer.isView(arrbuf);}
if(!arrbuf){return false;}
if(arrbuf instanceof DataView){return true;}
if(arrbuf.buffer&&arrbuf.buffer instanceof ArrayBuffer){return true;}
return false;}
var assert=module.exports=ok;var regex=/\s*function\s+([^\(\s]*)\s*/;function getName(func){if(!util.isFunction(func)){return;}
if(functionsHaveNames){return func.name;}
var str=func.toString();var match=str.match(regex);return match&&match[1];}
assert.AssertionError=function AssertionError(options){this.name='AssertionError';this.actual=options.actual;this.expected=options.expected;this.operator=options.operator;if(options.message){this.message=options.message;this.generatedMessage=false;}else{this.message=getMessage(this);this.generatedMessage=true;}
var stackStartFunction=options.stackStartFunction||fail;if(Error.captureStackTrace){Error.captureStackTrace(this,stackStartFunction);}else{var err=new Error();if(err.stack){var out=err.stack;var fn_name=getName(stackStartFunction);var idx=out.indexOf('\n'+fn_name);if(idx>=0){var next_line=out.indexOf('\n',idx+1);out=out.substring(next_line+1);}
this.stack=out;}}};util.inherits(assert.AssertionError,Error);function truncate(s,n){if(typeof s==='string'){return s.length<n?s:s.slice(0,n);}else{return s;}}
function inspect(something){if(functionsHaveNames||!util.isFunction(something)){return util.inspect(something);}
var rawname=getName(something);var name=rawname?': '+rawname:'';return'[Function'+name+']';}
function getMessage(self){return truncate(inspect(self.actual),128)+' '+
self.operator+' '+
truncate(inspect(self.expected),128);}
function fail(actual,expected,message,operator,stackStartFunction){throw new assert.AssertionError({message:message,actual:actual,expected:expected,operator:operator,stackStartFunction:stackStartFunction});}
assert.fail=fail;function ok(value,message){if(!value)fail(value,true,message,'==',assert.ok);}
assert.ok=ok;assert.equal=function equal(actual,expected,message){if(actual!=expected)fail(actual,expected,message,'==',assert.equal);};assert.notEqual=function notEqual(actual,expected,message){if(actual==expected){fail(actual,expected,message,'!=',assert.notEqual);}};assert.deepEqual=function deepEqual(actual,expected,message){if(!_deepEqual(actual,expected,false)){fail(actual,expected,message,'deepEqual',assert.deepEqual);}};assert.deepStrictEqual=function deepStrictEqual(actual,expected,message){if(!_deepEqual(actual,expected,true)){fail(actual,expected,message,'deepStrictEqual',assert.deepStrictEqual);}};function _deepEqual(actual,expected,strict,memos){if(actual===expected){return true;}else if(isBuffer(actual)&&isBuffer(expected)){return compare(actual,expected)===0;}else if(util.isDate(actual)&&util.isDate(expected)){return actual.getTime()===expected.getTime();}else if(util.isRegExp(actual)&&util.isRegExp(expected)){return actual.source===expected.source&&actual.global===expected.global&&actual.multiline===expected.multiline&&actual.lastIndex===expected.lastIndex&&actual.ignoreCase===expected.ignoreCase;}else if((actual===null||typeof actual!=='object')&&(expected===null||typeof expected!=='object')){return strict?actual===expected:actual==expected;}else if(isView(actual)&&isView(expected)&&pToString(actual)===pToString(expected)&&!(actual instanceof Float32Array||actual instanceof Float64Array)){return compare(new Uint8Array(actual.buffer),new Uint8Array(expected.buffer))===0;}else if(isBuffer(actual)!==isBuffer(expected)){return false;}else{memos=memos||{actual:[],expected:[]};var actualIndex=memos.actual.indexOf(actual);if(actualIndex!==-1){if(actualIndex===memos.expected.indexOf(expected)){return true;}}
memos.actual.push(actual);memos.expected.push(expected);return objEquiv(actual,expected,strict,memos);}}
function isArguments(object){return Object.prototype.toString.call(object)=='[object Arguments]';}
function objEquiv(a,b,strict,actualVisitedObjects){if(a===null||a===undefined||b===null||b===undefined)
return false;if(util.isPrimitive(a)||util.isPrimitive(b))
return a===b;if(strict&&Object.getPrototypeOf(a)!==Object.getPrototypeOf(b))
return false;var aIsArgs=isArguments(a);var bIsArgs=isArguments(b);if(aIsArgs&&!bIsArgs||!aIsArgs&&bIsArgs)
return false;if(aIsArgs){a=pSlice.call(a);b=pSlice.call(b);return _deepEqual(a,b,strict);}
var ka=objectKeys(a);var kb=objectKeys(b);var key,i;if(ka.length!==kb.length)
return false;ka.sort();kb.sort();for(i=ka.length-1;i>=0;i--){if(ka[i]!==kb[i])
return false;}
for(i=ka.length-1;i>=0;i--){key=ka[i];if(!_deepEqual(a[key],b[key],strict,actualVisitedObjects))
return false;}
return true;}
assert.notDeepEqual=function notDeepEqual(actual,expected,message){if(_deepEqual(actual,expected,false)){fail(actual,expected,message,'notDeepEqual',assert.notDeepEqual);}};assert.notDeepStrictEqual=notDeepStrictEqual;function notDeepStrictEqual(actual,expected,message){if(_deepEqual(actual,expected,true)){fail(actual,expected,message,'notDeepStrictEqual',notDeepStrictEqual);}}
assert.strictEqual=function strictEqual(actual,expected,message){if(actual!==expected){fail(actual,expected,message,'===',assert.strictEqual);}};assert.notStrictEqual=function notStrictEqual(actual,expected,message){if(actual===expected){fail(actual,expected,message,'!==',assert.notStrictEqual);}};function expectedException(actual,expected){if(!actual||!expected){return false;}
if(Object.prototype.toString.call(expected)=='[object RegExp]'){return expected.test(actual);}
try{if(actual instanceof expected){return true;}}catch(e){}
if(Error.isPrototypeOf(expected)){return false;}
return expected.call({},actual)===true;}
function _tryBlock(block){var error;try{block();}catch(e){error=e;}
return error;}
function _throws(shouldThrow,block,expected,message){var actual;if(typeof block!=='function'){throw new TypeError('"block" argument must be a function');}
if(typeof expected==='string'){message=expected;expected=null;}
actual=_tryBlock(block);message=(expected&&expected.name?' ('+expected.name+').':'.')+(message?' '+message:'.');if(shouldThrow&&!actual){fail(actual,expected,'Missing expected exception'+message);}
var userProvidedMessage=typeof message==='string';var isUnwantedException=!shouldThrow&&util.isError(actual);var isUnexpectedException=!shouldThrow&&actual&&!expected;if(isUnwantedException&&userProvidedMessage&&expectedException(actual,expected)||isUnexpectedException){fail(actual,expected,'Got unwanted exception'+message);}
if(shouldThrow&&actual&&expected&&!expectedException(actual,expected)||!shouldThrow&&actual){throw actual;}}
assert.throws=function(block,error,message){_throws(true,block,error,message);};assert.doesNotThrow=function(block,error,message){_throws(false,block,error,message);};assert.ifError=function(err){if(err)throw err;};var objectKeys=Object.keys||function(obj){var keys=[];for(var key in obj){if(hasOwn.call(obj,key))keys.push(key);}
return keys;};}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"util/":71}],37:[function(require,module,exports){'use strict';exports.byteLength=byteLength;exports.toByteArray=toByteArray;exports.fromByteArray=fromByteArray;var lookup=[];var revLookup=[];var Arr=typeof Uint8Array!=='undefined'?Uint8Array:Array;var code='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';for(var i=0,len=code.length;i<len;++i){lookup[i]=code[i];revLookup[code.charCodeAt(i)]=i;}
revLookup['-'.charCodeAt(0)]=62;revLookup['_'.charCodeAt(0)]=63;function placeHoldersCount(b64){var len=b64.length;if(len%4>0){throw new Error('Invalid string. Length must be a multiple of 4');}
return b64[len-2]==='='?2:b64[len-1]==='='?1:0;}
function byteLength(b64){return b64.length*3/4-placeHoldersCount(b64);}
function toByteArray(b64){var i,j,l,tmp,placeHolders,arr;var len=b64.length;placeHolders=placeHoldersCount(b64);arr=new Arr(len*3/4-placeHolders);l=placeHolders>0?len-4:len;var L=0;for(i=0,j=0;i<l;i+=4,j+=3){tmp=revLookup[b64.charCodeAt(i)]<<18|revLookup[b64.charCodeAt(i+1)]<<12|revLookup[b64.charCodeAt(i+2)]<<6|revLookup[b64.charCodeAt(i+3)];arr[L++]=tmp>>16&0xFF;arr[L++]=tmp>>8&0xFF;arr[L++]=tmp&0xFF;}
if(placeHolders===2){tmp=revLookup[b64.charCodeAt(i)]<<2|revLookup[b64.charCodeAt(i+1)]>>4;arr[L++]=tmp&0xFF;}else if(placeHolders===1){tmp=revLookup[b64.charCodeAt(i)]<<10|revLookup[b64.charCodeAt(i+1)]<<4|revLookup[b64.charCodeAt(i+2)]>>2;arr[L++]=tmp>>8&0xFF;arr[L++]=tmp&0xFF;}
return arr;}
function tripletToBase64(num){return lookup[num>>18&0x3F]+lookup[num>>12&0x3F]+lookup[num>>6&0x3F]+lookup[num&0x3F];}
function encodeChunk(uint8,start,end){var tmp;var output=[];for(var i=start;i<end;i+=3){tmp=(uint8[i]<<16)+(uint8[i+1]<<8)+uint8[i+2];output.push(tripletToBase64(tmp));}
return output.join('');}
function fromByteArray(uint8){var tmp;var len=uint8.length;var extraBytes=len%3;var output='';var parts=[];var maxChunkLength=16383;for(var i=0,len2=len-extraBytes;i<len2;i+=maxChunkLength){parts.push(encodeChunk(uint8,i,i+maxChunkLength>len2?len2:i+maxChunkLength));}
if(extraBytes===1){tmp=uint8[len-1];output+=lookup[tmp>>2];output+=lookup[tmp<<4&0x3F];output+='==';}else if(extraBytes===2){tmp=(uint8[len-2]<<8)+uint8[len-1];output+=lookup[tmp>>10];output+=lookup[tmp>>4&0x3F];output+=lookup[tmp<<2&0x3F];output+='=';}
parts.push(output);return parts.join('');}},{}],38:[function(require,module,exports){},{}],39:[function(require,module,exports){(function(process,Buffer){var msg=require('pako/lib/zlib/messages');var zstream=require('pako/lib/zlib/zstream');var zlib_deflate=require('pako/lib/zlib/deflate.js');var zlib_inflate=require('pako/lib/zlib/inflate.js');var constants=require('pako/lib/zlib/constants');for(var key in constants){exports[key]=constants[key];}
exports.NONE=0;exports.DEFLATE=1;exports.INFLATE=2;exports.GZIP=3;exports.GUNZIP=4;exports.DEFLATERAW=5;exports.INFLATERAW=6;exports.UNZIP=7;function Zlib(mode){if(mode<exports.DEFLATE||mode>exports.UNZIP)
throw new TypeError("Bad argument");this.mode=mode;this.init_done=false;this.write_in_progress=false;this.pending_close=false;this.windowBits=0;this.level=0;this.memLevel=0;this.strategy=0;this.dictionary=null;}
Zlib.prototype.init=function(windowBits,level,memLevel,strategy,dictionary){this.windowBits=windowBits;this.level=level;this.memLevel=memLevel;this.strategy=strategy;if(this.mode===exports.GZIP||this.mode===exports.GUNZIP)
this.windowBits+=16;if(this.mode===exports.UNZIP)
this.windowBits+=32;if(this.mode===exports.DEFLATERAW||this.mode===exports.INFLATERAW)
this.windowBits=-this.windowBits;this.strm=new zstream();switch(this.mode){case exports.DEFLATE:case exports.GZIP:case exports.DEFLATERAW:var status=zlib_deflate.deflateInit2(this.strm,this.level,exports.Z_DEFLATED,this.windowBits,this.memLevel,this.strategy);break;case exports.INFLATE:case exports.GUNZIP:case exports.INFLATERAW:case exports.UNZIP:var status=zlib_inflate.inflateInit2(this.strm,this.windowBits);break;default:throw new Error("Unknown mode "+this.mode);}
if(status!==exports.Z_OK){this._error(status);return;}
this.write_in_progress=false;this.init_done=true;};Zlib.prototype.params=function(){throw new Error("deflateParams Not supported");};Zlib.prototype._writeCheck=function(){if(!this.init_done)
throw new Error("write before init");if(this.mode===exports.NONE)
throw new Error("already finalized");if(this.write_in_progress)
throw new Error("write already in progress");if(this.pending_close)
throw new Error("close is pending");};Zlib.prototype.write=function(flush,input,in_off,in_len,out,out_off,out_len){this._writeCheck();this.write_in_progress=true;var self=this;process.nextTick(function(){self.write_in_progress=false;var res=self._write(flush,input,in_off,in_len,out,out_off,out_len);self.callback(res[0],res[1]);if(self.pending_close)
self.close();});return this;};function bufferSet(data,offset){for(var i=0;i<data.length;i++){this[offset+i]=data[i];}}
Zlib.prototype.writeSync=function(flush,input,in_off,in_len,out,out_off,out_len){this._writeCheck();return this._write(flush,input,in_off,in_len,out,out_off,out_len);};Zlib.prototype._write=function(flush,input,in_off,in_len,out,out_off,out_len){this.write_in_progress=true;if(flush!==exports.Z_NO_FLUSH&&flush!==exports.Z_PARTIAL_FLUSH&&flush!==exports.Z_SYNC_FLUSH&&flush!==exports.Z_FULL_FLUSH&&flush!==exports.Z_FINISH&&flush!==exports.Z_BLOCK){throw new Error("Invalid flush value");}
if(input==null){input=new Buffer(0);in_len=0;in_off=0;}
if(out._set)
out.set=out._set;else
out.set=bufferSet;var strm=this.strm;strm.avail_in=in_len;strm.input=input;strm.next_in=in_off;strm.avail_out=out_len;strm.output=out;strm.next_out=out_off;switch(this.mode){case exports.DEFLATE:case exports.GZIP:case exports.DEFLATERAW:var status=zlib_deflate.deflate(strm,flush);break;case exports.UNZIP:case exports.INFLATE:case exports.GUNZIP:case exports.INFLATERAW:var status=zlib_inflate.inflate(strm,flush);break;default:throw new Error("Unknown mode "+this.mode);}
if(status!==exports.Z_STREAM_END&&status!==exports.Z_OK){this._error(status);}
this.write_in_progress=false;return[strm.avail_in,strm.avail_out];};Zlib.prototype.close=function(){if(this.write_in_progress){this.pending_close=true;return;}
this.pending_close=false;if(this.mode===exports.DEFLATE||this.mode===exports.GZIP||this.mode===exports.DEFLATERAW){zlib_deflate.deflateEnd(this.strm);}else{zlib_inflate.inflateEnd(this.strm);}
this.mode=exports.NONE;};Zlib.prototype.reset=function(){switch(this.mode){case exports.DEFLATE:case exports.DEFLATERAW:var status=zlib_deflate.deflateReset(this.strm);break;case exports.INFLATE:case exports.INFLATERAW:var status=zlib_inflate.inflateReset(this.strm);break;}
if(status!==exports.Z_OK){this._error(status);}};Zlib.prototype._error=function(status){this.onerror(msg[status]+': '+this.strm.msg,status);this.write_in_progress=false;if(this.pending_close)
this.close();};exports.Zlib=Zlib;}).call(this,require('_process'),require("buffer").Buffer);},{"_process":60,"buffer":43,"pako/lib/zlib/constants":52,"pako/lib/zlib/deflate.js":54,"pako/lib/zlib/inflate.js":41,"pako/lib/zlib/messages":55,"pako/lib/zlib/zstream":57}],40:[function(require,module,exports){(function(process,Buffer){var Transform=require('_stream_transform');var binding=require('./binding');var util=require('util');var assert=require('assert').ok;binding.Z_MIN_WINDOWBITS=8;binding.Z_MAX_WINDOWBITS=15;binding.Z_DEFAULT_WINDOWBITS=15;binding.Z_MIN_CHUNK=64;binding.Z_MAX_CHUNK=Infinity;binding.Z_DEFAULT_CHUNK=16*1024;binding.Z_MIN_MEMLEVEL=1;binding.Z_MAX_MEMLEVEL=9;binding.Z_DEFAULT_MEMLEVEL=8;binding.Z_MIN_LEVEL=-1;binding.Z_MAX_LEVEL=9;binding.Z_DEFAULT_LEVEL=binding.Z_DEFAULT_COMPRESSION;Object.keys(binding).forEach(function(k){if(k.match(/^Z/))exports[k]=binding[k];});exports.codes={Z_OK:binding.Z_OK,Z_STREAM_END:binding.Z_STREAM_END,Z_NEED_DICT:binding.Z_NEED_DICT,Z_ERRNO:binding.Z_ERRNO,Z_STREAM_ERROR:binding.Z_STREAM_ERROR,Z_DATA_ERROR:binding.Z_DATA_ERROR,Z_MEM_ERROR:binding.Z_MEM_ERROR,Z_BUF_ERROR:binding.Z_BUF_ERROR,Z_VERSION_ERROR:binding.Z_VERSION_ERROR};Object.keys(exports.codes).forEach(function(k){exports.codes[exports.codes[k]]=k;});exports.Deflate=Deflate;exports.Inflate=Inflate;exports.Gzip=Gzip;exports.Gunzip=Gunzip;exports.DeflateRaw=DeflateRaw;exports.InflateRaw=InflateRaw;exports.Unzip=Unzip;exports.createDeflate=function(o){return new Deflate(o);};exports.createInflate=function(o){return new Inflate(o);};exports.createDeflateRaw=function(o){return new DeflateRaw(o);};exports.createInflateRaw=function(o){return new InflateRaw(o);};exports.createGzip=function(o){return new Gzip(o);};exports.createGunzip=function(o){return new Gunzip(o);};exports.createUnzip=function(o){return new Unzip(o);};exports.deflate=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Deflate(opts),buffer,callback);};exports.deflateSync=function(buffer,opts){return zlibBufferSync(new Deflate(opts),buffer);};exports.gzip=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Gzip(opts),buffer,callback);};exports.gzipSync=function(buffer,opts){return zlibBufferSync(new Gzip(opts),buffer);};exports.deflateRaw=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new DeflateRaw(opts),buffer,callback);};exports.deflateRawSync=function(buffer,opts){return zlibBufferSync(new DeflateRaw(opts),buffer);};exports.unzip=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Unzip(opts),buffer,callback);};exports.unzipSync=function(buffer,opts){return zlibBufferSync(new Unzip(opts),buffer);};exports.inflate=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Inflate(opts),buffer,callback);};exports.inflateSync=function(buffer,opts){return zlibBufferSync(new Inflate(opts),buffer);};exports.gunzip=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new Gunzip(opts),buffer,callback);};exports.gunzipSync=function(buffer,opts){return zlibBufferSync(new Gunzip(opts),buffer);};exports.inflateRaw=function(buffer,opts,callback){if(typeof opts==='function'){callback=opts;opts={};}
return zlibBuffer(new InflateRaw(opts),buffer,callback);};exports.inflateRawSync=function(buffer,opts){return zlibBufferSync(new InflateRaw(opts),buffer);};function zlibBuffer(engine,buffer,callback){var buffers=[];var nread=0;engine.on('error',onError);engine.on('end',onEnd);engine.end(buffer);flow();function flow(){var chunk;while(null!==(chunk=engine.read())){buffers.push(chunk);nread+=chunk.length;}
engine.once('readable',flow);}
function onError(err){engine.removeListener('end',onEnd);engine.removeListener('readable',flow);callback(err);}
function onEnd(){var buf=Buffer.concat(buffers,nread);buffers=[];callback(null,buf);engine.close();}}
function zlibBufferSync(engine,buffer){if(typeof buffer==='string')
buffer=new Buffer(buffer);if(!Buffer.isBuffer(buffer))
throw new TypeError('Not a string or buffer');var flushFlag=binding.Z_FINISH;return engine._processChunk(buffer,flushFlag);}
function Deflate(opts){if(!(this instanceof Deflate))return new Deflate(opts);Zlib.call(this,opts,binding.DEFLATE);}
function Inflate(opts){if(!(this instanceof Inflate))return new Inflate(opts);Zlib.call(this,opts,binding.INFLATE);}
function Gzip(opts){if(!(this instanceof Gzip))return new Gzip(opts);Zlib.call(this,opts,binding.GZIP);}
function Gunzip(opts){if(!(this instanceof Gunzip))return new Gunzip(opts);Zlib.call(this,opts,binding.GUNZIP);}
function DeflateRaw(opts){if(!(this instanceof DeflateRaw))return new DeflateRaw(opts);Zlib.call(this,opts,binding.DEFLATERAW);}
function InflateRaw(opts){if(!(this instanceof InflateRaw))return new InflateRaw(opts);Zlib.call(this,opts,binding.INFLATERAW);}
function Unzip(opts){if(!(this instanceof Unzip))return new Unzip(opts);Zlib.call(this,opts,binding.UNZIP);}
function Zlib(opts,mode){this._opts=opts=opts||{};this._chunkSize=opts.chunkSize||exports.Z_DEFAULT_CHUNK;Transform.call(this,opts);if(opts.flush){if(opts.flush!==binding.Z_NO_FLUSH&&opts.flush!==binding.Z_PARTIAL_FLUSH&&opts.flush!==binding.Z_SYNC_FLUSH&&opts.flush!==binding.Z_FULL_FLUSH&&opts.flush!==binding.Z_FINISH&&opts.flush!==binding.Z_BLOCK){throw new Error('Invalid flush flag: '+opts.flush);}}
this._flushFlag=opts.flush||binding.Z_NO_FLUSH;if(opts.chunkSize){if(opts.chunkSize<exports.Z_MIN_CHUNK||opts.chunkSize>exports.Z_MAX_CHUNK){throw new Error('Invalid chunk size: '+opts.chunkSize);}}
if(opts.windowBits){if(opts.windowBits<exports.Z_MIN_WINDOWBITS||opts.windowBits>exports.Z_MAX_WINDOWBITS){throw new Error('Invalid windowBits: '+opts.windowBits);}}
if(opts.level){if(opts.level<exports.Z_MIN_LEVEL||opts.level>exports.Z_MAX_LEVEL){throw new Error('Invalid compression level: '+opts.level);}}
if(opts.memLevel){if(opts.memLevel<exports.Z_MIN_MEMLEVEL||opts.memLevel>exports.Z_MAX_MEMLEVEL){throw new Error('Invalid memLevel: '+opts.memLevel);}}
if(opts.strategy){if(opts.strategy!=exports.Z_FILTERED&&opts.strategy!=exports.Z_HUFFMAN_ONLY&&opts.strategy!=exports.Z_RLE&&opts.strategy!=exports.Z_FIXED&&opts.strategy!=exports.Z_DEFAULT_STRATEGY){throw new Error('Invalid strategy: '+opts.strategy);}}
if(opts.dictionary){if(!Buffer.isBuffer(opts.dictionary)){throw new Error('Invalid dictionary: it should be a Buffer instance');}}
this._binding=new binding.Zlib(mode);var self=this;this._hadError=false;this._binding.onerror=function(message,errno){self._binding=null;self._hadError=true;var error=new Error(message);error.errno=errno;error.code=exports.codes[errno];self.emit('error',error);};var level=exports.Z_DEFAULT_COMPRESSION;if(typeof opts.level==='number')level=opts.level;var strategy=exports.Z_DEFAULT_STRATEGY;if(typeof opts.strategy==='number')strategy=opts.strategy;this._binding.init(opts.windowBits||exports.Z_DEFAULT_WINDOWBITS,level,opts.memLevel||exports.Z_DEFAULT_MEMLEVEL,strategy,opts.dictionary);this._buffer=new Buffer(this._chunkSize);this._offset=0;this._closed=false;this._level=level;this._strategy=strategy;this.once('end',this.close);}
util.inherits(Zlib,Transform);Zlib.prototype.params=function(level,strategy,callback){if(level<exports.Z_MIN_LEVEL||level>exports.Z_MAX_LEVEL){throw new RangeError('Invalid compression level: '+level);}
if(strategy!=exports.Z_FILTERED&&strategy!=exports.Z_HUFFMAN_ONLY&&strategy!=exports.Z_RLE&&strategy!=exports.Z_FIXED&&strategy!=exports.Z_DEFAULT_STRATEGY){throw new TypeError('Invalid strategy: '+strategy);}
if(this._level!==level||this._strategy!==strategy){var self=this;this.flush(binding.Z_SYNC_FLUSH,function(){self._binding.params(level,strategy);if(!self._hadError){self._level=level;self._strategy=strategy;if(callback)callback();}});}else{process.nextTick(callback);}};Zlib.prototype.reset=function(){return this._binding.reset();};Zlib.prototype._flush=function(callback){this._transform(new Buffer(0),'',callback);};Zlib.prototype.flush=function(kind,callback){var ws=this._writableState;if(typeof kind==='function'||kind===void 0&&!callback){callback=kind;kind=binding.Z_FULL_FLUSH;}
if(ws.ended){if(callback)
process.nextTick(callback);}else if(ws.ending){if(callback)
this.once('end',callback);}else if(ws.needDrain){var self=this;this.once('drain',function(){self.flush(callback);});}else{this._flushFlag=kind;this.write(new Buffer(0),'',callback);}};Zlib.prototype.close=function(callback){if(callback)
process.nextTick(callback);if(this._closed)
return;this._closed=true;this._binding.close();var self=this;process.nextTick(function(){self.emit('close');});};Zlib.prototype._transform=function(chunk,encoding,cb){var flushFlag;var ws=this._writableState;var ending=ws.ending||ws.ended;var last=ending&&(!chunk||ws.length===chunk.length);if(!chunk===null&&!Buffer.isBuffer(chunk))
return cb(new Error('invalid input'));if(last)
flushFlag=binding.Z_FINISH;else
{flushFlag=this._flushFlag;if(chunk.length>=ws.length){this._flushFlag=this._opts.flush||binding.Z_NO_FLUSH;}}
var self=this;this._processChunk(chunk,flushFlag,cb);};Zlib.prototype._processChunk=function(chunk,flushFlag,cb){var availInBefore=chunk&&chunk.length;var availOutBefore=this._chunkSize-this._offset;var inOff=0;var self=this;var async=typeof cb==='function';if(!async){var buffers=[];var nread=0;var error;this.on('error',function(er){error=er;});do{var res=this._binding.writeSync(flushFlag,chunk,inOff,availInBefore,this._buffer,this._offset,availOutBefore);}while(!this._hadError&&callback(res[0],res[1]));if(this._hadError){throw error;}
var buf=Buffer.concat(buffers,nread);this.close();return buf;}
var req=this._binding.write(flushFlag,chunk,inOff,availInBefore,this._buffer,this._offset,availOutBefore);req.buffer=chunk;req.callback=callback;function callback(availInAfter,availOutAfter){if(self._hadError)
return;var have=availOutBefore-availOutAfter;assert(have>=0,'have should not go down');if(have>0){var out=self._buffer.slice(self._offset,self._offset+have);self._offset+=have;if(async){self.push(out);}else{buffers.push(out);nread+=out.length;}}
if(availOutAfter===0||self._offset>=self._chunkSize){availOutBefore=self._chunkSize;self._offset=0;self._buffer=new Buffer(self._chunkSize);}
if(availOutAfter===0){inOff+=availInBefore-availInAfter;availInBefore=availInAfter;if(!async)
return true;var newReq=self._binding.write(flushFlag,chunk,inOff,availInBefore,self._buffer,self._offset,self._chunkSize);newReq.callback=callback;newReq.buffer=chunk;return;}
if(!async)
return false;cb();}};util.inherits(Deflate,Zlib);util.inherits(Inflate,Zlib);util.inherits(Gzip,Zlib);util.inherits(Gunzip,Zlib);util.inherits(DeflateRaw,Zlib);util.inherits(InflateRaw,Zlib);util.inherits(Unzip,Zlib);}).call(this,require('_process'),require("buffer").Buffer);},{"./binding":39,"_process":60,"_stream_transform":66,"assert":36,"buffer":43,"util":71}],41:[function(require,module,exports){arguments[4][38][0].apply(exports,arguments);},{"dup":38}],42:[function(require,module,exports){(function(global){'use strict';var buffer=require('buffer');var Buffer=buffer.Buffer;var SlowBuffer=buffer.SlowBuffer;var MAX_LEN=buffer.kMaxLength||2147483647;exports.alloc=function alloc(size,fill,encoding){if(typeof Buffer.alloc==='function'){return Buffer.alloc(size,fill,encoding);}
if(typeof encoding==='number'){throw new TypeError('encoding must not be number');}
if(typeof size!=='number'){throw new TypeError('size must be a number');}
if(size>MAX_LEN){throw new RangeError('size is too large');}
var enc=encoding;var _fill=fill;if(_fill===undefined){enc=undefined;_fill=0;}
var buf=new Buffer(size);if(typeof _fill==='string'){var fillBuf=new Buffer(_fill,enc);var flen=fillBuf.length;var i=-1;while(++i<size){buf[i]=fillBuf[i%flen];}}else{buf.fill(_fill);}
return buf;};exports.allocUnsafe=function allocUnsafe(size){if(typeof Buffer.allocUnsafe==='function'){return Buffer.allocUnsafe(size);}
if(typeof size!=='number'){throw new TypeError('size must be a number');}
if(size>MAX_LEN){throw new RangeError('size is too large');}
return new Buffer(size);};exports.from=function from(value,encodingOrOffset,length){if(typeof Buffer.from==='function'&&(!global.Uint8Array||Uint8Array.from!==Buffer.from)){return Buffer.from(value,encodingOrOffset,length);}
if(typeof value==='number'){throw new TypeError('"value" argument must not be a number');}
if(typeof value==='string'){return new Buffer(value,encodingOrOffset);}
if(typeof ArrayBuffer!=='undefined'&&value instanceof ArrayBuffer){var offset=encodingOrOffset;if(arguments.length===1){return new Buffer(value);}
if(typeof offset==='undefined'){offset=0;}
var len=length;if(typeof len==='undefined'){len=value.byteLength-offset;}
if(offset>=value.byteLength){throw new RangeError('\'offset\' is out of bounds');}
if(len>value.byteLength-offset){throw new RangeError('\'length\' is out of bounds');}
return new Buffer(value.slice(offset,offset+len));}
if(Buffer.isBuffer(value)){var out=new Buffer(value.length);value.copy(out,0,0,value.length);return out;}
if(value){if(Array.isArray(value)||typeof ArrayBuffer!=='undefined'&&value.buffer instanceof ArrayBuffer||'length'in value){return new Buffer(value);}
if(value.type==='Buffer'&&Array.isArray(value.data)){return new Buffer(value.data);}}
throw new TypeError('First argument must be a string, Buffer, '+'ArrayBuffer, Array, or array-like object.');};exports.allocUnsafeSlow=function allocUnsafeSlow(size){if(typeof Buffer.allocUnsafeSlow==='function'){return Buffer.allocUnsafeSlow(size);}
if(typeof size!=='number'){throw new TypeError('size must be a number');}
if(size>=MAX_LEN){throw new RangeError('size is too large');}
return new SlowBuffer(size);};}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"buffer":43}],43:[function(require,module,exports){(function(global){'use strict';var base64=require('base64-js');var ieee754=require('ieee754');var isArray=require('isarray');exports.Buffer=Buffer;exports.SlowBuffer=SlowBuffer;exports.INSPECT_MAX_BYTES=50;Buffer.TYPED_ARRAY_SUPPORT=global.TYPED_ARRAY_SUPPORT!==undefined?global.TYPED_ARRAY_SUPPORT:typedArraySupport();exports.kMaxLength=kMaxLength();function typedArraySupport(){try{var arr=new Uint8Array(1);arr.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42;}};return arr.foo()===42&&typeof arr.subarray==='function'&&arr.subarray(1,1).byteLength===0;}catch(e){return false;}}
function kMaxLength(){return Buffer.TYPED_ARRAY_SUPPORT?0x7fffffff:0x3fffffff;}
function createBuffer(that,length){if(kMaxLength()<length){throw new RangeError('Invalid typed array length');}
if(Buffer.TYPED_ARRAY_SUPPORT){that=new Uint8Array(length);that.__proto__=Buffer.prototype;}else{if(that===null){that=new Buffer(length);}
that.length=length;}
return that;}
function Buffer(arg,encodingOrOffset,length){if(!Buffer.TYPED_ARRAY_SUPPORT&&!(this instanceof Buffer)){return new Buffer(arg,encodingOrOffset,length);}
if(typeof arg==='number'){if(typeof encodingOrOffset==='string'){throw new Error('If encoding is specified then the first argument must be a string');}
return allocUnsafe(this,arg);}
return from(this,arg,encodingOrOffset,length);}
Buffer.poolSize=8192;Buffer._augment=function(arr){arr.__proto__=Buffer.prototype;return arr;};function from(that,value,encodingOrOffset,length){if(typeof value==='number'){throw new TypeError('"value" argument must not be a number');}
if(typeof ArrayBuffer!=='undefined'&&value instanceof ArrayBuffer){return fromArrayBuffer(that,value,encodingOrOffset,length);}
if(typeof value==='string'){return fromString(that,value,encodingOrOffset);}
return fromObject(that,value);}
Buffer.from=function(value,encodingOrOffset,length){return from(null,value,encodingOrOffset,length);};if(Buffer.TYPED_ARRAY_SUPPORT){Buffer.prototype.__proto__=Uint8Array.prototype;Buffer.__proto__=Uint8Array;if(typeof Symbol!=='undefined'&&Symbol.species&&Buffer[Symbol.species]===Buffer){Object.defineProperty(Buffer,Symbol.species,{value:null,configurable:true});}}
function assertSize(size){if(typeof size!=='number'){throw new TypeError('"size" argument must be a number');}else if(size<0){throw new RangeError('"size" argument must not be negative');}}
function alloc(that,size,fill,encoding){assertSize(size);if(size<=0){return createBuffer(that,size);}
if(fill!==undefined){return typeof encoding==='string'?createBuffer(that,size).fill(fill,encoding):createBuffer(that,size).fill(fill);}
return createBuffer(that,size);}
Buffer.alloc=function(size,fill,encoding){return alloc(null,size,fill,encoding);};function allocUnsafe(that,size){assertSize(size);that=createBuffer(that,size<0?0:checked(size)|0);if(!Buffer.TYPED_ARRAY_SUPPORT){for(var i=0;i<size;++i){that[i]=0;}}
return that;}
Buffer.allocUnsafe=function(size){return allocUnsafe(null,size);};Buffer.allocUnsafeSlow=function(size){return allocUnsafe(null,size);};function fromString(that,string,encoding){if(typeof encoding!=='string'||encoding===''){encoding='utf8';}
if(!Buffer.isEncoding(encoding)){throw new TypeError('"encoding" must be a valid string encoding');}
var length=byteLength(string,encoding)|0;that=createBuffer(that,length);var actual=that.write(string,encoding);if(actual!==length){that=that.slice(0,actual);}
return that;}
function fromArrayLike(that,array){var length=array.length<0?0:checked(array.length)|0;that=createBuffer(that,length);for(var i=0;i<length;i+=1){that[i]=array[i]&255;}
return that;}
function fromArrayBuffer(that,array,byteOffset,length){array.byteLength;if(byteOffset<0||array.byteLength<byteOffset){throw new RangeError('\'offset\' is out of bounds');}
if(array.byteLength<byteOffset+(length||0)){throw new RangeError('\'length\' is out of bounds');}
if(byteOffset===undefined&&length===undefined){array=new Uint8Array(array);}else if(length===undefined){array=new Uint8Array(array,byteOffset);}else{array=new Uint8Array(array,byteOffset,length);}
if(Buffer.TYPED_ARRAY_SUPPORT){that=array;that.__proto__=Buffer.prototype;}else{that=fromArrayLike(that,array);}
return that;}
function fromObject(that,obj){if(Buffer.isBuffer(obj)){var len=checked(obj.length)|0;that=createBuffer(that,len);if(that.length===0){return that;}
obj.copy(that,0,0,len);return that;}
if(obj){if(typeof ArrayBuffer!=='undefined'&&obj.buffer instanceof ArrayBuffer||'length'in obj){if(typeof obj.length!=='number'||isnan(obj.length)){return createBuffer(that,0);}
return fromArrayLike(that,obj);}
if(obj.type==='Buffer'&&isArray(obj.data)){return fromArrayLike(that,obj.data);}}
throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.');}
function checked(length){if(length>=kMaxLength()){throw new RangeError('Attempt to allocate Buffer larger than maximum '+'size: 0x'+kMaxLength().toString(16)+' bytes');}
return length|0;}
function SlowBuffer(length){if(+length!=length){length=0;}
return Buffer.alloc(+length);}
Buffer.isBuffer=function isBuffer(b){return!!(b!=null&&b._isBuffer);};Buffer.compare=function compare(a,b){if(!Buffer.isBuffer(a)||!Buffer.isBuffer(b)){throw new TypeError('Arguments must be Buffers');}
if(a===b)return 0;var x=a.length;var y=b.length;for(var i=0,len=Math.min(x,y);i<len;++i){if(a[i]!==b[i]){x=a[i];y=b[i];break;}}
if(x<y)return-1;if(y<x)return 1;return 0;};Buffer.isEncoding=function isEncoding(encoding){switch(String(encoding).toLowerCase()){case'hex':case'utf8':case'utf-8':case'ascii':case'latin1':case'binary':case'base64':case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':return true;default:return false;}};Buffer.concat=function concat(list,length){if(!isArray(list)){throw new TypeError('"list" argument must be an Array of Buffers');}
if(list.length===0){return Buffer.alloc(0);}
var i;if(length===undefined){length=0;for(i=0;i<list.length;++i){length+=list[i].length;}}
var buffer=Buffer.allocUnsafe(length);var pos=0;for(i=0;i<list.length;++i){var buf=list[i];if(!Buffer.isBuffer(buf)){throw new TypeError('"list" argument must be an Array of Buffers');}
buf.copy(buffer,pos);pos+=buf.length;}
return buffer;};function byteLength(string,encoding){if(Buffer.isBuffer(string)){return string.length;}
if(typeof ArrayBuffer!=='undefined'&&typeof ArrayBuffer.isView==='function'&&(ArrayBuffer.isView(string)||string instanceof ArrayBuffer)){return string.byteLength;}
if(typeof string!=='string'){string=''+string;}
var len=string.length;if(len===0)return 0;var loweredCase=false;for(;;){switch(encoding){case'ascii':case'latin1':case'binary':return len;case'utf8':case'utf-8':case undefined:return utf8ToBytes(string).length;case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':return len*2;case'hex':return len>>>1;case'base64':return base64ToBytes(string).length;default:if(loweredCase)return utf8ToBytes(string).length;encoding=(''+encoding).toLowerCase();loweredCase=true;}}}
Buffer.byteLength=byteLength;function slowToString(encoding,start,end){var loweredCase=false;if(start===undefined||start<0){start=0;}
if(start>this.length){return'';}
if(end===undefined||end>this.length){end=this.length;}
if(end<=0){return'';}
end>>>=0;start>>>=0;if(end<=start){return'';}
if(!encoding)encoding='utf8';while(true){switch(encoding){case'hex':return hexSlice(this,start,end);case'utf8':case'utf-8':return utf8Slice(this,start,end);case'ascii':return asciiSlice(this,start,end);case'latin1':case'binary':return latin1Slice(this,start,end);case'base64':return base64Slice(this,start,end);case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':return utf16leSlice(this,start,end);default:if(loweredCase)throw new TypeError('Unknown encoding: '+encoding);encoding=(encoding+'').toLowerCase();loweredCase=true;}}}
Buffer.prototype._isBuffer=true;function swap(b,n,m){var i=b[n];b[n]=b[m];b[m]=i;}
Buffer.prototype.swap16=function swap16(){var len=this.length;if(len%2!==0){throw new RangeError('Buffer size must be a multiple of 16-bits');}
for(var i=0;i<len;i+=2){swap(this,i,i+1);}
return this;};Buffer.prototype.swap32=function swap32(){var len=this.length;if(len%4!==0){throw new RangeError('Buffer size must be a multiple of 32-bits');}
for(var i=0;i<len;i+=4){swap(this,i,i+3);swap(this,i+1,i+2);}
return this;};Buffer.prototype.swap64=function swap64(){var len=this.length;if(len%8!==0){throw new RangeError('Buffer size must be a multiple of 64-bits');}
for(var i=0;i<len;i+=8){swap(this,i,i+7);swap(this,i+1,i+6);swap(this,i+2,i+5);swap(this,i+3,i+4);}
return this;};Buffer.prototype.toString=function toString(){var length=this.length|0;if(length===0)return'';if(arguments.length===0)return utf8Slice(this,0,length);return slowToString.apply(this,arguments);};Buffer.prototype.equals=function equals(b){if(!Buffer.isBuffer(b))throw new TypeError('Argument must be a Buffer');if(this===b)return true;return Buffer.compare(this,b)===0;};Buffer.prototype.inspect=function inspect(){var str='';var max=exports.INSPECT_MAX_BYTES;if(this.length>0){str=this.toString('hex',0,max).match(/.{2}/g).join(' ');if(this.length>max)str+=' ... ';}
return'<Buffer '+str+'>';};Buffer.prototype.compare=function compare(target,start,end,thisStart,thisEnd){if(!Buffer.isBuffer(target)){throw new TypeError('Argument must be a Buffer');}
if(start===undefined){start=0;}
if(end===undefined){end=target?target.length:0;}
if(thisStart===undefined){thisStart=0;}
if(thisEnd===undefined){thisEnd=this.length;}
if(start<0||end>target.length||thisStart<0||thisEnd>this.length){throw new RangeError('out of range index');}
if(thisStart>=thisEnd&&start>=end){return 0;}
if(thisStart>=thisEnd){return-1;}
if(start>=end){return 1;}
start>>>=0;end>>>=0;thisStart>>>=0;thisEnd>>>=0;if(this===target)return 0;var x=thisEnd-thisStart;var y=end-start;var len=Math.min(x,y);var thisCopy=this.slice(thisStart,thisEnd);var targetCopy=target.slice(start,end);for(var i=0;i<len;++i){if(thisCopy[i]!==targetCopy[i]){x=thisCopy[i];y=targetCopy[i];break;}}
if(x<y)return-1;if(y<x)return 1;return 0;};function bidirectionalIndexOf(buffer,val,byteOffset,encoding,dir){if(buffer.length===0)return-1;if(typeof byteOffset==='string'){encoding=byteOffset;byteOffset=0;}else if(byteOffset>0x7fffffff){byteOffset=0x7fffffff;}else if(byteOffset<-0x80000000){byteOffset=-0x80000000;}
byteOffset=+byteOffset;if(isNaN(byteOffset)){byteOffset=dir?0:buffer.length-1;}
if(byteOffset<0)byteOffset=buffer.length+byteOffset;if(byteOffset>=buffer.length){if(dir)return-1;else
byteOffset=buffer.length-1;}else if(byteOffset<0){if(dir)byteOffset=0;else
return-1;}
if(typeof val==='string'){val=Buffer.from(val,encoding);}
if(Buffer.isBuffer(val)){if(val.length===0){return-1;}
return arrayIndexOf(buffer,val,byteOffset,encoding,dir);}else if(typeof val==='number'){val=val&0xFF;if(Buffer.TYPED_ARRAY_SUPPORT&&typeof Uint8Array.prototype.indexOf==='function'){if(dir){return Uint8Array.prototype.indexOf.call(buffer,val,byteOffset);}else{return Uint8Array.prototype.lastIndexOf.call(buffer,val,byteOffset);}}
return arrayIndexOf(buffer,[val],byteOffset,encoding,dir);}
throw new TypeError('val must be string, number or Buffer');}
function arrayIndexOf(arr,val,byteOffset,encoding,dir){var indexSize=1;var arrLength=arr.length;var valLength=val.length;if(encoding!==undefined){encoding=String(encoding).toLowerCase();if(encoding==='ucs2'||encoding==='ucs-2'||encoding==='utf16le'||encoding==='utf-16le'){if(arr.length<2||val.length<2){return-1;}
indexSize=2;arrLength/=2;valLength/=2;byteOffset/=2;}}
function read(buf,i){if(indexSize===1){return buf[i];}else{return buf.readUInt16BE(i*indexSize);}}
var i;if(dir){var foundIndex=-1;for(i=byteOffset;i<arrLength;i++){if(read(arr,i)===read(val,foundIndex===-1?0:i-foundIndex)){if(foundIndex===-1)foundIndex=i;if(i-foundIndex+1===valLength)return foundIndex*indexSize;}else{if(foundIndex!==-1)i-=i-foundIndex;foundIndex=-1;}}}else{if(byteOffset+valLength>arrLength)byteOffset=arrLength-valLength;for(i=byteOffset;i>=0;i--){var found=true;for(var j=0;j<valLength;j++){if(read(arr,i+j)!==read(val,j)){found=false;break;}}
if(found)return i;}}
return-1;}
Buffer.prototype.includes=function includes(val,byteOffset,encoding){return this.indexOf(val,byteOffset,encoding)!==-1;};Buffer.prototype.indexOf=function indexOf(val,byteOffset,encoding){return bidirectionalIndexOf(this,val,byteOffset,encoding,true);};Buffer.prototype.lastIndexOf=function lastIndexOf(val,byteOffset,encoding){return bidirectionalIndexOf(this,val,byteOffset,encoding,false);};function hexWrite(buf,string,offset,length){offset=Number(offset)||0;var remaining=buf.length-offset;if(!length){length=remaining;}else{length=Number(length);if(length>remaining){length=remaining;}}
var strLen=string.length;if(strLen%2!==0)throw new TypeError('Invalid hex string');if(length>strLen/2){length=strLen/2;}
for(var i=0;i<length;++i){var parsed=parseInt(string.substr(i*2,2),16);if(isNaN(parsed))return i;buf[offset+i]=parsed;}
return i;}
function utf8Write(buf,string,offset,length){return blitBuffer(utf8ToBytes(string,buf.length-offset),buf,offset,length);}
function asciiWrite(buf,string,offset,length){return blitBuffer(asciiToBytes(string),buf,offset,length);}
function latin1Write(buf,string,offset,length){return asciiWrite(buf,string,offset,length);}
function base64Write(buf,string,offset,length){return blitBuffer(base64ToBytes(string),buf,offset,length);}
function ucs2Write(buf,string,offset,length){return blitBuffer(utf16leToBytes(string,buf.length-offset),buf,offset,length);}
Buffer.prototype.write=function write(string,offset,length,encoding){if(offset===undefined){encoding='utf8';length=this.length;offset=0;}else if(length===undefined&&typeof offset==='string'){encoding=offset;length=this.length;offset=0;}else if(isFinite(offset)){offset=offset|0;if(isFinite(length)){length=length|0;if(encoding===undefined)encoding='utf8';}else{encoding=length;length=undefined;}}else{throw new Error('Buffer.write(string, encoding, offset[, length]) is no longer supported');}
var remaining=this.length-offset;if(length===undefined||length>remaining)length=remaining;if(string.length>0&&(length<0||offset<0)||offset>this.length){throw new RangeError('Attempt to write outside buffer bounds');}
if(!encoding)encoding='utf8';var loweredCase=false;for(;;){switch(encoding){case'hex':return hexWrite(this,string,offset,length);case'utf8':case'utf-8':return utf8Write(this,string,offset,length);case'ascii':return asciiWrite(this,string,offset,length);case'latin1':case'binary':return latin1Write(this,string,offset,length);case'base64':return base64Write(this,string,offset,length);case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':return ucs2Write(this,string,offset,length);default:if(loweredCase)throw new TypeError('Unknown encoding: '+encoding);encoding=(''+encoding).toLowerCase();loweredCase=true;}}};Buffer.prototype.toJSON=function toJSON(){return{type:'Buffer',data:Array.prototype.slice.call(this._arr||this,0)};};function base64Slice(buf,start,end){if(start===0&&end===buf.length){return base64.fromByteArray(buf);}else{return base64.fromByteArray(buf.slice(start,end));}}
function utf8Slice(buf,start,end){end=Math.min(buf.length,end);var res=[];var i=start;while(i<end){var firstByte=buf[i];var codePoint=null;var bytesPerSequence=firstByte>0xEF?4:firstByte>0xDF?3:firstByte>0xBF?2:1;if(i+bytesPerSequence<=end){var secondByte,thirdByte,fourthByte,tempCodePoint;switch(bytesPerSequence){case 1:if(firstByte<0x80){codePoint=firstByte;}
break;case 2:secondByte=buf[i+1];if((secondByte&0xC0)===0x80){tempCodePoint=(firstByte&0x1F)<<0x6|secondByte&0x3F;if(tempCodePoint>0x7F){codePoint=tempCodePoint;}}
break;case 3:secondByte=buf[i+1];thirdByte=buf[i+2];if((secondByte&0xC0)===0x80&&(thirdByte&0xC0)===0x80){tempCodePoint=(firstByte&0xF)<<0xC|(secondByte&0x3F)<<0x6|thirdByte&0x3F;if(tempCodePoint>0x7FF&&(tempCodePoint<0xD800||tempCodePoint>0xDFFF)){codePoint=tempCodePoint;}}
break;case 4:secondByte=buf[i+1];thirdByte=buf[i+2];fourthByte=buf[i+3];if((secondByte&0xC0)===0x80&&(thirdByte&0xC0)===0x80&&(fourthByte&0xC0)===0x80){tempCodePoint=(firstByte&0xF)<<0x12|(secondByte&0x3F)<<0xC|(thirdByte&0x3F)<<0x6|fourthByte&0x3F;if(tempCodePoint>0xFFFF&&tempCodePoint<0x110000){codePoint=tempCodePoint;}}}}
if(codePoint===null){codePoint=0xFFFD;bytesPerSequence=1;}else if(codePoint>0xFFFF){codePoint-=0x10000;res.push(codePoint>>>10&0x3FF|0xD800);codePoint=0xDC00|codePoint&0x3FF;}
res.push(codePoint);i+=bytesPerSequence;}
return decodeCodePointsArray(res);}
var MAX_ARGUMENTS_LENGTH=0x1000;function decodeCodePointsArray(codePoints){var len=codePoints.length;if(len<=MAX_ARGUMENTS_LENGTH){return String.fromCharCode.apply(String,codePoints);}
var res='';var i=0;while(i<len){res+=String.fromCharCode.apply(String,codePoints.slice(i,i+=MAX_ARGUMENTS_LENGTH));}
return res;}
function asciiSlice(buf,start,end){var ret='';end=Math.min(buf.length,end);for(var i=start;i<end;++i){ret+=String.fromCharCode(buf[i]&0x7F);}
return ret;}
function latin1Slice(buf,start,end){var ret='';end=Math.min(buf.length,end);for(var i=start;i<end;++i){ret+=String.fromCharCode(buf[i]);}
return ret;}
function hexSlice(buf,start,end){var len=buf.length;if(!start||start<0)start=0;if(!end||end<0||end>len)end=len;var out='';for(var i=start;i<end;++i){out+=toHex(buf[i]);}
return out;}
function utf16leSlice(buf,start,end){var bytes=buf.slice(start,end);var res='';for(var i=0;i<bytes.length;i+=2){res+=String.fromCharCode(bytes[i]+bytes[i+1]*256);}
return res;}
Buffer.prototype.slice=function slice(start,end){var len=this.length;start=~~start;end=end===undefined?len:~~end;if(start<0){start+=len;if(start<0)start=0;}else if(start>len){start=len;}
if(end<0){end+=len;if(end<0)end=0;}else if(end>len){end=len;}
if(end<start)end=start;var newBuf;if(Buffer.TYPED_ARRAY_SUPPORT){newBuf=this.subarray(start,end);newBuf.__proto__=Buffer.prototype;}else{var sliceLen=end-start;newBuf=new Buffer(sliceLen,undefined);for(var i=0;i<sliceLen;++i){newBuf[i]=this[i+start];}}
return newBuf;};function checkOffset(offset,ext,length){if(offset%1!==0||offset<0)throw new RangeError('offset is not uint');if(offset+ext>length)throw new RangeError('Trying to access beyond buffer length');}
Buffer.prototype.readUIntLE=function readUIntLE(offset,byteLength,noAssert){offset=offset|0;byteLength=byteLength|0;if(!noAssert)checkOffset(offset,byteLength,this.length);var val=this[offset];var mul=1;var i=0;while(++i<byteLength&&(mul*=0x100)){val+=this[offset+i]*mul;}
return val;};Buffer.prototype.readUIntBE=function readUIntBE(offset,byteLength,noAssert){offset=offset|0;byteLength=byteLength|0;if(!noAssert){checkOffset(offset,byteLength,this.length);}
var val=this[offset+--byteLength];var mul=1;while(byteLength>0&&(mul*=0x100)){val+=this[offset+--byteLength]*mul;}
return val;};Buffer.prototype.readUInt8=function readUInt8(offset,noAssert){if(!noAssert)checkOffset(offset,1,this.length);return this[offset];};Buffer.prototype.readUInt16LE=function readUInt16LE(offset,noAssert){if(!noAssert)checkOffset(offset,2,this.length);return this[offset]|this[offset+1]<<8;};Buffer.prototype.readUInt16BE=function readUInt16BE(offset,noAssert){if(!noAssert)checkOffset(offset,2,this.length);return this[offset]<<8|this[offset+1];};Buffer.prototype.readUInt32LE=function readUInt32LE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return(this[offset]|this[offset+1]<<8|this[offset+2]<<16)+
this[offset+3]*0x1000000;};Buffer.prototype.readUInt32BE=function readUInt32BE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return this[offset]*0x1000000+(this[offset+1]<<16|this[offset+2]<<8|this[offset+3]);};Buffer.prototype.readIntLE=function readIntLE(offset,byteLength,noAssert){offset=offset|0;byteLength=byteLength|0;if(!noAssert)checkOffset(offset,byteLength,this.length);var val=this[offset];var mul=1;var i=0;while(++i<byteLength&&(mul*=0x100)){val+=this[offset+i]*mul;}
mul*=0x80;if(val>=mul)val-=Math.pow(2,8*byteLength);return val;};Buffer.prototype.readIntBE=function readIntBE(offset,byteLength,noAssert){offset=offset|0;byteLength=byteLength|0;if(!noAssert)checkOffset(offset,byteLength,this.length);var i=byteLength;var mul=1;var val=this[offset+--i];while(i>0&&(mul*=0x100)){val+=this[offset+--i]*mul;}
mul*=0x80;if(val>=mul)val-=Math.pow(2,8*byteLength);return val;};Buffer.prototype.readInt8=function readInt8(offset,noAssert){if(!noAssert)checkOffset(offset,1,this.length);if(!(this[offset]&0x80))return this[offset];return(0xff-this[offset]+1)*-1;};Buffer.prototype.readInt16LE=function readInt16LE(offset,noAssert){if(!noAssert)checkOffset(offset,2,this.length);var val=this[offset]|this[offset+1]<<8;return val&0x8000?val|0xFFFF0000:val;};Buffer.prototype.readInt16BE=function readInt16BE(offset,noAssert){if(!noAssert)checkOffset(offset,2,this.length);var val=this[offset+1]|this[offset]<<8;return val&0x8000?val|0xFFFF0000:val;};Buffer.prototype.readInt32LE=function readInt32LE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return this[offset]|this[offset+1]<<8|this[offset+2]<<16|this[offset+3]<<24;};Buffer.prototype.readInt32BE=function readInt32BE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return this[offset]<<24|this[offset+1]<<16|this[offset+2]<<8|this[offset+3];};Buffer.prototype.readFloatLE=function readFloatLE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return ieee754.read(this,offset,true,23,4);};Buffer.prototype.readFloatBE=function readFloatBE(offset,noAssert){if(!noAssert)checkOffset(offset,4,this.length);return ieee754.read(this,offset,false,23,4);};Buffer.prototype.readDoubleLE=function readDoubleLE(offset,noAssert){if(!noAssert)checkOffset(offset,8,this.length);return ieee754.read(this,offset,true,52,8);};Buffer.prototype.readDoubleBE=function readDoubleBE(offset,noAssert){if(!noAssert)checkOffset(offset,8,this.length);return ieee754.read(this,offset,false,52,8);};function checkInt(buf,value,offset,ext,max,min){if(!Buffer.isBuffer(buf))throw new TypeError('"buffer" argument must be a Buffer instance');if(value>max||value<min)throw new RangeError('"value" argument is out of bounds');if(offset+ext>buf.length)throw new RangeError('Index out of range');}
Buffer.prototype.writeUIntLE=function writeUIntLE(value,offset,byteLength,noAssert){value=+value;offset=offset|0;byteLength=byteLength|0;if(!noAssert){var maxBytes=Math.pow(2,8*byteLength)-1;checkInt(this,value,offset,byteLength,maxBytes,0);}
var mul=1;var i=0;this[offset]=value&0xFF;while(++i<byteLength&&(mul*=0x100)){this[offset+i]=value/mul&0xFF;}
return offset+byteLength;};Buffer.prototype.writeUIntBE=function writeUIntBE(value,offset,byteLength,noAssert){value=+value;offset=offset|0;byteLength=byteLength|0;if(!noAssert){var maxBytes=Math.pow(2,8*byteLength)-1;checkInt(this,value,offset,byteLength,maxBytes,0);}
var i=byteLength-1;var mul=1;this[offset+i]=value&0xFF;while(--i>=0&&(mul*=0x100)){this[offset+i]=value/mul&0xFF;}
return offset+byteLength;};Buffer.prototype.writeUInt8=function writeUInt8(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,1,0xff,0);if(!Buffer.TYPED_ARRAY_SUPPORT)value=Math.floor(value);this[offset]=value&0xff;return offset+1;};function objectWriteUInt16(buf,value,offset,littleEndian){if(value<0)value=0xffff+value+1;for(var i=0,j=Math.min(buf.length-offset,2);i<j;++i){buf[offset+i]=(value&0xff<<8*(littleEndian?i:1-i))>>>(littleEndian?i:1-i)*8;}}
Buffer.prototype.writeUInt16LE=function writeUInt16LE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,2,0xffff,0);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value&0xff;this[offset+1]=value>>>8;}else{objectWriteUInt16(this,value,offset,true);}
return offset+2;};Buffer.prototype.writeUInt16BE=function writeUInt16BE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,2,0xffff,0);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value>>>8;this[offset+1]=value&0xff;}else{objectWriteUInt16(this,value,offset,false);}
return offset+2;};function objectWriteUInt32(buf,value,offset,littleEndian){if(value<0)value=0xffffffff+value+1;for(var i=0,j=Math.min(buf.length-offset,4);i<j;++i){buf[offset+i]=value>>>(littleEndian?i:3-i)*8&0xff;}}
Buffer.prototype.writeUInt32LE=function writeUInt32LE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,4,0xffffffff,0);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset+3]=value>>>24;this[offset+2]=value>>>16;this[offset+1]=value>>>8;this[offset]=value&0xff;}else{objectWriteUInt32(this,value,offset,true);}
return offset+4;};Buffer.prototype.writeUInt32BE=function writeUInt32BE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,4,0xffffffff,0);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value>>>24;this[offset+1]=value>>>16;this[offset+2]=value>>>8;this[offset+3]=value&0xff;}else{objectWriteUInt32(this,value,offset,false);}
return offset+4;};Buffer.prototype.writeIntLE=function writeIntLE(value,offset,byteLength,noAssert){value=+value;offset=offset|0;if(!noAssert){var limit=Math.pow(2,8*byteLength-1);checkInt(this,value,offset,byteLength,limit-1,-limit);}
var i=0;var mul=1;var sub=0;this[offset]=value&0xFF;while(++i<byteLength&&(mul*=0x100)){if(value<0&&sub===0&&this[offset+i-1]!==0){sub=1;}
this[offset+i]=(value/mul>>0)-sub&0xFF;}
return offset+byteLength;};Buffer.prototype.writeIntBE=function writeIntBE(value,offset,byteLength,noAssert){value=+value;offset=offset|0;if(!noAssert){var limit=Math.pow(2,8*byteLength-1);checkInt(this,value,offset,byteLength,limit-1,-limit);}
var i=byteLength-1;var mul=1;var sub=0;this[offset+i]=value&0xFF;while(--i>=0&&(mul*=0x100)){if(value<0&&sub===0&&this[offset+i+1]!==0){sub=1;}
this[offset+i]=(value/mul>>0)-sub&0xFF;}
return offset+byteLength;};Buffer.prototype.writeInt8=function writeInt8(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,1,0x7f,-0x80);if(!Buffer.TYPED_ARRAY_SUPPORT)value=Math.floor(value);if(value<0)value=0xff+value+1;this[offset]=value&0xff;return offset+1;};Buffer.prototype.writeInt16LE=function writeInt16LE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,2,0x7fff,-0x8000);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value&0xff;this[offset+1]=value>>>8;}else{objectWriteUInt16(this,value,offset,true);}
return offset+2;};Buffer.prototype.writeInt16BE=function writeInt16BE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,2,0x7fff,-0x8000);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value>>>8;this[offset+1]=value&0xff;}else{objectWriteUInt16(this,value,offset,false);}
return offset+2;};Buffer.prototype.writeInt32LE=function writeInt32LE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,4,0x7fffffff,-0x80000000);if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value&0xff;this[offset+1]=value>>>8;this[offset+2]=value>>>16;this[offset+3]=value>>>24;}else{objectWriteUInt32(this,value,offset,true);}
return offset+4;};Buffer.prototype.writeInt32BE=function writeInt32BE(value,offset,noAssert){value=+value;offset=offset|0;if(!noAssert)checkInt(this,value,offset,4,0x7fffffff,-0x80000000);if(value<0)value=0xffffffff+value+1;if(Buffer.TYPED_ARRAY_SUPPORT){this[offset]=value>>>24;this[offset+1]=value>>>16;this[offset+2]=value>>>8;this[offset+3]=value&0xff;}else{objectWriteUInt32(this,value,offset,false);}
return offset+4;};function checkIEEE754(buf,value,offset,ext,max,min){if(offset+ext>buf.length)throw new RangeError('Index out of range');if(offset<0)throw new RangeError('Index out of range');}
function writeFloat(buf,value,offset,littleEndian,noAssert){if(!noAssert){checkIEEE754(buf,value,offset,4,3.4028234663852886e+38,-3.4028234663852886e+38);}
ieee754.write(buf,value,offset,littleEndian,23,4);return offset+4;}
Buffer.prototype.writeFloatLE=function writeFloatLE(value,offset,noAssert){return writeFloat(this,value,offset,true,noAssert);};Buffer.prototype.writeFloatBE=function writeFloatBE(value,offset,noAssert){return writeFloat(this,value,offset,false,noAssert);};function writeDouble(buf,value,offset,littleEndian,noAssert){if(!noAssert){checkIEEE754(buf,value,offset,8,1.7976931348623157E+308,-1.7976931348623157E+308);}
ieee754.write(buf,value,offset,littleEndian,52,8);return offset+8;}
Buffer.prototype.writeDoubleLE=function writeDoubleLE(value,offset,noAssert){return writeDouble(this,value,offset,true,noAssert);};Buffer.prototype.writeDoubleBE=function writeDoubleBE(value,offset,noAssert){return writeDouble(this,value,offset,false,noAssert);};Buffer.prototype.copy=function copy(target,targetStart,start,end){if(!start)start=0;if(!end&&end!==0)end=this.length;if(targetStart>=target.length)targetStart=target.length;if(!targetStart)targetStart=0;if(end>0&&end<start)end=start;if(end===start)return 0;if(target.length===0||this.length===0)return 0;if(targetStart<0){throw new RangeError('targetStart out of bounds');}
if(start<0||start>=this.length)throw new RangeError('sourceStart out of bounds');if(end<0)throw new RangeError('sourceEnd out of bounds');if(end>this.length)end=this.length;if(target.length-targetStart<end-start){end=target.length-targetStart+start;}
var len=end-start;var i;if(this===target&&start<targetStart&&targetStart<end){for(i=len-1;i>=0;--i){target[i+targetStart]=this[i+start];}}else if(len<1000||!Buffer.TYPED_ARRAY_SUPPORT){for(i=0;i<len;++i){target[i+targetStart]=this[i+start];}}else{Uint8Array.prototype.set.call(target,this.subarray(start,start+len),targetStart);}
return len;};Buffer.prototype.fill=function fill(val,start,end,encoding){if(typeof val==='string'){if(typeof start==='string'){encoding=start;start=0;end=this.length;}else if(typeof end==='string'){encoding=end;end=this.length;}
if(val.length===1){var code=val.charCodeAt(0);if(code<256){val=code;}}
if(encoding!==undefined&&typeof encoding!=='string'){throw new TypeError('encoding must be a string');}
if(typeof encoding==='string'&&!Buffer.isEncoding(encoding)){throw new TypeError('Unknown encoding: '+encoding);}}else if(typeof val==='number'){val=val&255;}
if(start<0||this.length<start||this.length<end){throw new RangeError('Out of range index');}
if(end<=start){return this;}
start=start>>>0;end=end===undefined?this.length:end>>>0;if(!val)val=0;var i;if(typeof val==='number'){for(i=start;i<end;++i){this[i]=val;}}else{var bytes=Buffer.isBuffer(val)?val:utf8ToBytes(new Buffer(val,encoding).toString());var len=bytes.length;for(i=0;i<end-start;++i){this[i+start]=bytes[i%len];}}
return this;};var INVALID_BASE64_RE=/[^+\/0-9A-Za-z-_]/g;function base64clean(str){str=stringtrim(str).replace(INVALID_BASE64_RE,'');if(str.length<2)return'';while(str.length%4!==0){str=str+'=';}
return str;}
function stringtrim(str){if(str.trim)return str.trim();return str.replace(/^\s+|\s+$/g,'');}
function toHex(n){if(n<16)return'0'+n.toString(16);return n.toString(16);}
function utf8ToBytes(string,units){units=units||Infinity;var codePoint;var length=string.length;var leadSurrogate=null;var bytes=[];for(var i=0;i<length;++i){codePoint=string.charCodeAt(i);if(codePoint>0xD7FF&&codePoint<0xE000){if(!leadSurrogate){if(codePoint>0xDBFF){if((units-=3)>-1)bytes.push(0xEF,0xBF,0xBD);continue;}else if(i+1===length){if((units-=3)>-1)bytes.push(0xEF,0xBF,0xBD);continue;}
leadSurrogate=codePoint;continue;}
if(codePoint<0xDC00){if((units-=3)>-1)bytes.push(0xEF,0xBF,0xBD);leadSurrogate=codePoint;continue;}
codePoint=(leadSurrogate-0xD800<<10|codePoint-0xDC00)+0x10000;}else if(leadSurrogate){if((units-=3)>-1)bytes.push(0xEF,0xBF,0xBD);}
leadSurrogate=null;if(codePoint<0x80){if((units-=1)<0)break;bytes.push(codePoint);}else if(codePoint<0x800){if((units-=2)<0)break;bytes.push(codePoint>>0x6|0xC0,codePoint&0x3F|0x80);}else if(codePoint<0x10000){if((units-=3)<0)break;bytes.push(codePoint>>0xC|0xE0,codePoint>>0x6&0x3F|0x80,codePoint&0x3F|0x80);}else if(codePoint<0x110000){if((units-=4)<0)break;bytes.push(codePoint>>0x12|0xF0,codePoint>>0xC&0x3F|0x80,codePoint>>0x6&0x3F|0x80,codePoint&0x3F|0x80);}else{throw new Error('Invalid code point');}}
return bytes;}
function asciiToBytes(str){var byteArray=[];for(var i=0;i<str.length;++i){byteArray.push(str.charCodeAt(i)&0xFF);}
return byteArray;}
function utf16leToBytes(str,units){var c,hi,lo;var byteArray=[];for(var i=0;i<str.length;++i){if((units-=2)<0)break;c=str.charCodeAt(i);hi=c>>8;lo=c%256;byteArray.push(lo);byteArray.push(hi);}
return byteArray;}
function base64ToBytes(str){return base64.toByteArray(base64clean(str));}
function blitBuffer(src,dst,offset,length){for(var i=0;i<length;++i){if(i+offset>=dst.length||i>=src.length)break;dst[i+offset]=src[i];}
return i;}
function isnan(val){return val!==val;}}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"base64-js":37,"ieee754":46,"isarray":49}],44:[function(require,module,exports){(function(Buffer){function isArray(arg){if(Array.isArray){return Array.isArray(arg);}
return objectToString(arg)==='[object Array]';}
exports.isArray=isArray;function isBoolean(arg){return typeof arg==='boolean';}
exports.isBoolean=isBoolean;function isNull(arg){return arg===null;}
exports.isNull=isNull;function isNullOrUndefined(arg){return arg==null;}
exports.isNullOrUndefined=isNullOrUndefined;function isNumber(arg){return typeof arg==='number';}
exports.isNumber=isNumber;function isString(arg){return typeof arg==='string';}
exports.isString=isString;function isSymbol(arg){return typeof arg==='symbol';}
exports.isSymbol=isSymbol;function isUndefined(arg){return arg===void 0;}
exports.isUndefined=isUndefined;function isRegExp(re){return objectToString(re)==='[object RegExp]';}
exports.isRegExp=isRegExp;function isObject(arg){return typeof arg==='object'&&arg!==null;}
exports.isObject=isObject;function isDate(d){return objectToString(d)==='[object Date]';}
exports.isDate=isDate;function isError(e){return objectToString(e)==='[object Error]'||e instanceof Error;}
exports.isError=isError;function isFunction(arg){return typeof arg==='function';}
exports.isFunction=isFunction;function isPrimitive(arg){return arg===null||typeof arg==='boolean'||typeof arg==='number'||typeof arg==='string'||typeof arg==='symbol'||typeof arg==='undefined';}
exports.isPrimitive=isPrimitive;exports.isBuffer=Buffer.isBuffer;function objectToString(o){return Object.prototype.toString.call(o);}}).call(this,{"isBuffer":require("../../is-buffer/index.js")});},{"../../is-buffer/index.js":48}],45:[function(require,module,exports){function EventEmitter(){this._events=this._events||{};this._maxListeners=this._maxListeners||undefined;}
module.exports=EventEmitter;EventEmitter.EventEmitter=EventEmitter;EventEmitter.prototype._events=undefined;EventEmitter.prototype._maxListeners=undefined;EventEmitter.defaultMaxListeners=10;EventEmitter.prototype.setMaxListeners=function(n){if(!isNumber(n)||n<0||isNaN(n))
throw TypeError('n must be a positive number');this._maxListeners=n;return this;};EventEmitter.prototype.emit=function(type){var er,handler,len,args,i,listeners;if(!this._events)
this._events={};if(type==='error'){if(!this._events.error||isObject(this._events.error)&&!this._events.error.length){er=arguments[1];if(er instanceof Error){throw er;}else{var err=new Error('Uncaught, unspecified "error" event. ('+er+')');err.context=er;throw err;}}}
handler=this._events[type];if(isUndefined(handler))
return false;if(isFunction(handler)){switch(arguments.length){case 1:handler.call(this);break;case 2:handler.call(this,arguments[1]);break;case 3:handler.call(this,arguments[1],arguments[2]);break;default:args=Array.prototype.slice.call(arguments,1);handler.apply(this,args);}}else if(isObject(handler)){args=Array.prototype.slice.call(arguments,1);listeners=handler.slice();len=listeners.length;for(i=0;i<len;i++)
listeners[i].apply(this,args);}
return true;};EventEmitter.prototype.addListener=function(type,listener){var m;if(!isFunction(listener))
throw TypeError('listener must be a function');if(!this._events)
this._events={};if(this._events.newListener)
this.emit('newListener',type,isFunction(listener.listener)?listener.listener:listener);if(!this._events[type])
this._events[type]=listener;else
if(isObject(this._events[type]))
this._events[type].push(listener);else
this._events[type]=[this._events[type],listener];if(isObject(this._events[type])&&!this._events[type].warned){if(!isUndefined(this._maxListeners)){m=this._maxListeners;}else{m=EventEmitter.defaultMaxListeners;}
if(m&&m>0&&this._events[type].length>m){this._events[type].warned=true;console.error('(node) warning: possible EventEmitter memory '+'leak detected. %d listeners added. '+'Use emitter.setMaxListeners() to increase limit.',this._events[type].length);if(typeof console.trace==='function'){console.trace();}}}
return this;};EventEmitter.prototype.on=EventEmitter.prototype.addListener;EventEmitter.prototype.once=function(type,listener){if(!isFunction(listener))
throw TypeError('listener must be a function');var fired=false;function g(){this.removeListener(type,g);if(!fired){fired=true;listener.apply(this,arguments);}}
g.listener=listener;this.on(type,g);return this;};EventEmitter.prototype.removeListener=function(type,listener){var list,position,length,i;if(!isFunction(listener))
throw TypeError('listener must be a function');if(!this._events||!this._events[type])
return this;list=this._events[type];length=list.length;position=-1;if(list===listener||isFunction(list.listener)&&list.listener===listener){delete this._events[type];if(this._events.removeListener)
this.emit('removeListener',type,listener);}else if(isObject(list)){for(i=length;i-->0;){if(list[i]===listener||list[i].listener&&list[i].listener===listener){position=i;break;}}
if(position<0)
return this;if(list.length===1){list.length=0;delete this._events[type];}else{list.splice(position,1);}
if(this._events.removeListener)
this.emit('removeListener',type,listener);}
return this;};EventEmitter.prototype.removeAllListeners=function(type){var key,listeners;if(!this._events)
return this;if(!this._events.removeListener){if(arguments.length===0)
this._events={};else
if(this._events[type])
delete this._events[type];return this;}
if(arguments.length===0){for(key in this._events){if(key==='removeListener')continue;this.removeAllListeners(key);}
this.removeAllListeners('removeListener');this._events={};return this;}
listeners=this._events[type];if(isFunction(listeners)){this.removeListener(type,listeners);}else if(listeners){while(listeners.length)
this.removeListener(type,listeners[listeners.length-1]);}
delete this._events[type];return this;};EventEmitter.prototype.listeners=function(type){var ret;if(!this._events||!this._events[type])
ret=[];else
if(isFunction(this._events[type]))
ret=[this._events[type]];else
ret=this._events[type].slice();return ret;};EventEmitter.prototype.listenerCount=function(type){if(this._events){var evlistener=this._events[type];if(isFunction(evlistener))
return 1;else
if(evlistener)
return evlistener.length;}
return 0;};EventEmitter.listenerCount=function(emitter,type){return emitter.listenerCount(type);};function isFunction(arg){return typeof arg==='function';}
function isNumber(arg){return typeof arg==='number';}
function isObject(arg){return typeof arg==='object'&&arg!==null;}
function isUndefined(arg){return arg===void 0;}},{}],46:[function(require,module,exports){exports.read=function(buffer,offset,isLE,mLen,nBytes){var e,m;var eLen=nBytes*8-mLen-1;var eMax=(1<<eLen)-1;var eBias=eMax>>1;var nBits=-7;var i=isLE?nBytes-1:0;var d=isLE?-1:1;var s=buffer[offset+i];i+=d;e=s&(1<<-nBits)-1;s>>=-nBits;nBits+=eLen;for(;nBits>0;e=e*256+buffer[offset+i],i+=d,nBits-=8){}
m=e&(1<<-nBits)-1;e>>=-nBits;nBits+=mLen;for(;nBits>0;m=m*256+buffer[offset+i],i+=d,nBits-=8){}
if(e===0){e=1-eBias;}else if(e===eMax){return m?NaN:(s?-1:1)*Infinity;}else{m=m+Math.pow(2,mLen);e=e-eBias;}
return(s?-1:1)*m*Math.pow(2,e-mLen);};exports.write=function(buffer,value,offset,isLE,mLen,nBytes){var e,m,c;var eLen=nBytes*8-mLen-1;var eMax=(1<<eLen)-1;var eBias=eMax>>1;var rt=mLen===23?Math.pow(2,-24)-Math.pow(2,-77):0;var i=isLE?0:nBytes-1;var d=isLE?1:-1;var s=value<0||value===0&&1/value<0?1:0;value=Math.abs(value);if(isNaN(value)||value===Infinity){m=isNaN(value)?1:0;e=eMax;}else{e=Math.floor(Math.log(value)/Math.LN2);if(value*(c=Math.pow(2,-e))<1){e--;c*=2;}
if(e+eBias>=1){value+=rt/c;}else{value+=rt*Math.pow(2,1-eBias);}
if(value*c>=2){e++;c/=2;}
if(e+eBias>=eMax){m=0;e=eMax;}else if(e+eBias>=1){m=(value*c-1)*Math.pow(2,mLen);e=e+eBias;}else{m=value*Math.pow(2,eBias-1)*Math.pow(2,mLen);e=0;}}
for(;mLen>=8;buffer[offset+i]=m&0xff,i+=d,m/=256,mLen-=8){}
e=e<<mLen|m;eLen+=mLen;for(;eLen>0;buffer[offset+i]=e&0xff,i+=d,e/=256,eLen-=8){}
buffer[offset+i-d]|=s*128;};},{}],47:[function(require,module,exports){if(typeof Object.create==='function'){module.exports=function inherits(ctor,superCtor){ctor.super_=superCtor;ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:false,writable:true,configurable:true}});};}else{module.exports=function inherits(ctor,superCtor){ctor.super_=superCtor;var TempCtor=function(){};TempCtor.prototype=superCtor.prototype;ctor.prototype=new TempCtor();ctor.prototype.constructor=ctor;};}},{}],48:[function(require,module,exports){module.exports=function(obj){return obj!=null&&(isBuffer(obj)||isSlowBuffer(obj)||!!obj._isBuffer);};function isBuffer(obj){return!!obj.constructor&&typeof obj.constructor.isBuffer==='function'&&obj.constructor.isBuffer(obj);}
function isSlowBuffer(obj){return typeof obj.readFloatLE==='function'&&typeof obj.slice==='function'&&isBuffer(obj.slice(0,0));}},{}],49:[function(require,module,exports){var toString={}.toString;module.exports=Array.isArray||function(arr){return toString.call(arr)=='[object Array]';};},{}],50:[function(require,module,exports){'use strict';var TYPED_OK=typeof Uint8Array!=='undefined'&&typeof Uint16Array!=='undefined'&&typeof Int32Array!=='undefined';exports.assign=function(obj){var sources=Array.prototype.slice.call(arguments,1);while(sources.length){var source=sources.shift();if(!source){continue;}
if(typeof source!=='object'){throw new TypeError(source+'must be non-object');}
for(var p in source){if(source.hasOwnProperty(p)){obj[p]=source[p];}}}
return obj;};exports.shrinkBuf=function(buf,size){if(buf.length===size){return buf;}
if(buf.subarray){return buf.subarray(0,size);}
buf.length=size;return buf;};var fnTyped={arraySet:function(dest,src,src_offs,len,dest_offs){if(src.subarray&&dest.subarray){dest.set(src.subarray(src_offs,src_offs+len),dest_offs);return;}
for(var i=0;i<len;i++){dest[dest_offs+i]=src[src_offs+i];}},flattenChunks:function(chunks){var i,l,len,pos,chunk,result;len=0;for(i=0,l=chunks.length;i<l;i++){len+=chunks[i].length;}
result=new Uint8Array(len);pos=0;for(i=0,l=chunks.length;i<l;i++){chunk=chunks[i];result.set(chunk,pos);pos+=chunk.length;}
return result;}};var fnUntyped={arraySet:function(dest,src,src_offs,len,dest_offs){for(var i=0;i<len;i++){dest[dest_offs+i]=src[src_offs+i];}},flattenChunks:function(chunks){return[].concat.apply([],chunks);}};exports.setTyped=function(on){if(on){exports.Buf8=Uint8Array;exports.Buf16=Uint16Array;exports.Buf32=Int32Array;exports.assign(exports,fnTyped);}else{exports.Buf8=Array;exports.Buf16=Array;exports.Buf32=Array;exports.assign(exports,fnUntyped);}};exports.setTyped(TYPED_OK);},{}],51:[function(require,module,exports){'use strict';function adler32(adler,buf,len,pos){var s1=adler&0xffff|0,s2=adler>>>16&0xffff|0,n=0;while(len!==0){n=len>2000?2000:len;len-=n;do{s1=s1+buf[pos++]|0;s2=s2+s1|0;}while(--n);s1%=65521;s2%=65521;}
return s1|s2<<16|0;}
module.exports=adler32;},{}],52:[function(require,module,exports){'use strict';module.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8};},{}],53:[function(require,module,exports){'use strict';function makeTable(){var c,table=[];for(var n=0;n<256;n++){c=n;for(var k=0;k<8;k++){c=c&1?0xEDB88320^c>>>1:c>>>1;}
table[n]=c;}
return table;}
var crcTable=makeTable();function crc32(crc,buf,len,pos){var t=crcTable,end=pos+len;crc^=-1;for(var i=pos;i<end;i++){crc=crc>>>8^t[(crc^buf[i])&0xFF];}
return crc^-1;}
module.exports=crc32;},{}],54:[function(require,module,exports){'use strict';var utils=require('../utils/common');var trees=require('./trees');var adler32=require('./adler32');var crc32=require('./crc32');var msg=require('./messages');var Z_NO_FLUSH=0;var Z_PARTIAL_FLUSH=1;var Z_FULL_FLUSH=3;var Z_FINISH=4;var Z_BLOCK=5;var Z_OK=0;var Z_STREAM_END=1;var Z_STREAM_ERROR=-2;var Z_DATA_ERROR=-3;var Z_BUF_ERROR=-5;var Z_DEFAULT_COMPRESSION=-1;var Z_FILTERED=1;var Z_HUFFMAN_ONLY=2;var Z_RLE=3;var Z_FIXED=4;var Z_DEFAULT_STRATEGY=0;var Z_UNKNOWN=2;var Z_DEFLATED=8;var MAX_MEM_LEVEL=9;var MAX_WBITS=15;var DEF_MEM_LEVEL=8;var LENGTH_CODES=29;var LITERALS=256;var L_CODES=LITERALS+1+LENGTH_CODES;var D_CODES=30;var BL_CODES=19;var HEAP_SIZE=2*L_CODES+1;var MAX_BITS=15;var MIN_MATCH=3;var MAX_MATCH=258;var MIN_LOOKAHEAD=MAX_MATCH+MIN_MATCH+1;var PRESET_DICT=0x20;var INIT_STATE=42;var EXTRA_STATE=69;var NAME_STATE=73;var COMMENT_STATE=91;var HCRC_STATE=103;var BUSY_STATE=113;var FINISH_STATE=666;var BS_NEED_MORE=1;var BS_BLOCK_DONE=2;var BS_FINISH_STARTED=3;var BS_FINISH_DONE=4;var OS_CODE=0x03;function err(strm,errorCode){strm.msg=msg[errorCode];return errorCode;}
function rank(f){return(f<<1)-(f>4?9:0);}
function zero(buf){var len=buf.length;while(--len>=0){buf[len]=0;}}
function flush_pending(strm){var s=strm.state;var len=s.pending;if(len>strm.avail_out){len=strm.avail_out;}
if(len===0){return;}
utils.arraySet(strm.output,s.pending_buf,s.pending_out,len,strm.next_out);strm.next_out+=len;s.pending_out+=len;strm.total_out+=len;strm.avail_out-=len;s.pending-=len;if(s.pending===0){s.pending_out=0;}}
function flush_block_only(s,last){trees._tr_flush_block(s,s.block_start>=0?s.block_start:-1,s.strstart-s.block_start,last);s.block_start=s.strstart;flush_pending(s.strm);}
function put_byte(s,b){s.pending_buf[s.pending++]=b;}
function putShortMSB(s,b){s.pending_buf[s.pending++]=b>>>8&0xff;s.pending_buf[s.pending++]=b&0xff;}
function read_buf(strm,buf,start,size){var len=strm.avail_in;if(len>size){len=size;}
if(len===0){return 0;}
strm.avail_in-=len;utils.arraySet(buf,strm.input,strm.next_in,len,start);if(strm.state.wrap===1){strm.adler=adler32(strm.adler,buf,len,start);}else
if(strm.state.wrap===2){strm.adler=crc32(strm.adler,buf,len,start);}
strm.next_in+=len;strm.total_in+=len;return len;}
function longest_match(s,cur_match){var chain_length=s.max_chain_length;var scan=s.strstart;var match;var len;var best_len=s.prev_length;var nice_match=s.nice_match;var limit=s.strstart>s.w_size-MIN_LOOKAHEAD?s.strstart-(s.w_size-MIN_LOOKAHEAD):0;var _win=s.window;var wmask=s.w_mask;var prev=s.prev;var strend=s.strstart+MAX_MATCH;var scan_end1=_win[scan+best_len-1];var scan_end=_win[scan+best_len];if(s.prev_length>=s.good_match){chain_length>>=2;}
if(nice_match>s.lookahead){nice_match=s.lookahead;}
do{match=cur_match;if(_win[match+best_len]!==scan_end||_win[match+best_len-1]!==scan_end1||_win[match]!==_win[scan]||_win[++match]!==_win[scan+1]){continue;}
scan+=2;match++;do{}while(_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&_win[++scan]===_win[++match]&&scan<strend);len=MAX_MATCH-(strend-scan);scan=strend-MAX_MATCH;if(len>best_len){s.match_start=cur_match;best_len=len;if(len>=nice_match){break;}
scan_end1=_win[scan+best_len-1];scan_end=_win[scan+best_len];}}while((cur_match=prev[cur_match&wmask])>limit&&--chain_length!==0);if(best_len<=s.lookahead){return best_len;}
return s.lookahead;}
function fill_window(s){var _w_size=s.w_size;var p,n,m,more,str;do{more=s.window_size-s.lookahead-s.strstart;if(s.strstart>=_w_size+(_w_size-MIN_LOOKAHEAD)){utils.arraySet(s.window,s.window,_w_size,_w_size,0);s.match_start-=_w_size;s.strstart-=_w_size;s.block_start-=_w_size;n=s.hash_size;p=n;do{m=s.head[--p];s.head[p]=m>=_w_size?m-_w_size:0;}while(--n);n=_w_size;p=n;do{m=s.prev[--p];s.prev[p]=m>=_w_size?m-_w_size:0;}while(--n);more+=_w_size;}
if(s.strm.avail_in===0){break;}
n=read_buf(s.strm,s.window,s.strstart+s.lookahead,more);s.lookahead+=n;if(s.lookahead+s.insert>=MIN_MATCH){str=s.strstart-s.insert;s.ins_h=s.window[str];s.ins_h=(s.ins_h<<s.hash_shift^s.window[str+1])&s.hash_mask;while(s.insert){s.ins_h=(s.ins_h<<s.hash_shift^s.window[str+MIN_MATCH-1])&s.hash_mask;s.prev[str&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=str;str++;s.insert--;if(s.lookahead+s.insert<MIN_MATCH){break;}}}}while(s.lookahead<MIN_LOOKAHEAD&&s.strm.avail_in!==0);}
function deflate_stored(s,flush){var max_block_size=0xffff;if(max_block_size>s.pending_buf_size-5){max_block_size=s.pending_buf_size-5;}
for(;;){if(s.lookahead<=1){fill_window(s);if(s.lookahead===0&&flush===Z_NO_FLUSH){return BS_NEED_MORE;}
if(s.lookahead===0){break;}}
s.strstart+=s.lookahead;s.lookahead=0;var max_start=s.block_start+max_block_size;if(s.strstart===0||s.strstart>=max_start){s.lookahead=s.strstart-max_start;s.strstart=max_start;flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
if(s.strstart-s.block_start>=s.w_size-MIN_LOOKAHEAD){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}
s.insert=0;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.strstart>s.block_start){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_NEED_MORE;}
function deflate_fast(s,flush){var hash_head;var bflush;for(;;){if(s.lookahead<MIN_LOOKAHEAD){fill_window(s);if(s.lookahead<MIN_LOOKAHEAD&&flush===Z_NO_FLUSH){return BS_NEED_MORE;}
if(s.lookahead===0){break;}}
hash_head=0;if(s.lookahead>=MIN_MATCH){s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+MIN_MATCH-1])&s.hash_mask;hash_head=s.prev[s.strstart&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=s.strstart;}
if(hash_head!==0&&s.strstart-hash_head<=s.w_size-MIN_LOOKAHEAD){s.match_length=longest_match(s,hash_head);}
if(s.match_length>=MIN_MATCH){bflush=trees._tr_tally(s,s.strstart-s.match_start,s.match_length-MIN_MATCH);s.lookahead-=s.match_length;if(s.match_length<=s.max_lazy_match&&s.lookahead>=MIN_MATCH){s.match_length--;do{s.strstart++;s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+MIN_MATCH-1])&s.hash_mask;hash_head=s.prev[s.strstart&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=s.strstart;}while(--s.match_length!==0);s.strstart++;}else
{s.strstart+=s.match_length;s.match_length=0;s.ins_h=s.window[s.strstart];s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+1])&s.hash_mask;}}else{bflush=trees._tr_tally(s,0,s.window[s.strstart]);s.lookahead--;s.strstart++;}
if(bflush){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}
s.insert=s.strstart<MIN_MATCH-1?s.strstart:MIN_MATCH-1;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.last_lit){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_BLOCK_DONE;}
function deflate_slow(s,flush){var hash_head;var bflush;var max_insert;for(;;){if(s.lookahead<MIN_LOOKAHEAD){fill_window(s);if(s.lookahead<MIN_LOOKAHEAD&&flush===Z_NO_FLUSH){return BS_NEED_MORE;}
if(s.lookahead===0){break;}}
hash_head=0;if(s.lookahead>=MIN_MATCH){s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+MIN_MATCH-1])&s.hash_mask;hash_head=s.prev[s.strstart&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=s.strstart;}
s.prev_length=s.match_length;s.prev_match=s.match_start;s.match_length=MIN_MATCH-1;if(hash_head!==0&&s.prev_length<s.max_lazy_match&&s.strstart-hash_head<=s.w_size-MIN_LOOKAHEAD){s.match_length=longest_match(s,hash_head);if(s.match_length<=5&&(s.strategy===Z_FILTERED||s.match_length===MIN_MATCH&&s.strstart-s.match_start>4096)){s.match_length=MIN_MATCH-1;}}
if(s.prev_length>=MIN_MATCH&&s.match_length<=s.prev_length){max_insert=s.strstart+s.lookahead-MIN_MATCH;bflush=trees._tr_tally(s,s.strstart-1-s.prev_match,s.prev_length-MIN_MATCH);s.lookahead-=s.prev_length-1;s.prev_length-=2;do{if(++s.strstart<=max_insert){s.ins_h=(s.ins_h<<s.hash_shift^s.window[s.strstart+MIN_MATCH-1])&s.hash_mask;hash_head=s.prev[s.strstart&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=s.strstart;}}while(--s.prev_length!==0);s.match_available=0;s.match_length=MIN_MATCH-1;s.strstart++;if(bflush){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}else if(s.match_available){bflush=trees._tr_tally(s,0,s.window[s.strstart-1]);if(bflush){flush_block_only(s,false);}
s.strstart++;s.lookahead--;if(s.strm.avail_out===0){return BS_NEED_MORE;}}else{s.match_available=1;s.strstart++;s.lookahead--;}}
if(s.match_available){bflush=trees._tr_tally(s,0,s.window[s.strstart-1]);s.match_available=0;}
s.insert=s.strstart<MIN_MATCH-1?s.strstart:MIN_MATCH-1;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.last_lit){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_BLOCK_DONE;}
function deflate_rle(s,flush){var bflush;var prev;var scan,strend;var _win=s.window;for(;;){if(s.lookahead<=MAX_MATCH){fill_window(s);if(s.lookahead<=MAX_MATCH&&flush===Z_NO_FLUSH){return BS_NEED_MORE;}
if(s.lookahead===0){break;}}
s.match_length=0;if(s.lookahead>=MIN_MATCH&&s.strstart>0){scan=s.strstart-1;prev=_win[scan];if(prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]){strend=s.strstart+MAX_MATCH;do{}while(prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&prev===_win[++scan]&&scan<strend);s.match_length=MAX_MATCH-(strend-scan);if(s.match_length>s.lookahead){s.match_length=s.lookahead;}}}
if(s.match_length>=MIN_MATCH){bflush=trees._tr_tally(s,1,s.match_length-MIN_MATCH);s.lookahead-=s.match_length;s.strstart+=s.match_length;s.match_length=0;}else{bflush=trees._tr_tally(s,0,s.window[s.strstart]);s.lookahead--;s.strstart++;}
if(bflush){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}
s.insert=0;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.last_lit){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_BLOCK_DONE;}
function deflate_huff(s,flush){var bflush;for(;;){if(s.lookahead===0){fill_window(s);if(s.lookahead===0){if(flush===Z_NO_FLUSH){return BS_NEED_MORE;}
break;}}
s.match_length=0;bflush=trees._tr_tally(s,0,s.window[s.strstart]);s.lookahead--;s.strstart++;if(bflush){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}}
s.insert=0;if(flush===Z_FINISH){flush_block_only(s,true);if(s.strm.avail_out===0){return BS_FINISH_STARTED;}
return BS_FINISH_DONE;}
if(s.last_lit){flush_block_only(s,false);if(s.strm.avail_out===0){return BS_NEED_MORE;}}
return BS_BLOCK_DONE;}
function Config(good_length,max_lazy,nice_length,max_chain,func){this.good_length=good_length;this.max_lazy=max_lazy;this.nice_length=nice_length;this.max_chain=max_chain;this.func=func;}
var configuration_table;configuration_table=[new Config(0,0,0,0,deflate_stored),new Config(4,4,8,4,deflate_fast),new Config(4,5,16,8,deflate_fast),new Config(4,6,32,32,deflate_fast),new Config(4,4,16,16,deflate_slow),new Config(8,16,32,32,deflate_slow),new Config(8,16,128,128,deflate_slow),new Config(8,32,128,256,deflate_slow),new Config(32,128,258,1024,deflate_slow),new Config(32,258,258,4096,deflate_slow)];function lm_init(s){s.window_size=2*s.w_size;zero(s.head);s.max_lazy_match=configuration_table[s.level].max_lazy;s.good_match=configuration_table[s.level].good_length;s.nice_match=configuration_table[s.level].nice_length;s.max_chain_length=configuration_table[s.level].max_chain;s.strstart=0;s.block_start=0;s.lookahead=0;s.insert=0;s.match_length=s.prev_length=MIN_MATCH-1;s.match_available=0;s.ins_h=0;}
function DeflateState(){this.strm=null;this.status=0;this.pending_buf=null;this.pending_buf_size=0;this.pending_out=0;this.pending=0;this.wrap=0;this.gzhead=null;this.gzindex=0;this.method=Z_DEFLATED;this.last_flush=-1;this.w_size=0;this.w_bits=0;this.w_mask=0;this.window=null;this.window_size=0;this.prev=null;this.head=null;this.ins_h=0;this.hash_size=0;this.hash_bits=0;this.hash_mask=0;this.hash_shift=0;this.block_start=0;this.match_length=0;this.prev_match=0;this.match_available=0;this.strstart=0;this.match_start=0;this.lookahead=0;this.prev_length=0;this.max_chain_length=0;this.max_lazy_match=0;this.level=0;this.strategy=0;this.good_match=0;this.nice_match=0;this.dyn_ltree=new utils.Buf16(HEAP_SIZE*2);this.dyn_dtree=new utils.Buf16((2*D_CODES+1)*2);this.bl_tree=new utils.Buf16((2*BL_CODES+1)*2);zero(this.dyn_ltree);zero(this.dyn_dtree);zero(this.bl_tree);this.l_desc=null;this.d_desc=null;this.bl_desc=null;this.bl_count=new utils.Buf16(MAX_BITS+1);this.heap=new utils.Buf16(2*L_CODES+1);zero(this.heap);this.heap_len=0;this.heap_max=0;this.depth=new utils.Buf16(2*L_CODES+1);zero(this.depth);this.l_buf=0;this.lit_bufsize=0;this.last_lit=0;this.d_buf=0;this.opt_len=0;this.static_len=0;this.matches=0;this.insert=0;this.bi_buf=0;this.bi_valid=0;}
function deflateResetKeep(strm){var s;if(!strm||!strm.state){return err(strm,Z_STREAM_ERROR);}
strm.total_in=strm.total_out=0;strm.data_type=Z_UNKNOWN;s=strm.state;s.pending=0;s.pending_out=0;if(s.wrap<0){s.wrap=-s.wrap;}
s.status=s.wrap?INIT_STATE:BUSY_STATE;strm.adler=s.wrap===2?0:1;s.last_flush=Z_NO_FLUSH;trees._tr_init(s);return Z_OK;}
function deflateReset(strm){var ret=deflateResetKeep(strm);if(ret===Z_OK){lm_init(strm.state);}
return ret;}
function deflateSetHeader(strm,head){if(!strm||!strm.state){return Z_STREAM_ERROR;}
if(strm.state.wrap!==2){return Z_STREAM_ERROR;}
strm.state.gzhead=head;return Z_OK;}
function deflateInit2(strm,level,method,windowBits,memLevel,strategy){if(!strm){return Z_STREAM_ERROR;}
var wrap=1;if(level===Z_DEFAULT_COMPRESSION){level=6;}
if(windowBits<0){wrap=0;windowBits=-windowBits;}else
if(windowBits>15){wrap=2;windowBits-=16;}
if(memLevel<1||memLevel>MAX_MEM_LEVEL||method!==Z_DEFLATED||windowBits<8||windowBits>15||level<0||level>9||strategy<0||strategy>Z_FIXED){return err(strm,Z_STREAM_ERROR);}
if(windowBits===8){windowBits=9;}
var s=new DeflateState();strm.state=s;s.strm=strm;s.wrap=wrap;s.gzhead=null;s.w_bits=windowBits;s.w_size=1<<s.w_bits;s.w_mask=s.w_size-1;s.hash_bits=memLevel+7;s.hash_size=1<<s.hash_bits;s.hash_mask=s.hash_size-1;s.hash_shift=~~((s.hash_bits+MIN_MATCH-1)/MIN_MATCH);s.window=new utils.Buf8(s.w_size*2);s.head=new utils.Buf16(s.hash_size);s.prev=new utils.Buf16(s.w_size);s.lit_bufsize=1<<memLevel+6;s.pending_buf_size=s.lit_bufsize*4;s.pending_buf=new utils.Buf8(s.pending_buf_size);s.d_buf=1*s.lit_bufsize;s.l_buf=(1+2)*s.lit_bufsize;s.level=level;s.strategy=strategy;s.method=method;return deflateReset(strm);}
function deflateInit(strm,level){return deflateInit2(strm,level,Z_DEFLATED,MAX_WBITS,DEF_MEM_LEVEL,Z_DEFAULT_STRATEGY);}
function deflate(strm,flush){var old_flush,s;var beg,val;if(!strm||!strm.state||flush>Z_BLOCK||flush<0){return strm?err(strm,Z_STREAM_ERROR):Z_STREAM_ERROR;}
s=strm.state;if(!strm.output||!strm.input&&strm.avail_in!==0||s.status===FINISH_STATE&&flush!==Z_FINISH){return err(strm,strm.avail_out===0?Z_BUF_ERROR:Z_STREAM_ERROR);}
s.strm=strm;old_flush=s.last_flush;s.last_flush=flush;if(s.status===INIT_STATE){if(s.wrap===2){strm.adler=0;put_byte(s,31);put_byte(s,139);put_byte(s,8);if(!s.gzhead){put_byte(s,0);put_byte(s,0);put_byte(s,0);put_byte(s,0);put_byte(s,0);put_byte(s,s.level===9?2:s.strategy>=Z_HUFFMAN_ONLY||s.level<2?4:0);put_byte(s,OS_CODE);s.status=BUSY_STATE;}else
{put_byte(s,(s.gzhead.text?1:0)+(s.gzhead.hcrc?2:0)+(!s.gzhead.extra?0:4)+(!s.gzhead.name?0:8)+(!s.gzhead.comment?0:16));put_byte(s,s.gzhead.time&0xff);put_byte(s,s.gzhead.time>>8&0xff);put_byte(s,s.gzhead.time>>16&0xff);put_byte(s,s.gzhead.time>>24&0xff);put_byte(s,s.level===9?2:s.strategy>=Z_HUFFMAN_ONLY||s.level<2?4:0);put_byte(s,s.gzhead.os&0xff);if(s.gzhead.extra&&s.gzhead.extra.length){put_byte(s,s.gzhead.extra.length&0xff);put_byte(s,s.gzhead.extra.length>>8&0xff);}
if(s.gzhead.hcrc){strm.adler=crc32(strm.adler,s.pending_buf,s.pending,0);}
s.gzindex=0;s.status=EXTRA_STATE;}}else
{var header=Z_DEFLATED+(s.w_bits-8<<4)<<8;var level_flags=-1;if(s.strategy>=Z_HUFFMAN_ONLY||s.level<2){level_flags=0;}else if(s.level<6){level_flags=1;}else if(s.level===6){level_flags=2;}else{level_flags=3;}
header|=level_flags<<6;if(s.strstart!==0){header|=PRESET_DICT;}
header+=31-header%31;s.status=BUSY_STATE;putShortMSB(s,header);if(s.strstart!==0){putShortMSB(s,strm.adler>>>16);putShortMSB(s,strm.adler&0xffff);}
strm.adler=1;}}
if(s.status===EXTRA_STATE){if(s.gzhead.extra){beg=s.pending;while(s.gzindex<(s.gzhead.extra.length&0xffff)){if(s.pending===s.pending_buf_size){if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
flush_pending(strm);beg=s.pending;if(s.pending===s.pending_buf_size){break;}}
put_byte(s,s.gzhead.extra[s.gzindex]&0xff);s.gzindex++;}
if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
if(s.gzindex===s.gzhead.extra.length){s.gzindex=0;s.status=NAME_STATE;}}else
{s.status=NAME_STATE;}}
if(s.status===NAME_STATE){if(s.gzhead.name){beg=s.pending;do{if(s.pending===s.pending_buf_size){if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
flush_pending(strm);beg=s.pending;if(s.pending===s.pending_buf_size){val=1;break;}}
if(s.gzindex<s.gzhead.name.length){val=s.gzhead.name.charCodeAt(s.gzindex++)&0xff;}else{val=0;}
put_byte(s,val);}while(val!==0);if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
if(val===0){s.gzindex=0;s.status=COMMENT_STATE;}}else
{s.status=COMMENT_STATE;}}
if(s.status===COMMENT_STATE){if(s.gzhead.comment){beg=s.pending;do{if(s.pending===s.pending_buf_size){if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
flush_pending(strm);beg=s.pending;if(s.pending===s.pending_buf_size){val=1;break;}}
if(s.gzindex<s.gzhead.comment.length){val=s.gzhead.comment.charCodeAt(s.gzindex++)&0xff;}else{val=0;}
put_byte(s,val);}while(val!==0);if(s.gzhead.hcrc&&s.pending>beg){strm.adler=crc32(strm.adler,s.pending_buf,s.pending-beg,beg);}
if(val===0){s.status=HCRC_STATE;}}else
{s.status=HCRC_STATE;}}
if(s.status===HCRC_STATE){if(s.gzhead.hcrc){if(s.pending+2>s.pending_buf_size){flush_pending(strm);}
if(s.pending+2<=s.pending_buf_size){put_byte(s,strm.adler&0xff);put_byte(s,strm.adler>>8&0xff);strm.adler=0;s.status=BUSY_STATE;}}else
{s.status=BUSY_STATE;}}
if(s.pending!==0){flush_pending(strm);if(strm.avail_out===0){s.last_flush=-1;return Z_OK;}}else if(strm.avail_in===0&&rank(flush)<=rank(old_flush)&&flush!==Z_FINISH){return err(strm,Z_BUF_ERROR);}
if(s.status===FINISH_STATE&&strm.avail_in!==0){return err(strm,Z_BUF_ERROR);}
if(strm.avail_in!==0||s.lookahead!==0||flush!==Z_NO_FLUSH&&s.status!==FINISH_STATE){var bstate=s.strategy===Z_HUFFMAN_ONLY?deflate_huff(s,flush):s.strategy===Z_RLE?deflate_rle(s,flush):configuration_table[s.level].func(s,flush);if(bstate===BS_FINISH_STARTED||bstate===BS_FINISH_DONE){s.status=FINISH_STATE;}
if(bstate===BS_NEED_MORE||bstate===BS_FINISH_STARTED){if(strm.avail_out===0){s.last_flush=-1;}
return Z_OK;}
if(bstate===BS_BLOCK_DONE){if(flush===Z_PARTIAL_FLUSH){trees._tr_align(s);}else
if(flush!==Z_BLOCK){trees._tr_stored_block(s,0,0,false);if(flush===Z_FULL_FLUSH){zero(s.head);if(s.lookahead===0){s.strstart=0;s.block_start=0;s.insert=0;}}}
flush_pending(strm);if(strm.avail_out===0){s.last_flush=-1;return Z_OK;}}}
if(flush!==Z_FINISH){return Z_OK;}
if(s.wrap<=0){return Z_STREAM_END;}
if(s.wrap===2){put_byte(s,strm.adler&0xff);put_byte(s,strm.adler>>8&0xff);put_byte(s,strm.adler>>16&0xff);put_byte(s,strm.adler>>24&0xff);put_byte(s,strm.total_in&0xff);put_byte(s,strm.total_in>>8&0xff);put_byte(s,strm.total_in>>16&0xff);put_byte(s,strm.total_in>>24&0xff);}else
{putShortMSB(s,strm.adler>>>16);putShortMSB(s,strm.adler&0xffff);}
flush_pending(strm);if(s.wrap>0){s.wrap=-s.wrap;}
return s.pending!==0?Z_OK:Z_STREAM_END;}
function deflateEnd(strm){var status;if(!strm||!strm.state){return Z_STREAM_ERROR;}
status=strm.state.status;if(status!==INIT_STATE&&status!==EXTRA_STATE&&status!==NAME_STATE&&status!==COMMENT_STATE&&status!==HCRC_STATE&&status!==BUSY_STATE&&status!==FINISH_STATE)
{return err(strm,Z_STREAM_ERROR);}
strm.state=null;return status===BUSY_STATE?err(strm,Z_DATA_ERROR):Z_OK;}
function deflateSetDictionary(strm,dictionary){var dictLength=dictionary.length;var s;var str,n;var wrap;var avail;var next;var input;var tmpDict;if(!strm||!strm.state){return Z_STREAM_ERROR;}
s=strm.state;wrap=s.wrap;if(wrap===2||wrap===1&&s.status!==INIT_STATE||s.lookahead){return Z_STREAM_ERROR;}
if(wrap===1){strm.adler=adler32(strm.adler,dictionary,dictLength,0);}
s.wrap=0;if(dictLength>=s.w_size){if(wrap===0){zero(s.head);s.strstart=0;s.block_start=0;s.insert=0;}
tmpDict=new utils.Buf8(s.w_size);utils.arraySet(tmpDict,dictionary,dictLength-s.w_size,s.w_size,0);dictionary=tmpDict;dictLength=s.w_size;}
avail=strm.avail_in;next=strm.next_in;input=strm.input;strm.avail_in=dictLength;strm.next_in=0;strm.input=dictionary;fill_window(s);while(s.lookahead>=MIN_MATCH){str=s.strstart;n=s.lookahead-(MIN_MATCH-1);do{s.ins_h=(s.ins_h<<s.hash_shift^s.window[str+MIN_MATCH-1])&s.hash_mask;s.prev[str&s.w_mask]=s.head[s.ins_h];s.head[s.ins_h]=str;str++;}while(--n);s.strstart=str;s.lookahead=MIN_MATCH-1;fill_window(s);}
s.strstart+=s.lookahead;s.block_start=s.strstart;s.insert=s.lookahead;s.lookahead=0;s.match_length=s.prev_length=MIN_MATCH-1;s.match_available=0;strm.next_in=next;strm.input=input;strm.avail_in=avail;s.wrap=wrap;return Z_OK;}
exports.deflateInit=deflateInit;exports.deflateInit2=deflateInit2;exports.deflateReset=deflateReset;exports.deflateResetKeep=deflateResetKeep;exports.deflateSetHeader=deflateSetHeader;exports.deflate=deflate;exports.deflateEnd=deflateEnd;exports.deflateSetDictionary=deflateSetDictionary;exports.deflateInfo='pako deflate (from Nodeca project)';},{"../utils/common":50,"./adler32":51,"./crc32":53,"./messages":55,"./trees":56}],55:[function(require,module,exports){'use strict';module.exports={2:'need dictionary',1:'stream end',0:'','-1':'file error','-2':'stream error','-3':'data error','-4':'insufficient memory','-5':'buffer error','-6':'incompatible version'};},{}],56:[function(require,module,exports){'use strict';var utils=require('../utils/common');var Z_FIXED=4;var Z_BINARY=0;var Z_TEXT=1;var Z_UNKNOWN=2;function zero(buf){var len=buf.length;while(--len>=0){buf[len]=0;}}
var STORED_BLOCK=0;var STATIC_TREES=1;var DYN_TREES=2;var MIN_MATCH=3;var MAX_MATCH=258;var LENGTH_CODES=29;var LITERALS=256;var L_CODES=LITERALS+1+LENGTH_CODES;var D_CODES=30;var BL_CODES=19;var HEAP_SIZE=2*L_CODES+1;var MAX_BITS=15;var Buf_size=16;var MAX_BL_BITS=7;var END_BLOCK=256;var REP_3_6=16;var REPZ_3_10=17;var REPZ_11_138=18;var extra_lbits=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0];var extra_dbits=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13];var extra_blbits=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7];var bl_order=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];var DIST_CODE_LEN=512;var static_ltree=new Array((L_CODES+2)*2);zero(static_ltree);var static_dtree=new Array(D_CODES*2);zero(static_dtree);var _dist_code=new Array(DIST_CODE_LEN);zero(_dist_code);var _length_code=new Array(MAX_MATCH-MIN_MATCH+1);zero(_length_code);var base_length=new Array(LENGTH_CODES);zero(base_length);var base_dist=new Array(D_CODES);zero(base_dist);function StaticTreeDesc(static_tree,extra_bits,extra_base,elems,max_length){this.static_tree=static_tree;this.extra_bits=extra_bits;this.extra_base=extra_base;this.elems=elems;this.max_length=max_length;this.has_stree=static_tree&&static_tree.length;}
var static_l_desc;var static_d_desc;var static_bl_desc;function TreeDesc(dyn_tree,stat_desc){this.dyn_tree=dyn_tree;this.max_code=0;this.stat_desc=stat_desc;}
function d_code(dist){return dist<256?_dist_code[dist]:_dist_code[256+(dist>>>7)];}
function put_short(s,w){s.pending_buf[s.pending++]=w&0xff;s.pending_buf[s.pending++]=w>>>8&0xff;}
function send_bits(s,value,length){if(s.bi_valid>Buf_size-length){s.bi_buf|=value<<s.bi_valid&0xffff;put_short(s,s.bi_buf);s.bi_buf=value>>Buf_size-s.bi_valid;s.bi_valid+=length-Buf_size;}else{s.bi_buf|=value<<s.bi_valid&0xffff;s.bi_valid+=length;}}
function send_code(s,c,tree){send_bits(s,tree[c*2],tree[c*2+1]);}
function bi_reverse(code,len){var res=0;do{res|=code&1;code>>>=1;res<<=1;}while(--len>0);return res>>>1;}
function bi_flush(s){if(s.bi_valid===16){put_short(s,s.bi_buf);s.bi_buf=0;s.bi_valid=0;}else if(s.bi_valid>=8){s.pending_buf[s.pending++]=s.bi_buf&0xff;s.bi_buf>>=8;s.bi_valid-=8;}}
function gen_bitlen(s,desc)
{var tree=desc.dyn_tree;var max_code=desc.max_code;var stree=desc.stat_desc.static_tree;var has_stree=desc.stat_desc.has_stree;var extra=desc.stat_desc.extra_bits;var base=desc.stat_desc.extra_base;var max_length=desc.stat_desc.max_length;var h;var n,m;var bits;var xbits;var f;var overflow=0;for(bits=0;bits<=MAX_BITS;bits++){s.bl_count[bits]=0;}
tree[s.heap[s.heap_max]*2+1]=0;for(h=s.heap_max+1;h<HEAP_SIZE;h++){n=s.heap[h];bits=tree[tree[n*2+1]*2+1]+1;if(bits>max_length){bits=max_length;overflow++;}
tree[n*2+1]=bits;if(n>max_code){continue;}
s.bl_count[bits]++;xbits=0;if(n>=base){xbits=extra[n-base];}
f=tree[n*2];s.opt_len+=f*(bits+xbits);if(has_stree){s.static_len+=f*(stree[n*2+1]+xbits);}}
if(overflow===0){return;}
do{bits=max_length-1;while(s.bl_count[bits]===0){bits--;}
s.bl_count[bits]--;s.bl_count[bits+1]+=2;s.bl_count[max_length]--;overflow-=2;}while(overflow>0);for(bits=max_length;bits!==0;bits--){n=s.bl_count[bits];while(n!==0){m=s.heap[--h];if(m>max_code){continue;}
if(tree[m*2+1]!==bits){s.opt_len+=(bits-tree[m*2+1])*tree[m*2];tree[m*2+1]=bits;}
n--;}}}
function gen_codes(tree,max_code,bl_count)
{var next_code=new Array(MAX_BITS+1);var code=0;var bits;var n;for(bits=1;bits<=MAX_BITS;bits++){next_code[bits]=code=code+bl_count[bits-1]<<1;}
for(n=0;n<=max_code;n++){var len=tree[n*2+1];if(len===0){continue;}
tree[n*2]=bi_reverse(next_code[len]++,len);}}
function tr_static_init(){var n;var bits;var length;var code;var dist;var bl_count=new Array(MAX_BITS+1);length=0;for(code=0;code<LENGTH_CODES-1;code++){base_length[code]=length;for(n=0;n<1<<extra_lbits[code];n++){_length_code[length++]=code;}}
_length_code[length-1]=code;dist=0;for(code=0;code<16;code++){base_dist[code]=dist;for(n=0;n<1<<extra_dbits[code];n++){_dist_code[dist++]=code;}}
dist>>=7;for(;code<D_CODES;code++){base_dist[code]=dist<<7;for(n=0;n<1<<extra_dbits[code]-7;n++){_dist_code[256+dist++]=code;}}
for(bits=0;bits<=MAX_BITS;bits++){bl_count[bits]=0;}
n=0;while(n<=143){static_ltree[n*2+1]=8;n++;bl_count[8]++;}
while(n<=255){static_ltree[n*2+1]=9;n++;bl_count[9]++;}
while(n<=279){static_ltree[n*2+1]=7;n++;bl_count[7]++;}
while(n<=287){static_ltree[n*2+1]=8;n++;bl_count[8]++;}
gen_codes(static_ltree,L_CODES+1,bl_count);for(n=0;n<D_CODES;n++){static_dtree[n*2+1]=5;static_dtree[n*2]=bi_reverse(n,5);}
static_l_desc=new StaticTreeDesc(static_ltree,extra_lbits,LITERALS+1,L_CODES,MAX_BITS);static_d_desc=new StaticTreeDesc(static_dtree,extra_dbits,0,D_CODES,MAX_BITS);static_bl_desc=new StaticTreeDesc(new Array(0),extra_blbits,0,BL_CODES,MAX_BL_BITS);}
function init_block(s){var n;for(n=0;n<L_CODES;n++){s.dyn_ltree[n*2]=0;}
for(n=0;n<D_CODES;n++){s.dyn_dtree[n*2]=0;}
for(n=0;n<BL_CODES;n++){s.bl_tree[n*2]=0;}
s.dyn_ltree[END_BLOCK*2]=1;s.opt_len=s.static_len=0;s.last_lit=s.matches=0;}
function bi_windup(s)
{if(s.bi_valid>8){put_short(s,s.bi_buf);}else if(s.bi_valid>0){s.pending_buf[s.pending++]=s.bi_buf;}
s.bi_buf=0;s.bi_valid=0;}
function copy_block(s,buf,len,header)
{bi_windup(s);if(header){put_short(s,len);put_short(s,~len);}
utils.arraySet(s.pending_buf,s.window,buf,len,s.pending);s.pending+=len;}
function smaller(tree,n,m,depth){var _n2=n*2;var _m2=m*2;return tree[_n2]<tree[_m2]||tree[_n2]===tree[_m2]&&depth[n]<=depth[m];}
function pqdownheap(s,tree,k)
{var v=s.heap[k];var j=k<<1;while(j<=s.heap_len){if(j<s.heap_len&&smaller(tree,s.heap[j+1],s.heap[j],s.depth)){j++;}
if(smaller(tree,v,s.heap[j],s.depth)){break;}
s.heap[k]=s.heap[j];k=j;j<<=1;}
s.heap[k]=v;}
function compress_block(s,ltree,dtree)
{var dist;var lc;var lx=0;var code;var extra;if(s.last_lit!==0){do{dist=s.pending_buf[s.d_buf+lx*2]<<8|s.pending_buf[s.d_buf+lx*2+1];lc=s.pending_buf[s.l_buf+lx];lx++;if(dist===0){send_code(s,lc,ltree);}else{code=_length_code[lc];send_code(s,code+LITERALS+1,ltree);extra=extra_lbits[code];if(extra!==0){lc-=base_length[code];send_bits(s,lc,extra);}
dist--;code=d_code(dist);send_code(s,code,dtree);extra=extra_dbits[code];if(extra!==0){dist-=base_dist[code];send_bits(s,dist,extra);}}}while(lx<s.last_lit);}
send_code(s,END_BLOCK,ltree);}
function build_tree(s,desc)
{var tree=desc.dyn_tree;var stree=desc.stat_desc.static_tree;var has_stree=desc.stat_desc.has_stree;var elems=desc.stat_desc.elems;var n,m;var max_code=-1;var node;s.heap_len=0;s.heap_max=HEAP_SIZE;for(n=0;n<elems;n++){if(tree[n*2]!==0){s.heap[++s.heap_len]=max_code=n;s.depth[n]=0;}else{tree[n*2+1]=0;}}
while(s.heap_len<2){node=s.heap[++s.heap_len]=max_code<2?++max_code:0;tree[node*2]=1;s.depth[node]=0;s.opt_len--;if(has_stree){s.static_len-=stree[node*2+1];}}
desc.max_code=max_code;for(n=s.heap_len>>1;n>=1;n--){pqdownheap(s,tree,n);}
node=elems;do{n=s.heap[1];s.heap[1]=s.heap[s.heap_len--];pqdownheap(s,tree,1);m=s.heap[1];s.heap[--s.heap_max]=n;s.heap[--s.heap_max]=m;tree[node*2]=tree[n*2]+tree[m*2];s.depth[node]=(s.depth[n]>=s.depth[m]?s.depth[n]:s.depth[m])+1;tree[n*2+1]=tree[m*2+1]=node;s.heap[1]=node++;pqdownheap(s,tree,1);}while(s.heap_len>=2);s.heap[--s.heap_max]=s.heap[1];gen_bitlen(s,desc);gen_codes(tree,max_code,s.bl_count);}
function scan_tree(s,tree,max_code)
{var n;var prevlen=-1;var curlen;var nextlen=tree[0*2+1];var count=0;var max_count=7;var min_count=4;if(nextlen===0){max_count=138;min_count=3;}
tree[(max_code+1)*2+1]=0xffff;for(n=0;n<=max_code;n++){curlen=nextlen;nextlen=tree[(n+1)*2+1];if(++count<max_count&&curlen===nextlen){continue;}else if(count<min_count){s.bl_tree[curlen*2]+=count;}else if(curlen!==0){if(curlen!==prevlen){s.bl_tree[curlen*2]++;}
s.bl_tree[REP_3_6*2]++;}else if(count<=10){s.bl_tree[REPZ_3_10*2]++;}else{s.bl_tree[REPZ_11_138*2]++;}
count=0;prevlen=curlen;if(nextlen===0){max_count=138;min_count=3;}else if(curlen===nextlen){max_count=6;min_count=3;}else{max_count=7;min_count=4;}}}
function send_tree(s,tree,max_code)
{var n;var prevlen=-1;var curlen;var nextlen=tree[0*2+1];var count=0;var max_count=7;var min_count=4;if(nextlen===0){max_count=138;min_count=3;}
for(n=0;n<=max_code;n++){curlen=nextlen;nextlen=tree[(n+1)*2+1];if(++count<max_count&&curlen===nextlen){continue;}else if(count<min_count){do{send_code(s,curlen,s.bl_tree);}while(--count!==0);}else if(curlen!==0){if(curlen!==prevlen){send_code(s,curlen,s.bl_tree);count--;}
send_code(s,REP_3_6,s.bl_tree);send_bits(s,count-3,2);}else if(count<=10){send_code(s,REPZ_3_10,s.bl_tree);send_bits(s,count-3,3);}else{send_code(s,REPZ_11_138,s.bl_tree);send_bits(s,count-11,7);}
count=0;prevlen=curlen;if(nextlen===0){max_count=138;min_count=3;}else if(curlen===nextlen){max_count=6;min_count=3;}else{max_count=7;min_count=4;}}}
function build_bl_tree(s){var max_blindex;scan_tree(s,s.dyn_ltree,s.l_desc.max_code);scan_tree(s,s.dyn_dtree,s.d_desc.max_code);build_tree(s,s.bl_desc);for(max_blindex=BL_CODES-1;max_blindex>=3;max_blindex--){if(s.bl_tree[bl_order[max_blindex]*2+1]!==0){break;}}
s.opt_len+=3*(max_blindex+1)+5+5+4;return max_blindex;}
function send_all_trees(s,lcodes,dcodes,blcodes)
{var rank;send_bits(s,lcodes-257,5);send_bits(s,dcodes-1,5);send_bits(s,blcodes-4,4);for(rank=0;rank<blcodes;rank++){send_bits(s,s.bl_tree[bl_order[rank]*2+1],3);}
send_tree(s,s.dyn_ltree,lcodes-1);send_tree(s,s.dyn_dtree,dcodes-1);}
function detect_data_type(s){var black_mask=0xf3ffc07f;var n;for(n=0;n<=31;n++,black_mask>>>=1){if(black_mask&1&&s.dyn_ltree[n*2]!==0){return Z_BINARY;}}
if(s.dyn_ltree[9*2]!==0||s.dyn_ltree[10*2]!==0||s.dyn_ltree[13*2]!==0){return Z_TEXT;}
for(n=32;n<LITERALS;n++){if(s.dyn_ltree[n*2]!==0){return Z_TEXT;}}
return Z_BINARY;}
var static_init_done=false;function _tr_init(s)
{if(!static_init_done){tr_static_init();static_init_done=true;}
s.l_desc=new TreeDesc(s.dyn_ltree,static_l_desc);s.d_desc=new TreeDesc(s.dyn_dtree,static_d_desc);s.bl_desc=new TreeDesc(s.bl_tree,static_bl_desc);s.bi_buf=0;s.bi_valid=0;init_block(s);}
function _tr_stored_block(s,buf,stored_len,last)
{send_bits(s,(STORED_BLOCK<<1)+(last?1:0),3);copy_block(s,buf,stored_len,true);}
function _tr_align(s){send_bits(s,STATIC_TREES<<1,3);send_code(s,END_BLOCK,static_ltree);bi_flush(s);}
function _tr_flush_block(s,buf,stored_len,last)
{var opt_lenb,static_lenb;var max_blindex=0;if(s.level>0){if(s.strm.data_type===Z_UNKNOWN){s.strm.data_type=detect_data_type(s);}
build_tree(s,s.l_desc);build_tree(s,s.d_desc);max_blindex=build_bl_tree(s);opt_lenb=s.opt_len+3+7>>>3;static_lenb=s.static_len+3+7>>>3;if(static_lenb<=opt_lenb){opt_lenb=static_lenb;}}else{opt_lenb=static_lenb=stored_len+5;}
if(stored_len+4<=opt_lenb&&buf!==-1){_tr_stored_block(s,buf,stored_len,last);}else if(s.strategy===Z_FIXED||static_lenb===opt_lenb){send_bits(s,(STATIC_TREES<<1)+(last?1:0),3);compress_block(s,static_ltree,static_dtree);}else{send_bits(s,(DYN_TREES<<1)+(last?1:0),3);send_all_trees(s,s.l_desc.max_code+1,s.d_desc.max_code+1,max_blindex+1);compress_block(s,s.dyn_ltree,s.dyn_dtree);}
init_block(s);if(last){bi_windup(s);}}
function _tr_tally(s,dist,lc)
{s.pending_buf[s.d_buf+s.last_lit*2]=dist>>>8&0xff;s.pending_buf[s.d_buf+s.last_lit*2+1]=dist&0xff;s.pending_buf[s.l_buf+s.last_lit]=lc&0xff;s.last_lit++;if(dist===0){s.dyn_ltree[lc*2]++;}else{s.matches++;dist--;s.dyn_ltree[(_length_code[lc]+LITERALS+1)*2]++;s.dyn_dtree[d_code(dist)*2]++;}
return s.last_lit===s.lit_bufsize-1;}
exports._tr_init=_tr_init;exports._tr_stored_block=_tr_stored_block;exports._tr_flush_block=_tr_flush_block;exports._tr_tally=_tr_tally;exports._tr_align=_tr_align;},{"../utils/common":50}],57:[function(require,module,exports){'use strict';function ZStream(){this.input=null;this.next_in=0;this.avail_in=0;this.total_in=0;this.output=null;this.next_out=0;this.avail_out=0;this.total_out=0;this.msg='';this.state=null;this.data_type=2;this.adler=0;}
module.exports=ZStream;},{}],58:[function(require,module,exports){(function(process){function normalizeArray(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==='.'){parts.splice(i,1);}else if(last==='..'){parts.splice(i,1);up++;}else if(up){parts.splice(i,1);up--;}}
if(allowAboveRoot){for(;up--;up){parts.unshift('..');}}
return parts;}
var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;var splitPath=function(filename){return splitPathRe.exec(filename).slice(1);};exports.resolve=function(){var resolvedPath='',resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:process.cwd();if(typeof path!=='string'){throw new TypeError('Arguments to path.resolve must be strings');}else if(!path){continue;}
resolvedPath=path+'/'+resolvedPath;resolvedAbsolute=path.charAt(0)==='/';}
resolvedPath=normalizeArray(filter(resolvedPath.split('/'),function(p){return!!p;}),!resolvedAbsolute).join('/');return(resolvedAbsolute?'/':'')+resolvedPath||'.';};exports.normalize=function(path){var isAbsolute=exports.isAbsolute(path),trailingSlash=substr(path,-1)==='/';path=normalizeArray(filter(path.split('/'),function(p){return!!p;}),!isAbsolute).join('/');if(!path&&!isAbsolute){path='.';}
if(path&&trailingSlash){path+='/';}
return(isAbsolute?'/':'')+path;};exports.isAbsolute=function(path){return path.charAt(0)==='/';};exports.join=function(){var paths=Array.prototype.slice.call(arguments,0);return exports.normalize(filter(paths,function(p,index){if(typeof p!=='string'){throw new TypeError('Arguments to path.join must be strings');}
return p;}).join('/'));};exports.relative=function(from,to){from=exports.resolve(from).substr(1);to=exports.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=='')break;}
var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=='')break;}
if(start>end)return[];return arr.slice(start,end-start+1);}
var fromParts=trim(from.split('/'));var toParts=trim(to.split('/'));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break;}}
var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push('..');}
outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join('/');};exports.sep='/';exports.delimiter=':';exports.dirname=function(path){var result=splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){return'.';}
if(dir){dir=dir.substr(0,dir.length-1);}
return root+dir;};exports.basename=function(path,ext){var f=splitPath(path)[2];if(ext&&f.substr(-1*ext.length)===ext){f=f.substr(0,f.length-ext.length);}
return f;};exports.extname=function(path){return splitPath(path)[3];};function filter(xs,f){if(xs.filter)return xs.filter(f);var res=[];for(var i=0;i<xs.length;i++){if(f(xs[i],i,xs))res.push(xs[i]);}
return res;}
var substr='ab'.substr(-1)==='b'?function(str,start,len){return str.substr(start,len);}:function(str,start,len){if(start<0)start=str.length+start;return str.substr(start,len);};}).call(this,require('_process'));},{"_process":60}],59:[function(require,module,exports){(function(process){'use strict';if(!process.version||process.version.indexOf('v0.')===0||process.version.indexOf('v1.')===0&&process.version.indexOf('v1.8.')!==0){module.exports=nextTick;}else{module.exports=process.nextTick;}
function nextTick(fn,arg1,arg2,arg3){if(typeof fn!=='function'){throw new TypeError('"callback" argument must be a function');}
var len=arguments.length;var args,i;switch(len){case 0:case 1:return process.nextTick(fn);case 2:return process.nextTick(function afterTickOne(){fn.call(null,arg1);});case 3:return process.nextTick(function afterTickTwo(){fn.call(null,arg1,arg2);});case 4:return process.nextTick(function afterTickThree(){fn.call(null,arg1,arg2,arg3);});default:args=new Array(len-1);i=0;while(i<args.length){args[i++]=arguments[i];}
return process.nextTick(function afterTick(){fn.apply(null,args);});}}}).call(this,require('_process'));},{"_process":60}],60:[function(require,module,exports){var process=module.exports={};var cachedSetTimeout;var cachedClearTimeout;function defaultSetTimout(){throw new Error('setTimeout has not been defined');}
function defaultClearTimeout(){throw new Error('clearTimeout has not been defined');}
(function(){try{if(typeof setTimeout==='function'){cachedSetTimeout=setTimeout;}else{cachedSetTimeout=defaultSetTimout;}}catch(e){cachedSetTimeout=defaultSetTimout;}
try{if(typeof clearTimeout==='function'){cachedClearTimeout=clearTimeout;}else{cachedClearTimeout=defaultClearTimeout;}}catch(e){cachedClearTimeout=defaultClearTimeout;}})();function runTimeout(fun){if(cachedSetTimeout===setTimeout){return setTimeout(fun,0);}
if((cachedSetTimeout===defaultSetTimout||!cachedSetTimeout)&&setTimeout){cachedSetTimeout=setTimeout;return setTimeout(fun,0);}
try{return cachedSetTimeout(fun,0);}catch(e){try{return cachedSetTimeout.call(null,fun,0);}catch(e){return cachedSetTimeout.call(this,fun,0);}}}
function runClearTimeout(marker){if(cachedClearTimeout===clearTimeout){return clearTimeout(marker);}
if((cachedClearTimeout===defaultClearTimeout||!cachedClearTimeout)&&clearTimeout){cachedClearTimeout=clearTimeout;return clearTimeout(marker);}
try{return cachedClearTimeout(marker);}catch(e){try{return cachedClearTimeout.call(null,marker);}catch(e){return cachedClearTimeout.call(this,marker);}}}
var queue=[];var draining=false;var currentQueue;var queueIndex=-1;function cleanUpNextTick(){if(!draining||!currentQueue){return;}
draining=false;if(currentQueue.length){queue=currentQueue.concat(queue);}else{queueIndex=-1;}
if(queue.length){drainQueue();}}
function drainQueue(){if(draining){return;}
var timeout=runTimeout(cleanUpNextTick);draining=true;var len=queue.length;while(len){currentQueue=queue;queue=[];while(++queueIndex<len){if(currentQueue){currentQueue[queueIndex].run();}}
queueIndex=-1;len=queue.length;}
currentQueue=null;draining=false;runClearTimeout(timeout);}
process.nextTick=function(fun){var args=new Array(arguments.length-1);if(arguments.length>1){for(var i=1;i<arguments.length;i++){args[i-1]=arguments[i];}}
queue.push(new Item(fun,args));if(queue.length===1&&!draining){runTimeout(drainQueue);}};function Item(fun,array){this.fun=fun;this.array=array;}
Item.prototype.run=function(){this.fun.apply(null,this.array);};process.title='browser';process.browser=true;process.env={};process.argv=[];process.version='';process.versions={};function noop(){}
process.on=noop;process.addListener=noop;process.once=noop;process.off=noop;process.removeListener=noop;process.removeAllListeners=noop;process.emit=noop;process.binding=function(name){throw new Error('process.binding is not supported');};process.cwd=function(){return'/';};process.chdir=function(dir){throw new Error('process.chdir is not supported');};process.umask=function(){return 0;};},{}],61:[function(require,module,exports){'use strict';var objectKeys=Object.keys||function(obj){var keys=[];for(var key in obj){keys.push(key);}return keys;};module.exports=Duplex;var processNextTick=require('process-nextick-args');var util=require('core-util-is');util.inherits=require('inherits');var Readable=require('./_stream_readable');var Writable=require('./_stream_writable');util.inherits(Duplex,Readable);var keys=objectKeys(Writable.prototype);for(var v=0;v<keys.length;v++){var method=keys[v];if(!Duplex.prototype[method])Duplex.prototype[method]=Writable.prototype[method];}
function Duplex(options){if(!(this instanceof Duplex))return new Duplex(options);Readable.call(this,options);Writable.call(this,options);if(options&&options.readable===false)this.readable=false;if(options&&options.writable===false)this.writable=false;this.allowHalfOpen=true;if(options&&options.allowHalfOpen===false)this.allowHalfOpen=false;this.once('end',onend);}
function onend(){if(this.allowHalfOpen||this._writableState.ended)return;processNextTick(onEndNT,this);}
function onEndNT(self){self.end();}
function forEach(xs,f){for(var i=0,l=xs.length;i<l;i++){f(xs[i],i);}}},{"./_stream_readable":62,"./_stream_writable":64,"core-util-is":44,"inherits":47,"process-nextick-args":59}],62:[function(require,module,exports){(function(process){'use strict';module.exports=Readable;var processNextTick=require('process-nextick-args');var isArray=require('isarray');var Duplex;Readable.ReadableState=ReadableState;var EE=require('events').EventEmitter;var EElistenerCount=function(emitter,type){return emitter.listeners(type).length;};var Stream;(function(){try{Stream=require('st'+'ream');}catch(_){}finally{if(!Stream)Stream=require('events').EventEmitter;}})();var Buffer=require('buffer').Buffer;var bufferShim=require('buffer-shims');var util=require('core-util-is');util.inherits=require('inherits');var debugUtil=require('util');var debug=void 0;if(debugUtil&&debugUtil.debuglog){debug=debugUtil.debuglog('stream');}else{debug=function(){};}
var BufferList=require('./internal/streams/BufferList');var StringDecoder;util.inherits(Readable,Stream);function prependListener(emitter,event,fn){if(typeof emitter.prependListener==='function'){return emitter.prependListener(event,fn);}else{if(!emitter._events||!emitter._events[event])emitter.on(event,fn);else if(isArray(emitter._events[event]))emitter._events[event].unshift(fn);else emitter._events[event]=[fn,emitter._events[event]];}}
function ReadableState(options,stream){Duplex=Duplex||require('./_stream_duplex');options=options||{};this.objectMode=!!options.objectMode;if(stream instanceof Duplex)this.objectMode=this.objectMode||!!options.readableObjectMode;var hwm=options.highWaterMark;var defaultHwm=this.objectMode?16:16*1024;this.highWaterMark=hwm||hwm===0?hwm:defaultHwm;this.highWaterMark=~~this.highWaterMark;this.buffer=new BufferList();this.length=0;this.pipes=null;this.pipesCount=0;this.flowing=null;this.ended=false;this.endEmitted=false;this.reading=false;this.sync=true;this.needReadable=false;this.emittedReadable=false;this.readableListening=false;this.resumeScheduled=false;this.defaultEncoding=options.defaultEncoding||'utf8';this.ranOut=false;this.awaitDrain=0;this.readingMore=false;this.decoder=null;this.encoding=null;if(options.encoding){if(!StringDecoder)StringDecoder=require('string_decoder/').StringDecoder;this.decoder=new StringDecoder(options.encoding);this.encoding=options.encoding;}}
function Readable(options){Duplex=Duplex||require('./_stream_duplex');if(!(this instanceof Readable))return new Readable(options);this._readableState=new ReadableState(options,this);this.readable=true;if(options&&typeof options.read==='function')this._read=options.read;Stream.call(this);}
Readable.prototype.push=function(chunk,encoding){var state=this._readableState;if(!state.objectMode&&typeof chunk==='string'){encoding=encoding||state.defaultEncoding;if(encoding!==state.encoding){chunk=bufferShim.from(chunk,encoding);encoding='';}}
return readableAddChunk(this,state,chunk,encoding,false);};Readable.prototype.unshift=function(chunk){var state=this._readableState;return readableAddChunk(this,state,chunk,'',true);};Readable.prototype.isPaused=function(){return this._readableState.flowing===false;};function readableAddChunk(stream,state,chunk,encoding,addToFront){var er=chunkInvalid(state,chunk);if(er){stream.emit('error',er);}else if(chunk===null){state.reading=false;onEofChunk(stream,state);}else if(state.objectMode||chunk&&chunk.length>0){if(state.ended&&!addToFront){var e=new Error('stream.push() after EOF');stream.emit('error',e);}else if(state.endEmitted&&addToFront){var _e=new Error('stream.unshift() after end event');stream.emit('error',_e);}else{var skipAdd;if(state.decoder&&!addToFront&&!encoding){chunk=state.decoder.write(chunk);skipAdd=!state.objectMode&&chunk.length===0;}
if(!addToFront)state.reading=false;if(!skipAdd){if(state.flowing&&state.length===0&&!state.sync){stream.emit('data',chunk);stream.read(0);}else{state.length+=state.objectMode?1:chunk.length;if(addToFront)state.buffer.unshift(chunk);else state.buffer.push(chunk);if(state.needReadable)emitReadable(stream);}}
maybeReadMore(stream,state);}}else if(!addToFront){state.reading=false;}
return needMoreData(state);}
function needMoreData(state){return!state.ended&&(state.needReadable||state.length<state.highWaterMark||state.length===0);}
Readable.prototype.setEncoding=function(enc){if(!StringDecoder)StringDecoder=require('string_decoder/').StringDecoder;this._readableState.decoder=new StringDecoder(enc);this._readableState.encoding=enc;return this;};var MAX_HWM=0x800000;function computeNewHighWaterMark(n){if(n>=MAX_HWM){n=MAX_HWM;}else{n--;n|=n>>>1;n|=n>>>2;n|=n>>>4;n|=n>>>8;n|=n>>>16;n++;}
return n;}
function howMuchToRead(n,state){if(n<=0||state.length===0&&state.ended)return 0;if(state.objectMode)return 1;if(n!==n){if(state.flowing&&state.length)return state.buffer.head.data.length;else return state.length;}
if(n>state.highWaterMark)state.highWaterMark=computeNewHighWaterMark(n);if(n<=state.length)return n;if(!state.ended){state.needReadable=true;return 0;}
return state.length;}
Readable.prototype.read=function(n){debug('read',n);n=parseInt(n,10);var state=this._readableState;var nOrig=n;if(n!==0)state.emittedReadable=false;if(n===0&&state.needReadable&&(state.length>=state.highWaterMark||state.ended)){debug('read: emitReadable',state.length,state.ended);if(state.length===0&&state.ended)endReadable(this);else emitReadable(this);return null;}
n=howMuchToRead(n,state);if(n===0&&state.ended){if(state.length===0)endReadable(this);return null;}
var doRead=state.needReadable;debug('need readable',doRead);if(state.length===0||state.length-n<state.highWaterMark){doRead=true;debug('length less than watermark',doRead);}
if(state.ended||state.reading){doRead=false;debug('reading or ended',doRead);}else if(doRead){debug('do read');state.reading=true;state.sync=true;if(state.length===0)state.needReadable=true;this._read(state.highWaterMark);state.sync=false;if(!state.reading)n=howMuchToRead(nOrig,state);}
var ret;if(n>0)ret=fromList(n,state);else ret=null;if(ret===null){state.needReadable=true;n=0;}else{state.length-=n;}
if(state.length===0){if(!state.ended)state.needReadable=true;if(nOrig!==n&&state.ended)endReadable(this);}
if(ret!==null)this.emit('data',ret);return ret;};function chunkInvalid(state,chunk){var er=null;if(!Buffer.isBuffer(chunk)&&typeof chunk!=='string'&&chunk!==null&&chunk!==undefined&&!state.objectMode){er=new TypeError('Invalid non-string/buffer chunk');}
return er;}
function onEofChunk(stream,state){if(state.ended)return;if(state.decoder){var chunk=state.decoder.end();if(chunk&&chunk.length){state.buffer.push(chunk);state.length+=state.objectMode?1:chunk.length;}}
state.ended=true;emitReadable(stream);}
function emitReadable(stream){var state=stream._readableState;state.needReadable=false;if(!state.emittedReadable){debug('emitReadable',state.flowing);state.emittedReadable=true;if(state.sync)processNextTick(emitReadable_,stream);else emitReadable_(stream);}}
function emitReadable_(stream){debug('emit readable');stream.emit('readable');flow(stream);}
function maybeReadMore(stream,state){if(!state.readingMore){state.readingMore=true;processNextTick(maybeReadMore_,stream,state);}}
function maybeReadMore_(stream,state){var len=state.length;while(!state.reading&&!state.flowing&&!state.ended&&state.length<state.highWaterMark){debug('maybeReadMore read 0');stream.read(0);if(len===state.length)
break;else len=state.length;}
state.readingMore=false;}
Readable.prototype._read=function(n){this.emit('error',new Error('_read() is not implemented'));};Readable.prototype.pipe=function(dest,pipeOpts){var src=this;var state=this._readableState;switch(state.pipesCount){case 0:state.pipes=dest;break;case 1:state.pipes=[state.pipes,dest];break;default:state.pipes.push(dest);break;}
state.pipesCount+=1;debug('pipe count=%d opts=%j',state.pipesCount,pipeOpts);var doEnd=(!pipeOpts||pipeOpts.end!==false)&&dest!==process.stdout&&dest!==process.stderr;var endFn=doEnd?onend:cleanup;if(state.endEmitted)processNextTick(endFn);else src.once('end',endFn);dest.on('unpipe',onunpipe);function onunpipe(readable){debug('onunpipe');if(readable===src){cleanup();}}
function onend(){debug('onend');dest.end();}
var ondrain=pipeOnDrain(src);dest.on('drain',ondrain);var cleanedUp=false;function cleanup(){debug('cleanup');dest.removeListener('close',onclose);dest.removeListener('finish',onfinish);dest.removeListener('drain',ondrain);dest.removeListener('error',onerror);dest.removeListener('unpipe',onunpipe);src.removeListener('end',onend);src.removeListener('end',cleanup);src.removeListener('data',ondata);cleanedUp=true;if(state.awaitDrain&&(!dest._writableState||dest._writableState.needDrain))ondrain();}
var increasedAwaitDrain=false;src.on('data',ondata);function ondata(chunk){debug('ondata');increasedAwaitDrain=false;var ret=dest.write(chunk);if(false===ret&&!increasedAwaitDrain){if((state.pipesCount===1&&state.pipes===dest||state.pipesCount>1&&indexOf(state.pipes,dest)!==-1)&&!cleanedUp){debug('false write response, pause',src._readableState.awaitDrain);src._readableState.awaitDrain++;increasedAwaitDrain=true;}
src.pause();}}
function onerror(er){debug('onerror',er);unpipe();dest.removeListener('error',onerror);if(EElistenerCount(dest,'error')===0)dest.emit('error',er);}
prependListener(dest,'error',onerror);function onclose(){dest.removeListener('finish',onfinish);unpipe();}
dest.once('close',onclose);function onfinish(){debug('onfinish');dest.removeListener('close',onclose);unpipe();}
dest.once('finish',onfinish);function unpipe(){debug('unpipe');src.unpipe(dest);}
dest.emit('pipe',src);if(!state.flowing){debug('pipe resume');src.resume();}
return dest;};function pipeOnDrain(src){return function(){var state=src._readableState;debug('pipeOnDrain',state.awaitDrain);if(state.awaitDrain)state.awaitDrain--;if(state.awaitDrain===0&&EElistenerCount(src,'data')){state.flowing=true;flow(src);}};}
Readable.prototype.unpipe=function(dest){var state=this._readableState;if(state.pipesCount===0)return this;if(state.pipesCount===1){if(dest&&dest!==state.pipes)return this;if(!dest)dest=state.pipes;state.pipes=null;state.pipesCount=0;state.flowing=false;if(dest)dest.emit('unpipe',this);return this;}
if(!dest){var dests=state.pipes;var len=state.pipesCount;state.pipes=null;state.pipesCount=0;state.flowing=false;for(var i=0;i<len;i++){dests[i].emit('unpipe',this);}return this;}
var index=indexOf(state.pipes,dest);if(index===-1)return this;state.pipes.splice(index,1);state.pipesCount-=1;if(state.pipesCount===1)state.pipes=state.pipes[0];dest.emit('unpipe',this);return this;};Readable.prototype.on=function(ev,fn){var res=Stream.prototype.on.call(this,ev,fn);if(ev==='data'){if(this._readableState.flowing!==false)this.resume();}else if(ev==='readable'){var state=this._readableState;if(!state.endEmitted&&!state.readableListening){state.readableListening=state.needReadable=true;state.emittedReadable=false;if(!state.reading){processNextTick(nReadingNextTick,this);}else if(state.length){emitReadable(this,state);}}}
return res;};Readable.prototype.addListener=Readable.prototype.on;function nReadingNextTick(self){debug('readable nexttick read 0');self.read(0);}
Readable.prototype.resume=function(){var state=this._readableState;if(!state.flowing){debug('resume');state.flowing=true;resume(this,state);}
return this;};function resume(stream,state){if(!state.resumeScheduled){state.resumeScheduled=true;processNextTick(resume_,stream,state);}}
function resume_(stream,state){if(!state.reading){debug('resume read 0');stream.read(0);}
state.resumeScheduled=false;state.awaitDrain=0;stream.emit('resume');flow(stream);if(state.flowing&&!state.reading)stream.read(0);}
Readable.prototype.pause=function(){debug('call pause flowing=%j',this._readableState.flowing);if(false!==this._readableState.flowing){debug('pause');this._readableState.flowing=false;this.emit('pause');}
return this;};function flow(stream){var state=stream._readableState;debug('flow',state.flowing);while(state.flowing&&stream.read()!==null){}}
Readable.prototype.wrap=function(stream){var state=this._readableState;var paused=false;var self=this;stream.on('end',function(){debug('wrapped end');if(state.decoder&&!state.ended){var chunk=state.decoder.end();if(chunk&&chunk.length)self.push(chunk);}
self.push(null);});stream.on('data',function(chunk){debug('wrapped data');if(state.decoder)chunk=state.decoder.write(chunk);if(state.objectMode&&(chunk===null||chunk===undefined))return;else if(!state.objectMode&&(!chunk||!chunk.length))return;var ret=self.push(chunk);if(!ret){paused=true;stream.pause();}});for(var i in stream){if(this[i]===undefined&&typeof stream[i]==='function'){this[i]=function(method){return function(){return stream[method].apply(stream,arguments);};}(i);}}
var events=['error','close','destroy','pause','resume'];forEach(events,function(ev){stream.on(ev,self.emit.bind(self,ev));});self._read=function(n){debug('wrapped _read',n);if(paused){paused=false;stream.resume();}};return self;};Readable._fromList=fromList;function fromList(n,state){if(state.length===0)return null;var ret;if(state.objectMode)ret=state.buffer.shift();else if(!n||n>=state.length){if(state.decoder)ret=state.buffer.join('');else if(state.buffer.length===1)ret=state.buffer.head.data;else ret=state.buffer.concat(state.length);state.buffer.clear();}else{ret=fromListPartial(n,state.buffer,state.decoder);}
return ret;}
function fromListPartial(n,list,hasStrings){var ret;if(n<list.head.data.length){ret=list.head.data.slice(0,n);list.head.data=list.head.data.slice(n);}else if(n===list.head.data.length){ret=list.shift();}else{ret=hasStrings?copyFromBufferString(n,list):copyFromBuffer(n,list);}
return ret;}
function copyFromBufferString(n,list){var p=list.head;var c=1;var ret=p.data;n-=ret.length;while(p=p.next){var str=p.data;var nb=n>str.length?str.length:n;if(nb===str.length)ret+=str;else ret+=str.slice(0,n);n-=nb;if(n===0){if(nb===str.length){++c;if(p.next)list.head=p.next;else list.head=list.tail=null;}else{list.head=p;p.data=str.slice(nb);}
break;}
++c;}
list.length-=c;return ret;}
function copyFromBuffer(n,list){var ret=bufferShim.allocUnsafe(n);var p=list.head;var c=1;p.data.copy(ret);n-=p.data.length;while(p=p.next){var buf=p.data;var nb=n>buf.length?buf.length:n;buf.copy(ret,ret.length-n,0,nb);n-=nb;if(n===0){if(nb===buf.length){++c;if(p.next)list.head=p.next;else list.head=list.tail=null;}else{list.head=p;p.data=buf.slice(nb);}
break;}
++c;}
list.length-=c;return ret;}
function endReadable(stream){var state=stream._readableState;if(state.length>0)throw new Error('"endReadable()" called on non-empty stream');if(!state.endEmitted){state.ended=true;processNextTick(endReadableNT,state,stream);}}
function endReadableNT(state,stream){if(!state.endEmitted&&state.length===0){state.endEmitted=true;stream.readable=false;stream.emit('end');}}
function forEach(xs,f){for(var i=0,l=xs.length;i<l;i++){f(xs[i],i);}}
function indexOf(xs,x){for(var i=0,l=xs.length;i<l;i++){if(xs[i]===x)return i;}
return-1;}}).call(this,require('_process'));},{"./_stream_duplex":61,"./internal/streams/BufferList":65,"_process":60,"buffer":43,"buffer-shims":42,"core-util-is":44,"events":45,"inherits":47,"isarray":49,"process-nextick-args":59,"string_decoder/":67,"util":38}],63:[function(require,module,exports){'use strict';module.exports=Transform;var Duplex=require('./_stream_duplex');var util=require('core-util-is');util.inherits=require('inherits');util.inherits(Transform,Duplex);function TransformState(stream){this.afterTransform=function(er,data){return afterTransform(stream,er,data);};this.needTransform=false;this.transforming=false;this.writecb=null;this.writechunk=null;this.writeencoding=null;}
function afterTransform(stream,er,data){var ts=stream._transformState;ts.transforming=false;var cb=ts.writecb;if(!cb)return stream.emit('error',new Error('no writecb in Transform class'));ts.writechunk=null;ts.writecb=null;if(data!==null&&data!==undefined)stream.push(data);cb(er);var rs=stream._readableState;rs.reading=false;if(rs.needReadable||rs.length<rs.highWaterMark){stream._read(rs.highWaterMark);}}
function Transform(options){if(!(this instanceof Transform))return new Transform(options);Duplex.call(this,options);this._transformState=new TransformState(this);var stream=this;this._readableState.needReadable=true;this._readableState.sync=false;if(options){if(typeof options.transform==='function')this._transform=options.transform;if(typeof options.flush==='function')this._flush=options.flush;}
this.once('prefinish',function(){if(typeof this._flush==='function')this._flush(function(er,data){done(stream,er,data);});else done(stream);});}
Transform.prototype.push=function(chunk,encoding){this._transformState.needTransform=false;return Duplex.prototype.push.call(this,chunk,encoding);};Transform.prototype._transform=function(chunk,encoding,cb){throw new Error('_transform() is not implemented');};Transform.prototype._write=function(chunk,encoding,cb){var ts=this._transformState;ts.writecb=cb;ts.writechunk=chunk;ts.writeencoding=encoding;if(!ts.transforming){var rs=this._readableState;if(ts.needTransform||rs.needReadable||rs.length<rs.highWaterMark)this._read(rs.highWaterMark);}};Transform.prototype._read=function(n){var ts=this._transformState;if(ts.writechunk!==null&&ts.writecb&&!ts.transforming){ts.transforming=true;this._transform(ts.writechunk,ts.writeencoding,ts.afterTransform);}else{ts.needTransform=true;}};function done(stream,er,data){if(er)return stream.emit('error',er);if(data!==null&&data!==undefined)stream.push(data);var ws=stream._writableState;var ts=stream._transformState;if(ws.length)throw new Error('Calling transform done when ws.length != 0');if(ts.transforming)throw new Error('Calling transform done when still transforming');return stream.push(null);}},{"./_stream_duplex":61,"core-util-is":44,"inherits":47}],64:[function(require,module,exports){(function(process){'use strict';module.exports=Writable;var processNextTick=require('process-nextick-args');var asyncWrite=!process.browser&&['v0.10','v0.9.'].indexOf(process.version.slice(0,5))>-1?setImmediate:processNextTick;var Duplex;Writable.WritableState=WritableState;var util=require('core-util-is');util.inherits=require('inherits');var internalUtil={deprecate:require('util-deprecate')};var Stream;(function(){try{Stream=require('st'+'ream');}catch(_){}finally{if(!Stream)Stream=require('events').EventEmitter;}})();var Buffer=require('buffer').Buffer;var bufferShim=require('buffer-shims');util.inherits(Writable,Stream);function nop(){}
function WriteReq(chunk,encoding,cb){this.chunk=chunk;this.encoding=encoding;this.callback=cb;this.next=null;}
function WritableState(options,stream){Duplex=Duplex||require('./_stream_duplex');options=options||{};this.objectMode=!!options.objectMode;if(stream instanceof Duplex)this.objectMode=this.objectMode||!!options.writableObjectMode;var hwm=options.highWaterMark;var defaultHwm=this.objectMode?16:16*1024;this.highWaterMark=hwm||hwm===0?hwm:defaultHwm;this.highWaterMark=~~this.highWaterMark;this.needDrain=false;this.ending=false;this.ended=false;this.finished=false;var noDecode=options.decodeStrings===false;this.decodeStrings=!noDecode;this.defaultEncoding=options.defaultEncoding||'utf8';this.length=0;this.writing=false;this.corked=0;this.sync=true;this.bufferProcessing=false;this.onwrite=function(er){onwrite(stream,er);};this.writecb=null;this.writelen=0;this.bufferedRequest=null;this.lastBufferedRequest=null;this.pendingcb=0;this.prefinished=false;this.errorEmitted=false;this.bufferedRequestCount=0;this.corkedRequestsFree=new CorkedRequest(this);}
WritableState.prototype.getBuffer=function getBuffer(){var current=this.bufferedRequest;var out=[];while(current){out.push(current);current=current.next;}
return out;};(function(){try{Object.defineProperty(WritableState.prototype,'buffer',{get:internalUtil.deprecate(function(){return this.getBuffer();},'_writableState.buffer is deprecated. Use _writableState.getBuffer '+'instead.')});}catch(_){}})();var realHasInstance;if(typeof Symbol==='function'&&Symbol.hasInstance&&typeof Function.prototype[Symbol.hasInstance]==='function'){realHasInstance=Function.prototype[Symbol.hasInstance];Object.defineProperty(Writable,Symbol.hasInstance,{value:function(object){if(realHasInstance.call(this,object))return true;return object&&object._writableState instanceof WritableState;}});}else{realHasInstance=function(object){return object instanceof this;};}
function Writable(options){Duplex=Duplex||require('./_stream_duplex');if(!realHasInstance.call(Writable,this)&&!(this instanceof Duplex)){return new Writable(options);}
this._writableState=new WritableState(options,this);this.writable=true;if(options){if(typeof options.write==='function')this._write=options.write;if(typeof options.writev==='function')this._writev=options.writev;}
Stream.call(this);}
Writable.prototype.pipe=function(){this.emit('error',new Error('Cannot pipe, not readable'));};function writeAfterEnd(stream,cb){var er=new Error('write after end');stream.emit('error',er);processNextTick(cb,er);}
function validChunk(stream,state,chunk,cb){var valid=true;var er=false;if(chunk===null){er=new TypeError('May not write null values to stream');}else if(!Buffer.isBuffer(chunk)&&typeof chunk!=='string'&&chunk!==undefined&&!state.objectMode){er=new TypeError('Invalid non-string/buffer chunk');}
if(er){stream.emit('error',er);processNextTick(cb,er);valid=false;}
return valid;}
Writable.prototype.write=function(chunk,encoding,cb){var state=this._writableState;var ret=false;if(typeof encoding==='function'){cb=encoding;encoding=null;}
if(Buffer.isBuffer(chunk))encoding='buffer';else if(!encoding)encoding=state.defaultEncoding;if(typeof cb!=='function')cb=nop;if(state.ended)writeAfterEnd(this,cb);else if(validChunk(this,state,chunk,cb)){state.pendingcb++;ret=writeOrBuffer(this,state,chunk,encoding,cb);}
return ret;};Writable.prototype.cork=function(){var state=this._writableState;state.corked++;};Writable.prototype.uncork=function(){var state=this._writableState;if(state.corked){state.corked--;if(!state.writing&&!state.corked&&!state.finished&&!state.bufferProcessing&&state.bufferedRequest)clearBuffer(this,state);}};Writable.prototype.setDefaultEncoding=function setDefaultEncoding(encoding){if(typeof encoding==='string')encoding=encoding.toLowerCase();if(!(['hex','utf8','utf-8','ascii','binary','base64','ucs2','ucs-2','utf16le','utf-16le','raw'].indexOf((encoding+'').toLowerCase())>-1))throw new TypeError('Unknown encoding: '+encoding);this._writableState.defaultEncoding=encoding;return this;};function decodeChunk(state,chunk,encoding){if(!state.objectMode&&state.decodeStrings!==false&&typeof chunk==='string'){chunk=bufferShim.from(chunk,encoding);}
return chunk;}
function writeOrBuffer(stream,state,chunk,encoding,cb){chunk=decodeChunk(state,chunk,encoding);if(Buffer.isBuffer(chunk))encoding='buffer';var len=state.objectMode?1:chunk.length;state.length+=len;var ret=state.length<state.highWaterMark;if(!ret)state.needDrain=true;if(state.writing||state.corked){var last=state.lastBufferedRequest;state.lastBufferedRequest=new WriteReq(chunk,encoding,cb);if(last){last.next=state.lastBufferedRequest;}else{state.bufferedRequest=state.lastBufferedRequest;}
state.bufferedRequestCount+=1;}else{doWrite(stream,state,false,len,chunk,encoding,cb);}
return ret;}
function doWrite(stream,state,writev,len,chunk,encoding,cb){state.writelen=len;state.writecb=cb;state.writing=true;state.sync=true;if(writev)stream._writev(chunk,state.onwrite);else stream._write(chunk,encoding,state.onwrite);state.sync=false;}
function onwriteError(stream,state,sync,er,cb){--state.pendingcb;if(sync)processNextTick(cb,er);else cb(er);stream._writableState.errorEmitted=true;stream.emit('error',er);}
function onwriteStateUpdate(state){state.writing=false;state.writecb=null;state.length-=state.writelen;state.writelen=0;}
function onwrite(stream,er){var state=stream._writableState;var sync=state.sync;var cb=state.writecb;onwriteStateUpdate(state);if(er)onwriteError(stream,state,sync,er,cb);else{var finished=needFinish(state);if(!finished&&!state.corked&&!state.bufferProcessing&&state.bufferedRequest){clearBuffer(stream,state);}
if(sync){asyncWrite(afterWrite,stream,state,finished,cb);}else{afterWrite(stream,state,finished,cb);}}}
function afterWrite(stream,state,finished,cb){if(!finished)onwriteDrain(stream,state);state.pendingcb--;cb();finishMaybe(stream,state);}
function onwriteDrain(stream,state){if(state.length===0&&state.needDrain){state.needDrain=false;stream.emit('drain');}}
function clearBuffer(stream,state){state.bufferProcessing=true;var entry=state.bufferedRequest;if(stream._writev&&entry&&entry.next){var l=state.bufferedRequestCount;var buffer=new Array(l);var holder=state.corkedRequestsFree;holder.entry=entry;var count=0;while(entry){buffer[count]=entry;entry=entry.next;count+=1;}
doWrite(stream,state,true,state.length,buffer,'',holder.finish);state.pendingcb++;state.lastBufferedRequest=null;if(holder.next){state.corkedRequestsFree=holder.next;holder.next=null;}else{state.corkedRequestsFree=new CorkedRequest(state);}}else{while(entry){var chunk=entry.chunk;var encoding=entry.encoding;var cb=entry.callback;var len=state.objectMode?1:chunk.length;doWrite(stream,state,false,len,chunk,encoding,cb);entry=entry.next;if(state.writing){break;}}
if(entry===null)state.lastBufferedRequest=null;}
state.bufferedRequestCount=0;state.bufferedRequest=entry;state.bufferProcessing=false;}
Writable.prototype._write=function(chunk,encoding,cb){cb(new Error('_write() is not implemented'));};Writable.prototype._writev=null;Writable.prototype.end=function(chunk,encoding,cb){var state=this._writableState;if(typeof chunk==='function'){cb=chunk;chunk=null;encoding=null;}else if(typeof encoding==='function'){cb=encoding;encoding=null;}
if(chunk!==null&&chunk!==undefined)this.write(chunk,encoding);if(state.corked){state.corked=1;this.uncork();}
if(!state.ending&&!state.finished)endWritable(this,state,cb);};function needFinish(state){return state.ending&&state.length===0&&state.bufferedRequest===null&&!state.finished&&!state.writing;}
function prefinish(stream,state){if(!state.prefinished){state.prefinished=true;stream.emit('prefinish');}}
function finishMaybe(stream,state){var need=needFinish(state);if(need){if(state.pendingcb===0){prefinish(stream,state);state.finished=true;stream.emit('finish');}else{prefinish(stream,state);}}
return need;}
function endWritable(stream,state,cb){state.ending=true;finishMaybe(stream,state);if(cb){if(state.finished)processNextTick(cb);else stream.once('finish',cb);}
state.ended=true;stream.writable=false;}
function CorkedRequest(state){var _this=this;this.next=null;this.entry=null;this.finish=function(err){var entry=_this.entry;_this.entry=null;while(entry){var cb=entry.callback;state.pendingcb--;cb(err);entry=entry.next;}
if(state.corkedRequestsFree){state.corkedRequestsFree.next=_this;}else{state.corkedRequestsFree=_this;}};}}).call(this,require('_process'));},{"./_stream_duplex":61,"_process":60,"buffer":43,"buffer-shims":42,"core-util-is":44,"events":45,"inherits":47,"process-nextick-args":59,"util-deprecate":68}],65:[function(require,module,exports){'use strict';var Buffer=require('buffer').Buffer;var bufferShim=require('buffer-shims');module.exports=BufferList;function BufferList(){this.head=null;this.tail=null;this.length=0;}
BufferList.prototype.push=function(v){var entry={data:v,next:null};if(this.length>0)this.tail.next=entry;else this.head=entry;this.tail=entry;++this.length;};BufferList.prototype.unshift=function(v){var entry={data:v,next:this.head};if(this.length===0)this.tail=entry;this.head=entry;++this.length;};BufferList.prototype.shift=function(){if(this.length===0)return;var ret=this.head.data;if(this.length===1)this.head=this.tail=null;else this.head=this.head.next;--this.length;return ret;};BufferList.prototype.clear=function(){this.head=this.tail=null;this.length=0;};BufferList.prototype.join=function(s){if(this.length===0)return'';var p=this.head;var ret=''+p.data;while(p=p.next){ret+=s+p.data;}return ret;};BufferList.prototype.concat=function(n){if(this.length===0)return bufferShim.alloc(0);if(this.length===1)return this.head.data;var ret=bufferShim.allocUnsafe(n>>>0);var p=this.head;var i=0;while(p){p.data.copy(ret,i);i+=p.data.length;p=p.next;}
return ret;};},{"buffer":43,"buffer-shims":42}],66:[function(require,module,exports){module.exports=require("./lib/_stream_transform.js");},{"./lib/_stream_transform.js":63}],67:[function(require,module,exports){var Buffer=require('buffer').Buffer;var isBufferEncoding=Buffer.isEncoding||function(encoding){switch(encoding&&encoding.toLowerCase()){case'hex':case'utf8':case'utf-8':case'ascii':case'binary':case'base64':case'ucs2':case'ucs-2':case'utf16le':case'utf-16le':case'raw':return true;default:return false;}};function assertEncoding(encoding){if(encoding&&!isBufferEncoding(encoding)){throw new Error('Unknown encoding: '+encoding);}}
var StringDecoder=exports.StringDecoder=function(encoding){this.encoding=(encoding||'utf8').toLowerCase().replace(/[-_]/,'');assertEncoding(encoding);switch(this.encoding){case'utf8':this.surrogateSize=3;break;case'ucs2':case'utf16le':this.surrogateSize=2;this.detectIncompleteChar=utf16DetectIncompleteChar;break;case'base64':this.surrogateSize=3;this.detectIncompleteChar=base64DetectIncompleteChar;break;default:this.write=passThroughWrite;return;}
this.charBuffer=new Buffer(6);this.charReceived=0;this.charLength=0;};StringDecoder.prototype.write=function(buffer){var charStr='';while(this.charLength){var available=buffer.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:buffer.length;buffer.copy(this.charBuffer,this.charReceived,0,available);this.charReceived+=available;if(this.charReceived<this.charLength){return'';}
buffer=buffer.slice(available,buffer.length);charStr=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var charCode=charStr.charCodeAt(charStr.length-1);if(charCode>=0xD800&&charCode<=0xDBFF){this.charLength+=this.surrogateSize;charStr='';continue;}
this.charReceived=this.charLength=0;if(buffer.length===0){return charStr;}
break;}
this.detectIncompleteChar(buffer);var end=buffer.length;if(this.charLength){buffer.copy(this.charBuffer,0,buffer.length-this.charReceived,end);end-=this.charReceived;}
charStr+=buffer.toString(this.encoding,0,end);var end=charStr.length-1;var charCode=charStr.charCodeAt(end);if(charCode>=0xD800&&charCode<=0xDBFF){var size=this.surrogateSize;this.charLength+=size;this.charReceived+=size;this.charBuffer.copy(this.charBuffer,size,0,size);buffer.copy(this.charBuffer,0,0,size);return charStr.substring(0,end);}
return charStr;};StringDecoder.prototype.detectIncompleteChar=function(buffer){var i=buffer.length>=3?3:buffer.length;for(;i>0;i--){var c=buffer[buffer.length-i];if(i==1&&c>>5==0x06){this.charLength=2;break;}
if(i<=2&&c>>4==0x0E){this.charLength=3;break;}
if(i<=3&&c>>3==0x1E){this.charLength=4;break;}}
this.charReceived=i;};StringDecoder.prototype.end=function(buffer){var res='';if(buffer&&buffer.length)
res=this.write(buffer);if(this.charReceived){var cr=this.charReceived;var buf=this.charBuffer;var enc=this.encoding;res+=buf.slice(0,cr).toString(enc);}
return res;};function passThroughWrite(buffer){return buffer.toString(this.encoding);}
function utf16DetectIncompleteChar(buffer){this.charReceived=buffer.length%2;this.charLength=this.charReceived?2:0;}
function base64DetectIncompleteChar(buffer){this.charReceived=buffer.length%3;this.charLength=this.charReceived?3:0;}},{"buffer":43}],68:[function(require,module,exports){(function(global){module.exports=deprecate;function deprecate(fn,msg){if(config('noDeprecation')){return fn;}
var warned=false;function deprecated(){if(!warned){if(config('throwDeprecation')){throw new Error(msg);}else if(config('traceDeprecation')){console.trace(msg);}else{console.warn(msg);}
warned=true;}
return fn.apply(this,arguments);}
return deprecated;}
function config(name){try{if(!global.localStorage)return false;}catch(_){return false;}
var val=global.localStorage[name];if(null==val)return false;return String(val).toLowerCase()==='true';}}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{}],69:[function(require,module,exports){arguments[4][47][0].apply(exports,arguments);},{"dup":47}],70:[function(require,module,exports){module.exports=function isBuffer(arg){return arg&&typeof arg==='object'&&typeof arg.copy==='function'&&typeof arg.fill==='function'&&typeof arg.readUInt8==='function';};},{}],71:[function(require,module,exports){(function(process,global){var formatRegExp=/%[sdj%]/g;exports.format=function(f){if(!isString(f)){var objects=[];for(var i=0;i<arguments.length;i++){objects.push(inspect(arguments[i]));}
return objects.join(' ');}
var i=1;var args=arguments;var len=args.length;var str=String(f).replace(formatRegExp,function(x){if(x==='%%')return'%';if(i>=len)return x;switch(x){case'%s':return String(args[i++]);case'%d':return Number(args[i++]);case'%j':try{return JSON.stringify(args[i++]);}catch(_){return'[Circular]';}
default:return x;}});for(var x=args[i];i<len;x=args[++i]){if(isNull(x)||!isObject(x)){str+=' '+x;}else{str+=' '+inspect(x);}}
return str;};exports.deprecate=function(fn,msg){if(isUndefined(global.process)){return function(){return exports.deprecate(fn,msg).apply(this,arguments);};}
if(process.noDeprecation===true){return fn;}
var warned=false;function deprecated(){if(!warned){if(process.throwDeprecation){throw new Error(msg);}else if(process.traceDeprecation){console.trace(msg);}else{console.error(msg);}
warned=true;}
return fn.apply(this,arguments);}
return deprecated;};var debugs={};var debugEnviron;exports.debuglog=function(set){if(isUndefined(debugEnviron))
debugEnviron=process.env.NODE_DEBUG||'';set=set.toUpperCase();if(!debugs[set]){if(new RegExp('\\b'+set+'\\b','i').test(debugEnviron)){var pid=process.pid;debugs[set]=function(){var msg=exports.format.apply(exports,arguments);console.error('%s %d: %s',set,pid,msg);};}else{debugs[set]=function(){};}}
return debugs[set];};function inspect(obj,opts){var ctx={seen:[],stylize:stylizeNoColor};if(arguments.length>=3)ctx.depth=arguments[2];if(arguments.length>=4)ctx.colors=arguments[3];if(isBoolean(opts)){ctx.showHidden=opts;}else if(opts){exports._extend(ctx,opts);}
if(isUndefined(ctx.showHidden))ctx.showHidden=false;if(isUndefined(ctx.depth))ctx.depth=2;if(isUndefined(ctx.colors))ctx.colors=false;if(isUndefined(ctx.customInspect))ctx.customInspect=true;if(ctx.colors)ctx.stylize=stylizeWithColor;return formatValue(ctx,obj,ctx.depth);}
exports.inspect=inspect;inspect.colors={'bold':[1,22],'italic':[3,23],'underline':[4,24],'inverse':[7,27],'white':[37,39],'grey':[90,39],'black':[30,39],'blue':[34,39],'cyan':[36,39],'green':[32,39],'magenta':[35,39],'red':[31,39],'yellow':[33,39]};inspect.styles={'special':'cyan','number':'yellow','boolean':'yellow','undefined':'grey','null':'bold','string':'green','date':'magenta','regexp':'red'};function stylizeWithColor(str,styleType){var style=inspect.styles[styleType];if(style){return'\u001b['+inspect.colors[style][0]+'m'+str+'\u001b['+inspect.colors[style][1]+'m';}else{return str;}}
function stylizeNoColor(str,styleType){return str;}
function arrayToHash(array){var hash={};array.forEach(function(val,idx){hash[val]=true;});return hash;}
function formatValue(ctx,value,recurseTimes){if(ctx.customInspect&&value&&isFunction(value.inspect)&&value.inspect!==exports.inspect&&!(value.constructor&&value.constructor.prototype===value)){var ret=value.inspect(recurseTimes,ctx);if(!isString(ret)){ret=formatValue(ctx,ret,recurseTimes);}
return ret;}
var primitive=formatPrimitive(ctx,value);if(primitive){return primitive;}
var keys=Object.keys(value);var visibleKeys=arrayToHash(keys);if(ctx.showHidden){keys=Object.getOwnPropertyNames(value);}
if(isError(value)&&(keys.indexOf('message')>=0||keys.indexOf('description')>=0)){return formatError(value);}
if(keys.length===0){if(isFunction(value)){var name=value.name?': '+value.name:'';return ctx.stylize('[Function'+name+']','special');}
if(isRegExp(value)){return ctx.stylize(RegExp.prototype.toString.call(value),'regexp');}
if(isDate(value)){return ctx.stylize(Date.prototype.toString.call(value),'date');}
if(isError(value)){return formatError(value);}}
var base='',array=false,braces=['{','}'];if(isArray(value)){array=true;braces=['[',']'];}
if(isFunction(value)){var n=value.name?': '+value.name:'';base=' [Function'+n+']';}
if(isRegExp(value)){base=' '+RegExp.prototype.toString.call(value);}
if(isDate(value)){base=' '+Date.prototype.toUTCString.call(value);}
if(isError(value)){base=' '+formatError(value);}
if(keys.length===0&&(!array||value.length==0)){return braces[0]+base+braces[1];}
if(recurseTimes<0){if(isRegExp(value)){return ctx.stylize(RegExp.prototype.toString.call(value),'regexp');}else{return ctx.stylize('[Object]','special');}}
ctx.seen.push(value);var output;if(array){output=formatArray(ctx,value,recurseTimes,visibleKeys,keys);}else{output=keys.map(function(key){return formatProperty(ctx,value,recurseTimes,visibleKeys,key,array);});}
ctx.seen.pop();return reduceToSingleString(output,base,braces);}
function formatPrimitive(ctx,value){if(isUndefined(value))
return ctx.stylize('undefined','undefined');if(isString(value)){var simple='\''+JSON.stringify(value).replace(/^"|"$/g,'').replace(/'/g,"\\'").replace(/\\"/g,'"')+'\'';return ctx.stylize(simple,'string');}
if(isNumber(value))
return ctx.stylize(''+value,'number');if(isBoolean(value))
return ctx.stylize(''+value,'boolean');if(isNull(value))
return ctx.stylize('null','null');}
function formatError(value){return'['+Error.prototype.toString.call(value)+']';}
function formatArray(ctx,value,recurseTimes,visibleKeys,keys){var output=[];for(var i=0,l=value.length;i<l;++i){if(hasOwnProperty(value,String(i))){output.push(formatProperty(ctx,value,recurseTimes,visibleKeys,String(i),true));}else{output.push('');}}
keys.forEach(function(key){if(!key.match(/^\d+$/)){output.push(formatProperty(ctx,value,recurseTimes,visibleKeys,key,true));}});return output;}
function formatProperty(ctx,value,recurseTimes,visibleKeys,key,array){var name,str,desc;desc=Object.getOwnPropertyDescriptor(value,key)||{value:value[key]};if(desc.get){if(desc.set){str=ctx.stylize('[Getter/Setter]','special');}else{str=ctx.stylize('[Getter]','special');}}else{if(desc.set){str=ctx.stylize('[Setter]','special');}}
if(!hasOwnProperty(visibleKeys,key)){name='['+key+']';}
if(!str){if(ctx.seen.indexOf(desc.value)<0){if(isNull(recurseTimes)){str=formatValue(ctx,desc.value,null);}else{str=formatValue(ctx,desc.value,recurseTimes-1);}
if(str.indexOf('\n')>-1){if(array){str=str.split('\n').map(function(line){return'  '+line;}).join('\n').substr(2);}else{str='\n'+str.split('\n').map(function(line){return'   '+line;}).join('\n');}}}else{str=ctx.stylize('[Circular]','special');}}
if(isUndefined(name)){if(array&&key.match(/^\d+$/)){return str;}
name=JSON.stringify(''+key);if(name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)){name=name.substr(1,name.length-2);name=ctx.stylize(name,'name');}else{name=name.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'");name=ctx.stylize(name,'string');}}
return name+': '+str;}
function reduceToSingleString(output,base,braces){var numLinesEst=0;var length=output.reduce(function(prev,cur){numLinesEst++;if(cur.indexOf('\n')>=0)numLinesEst++;return prev+cur.replace(/\u001b\[\d\d?m/g,'').length+1;},0);if(length>60){return braces[0]+(base===''?'':base+'\n ')+' '+
output.join(',\n  ')+' '+
braces[1];}
return braces[0]+base+' '+output.join(', ')+' '+braces[1];}
function isArray(ar){return Array.isArray(ar);}
exports.isArray=isArray;function isBoolean(arg){return typeof arg==='boolean';}
exports.isBoolean=isBoolean;function isNull(arg){return arg===null;}
exports.isNull=isNull;function isNullOrUndefined(arg){return arg==null;}
exports.isNullOrUndefined=isNullOrUndefined;function isNumber(arg){return typeof arg==='number';}
exports.isNumber=isNumber;function isString(arg){return typeof arg==='string';}
exports.isString=isString;function isSymbol(arg){return typeof arg==='symbol';}
exports.isSymbol=isSymbol;function isUndefined(arg){return arg===void 0;}
exports.isUndefined=isUndefined;function isRegExp(re){return isObject(re)&&objectToString(re)==='[object RegExp]';}
exports.isRegExp=isRegExp;function isObject(arg){return typeof arg==='object'&&arg!==null;}
exports.isObject=isObject;function isDate(d){return isObject(d)&&objectToString(d)==='[object Date]';}
exports.isDate=isDate;function isError(e){return isObject(e)&&(objectToString(e)==='[object Error]'||e instanceof Error);}
exports.isError=isError;function isFunction(arg){return typeof arg==='function';}
exports.isFunction=isFunction;function isPrimitive(arg){return arg===null||typeof arg==='boolean'||typeof arg==='number'||typeof arg==='string'||typeof arg==='symbol'||typeof arg==='undefined';}
exports.isPrimitive=isPrimitive;exports.isBuffer=require('./support/isBuffer');function objectToString(o){return Object.prototype.toString.call(o);}
function pad(n){return n<10?'0'+n.toString(10):n.toString(10);}
var months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];function timestamp(){var d=new Date();var time=[pad(d.getHours()),pad(d.getMinutes()),pad(d.getSeconds())].join(':');return[d.getDate(),months[d.getMonth()],time].join(' ');}
exports.log=function(){console.log('%s - %s',timestamp(),exports.format.apply(exports,arguments));};exports.inherits=require('inherits');exports._extend=function(origin,add){if(!add||!isObject(add))return origin;var keys=Object.keys(add);var i=keys.length;while(i--){origin[keys[i]]=add[keys[i]];}
return origin;};function hasOwnProperty(obj,prop){return Object.prototype.hasOwnProperty.call(obj,prop);}}).call(this,require('_process'),typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./support/isBuffer":70,"_process":60,"inherits":69}],72:[function(require,module,exports){window.requestFileSystem=window.requestFileSystem||window.webkitRequestFileSystem;WebInspector.TempFile=function()
{this._fileEntry=null;this._writer=null;};WebInspector.TempFile.create=function(dirPath,name)
{var file=new WebInspector.TempFile();function requestTempFileSystem()
{return new Promise(window.requestFileSystem.bind(window,window.TEMPORARY,10));}
function getDirectoryEntry(fs)
{return new Promise(fs.root.getDirectory.bind(fs.root,dirPath,{create:true}));}
function getFileEntry(dir)
{return new Promise(dir.getFile.bind(dir,name,{create:true}));}
function createFileWriter(fileEntry)
{file._fileEntry=fileEntry;return new Promise(fileEntry.createWriter.bind(fileEntry));}
function truncateFile(writer)
{if(!writer.length){file._writer=writer;return Promise.resolve(file);}
function truncate(fulfill,reject)
{writer.onwriteend=fulfill;writer.onerror=reject;writer.truncate(0);}
function didTruncate()
{file._writer=writer;writer.onwriteend=null;writer.onerror=null;return Promise.resolve(file);}
function onTruncateError(e)
{writer.onwriteend=null;writer.onerror=null;throw e;}
return new Promise(truncate).then(didTruncate,onTruncateError);}
return WebInspector.TempFile.ensureTempStorageCleared().then(requestTempFileSystem).then(getDirectoryEntry).then(getFileEntry).then(createFileWriter).then(truncateFile);};WebInspector.TempFile.prototype={write:function(strings,callback)
{var blob=new Blob(strings,{type:"text/plain"});this._writer.onerror=function(e)
{WebInspector.console.error("Failed to write into a temp file: "+e.target.error.message);callback(-1);};this._writer.onwriteend=function(e)
{callback(e.target.length);};this._writer.write(blob);},finishWriting:function()
{this._writer=null;},read:function(callback)
{this.readRange(undefined,undefined,callback);},readRange:function(startOffset,endOffset,callback)
{function didGetFile(file)
{var reader=new FileReader();if(typeof startOffset==="number"||typeof endOffset==="number")
file=file.slice(startOffset,endOffset);reader.onloadend=function(e)
{callback(this.result);};reader.onerror=function(error)
{WebInspector.console.error("Failed to read from temp file: "+error.message);};reader.readAsText(file);}
function didFailToGetFile(error)
{WebInspector.console.error("Failed to load temp file: "+error.message);callback(null);}
this._fileEntry.file(didGetFile,didFailToGetFile);},copyToOutputStream:function(outputStream,delegate)
{function didGetFile(file)
{var reader=new WebInspector.ChunkedFileReader(file,10*1000*1000,delegate);reader.start(outputStream);}
function didFailToGetFile(error)
{WebInspector.console.error("Failed to load temp file: "+error.message);outputStream.close();}
this._fileEntry.file(didGetFile,didFailToGetFile);},remove:function()
{if(this._fileEntry)
this._fileEntry.remove(function(){});}};WebInspector.DeferredTempFile=function(dirPath,name)
{this._chunks=[];this._tempFile=null;this._isWriting=false;this._finishCallback=null;this._finishedWriting=false;this._callsPendingOpen=[];this._pendingReads=[];WebInspector.TempFile.create(dirPath,name).then(this._didCreateTempFile.bind(this),this._failedToCreateTempFile.bind(this));};WebInspector.DeferredTempFile.prototype={write:function(strings,callback)
{if(this._finishCallback)
throw new Error("No writes are allowed after close.");this._chunks.push({strings:strings,callback:callback||null});if(this._tempFile&&!this._isWriting)
this._writeNextChunk();},finishWriting:function(callback)
{this._finishCallback=callback;if(this._finishedWriting)
callback(this._tempFile);else
if(!this._isWriting&&!this._chunks.length)
this._notifyFinished();},_failedToCreateTempFile:function(e)
{WebInspector.console.error("Failed to create temp file "+e.code+" : "+e.message);this._notifyFinished();},_didCreateTempFile:function(tempFile)
{this._tempFile=tempFile;var callsPendingOpen=this._callsPendingOpen;this._callsPendingOpen=null;for(var i=0;i<callsPendingOpen.length;++i)
callsPendingOpen[i]();if(this._chunks.length)
this._writeNextChunk();},_writeNextChunk:function()
{if(!this._tempFile)
return;var chunk=this._chunks.shift();this._isWriting=true;this._tempFile.write(chunk.strings,this._didWriteChunk.bind(this,chunk.callback));},_didWriteChunk:function(callback,size)
{this._isWriting=false;if(size===-1){this._tempFile=null;this._notifyFinished();return;}
if(callback)
callback(size);if(this._chunks.length)
this._writeNextChunk();else
if(this._finishCallback)
this._notifyFinished();},_notifyFinished:function()
{this._finishedWriting=true;if(this._tempFile)
this._tempFile.finishWriting();var chunks=this._chunks;this._chunks=[];for(var i=0;i<chunks.length;++i){if(chunks[i].callback)
chunks[i].callback(-1);}
if(this._finishCallback)
this._finishCallback(this._tempFile);var pendingReads=this._pendingReads;this._pendingReads=[];for(var i=0;i<pendingReads.length;++i)
pendingReads[i]();},readRange:function(startOffset,endOffset,callback)
{if(!this._finishedWriting){this._pendingReads.push(this.readRange.bind(this,startOffset,endOffset,callback));return;}
if(!this._tempFile){callback(null);return;}
this._tempFile.readRange(startOffset,endOffset,callback);},copyToOutputStream:function(outputStream,delegate)
{if(!this._finishedWriting){this._pendingReads.push(this.copyToOutputStream.bind(this,outputStream,delegate));return;}
if(this._tempFile)
this._tempFile.copyToOutputStream(outputStream,delegate);},remove:function()
{if(this._callsPendingOpen){this._callsPendingOpen.push(this.remove.bind(this));return;}
if(this._tempFile)
this._tempFile.remove();this._tempFile=null;}};WebInspector.TempFile._clearTempStorage=function(fulfill,reject)
{function handleError(event)
{WebInspector.console.error(WebInspector.UIString("Failed to clear temp storage: %s",event.data));reject(event.data);}
function handleMessage(event)
{if(event.data.type==="tempStorageCleared"){if(event.data.error)
WebInspector.console.error(event.data.error);else
fulfill(undefined);return;}
reject(event.data);}
try{var worker=new WebInspector.Worker("temp_storage_shared_worker","TempStorageCleaner");worker.onerror=handleError;worker.onmessage=handleMessage;}catch(e){if(e.name==="URLMismatchError")
console.log("Shared worker wasn't started due to url difference. "+e);else
throw e;}};WebInspector.TempFile.ensureTempStorageCleared=function()
{if(!WebInspector.TempFile._storageCleanerPromise)
WebInspector.TempFile._storageCleanerPromise=new Promise(WebInspector.TempFile._clearTempStorage);return WebInspector.TempFile._storageCleanerPromise;};WebInspector.TempFileBackingStorage=function(dirName)
{this._dirName=dirName;this.reset();};WebInspector.TempFileBackingStorage.Chunk;WebInspector.TempFileBackingStorage.prototype={appendString:function(string)
{this._strings.push(string);this._stringsLength+=string.length;var flushStringLength=10*1024*1024;if(this._stringsLength>flushStringLength)
this._flush(false);},appendAccessibleString:function(string)
{this._flush(false);this._strings.push(string);var chunk=this._flush(true);function readString(chunk,file)
{if(chunk.string)
return Promise.resolve(chunk.string);console.assert(chunk.endOffset);if(!chunk.endOffset)
return Promise.reject("Nor string nor offset to the string in the file were found.");function readRange(fulfill,reject)
{file.readRange(chunk.startOffset,chunk.endOffset,fulfill);}
return new Promise(readRange);}
return readString.bind(null,chunk,this._file);},_flush:function(createChunk)
{if(!this._strings.length)
return null;var chunk=null;if(createChunk){console.assert(this._strings.length===1);chunk={string:this._strings[0],startOffset:0,endOffset:0};}
function didWrite(chunk,fileSize)
{if(fileSize===-1)
return;if(chunk){chunk.startOffset=this._fileSize;chunk.endOffset=fileSize;chunk.string=null;}
this._fileSize=fileSize;}
this._file.write(this._strings,didWrite.bind(this,chunk));this._strings=[];this._stringsLength=0;return chunk;},finishWriting:function()
{this._flush(false);this._file.finishWriting(function(){});},reset:function()
{if(this._file)
this._file.remove();this._file=new WebInspector.DeferredTempFile(this._dirName,String(Date.now()));this._strings=[];this._stringsLength=0;this._fileSize=0;},writeToStream:function(outputStream,delegate)
{this._file.copyToOutputStream(outputStream,delegate);}};},{}],73:[function(require,module,exports){WebInspector.Color=function(rgba,format,originalText)
{this._rgba=rgba;this._originalText=originalText||null;this._originalTextIsValid=!!this._originalText;this._format=format;if(typeof this._rgba[3]==="undefined")
this._rgba[3]=1;for(var i=0;i<4;++i){if(this._rgba[i]<0){this._rgba[i]=0;this._originalTextIsValid=false;}
if(this._rgba[i]>1){this._rgba[i]=1;this._originalTextIsValid=false;}}};WebInspector.Color.Regex=/((?:rgb|hsl)a?\([^)]+\)|#[0-9a-fA-F]{6}|#[0-9a-fA-F]{3}|\b[a-zA-Z]+\b(?!-))/g;WebInspector.Color.Format={Original:"original",Nickname:"nickname",HEX:"hex",ShortHEX:"shorthex",RGB:"rgb",RGBA:"rgba",HSL:"hsl",HSLA:"hsla"};WebInspector.Color.parse=function(text)
{var value=text.toLowerCase().replace(/\s+/g,"");var simple=/^(?:#([0-9a-f]{3}|[0-9a-f]{6})|rgb\(((?:-?\d+%?,){2}-?\d+%?)\)|(\w+)|hsl\((-?\d+\.?\d*(?:,-?\d+\.?\d*%){2})\))$/i;var match=value.match(simple);if(match){if(match[1]){var hex=match[1].toLowerCase();var format;if(hex.length===3){format=WebInspector.Color.Format.ShortHEX;hex=hex.charAt(0)+hex.charAt(0)+hex.charAt(1)+hex.charAt(1)+hex.charAt(2)+hex.charAt(2);}else
format=WebInspector.Color.Format.HEX;var r=parseInt(hex.substring(0,2),16);var g=parseInt(hex.substring(2,4),16);var b=parseInt(hex.substring(4,6),16);return new WebInspector.Color([r/255,g/255,b/255,1],format,text);}
if(match[2]){var rgbString=match[2].split(/\s*,\s*/);var rgba=[WebInspector.Color._parseRgbNumeric(rgbString[0]),WebInspector.Color._parseRgbNumeric(rgbString[1]),WebInspector.Color._parseRgbNumeric(rgbString[2]),1];return new WebInspector.Color(rgba,WebInspector.Color.Format.RGB,text);}
if(match[3]){var nickname=match[3].toLowerCase();if(nickname in WebInspector.Color.Nicknames){var rgba=WebInspector.Color.Nicknames[nickname];var color=WebInspector.Color.fromRGBA(rgba);color._format=WebInspector.Color.Format.Nickname;color._originalText=text;return color;}
return null;}
if(match[4]){var hslString=match[4].replace(/%/g,"").split(/\s*,\s*/);var hsla=[WebInspector.Color._parseHueNumeric(hslString[0]),WebInspector.Color._parseSatLightNumeric(hslString[1]),WebInspector.Color._parseSatLightNumeric(hslString[2]),1];var rgba=[];WebInspector.Color.hsl2rgb(hsla,rgba);return new WebInspector.Color(rgba,WebInspector.Color.Format.HSL,text);}
return null;}
var advanced=/^(?:rgba\(((?:-?\d+%?,){3}-?(?:\d+|\d*\.\d+))\)|hsla\((-?(?:\d+|\d*\.\d+)(?:,-?(?:\d+|\d*\.\d+)*%){2},-?(?:\d+|\d*\.\d+))\))$/;match=value.match(advanced);if(match){if(match[1]){var rgbaString=match[1].split(/\s*,\s*/);var rgba=[WebInspector.Color._parseRgbNumeric(rgbaString[0]),WebInspector.Color._parseRgbNumeric(rgbaString[1]),WebInspector.Color._parseRgbNumeric(rgbaString[2]),WebInspector.Color._parseAlphaNumeric(rgbaString[3])];return new WebInspector.Color(rgba,WebInspector.Color.Format.RGBA,text);}
if(match[2]){var hslaString=match[2].replace(/%/g,"").split(/\s*,\s*/);var hsla=[WebInspector.Color._parseHueNumeric(hslaString[0]),WebInspector.Color._parseSatLightNumeric(hslaString[1]),WebInspector.Color._parseSatLightNumeric(hslaString[2]),WebInspector.Color._parseAlphaNumeric(hslaString[3])];var rgba=[];WebInspector.Color.hsl2rgb(hsla,rgba);return new WebInspector.Color(rgba,WebInspector.Color.Format.HSLA,text);}}
return null;};WebInspector.Color.fromRGBA=function(rgba)
{return new WebInspector.Color([rgba[0]/255,rgba[1]/255,rgba[2]/255,rgba[3]],WebInspector.Color.Format.RGBA);};WebInspector.Color.fromHSVA=function(hsva)
{var rgba=[];WebInspector.Color.hsva2rgba(hsva,rgba);return new WebInspector.Color(rgba,WebInspector.Color.Format.HSLA);};WebInspector.Color.prototype={format:function()
{return this._format;},hsla:function()
{if(this._hsla)
return this._hsla;var r=this._rgba[0];var g=this._rgba[1];var b=this._rgba[2];var max=Math.max(r,g,b);var min=Math.min(r,g,b);var diff=max-min;var add=max+min;if(min===max)
var h=0;else
if(r===max)
var h=(1/6*(g-b)/diff+1)%1;else
if(g===max)
var h=1/6*(b-r)/diff+1/3;else
var h=1/6*(r-g)/diff+2/3;var l=0.5*add;if(l===0)
var s=0;else
if(l===1)
var s=0;else
if(l<=0.5)
var s=diff/add;else
var s=diff/(2-add);this._hsla=[h,s,l,this._rgba[3]];return this._hsla;},canonicalHSLA:function()
{var hsla=this.hsla();return[Math.round(hsla[0]*360),Math.round(hsla[1]*100),Math.round(hsla[2]*100),hsla[3]];},hsva:function()
{var hsla=this.hsla();var h=hsla[0];var s=hsla[1];var l=hsla[2];s*=l<0.5?l:1-l;return[h,s!==0?2*s/(l+s):0,l+s,hsla[3]];},hasAlpha:function()
{return this._rgba[3]!==1;},canBeShortHex:function()
{if(this.hasAlpha())
return false;for(var i=0;i<3;++i){var c=Math.round(this._rgba[i]*255);if(c%17)
return false;}
return true;},asString:function(format)
{if(format===this._format&&this._originalTextIsValid)
return this._originalText;if(!format)
format=this._format;function toRgbValue(value)
{return Math.round(value*255);}
function toHexValue(value)
{var hex=Math.round(value*255).toString(16);return hex.length===1?"0"+hex:hex;}
function toShortHexValue(value)
{return(Math.round(value*255)/17).toString(16);}
switch(format){case WebInspector.Color.Format.Original:return this._originalText;case WebInspector.Color.Format.RGB:if(this.hasAlpha())
return null;return String.sprintf("rgb(%d, %d, %d)",toRgbValue(this._rgba[0]),toRgbValue(this._rgba[1]),toRgbValue(this._rgba[2]));case WebInspector.Color.Format.RGBA:return String.sprintf("rgba(%d, %d, %d, %f)",toRgbValue(this._rgba[0]),toRgbValue(this._rgba[1]),toRgbValue(this._rgba[2]),this._rgba[3]);case WebInspector.Color.Format.HSL:if(this.hasAlpha())
return null;var hsl=this.hsla();return String.sprintf("hsl(%d, %d%, %d%)",Math.round(hsl[0]*360),Math.round(hsl[1]*100),Math.round(hsl[2]*100));case WebInspector.Color.Format.HSLA:var hsla=this.hsla();return String.sprintf("hsla(%d, %d%, %d%, %f)",Math.round(hsla[0]*360),Math.round(hsla[1]*100),Math.round(hsla[2]*100),hsla[3]);case WebInspector.Color.Format.HEX:if(this.hasAlpha())
return null;return String.sprintf("#%s%s%s",toHexValue(this._rgba[0]),toHexValue(this._rgba[1]),toHexValue(this._rgba[2])).toLowerCase();case WebInspector.Color.Format.ShortHEX:if(!this.canBeShortHex())
return null;return String.sprintf("#%s%s%s",toShortHexValue(this._rgba[0]),toShortHexValue(this._rgba[1]),toShortHexValue(this._rgba[2])).toLowerCase();case WebInspector.Color.Format.Nickname:return this.nickname();}
return this._originalText;},rgba:function()
{return this._rgba.slice();},canonicalRGBA:function()
{var rgba=new Array(4);for(var i=0;i<3;++i)
rgba[i]=Math.round(this._rgba[i]*255);rgba[3]=this._rgba[3];return rgba;},nickname:function()
{if(!WebInspector.Color._rgbaToNickname){WebInspector.Color._rgbaToNickname={};for(var nickname in WebInspector.Color.Nicknames){var rgba=WebInspector.Color.Nicknames[nickname];if(rgba.length!==4)
rgba=rgba.concat(1);WebInspector.Color._rgbaToNickname[rgba]=nickname;}}
return WebInspector.Color._rgbaToNickname[this.canonicalRGBA()]||null;},toProtocolRGBA:function()
{var rgba=this.canonicalRGBA();var result={r:rgba[0],g:rgba[1],b:rgba[2]};if(rgba[3]!==1)
result.a=rgba[3];return result;},invert:function()
{var rgba=[];rgba[0]=1-this._rgba[0];rgba[1]=1-this._rgba[1];rgba[2]=1-this._rgba[2];rgba[3]=this._rgba[3];return new WebInspector.Color(rgba,WebInspector.Color.Format.RGBA);},setAlpha:function(alpha)
{var rgba=this._rgba.slice();rgba[3]=alpha;return new WebInspector.Color(rgba,WebInspector.Color.Format.RGBA);}};WebInspector.Color._parseRgbNumeric=function(value)
{var parsed=parseInt(value,10);if(value.indexOf("%")!==-1)
parsed/=100;else
parsed/=255;return parsed;};WebInspector.Color._parseHueNumeric=function(value)
{return isNaN(value)?0:parseFloat(value)/360%1;};WebInspector.Color._parseSatLightNumeric=function(value)
{return Math.min(1,parseFloat(value)/100);};WebInspector.Color._parseAlphaNumeric=function(value)
{return isNaN(value)?0:parseFloat(value);};WebInspector.Color._hsva2hsla=function(hsva,out_hsla)
{var h=hsva[0];var s=hsva[1];var v=hsva[2];var t=(2-s)*v;if(v===0||s===0)
s=0;else
s*=v/(t<1?t:2-t);out_hsla[0]=h;out_hsla[1]=s;out_hsla[2]=t/2;out_hsla[3]=hsva[3];};WebInspector.Color.hsl2rgb=function(hsl,out_rgb)
{var h=hsl[0];var s=hsl[1];var l=hsl[2];function hue2rgb(p,q,h)
{if(h<0)
h+=1;else
if(h>1)
h-=1;if(h*6<1)
return p+(q-p)*h*6;else
if(h*2<1)
return q;else
if(h*3<2)
return p+(q-p)*(2/3-h)*6;else
return p;}
if(s<0)
s=0;if(l<=0.5)
var q=l*(1+s);else
var q=l+s-l*s;var p=2*l-q;var tr=h+1/3;var tg=h;var tb=h-1/3;out_rgb[0]=hue2rgb(p,q,tr);out_rgb[1]=hue2rgb(p,q,tg);out_rgb[2]=hue2rgb(p,q,tb);out_rgb[3]=hsl[3];};WebInspector.Color.hsva2rgba=function(hsva,out_rgba)
{WebInspector.Color._hsva2hsla(hsva,WebInspector.Color.hsva2rgba._tmpHSLA);WebInspector.Color.hsl2rgb(WebInspector.Color.hsva2rgba._tmpHSLA,out_rgba);for(var i=0;i<WebInspector.Color.hsva2rgba._tmpHSLA.length;i++)
WebInspector.Color.hsva2rgba._tmpHSLA[i]=0;};WebInspector.Color.hsva2rgba._tmpHSLA=[0,0,0,0];WebInspector.Color.luminance=function(rgba)
{var rSRGB=rgba[0];var gSRGB=rgba[1];var bSRGB=rgba[2];var r=rSRGB<=0.03928?rSRGB/12.92:Math.pow((rSRGB+0.055)/1.055,2.4);var g=gSRGB<=0.03928?gSRGB/12.92:Math.pow((gSRGB+0.055)/1.055,2.4);var b=bSRGB<=0.03928?bSRGB/12.92:Math.pow((bSRGB+0.055)/1.055,2.4);return 0.2126*r+0.7152*g+0.0722*b;};WebInspector.Color.blendColors=function(fgRGBA,bgRGBA,out_blended)
{var alpha=fgRGBA[3];out_blended[0]=(1-alpha)*bgRGBA[0]+alpha*fgRGBA[0];out_blended[1]=(1-alpha)*bgRGBA[1]+alpha*fgRGBA[1];out_blended[2]=(1-alpha)*bgRGBA[2]+alpha*fgRGBA[2];out_blended[3]=alpha+bgRGBA[3]*(1-alpha);};WebInspector.Color.calculateContrastRatio=function(fgRGBA,bgRGBA)
{WebInspector.Color.blendColors(fgRGBA,bgRGBA,WebInspector.Color.calculateContrastRatio._blendedFg);var fgLuminance=WebInspector.Color.luminance(WebInspector.Color.calculateContrastRatio._blendedFg);var bgLuminance=WebInspector.Color.luminance(bgRGBA);var contrastRatio=(Math.max(fgLuminance,bgLuminance)+0.05)/(Math.min(fgLuminance,bgLuminance)+0.05);for(var i=0;i<WebInspector.Color.calculateContrastRatio._blendedFg.length;i++)
WebInspector.Color.calculateContrastRatio._blendedFg[i]=0;return contrastRatio;};WebInspector.Color.calculateContrastRatio._blendedFg=[0,0,0,0];WebInspector.Color.desiredLuminance=function(luminance,contrast,lighter)
{function computeLuminance()
{if(lighter)
return(luminance+0.05)*contrast-0.05;else
return(luminance+0.05)/contrast-0.05;}
var desiredLuminance=computeLuminance();if(desiredLuminance<0||desiredLuminance>1){lighter=!lighter;desiredLuminance=computeLuminance();}
return desiredLuminance;};WebInspector.Color.Nicknames={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[237,20,61],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgrey":[169,169,169],"darkgreen":[0,100,0],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"grey":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgreen":[144,238,144],"lightgray":[211,211,211],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50],"transparent":[0,0,0,0]};WebInspector.Color.PageHighlight={Content:WebInspector.Color.fromRGBA([111,168,220,.66]),ContentLight:WebInspector.Color.fromRGBA([111,168,220,.5]),ContentOutline:WebInspector.Color.fromRGBA([9,83,148]),Padding:WebInspector.Color.fromRGBA([147,196,125,.55]),PaddingLight:WebInspector.Color.fromRGBA([147,196,125,.4]),Border:WebInspector.Color.fromRGBA([255,229,153,.66]),BorderLight:WebInspector.Color.fromRGBA([255,229,153,.5]),Margin:WebInspector.Color.fromRGBA([246,178,107,.66]),MarginLight:WebInspector.Color.fromRGBA([246,178,107,.5]),EventTarget:WebInspector.Color.fromRGBA([255,196,196,.66]),Shape:WebInspector.Color.fromRGBA([96,82,177,0.8]),ShapeMargin:WebInspector.Color.fromRGBA([96,82,127,.6])};WebInspector.Color.detectColorFormat=function(color)
{const cf=WebInspector.Color.Format;var format;var formatSetting=WebInspector.moduleSetting("colorFormat").get();if(formatSetting===cf.Original)
format=cf.Original;else
if(formatSetting===cf.RGB)
format=color.hasAlpha()?cf.RGBA:cf.RGB;else
if(formatSetting===cf.HSL)
format=color.hasAlpha()?cf.HSLA:cf.HSL;else
if(!color.hasAlpha())
format=color.canBeShortHex()?cf.ShortHEX:cf.HEX;else
format=cf.RGBA;return format;};},{}],74:[function(require,module,exports){WebInspector.Object=function(){};WebInspector.Object.prototype={addEventListener:function(eventType,listener,thisObject)
{if(!listener)
console.assert(false);if(!this._listeners)
this._listeners=new Map();if(!this._listeners.has(eventType))
this._listeners.set(eventType,[]);this._listeners.get(eventType).push({thisObject:thisObject,listener:listener});return new WebInspector.EventTarget.EventDescriptor(this,eventType,thisObject,listener);},removeEventListener:function(eventType,listener,thisObject)
{console.assert(listener);if(!this._listeners||!this._listeners.has(eventType))
return;var listeners=this._listeners.get(eventType);for(var i=0;i<listeners.length;++i){if(listeners[i].listener===listener&&listeners[i].thisObject===thisObject)
listeners.splice(i--,1);}
if(!listeners.length)
this._listeners.delete(eventType);},removeAllListeners:function()
{delete this._listeners;},hasEventListeners:function(eventType)
{return this._listeners&&this._listeners.has(eventType);},dispatchEventToListeners:function(eventType,eventData)
{if(!this._listeners||!this._listeners.has(eventType))
return false;var event=new WebInspector.Event(this,eventType,eventData);var listeners=this._listeners.get(eventType).slice(0);for(var i=0;i<listeners.length;++i){listeners[i].listener.call(listeners[i].thisObject,event);if(event._stoppedPropagation)
break;}
return event.defaultPrevented;}};WebInspector.Event=function(target,type,data)
{this.target=target;this.type=type;this.data=data;this.defaultPrevented=false;this._stoppedPropagation=false;};WebInspector.Event.prototype={stopPropagation:function()
{this._stoppedPropagation=true;},preventDefault:function()
{this.defaultPrevented=true;},consume:function(preventDefault)
{this.stopPropagation();if(preventDefault)
this.preventDefault();}};WebInspector.EventTarget=function()
{};WebInspector.EventTarget.removeEventListeners=function(eventList)
{for(var i=0;i<eventList.length;++i){var eventInfo=eventList[i];eventInfo.eventTarget.removeEventListener(eventInfo.eventType,eventInfo.method,eventInfo.receiver);}
eventList.splice(0,eventList.length);};WebInspector.EventTarget.prototype={addEventListener:function(eventType,listener,thisObject){},removeEventListener:function(eventType,listener,thisObject){},removeAllListeners:function(){},hasEventListeners:function(eventType){},dispatchEventToListeners:function(eventType,eventData){}};WebInspector.EventTarget.EventDescriptor=function(eventTarget,eventType,receiver,method)
{this.eventTarget=eventTarget;this.eventType=eventType;this.receiver=receiver;this.method=method;};},{}],75:[function(require,module,exports){WebInspector.ParsedURL=function(url)
{this.isValid=false;this.url=url;this.scheme="";this.host="";this.port="";this.path="";this.queryParams="";this.fragment="";this.folderPathComponents="";this.lastPathComponent="";var match=url.match(/^([A-Za-z][A-Za-z0-9+.-]*):\/\/([^\s\/:]*)(?::([\d]+))?(?:(\/[^#]*)(?:#(.*))?)?$/i);if(match){this.isValid=true;this.scheme=match[1].toLowerCase();this.host=match[2];this.port=match[3];this.path=match[4]||"/";this.fragment=match[5];}else{if(this.url.startsWith("data:")){this.scheme="data";return;}
if(this.url==="about:blank"){this.scheme="about";return;}
this.path=this.url;}
var path=this.path;var indexOfQuery=path.indexOf("?");if(indexOfQuery!==-1){this.queryParams=path.substring(indexOfQuery+1);path=path.substring(0,indexOfQuery);}
var lastSlashIndex=path.lastIndexOf("/");if(lastSlashIndex!==-1){this.folderPathComponents=path.substring(0,lastSlashIndex);this.lastPathComponent=path.substring(lastSlashIndex+1);}else
this.lastPathComponent=path;};WebInspector.ParsedURL.splitURLIntoPathComponents=function(url)
{if(url.startsWith("/"))
url="file://"+url;var parsedURL=new WebInspector.ParsedURL(url);var origin;var folderPath;var name;if(parsedURL.isValid){origin=parsedURL.scheme+"://"+parsedURL.host;if(parsedURL.port)
origin+=":"+parsedURL.port;folderPath=parsedURL.folderPathComponents;name=parsedURL.lastPathComponent;if(parsedURL.queryParams)
name+="?"+parsedURL.queryParams;}else{origin="";folderPath="";name=url;}
var result=[origin];var splittedPath=folderPath.split("/");for(var i=1;i<splittedPath.length;++i){if(!splittedPath[i])
continue;result.push(splittedPath[i]);}
result.push(name);return result;};WebInspector.ParsedURL.extractOrigin=function(url)
{var parsedURL=new WebInspector.ParsedURL(url);if(!parsedURL.isValid)
return"";var origin=parsedURL.scheme+"://"+parsedURL.host;if(parsedURL.port)
origin+=":"+parsedURL.port;return origin;};WebInspector.ParsedURL.extractExtension=function(url)
{var lastIndexOfDot=url.lastIndexOf(".");var extension=lastIndexOfDot!==-1?url.substr(lastIndexOfDot+1):"";var indexOfQuestionMark=extension.indexOf("?");if(indexOfQuestionMark!==-1)
extension=extension.substr(0,indexOfQuestionMark);return extension;};WebInspector.ParsedURL.extractName=function(url)
{var index=url.lastIndexOf("/");return index!==-1?url.substr(index+1):url;};WebInspector.ParsedURL.completeURL=function(baseURL,href)
{if(href){var trimmedHref=href.trim();if(trimmedHref.startsWith("data:")||trimmedHref.startsWith("blob:")||trimmedHref.startsWith("javascript:"))
return href;var parsedHref=trimmedHref.asParsedURL();if(parsedHref&&parsedHref.scheme)
return trimmedHref;}else{return baseURL;}
var parsedURL=baseURL.asParsedURL();if(parsedURL){if(parsedURL.isDataURL())
return href;var path=href;var query=path.indexOf("?");var postfix="";if(query!==-1){postfix=path.substring(query);path=path.substring(0,query);}else{var fragment=path.indexOf("#");if(fragment!==-1){postfix=path.substring(fragment);path=path.substring(0,fragment);}}
if(!path){var basePath=parsedURL.path;if(postfix.charAt(0)==="?"){var baseQuery=parsedURL.path.indexOf("?");if(baseQuery!==-1)
basePath=basePath.substring(0,baseQuery);}
return parsedURL.scheme+"://"+parsedURL.host+(parsedURL.port?":"+parsedURL.port:"")+basePath+postfix;}else if(path.charAt(0)!=="/"){var prefix=parsedURL.path;var prefixQuery=prefix.indexOf("?");if(prefixQuery!==-1)
prefix=prefix.substring(0,prefixQuery);prefix=prefix.substring(0,prefix.lastIndexOf("/"))+"/";path=prefix+path;}else if(path.length>1&&path.charAt(1)==="/"){return parsedURL.scheme+":"+path+postfix;}
return parsedURL.scheme+"://"+parsedURL.host+(parsedURL.port?":"+parsedURL.port:"")+Runtime.normalizePath(path)+postfix;}
return null;};WebInspector.ParsedURL.prototype={get displayName()
{if(this._displayName)
return this._displayName;if(this.isDataURL())
return this.dataURLDisplayName();if(this.isAboutBlank())
return this.url;this._displayName=this.lastPathComponent;if(!this._displayName)
this._displayName=(this.host||"")+"/";if(this._displayName==="/")
this._displayName=this.url;return this._displayName;},dataURLDisplayName:function()
{if(this._dataURLDisplayName)
return this._dataURLDisplayName;if(!this.isDataURL())
return"";this._dataURLDisplayName=this.url.trimEnd(20);return this._dataURLDisplayName;},isAboutBlank:function()
{return this.url==="about:blank";},isDataURL:function()
{return this.scheme==="data";},lastPathComponentWithFragment:function()
{return this.lastPathComponent+(this.fragment?"#"+this.fragment:"");},domain:function()
{if(this.isDataURL())
return"data:";return this.host+(this.port?":"+this.port:"");},securityOrigin:function()
{if(this.isDataURL())
return"data:";return this.scheme+"://"+this.domain();},urlWithoutScheme:function()
{if(this.scheme&&this.url.startsWith(this.scheme+"://"))
return this.url.substring(this.scheme.length+3);return this.url;}};WebInspector.ParsedURL.splitLineAndColumn=function(string)
{var lineColumnRegEx=/(?::(\d+))?(?::(\d+))?$/;var lineColumnMatch=lineColumnRegEx.exec(string);var lineNumber;var columnNumber;console.assert(lineColumnMatch);if(typeof lineColumnMatch[1]==="string"){lineNumber=parseInt(lineColumnMatch[1],10);lineNumber=isNaN(lineNumber)?undefined:lineNumber-1;}
if(typeof lineColumnMatch[2]==="string"){columnNumber=parseInt(lineColumnMatch[2],10);columnNumber=isNaN(columnNumber)?undefined:columnNumber-1;}
return{url:string.substring(0,string.length-lineColumnMatch[0].length),lineNumber:lineNumber,columnNumber:columnNumber};};WebInspector.ParsedURL.isRelativeURL=function(url)
{return!/^[A-Za-z][A-Za-z0-9+.-]*:/.test(url);};String.prototype.asParsedURL=function()
{var parsedURL=new WebInspector.ParsedURL(this.toString());if(parsedURL.isValid)
return parsedURL;return null;};},{}],76:[function(require,module,exports){WebInspector.ResourceType=function(name,title,category,isTextType)
{this._name=name;this._title=title;this._category=category;this._isTextType=isTextType;};WebInspector.ResourceType.prototype={name:function()
{return this._name;},title:function()
{return this._title;},category:function()
{return this._category;},isTextType:function()
{return this._isTextType;},isScript:function()
{return this._name==="script"||this._name==="sm-script";},hasScripts:function()
{return this.isScript()||this.isDocument();},isStyleSheet:function()
{return this._name==="stylesheet"||this._name==="sm-stylesheet";},isDocument:function()
{return this._name==="document";},isDocumentOrScriptOrStyleSheet:function()
{return this.isDocument()||this.isScript()||this.isStyleSheet();},isFromSourceMap:function()
{return this._name.startsWith("sm-");},toString:function()
{return this._name;},canonicalMimeType:function()
{if(this.isDocument())
return"text/html";if(this.isScript())
return"text/javascript";if(this.isStyleSheet())
return"text/css";return"";}};WebInspector.ResourceCategory=function(title,shortTitle)
{this.title=title;this.shortTitle=shortTitle;};WebInspector.resourceCategories={XHR:new WebInspector.ResourceCategory("XHR and Fetch","XHR"),Script:new WebInspector.ResourceCategory("Scripts","JS"),Stylesheet:new WebInspector.ResourceCategory("Stylesheets","CSS"),Image:new WebInspector.ResourceCategory("Images","Img"),Media:new WebInspector.ResourceCategory("Media","Media"),Font:new WebInspector.ResourceCategory("Fonts","Font"),Document:new WebInspector.ResourceCategory("Documents","Doc"),WebSocket:new WebInspector.ResourceCategory("WebSockets","WS"),Manifest:new WebInspector.ResourceCategory("Manifest","Manifest"),Other:new WebInspector.ResourceCategory("Other","Other")};WebInspector.resourceTypes={XHR:new WebInspector.ResourceType("xhr","XHR",WebInspector.resourceCategories.XHR,true),Fetch:new WebInspector.ResourceType("fetch","Fetch",WebInspector.resourceCategories.XHR,true),EventSource:new WebInspector.ResourceType("eventsource","EventSource",WebInspector.resourceCategories.XHR,true),Script:new WebInspector.ResourceType("script","Script",WebInspector.resourceCategories.Script,true),Stylesheet:new WebInspector.ResourceType("stylesheet","Stylesheet",WebInspector.resourceCategories.Stylesheet,true),Image:new WebInspector.ResourceType("image","Image",WebInspector.resourceCategories.Image,false),Media:new WebInspector.ResourceType("media","Media",WebInspector.resourceCategories.Media,false),Font:new WebInspector.ResourceType("font","Font",WebInspector.resourceCategories.Font,false),Document:new WebInspector.ResourceType("document","Document",WebInspector.resourceCategories.Document,true),TextTrack:new WebInspector.ResourceType("texttrack","TextTrack",WebInspector.resourceCategories.Other,true),WebSocket:new WebInspector.ResourceType("websocket","WebSocket",WebInspector.resourceCategories.WebSocket,false),Other:new WebInspector.ResourceType("other","Other",WebInspector.resourceCategories.Other,false),SourceMapScript:new WebInspector.ResourceType("sm-script","Script",WebInspector.resourceCategories.Script,false),SourceMapStyleSheet:new WebInspector.ResourceType("sm-stylesheet","Stylesheet",WebInspector.resourceCategories.Stylesheet,false),Manifest:new WebInspector.ResourceType("manifest","Manifest",WebInspector.resourceCategories.Manifest,true)};WebInspector.ResourceType.mimeFromURL=function(url)
{var name=WebInspector.ParsedURL.extractName(url);if(WebInspector.ResourceType._mimeTypeByName.has(name)){return WebInspector.ResourceType._mimeTypeByName.get(name);}
var ext=WebInspector.ParsedURL.extractExtension(url).toLowerCase();return WebInspector.ResourceType._mimeTypeByExtension.get(ext);};WebInspector.ResourceType._mimeTypeByName=new Map([["Cakefile","text/x-coffeescript"]]);WebInspector.ResourceType._mimeTypeByExtension=new Map([["js","text/javascript"],["css","text/css"],["html","text/html"],["htm","text/html"],["xml","application/xml"],["xsl","application/xml"],["asp","application/x-aspx"],["aspx","application/x-aspx"],["jsp","application/x-jsp"],["c","text/x-c++src"],["cc","text/x-c++src"],["cpp","text/x-c++src"],["h","text/x-c++src"],["m","text/x-c++src"],["mm","text/x-c++src"],["coffee","text/x-coffeescript"],["dart","text/javascript"],["ts","text/typescript"],["tsx","text/typescript"],["json","application/json"],["gyp","application/json"],["gypi","application/json"],["cs","text/x-csharp"],["java","text/x-java"],["less","text/x-less"],["php","text/x-php"],["phtml","application/x-httpd-php"],["py","text/x-python"],["sh","text/x-sh"],["scss","text/x-scss"],["vtt","text/vtt"],["ls","text/x-livescript"],["cljs","text/x-clojure"],["cljc","text/x-clojure"],["cljx","text/x-clojure"],["styl","text/x-styl"],["jsx","text/jsx"],["jpeg","image/jpeg"],["jpg","image/jpeg"],["svg","image/svg"],["gif","image/gif"],["webp","image/webp"],["png","image/png"],["ico","image/ico"],["tiff","image/tiff"],["tif","image/tif"],["bmp","image/bmp"],["ttf","font/opentype"],["otf","font/opentype"],["ttc","font/opentype"],["woff","application/font-woff"]]);},{}],77:[function(require,module,exports){WebInspector.Segment=function(begin,end,data)
{if(begin>end)
console.assert(false,"Invalid segment");this.begin=begin;this.end=end;this.data=data;};WebInspector.Segment.prototype={intersects:function(that)
{return this.begin<that.end&&that.begin<this.end;}};WebInspector.SegmentedRange=function(mergeCallback)
{this._segments=[];this._mergeCallback=mergeCallback;};WebInspector.SegmentedRange.prototype={append:function(newSegment)
{var startIndex=this._segments.lowerBound(newSegment,(a,b)=>a.begin-b.begin);var endIndex=startIndex;var merged=null;if(startIndex>0){var precedingSegment=this._segments[startIndex-1];merged=this._tryMerge(precedingSegment,newSegment);if(merged){--startIndex;newSegment=merged;}else if(this._segments[startIndex-1].end>=newSegment.begin){if(newSegment.end<precedingSegment.end)
this._segments.splice(startIndex,0,new WebInspector.Segment(newSegment.end,precedingSegment.end,precedingSegment.data));precedingSegment.end=newSegment.begin;}}
while(endIndex<this._segments.length&&this._segments[endIndex].end<=newSegment.end)
++endIndex;if(endIndex<this._segments.length){merged=this._tryMerge(newSegment,this._segments[endIndex]);if(merged){endIndex++;newSegment=merged;}else if(newSegment.intersects(this._segments[endIndex]))
this._segments[endIndex].begin=newSegment.end;}
this._segments.splice(startIndex,endIndex-startIndex,newSegment);},appendRange:function(that)
{that.segments().forEach(segment=>this.append(segment));},segments:function()
{return this._segments;},_tryMerge:function(first,second)
{var merged=this._mergeCallback&&this._mergeCallback(first,second);if(!merged)
return null;merged.begin=first.begin;merged.end=Math.max(first.end,second.end);return merged;}};},{}],78:[function(require,module,exports){WebInspector.TextRange=function(startLine,startColumn,endLine,endColumn)
{this.startLine=startLine;this.startColumn=startColumn;this.endLine=endLine;this.endColumn=endColumn;};WebInspector.TextRange.createFromLocation=function(line,column)
{return new WebInspector.TextRange(line,column,line,column);};WebInspector.TextRange.fromObject=function(serializedTextRange)
{return new WebInspector.TextRange(serializedTextRange.startLine,serializedTextRange.startColumn,serializedTextRange.endLine,serializedTextRange.endColumn);};WebInspector.TextRange.comparator=function(range1,range2)
{return range1.compareTo(range2);};WebInspector.TextRange.prototype={isEmpty:function()
{return this.startLine===this.endLine&&this.startColumn===this.endColumn;},immediatelyPrecedes:function(range)
{if(!range)
return false;return this.endLine===range.startLine&&this.endColumn===range.startColumn;},immediatelyFollows:function(range)
{if(!range)
return false;return range.immediatelyPrecedes(this);},follows:function(range)
{return range.endLine===this.startLine&&range.endColumn<=this.startColumn||range.endLine<this.startLine;},get linesCount()
{return this.endLine-this.startLine;},collapseToEnd:function()
{return new WebInspector.TextRange(this.endLine,this.endColumn,this.endLine,this.endColumn);},collapseToStart:function()
{return new WebInspector.TextRange(this.startLine,this.startColumn,this.startLine,this.startColumn);},normalize:function()
{if(this.startLine>this.endLine||this.startLine===this.endLine&&this.startColumn>this.endColumn)
return new WebInspector.TextRange(this.endLine,this.endColumn,this.startLine,this.startColumn);else
return this.clone();},clone:function()
{return new WebInspector.TextRange(this.startLine,this.startColumn,this.endLine,this.endColumn);},serializeToObject:function()
{var serializedTextRange={};serializedTextRange.startLine=this.startLine;serializedTextRange.startColumn=this.startColumn;serializedTextRange.endLine=this.endLine;serializedTextRange.endColumn=this.endColumn;return serializedTextRange;},compareTo:function(other)
{if(this.startLine>other.startLine)
return 1;if(this.startLine<other.startLine)
return-1;if(this.startColumn>other.startColumn)
return 1;if(this.startColumn<other.startColumn)
return-1;return 0;},compareToPosition:function(lineNumber,columnNumber)
{if(lineNumber<this.startLine||lineNumber===this.startLine&&columnNumber<this.startColumn)
return-1;if(lineNumber>this.endLine||lineNumber===this.endLine&&columnNumber>this.endColumn)
return 1;return 0;},equal:function(other)
{return this.startLine===other.startLine&&this.endLine===other.endLine&&this.startColumn===other.startColumn&&this.endColumn===other.endColumn;},relativeTo:function(line,column)
{var relative=this.clone();if(this.startLine===line)
relative.startColumn-=column;if(this.endLine===line)
relative.endColumn-=column;relative.startLine-=line;relative.endLine-=line;return relative;},rebaseAfterTextEdit:function(originalRange,editedRange)
{console.assert(originalRange.startLine===editedRange.startLine);console.assert(originalRange.startColumn===editedRange.startColumn);var rebase=this.clone();if(!this.follows(originalRange))
return rebase;var lineDelta=editedRange.endLine-originalRange.endLine;var columnDelta=editedRange.endColumn-originalRange.endColumn;rebase.startLine+=lineDelta;rebase.endLine+=lineDelta;if(rebase.startLine===editedRange.endLine)
rebase.startColumn+=columnDelta;if(rebase.endLine===editedRange.endLine)
rebase.endColumn+=columnDelta;return rebase;},toString:function()
{return JSON.stringify(this);},containsLocation:function(lineNumber,columnNumber)
{if(this.startLine===this.endLine)
return this.startLine===lineNumber&&this.startColumn<=columnNumber&&columnNumber<=this.endColumn;if(this.startLine===lineNumber)
return this.startColumn<=columnNumber;if(this.endLine===lineNumber)
return columnNumber<=this.endColumn;return this.startLine<lineNumber&&lineNumber<this.endLine;}};WebInspector.TextRange.fromEdit=function(oldRange,newText)
{var endLine=oldRange.startLine;var endColumn=oldRange.startColumn+newText.length;var lineEndings=newText.computeLineEndings();if(lineEndings.length>1){endLine=oldRange.startLine+lineEndings.length-1;var len=lineEndings.length;endColumn=lineEndings[len-1]-lineEndings[len-2]-1;}
return new WebInspector.TextRange(oldRange.startLine,oldRange.startColumn,endLine,endColumn);};WebInspector.SourceRange=function(offset,length)
{this.offset=offset;this.length=length;};WebInspector.SourceEdit=function(sourceURL,oldRange,newText)
{this.sourceURL=sourceURL;this.oldRange=oldRange;this.newText=newText;};WebInspector.SourceEdit.prototype={newRange:function()
{return WebInspector.TextRange.fromEdit(this.oldRange,this.newText);}};WebInspector.SourceEdit.comparator=function(edit1,edit2)
{return WebInspector.TextRange.comparator(edit1.oldRange,edit2.oldRange);};},{}],79:[function(require,module,exports){WebInspector.TextUtils={isStopChar:function(char)
{return char>" "&&char<"0"||char>"9"&&char<"A"||char>"Z"&&char<"_"||char>"_"&&char<"a"||char>"z"&&char<="~";},isWordChar:function(char)
{return!WebInspector.TextUtils.isStopChar(char)&&!WebInspector.TextUtils.isSpaceChar(char);},isSpaceChar:function(char)
{return WebInspector.TextUtils._SpaceCharRegex.test(char);},isWord:function(word)
{for(var i=0;i<word.length;++i){if(!WebInspector.TextUtils.isWordChar(word.charAt(i)))
return false;}
return true;},isOpeningBraceChar:function(char)
{return char==="("||char==="{";},isClosingBraceChar:function(char)
{return char===")"||char==="}";},isBraceChar:function(char)
{return WebInspector.TextUtils.isOpeningBraceChar(char)||WebInspector.TextUtils.isClosingBraceChar(char);},textToWords:function(text,isWordChar,wordCallback)
{var startWord=-1;for(var i=0;i<text.length;++i){if(!isWordChar(text.charAt(i))){if(startWord!==-1)
wordCallback(text.substring(startWord,i));startWord=-1;}else if(startWord===-1)
startWord=i;}
if(startWord!==-1)
wordCallback(text.substring(startWord));},lineIndent:function(line)
{var indentation=0;while(indentation<line.length&&WebInspector.TextUtils.isSpaceChar(line.charAt(indentation)))
++indentation;return line.substr(0,indentation);},isUpperCase:function(text)
{return text===text.toUpperCase();},isLowerCase:function(text)
{return text===text.toLowerCase();},splitStringByRegexes(text,regexes)
{var matches=[];var globalRegexes=[];for(var i=0;i<regexes.length;i++){var regex=regexes[i];if(!regex.global)
globalRegexes.push(new RegExp(regex.source,regex.flags?regex.flags+"g":"g"));else
globalRegexes.push(regex);}
doSplit(text,0,0);return matches;function doSplit(text,regexIndex,startIndex)
{if(regexIndex>=globalRegexes.length){matches.push({value:text,position:startIndex,regexIndex:-1});return;}
var regex=globalRegexes[regexIndex];var currentIndex=0;var result;regex.lastIndex=0;while((result=regex.exec(text))!==null){var stringBeforeMatch=text.substring(currentIndex,result.index);if(stringBeforeMatch)
doSplit(stringBeforeMatch,regexIndex+1,startIndex+currentIndex);var match=result[0];matches.push({value:match,position:startIndex+result.index,regexIndex:regexIndex});currentIndex=result.index+match.length;}
var stringAfterMatches=text.substring(currentIndex);if(stringAfterMatches)
doSplit(stringAfterMatches,regexIndex+1,startIndex+currentIndex);}}};WebInspector.TextUtils._SpaceCharRegex=/\s/;WebInspector.TextUtils.Indent={TwoSpaces:"  ",FourSpaces:"    ",EightSpaces:"        ",TabCharacter:"\t"};WebInspector.TextUtils.BalancedJSONTokenizer=function(callback,findMultiple)
{this._callback=callback;this._index=0;this._balance=0;this._buffer="";this._findMultiple=findMultiple||false;this._closingDoubleQuoteRegex=/[^\\](?:\\\\)*"/g;};WebInspector.TextUtils.BalancedJSONTokenizer.prototype={write:function(chunk)
{this._buffer+=chunk;var lastIndex=this._buffer.length;var buffer=this._buffer;for(var index=this._index;index<lastIndex;++index){var character=buffer[index];if(character==="\""){this._closingDoubleQuoteRegex.lastIndex=index;if(!this._closingDoubleQuoteRegex.test(buffer))
break;index=this._closingDoubleQuoteRegex.lastIndex-1;}else if(character==="{"){++this._balance;}else if(character==="}"){--this._balance;if(this._balance<0){this._reportBalanced();return false;}
if(!this._balance){this._lastBalancedIndex=index+1;if(!this._findMultiple)
break;}}else if(character==="]"&&!this._balance){this._reportBalanced();return false;}}
this._index=index;this._reportBalanced();return true;},_reportBalanced:function()
{if(!this._lastBalancedIndex)
return;this._callback(this._buffer.slice(0,this._lastBalancedIndex));this._buffer=this._buffer.slice(this._lastBalancedIndex);this._index-=this._lastBalancedIndex;this._lastBalancedIndex=0;},remainder:function()
{return this._buffer;}};WebInspector.TokenizerFactory=function(){};WebInspector.TokenizerFactory.prototype={createTokenizer:function(mimeType){}};},{}],80:[function(require,module,exports){WebInspector.UIString=function(string,vararg)
{return String.vsprintf(WebInspector.localize(string),Array.prototype.slice.call(arguments,1));};WebInspector.UIString.capitalize=function(string,vararg)
{if(WebInspector._useLowerCaseMenuTitles===undefined)
throw"WebInspector.setLocalizationPlatform() has not been called";var localized=WebInspector.localize(string);var capitalized;if(WebInspector._useLowerCaseMenuTitles)
capitalized=localized.replace(/\^(.)/g,"$1");else
capitalized=localized.replace(/\^(.)/g,function(str,char){return char.toUpperCase();});return String.vsprintf(capitalized,Array.prototype.slice.call(arguments,1));};WebInspector.setLocalizationPlatform=function(platform)
{WebInspector._useLowerCaseMenuTitles=platform==="windows";};WebInspector.localize=function(string)
{return string;};WebInspector.UIStringFormat=function(format)
{this._localizedFormat=WebInspector.localize(format);this._tokenizedFormat=String.tokenizeFormatString(this._localizedFormat,String.standardFormatters);};WebInspector.UIStringFormat._append=function(a,b)
{return a+b;};WebInspector.UIStringFormat.prototype={format:function(vararg)
{return String.format(this._localizedFormat,arguments,String.standardFormatters,"",WebInspector.UIStringFormat._append,this._tokenizedFormat).formattedResult;}};},{}],81:[function(require,module,exports){WebInspector.FilmStripModel=function(tracingModel,zeroTime)
{this.reset(tracingModel,zeroTime);};WebInspector.FilmStripModel._category="disabled-by-default-devtools.screenshot";WebInspector.FilmStripModel.TraceEvents={CaptureFrame:"CaptureFrame",Screenshot:"Screenshot"};WebInspector.FilmStripModel.prototype={reset:function(tracingModel,zeroTime)
{this._zeroTime=zeroTime||tracingModel.minimumRecordTime();this._spanTime=tracingModel.maximumRecordTime()-this._zeroTime;this._frames=[];var browserMain=WebInspector.TracingModel.browserMainThread(tracingModel);if(!browserMain)
return;var events=browserMain.events();for(var i=0;i<events.length;++i){var event=events[i];if(event.startTime<this._zeroTime)
continue;if(!event.hasCategory(WebInspector.FilmStripModel._category))
continue;if(event.name===WebInspector.FilmStripModel.TraceEvents.CaptureFrame){var data=event.args["data"];if(data)
this._frames.push(WebInspector.FilmStripModel.Frame._fromEvent(this,event,this._frames.length));}else if(event.name===WebInspector.FilmStripModel.TraceEvents.Screenshot){this._frames.push(WebInspector.FilmStripModel.Frame._fromSnapshot(this,event,this._frames.length));}}},frames:function()
{return this._frames;},zeroTime:function()
{return this._zeroTime;},spanTime:function()
{return this._spanTime;},frameByTimestamp:function(timestamp)
{var index=this._frames.upperBound(timestamp,(timestamp,frame)=>timestamp-frame.timestamp)-1;return index>=0?this._frames[index]:null;}};WebInspector.FilmStripModel.Frame=function(model,timestamp,index)
{this._model=model;this.timestamp=timestamp;this.index=index;this._imageData=null;this._snapshot=null;};WebInspector.FilmStripModel.Frame._fromEvent=function(model,event,index)
{var frame=new WebInspector.FilmStripModel.Frame(model,event.startTime,index);frame._imageData=event.args["data"];return frame;};WebInspector.FilmStripModel.Frame._fromSnapshot=function(model,snapshot,index)
{var frame=new WebInspector.FilmStripModel.Frame(model,snapshot.startTime,index);frame._snapshot=snapshot;return frame;};WebInspector.FilmStripModel.Frame.prototype={model:function()
{return this._model;},imageDataPromise:function()
{if(this._imageData||!this._snapshot)
return Promise.resolve(this._imageData);return this._snapshot.objectPromise();}};},{}],82:[function(require,module,exports){WebInspector.SCSSParser=function()
{};WebInspector.SCSSParser.prototype={parse:function(content)
{var ast=null;try{ast=gonzales.parse(content,{syntax:"scss"});}catch(e){return[];}
var rootBlock={properties:[],node:ast};var blocks=[rootBlock];ast.selectors=[];WebInspector.SCSSParser.extractNodes(ast,blocks,rootBlock);var rules=[];for(var block of blocks)
this._handleBlock(block,rules);return rules;},_handleBlock:function(block,output)
{var selectors=block.node.selectors.map(WebInspector.SCSSParser.rangeFromNode);var properties=[];var styleRange=WebInspector.SCSSParser.rangeFromNode(block.node);styleRange.startColumn+=1;styleRange.endColumn-=1;for(var node of block.properties){if(node.type==="declaration")
this._handleDeclaration(node,properties);else
if(node.type==="include")
this._handleInclude(node,properties);else
if(node.type==="multilineComment"&&node.start.line===node.end.line)
this._handleComment(node,properties);}
if(!selectors.length&&!properties.length)
return;var rule=new WebInspector.SCSSParser.Rule(selectors,properties,styleRange);output.push(rule);},_handleDeclaration:function(node,output)
{var propertyNode=node.content.find(node=>node.type==="property");var valueNode=node.content.find(node=>node.type==="value");if(!propertyNode||!valueNode)
return;var nameRange=WebInspector.SCSSParser.rangeFromNode(propertyNode);var valueRange=WebInspector.SCSSParser.rangeFromNode(valueNode);var range=node.declarationRange;var property=new WebInspector.SCSSParser.Property(range,nameRange,valueRange,false);output.push(property);},_handleInclude:function(node,output)
{var mixinName=node.content.find(node=>node.type==="ident");if(!mixinName)
return;var nameRange=WebInspector.SCSSParser.rangeFromNode(mixinName);var mixinArguments=node.content.find(node=>node.type==="arguments");if(!mixinArguments)
return;var parameters=mixinArguments.content.filter(node=>node.type!=="delimiter"&&node.type!=="space");for(var parameter of parameters){var range=WebInspector.SCSSParser.rangeFromNode(node);var valueRange=WebInspector.SCSSParser.rangeFromNode(parameter);var property=new WebInspector.SCSSParser.Property(range,nameRange,valueRange,false);output.push(property);}},_handleComment:function(node,output)
{if(node.start.line!==node.end.line)
return;var innerText=node.content;var innerResult=this.parse(innerText);if(innerResult.length!==1||innerResult[0].properties.length!==1)
return;var property=innerResult[0].properties[0];var disabledProperty=property.rebaseInsideOneLineComment(node);output.push(disabledProperty);}};WebInspector.SCSSParser.rangeFromNode=function(node)
{return new WebInspector.TextRange(node.start.line-1,node.start.column-1,node.end.line-1,node.end.column);};WebInspector.SCSSParser.Property=function(range,nameRange,valueRange,disabled)
{this.range=range;this.name=nameRange;this.value=valueRange;this.disabled=disabled;};WebInspector.SCSSParser.Property.prototype={rebaseInsideOneLineComment:function(commentNode)
{var lineOffset=commentNode.start.line-1;var columnOffset=commentNode.start.column-1+2;var range=WebInspector.SCSSParser.rangeFromNode(commentNode);var name=rebaseRange(this.name,lineOffset,columnOffset);var value=rebaseRange(this.value,lineOffset,columnOffset);return new WebInspector.SCSSParser.Property(range,name,value,true);function rebaseRange(range,lineOffset,columnOffset)
{return new WebInspector.TextRange(range.startLine+lineOffset,range.startColumn+columnOffset,range.endLine+lineOffset,range.endColumn+columnOffset);}}};WebInspector.SCSSParser.Rule=function(selectors,properties,styleRange)
{this.selectors=selectors;this.properties=properties;this.styleRange=styleRange;};WebInspector.SCSSParser.extractNodes=function(node,blocks,lastBlock)
{if(!Array.isArray(node.content))
return;if(node.type==="block"){lastBlock={node:node,properties:[]};blocks.push(lastBlock);}
var lastDeclaration=null;var selectors=[];for(var i=0;i<node.content.length;++i){var child=node.content[i];if(child.type==="declarationDelimiter"&&lastDeclaration){lastDeclaration.declarationRange.endLine=child.end.line-1;lastDeclaration.declarationRange.endColumn=child.end.column;lastDeclaration=null;}else if(child.type==="selector"){selectors.push(child);}else if(child.type==="block"){child.selectors=selectors;selectors=[];}
if(child.type==="include"||child.type==="declaration"||child.type==="multilineComment")
lastBlock.properties.push(child);if(child.type==="declaration"){lastDeclaration=child;lastDeclaration.declarationRange=WebInspector.TextRange.createFromLocation(child.start.line-1,child.start.column-1);}
WebInspector.SCSSParser.extractNodes(child,blocks,lastBlock);}
if(lastDeclaration){lastDeclaration.declarationRange.endLine=node.end.line-1;lastDeclaration.declarationRange.endColumn=node.end.column-1;}};},{}],83:[function(require,module,exports){(function webpackUniversalModuleDefinition(root,factory){if(typeof exports==='object'&&typeof module==='object')
module.exports=factory();else
if(typeof define==='function'&&define.amd)
define([],factory);else
if(typeof exports==='object')
exports["gonzales"]=factory();else
root["gonzales"]=factory();})(this,function(){return function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId])
return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:false};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.loaded=true;return module.exports;}
__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.p="";return __webpack_require__(0);}([function(module,exports,__webpack_require__){'use strict';var Node=__webpack_require__(1);var parse=__webpack_require__(7);module.exports={createNode:function(options){return new Node(options);},parse:parse};},function(module,exports,__webpack_require__){'use strict';var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if('value'in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor);}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor;};}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError('Cannot call a class as a function');}}
var Node=function(){function Node(options){_classCallCheck(this,Node);this.type=options.type;this.content=options.content;this.syntax=options.syntax;if(options.start)this.start=options.start;if(options.end)this.end=options.end;}
Node.prototype.contains=function contains(type){return this.content.some(function(node){return node.type===type;});};Node.prototype.eachFor=function eachFor(type,callback){if(!Array.isArray(this.content))return;if(typeof type!=='string'){callback=type;type=null;}
var l=this.content.length;var breakLoop;for(var i=l;i--;){if(breakLoop===null)break;if(!type||this.content[i]&&this.content[i].type===type)breakLoop=callback(this.content[i],i,this);}
if(breakLoop===null)return null;};Node.prototype.first=function first(type){if(!Array.isArray(this.content))return null;if(!type)return this.content[0];var i=0;var l=this.content.length;for(;i<l;i++){if(this.content[i].type===type)return this.content[i];}
return null;};Node.prototype.forEach=function forEach(type,callback){if(!Array.isArray(this.content))return;if(typeof type!=='string'){callback=type;type=null;}
var i=0;var l=this.content.length;var breakLoop;for(;i<l;i++){if(breakLoop===null)break;if(!type||this.content[i]&&this.content[i].type===type)breakLoop=callback(this.content[i],i,this);}
if(breakLoop===null)return null;};Node.prototype.get=function get(index){if(!Array.isArray(this.content))return null;var node=this.content[index];return node?node:null;};Node.prototype.insert=function insert(index,node){if(!Array.isArray(this.content))return;this.content.splice(index,0,node);};Node.prototype.is=function is(type){return this.type===type;};Node.prototype.last=function last(type){if(!Array.isArray(this.content))return null;var i=this.content.length-1;if(!type)return this.content[i];for(;;i--){if(this.content[i].type===type)return this.content[i];}
return null;};Node.prototype.removeChild=function removeChild(index){if(!Array.isArray(this.content))return;var removedChild=this.content.splice(index,1);return removedChild;};Node.prototype.toJson=function toJson(){return JSON.stringify(this,false,2);};Node.prototype.toString=function toString(){var stringify=undefined;try{stringify=__webpack_require__(2)("./"+this.syntax+'/stringify');}catch(e){var message='Syntax "'+this.syntax+'" is not supported yet, sorry';return console.error(message);}
return stringify(this);};Node.prototype.traverse=function traverse(callback,index){var level=arguments.length<=2||arguments[2]===undefined?0:arguments[2];var parent=arguments.length<=3||arguments[3]===undefined?null:arguments[3];var breakLoop;var x;level++;callback(this,index,parent,level);if(!Array.isArray(this.content))return;for(var i=0,l=this.content.length;i<l;i++){breakLoop=this.content[i].traverse(callback,i,level,this);if(breakLoop===null)break;if(x=this.content.length-l){l+=x;i+=x;}}
if(breakLoop===null)return null;};Node.prototype.traverseByType=function traverseByType(type,callback){this.traverse(function(node){if(node.type===type)callback.apply(node,arguments);});};Node.prototype.traverseByTypes=function traverseByTypes(types,callback){this.traverse(function(node){if(types.indexOf(node.type)!==-1)callback.apply(node,arguments);});};_createClass(Node,[{key:'length',get:function(){if(!Array.isArray(this.content))return 0;return this.content.length;}}]);return Node;}();module.exports=Node;},function(module,exports,__webpack_require__){var map={"./css/stringify":3,"./less/stringify":4,"./sass/stringify":5,"./scss/stringify":6};function webpackContext(req){return __webpack_require__(webpackContextResolve(req));};function webpackContextResolve(req){return map[req]||function(){throw new Error("Cannot find module '"+req+"'.");}();};webpackContext.keys=function webpackContextKeys(){return Object.keys(map);};webpackContext.resolve=webpackContextResolve;module.exports=webpackContext;webpackContext.id=2;},function(module,exports){'use strict';module.exports=function stringify(tree){if(!tree)throw new Error('We need tree to translate');function _t(tree){var type=tree.type;if(_unique[type])return _unique[type](tree);if(typeof tree.content==='string')return tree.content;if(Array.isArray(tree.content))return _composite(tree.content);return'';}
function _composite(t,i){if(!t)return'';var s='';i=i||0;for(;i<t.length;i++)s+=_t(t[i]);return s;}
var _unique={'arguments':function(t){return'('+_composite(t.content)+')';},'atkeyword':function(t){return'@'+_composite(t.content);},'attributeSelector':function(t){return'['+_composite(t.content)+']';},'block':function(t){return'{'+_composite(t.content)+'}';},'brackets':function(t){return'['+_composite(t.content)+']';},'class':function(t){return'.'+_composite(t.content);},'color':function(t){return'#'+t.content;},'expression':function(t){return'expression('+t.content+')';},'id':function(t){return'#'+_composite(t.content);},'multilineComment':function(t){return'/*'+t.content+'*/';},'nthSelector':function(t){return':'+_t(t.content[0])+'('+_composite(t.content.slice(1))+')';},'parentheses':function(t){return'('+_composite(t.content)+')';},'percentage':function(t){return _composite(t.content)+'%';},'pseudoClass':function(t){return':'+_composite(t.content);},'pseudoElement':function(t){return'::'+_composite(t.content);},'uri':function(t){return'url('+_composite(t.content)+')';}};return _t(tree);};},function(module,exports){'use strict';module.exports=function stringify(tree){if(!tree)throw new Error('We need tree to translate');function _t(tree){var type=tree.type;if(_unique[type])return _unique[type](tree);if(typeof tree.content==='string')return tree.content;if(Array.isArray(tree.content))return _composite(tree.content);return'';}
function _composite(t,i){if(!t)return'';var s='';i=i||0;for(;i<t.length;i++)s+=_t(t[i]);return s;}
var _unique={'arguments':function(t){return'('+_composite(t.content)+')';},'atkeyword':function(t){return'@'+_composite(t.content);},'attributeSelector':function(t){return'['+_composite(t.content)+']';},'block':function(t){return'{'+_composite(t.content)+'}';},'brackets':function(t){return'['+_composite(t.content)+']';},'class':function(t){return'.'+_composite(t.content);},'color':function(t){return'#'+t.content;},'escapedString':function(t){return'~'+t.content;},'expression':function(t){return'expression('+t.content+')';},'id':function(t){return'#'+_composite(t.content);},'interpolatedVariable':function(t){return'@{'+_composite(t.content)+'}';},'multilineComment':function(t){return'/*'+t.content+'*/';},'nthSelector':function(t){return':'+_t(t.content[0])+'('+_composite(t.content.slice(1))+')';},'parentheses':function(t){return'('+_composite(t.content)+')';},'percentage':function(t){return _composite(t.content)+'%';},'pseudoClass':function(t){return':'+_composite(t.content);},'pseudoElement':function(t){return'::'+_composite(t.content);},'singlelineComment':function(t){return'/'+'/'+t.content;},'uri':function(t){return'url('+_composite(t.content)+')';},'variable':function(t){return'@'+_composite(t.content);},'variablesList':function(t){return _composite(t.content)+'...';}};return _t(tree);};},function(module,exports){'use strict';module.exports=function stringify(tree){if(!tree)throw new Error('We need tree to translate');function _t(tree){var type=tree.type;if(_unique[type])return _unique[type](tree);if(typeof tree.content==='string')return tree.content;if(Array.isArray(tree.content))return _composite(tree.content);return'';}
function _composite(t,i){if(!t)return'';var s='';i=i||0;for(;i<t.length;i++)s+=_t(t[i]);return s;}
var _unique={'arguments':function(t){return'('+_composite(t.content)+')';},'atkeyword':function(t){return'@'+_composite(t.content);},'attributeSelector':function(t){return'['+_composite(t.content)+']';},'block':function(t){return _composite(t.content);},'brackets':function(t){return'['+_composite(t.content)+']';},'class':function(t){return'.'+_composite(t.content);},'color':function(t){return'#'+t.content;},'expression':function(t){return'expression('+t.content+')';},'id':function(t){return'#'+_composite(t.content);},'interpolation':function(t){return'#{'+_composite(t.content)+'}';},'multilineComment':function(t){return'/*'+t.content;},'nthSelector':function(t){return':'+_t(t.content[0])+'('+_composite(t.content.slice(1))+')';},'parentheses':function(t){return'('+_composite(t.content)+')';},'percentage':function(t){return _composite(t.content)+'%';},'placeholder':function(t){return'%'+_composite(t.content);},'pseudoClass':function(t){return':'+_composite(t.content);},'pseudoElement':function(t){return'::'+_composite(t.content);},'singlelineComment':function(t){return'/'+'/'+t.content;},'uri':function(t){return'url('+_composite(t.content)+')';},'variable':function(t){return'$'+_composite(t.content);},'variablesList':function(t){return _composite(t.content)+'...';}};return _t(tree);};},function(module,exports){'use strict';module.exports=function stringify(tree){if(!tree)throw new Error('We need tree to translate');function _t(tree){var type=tree.type;if(_unique[type])return _unique[type](tree);if(typeof tree.content==='string')return tree.content;if(Array.isArray(tree.content))return _composite(tree.content);return'';}
function _composite(t,i){if(!t)return'';var s='';i=i||0;for(;i<t.length;i++)s+=_t(t[i]);return s;}
var _unique={'arguments':function(t){return'('+_composite(t.content)+')';},'atkeyword':function(t){return'@'+_composite(t.content);},'attributeSelector':function(t){return'['+_composite(t.content)+']';},'block':function(t){return'{'+_composite(t.content)+'}';},'brackets':function(t){return'['+_composite(t.content)+']';},'class':function(t){return'.'+_composite(t.content);},'color':function(t){return'#'+t.content;},'expression':function(t){return'expression('+t.content+')';},'id':function(t){return'#'+_composite(t.content);},'interpolation':function(t){return'#{'+_composite(t.content)+'}';},'multilineComment':function(t){return'/*'+t.content+'*/';},'nthSelector':function(t){return':'+_t(t.content[0])+'('+_composite(t.content.slice(1))+')';},'parentheses':function(t){return'('+_composite(t.content)+')';},'percentage':function(t){return _composite(t.content)+'%';},'placeholder':function(t){return'%'+_composite(t.content);},'pseudoClass':function(t){return':'+_composite(t.content);},'pseudoElement':function(t){return'::'+_composite(t.content);},'singlelineComment':function(t){return'/'+'/'+t.content;},'uri':function(t){return'url('+_composite(t.content)+')';},'variable':function(t){return'$'+_composite(t.content);},'variablesList':function(t){return _composite(t.content)+'...';}};return _t(tree);};},function(module,exports,__webpack_require__){'use strict';var ParsingError=__webpack_require__(8);var syntaxes=__webpack_require__(10);var isInteger=Number.isInteger||function(value){return typeof value==='number'&&Math.floor(value)===value;};function parser(css,options){if(typeof css!=='string')throw new Error('Please, pass a string to parse');else if(!css)return __webpack_require__(16)();var syntax=options&&options.syntax||'css';var context=options&&options.context||'stylesheet';var tabSize=options&&options.tabSize;if(!isInteger(tabSize)||tabSize<1)tabSize=1;var syntaxParser=undefined;if(syntaxes[syntax]){syntaxParser=syntaxes[syntax];}else{syntaxParser=syntaxes;}
if(!syntaxParser){var message='Syntax "'+syntax+'" is not supported yet, sorry';return console.error(message);}
var getTokens=syntaxParser.tokenizer;var mark=syntaxParser.mark;var parse=syntaxParser.parse;var tokens=getTokens(css,tabSize);mark(tokens);var ast;try{ast=parse(tokens,context);}catch(e){if(!e.syntax)throw e;throw new ParsingError(e,css);}
return ast;}
module.exports=parser;},function(module,exports,__webpack_require__){'use strict';var parserPackage=__webpack_require__(9);function ParsingError(e,css){this.line=e.line;this.syntax=e.syntax;this.css_=css;}
ParsingError.prototype=Object.defineProperties({customMessage_:'',line:null,name:'Parsing error',syntax:null,version:parserPackage.version,toString:function(){return[this.name+': '+this.message,'',this.context,'','Syntax: '+this.syntax,'Gonzales PE version: '+this.version].join('\n');}},{context:{get:function(){var LINES_AROUND=2;var result=[];var currentLineNumber=this.line;var start=currentLineNumber-1-LINES_AROUND;var end=currentLineNumber+LINES_AROUND;var lines=this.css_.split(/\r\n|\r|\n/);for(var i=start;i<end;i++){var line=lines[i];if(!line)continue;var ln=i+1;var mark=ln===currentLineNumber?'*':' ';result.push(ln+mark+'| '+line);}
return result.join('\n');},configurable:true,enumerable:true},message:{get:function(){if(this.customMessage_){return this.customMessage_;}else{var message='Please check validity of the block';if(typeof this.line==='number')message+=' starting from line #'+this.line;return message;}},set:function(message){this.customMessage_=message;},configurable:true,enumerable:true}});module.exports=ParsingError;},function(module,exports){module.exports={"name":"gonzales-pe","description":"Gonzales Preprocessor Edition (fast CSS parser)","version":"3.3.1","homepage":"http://github.com/tonyganch/gonzales-pe","bugs":"http://github.com/tonyganch/gonzales-pe/issues","license":"MIT","author":{"name":"Tony Ganch","email":"tonyganch+github@gmail.com","url":"http://tonyganch.com"},"main":"./lib/gonzales","repository":{"type":"git","url":"http://github.com/tonyganch/gonzales-pe.git"},"scripts":{"autofix-tests":"bash ./scripts/build.sh && bash ./scripts/autofix-tests.sh","build":"bash ./scripts/build.sh","init":"bash ./scripts/init.sh","log":"bash ./scripts/log.sh","prepublish":"bash ./scripts/prepublish.sh","postpublish":"bash ./scripts/postpublish.sh","test":"bash ./scripts/build.sh && bash ./scripts/test.sh","watch":"bash ./scripts/watch.sh"},"bin":{"gonzales":"./bin/gonzales.js"},"dependencies":{"minimist":"1.1.x"},"devDependencies":{"babel-loader":"^5.3.2","coffee-script":"~1.7.1","jscs":"2.1.0","jshint":"2.8.0","json-loader":"^0.5.3","mocha":"2.2.x","webpack":"^1.12.2"},"engines":{"node":">=0.6.0"}};},function(module,exports,__webpack_require__){'use strict';exports.__esModule=true;exports['default']={mark:__webpack_require__(11),parse:__webpack_require__(13),stringify:__webpack_require__(6),tokenizer:__webpack_require__(15)};module.exports=exports['default'];},function(module,exports,__webpack_require__){'use strict';var TokenType=__webpack_require__(12);module.exports=function(){function markSC(tokens){var tokensLength=tokens.length;var ws=-1;var sc=-1;var t=undefined;for(var i=0;i<tokensLength;i++){t=tokens[i];switch(t.type){case TokenType.Space:case TokenType.Tab:case TokenType.Newline:t.ws=true;t.sc=true;if(ws===-1)ws=i;if(sc===-1)sc=i;break;case TokenType.CommentML:case TokenType.CommentSL:if(ws!==-1){tokens[ws].ws_last=i-1;ws=-1;}
t.sc=true;break;default:if(ws!==-1){tokens[ws].ws_last=i-1;ws=-1;}
if(sc!==-1){tokens[sc].sc_last=i-1;sc=-1;}}}
if(ws!==-1)tokens[ws].ws_last=i-1;if(sc!==-1)tokens[sc].sc_last=i-1;}
function markBrackets(tokens){var tokensLength=tokens.length;var ps=[];var sbs=[];var cbs=[];var t=undefined;for(var i=0;i<tokensLength;i++){t=tokens[i];switch(t.type){case TokenType.LeftParenthesis:ps.push(i);break;case TokenType.RightParenthesis:if(ps.length){t.left=ps.pop();tokens[t.left].right=i;}
break;case TokenType.LeftSquareBracket:sbs.push(i);break;case TokenType.RightSquareBracket:if(sbs.length){t.left=sbs.pop();tokens[t.left].right=i;}
break;case TokenType.LeftCurlyBracket:cbs.push(i);break;case TokenType.RightCurlyBracket:if(cbs.length){t.left=cbs.pop();tokens[t.left].right=i;}
break;}}}
return function(tokens){markBrackets(tokens);markSC(tokens);};}();},function(module,exports){'use strict';module.exports={StringSQ:'StringSQ',StringDQ:'StringDQ',CommentML:'CommentML',CommentSL:'CommentSL',Newline:'Newline',Space:'Space',Tab:'Tab',ExclamationMark:'ExclamationMark',QuotationMark:'QuotationMark',NumberSign:'NumberSign',DollarSign:'DollarSign',PercentSign:'PercentSign',Ampersand:'Ampersand',Apostrophe:'Apostrophe',LeftParenthesis:'LeftParenthesis',RightParenthesis:'RightParenthesis',Asterisk:'Asterisk',PlusSign:'PlusSign',Comma:'Comma',HyphenMinus:'HyphenMinus',FullStop:'FullStop',Solidus:'Solidus',Colon:'Colon',Semicolon:'Semicolon',LessThanSign:'LessThanSign',EqualsSign:'EqualsSign',EqualitySign:'EqualitySign',InequalitySign:'InequalitySign',GreaterThanSign:'GreaterThanSign',QuestionMark:'QuestionMark',CommercialAt:'CommercialAt',LeftSquareBracket:'LeftSquareBracket',ReverseSolidus:'ReverseSolidus',RightSquareBracket:'RightSquareBracket',CircumflexAccent:'CircumflexAccent',LowLine:'LowLine',LeftCurlyBracket:'LeftCurlyBracket',VerticalLine:'VerticalLine',RightCurlyBracket:'RightCurlyBracket',Tilde:'Tilde',Identifier:'Identifier',DecimalNumber:'DecimalNumber'};},function(module,exports,__webpack_require__){'use strict';var Node=__webpack_require__(1);var NodeType=__webpack_require__(14);var TokenType=__webpack_require__(12);var tokens=undefined;var tokensLength=undefined;var pos=undefined;var contexts={'arguments':function(){return checkArguments(pos)&&getArguments();},'atkeyword':function(){return checkAtkeyword(pos)&&getAtkeyword();},'atrule':function(){return checkAtrule(pos)&&getAtrule();},'block':function(){return checkBlock(pos)&&getBlock();},'brackets':function(){return checkBrackets(pos)&&getBrackets();},'class':function(){return checkClass(pos)&&getClass();},'combinator':function(){return checkCombinator(pos)&&getCombinator();},'commentML':function(){return checkCommentML(pos)&&getCommentML();},'commentSL':function(){return checkCommentSL(pos)&&getCommentSL();},'condition':function(){return checkCondition(pos)&&getCondition();},'conditionalStatement':function(){return checkConditionalStatement(pos)&&getConditionalStatement();},'declaration':function(){return checkDeclaration(pos)&&getDeclaration();},'declDelim':function(){return checkDeclDelim(pos)&&getDeclDelim();},'default':function(){return checkDefault(pos)&&getDefault();},'delim':function(){return checkDelim(pos)&&getDelim();},'dimension':function(){return checkDimension(pos)&&getDimension();},'expression':function(){return checkExpression(pos)&&getExpression();},'extend':function(){return checkExtend(pos)&&getExtend();},'function':function(){return checkFunction(pos)&&getFunction();},'global':function(){return checkGlobal(pos)&&getGlobal();},'ident':function(){return checkIdent(pos)&&getIdent();},'important':function(){return checkImportant(pos)&&getImportant();},'include':function(){return checkInclude(pos)&&getInclude();},'interpolation':function(){return checkInterpolation(pos)&&getInterpolation();},'loop':function(){return checkLoop(pos)&&getLoop();},'mixin':function(){return checkMixin(pos)&&getMixin();},'namespace':function(){return checkNamespace(pos)&&getNamespace();},'number':function(){return checkNumber(pos)&&getNumber();},'operator':function(){return checkOperator(pos)&&getOperator();},'optional':function(){return checkOptional(pos)&&getOptional();},'parentheses':function(){return checkParentheses(pos)&&getParentheses();},'parentselector':function(){return checkParentSelector(pos)&&getParentSelector();},'percentage':function(){return checkPercentage(pos)&&getPercentage();},'placeholder':function(){return checkPlaceholder(pos)&&getPlaceholder();},'progid':function(){return checkProgid(pos)&&getProgid();},'property':function(){return checkProperty(pos)&&getProperty();},'propertyDelim':function(){return checkPropertyDelim(pos)&&getPropertyDelim();},'pseudoc':function(){return checkPseudoc(pos)&&getPseudoc();},'pseudoe':function(){return checkPseudoe(pos)&&getPseudoe();},'ruleset':function(){return checkRuleset(pos)&&getRuleset();},'s':function(){return checkS(pos)&&getS();},'selector':function(){return checkSelector(pos)&&getSelector();},'shash':function(){return checkShash(pos)&&getShash();},'string':function(){return checkString(pos)&&getString();},'stylesheet':function(){return checkStylesheet(pos)&&getStylesheet();},'unary':function(){return checkUnary(pos)&&getUnary();},'uri':function(){return checkUri(pos)&&getUri();},'value':function(){return checkValue(pos)&&getValue();},'variable':function(){return checkVariable(pos)&&getVariable();},'variableslist':function(){return checkVariablesList(pos)&&getVariablesList();},'vhash':function(){return checkVhash(pos)&&getVhash();}};function throwError(i){var ln=i?tokens[i].ln:tokens[pos].ln;throw{line:ln,syntax:'scss'};}
function checkExcluding(exclude,i){var start=i;while(i<tokensLength){if(exclude[tokens[i++].type])break;}return i-start-2;}
function joinValues(start,finish){var s='';for(var i=start;i<finish+1;i++){s+=tokens[i].value;}return s;}
function joinValues2(start,num){if(start+num-1>=tokensLength)return;var s='';for(var i=0;i<num;i++){s+=tokens[start+i].value;}return s;}function getLastPosition(content,line,column,colOffset){return typeof content==='string'?getLastPositionForString(content,line,column,colOffset):getLastPositionForArray(content,line,column,colOffset);}function getLastPositionForString(content,line,column,colOffset){var position=[];if(!content){position=[line,column];if(colOffset)position[1]+=colOffset-1;return position;}var lastLinebreak=content.lastIndexOf('\n');var endsWithLinebreak=lastLinebreak===content.length-1;var splitContent=content.split('\n');var linebreaksCount=splitContent.length-1;var prevLinebreak=linebreaksCount===0||linebreaksCount===1?-1:content.length-splitContent[linebreaksCount-1].length-2;var offset=endsWithLinebreak?linebreaksCount-1:linebreaksCount;position[0]=line+offset;if(endsWithLinebreak){offset=prevLinebreak!==-1?content.length-prevLinebreak:content.length-1;}else{offset=linebreaksCount!==0?content.length-lastLinebreak-column-1:content.length-1;}position[1]=column+offset;if(!colOffset)return position;if(endsWithLinebreak){position[0]++;position[1]=colOffset;}else{position[1]+=colOffset;}return position;}function getLastPositionForArray(content,line,column,colOffset){var position;if(content.length===0){position=[line,column];}else{var c=content[content.length-1];if(c.hasOwnProperty('end')){position=[c.end.line,c.end.column];}else{position=getLastPosition(c.content,line,column);}}if(!colOffset)return position;if(tokens[pos-1].type!=='Newline'){position[1]+=colOffset;}else{position[0]++;position[1]=1;}return position;}function newNode(type,content,line,column,end){if(!end)end=getLastPosition(content,line,column);return new Node({type:type,content:content,start:{line:line,column:column},end:{line:end[0],column:end[1]},syntax:'scss'});}
function checkAny(i){return checkBrackets(i)||checkParentheses(i)||checkString(i)||checkVariablesList(i)||checkVariable(i)||checkPlaceholder(i)||checkPercentage(i)||checkDimension(i)||checkNumber(i)||checkUri(i)||checkExpression(i)||checkFunction(i)||checkInterpolation(i)||checkIdent(i)||checkClass(i)||checkUnary(i);}
function getAny(){if(checkBrackets(pos))return getBrackets();else if(checkParentheses(pos))return getParentheses();else if(checkString(pos))return getString();else if(checkVariablesList(pos))return getVariablesList();else if(checkVariable(pos))return getVariable();else if(checkPlaceholder(pos))return getPlaceholder();else if(checkPercentage(pos))return getPercentage();else if(checkDimension(pos))return getDimension();else if(checkNumber(pos))return getNumber();else if(checkUri(pos))return getUri();else if(checkExpression(pos))return getExpression();else if(checkFunction(pos))return getFunction();else if(checkInterpolation(pos))return getInterpolation();else if(checkIdent(pos))return getIdent();else if(checkClass(pos))return getClass();else if(checkUnary(pos))return getUnary();}
function checkArguments(i){var start=i;var l=undefined;if(i>=tokensLength||tokens[i].type!==TokenType.LeftParenthesis)return 0;i++;while(i<tokens[start].right){if(l=checkArgument(i))i+=l;else return 0;}return tokens[start].right-start+1;}
function checkArgument(i){return checkBrackets(i)||checkParentheses(i)||checkDeclaration(i)||checkFunction(i)||checkVariablesList(i)||checkVariable(i)||checkSC(i)||checkDelim(i)||checkDeclDelim(i)||checkString(i)||checkPercentage(i)||checkDimensio