/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class BasicInternalFrameUI
extends InternalFrameUI {
    protected MouseInputAdapter borderListener;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    protected PropertyChangeListener propertyChangeListener;
    private transient BasicInternalFrameListener internalFrameListener;
    protected JComponent eastPane;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected KeyStroke openMenuKey;
    protected BasicInternalFrameTitlePane titlePane;
    protected JInternalFrame frame;
    protected LayoutManager internalFrameLayout;
    private transient JDesktopPane desktopPane;

    public BasicInternalFrameUI(JInternalFrame b) {
    }

    public static ComponentUI createUI(JComponent b) {
        return new BasicInternalFrameUI((JInternalFrame)b);
    }

    public void installUI(JComponent c) {
        if (c instanceof JInternalFrame) {
            this.frame = (JInternalFrame)c;
            this.installDefaults();
            this.installListeners();
            this.installComponents();
            this.installKeyboardActions();
            if (!this.frame.isSelected()) {
                this.frame.getGlassPane().setVisible(true);
            }
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.frame.getRootPane().getGlassPane().setVisible(false);
        this.frame = null;
    }

    protected void installDefaults() {
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        Container contentPane = this.frame.getContentPane();
        if (contentPane != null && contentPane.getBackground() instanceof UIResource) {
            contentPane.setBackground(null);
        }
    }

    protected void installKeyboardActions() {
        ActionMapUIResource am = new ActionMapUIResource();
        am.put("showSystemMenu", new ShowSystemMenuAction());
        BasicLookAndFeel blaf = (BasicLookAndFeel)UIManager.getLookAndFeel();
        ActionMap audioActionMap = blaf.getAudioActionMap();
        am.setParent(audioActionMap);
        SwingUtilities.replaceUIActionMap(this.frame, am);
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installListeners() {
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        this.createInternalFrameListener();
        this.borderListener = this.createBorderListener(this.frame);
        this.componentListener = this.createComponentListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addMouseListener(this.borderListener);
        this.frame.addMouseMotionListener(this.borderListener);
        this.frame.addInternalFrameListener(this.internalFrameListener);
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.frame.getRootPane().getGlassPane().addMouseListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
        Container parent = this.frame.getParent();
        if (parent != null) {
            parent.addComponentListener(this.componentListener);
        }
    }

    protected void uninstallDefaults() {
        this.frame.setBorder(null);
        this.frame.setLayout(null);
        this.internalFrameLayout = null;
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
    }

    protected void uninstallListeners() {
        Container parent = this.frame.getParent();
        if (parent != null) {
            parent.removeComponentListener(this.componentListener);
        }
        this.componentListener = null;
        this.frame.getRootPane().getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().removeMouseListener(this.glassPaneDispatcher);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.frame.removeInternalFrameListener(this.internalFrameListener);
        this.frame.removeMouseMotionListener(this.borderListener);
        this.frame.removeMouseListener(this.borderListener);
        this.propertyChangeListener = null;
        this.borderListener = null;
        this.internalFrameListener = null;
        this.glassPaneDispatcher = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.frame, null);
        SwingUtilities.replaceUIInputMap(this.frame, 2, null);
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new InternalFramePropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent x) {
        Dimension pref = null;
        LayoutManager layout = this.frame.getLayout();
        pref = this.frame == x && layout != null ? layout.preferredLayoutSize(this.frame) : new Dimension(100, 100);
        return pref;
    }

    public Dimension getMinimumSize(JComponent x) {
        Dimension min = null;
        LayoutManager layout = this.frame.getLayout();
        min = this.frame == x && layout != null ? layout.minimumLayoutSize(this.frame) : new Dimension(0, 0);
        return min;
    }

    public Dimension getMaximumSize(JComponent x) {
        Dimension max = null;
        LayoutManager layout = this.frame.getLayout();
        max = this.frame == x && layout != null && layout instanceof LayoutManager2 ? ((LayoutManager2)layout).maximumLayoutSize(this.frame) : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        return max;
    }

    protected void replacePane(JComponent currentPane, JComponent newPane) {
        if (currentPane != null) {
            this.deinstallMouseHandlers(currentPane);
            this.frame.remove(currentPane);
        }
        if (newPane != null) {
            this.installMouseHandlers(newPane);
            this.frame.add(newPane);
        }
    }

    protected void deinstallMouseHandlers(JComponent c) {
        c.removeMouseListener(this.borderListener);
        c.removeMouseMotionListener(this.borderListener);
    }

    protected void installMouseHandlers(JComponent c) {
        c.addMouseListener(this.borderListener);
        c.addMouseMotionListener(this.borderListener);
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new BasicInternalFrameTitlePane(w);
        return this.titlePane;
    }

    protected JComponent createWestPane(JInternalFrame w) {
        return null;
    }

    protected JComponent createSouthPane(JInternalFrame w) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame w) {
        return null;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame w) {
        return new BorderListener();
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = new BasicInternalFrameListener();
    }

    protected final boolean isKeyBindingRegistered() {
        return false;
    }

    protected final void setKeyBindingRegistered(boolean b) {
    }

    public final boolean isKeyBindingActive() {
        return false;
    }

    protected final void setKeyBindingActive(boolean b) {
    }

    protected void setupMenuOpenKey() {
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public void setNorthPane(JComponent c) {
        this.replacePane(this.northPane, c);
        this.northPane = c;
        if (c instanceof BasicInternalFrameTitlePane) {
            this.titlePane = (BasicInternalFrameTitlePane)c;
        }
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public void setSouthPane(JComponent c) {
        this.replacePane(this.southPane, c);
        this.southPane = c;
    }

    public void setEastPane(JComponent c) {
        this.replacePane(this.eastPane, c);
        this.eastPane = c;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public void setWestPane(JComponent c) {
        this.replacePane(this.westPane, c);
        this.westPane = c;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    protected DesktopManager getDesktopManager() {
        DesktopManager value = null;
        JDesktopPane pane = this.frame.getDesktopPane();
        if (pane != null) {
            value = this.frame.getDesktopPane().getDesktopManager();
        }
        if (value == null) {
            value = this.createDesktopManager();
        }
        return value;
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected void closeFrame(JInternalFrame f) {
        this.getDesktopManager().closeFrame(f);
    }

    protected void maximizeFrame(JInternalFrame f) {
        this.getDesktopManager().maximizeFrame(f);
    }

    protected void minimizeFrame(JInternalFrame f) {
        this.getDesktopManager().minimizeFrame(f);
    }

    protected void iconifyFrame(JInternalFrame f) {
        this.getDesktopManager().iconifyFrame(f);
    }

    protected void deiconifyFrame(JInternalFrame f) {
        this.getDesktopManager().deiconifyFrame(f);
    }

    protected void activateFrame(JInternalFrame f) {
        this.getDesktopManager().activateFrame(f);
    }

    protected void deactivateFrame(JInternalFrame f) {
        this.getDesktopManager().deactivateFrame(f);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher();
    }

    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        protected BasicInternalFrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            BasicInternalFrameUI.this.frame.getGlassPane().setVisible(false);
        }

        public void internalFrameClosed(InternalFrameEvent e) {
        }

        public void internalFrameClosing(InternalFrameEvent e) {
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            BasicInternalFrameUI.this.frame.getGlassPane().setVisible(true);
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        public void internalFrameIconified(InternalFrameEvent e) {
        }

        public void internalFrameOpened(InternalFrameEvent e) {
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        transient int showingCursor;
        protected final int RESIZE_NONE = 0;
        private transient int xOffset;
        private transient int yOffset;
        private transient int direction = -1;
        private transient Rectangle cacheRect = new Rectangle();

        protected BorderListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getSource() == BasicInternalFrameUI.this.titlePane && e.getClickCount() == 2) {
                try {
                    if (BasicInternalFrameUI.this.frame.isMaximizable() && !BasicInternalFrameUI.this.frame.isMaximum()) {
                        BasicInternalFrameUI.this.frame.setMaximum(true);
                    } else if (BasicInternalFrameUI.this.frame.isMaximum()) {
                        BasicInternalFrameUI.this.frame.setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (BasicInternalFrameUI.this.frame.isMaximum()) {
                return;
            }
            DesktopManager dm = BasicInternalFrameUI.this.getDesktopManager();
            Rectangle b = BasicInternalFrameUI.this.frame.getBounds();
            Dimension min = BasicInternalFrameUI.this.frame.getMinimumSize();
            if (min == null) {
                min = new Dimension(0, 0);
            }
            BasicInternalFrameUI.this.frame.getInsets();
            int x = e.getX();
            int y = e.getY();
            if (e.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                switch (this.direction) {
                    case 8: {
                        this.cacheRect.setBounds(b.x, Math.min(b.y + y, b.y + b.height - min.height), b.width, b.height - y);
                        break;
                    }
                    case 7: {
                        this.cacheRect.setBounds(b.x, Math.min(b.y + y, b.y + b.height - min.height), x + 1, b.height - y);
                        break;
                    }
                    case 11: {
                        this.cacheRect.setBounds(b.x, b.y, x + 1, b.height);
                        break;
                    }
                    case 5: {
                        this.cacheRect.setBounds(b.x, b.y, x + 1, y + 1);
                        break;
                    }
                    case 9: {
                        this.cacheRect.setBounds(b.x, b.y, b.width, y + 1);
                        break;
                    }
                    case 4: {
                        this.cacheRect.setBounds(Math.min(b.x + x, b.x + b.width - min.width), b.y, b.width - x, y + 1);
                        break;
                    }
                    case 10: {
                        this.cacheRect.setBounds(Math.min(b.x + x, b.x + b.width - min.width), b.y, b.width - x, b.height);
                        break;
                    }
                    case 6: {
                        this.cacheRect.setBounds(Math.min(b.x + x, b.x + b.width - min.width), Math.min(b.y + y, b.y + b.height - min.height), b.width - x, b.height - y);
                    }
                }
                dm.resizeFrame(BasicInternalFrameUI.this.frame, this.cacheRect.x, this.cacheRect.y, Math.max(min.width, this.cacheRect.width), Math.max(min.height, this.cacheRect.height));
                this.setCursor(e);
            } else if (e.getSource() == BasicInternalFrameUI.this.titlePane) {
                BasicInternalFrameUI.this.frame.getBounds();
                BasicInternalFrameUI.this.frame.putClientProperty("bufferedDragging", Boolean.TRUE);
                dm.dragFrame(BasicInternalFrameUI.this.frame, e.getX() - this.xOffset + b.x, e.getY() - this.yOffset + b.y);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.showingCursor != 0) {
                BasicInternalFrameUI.this.frame.setCursor(Cursor.getDefaultCursor());
                this.showingCursor = 0;
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (this.showingCursor != 0 && e.getSource() != BasicInternalFrameUI.this.frame) {
                BasicInternalFrameUI.this.frame.setCursor(Cursor.getDefaultCursor());
                this.showingCursor = 0;
            } else if (e.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                this.setCursor(e);
            }
        }

        void setCursor(MouseEvent e) {
            int cursor = this.sectionOfClick(e.getX(), e.getY());
            if (cursor != this.showingCursor) {
                Cursor resize = Cursor.getPredefinedCursor(cursor);
                BasicInternalFrameUI.this.frame.setCursor(resize);
                this.showingCursor = cursor;
            }
        }

        public void mousePressed(MouseEvent e) {
            BasicInternalFrameUI.this.activateFrame(BasicInternalFrameUI.this.frame);
            DesktopManager dm = BasicInternalFrameUI.this.getDesktopManager();
            int x = e.getX();
            int y = e.getY();
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            if (e.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                this.direction = this.sectionOfClick(x, y);
                dm.beginResizingFrame(BasicInternalFrameUI.this.frame, this.direction);
            } else if (e.getSource() == BasicInternalFrameUI.this.titlePane) {
                Rectangle tBounds = BasicInternalFrameUI.this.titlePane.getBounds();
                this.xOffset = e.getX() - tBounds.x + insets.left;
                this.yOffset = e.getY() - tBounds.y + insets.top;
                dm.beginDraggingFrame(BasicInternalFrameUI.this.frame);
            }
        }

        public void mouseReleased(MouseEvent e) {
            DesktopManager dm = BasicInternalFrameUI.this.getDesktopManager();
            this.xOffset = 0;
            this.yOffset = 0;
            if (e.getSource() == BasicInternalFrameUI.this.frame && BasicInternalFrameUI.this.frame.isResizable()) {
                dm.endResizingFrame(BasicInternalFrameUI.this.frame);
            } else if (e.getSource() == BasicInternalFrameUI.this.titlePane) {
                dm.endDraggingFrame(BasicInternalFrameUI.this.frame);
                BasicInternalFrameUI.this.frame.putClientProperty("bufferedDragging", null);
            }
            this.setCursor(e);
        }

        private int sectionOfClick(int x, int y) {
            Rectangle b = BasicInternalFrameUI.this.frame.getBounds();
            int corner = 10;
            if (x < corner && y < corner) {
                return 6;
            }
            if (x > b.width - corner && y < corner) {
                return 7;
            }
            if (x > b.width - corner && y > b.height - corner) {
                return 5;
            }
            if (x < corner && y > b.height - corner) {
                return 4;
            }
            if (y < corner) {
                return 8;
            }
            if (x < corner) {
                return 10;
            }
            if (y > b.height - corner) {
                return 9;
            }
            if (x > b.width - corner) {
                return 11;
            }
            return 0;
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            if (BasicInternalFrameUI.this.frame.isMaximum()) {
                Container parent = BasicInternalFrameUI.this.frame.getParent();
                Insets i = parent.getInsets();
                int width = parent.getWidth() - i.left - i.right;
                int height = parent.getHeight() - i.top - i.bottom;
                BasicInternalFrameUI.this.frame.setBounds(0, 0, width, height);
            }
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private transient Component mouseEventTarget;
        private Component dragTarget;
        private boolean isDragging;

        protected GlassPaneDispatcher() {
        }

        public void mouseEntered(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            if (BasicInternalFrameUI.this.borderListener != null) {
                BasicInternalFrameUI.this.borderListener.mousePressed(e);
            }
            this.handleEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e);
        }

        private void handleEvent(MouseEvent e) {
            Component target = BasicInternalFrameUI.this.frame.getLayeredPane().findComponentAt(e.getX(), e.getY());
            while (target != null && target.getMouseListeners().length == 0 && target.getMouseMotionListeners().length == 0 && target.getMouseWheelListeners().length == 0) {
                target = target.getParent();
            }
            if (target != null) {
                int id = e.getID();
                switch (id) {
                    case 504: {
                        if (this.isDragging && !BasicInternalFrameUI.this.frame.isSelected()) break;
                        this.mouseEventTarget = target;
                        this.redispatch(id, e, this.mouseEventTarget);
                        break;
                    }
                    case 505: {
                        if (this.isDragging && !BasicInternalFrameUI.this.frame.isSelected()) break;
                        this.redispatch(id, e, this.mouseEventTarget);
                        break;
                    }
                    case 501: {
                        this.mouseEventTarget = target;
                        this.redispatch(id, e, this.mouseEventTarget);
                        this.dragTarget = target;
                        break;
                    }
                    case 502: {
                        if (this.isDragging) {
                            this.redispatch(id, e, this.dragTarget);
                            this.isDragging = false;
                            break;
                        }
                        this.redispatch(id, e, this.mouseEventTarget);
                        break;
                    }
                    case 500: {
                        this.redispatch(id, e, this.mouseEventTarget);
                        break;
                    }
                    case 503: {
                        if (target != this.mouseEventTarget) {
                            this.redispatch(505, e, this.mouseEventTarget);
                            this.mouseEventTarget = target;
                            this.redispatch(504, e, this.mouseEventTarget);
                        }
                        this.redispatch(id, e, this.mouseEventTarget);
                        break;
                    }
                    case 506: {
                        if (!this.isDragging) {
                            this.isDragging = true;
                        }
                        this.redispatch(id, e, this.mouseEventTarget);
                        break;
                    }
                    case 507: {
                        this.redispatch(id, e, this.mouseEventTarget);
                        break;
                    }
                    default: {
                        assert (false) : "Must not reach here";
                        break;
                    }
                }
            }
        }

        private void redispatch(int id, MouseEvent e, Component target) {
            Point p = SwingUtilities.convertPoint(BasicInternalFrameUI.this.frame.getLayeredPane(), e.getX(), e.getY(), target);
            MouseEvent ev = new MouseEvent(target, id, e.getWhen(), e.getModifiers() | e.getModifiersEx(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
            target.dispatchEvent(ev);
        }
    }

    class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        static final int bSize = 5;
        static final int cornerSize = 10;

        InternalFrameBorder() {
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.translate(x, y);
            Color saved = g.getColor();
            Rectangle b = BasicInternalFrameUI.this.frame.getBounds();
            Color d = c.getBackground();
            g.setColor(d);
            g.fillRect(0, 0, 5, b.height);
            g.fillRect(0, 0, b.width, 5);
            g.fillRect(0, b.height - 5, b.width, 5);
            g.fillRect(b.width - 5, 0, 5, b.height);
            int x3 = b.width - 5;
            int x4 = b.width;
            int y3 = b.height - 5;
            int y4 = b.height;
            g.setColor(Color.GRAY);
            g.fillRect(0, 0, 5, y4);
            g.fillRect(0, 0, x4, 5);
            g.fillRect(0, y3, b.width, 5);
            g.fillRect(x3, 0, 5, b.height);
            g.fill3DRect(0, 10, 5, b.height - 20, false);
            g.fill3DRect(10, 0, b.width - 20, 5, false);
            g.fill3DRect(10, b.height - 5, b.width - 20, 5, false);
            g.fill3DRect(b.width - 5, 10, 5, b.height - 20, false);
            g.translate(-x, -y);
            g.setColor(saved);
        }
    }

    public class InternalFrameLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void layoutContainer(Container c) {
            Dimension dims = BasicInternalFrameUI.this.frame.getSize();
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            dims.width -= insets.left + insets.right;
            dims.height -= insets.top + insets.bottom;
            int nh = 0;
            int sh = 0;
            int ew = 0;
            int ww = 0;
            if (BasicInternalFrameUI.this.northPane != null) {
                Dimension nDims = BasicInternalFrameUI.this.northPane.getPreferredSize();
                nh = Math.min(nDims.height, dims.height);
                BasicInternalFrameUI.this.northPane.setBounds(insets.left, insets.top, dims.width, nh);
            }
            if (BasicInternalFrameUI.this.southPane != null) {
                Dimension sDims = BasicInternalFrameUI.this.southPane.getPreferredSize();
                sh = Math.min(sDims.height, dims.height - nh);
                BasicInternalFrameUI.this.southPane.setBounds(insets.left, insets.top + dims.height - sh, dims.width, sh);
            }
            int remHeight = dims.height - sh - nh;
            if (BasicInternalFrameUI.this.westPane != null) {
                Dimension wDims = BasicInternalFrameUI.this.westPane.getPreferredSize();
                ww = Math.min(dims.width, wDims.width);
                BasicInternalFrameUI.this.westPane.setBounds(insets.left, insets.top + nh, ww, remHeight);
            }
            if (BasicInternalFrameUI.this.eastPane != null) {
                Dimension eDims = BasicInternalFrameUI.this.eastPane.getPreferredSize();
                ew = Math.min(eDims.width, dims.width - ww);
                BasicInternalFrameUI.this.eastPane.setBounds(insets.left + dims.width - ew, insets.top + nh, ew, remHeight);
            }
            int remWidth = dims.width - ww - ew;
            BasicInternalFrameUI.this.frame.getRootPane().setBounds(insets.left + ww, insets.top + nh, remWidth, remHeight);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.getSize(c, true);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.getSize(c, false);
        }

        private Dimension getSize(Container c, boolean min) {
            Dimension dims;
            Insets insets = BasicInternalFrameUI.this.frame.getInsets();
            Dimension contentDims = BasicInternalFrameUI.this.frame.getContentPane().getPreferredSize();
            if (min) {
                contentDims.height = 0;
                contentDims.width = 0;
            }
            int nWidth = 0;
            int nHeight = 0;
            int sWidth = 0;
            int sHeight = 0;
            int eWidth = 0;
            int eHeight = 0;
            int wWidth = 0;
            int wHeight = 0;
            if (BasicInternalFrameUI.this.northPane != null && (dims = BasicInternalFrameUI.this.northPane.getPreferredSize()) != null) {
                nWidth = dims.width;
                nHeight = dims.height;
            }
            if (BasicInternalFrameUI.this.southPane != null && (dims = BasicInternalFrameUI.this.southPane.getPreferredSize()) != null) {
                sWidth = dims.width;
                sHeight = dims.height;
            }
            if (BasicInternalFrameUI.this.eastPane != null && (dims = BasicInternalFrameUI.this.eastPane.getPreferredSize()) != null) {
                sWidth = dims.width;
                sHeight = dims.height;
            }
            if (BasicInternalFrameUI.this.westPane != null && (dims = BasicInternalFrameUI.this.westPane.getPreferredSize()) != null) {
                wWidth = dims.width;
                wHeight = dims.height;
            }
            int width = Math.max(sWidth, nWidth);
            width = Math.max(width, contentDims.width + eWidth + wWidth);
            int height = Math.max(eHeight, wHeight);
            height = Math.max(height, contentDims.height);
            height += nHeight + sHeight;
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component c) {
        }
    }

    public class InternalFramePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("maximum")) {
                if (BasicInternalFrameUI.this.frame.isMaximum()) {
                    BasicInternalFrameUI.this.maximizeFrame(BasicInternalFrameUI.this.frame);
                } else {
                    BasicInternalFrameUI.this.minimizeFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (property.equals("icon")) {
                if (BasicInternalFrameUI.this.frame.isIcon()) {
                    BasicInternalFrameUI.this.iconifyFrame(BasicInternalFrameUI.this.frame);
                } else {
                    BasicInternalFrameUI.this.deiconifyFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (property.equals("selected")) {
                Component glassPane = BasicInternalFrameUI.this.frame.getGlassPane();
                if (BasicInternalFrameUI.this.frame.isSelected()) {
                    BasicInternalFrameUI.this.activateFrame(BasicInternalFrameUI.this.frame);
                    glassPane.setVisible(false);
                } else {
                    BasicInternalFrameUI.this.deactivateFrame(BasicInternalFrameUI.this.frame);
                    glassPane.setVisible(true);
                }
            } else if (property.equals("rootPane") || property.equals("glassPane")) {
                Component newPane;
                Component old = (Component)evt.getOldValue();
                if (old != null) {
                    old.removeMouseListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                    old.removeMouseMotionListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                }
                if ((newPane = (Component)evt.getNewValue()) != null) {
                    newPane.addMouseListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                    newPane.addMouseMotionListener(BasicInternalFrameUI.this.glassPaneDispatcher);
                }
                BasicInternalFrameUI.this.frame.revalidate();
            } else if (property.equals("closed")) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    Container parent = BasicInternalFrameUI.this.frame.getParent();
                    if (parent != null) {
                        parent.removeComponentListener(BasicInternalFrameUI.this.componentListener);
                    }
                    BasicInternalFrameUI.this.closeFrame(BasicInternalFrameUI.this.frame);
                }
            } else if (property.equals("ancestor")) {
                Container newParent = (Container)evt.getNewValue();
                Container oldParent = (Container)evt.getOldValue();
                if (newParent != null) {
                    newParent.addComponentListener(BasicInternalFrameUI.this.componentListener);
                } else if (oldParent != null) {
                    oldParent.removeComponentListener(BasicInternalFrameUI.this.componentListener);
                }
            }
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private ShowSystemMenuAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicInternalFrameUI.this.titlePane != null) {
                BasicInternalFrameUI.this.titlePane.showSystemMenu();
            }
        }
    }
}

