/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfo
extends MBeanFeatureInfo
implements Cloneable {
    private static final long serialVersionUID = 4433990064191844427L;
    private MBeanParameterInfo[] signature;

    public MBeanConstructorInfo(String desc, Constructor cons) {
        super(cons.getName(), desc);
        Type[] paramTypes = cons.getGenericParameterTypes();
        this.signature = new MBeanParameterInfo[paramTypes.length];
        int a = 0;
        while (a < paramTypes.length) {
            Type t = paramTypes[a];
            this.signature[a] = t instanceof Class ? new MBeanParameterInfo(null, ((Class)t).getName(), null) : new MBeanParameterInfo(null, t.toString(), null);
            ++a;
        }
    }

    public MBeanConstructorInfo(String name, String desc, MBeanParameterInfo[] sig) {
        super(name, desc);
        if (sig == null) {
            this.signature = new MBeanParameterInfo[0];
        } else {
            this.signature = new MBeanParameterInfo[sig.length];
            System.arraycopy(sig, 0, this.signature, 0, sig.length);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("clone() called on non-cloneable object.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MBeanConstructorInfo)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MBeanConstructorInfo o = (MBeanConstructorInfo)obj;
        MBeanParameterInfo[] sig = o.getSignature();
        int a = 0;
        while (a < this.signature.length) {
            if (a == sig.length) {
                return true;
            }
            if (!this.signature[a].equals(sig[a])) {
                return false;
            }
            ++a;
        }
        return true;
    }

    public MBeanParameterInfo[] getSignature() {
        return (MBeanParameterInfo[])this.signature.clone();
    }

    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.signature);
    }

    public String toString() {
        if (this.string == null) {
            super.toString();
            this.string = String.valueOf(this.string.substring(0, this.string.length() - 1)) + ",signature=" + Arrays.toString(this.signature) + "]";
        }
        return this.string;
    }
}

