/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exchanger<V> {
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int CAPACITY = 32;
    private static final int FULL = Math.max(0, Math.min(32, NCPU / 2) - 1);
    private static final int SPINS = NCPU == 1 ? 0 : 2000;
    private static final int TIMED_SPINS = SPINS / 20;
    private static final Object CANCEL = new Object();
    private static final Object NULL_ITEM = new Object();
    private volatile Slot[] arena = new Slot[32];
    private final AtomicInteger max = new AtomicInteger();

    private Object doExchange(Object item, boolean timed, long nanos) {
        Node me = new Node(item);
        int index = this.hashIndex();
        int fails = 0;
        while (true) {
            Slot slot;
            if ((slot = this.arena[index]) == null) {
                this.createSlot(index);
                continue;
            }
            Object y = slot.get();
            if (y != null && slot.compareAndSet(y, null)) {
                Node you = (Node)y;
                if (!you.compareAndSet(null, item)) continue;
                LockSupport.unpark(you.waiter);
                return you.item;
            }
            if (y == null && slot.compareAndSet(null, me)) {
                if (index == 0) {
                    return timed ? this.awaitNanos(me, slot, nanos) : Exchanger.await(me, slot);
                }
                Object v = Exchanger.spinWait(me, slot);
                if (v != CANCEL) {
                    return v;
                }
                me = new Node(item);
                int m = this.max.get();
                if (m <= (index >>>= 1)) continue;
                this.max.compareAndSet(m, m - 1);
                continue;
            }
            if (++fails <= 1) continue;
            int m = this.max.get();
            if (fails > 3 && m < FULL && this.max.compareAndSet(m, m + 1)) {
                index = m + 1;
                continue;
            }
            if (--index >= 0) continue;
            index = m;
        }
    }

    private final int hashIndex() {
        int index;
        long id = Thread.currentThread().getId();
        int hash = ((int)(id ^ id >>> 32) ^ 0x811C9DC5) * 16777619;
        int m = this.max.get();
        int nbits = -1024 >> m & 4 | 504 >>> m & 2 | -65294 >>> m & 1;
        while ((index = hash & (1 << nbits) - 1) > m) {
            hash = hash >>> nbits | hash << 33 - nbits;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSlot(int index) {
        Slot[] a;
        Slot newSlot = new Slot();
        Slot[] slotArray = a = this.arena;
        synchronized (a) {
            if (a[index] == null) {
                a[index] = newSlot;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static boolean tryCancel(Node node2, Slot slot) {
        if (!node2.compareAndSet(null, CANCEL)) {
            return false;
        }
        if (slot.get() == node2) {
            slot.compareAndSet(node2, null);
        }
        return true;
    }

    private static Object spinWait(Node node2, Slot slot) {
        int spins = SPINS;
        Object v;
        while ((v = node2.get()) == null) {
            if (spins > 0) {
                --spins;
                continue;
            }
            Exchanger.tryCancel(node2, slot);
        }
        return v;
    }

    private static Object await(Node node2, Slot slot) {
        Thread w = Thread.currentThread();
        int spins = SPINS;
        Object v;
        while ((v = node2.get()) == null) {
            if (spins > 0) {
                --spins;
                continue;
            }
            if (node2.waiter == null) {
                node2.waiter = w;
                continue;
            }
            if (w.isInterrupted()) {
                Exchanger.tryCancel(node2, slot);
                continue;
            }
            LockSupport.park(node2);
        }
        return v;
    }

    private Object awaitNanos(Node node2, Slot slot, long nanos) {
        int spins = TIMED_SPINS;
        long lastTime = 0L;
        Thread w = null;
        while (true) {
            Object v;
            if ((v = node2.get()) != null) {
                return v;
            }
            long now = System.nanoTime();
            if (w == null) {
                w = Thread.currentThread();
            } else {
                nanos -= now - lastTime;
            }
            lastTime = now;
            if (nanos > 0L) {
                if (spins > 0) {
                    --spins;
                    continue;
                }
                if (node2.waiter == null) {
                    node2.waiter = w;
                    continue;
                }
                if (w.isInterrupted()) {
                    Exchanger.tryCancel(node2, slot);
                    continue;
                }
                LockSupport.parkNanos(node2, nanos);
                continue;
            }
            if (Exchanger.tryCancel(node2, slot) && !w.isInterrupted()) break;
        }
        return this.scanOnTimeout(node2);
    }

    private Object scanOnTimeout(Node node2) {
        int j = this.arena.length - 1;
        while (j >= 0) {
            Slot slot = this.arena[j];
            if (slot != null) {
                Object y;
                while ((y = slot.get()) != null) {
                    Node you;
                    if (!slot.compareAndSet(y, null) || !(you = (Node)y).compareAndSet(null, node2.item)) continue;
                    LockSupport.unpark(you.waiter);
                    return you.item;
                }
            }
            --j;
        }
        return CANCEL;
    }

    public V exchange(V x) throws InterruptedException {
        if (!Thread.interrupted()) {
            Object v = this.doExchange(x == null ? NULL_ITEM : x, false, 0L);
            if (v == NULL_ITEM) {
                return null;
            }
            if (v != CANCEL) {
                return (V)v;
            }
            Thread.interrupted();
        }
        throw new InterruptedException();
    }

    public V exchange(V x, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!Thread.interrupted()) {
            Object v = this.doExchange(x == null ? NULL_ITEM : x, true, unit.toNanos(timeout));
            if (v == NULL_ITEM) {
                return null;
            }
            if (v != CANCEL) {
                return (V)v;
            }
            if (!Thread.interrupted()) {
                throw new TimeoutException();
            }
        }
        throw new InterruptedException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node
    extends AtomicReference<Object> {
        public final Object item;
        public volatile Thread waiter;

        public Node(Object item) {
            this.item = item;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Slot
    extends AtomicReference<Object> {
        long q0;
        long q1;
        long q2;
        long q3;
        long q4;
        long q5;
        long q6;
        long q7;
        long q8;
        long q9;
        long qa;
        long qb;
        long qc;
        long qd;
        long qe;

        private Slot() {
        }
    }
}

