/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.util.Enumeration;

public class ProtectionDomain {
    private CodeSource code_source;
    private PermissionCollection perms;
    private ClassLoader classloader;
    private Principal[] principals;
    private boolean staticBinding;
    private boolean hasAllPermissions;

    public ProtectionDomain(CodeSource codesource, PermissionCollection permissions) {
        this(codesource, permissions, null, null, true);
    }

    public ProtectionDomain(CodeSource codesource, PermissionCollection permissions, ClassLoader classloader, Principal[] principals) {
        this(codesource, permissions, classloader, principals, false);
    }

    private ProtectionDomain(CodeSource codesource, PermissionCollection permissions, ClassLoader classloader, Principal[] principals, boolean staticBinding) {
        this.code_source = codesource;
        if (permissions != null) {
            this.perms = permissions;
            this.perms.setReadOnly();
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                if (!(e.nextElement() instanceof AllPermission)) continue;
                this.hasAllPermissions = true;
            }
        }
        this.classloader = classloader;
        this.principals = principals != null ? (Principal[])principals.clone() : new Principal[]{};
        this.staticBinding = staticBinding;
    }

    public final CodeSource getCodeSource() {
        return this.code_source;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public final PermissionCollection getPermissions() {
        return this.perms;
    }

    public boolean implies(Permission permission) {
        if (this.hasAllPermissions) {
            return true;
        }
        if (this.staticBinding) {
            return this.perms == null ? false : this.perms.implies(permission);
        }
        return Policy.getCurrentPolicy().implies(this, permission);
    }

    public String toString() {
        String linesep = SystemProperties.getProperty("line.separator");
        CPStringBuilder sb = new CPStringBuilder("ProtectionDomain (").append(linesep);
        if (this.code_source == null) {
            sb.append("CodeSource:null");
        } else {
            sb.append(this.code_source);
        }
        sb.append(linesep);
        if (this.classloader == null) {
            sb.append("ClassLoader:null");
        } else {
            sb.append(this.classloader);
        }
        sb.append(linesep);
        sb.append("Principals:");
        if (this.principals != null && this.principals.length > 0) {
            sb.append("[");
            int i = 0;
            while (i < this.principals.length) {
                Principal pal = this.principals[i];
                sb.append("'").append(pal.getName()).append("' of type ").append(pal.getClass().getName());
                if (i < this.principals.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append("]");
        } else {
            sb.append("none");
        }
        sb.append(linesep);
        if (!this.staticBinding) {
            if (Policy.isLoaded()) {
                try {
                    sb.append(Policy.getPolicy().getPermissions(this));
                }
                catch (SecurityException securityException) {
                    sb.append(this.perms);
                }
            } else {
                sb.append(this.perms);
            }
        } else {
            sb.append(this.perms);
        }
        return sb.append(linesep).append(")").append(linesep).toString();
    }
}

