/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class TimeType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    TimeType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "time"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int state = 3;
        int start = 0;
        int i = 0;
        while (i < len) {
            block28: {
                char c;
                block27: {
                    c = value.charAt(i);
                    if (c != '-' || state != 0) break block27;
                    ++start;
                    break block28;
                }
                if (c >= '0' && c <= '9') break block28;
                switch (state) {
                    case 3: {
                        if (c != ':') throw new DatatypeException(i, "invalid time value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid time value");
                        }
                        state = 4;
                        start = i + 1;
                        break;
                    }
                    case 4: {
                        if (c != ':') throw new DatatypeException(i, "invalid time value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid time value");
                        }
                        state = 5;
                        start = i + 1;
                        break;
                    }
                    case 5: {
                        if (c == '.') {
                            if (i - start != 2) {
                                throw new DatatypeException(i, "invalid time value");
                            }
                            state = 6;
                            start = i + 1;
                            break;
                        }
                        if (c != ' ') throw new DatatypeException(i, "invalid time value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid time value");
                        }
                        state = 7;
                        start = i + 1;
                        break;
                    }
                    case 6: {
                        if (c != ' ') throw new DatatypeException(i, "invalid time value");
                        state = 7;
                        start = i + 1;
                        break;
                    }
                    case 7: {
                        if (start == i) {
                            if (c == '+' || c == '-') break;
                            if (c == 'Z') {
                                state = 9;
                                start = i + 1;
                                break;
                            }
                        }
                        if (c != ':') throw new DatatypeException(i, "invalid time value");
                        if (i - start != 2) {
                            throw new DatatypeException(i, "invalid time value");
                        }
                        state = 8;
                        start = i + 1;
                        break;
                    }
                    default: {
                        throw new DatatypeException(i, "invalid time value");
                    }
                }
            }
            ++i;
        }
        switch (state) {
            case 5: {
                if (len - start == 2) return;
                throw new DatatypeException(len, "invalid time value");
            }
            case 6: {
                return;
            }
            case 8: {
                if (len - start == 2) return;
                throw new DatatypeException(len, "invalid time value");
            }
            case 9: {
                return;
            }
            default: {
                throw new DatatypeException(len, "invalid time value");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object createValue(String value, ValidationContext context) {
        int len = value.length();
        int state = 3;
        int start = 0;
        Time time = new Time();
        try {
            int i;
            String timezone;
            block12: {
                TimeZone tz;
                int i2 = 0;
                while (true) {
                    if (i2 >= len) {
                        if (len - start <= 0) return time;
                        if (state != 7) return time;
                        timezone = value.substring(len - start);
                        i = timezone.indexOf(58);
                        if (i == -1) {
                            if ("Z".equals(timezone)) {
                                timezone = "UTC";
                            }
                            if ((tz = TimeZone.getTimeZone(timezone)) != null) break;
                            return null;
                        }
                        break block12;
                    }
                    char c = value.charAt(i2);
                    if (c < '0' || c > '9') {
                        switch (state) {
                            case 3: {
                                if (c != ':') break;
                                time.minutes = Integer.parseInt(value.substring(start, i2)) * 60;
                                state = 4;
                                start = i2 + 1;
                                break;
                            }
                            case 4: {
                                if (c != ':') break;
                                time.minutes += Integer.parseInt(value.substring(start, i2));
                                state = 5;
                                start = i2 + 1;
                                break;
                            }
                            case 5: {
                                if (c != ' ') break;
                                time.seconds = Float.parseFloat(value.substring(start, i2));
                                state = 7;
                                start = i2 + 1;
                                break;
                            }
                        }
                    }
                    ++i2;
                }
                time.minutes += tz.getRawOffset();
                return time;
            }
            String tzh = timezone.substring(0, i);
            String tzm = timezone.substring(i + 1);
            int offset = Integer.parseInt(tzh) * 60;
            offset = offset < 0 ? (offset -= Integer.parseInt(tzm)) : (offset += Integer.parseInt(tzm));
            time.minutes += offset;
            return time;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static class Time
    implements Comparable {
        int minutes;
        float seconds;

        Time() {
        }

        public int hashCode() {
            return this.minutes * 31 + new Float(this.seconds).hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Time) {
                Time time = (Time)other;
                return time.minutes == this.minutes && time.seconds == this.seconds;
            }
            return false;
        }

        public int compareTo(Object other) {
            if (other instanceof Time) {
                Time time = (Time)other;
                if (time.minutes != this.minutes) {
                    return this.minutes - time.minutes;
                }
                if (time.seconds == this.seconds) {
                    return 0;
                }
                return this.seconds < time.seconds ? -1 : 1;
            }
            return 0;
        }
    }
}

