/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser;

import gnu.javax.swing.text.html.parser.support.Parser;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.text.html.parser.TagElement;

public class GnuParserDelegator
extends ParserDelegator
implements Serializable {
    private static final long serialVersionUID = -1276686502624777206L;
    private DTD theDtd;
    HTMLEditorKit.ParserCallback callBack;
    gnuParser gnu;

    public GnuParserDelegator(DTD theDtd) {
        this.theDtd = theDtd;
        this.gnu = new gnuParser(theDtd);
    }

    public void parse(Reader reader, HTMLEditorKit.ParserCallback a_callback, boolean ignoreCharSet) throws IOException {
        this.callBack = a_callback;
        this.gnu.parse(reader);
        this.callBack.handleEndOfLineString(this.gnu.getEndOfLineSequence());
        try {
            this.callBack.flush();
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    class gnuParser
    extends Parser {
        private static final long serialVersionUID = 1L;

        gnuParser(DTD d) {
            super(d);
        }

        protected final void handleComment(char[] comment) {
            GnuParserDelegator.this.callBack.handleComment(comment, this.hTag.where.startPosition);
        }

        protected final void handleEmptyTag(TagElement tag) throws ChangedCharSetException {
            GnuParserDelegator.this.callBack.handleSimpleTag(tag.getHTMLTag(), this.getAttributes(), this.hTag.where.startPosition);
        }

        protected final void handleEndTag(TagElement tag) {
            GnuParserDelegator.this.callBack.handleEndTag(tag.getHTMLTag(), this.hTag.where.startPosition);
        }

        protected final void handleError(int line, String message) {
            GnuParserDelegator.this.callBack.handleError(message, this.hTag.where.startPosition);
        }

        protected final void handleStartTag(TagElement tag) {
            SimpleAttributeSet attributes = GnuParserDelegator.this.gnu.getAttributes();
            if (tag.fictional()) {
                attributes.addAttribute(HTMLEditorKit.ParserCallback.IMPLIED, Boolean.TRUE);
            }
            GnuParserDelegator.this.callBack.handleStartTag(tag.getHTMLTag(), attributes, this.hTag.where.startPosition);
        }

        protected final void handleText(char[] text) {
            GnuParserDelegator.this.callBack.handleText(text, this.hTag.where.startPosition);
        }

        DTD getDTD() {
            return this.dtd;
        }
    }
}

