/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.BacktrackStack;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.CharIndexedCharArray;
import gnu.java.util.regex.CharIndexedCharSequence;
import gnu.java.util.regex.CharIndexedInputStream;
import gnu.java.util.regex.CharIndexedString;
import gnu.java.util.regex.CharIndexedStringBuffer;
import gnu.java.util.regex.REException;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REMatchEnumeration;
import gnu.java.util.regex.RESyntax;
import gnu.java.util.regex.REToken;
import gnu.java.util.regex.RETokenAny;
import gnu.java.util.regex.RETokenBackRef;
import gnu.java.util.regex.RETokenChar;
import gnu.java.util.regex.RETokenEnd;
import gnu.java.util.regex.RETokenEndOfPreviousMatch;
import gnu.java.util.regex.RETokenEndSub;
import gnu.java.util.regex.RETokenIndependent;
import gnu.java.util.regex.RETokenLookAhead;
import gnu.java.util.regex.RETokenLookBehind;
import gnu.java.util.regex.RETokenNamedProperty;
import gnu.java.util.regex.RETokenOneOf;
import gnu.java.util.regex.RETokenPOSIX;
import gnu.java.util.regex.RETokenRange;
import gnu.java.util.regex.RETokenRepeated;
import gnu.java.util.regex.RETokenStart;
import gnu.java.util.regex.RETokenWordBoundary;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class RE
extends REToken {
    private static final String VERSION = "1.1.5-dev";
    private static ResourceBundle messages;
    private static final String bundle = "gnu/java/util/regex/MessagesBundle";
    private REToken firstToken;
    private REToken lastToken;
    private int numSubs;
    private int minimumLength;
    private int maximumLength;
    public static final int REG_ICASE = 2;
    public static final int REG_DOT_NEWLINE = 4;
    public static final int REG_MULTILINE = 8;
    public static final int REG_NOTBOL = 16;
    public static final int REG_NOTEOL = 32;
    public static final int REG_ANCHORINDEX = 64;
    public static final int REG_NO_INTERPOLATE = 128;
    public static final int REG_TRY_ENTIRE_MATCH = 256;
    public static final int REG_REPLACE_USE_BACKSLASHESCAPE = 512;
    public static final int REG_X_COMMENTS = 1024;
    public static final int REG_ICASE_USASCII = 2048;
    public static final int REG_FIX_STARTING_POSITION = 4096;

    public static final String version() {
        return VERSION;
    }

    static final String getLocalizedMessage(String key) {
        if (messages == null) {
            messages = PropertyResourceBundle.getBundle(bundle, Locale.getDefault());
        }
        return messages.getString(key);
    }

    public RE(Object pattern2) throws REException {
        this(pattern2, 0, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object pattern2, int cflags) throws REException {
        this(pattern2, cflags, RESyntax.RE_SYNTAX_PERL5, 0, 0);
    }

    public RE(Object pattern2, int cflags, RESyntax syntax) throws REException {
        this(pattern2, cflags, syntax, 0, 0);
    }

    private RE(REToken first, REToken last, int subs, int subIndex, int minLength, int maxLength) {
        super(subIndex);
        this.firstToken = first;
        this.lastToken = last;
        this.numSubs = subs;
        this.minimumLength = minLength;
        this.maximumLength = maxLength;
        this.addToken(new RETokenEndSub(subIndex));
    }

    private RE(Object patternObj, int cflags, RESyntax syntax, int myIndex, int nextSub) throws REException {
        super(myIndex);
        this.initialize(patternObj, cflags, syntax, myIndex, nextSub);
    }

    protected RE() {
        super(0);
    }

    protected void initialize(Object patternObj, int cflags, RESyntax syntax, int myIndex, int nextSub) throws REException {
        char[] pattern2;
        if (patternObj instanceof String) {
            pattern2 = ((String)patternObj).toCharArray();
        } else if (patternObj instanceof char[]) {
            pattern2 = (char[])patternObj;
        } else if (patternObj instanceof StringBuffer) {
            pattern2 = new char[((StringBuffer)patternObj).length()];
            ((StringBuffer)patternObj).getChars(0, pattern2.length, pattern2, 0);
        } else if (patternObj instanceof StringBuilder) {
            pattern2 = new char[((StringBuilder)patternObj).length()];
            ((StringBuilder)patternObj).getChars(0, pattern2.length, pattern2, 0);
        } else if (patternObj instanceof CPStringBuilder) {
            pattern2 = new char[((CPStringBuilder)patternObj).length()];
            ((CPStringBuilder)patternObj).getChars(0, pattern2.length, pattern2, 0);
        } else {
            pattern2 = patternObj.toString().toCharArray();
        }
        int pLength = pattern2.length;
        this.numSubs = 0;
        ArrayList<RE> branches = null;
        this.lastToken = null;
        this.firstToken = null;
        boolean insens = (cflags & 2) > 0;
        boolean insensUSASCII = (cflags & 0x800) > 0;
        int index = 0;
        CharUnit unit = new CharUnit();
        IntPair minMax = new IntPair();
        REToken currentToken = null;
        boolean quot = false;
        RESyntax savedSyntax = null;
        int savedCflags = 0;
        boolean flagsSaved = false;
        while (index < pLength) {
            index = RE.getCharUnit(pattern2, index, unit, quot);
            if (unit.bk) {
                if (unit.ch == 'Q') {
                    quot = true;
                    continue;
                }
                if (unit.ch == 'E') {
                    quot = false;
                    continue;
                }
            }
            if (quot) {
                unit.bk = false;
            }
            if ((cflags & 0x400) > 0 && !unit.bk && !quot) {
                if (Character.isWhitespace(unit.ch)) continue;
                if (unit.ch == '#') {
                    int i = index;
                    while (i < pLength) {
                        if (pattern2[i] == '\n') {
                            index = i + 1;
                        } else if (pattern2[i] == '\r') {
                            index = i + 1 < pLength && pattern2[i + 1] == '\n' ? i + 2 : i + 1;
                        }
                        ++i;
                    }
                    index = pLength;
                    continue;
                }
            }
            if ((unit.ch == '|' && syntax.get(14) ^ (unit.bk || quot) || syntax.get(10) && unit.ch == '\n' && !unit.bk && !quot) && !syntax.get(9)) {
                this.addToken(currentToken);
                RE theBranch = new RE(this.firstToken, this.lastToken, this.numSubs, this.subIndex, this.minimumLength, this.maximumLength);
                this.minimumLength = 0;
                this.maximumLength = 0;
                if (branches == null) {
                    branches = new ArrayList<RE>();
                }
                branches.add(theBranch);
                currentToken = null;
                this.lastToken = null;
                this.firstToken = null;
                continue;
            }
            if (unit.ch == '{' && syntax.get(8) && syntax.get(11) ^ (unit.bk || quot)) {
                int newIndex = this.getMinMax(pattern2, index, minMax, syntax);
                if (newIndex > index) {
                    if (minMax.first > minMax.second) {
                        throw new REException(RE.getLocalizedMessage("interval.order"), 1, newIndex);
                    }
                    if (currentToken == null) {
                        throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, newIndex);
                    }
                    if (currentToken instanceof RETokenRepeated) {
                        throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, newIndex);
                    }
                    if (currentToken instanceof RETokenWordBoundary || currentToken instanceof RETokenWordBoundary) {
                        throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, newIndex);
                    }
                    index = newIndex;
                    currentToken = RE.setRepeated(currentToken, minMax.first, minMax.second, index);
                    continue;
                }
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.subIndex, unit.ch, insens);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.ch == '[' && !unit.bk && !quot) {
                ParseCharClassResult result = RE.parseCharClass(this.subIndex, pattern2, index, pLength, cflags, syntax, 0);
                this.addToken(currentToken);
                currentToken = result.token;
                index = result.index;
                continue;
            }
            if (unit.ch == '(' && syntax.get(12) ^ (unit.bk || quot)) {
                boolean pure = false;
                boolean comment = false;
                boolean lookAhead = false;
                boolean lookBehind = false;
                boolean independent = false;
                boolean negativelh = false;
                boolean negativelb = false;
                if (index + 1 < pLength && pattern2[index] == '?') {
                    switch (pattern2[index + 1]) {
                        case '!': {
                            if (!syntax.get(21)) break;
                            pure = true;
                            negativelh = true;
                            lookAhead = true;
                            index += 2;
                            break;
                        }
                        case '=': {
                            if (!syntax.get(21)) break;
                            pure = true;
                            lookAhead = true;
                            index += 2;
                            break;
                        }
                        case '<': {
                            if (!syntax.get(21)) break;
                            switch (pattern2[++index + 1]) {
                                case '!': {
                                    pure = true;
                                    negativelb = true;
                                    lookBehind = true;
                                    index += 2;
                                    break;
                                }
                                case '=': {
                                    pure = true;
                                    lookBehind = true;
                                    index += 2;
                                }
                            }
                            break;
                        }
                        case '>': {
                            if (!syntax.get(21)) break;
                            pure = true;
                            independent = true;
                            index += 2;
                            break;
                        }
                        case '-': 
                        case 'd': 
                        case 'i': 
                        case 'm': 
                        case 's': 
                        case 'u': 
                        case 'x': {
                            if (!syntax.get(26)) break;
                            int flagIndex = index + 1;
                            int endFlag = -1;
                            RESyntax newSyntax = new RESyntax(syntax);
                            int newCflags = cflags;
                            boolean negate = false;
                            while (flagIndex < pLength && endFlag < 0) {
                                switch (pattern2[flagIndex]) {
                                    case 'i': {
                                        newCflags = negate ? (newCflags &= 0xFFFFFFFD) : (newCflags |= 2);
                                        ++flagIndex;
                                        break;
                                    }
                                    case 'd': {
                                        if (negate) {
                                            newSyntax.setLineSeparator(RESyntax.DEFAULT_LINE_SEPARATOR);
                                        } else {
                                            newSyntax.setLineSeparator("\n");
                                        }
                                        ++flagIndex;
                                        break;
                                    }
                                    case 'm': {
                                        newCflags = negate ? (newCflags &= 0xFFFFFFF7) : (newCflags |= 8);
                                        ++flagIndex;
                                        break;
                                    }
                                    case 's': {
                                        newCflags = negate ? (newCflags &= 0xFFFFFFFB) : (newCflags |= 4);
                                        ++flagIndex;
                                        break;
                                    }
                                    case 'u': {
                                        newCflags = negate ? (newCflags |= 0x800) : (newCflags &= 0xFFFFF7FF);
                                        ++flagIndex;
                                        break;
                                    }
                                    case 'x': {
                                        newCflags = negate ? (newCflags &= 0xFFFFFBFF) : (newCflags |= 0x400);
                                        ++flagIndex;
                                        break;
                                    }
                                    case '-': {
                                        negate = true;
                                        ++flagIndex;
                                        break;
                                    }
                                    case ')': 
                                    case ':': {
                                        endFlag = pattern2[flagIndex];
                                        break;
                                    }
                                    default: {
                                        throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                                    }
                                }
                            }
                            if (endFlag == 41) {
                                syntax = newSyntax;
                                cflags = newCflags;
                                insens = (cflags & 2) > 0;
                                insensUSASCII = (cflags & 0x800) > 0;
                                comment = true;
                                index = flagIndex - 1;
                                break;
                            }
                            if (endFlag == 58) {
                                savedSyntax = syntax;
                                savedCflags = cflags;
                                flagsSaved = true;
                                syntax = newSyntax;
                                cflags = newCflags;
                                insens = (cflags & 2) > 0;
                                insensUSASCII = (cflags & 0x800) > 0;
                                index = flagIndex - 1;
                            } else {
                                throw new REException(RE.getLocalizedMessage("unmatched.paren"), 8, index);
                            }
                        }
                        case ':': {
                            if (!syntax.get(20)) break;
                            pure = true;
                            index += 2;
                            break;
                        }
                        case '#': {
                            if (!syntax.get(23)) break;
                            comment = true;
                            break;
                        }
                        default: {
                            throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                        }
                    }
                }
                if (index >= pLength) {
                    throw new REException(RE.getLocalizedMessage("unmatched.paren"), 8, index);
                }
                int endIndex = index;
                int nextIndex = index;
                int nested = 0;
                while (!((nextIndex = RE.getCharUnit(pattern2, endIndex, unit, false)) <= 0 || nested == 0 && unit.ch == ')' && syntax.get(12) ^ (unit.bk || quot))) {
                    endIndex = nextIndex;
                    if (endIndex >= pLength) {
                        throw new REException(RE.getLocalizedMessage("subexpr.no.end"), 8, nextIndex);
                    }
                    if (unit.ch == '[' && !unit.bk && !quot) {
                        int listIndex = nextIndex;
                        if (listIndex < pLength && pattern2[listIndex] == '^') {
                            ++listIndex;
                        }
                        if (listIndex < pLength && pattern2[listIndex] == ']') {
                            ++listIndex;
                        }
                        int listEndIndex = -1;
                        int listNest = 0;
                        block32: while (listIndex < pLength && listEndIndex < 0) {
                            switch (pattern2[listIndex++]) {
                                case '\\': {
                                    ++listIndex;
                                    break;
                                }
                                case '[': {
                                    ++listNest;
                                    if (listIndex < pLength && pattern2[listIndex] == '^') {
                                        ++listIndex;
                                    }
                                    if (listIndex >= pLength || pattern2[listIndex] != ']') continue block32;
                                    ++listIndex;
                                    break;
                                }
                                case ']': {
                                    if (listNest == 0) {
                                        listEndIndex = listIndex;
                                    }
                                    --listNest;
                                }
                            }
                        }
                        if (listEndIndex >= 0) {
                            nextIndex = listEndIndex;
                            endIndex = nextIndex;
                            if (endIndex < pLength) continue;
                            throw new REException(RE.getLocalizedMessage("subexpr.no.end"), 8, nextIndex);
                        }
                        throw new REException(RE.getLocalizedMessage("subexpr.no.end"), 8, nextIndex);
                    }
                    if (unit.ch == '(' && syntax.get(12) ^ (unit.bk || quot)) {
                        ++nested;
                        continue;
                    }
                    if (unit.ch != ')' || !(syntax.get(12) ^ (unit.bk || quot))) continue;
                    --nested;
                }
                if (comment) {
                    index = nextIndex;
                    continue;
                }
                this.addToken(currentToken);
                if (!pure) {
                    ++this.numSubs;
                }
                int useIndex = pure || lookAhead || lookBehind || independent ? 0 : nextSub + this.numSubs;
                currentToken = new RE(String.valueOf(pattern2, index, endIndex - index).toCharArray(), cflags, syntax, useIndex, nextSub + this.numSubs);
                this.numSubs += ((RE)currentToken).getNumSubs();
                if (lookAhead) {
                    currentToken = new RETokenLookAhead(currentToken, negativelh);
                } else if (lookBehind) {
                    currentToken = new RETokenLookBehind(currentToken, negativelb);
                } else if (independent) {
                    currentToken = new RETokenIndependent(currentToken);
                }
                index = nextIndex;
                if (!flagsSaved) continue;
                syntax = savedSyntax;
                cflags = savedCflags;
                insens = (cflags & 2) > 0;
                insensUSASCII = (cflags & 0x800) > 0;
                flagsSaved = false;
                continue;
            }
            if (!syntax.get(16) && unit.ch == ')' && syntax.get(12) ^ (unit.bk || quot)) {
                throw new REException(RE.getLocalizedMessage("unmatched.paren"), 7, index);
            }
            if (unit.ch == '^' && !unit.bk && !quot) {
                String sep;
                this.addToken(currentToken);
                currentToken = null;
                RETokenStart token = null;
                token = (cflags & 8) > 0 ? ((sep = syntax.getLineSeparator()) == null ? new RETokenStart(this.subIndex, null, true) : new RETokenStart(this.subIndex, sep)) : new RETokenStart(this.subIndex, null);
                this.addToken(token);
                continue;
            }
            if (unit.ch == '$' && !unit.bk && !quot) {
                String sep;
                this.addToken(currentToken);
                currentToken = null;
                RETokenEnd token = null;
                token = (cflags & 8) > 0 ? ((sep = syntax.getLineSeparator()) == null ? new RETokenEnd(this.subIndex, null, true) : new RETokenEnd(this.subIndex, sep)) : new RETokenEnd(this.subIndex, null);
                this.addToken(token);
                continue;
            }
            if (unit.ch == '.' && !unit.bk && !quot) {
                this.addToken(currentToken);
                currentToken = new RETokenAny(this.subIndex, syntax.get(6) || (cflags & 4) > 0, syntax.get(7));
                continue;
            }
            if (unit.ch == '*' && !unit.bk && !quot) {
                if (currentToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                }
                if (currentToken instanceof RETokenRepeated) {
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, index);
                }
                if (currentToken instanceof RETokenWordBoundary || currentToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, index);
                }
                currentToken = RE.setRepeated(currentToken, 0, Integer.MAX_VALUE, index);
                continue;
            }
            if (unit.ch == '+' && !syntax.get(9) && !syntax.get(1) ^ (unit.bk || quot)) {
                if (currentToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                }
                if (currentToken instanceof RETokenRepeated) {
                    RETokenRepeated tokenRep = (RETokenRepeated)currentToken;
                    if (syntax.get(25) && !tokenRep.isPossessive() && !tokenRep.isStingy()) {
                        tokenRep.makePossessive();
                        continue;
                    }
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, index);
                }
                if (currentToken instanceof RETokenWordBoundary || currentToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, index);
                }
                currentToken = RE.setRepeated(currentToken, 1, Integer.MAX_VALUE, index);
                continue;
            }
            if (unit.ch == '?' && !syntax.get(9) && !syntax.get(1) ^ (unit.bk || quot)) {
                if (currentToken == null) {
                    throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
                }
                if (currentToken instanceof RETokenRepeated) {
                    RETokenRepeated tokenRep = (RETokenRepeated)currentToken;
                    if (syntax.get(18) && !tokenRep.isStingy() && !tokenRep.isPossessive()) {
                        tokenRep.makeStingy();
                        continue;
                    }
                    throw new REException(RE.getLocalizedMessage("repeat.chained"), 1, index);
                }
                if (currentToken instanceof RETokenWordBoundary || currentToken instanceof RETokenWordBoundary) {
                    throw new REException(RE.getLocalizedMessage("repeat.assertion"), 1, index);
                }
                currentToken = RE.setRepeated(currentToken, 0, 1, index);
                continue;
            }
            if (unit.bk && unit.ch == '0' && syntax.get(27)) {
                CharExpression ce = RE.getCharExpression(pattern2, index - 2, pLength, syntax);
                if (ce == null) {
                    throw new REException("invalid octal character", 10, index);
                }
                index = index - 2 + ce.len;
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.subIndex, ce.ch, insens);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && Character.isDigit(unit.ch) && !syntax.get(13)) {
                this.addToken(currentToken);
                int numBegin = index - 1;
                int numEnd = pLength;
                int i = index;
                while (i < pLength) {
                    if (!Character.isDigit(pattern2[i])) {
                        numEnd = i;
                        break;
                    }
                    ++i;
                }
                int num = RE.parseInt(pattern2, numBegin, numEnd - numBegin, 10);
                currentToken = new RETokenBackRef(this.subIndex, num, insens);
                if (insensUSASCII) {
                    currentToken.unicodeAware = false;
                }
                index = numEnd;
                continue;
            }
            if (unit.bk && unit.ch == 'A' && syntax.get(22)) {
                this.addToken(currentToken);
                currentToken = new RETokenStart(this.subIndex, null);
                continue;
            }
            if (unit.bk && unit.ch == 'b' && syntax.get(22)) {
                this.addToken(currentToken);
                currentToken = new RETokenWordBoundary(this.subIndex, 3, false);
                continue;
            }
            if (unit.bk && unit.ch == '<') {
                this.addToken(currentToken);
                currentToken = new RETokenWordBoundary(this.subIndex, 1, false);
                continue;
            }
            if (unit.bk && unit.ch == '>') {
                this.addToken(currentToken);
                currentToken = new RETokenWordBoundary(this.subIndex, 2, false);
                continue;
            }
            if (unit.bk && unit.ch == 'B' && syntax.get(22)) {
                this.addToken(currentToken);
                currentToken = new RETokenWordBoundary(this.subIndex, 3, true);
                continue;
            }
            if (unit.bk && unit.ch == 'd' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.subIndex, 4, insens, false);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && unit.ch == 'D' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.subIndex, 4, insens, true);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && unit.ch == 'n') {
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.subIndex, '\n', false);
                continue;
            }
            if (unit.bk && unit.ch == 'r') {
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.subIndex, '\r', false);
                continue;
            }
            if (unit.bk && unit.ch == 's' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.subIndex, 9, insens, false);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && unit.ch == 'S' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.subIndex, 9, insens, true);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && unit.ch == 't') {
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.subIndex, '\t', false);
                continue;
            }
            if (unit.bk && unit.ch == 'w' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.subIndex, 0, insens, false);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && unit.ch == 'W' && syntax.get(19)) {
                this.addToken(currentToken);
                currentToken = new RETokenPOSIX(this.subIndex, 0, insens, true);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && (unit.ch == 'Z' || unit.ch == 'z') && syntax.get(22)) {
                this.addToken(currentToken);
                currentToken = new RETokenEnd(this.subIndex, null);
                continue;
            }
            if (unit.bk && unit.ch == 'x' && syntax.get(28) || unit.bk && unit.ch == 'u' && syntax.get(29)) {
                CharExpression ce = RE.getCharExpression(pattern2, index - 2, pLength, syntax);
                if (ce == null) {
                    throw new REException("invalid hex character", 10, index);
                }
                index = index - 2 + ce.len;
                this.addToken(currentToken);
                currentToken = new RETokenChar(this.subIndex, ce.ch, insens);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && unit.ch == 'p' && syntax.get(30) || unit.bk && unit.ch == 'P' && syntax.get(30)) {
                NamedProperty np = RE.getNamedProperty(pattern2, index - 2, pLength);
                if (np == null) {
                    throw new REException("invalid escape sequence", 10, index);
                }
                index = index - 2 + np.len;
                this.addToken(currentToken);
                currentToken = RE.getRETokenNamedProperty(this.subIndex, np, insens, index);
                if (!insensUSASCII) continue;
                currentToken.unicodeAware = false;
                continue;
            }
            if (unit.bk && unit.ch == 'G' && syntax.get(22)) {
                this.addToken(currentToken);
                currentToken = new RETokenEndOfPreviousMatch(this.subIndex);
                continue;
            }
            this.addToken(currentToken);
            currentToken = new RETokenChar(this.subIndex, unit.ch, insens);
            if (!insensUSASCII) continue;
            currentToken.unicodeAware = false;
        }
        this.addToken(currentToken);
        if (branches != null) {
            branches.add(new RE(this.firstToken, this.lastToken, this.numSubs, this.subIndex, this.minimumLength, this.maximumLength));
            branches.trimToSize();
            this.minimumLength = 0;
            this.maximumLength = 0;
            this.lastToken = null;
            this.firstToken = null;
            this.addToken(new RETokenOneOf(this.subIndex, (List<REToken>)branches, false));
        } else {
            this.addToken(new RETokenEndSub(this.subIndex));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static ParseCharClassResult parseCharClass(int subIndex, char[] pattern, int index, int pLength, int cflags, RESyntax syntax, int pflags) throws REException {
        insens = (cflags & 2) > 0;
        insensUSASCII = (cflags & 2048) > 0;
        options = new ArrayList<REToken>();
        addition = new ArrayList<Object>();
        additionAndAppeared = false;
        returnAtAndOperator = (pflags & 1) != 0;
        negative = false;
        lastChar = '\u0000';
        lastCharIsSet = false;
        if (index == pLength) {
            throw new REException(RE.getLocalizedMessage("unmatched.bracket"), 4, index);
        }
        ch = pattern[index];
        if (ch == '^') {
            negative = true;
            if (++index == pLength) {
                throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
            }
            ch = pattern[index];
        }
        if (ch != ']') ** GOTO lbl170
        lastChar = ch;
        lastCharIsSet = true;
        if (++index != pLength) ** GOTO lbl170
        throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
lbl-1000:
        // 1 sources

        {
            if (ch == '-' && lastCharIsSet) {
                if (index == pLength) {
                    throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
                }
                ch = pattern[index];
                if (ch == ']') {
                    t = new RETokenChar(subIndex, lastChar, insens);
                    if (insensUSASCII) {
                        t.unicodeAware = false;
                    }
                    options.add(t);
                    lastChar = '-';
                } else {
                    if (ch == '\\' && syntax.get(0)) {
                        ce = RE.getCharExpression(pattern, index, pLength, syntax);
                        if (ce == null) {
                            throw new REException("invalid escape sequence", 10, index);
                        }
                        ch = ce.ch;
                        index = index + ce.len - 1;
                    }
                    t = new RETokenRange(subIndex, lastChar, ch, insens);
                    if (insensUSASCII) {
                        t.unicodeAware = false;
                    }
                    options.add(t);
                    lastChar = '\u0000';
                    lastCharIsSet = false;
                    ++index;
                }
            } else if (ch == '\\' && syntax.get(0)) {
                if (index == pLength) {
                    throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
                }
                posixID = -1;
                negate = false;
                asciiEsc = '\u0000';
                asciiEscIsSet = false;
                np = null;
                if ("dswDSW".indexOf(pattern[index]) != -1 && syntax.get(24)) {
                    switch (pattern[index]) {
                        case 'D': {
                            negate = true;
                        }
                        case 'd': {
                            posixID = 4;
                            break;
                        }
                        case 'S': {
                            negate = true;
                        }
                        case 's': {
                            posixID = 9;
                            break;
                        }
                        case 'W': {
                            negate = true;
                        }
                        case 'w': {
                            posixID = 0;
                        }
                    }
                }
                if ("pP".indexOf(pattern[index]) != -1 && syntax.get(30)) {
                    np = RE.getNamedProperty(pattern, index - 1, pLength);
                    if (np == null) {
                        throw new REException("invalid escape sequence", 10, index);
                    }
                    index = index - 1 + np.len - 1;
                } else {
                    ce = RE.getCharExpression(pattern, index - 1, pLength, syntax);
                    if (ce == null) {
                        throw new REException("invalid escape sequence", 10, index);
                    }
                    asciiEsc = ce.ch;
                    asciiEscIsSet = true;
                    index = index - 1 + ce.len - 1;
                }
                if (lastCharIsSet) {
                    t /* !! */  = new RETokenChar(subIndex, lastChar, insens);
                    if (insensUSASCII) {
                        t /* !! */ .unicodeAware = false;
                    }
                    options.add(t /* !! */ );
                }
                if (posixID != -1) {
                    t /* !! */  = new RETokenPOSIX(subIndex, posixID, insens, negate);
                    if (insensUSASCII) {
                        t /* !! */ .unicodeAware = false;
                    }
                    options.add(t /* !! */ );
                } else if (np != null) {
                    t /* !! */  = RE.getRETokenNamedProperty(subIndex, np, insens, index);
                    if (insensUSASCII) {
                        t /* !! */ .unicodeAware = false;
                    }
                    options.add(t /* !! */ );
                } else if (asciiEscIsSet) {
                    lastChar = asciiEsc;
                    lastCharIsSet = true;
                } else {
                    lastChar = pattern[index];
                    lastCharIsSet = true;
                }
                ++index;
            } else if (ch == '[' && syntax.get(2) && index < pLength && pattern[index] == ':') {
                posixSet = new CPStringBuilder();
                index = RE.getPosixSet(pattern, index + 1, posixSet);
                posixId = RETokenPOSIX.intValue(posixSet.toString());
                if (posixId != -1) {
                    t = new RETokenPOSIX(subIndex, posixId, insens, false);
                    if (insensUSASCII) {
                        t.unicodeAware = false;
                    }
                    options.add(t);
                }
            } else if (ch == '[' && syntax.get(31)) {
                result = RE.parseCharClass(subIndex, pattern, index, pLength, cflags, syntax, 0);
                addition.add(result.token);
                addition.add("|");
                index = result.index;
            } else if (ch == '&' && syntax.get(31) && index < pLength && pattern[index] == '&') {
                if (returnAtAndOperator) {
                    result = new ParseCharClassResult();
                    options.trimToSize();
                    if (additionAndAppeared) {
                        addition.add("&");
                    }
                    if (addition.size() == 0) {
                        addition = null;
                    }
                    result.token = new RETokenOneOf(subIndex, options, addition, negative);
                    result.index = index - 1;
                    result.returnAtAndOperator = true;
                    return result;
                }
                if (additionAndAppeared) {
                    addition.add("&");
                }
                addition.add(Boolean.FALSE);
                additionAndAppeared = true;
                if (index + 1 < pLength && pattern[index + 1] != '[') {
                    result = RE.parseCharClass(subIndex, pattern, index + 1, pLength, cflags, syntax, 1);
                    addition.add(result.token);
                    addition.add("|");
                    index = result.returnAtAndOperator != false ? result.index : result.index - 1;
                }
            } else {
                if (lastCharIsSet) {
                    t = new RETokenChar(subIndex, lastChar, insens);
                    if (insensUSASCII) {
                        t.unicodeAware = false;
                    }
                    options.add(t);
                }
                lastChar = ch;
                lastCharIsSet = true;
            }
            if (index != pLength) continue;
            throw new REException(RE.getLocalizedMessage("class.no.end"), 4, index);
lbl170:
            // 3 sources

            ** while ((ch = pattern[index++]) != ']')
        }
lbl171:
        // 1 sources

        if (lastCharIsSet) {
            t = new RETokenChar(subIndex, lastChar, insens);
            if (insensUSASCII) {
                t.unicodeAware = false;
            }
            options.add(t);
        }
        result = new ParseCharClassResult();
        options.trimToSize();
        if (additionAndAppeared) {
            addition.add("&");
        }
        if (addition.size() == 0) {
            addition = null;
        }
        result.token = new RETokenOneOf(subIndex, options, addition, negative);
        result.index = index;
        return result;
    }

    private static int getCharUnit(char[] input, int index, CharUnit unit, boolean quot) throws REException {
        unit.ch = input[index++];
        boolean bl = unit.bk = unit.ch == '\\' && (!quot || index >= input.length || input[index] == 'E');
        if (unit.bk) {
            if (index < input.length) {
                unit.ch = input[index++];
            } else {
                throw new REException(RE.getLocalizedMessage("ends.with.backslash"), 10, index);
            }
        }
        return index;
    }

    private static int parseInt(char[] input, int pos, int len, int radix) {
        int ret = 0;
        int i = pos;
        while (i < pos + len) {
            ret = ret * radix + Character.digit(input[i], radix);
            ++i;
        }
        return ret;
    }

    private static CharExpression getCharExpression(char[] input, int pos, int lim, RESyntax syntax) {
        CharExpression ce = new CharExpression();
        char c = input[pos];
        if (c == '\\') {
            if (pos + 1 >= lim) {
                return null;
            }
            c = input[pos + 1];
            switch (c) {
                case 't': {
                    ce.ch = (char)9;
                    ce.len = 2;
                    break;
                }
                case 'n': {
                    ce.ch = (char)10;
                    ce.len = 2;
                    break;
                }
                case 'r': {
                    ce.ch = (char)13;
                    ce.len = 2;
                    break;
                }
                case 'u': 
                case 'x': {
                    if (c == 'x' && syntax.get(28) || c == 'u' && syntax.get(29)) {
                        int l = 0;
                        int expectedLength = c == 'x' ? 2 : 4;
                        int i = pos + 2;
                        while (i < pos + 2 + expectedLength) {
                            if (!(i < lim && (input[i] >= '0' && input[i] <= '9' || input[i] >= 'A' && input[i] <= 'F' || input[i] >= 'a' && input[i] <= 'f'))) break;
                            ++l;
                            ++i;
                        }
                        if (l != expectedLength) {
                            return null;
                        }
                        ce.ch = (char)RE.parseInt(input, pos + 2, l, 16);
                        ce.len = l + 2;
                        break;
                    }
                    ce.ch = c;
                    ce.len = 2;
                    break;
                }
                case '0': {
                    if (syntax.get(27)) {
                        int l = 0;
                        int i = pos + 2;
                        while (i < pos + 2 + 3) {
                            if (i >= lim || input[i] < '0' || input[i] > '7') break;
                            ++l;
                            ++i;
                        }
                        if (l == 3 && input[pos + 2] > '3') {
                            --l;
                        }
                        if (l <= 0) {
                            return null;
                        }
                        ce.ch = (char)RE.parseInt(input, pos + 2, l, 8);
                        ce.len = l + 2;
                        break;
                    }
                    ce.ch = c;
                    ce.len = 2;
                    break;
                }
                default: {
                    ce.ch = c;
                    ce.len = 2;
                    break;
                }
            }
        } else {
            ce.ch = input[pos];
            ce.len = 1;
        }
        ce.expr = new String(input, pos, ce.len);
        return ce;
    }

    private static NamedProperty getNamedProperty(char[] input, int pos, int lim) {
        NamedProperty np = new NamedProperty();
        char c = input[pos];
        if (c == '\\') {
            if (++pos >= lim) {
                return null;
            }
            c = input[pos++];
            switch (c) {
                case 'p': {
                    np.negate = false;
                    break;
                }
                case 'P': {
                    np.negate = true;
                    break;
                }
                default: {
                    return null;
                }
            }
            c = input[pos++];
            if (c == '{') {
                int p = -1;
                int i = pos;
                while (i < lim) {
                    if (input[i] == '}') {
                        p = i;
                        break;
                    }
                    ++i;
                }
                if (p < 0) {
                    return null;
                }
                int len = p - pos;
                np.name = new String(input, pos, len);
                np.len = len + 4;
            } else {
                np.name = new String(input, pos - 1, 1);
                np.len = 3;
            }
            return np;
        }
        return null;
    }

    private static RETokenNamedProperty getRETokenNamedProperty(int subIndex, NamedProperty np, boolean insens, int index) throws REException {
        try {
            return new RETokenNamedProperty(subIndex, np.name, insens, np.negate);
        }
        catch (REException e) {
            REException ree = new REException(e.getMessage(), 10, index);
            ree.initCause(e);
            throw ree;
        }
    }

    public boolean isMatch(Object input) {
        return this.isMatch(input, 0, 0);
    }

    public boolean isMatch(Object input, int index) {
        return this.isMatch(input, index, 0);
    }

    public boolean isMatch(Object input, int index, int eflags) {
        return this.isMatchImpl(RE.makeCharIndexed(input, index), index, eflags);
    }

    private boolean isMatchImpl(CharIndexed input, int index, int eflags) {
        if (this.firstToken == null) {
            return input.charAt(0) == '\uffff';
        }
        REMatch m = new REMatch(this.numSubs, index, eflags);
        return this.firstToken.match(input, m) && m != null && input.charAt(m.index) == '\uffff';
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    void setUncle(REToken uncle) {
        if (this.lastToken != null) {
            this.lastToken.setUncle(uncle);
        } else {
            super.setUncle(uncle);
        }
    }

    boolean chain(REToken next) {
        super.chain(next);
        this.setUncle(next);
        return true;
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public REMatch[] getAllMatches(Object input) {
        return this.getAllMatches(input, 0, 0);
    }

    public REMatch[] getAllMatches(Object input, int index) {
        return this.getAllMatches(input, index, 0);
    }

    public REMatch[] getAllMatches(Object input, int index, int eflags) {
        return this.getAllMatchesImpl(RE.makeCharIndexed(input, index), index, eflags);
    }

    private REMatch[] getAllMatchesImpl(CharIndexed input, int index, int eflags) {
        ArrayList<REMatch> all = new ArrayList<REMatch>();
        REMatch m = null;
        while ((m = this.getMatchImpl(input, index, eflags, null)) != null) {
            all.add(m);
            index = m.getEndIndex();
            if (m.end[0] == 0) {
                ++index;
                input.move(1);
            } else {
                input.move(m.end[0]);
            }
            if (!input.isValid()) break;
        }
        return all.toArray(new REMatch[all.size()]);
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        input.setHitEnd(mymatch);
        if (this.firstToken == null) {
            return this.next(input, mymatch);
        }
        mymatch.start1[this.subIndex] = mymatch.index;
        return this.firstToken.match(input, mymatch);
    }

    REMatch findMatch(CharIndexed input, REMatch mymatch) {
        boolean b;
        if (mymatch.backtrackStack == null) {
            mymatch.backtrackStack = new BacktrackStack();
        }
        if (b = this.match(input, mymatch)) {
            return mymatch;
        }
        return null;
    }

    public REMatch getMatch(Object input) {
        return this.getMatch(input, 0, 0);
    }

    public REMatch getMatch(Object input, int index) {
        return this.getMatch(input, index, 0);
    }

    public REMatch getMatch(Object input, int index, int eflags) {
        return this.getMatch(input, index, eflags, null);
    }

    public REMatch getMatch(Object input, int index, int eflags, CPStringBuilder buffer) {
        return this.getMatchImpl(RE.makeCharIndexed(input, index), index, eflags, buffer);
    }

    REMatch getMatchImpl(CharIndexed input, int anchor, int eflags, CPStringBuilder buffer) {
        RE re;
        boolean tryEntireMatch = (eflags & 0x100) != 0;
        boolean doMove = (eflags & 0x1000) == 0;
        RE rE = re = tryEntireMatch ? (RE)this.clone() : this;
        if (tryEntireMatch) {
            RETokenEnd reEnd = new RETokenEnd(0, null);
            reEnd.setFake(true);
            re.chain(reEnd);
        }
        REMatch mymatch = new REMatch(this.numSubs, anchor, eflags);
        do {
            if (re.match(input, mymatch)) {
                REMatch best = mymatch;
                best.end[0] = best.index;
                best.finish(input);
                input.setLastMatch(best);
                return best;
            }
            mymatch.clear(++anchor);
            if (buffer == null || input.charAt(0) == '\uffff') continue;
            buffer.append(input.charAt(0));
        } while (doMove && input.move1(1));
        if (this.minimumLength == 0 && this.match(input, mymatch)) {
            mymatch.finish(input);
            return mymatch;
        }
        return null;
    }

    public REMatchEnumeration getMatchEnumeration(Object input) {
        return this.getMatchEnumeration(input, 0, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object input, int index) {
        return this.getMatchEnumeration(input, index, 0);
    }

    public REMatchEnumeration getMatchEnumeration(Object input, int index, int eflags) {
        return new REMatchEnumeration(this, RE.makeCharIndexed(input, index), index, eflags);
    }

    public String substitute(Object input, String replace) {
        return this.substitute(input, replace, 0, 0);
    }

    public String substitute(Object input, String replace, int index) {
        return this.substitute(input, replace, index, 0);
    }

    public String substitute(Object input, String replace, int index, int eflags) {
        return this.substituteImpl(RE.makeCharIndexed(input, index), replace, index, eflags);
    }

    private String substituteImpl(CharIndexed input, String replace, int index, int eflags) {
        CPStringBuilder buffer = new CPStringBuilder();
        REMatch m = this.getMatchImpl(input, index, eflags, buffer);
        if (m == null) {
            return buffer.toString();
        }
        buffer.append(RE.getReplacement(replace, m, eflags));
        if (input.move(m.end[0])) {
            do {
                buffer.append(input.charAt(0));
            } while (input.move(1));
        }
        return buffer.toString();
    }

    public String substituteAll(Object input, String replace) {
        return this.substituteAll(input, replace, 0, 0);
    }

    public String substituteAll(Object input, String replace, int index) {
        return this.substituteAll(input, replace, index, 0);
    }

    public String substituteAll(Object input, String replace, int index, int eflags) {
        return this.substituteAllImpl(RE.makeCharIndexed(input, index), replace, index, eflags);
    }

    private String substituteAllImpl(CharIndexed input, String replace, int index, int eflags) {
        REMatch m;
        CPStringBuilder buffer = new CPStringBuilder();
        while ((m = this.getMatchImpl(input, index, eflags, buffer)) != null) {
            buffer.append(RE.getReplacement(replace, m, eflags));
            index = m.getEndIndex();
            if (m.end[0] == 0) {
                char ch = input.charAt(0);
                if (ch != '\uffff') {
                    buffer.append(ch);
                }
                input.move(1);
            } else {
                input.move(m.end[0]);
            }
            if (!input.isValid()) break;
        }
        return buffer.toString();
    }

    public static String getReplacement(String replace, REMatch m, int eflags) {
        if ((eflags & 0x80) > 0) {
            return replace;
        }
        if ((eflags & 0x200) > 0) {
            CPStringBuilder sb = new CPStringBuilder();
            int l = replace.length();
            int i = 0;
            while (i < l) {
                char c = replace.charAt(i);
                switch (c) {
                    case '\\': {
                        sb.append(replace.charAt(++i));
                        break;
                    }
                    case '$': {
                        int i1 = i + 1;
                        while (i1 < replace.length() && Character.isDigit(replace.charAt(i1))) {
                            ++i1;
                        }
                        sb.append(m.substituteInto(replace.substring(i, i1)));
                        i = i1 - 1;
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            return sb.toString();
        }
        return m.substituteInto(replace);
    }

    private void addToken(REToken next) {
        if (next == null) {
            return;
        }
        this.minimumLength += next.getMinimumLength();
        int nmax = next.getMaximumLength();
        this.maximumLength = nmax < Integer.MAX_VALUE && this.maximumLength < Integer.MAX_VALUE ? (this.maximumLength += nmax) : Integer.MAX_VALUE;
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = next;
        } else if (this.lastToken.chain(next)) {
            this.lastToken = next;
        }
    }

    private static REToken setRepeated(REToken current, int min, int max, int index) throws REException {
        if (current == null) {
            throw new REException(RE.getLocalizedMessage("repeat.no.token"), 1, index);
        }
        return new RETokenRepeated(current.subIndex, current, min, max);
    }

    private static int getPosixSet(char[] pattern2, int index, CPStringBuilder buf) {
        int i = index;
        while (i < pattern2.length - 1) {
            if (pattern2[i] == ':' && pattern2[i + 1] == ']') {
                return i + 2;
            }
            buf.append(pattern2[i]);
            ++i;
        }
        return index;
    }

    private int getMinMax(char[] input, int index, IntPair minMax, RESyntax syntax) throws REException {
        boolean mustMatch = !syntax.get(11);
        int startIndex = index;
        if (index == input.length) {
            if (mustMatch) {
                throw new REException(RE.getLocalizedMessage("unmatched.brace"), 3, index);
            }
            return startIndex;
        }
        int max = 0;
        CharUnit unit = new CharUnit();
        CPStringBuilder buf = new CPStringBuilder();
        do {
            index = RE.getCharUnit(input, index, unit, false);
            if (!Character.isDigit(unit.ch)) continue;
            buf.append(unit.ch);
        } while (index != input.length && Character.isDigit(unit.ch));
        if (buf.length() == 0) {
            if (mustMatch) {
                throw new REException(RE.getLocalizedMessage("interval.error"), 3, index);
            }
            return startIndex;
        }
        int min = Integer.parseInt(buf.toString());
        if (unit.ch == '}' && syntax.get(11) ^ unit.bk) {
            max = min;
        } else {
            if (index == input.length) {
                if (mustMatch) {
                    throw new REException(RE.getLocalizedMessage("interval.no.end"), 3, index);
                }
                return startIndex;
            }
            if (unit.ch == ',' && !unit.bk) {
                buf = new CPStringBuilder();
                while ((index = RE.getCharUnit(input, index, unit, false)) != input.length && Character.isDigit(unit.ch)) {
                    buf.append(unit.ch);
                }
                if (unit.ch != '}' || !(syntax.get(11) ^ unit.bk)) {
                    if (mustMatch) {
                        throw new REException(RE.getLocalizedMessage("interval.error"), 3, index);
                    }
                    return startIndex;
                }
                max = buf.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(buf.toString());
            } else {
                if (mustMatch) {
                    throw new REException(RE.getLocalizedMessage("interval.error"), 3, index);
                }
                return startIndex;
            }
        }
        minMax.first = min;
        minMax.second = max;
        return index;
    }

    public String toString() {
        CPStringBuilder sb = new CPStringBuilder();
        this.dump(sb);
        return sb.toString();
    }

    void dump(CPStringBuilder os) {
        os.append("(?#startRE subIndex=" + this.subIndex + ")");
        if (this.subIndex == 0) {
            os.append("?:");
        }
        if (this.firstToken != null) {
            this.firstToken.dumpAll(os);
        }
        if (this.subIndex == 0) {
            os.append(")");
        }
        os.append("(?#endRE subIndex=" + this.subIndex + ")");
    }

    public static CharIndexed makeCharIndexed(Object input, int index) {
        if (input instanceof CharIndexed) {
            CharIndexed ci = (CharIndexed)input;
            ci.setAnchor(index);
            return ci;
        }
        if (input instanceof CharSequence) {
            return new CharIndexedCharSequence((CharSequence)input, index);
        }
        if (input instanceof String) {
            return new CharIndexedString((String)input, index);
        }
        if (input instanceof char[]) {
            return new CharIndexedCharArray((char[])input, index);
        }
        if (input instanceof StringBuffer) {
            return new CharIndexedStringBuffer((StringBuffer)input, index);
        }
        if (input instanceof InputStream) {
            return new CharIndexedInputStream((InputStream)input, index);
        }
        return new CharIndexedString(input.toString(), index);
    }

    private static class CharExpression {
        char ch;
        String expr;
        int len;

        private CharExpression() {
        }

        public String toString() {
            return this.expr;
        }
    }

    private static final class CharUnit
    implements Serializable {
        public char ch;
        public boolean bk;

        private CharUnit() {
        }
    }

    private static final class IntPair
    implements Serializable {
        public int first;
        public int second;

        private IntPair() {
        }
    }

    private static class NamedProperty {
        String name;
        boolean negate;
        int len;

        private NamedProperty() {
        }
    }

    private static class ParseCharClassResult {
        RETokenOneOf token;
        int index;
        boolean returnAtAndOperator = false;

        private ParseCharClassResult() {
        }
    }
}

