/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextAreaPeer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;

public class SwingTextAreaPeer
extends SwingComponentPeer
implements TextAreaPeer {
    private SwingTextArea jTextArea = new SwingTextArea();

    public SwingTextAreaPeer(TextArea textArea) {
        SwingScrollPane swingArea = new SwingScrollPane(this.jTextArea);
        this.init(textArea, swingArea);
        JViewport viewport = new JViewport(){

            public Image createImage(int width, int height) {
                return SwingTextAreaPeer.this.awtComponent.createImage(width, height);
            }
        };
        viewport.setView(this.jTextArea);
        swingArea.setViewport(viewport);
        this.setText(textArea.getText());
        int columns = textArea.getColumns();
        int rows = textArea.getRows();
        if (columns == 0 && rows == 0) {
            columns = 25;
            textArea.setColumns(columns);
            rows = 5;
            textArea.setRows(rows);
        }
        this.jTextArea.setColumns(columns);
        this.jTextArea.setRows(rows);
    }

    public Dimension getMinimumSize(int rows, int cols) {
        return this.jTextArea.getMinimumSize();
    }

    public Dimension getPreferredSize(int rows, int cols) {
        return this.jTextArea.getPreferredSize();
    }

    public void insert(String text, int pos) {
        this.jTextArea.insert(text, pos);
    }

    public void insertText(String text, int pos) {
        this.jTextArea.insert(text, pos);
    }

    public Dimension minimumSize() {
        return this.jTextArea.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.jTextArea.getPreferredSize();
    }

    public Dimension minimumSize(int rows, int cols) {
        return this.jTextArea.getMinimumSize();
    }

    public Dimension preferredSize(int rows, int cols) {
        return this.jTextArea.getPreferredSize();
    }

    public void replaceRange(String text, int start, int end) {
        this.jTextArea.replaceRange(text, start, end);
    }

    public void replaceText(String text, int start, int end) {
        this.jTextArea.replaceRange(text, start, end);
    }

    public long filterEvents(long filter) {
        return 0L;
    }

    public int getCaretPosition() {
        return this.jTextArea.getCaretPosition();
    }

    public Rectangle getCharacterBounds(int pos) {
        try {
            return this.jTextArea.modelToView(pos);
        }
        catch (BadLocationException badLocationException) {
            Rectangle r = null;
            return r;
        }
    }

    public int getIndexAtPoint(int x, int y) {
        return this.jTextArea.viewToModel(new Point(x, y));
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public int getSelectionEnd() {
        return this.jTextArea.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.jTextArea.getSelectionStart();
    }

    public String getText() {
        return this.jTextArea.getText();
    }

    public void select(int start, int end) {
        this.jTextArea.select(start, end);
    }

    public void setCaretPosition(int pos) {
        this.jTextArea.setCaretPosition(pos);
    }

    public void setEditable(boolean editable) {
        this.jTextArea.setEditable(editable);
    }

    public void setText(String text) {
        this.jTextArea.setText(text);
    }

    public void reshape(int x, int y, int width, int height) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(x, y, width, height);
            this.swingComponent.getJComponent().validate();
        }
    }

    private class SwingScrollPane
    extends JScrollPane
    implements SwingComponent {
        SwingTextArea textArea;

        SwingScrollPane(SwingTextArea textArea) {
            super(textArea, 22, 32);
            this.textArea = textArea;
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent ev) {
            JViewport viewPort = this.getViewport();
            if (viewPort.contains(ev.getPoint())) {
                ev.setSource(this.textArea);
                this.textArea.dispatchEvent(ev);
            } else {
                ev.setSource(this);
                this.dispatchEvent(ev);
            }
        }

        public boolean isLightweight() {
            return false;
        }

        public void handleMouseMotionEvent(MouseEvent ev) {
            this.textArea.processMouseMotionEvent(ev);
        }

        public void handleKeyEvent(KeyEvent ev) {
            this.textArea.processKeyEvent(ev);
        }

        public void handleFocusEvent(FocusEvent ev) {
            this.textArea.processFocusEvent(ev);
        }

        public Point getLocationOnScreen() {
            return SwingTextAreaPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean retVal = false;
            if (SwingTextAreaPeer.this.awtComponent != null) {
                retVal = SwingTextAreaPeer.this.awtComponent.isShowing();
            }
            return retVal;
        }

        public Image createImage(int w, int h) {
            return SwingTextAreaPeer.this.createImage(w, h);
        }

        public Graphics getGraphics() {
            return SwingTextAreaPeer.this.getGraphics();
        }

        public Container getParent() {
            Container par = null;
            if (SwingTextAreaPeer.this.awtComponent != null) {
                par = SwingTextAreaPeer.this.awtComponent.getParent();
            }
            return par;
        }

        public void requestFocus() {
            SwingTextAreaPeer.this.requestFocus(SwingTextAreaPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean temporary) {
            return SwingTextAreaPeer.this.requestFocus(SwingTextAreaPeer.this.awtComponent, temporary, true, 0L);
        }
    }

    private class SwingTextArea
    extends JTextArea {
        private SwingTextArea() {
        }

        protected final void processComponentKeyEvent(KeyEvent e) {
            super.processComponentKeyEvent(e);
        }

        protected final void processMouseMotionEvent(MouseEvent ev) {
            super.processMouseMotionEvent(ev);
        }

        protected final void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected final void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected final void processHierarchyBoundsEvent(HierarchyEvent e) {
            super.processHierarchyBoundsEvent(e);
        }

        protected final void processHierarchyEvent(HierarchyEvent e) {
            super.processHierarchyEvent(e);
        }

        protected final void processInputMethodEvent(InputMethodEvent e) {
            super.processInputMethodEvent(e);
        }

        protected final void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected final void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }

        protected final void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        public void requestFocus() {
            SwingTextAreaPeer.this.requestFocus(SwingTextAreaPeer.this.awtComponent, false, true, 0L);
        }

        public boolean requestFocus(boolean temporary) {
            return SwingTextAreaPeer.this.requestFocus(SwingTextAreaPeer.this.awtComponent, temporary, true, 0L);
        }
    }
}

