/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ThreadGroupReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeName(bb, os);
                    break;
                }
                case 2: {
                    this.executeParent(bb, os);
                    break;
                }
                case 3: {
                    this.executeChildren(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ThreadGroupReference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private void executeName(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        ThreadGroup group = (ThreadGroup)oid.getObject();
        JdwpString.writeString(os, group.getName());
    }

    private void executeParent(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ObjectId oid = this.idMan.readObjectId(bb);
        ThreadGroup group = (ThreadGroup)oid.getObject();
        ThreadGroup parent = group.getParent();
        if (parent == null) {
            os.writeLong(0L);
        } else {
            ObjectId parentId = this.idMan.getObjectId(parent);
            parentId.write(os);
        }
    }

    private void executeChildren(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ThreadGroup tgroup;
        Thread thread;
        ObjectId oid = this.idMan.readObjectId(bb);
        ThreadGroup group = (ThreadGroup)oid.getObject();
        ThreadGroup jdwpGroup = Thread.currentThread().getThreadGroup();
        int numThreads = group.activeCount();
        Thread[] allThreads = new Thread[numThreads];
        group.enumerate(allThreads, false);
        numThreads = 0;
        int i = 0;
        while (i < allThreads.length) {
            thread = allThreads[i];
            if (thread == null) break;
            if (!thread.getThreadGroup().equals(jdwpGroup)) {
                ++numThreads;
            }
            ++i;
        }
        os.writeInt(numThreads);
        i = 0;
        while (i < allThreads.length) {
            thread = allThreads[i];
            if (thread == null) break;
            if (!thread.getThreadGroup().equals(jdwpGroup)) {
                this.idMan.getObjectId(thread).write(os);
            }
            ++i;
        }
        int numGroups = group.activeCount();
        ThreadGroup[] allGroups = new ThreadGroup[numGroups];
        group.enumerate(allGroups, false);
        numGroups = 0;
        int i2 = 0;
        while (i2 < allGroups.length) {
            tgroup = allGroups[i2];
            if (tgroup == null) break;
            if (!tgroup.equals(jdwpGroup)) {
                ++numGroups;
            }
            ++i2;
        }
        os.writeInt(numGroups);
        i2 = 0;
        while (i2 < allGroups.length) {
            tgroup = allGroups[i2];
            if (tgroup == null) break;
            if (!tgroup.equals(jdwpGroup)) {
                this.idMan.getObjectId(tgroup).write(os);
            }
            ++i2;
        }
    }
}

