/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;

public final class ReportClassicColonyPanel
extends ReportPanel
implements ActionListener {
    private static final int COLONISTS_PER_ROW = 20;
    private static final int UNITS_PER_ROW = 14;
    private static final int GOODS_PER_ROW = 10;
    private static final int BUILDINGS_PER_ROW = 8;
    private static final List<Colony> colonies = new ArrayList<Colony>();

    public ReportClassicColonyPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportColonyAction");
        colonies.addAll(freeColClient.getMySortedColonies());
        this.update();
    }

    private void update() {
        Specification spec = this.getSpecification();
        ImageLibrary lib = this.getImageLibrary();
        this.reportPanel.removeAll();
        this.reportPanel.setLayout(new MigLayout("fill"));
        for (Colony colony : colonies) {
            Object u2;
            JButton button = Utility.getLinkButton(colony.getName(), null, colony.getId());
            button.addActionListener(this);
            this.reportPanel.add((Component)button, "newline, split 2");
            this.reportPanel.add((Component)new JSeparator(0), "growx");
            BuildableType currentType = colony.getCurrentlyBuilding();
            JLabel buildableLabel = null;
            if (currentType != null) {
                buildableLabel = new JLabel(new ImageIcon(lib.getSmallBuildableImage(currentType, colony.getOwner())));
                Utility.localizeToolTip((JComponent)buildableLabel, currentType.getCurrentlyBuildingLabel());
                buildableLabel.setIcon(buildableLabel.getDisabledIcon());
            }
            JPanel colonistsPanel = new JPanel(new GridLayout(0, 20));
            colonistsPanel.setOpaque(false);
            for (Object u2 : colony.getUnitList().stream().sorted(Unit.typeRoleComparator).collect(Collectors.toList())) {
                colonistsPanel.add(new UnitLabel(this.getFreeColClient(), (Unit)u2, true, true));
            }
            JPanel unitsPanel = new JPanel(new GridLayout(0, 14));
            unitsPanel.setOpaque(false);
            u2 = colony.getTile().getUnitList().stream().sorted(Unit.typeRoleComparator).collect(Collectors.toList()).iterator();
            while (u2.hasNext()) {
                Unit u3 = (Unit)u2.next();
                unitsPanel.add(new UnitLabel(this.getFreeColClient(), u3, true, true));
            }
            if (buildableLabel != null && spec.getUnitTypeList().contains(currentType)) {
                unitsPanel.add(buildableLabel);
            }
            this.reportPanel.add((Component)colonistsPanel, "newline, growx");
            this.reportPanel.add((Component)unitsPanel, "newline, growx");
            ArrayList<GoodsType> goodsTypes = new ArrayList<GoodsType>(spec.getGoodsTypeList());
            Collections.sort(goodsTypes, GoodsType.goodsTypeComparator);
            int count = 0;
            for (GoodsType gt : goodsTypes) {
                int newValue = colony.getNetProductionOf(gt);
                int stockValue = colony.getGoodsCount(gt);
                if (newValue == 0 && stockValue <= 0) continue;
                int maxProduction = colony.getWorkLocationsForProducing(gt).stream().mapToInt(wl -> wl.getMaximumProductionOf(gt)).sum();
                ProductionLabel productionLabel = new ProductionLabel(this.getFreeColClient(), new AbstractGoods(gt, newValue), maxProduction, stockValue);
                if (count % 10 == 0) {
                    this.reportPanel.add((Component)productionLabel, "newline, split 10");
                } else {
                    this.reportPanel.add(productionLabel);
                }
                ++count;
            }
            JPanel buildingsPanel = new JPanel(new GridLayout(0, 8));
            buildingsPanel.setOpaque(false);
            List<Building> buildingList = colony.getBuildings();
            Collections.sort(buildingList);
            for (Building building : buildingList) {
                if (building.getType().isAutomaticBuild()) continue;
                JLabel buildingLabel = new JLabel(new ImageIcon(lib.getSmallBuildingImage(building)));
                buildingLabel.setToolTipText(Messages.getName(building));
                buildingsPanel.add(buildingLabel);
            }
            if (buildableLabel != null && spec.getBuildingTypeList().contains(currentType)) {
                buildingsPanel.add(buildableLabel);
            }
            this.reportPanel.add((Component)buildingsPanel, "newline, growx");
        }
    }
}

