/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.JavolutionError;
import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.context.ObjectPool;
import javolution.context.PoolContext;
import javolution.util.FastTable;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public class HeapContext
extends Context {
    private static final Class CLASS = new HeapContext().getClass();
    protected static final XMLFormat<HeapContext> XML = new XMLFormat(CLASS){

        public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
            HeapContext heapContext = (HeapContext)object;
            FastTable fastTable = (FastTable)inputElement.get("pools");
            heapContext.setPools(fastTable);
        }

        public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
            HeapContext heapContext = (HeapContext)object;
            outputElement.add(heapContext._pools, "pools");
        }
    };
    final ObjectPool[] _pools = new ObjectPool[ObjectFactory._Instances.length];
    private final ObjectPool[] _inUsePools = new ObjectPool[ObjectFactory._Instances.length];
    private int _inUsePoolsLength;
    private int _tmpIndex;
    private Runnable NEW_POOL = new Runnable(){

        public void run() {
            HeapContext.this._pools[((HeapContext)HeapContext.this)._tmpIndex] = ObjectFactory._Instances[HeapContext.this._tmpIndex].newHeapPool();
        }
    };

    public FastTable getPools() {
        FastTable<ObjectPool> fastTable = FastTable.newInstance();
        int n = ObjectFactory._Count;
        while (n > 0) {
            ObjectPool objectPool;
            if ((objectPool = this._pools[--n]) == null) continue;
            fastTable.add(objectPool);
        }
        return fastTable;
    }

    public void setPools(FastTable fastTable) {
        for (int i = 0; i < fastTable.size(); ++i) {
            ObjectPool objectPool;
            this._pools[objectPool.getFactory()._index] = objectPool = (ObjectPool)fastTable.get(i);
        }
    }

    public static HeapContext current() {
        for (Context context = Context.current(); context != null; context = context.getOuter()) {
            if (context instanceof PoolContext) {
                return null;
            }
            if (!(context instanceof HeapContext)) continue;
            return (HeapContext)context;
        }
        throw new JavolutionError("No heap context or pool context");
    }

    public static void enter() {
        Context.enter(CLASS);
    }

    public static void exit() {
        Context.exit(CLASS);
    }

    public void clear() {
        super.clear();
        int n = ObjectFactory._Count;
        while (n > 0) {
            ObjectPool objectPool;
            if ((objectPool = this._pools[--n]) == null) continue;
            objectPool.clearAll();
        }
        this._inUsePoolsLength = 0;
    }

    protected void enterAction() {
        Context context = this.getOuter();
        if (context != null) {
            context.setPoolsActive(false);
        }
        this._poolsShortcut = this._pools;
    }

    protected void exitAction() {
        int n = this._inUsePoolsLength;
        while (n > 0) {
            ObjectPool objectPool = this._inUsePools[--n];
            objectPool._user = null;
            objectPool._inUse = false;
        }
        this._inUsePoolsLength = 0;
        Context context = this.getOuter();
        if (context != null) {
            context.setPoolsActive(true);
        }
    }

    void setPoolsActive(boolean bl) {
        Thread thread = bl ? this.getOwner() : null;
        int n = this._inUsePoolsLength;
        while (n > 0) {
            this._inUsePools[--n]._user = thread;
        }
    }

    ObjectPool getPool(int n, boolean bl) {
        ObjectPool objectPool = this._pools[n];
        if (objectPool == null) {
            this._tmpIndex = n;
            MemoryArea.getMemoryArea(this).executeInArea(this.NEW_POOL);
            objectPool = this._pools[n];
        }
        if (!objectPool._inUse) {
            objectPool._inUse = true;
            this._inUsePools[this._inUsePoolsLength++] = objectPool;
        }
        if (bl) {
            objectPool._user = this.getOwner();
        }
        return objectPool;
    }
}

