/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.handles;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PLocator;
import edu.umd.cs.piccolox.util.PNodeLocator;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;

public class PHandle
extends PPath {
    public static float DEFAULT_HANDLE_SIZE = 8.0f;
    public static Shape DEFAULT_HANDLE_SHAPE = new Ellipse2D.Float(0.0f, 0.0f, DEFAULT_HANDLE_SIZE, DEFAULT_HANDLE_SIZE);
    public static Color DEFAULT_COLOR = Color.white;
    private PLocator locator;
    private transient PDragSequenceEventHandler handleDragger;

    public PHandle(PLocator pLocator) {
        super(DEFAULT_HANDLE_SHAPE);
        this.locator = pLocator;
        this.setPaint(DEFAULT_COLOR);
        this.installHandleEventHandlers();
    }

    protected void installHandleEventHandlers() {
        this.handleDragger = new PDragSequenceEventHandler(){

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                PHandle.this.startHandleDrag(pInputEvent.getPositionRelativeTo(PHandle.this), pInputEvent);
            }

            protected void drag(PInputEvent pInputEvent) {
                super.drag(pInputEvent);
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(PHandle.this);
                if (pDimension.getWidth() != 0.0 || pDimension.getHeight() != 0.0) {
                    PHandle.this.dragHandle(pDimension, pInputEvent);
                }
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                PHandle.this.endHandleDrag(pInputEvent.getPositionRelativeTo(PHandle.this), pInputEvent);
            }
        };
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PHandle.this.relocateHandle();
            }
        });
        this.handleDragger.setEventFilter(new PInputEventFilter(16));
        this.handleDragger.getEventFilter().setMarksAcceptedEventsAsHandled(true);
        this.handleDragger.getEventFilter().setAcceptsMouseEntered(false);
        this.handleDragger.getEventFilter().setAcceptsMouseExited(false);
        this.handleDragger.getEventFilter().setAcceptsMouseMoved(false);
        this.addInputEventListener(this.handleDragger);
    }

    public PDragSequenceEventHandler getHandleDraggerHandler() {
        return this.handleDragger;
    }

    public PLocator getLocator() {
        return this.locator;
    }

    public void setLocator(PLocator pLocator) {
        this.locator = pLocator;
        this.invalidatePaint();
        this.relocateHandle();
    }

    public void startHandleDrag(Point2D point2D, PInputEvent pInputEvent) {
    }

    public void dragHandle(PDimension pDimension, PInputEvent pInputEvent) {
    }

    public void endHandleDrag(Point2D point2D, PInputEvent pInputEvent) {
    }

    public void setParent(PNode pNode) {
        super.setParent(pNode);
        this.relocateHandle();
    }

    public void parentBoundsChanged() {
        this.relocateHandle();
    }

    public void relocateHandle() {
        if (this.locator != null) {
            PBounds pBounds = this.getBoundsReference();
            Point2D point2D = this.locator.locatePoint(null);
            if (this.locator instanceof PNodeLocator) {
                PNode pNode = ((PNodeLocator)this.locator).getNode();
                PNode pNode2 = this.getParent();
                pNode.localToGlobal(point2D);
                this.globalToLocal(point2D);
                if (pNode2 != pNode && pNode2 instanceof PCamera) {
                    ((PCamera)pNode2).viewToLocal(point2D);
                }
            }
            double d = point2D.getX();
            double d2 = point2D.getY();
            if (d != pBounds.getCenterX() || d2 != pBounds.getCenterY()) {
                this.centerBoundsOnPoint(d, d2);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.installHandleEventHandlers();
    }
}

