/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.util.StringHelper;

public class DefaultJmsKeyFormatStrategy
implements JmsKeyFormatStrategy {
    private static final String DOT = ".";
    private static final String DOT_REPLACEMENT = "_DOT_";
    private static final String HYPHEN = "-";
    private static final String HYPHEN_REPLACEMENT = "_HYPHEN_";

    @Override
    public String encodeKey(String key) {
        String answer = StringHelper.replaceAll(key, DOT, DOT_REPLACEMENT);
        answer = StringHelper.replaceAll(answer, HYPHEN, HYPHEN_REPLACEMENT);
        return answer;
    }

    @Override
    public String decodeKey(String key) {
        String answer = StringHelper.replaceAll(key, DOT_REPLACEMENT, DOT);
        answer = StringHelper.replaceAll(answer, HYPHEN_REPLACEMENT, HYPHEN);
        return answer;
    }
}

